# Microsoft Azure SDK for Go
[![GoDoc](https://godoc.org/github.com/Azure/azure-sdk-for-go?status.svg)](https://godoc.org/github.com/Azure/azure-sdk-for-go) 
[![Build Status](https://travis-ci.org/Azure/azure-sdk-for-go.svg?branch=master)](https://travis-ci.org/Azure/azure-sdk-for-go) 
[![Go Report Card](https://goreportcard.com/badge/github.com/Azure/azure-sdk-for-go)](https://goreportcard.com/report/github.com/Azure/azure-sdk-for-go)

This is Microsoft Azure's core repository for hosting Go packages which offer a more convenient way of targeting Azure
REST endpoints. Here, you'll find a mix of code generated by [Autorest](https://github.com/Azure/autorest) and hand
maintained packages.

> **NOTE:** This repository is under heavy ongoing development and should be considered a preview. Vendoring your
dependencies is always a good idea, but it is doubly important if you're consuming this library.

# Installation
- If you don't already have it, install [the Go Programming Language](https://golang.org/dl/).
- Go get the SDK:

```
$ go get -u github.com/Azure/azure-sdk-for-go/...
```

> **IMPORTANT:** We highly suggest vendoring Azure SDK for Go as a dependency. For vendoring dependencies, Azure SDK
for Go uses [dep](https://github.com/golang/dep).

# Versioning
## SDK Versions
The entire SDK will
continue to be distributed as a single repository, and be labeled with version tags  that are applicable to the whole
repository. The tags in this repository are based on, but do not conform to [SemVer.org's recommendations](http://semver.org/).
For now, the "-beta" tag is an indicator that we are still in preview and still are planning on releasing some breaking
changes.

While in beta, we will only accept contributions to the `dev` or `master` branches. Once the `beta` tag is removed, we'll
only contribute new features and Azure API surface space to the most recent major version of our SDK. However, pull requests
to older major versions will be evaluated and accepted as appropriate. Any critical bugs will be fixed in old versions as well.
To facilitate pull requests, a branch will be created for each of the major versions accepting support. For example,
should we have tags denoting the versions, `v11.1.0`, `v11.2.0`, and `v12.0.0`, a branch `v11` would be present for submission
of PRs.

## Azure Versions
Azure services _mostly_ do not use SemVer based versions. Rather, they stamp a set of REST endpoints with a date identifier. One will often
see these stamps casually referred to as "API Versions". At the moment, our SDK only supports the most recent stamp for each service. In
order to lock to an API version, one must also lock to an SDK version. However, as discussed in [#517](https://github.com/Azure/azure-sdk-for-go/issues/517),
our objective is to reorganize and publish an independent package for each stamped API version of each service. In that way, we'll be able to support all API Versions
in a single SDK Version.

Knowing which API Versions of services are compatbile with one another, and finding which API Versions are available in which environments
has been a common source of frustration for users. Along with Azure Stack, these problems have led to the development of "Profiles" which are
aggregations of multiple services at particular API Versions. Using profiles with our SDK will be optional, and to opt-in you will need to be
running Go 1.9 or higher.

# Documentation

- Azure SDK for Go Documentation is available at [GoDoc.org](http://godoc.org/github.com/Azure/azure-sdk-for-go/).
- Azure REST APIs used by packages in this repository are documented at [Microsoft Docs, Azure REST](https://docs.microsoft.com/en-us/rest/api/).
- Azure Services are discussed in detail at [Microsoft Docs, Azure Services](https://docs.microsoft.com/en-us/azure/#pivot=services).

# Code samples

- [Getting Started with Azure Blob Service in Go](https://github.com/Azure-Samples/storage-blob-go-getting-started)

# License

This project is published under [Apache 2.0 License](LICENSE).

# Contribute

If you would like to become an active contributor to this project please follow the instructions provided in [Microsoft
Azure Projects Contribution Guidelines](http://azure.github.io/guidelines/).

This project has adopted the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/).
For more information see the [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) or contact
[opencode@microsoft.com](mailto:opencode@microsoft.com) with any additional questions or comments.
