// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opBatchGetBuilds = "BatchGetBuilds"

// BatchGetBuildsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetBuilds operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchGetBuilds for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchGetBuilds method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchGetBuildsRequest method.
//    req, resp := client.BatchGetBuildsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetBuilds
func (c *CodeBuild) BatchGetBuildsRequest(input *BatchGetBuildsInput) (req *request.Request, output *BatchGetBuildsOutput) {
	op := &request.Operation{
		Name:       opBatchGetBuilds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetBuildsInput{}
	}

	output = &BatchGetBuildsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetBuilds API operation for AWS CodeBuild.
//
// Gets information about builds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation BatchGetBuilds for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetBuilds
func (c *CodeBuild) BatchGetBuilds(input *BatchGetBuildsInput) (*BatchGetBuildsOutput, error) {
	req, out := c.BatchGetBuildsRequest(input)
	return out, req.Send()
}

// BatchGetBuildsWithContext is the same as BatchGetBuilds with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetBuilds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) BatchGetBuildsWithContext(ctx aws.Context, input *BatchGetBuildsInput, opts ...request.Option) (*BatchGetBuildsOutput, error) {
	req, out := c.BatchGetBuildsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetProjects = "BatchGetProjects"

// BatchGetProjectsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetProjects operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchGetProjects for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchGetProjects method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchGetProjectsRequest method.
//    req, resp := client.BatchGetProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetProjects
func (c *CodeBuild) BatchGetProjectsRequest(input *BatchGetProjectsInput) (req *request.Request, output *BatchGetProjectsOutput) {
	op := &request.Operation{
		Name:       opBatchGetProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetProjectsInput{}
	}

	output = &BatchGetProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetProjects API operation for AWS CodeBuild.
//
// Gets information about build projects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation BatchGetProjects for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetProjects
func (c *CodeBuild) BatchGetProjects(input *BatchGetProjectsInput) (*BatchGetProjectsOutput, error) {
	req, out := c.BatchGetProjectsRequest(input)
	return out, req.Send()
}

// BatchGetProjectsWithContext is the same as BatchGetProjects with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) BatchGetProjectsWithContext(ctx aws.Context, input *BatchGetProjectsInput, opts ...request.Option) (*BatchGetProjectsOutput, error) {
	req, out := c.BatchGetProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateProject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateProject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateProjectRequest method.
//    req, resp := client.CreateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateProject
func (c *CodeBuild) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for AWS CodeBuild.
//
// Creates a build project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation CreateProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified AWS resource cannot be created, because an AWS resource with
//   the same settings already exists.
//
//   * ErrCodeAccountLimitExceededException "AccountLimitExceededException"
//   An AWS service limit was exceeded for the calling AWS account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateProject
func (c *CodeBuild) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteProject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteProject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteProjectRequest method.
//    req, resp := client.DeleteProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteProject
func (c *CodeBuild) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProject API operation for AWS CodeBuild.
//
// Deletes a build project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation DeleteProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteProject
func (c *CodeBuild) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBuilds = "ListBuilds"

// ListBuildsRequest generates a "aws/request.Request" representing the
// client's request for the ListBuilds operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListBuilds for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListBuilds method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListBuildsRequest method.
//    req, resp := client.ListBuildsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuilds
func (c *CodeBuild) ListBuildsRequest(input *ListBuildsInput) (req *request.Request, output *ListBuildsOutput) {
	op := &request.Operation{
		Name:       opListBuilds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBuildsInput{}
	}

	output = &ListBuildsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuilds API operation for AWS CodeBuild.
//
// Gets a list of build IDs, with each build ID representing a single build.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation ListBuilds for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuilds
func (c *CodeBuild) ListBuilds(input *ListBuildsInput) (*ListBuildsOutput, error) {
	req, out := c.ListBuildsRequest(input)
	return out, req.Send()
}

// ListBuildsWithContext is the same as ListBuilds with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuilds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) ListBuildsWithContext(ctx aws.Context, input *ListBuildsInput, opts ...request.Option) (*ListBuildsOutput, error) {
	req, out := c.ListBuildsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBuildsForProject = "ListBuildsForProject"

// ListBuildsForProjectRequest generates a "aws/request.Request" representing the
// client's request for the ListBuildsForProject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListBuildsForProject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListBuildsForProject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListBuildsForProjectRequest method.
//    req, resp := client.ListBuildsForProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsForProject
func (c *CodeBuild) ListBuildsForProjectRequest(input *ListBuildsForProjectInput) (req *request.Request, output *ListBuildsForProjectOutput) {
	op := &request.Operation{
		Name:       opListBuildsForProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBuildsForProjectInput{}
	}

	output = &ListBuildsForProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuildsForProject API operation for AWS CodeBuild.
//
// Gets a list of build IDs for the specified build project, with each build
// ID representing a single build.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation ListBuildsForProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified AWS resource cannot be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsForProject
func (c *CodeBuild) ListBuildsForProject(input *ListBuildsForProjectInput) (*ListBuildsForProjectOutput, error) {
	req, out := c.ListBuildsForProjectRequest(input)
	return out, req.Send()
}

// ListBuildsForProjectWithContext is the same as ListBuildsForProject with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuildsForProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) ListBuildsForProjectWithContext(ctx aws.Context, input *ListBuildsForProjectInput, opts ...request.Option) (*ListBuildsForProjectOutput, error) {
	req, out := c.ListBuildsForProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCuratedEnvironmentImages = "ListCuratedEnvironmentImages"

// ListCuratedEnvironmentImagesRequest generates a "aws/request.Request" representing the
// client's request for the ListCuratedEnvironmentImages operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListCuratedEnvironmentImages for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListCuratedEnvironmentImages method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListCuratedEnvironmentImagesRequest method.
//    req, resp := client.ListCuratedEnvironmentImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCuratedEnvironmentImages
func (c *CodeBuild) ListCuratedEnvironmentImagesRequest(input *ListCuratedEnvironmentImagesInput) (req *request.Request, output *ListCuratedEnvironmentImagesOutput) {
	op := &request.Operation{
		Name:       opListCuratedEnvironmentImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListCuratedEnvironmentImagesInput{}
	}

	output = &ListCuratedEnvironmentImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCuratedEnvironmentImages API operation for AWS CodeBuild.
//
// Gets information about Docker images that are managed by AWS CodeBuild.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation ListCuratedEnvironmentImages for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCuratedEnvironmentImages
func (c *CodeBuild) ListCuratedEnvironmentImages(input *ListCuratedEnvironmentImagesInput) (*ListCuratedEnvironmentImagesOutput, error) {
	req, out := c.ListCuratedEnvironmentImagesRequest(input)
	return out, req.Send()
}

// ListCuratedEnvironmentImagesWithContext is the same as ListCuratedEnvironmentImages with the addition of
// the ability to pass a context and additional request options.
//
// See ListCuratedEnvironmentImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) ListCuratedEnvironmentImagesWithContext(ctx aws.Context, input *ListCuratedEnvironmentImagesInput, opts ...request.Option) (*ListCuratedEnvironmentImagesOutput, error) {
	req, out := c.ListCuratedEnvironmentImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListProjects for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListProjects method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListProjectsRequest method.
//    req, resp := client.ListProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListProjects
func (c *CodeBuild) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for AWS CodeBuild.
//
// Gets a list of build project names, with each build project name representing
// a single build project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation ListProjects for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListProjects
func (c *CodeBuild) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartBuild = "StartBuild"

// StartBuildRequest generates a "aws/request.Request" representing the
// client's request for the StartBuild operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StartBuild for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StartBuild method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StartBuildRequest method.
//    req, resp := client.StartBuildRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartBuild
func (c *CodeBuild) StartBuildRequest(input *StartBuildInput) (req *request.Request, output *StartBuildOutput) {
	op := &request.Operation{
		Name:       opStartBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartBuildInput{}
	}

	output = &StartBuildOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartBuild API operation for AWS CodeBuild.
//
// Starts running a build.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation StartBuild for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified AWS resource cannot be found.
//
//   * ErrCodeAccountLimitExceededException "AccountLimitExceededException"
//   An AWS service limit was exceeded for the calling AWS account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartBuild
func (c *CodeBuild) StartBuild(input *StartBuildInput) (*StartBuildOutput, error) {
	req, out := c.StartBuildRequest(input)
	return out, req.Send()
}

// StartBuildWithContext is the same as StartBuild with the addition of
// the ability to pass a context and additional request options.
//
// See StartBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) StartBuildWithContext(ctx aws.Context, input *StartBuildInput, opts ...request.Option) (*StartBuildOutput, error) {
	req, out := c.StartBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopBuild = "StopBuild"

// StopBuildRequest generates a "aws/request.Request" representing the
// client's request for the StopBuild operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StopBuild for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StopBuild method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StopBuildRequest method.
//    req, resp := client.StopBuildRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StopBuild
func (c *CodeBuild) StopBuildRequest(input *StopBuildInput) (req *request.Request, output *StopBuildOutput) {
	op := &request.Operation{
		Name:       opStopBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopBuildInput{}
	}

	output = &StopBuildOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopBuild API operation for AWS CodeBuild.
//
// Attempts to stop running a build.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation StopBuild for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified AWS resource cannot be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StopBuild
func (c *CodeBuild) StopBuild(input *StopBuildInput) (*StopBuildOutput, error) {
	req, out := c.StopBuildRequest(input)
	return out, req.Send()
}

// StopBuildWithContext is the same as StopBuild with the addition of
// the ability to pass a context and additional request options.
//
// See StopBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) StopBuildWithContext(ctx aws.Context, input *StopBuildInput, opts ...request.Option) (*StopBuildOutput, error) {
	req, out := c.StopBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateProject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateProject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateProjectRequest method.
//    req, resp := client.UpdateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateProject
func (c *CodeBuild) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProject API operation for AWS CodeBuild.
//
// Changes the settings of a build project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeBuild's
// API operation UpdateProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input value that was provided is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified AWS resource cannot be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateProject
func (c *CodeBuild) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	return out, req.Send()
}

// UpdateProjectWithContext is the same as UpdateProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeBuild) UpdateProjectWithContext(ctx aws.Context, input *UpdateProjectInput, opts ...request.Option) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetBuildsInput
type BatchGetBuildsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the builds.
	//
	// Ids is a required field
	Ids []*string `locationName:"ids" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetBuildsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetBuildsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetBuildsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetBuildsInput"}
	if s.Ids == nil {
		invalidParams.Add(request.NewErrParamRequired("Ids"))
	}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIds sets the Ids field's value.
func (s *BatchGetBuildsInput) SetIds(v []*string) *BatchGetBuildsInput {
	s.Ids = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetBuildsOutput
type BatchGetBuildsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the requested builds.
	Builds []*Build `locationName:"builds" type:"list"`

	// The IDs of builds for which information could not be found.
	BuildsNotFound []*string `locationName:"buildsNotFound" min:"1" type:"list"`
}

// String returns the string representation
func (s BatchGetBuildsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetBuildsOutput) GoString() string {
	return s.String()
}

// SetBuilds sets the Builds field's value.
func (s *BatchGetBuildsOutput) SetBuilds(v []*Build) *BatchGetBuildsOutput {
	s.Builds = v
	return s
}

// SetBuildsNotFound sets the BuildsNotFound field's value.
func (s *BatchGetBuildsOutput) SetBuildsNotFound(v []*string) *BatchGetBuildsOutput {
	s.BuildsNotFound = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetProjectsInput
type BatchGetProjectsInput struct {
	_ struct{} `type:"structure"`

	// The names of the build projects.
	//
	// Names is a required field
	Names []*string `locationName:"names" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetProjectsInput"}
	if s.Names == nil {
		invalidParams.Add(request.NewErrParamRequired("Names"))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *BatchGetProjectsInput) SetNames(v []*string) *BatchGetProjectsInput {
	s.Names = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetProjectsOutput
type BatchGetProjectsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the requested build projects.
	Projects []*Project `locationName:"projects" type:"list"`

	// The names of build projects for which information could not be found.
	ProjectsNotFound []*string `locationName:"projectsNotFound" min:"1" type:"list"`
}

// String returns the string representation
func (s BatchGetProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetProjectsOutput) GoString() string {
	return s.String()
}

// SetProjects sets the Projects field's value.
func (s *BatchGetProjectsOutput) SetProjects(v []*Project) *BatchGetProjectsOutput {
	s.Projects = v
	return s
}

// SetProjectsNotFound sets the ProjectsNotFound field's value.
func (s *BatchGetProjectsOutput) SetProjectsNotFound(v []*string) *BatchGetProjectsOutput {
	s.ProjectsNotFound = v
	return s
}

// Information about a build.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/Build
type Build struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the build.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Information about the output artifacts for the build.
	Artifacts *BuildArtifacts `locationName:"artifacts" type:"structure"`

	// Whether the build has finished. True if completed; otherwise, false.
	BuildComplete *bool `locationName:"buildComplete" type:"boolean"`

	// The current status of the build. Valid values include:
	//
	//    * FAILED: The build failed.
	//
	//    * FAULT: The build faulted.
	//
	//    * IN_PROGRESS: The build is still in progress.
	//
	//    * STOPPED: The build stopped.
	//
	//    * SUCCEEDED: The build succeeded.
	//
	//    * TIMED_OUT: The build timed out.
	BuildStatus *string `locationName:"buildStatus" type:"string" enum:"StatusType"`

	// The current build phase.
	CurrentPhase *string `locationName:"currentPhase" type:"string"`

	// When the build process ended, expressed in Unix time format.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"unix"`

	// Information about the build environment for this build.
	Environment *ProjectEnvironment `locationName:"environment" type:"structure"`

	// The unique ID for the build.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The entity that started the build. Valid values include:
	//
	//    * If AWS CodePipeline started the build, the pipeline's name (for example,
	//    codepipeline/my-demo-pipeline).
	//
	//    * If an AWS Identity and Access Management (IAM) user started the build,
	//    the user's name (for example MyUserName).
	//
	//    * If the Jenkins plugin for AWS CodeBuild started the build, the string
	//    CodeBuild-Jenkins-Plugin.
	Initiator *string `locationName:"initiator" type:"string"`

	// Information about the build's logs in Amazon CloudWatch Logs.
	Logs *LogsLocation `locationName:"logs" type:"structure"`

	// Information about all previous build phases that are completed and information
	// about any current build phase that is not yet complete.
	Phases []*BuildPhase `locationName:"phases" type:"list"`

	// The name of the build project.
	ProjectName *string `locationName:"projectName" min:"1" type:"string"`

	// Information about the source code to be built.
	Source *ProjectSource `locationName:"source" type:"structure"`

	// Any version identifier for the version of the source code to be built.
	SourceVersion *string `locationName:"sourceVersion" min:"1" type:"string"`

	// When the build process started, expressed in Unix time format.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`

	// How long, in minutes, for AWS CodeBuild to wait before timing out this build
	// if it does not get marked as completed.
	TimeoutInMinutes *int64 `locationName:"timeoutInMinutes" type:"integer"`
}

// String returns the string representation
func (s Build) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Build) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Build) SetArn(v string) *Build {
	s.Arn = &v
	return s
}

// SetArtifacts sets the Artifacts field's value.
func (s *Build) SetArtifacts(v *BuildArtifacts) *Build {
	s.Artifacts = v
	return s
}

// SetBuildComplete sets the BuildComplete field's value.
func (s *Build) SetBuildComplete(v bool) *Build {
	s.BuildComplete = &v
	return s
}

// SetBuildStatus sets the BuildStatus field's value.
func (s *Build) SetBuildStatus(v string) *Build {
	s.BuildStatus = &v
	return s
}

// SetCurrentPhase sets the CurrentPhase field's value.
func (s *Build) SetCurrentPhase(v string) *Build {
	s.CurrentPhase = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Build) SetEndTime(v time.Time) *Build {
	s.EndTime = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *Build) SetEnvironment(v *ProjectEnvironment) *Build {
	s.Environment = v
	return s
}

// SetId sets the Id field's value.
func (s *Build) SetId(v string) *Build {
	s.Id = &v
	return s
}

// SetInitiator sets the Initiator field's value.
func (s *Build) SetInitiator(v string) *Build {
	s.Initiator = &v
	return s
}

// SetLogs sets the Logs field's value.
func (s *Build) SetLogs(v *LogsLocation) *Build {
	s.Logs = v
	return s
}

// SetPhases sets the Phases field's value.
func (s *Build) SetPhases(v []*BuildPhase) *Build {
	s.Phases = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *Build) SetProjectName(v string) *Build {
	s.ProjectName = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Build) SetSource(v *ProjectSource) *Build {
	s.Source = v
	return s
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *Build) SetSourceVersion(v string) *Build {
	s.SourceVersion = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Build) SetStartTime(v time.Time) *Build {
	s.StartTime = &v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *Build) SetTimeoutInMinutes(v int64) *Build {
	s.TimeoutInMinutes = &v
	return s
}

// Information about build output artifacts.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BuildArtifacts
type BuildArtifacts struct {
	_ struct{} `type:"structure"`

	// Information about the location of the build artifacts.
	Location *string `locationName:"location" type:"string"`

	// The MD5 hash of the build artifact.
	//
	// You can use this hash along with a checksum tool to confirm both file integrity
	// and authenticity.
	//
	// This value is available only if the build project's packaging value is set
	// to ZIP.
	Md5sum *string `locationName:"md5sum" type:"string"`

	// The SHA-256 hash of the build artifact.
	//
	// You can use this hash along with a checksum tool to confirm both file integrity
	// and authenticity.
	//
	// This value is available only if the build project's packaging value is set
	// to ZIP.
	Sha256sum *string `locationName:"sha256sum" type:"string"`
}

// String returns the string representation
func (s BuildArtifacts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BuildArtifacts) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *BuildArtifacts) SetLocation(v string) *BuildArtifacts {
	s.Location = &v
	return s
}

// SetMd5sum sets the Md5sum field's value.
func (s *BuildArtifacts) SetMd5sum(v string) *BuildArtifacts {
	s.Md5sum = &v
	return s
}

// SetSha256sum sets the Sha256sum field's value.
func (s *BuildArtifacts) SetSha256sum(v string) *BuildArtifacts {
	s.Sha256sum = &v
	return s
}

// Information about a stage for a build.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BuildPhase
type BuildPhase struct {
	_ struct{} `type:"structure"`

	// Additional information about a build phase, especially to help troubleshoot
	// a failed build.
	Contexts []*PhaseContext `locationName:"contexts" type:"list"`

	// How long, in seconds, between the starting and ending times of the build's
	// phase.
	DurationInSeconds *int64 `locationName:"durationInSeconds" type:"long"`

	// When the build phase ended, expressed in Unix time format.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"unix"`

	// The current status of the build phase. Valid values include:
	//
	//    * FAILED: The build phase failed.
	//
	//    * FAULT: The build phase faulted.
	//
	//    * IN_PROGRESS: The build phase is still in progress.
	//
	//    * STOPPED: The build phase stopped.
	//
	//    * SUCCEEDED: The build phase succeeded.
	//
	//    * TIMED_OUT: The build phase timed out.
	PhaseStatus *string `locationName:"phaseStatus" type:"string" enum:"StatusType"`

	// The name of the build phase. Valid values include:
	//
	//    * BUILD: Core build activities typically occur in this build phase.
	//
	//    * COMPLETED: The build has been completed.
	//
	//    * DOWNLOAD_SOURCE: Source code is being downloaded in this build phase.
	//
	//    * FINALIZING: The build process is completing in this build phase.
	//
	//    * INSTALL: Installation activities typically occur in this build phase.
	//
	//    * POST_BUILD: Post-build activities typically occur in this build phase.
	//
	//    * PRE_BUILD: Pre-build activities typically occur in this build phase.
	//
	//    * PROVISIONING: The build environment is being set up.
	//
	//    * SUBMITTED: The build has been submitted.
	//
	//    * UPLOAD_ARTIFACTS: Build output artifacts are being uploaded to the output
	//    location.
	PhaseType *string `locationName:"phaseType" type:"string" enum:"BuildPhaseType"`

	// When the build phase started, expressed in Unix time format.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s BuildPhase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BuildPhase) GoString() string {
	return s.String()
}

// SetContexts sets the Contexts field's value.
func (s *BuildPhase) SetContexts(v []*PhaseContext) *BuildPhase {
	s.Contexts = v
	return s
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *BuildPhase) SetDurationInSeconds(v int64) *BuildPhase {
	s.DurationInSeconds = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *BuildPhase) SetEndTime(v time.Time) *BuildPhase {
	s.EndTime = &v
	return s
}

// SetPhaseStatus sets the PhaseStatus field's value.
func (s *BuildPhase) SetPhaseStatus(v string) *BuildPhase {
	s.PhaseStatus = &v
	return s
}

// SetPhaseType sets the PhaseType field's value.
func (s *BuildPhase) SetPhaseType(v string) *BuildPhase {
	s.PhaseType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *BuildPhase) SetStartTime(v time.Time) *BuildPhase {
	s.StartTime = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateProjectInput
type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// Information about the build output artifacts for the build project.
	//
	// Artifacts is a required field
	Artifacts *ProjectArtifacts `locationName:"artifacts" type:"structure" required:"true"`

	// A description that makes the build project easy to identify.
	Description *string `locationName:"description" type:"string"`

	// The AWS Key Management Service (AWS KMS) customer master key (CMK) to be
	// used for encrypting the build output artifacts.
	//
	// You can specify either the CMK's Amazon Resource Name (ARN) or, if available,
	// the CMK's alias (using the format alias/alias-name).
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// Information about the build environment for the build project.
	//
	// Environment is a required field
	Environment *ProjectEnvironment `locationName:"environment" type:"structure" required:"true"`

	// The name of the build project.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"2" type:"string" required:"true"`

	// The ARN of the AWS Identity and Access Management (IAM) role that enables
	// AWS CodeBuild to interact with dependent AWS services on behalf of the AWS
	// account.
	ServiceRole *string `locationName:"serviceRole" min:"1" type:"string"`

	// Information about the build input source code for the build project.
	//
	// Source is a required field
	Source *ProjectSource `locationName:"source" type:"structure" required:"true"`

	// A set of tags for this build project.
	//
	// These tags are available for use by AWS services that support AWS CodeBuild
	// build project tags.
	Tags []*Tag `locationName:"tags" type:"list"`

	// How long, in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait
	// until timing out any build that has not been marked as completed. The default
	// is 60 minutes.
	TimeoutInMinutes *int64 `locationName:"timeoutInMinutes" min:"5" type:"integer"`
}

// String returns the string representation
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.Artifacts == nil {
		invalidParams.Add(request.NewErrParamRequired("Artifacts"))
	}
	if s.EncryptionKey != nil && len(*s.EncryptionKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKey", 1))
	}
	if s.Environment == nil {
		invalidParams.Add(request.NewErrParamRequired("Environment"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 2))
	}
	if s.ServiceRole != nil && len(*s.ServiceRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceRole", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.TimeoutInMinutes != nil && *s.TimeoutInMinutes < 5 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInMinutes", 5))
	}
	if s.Artifacts != nil {
		if err := s.Artifacts.Validate(); err != nil {
			invalidParams.AddNested("Artifacts", err.(request.ErrInvalidParams))
		}
	}
	if s.Environment != nil {
		if err := s.Environment.Validate(); err != nil {
			invalidParams.AddNested("Environment", err.(request.ErrInvalidParams))
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifacts sets the Artifacts field's value.
func (s *CreateProjectInput) SetArtifacts(v *ProjectArtifacts) *CreateProjectInput {
	s.Artifacts = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateProjectInput) SetDescription(v string) *CreateProjectInput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *CreateProjectInput) SetEncryptionKey(v string) *CreateProjectInput {
	s.EncryptionKey = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *CreateProjectInput) SetEnvironment(v *ProjectEnvironment) *CreateProjectInput {
	s.Environment = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProjectInput) SetName(v string) *CreateProjectInput {
	s.Name = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *CreateProjectInput) SetServiceRole(v string) *CreateProjectInput {
	s.ServiceRole = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateProjectInput) SetSource(v *ProjectSource) *CreateProjectInput {
	s.Source = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProjectInput) SetTags(v []*Tag) *CreateProjectInput {
	s.Tags = v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *CreateProjectInput) SetTimeoutInMinutes(v int64) *CreateProjectInput {
	s.TimeoutInMinutes = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateProjectOutput
type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// Information about the build project that was created.
	Project *Project `locationName:"project" type:"structure"`
}

// String returns the string representation
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *CreateProjectOutput) SetProject(v *Project) *CreateProjectOutput {
	s.Project = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteProjectInput
type DeleteProjectInput struct {
	_ struct{} `type:"structure"`

	// The name of the build project.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteProjectInput) SetName(v string) *DeleteProjectInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteProjectOutput
type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

// Information about a Docker image that is managed by AWS CodeBuild.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/EnvironmentImage
type EnvironmentImage struct {
	_ struct{} `type:"structure"`

	// The description of the Docker image.
	Description *string `locationName:"description" type:"string"`

	// The name of the Docker image.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s EnvironmentImage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentImage) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *EnvironmentImage) SetDescription(v string) *EnvironmentImage {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnvironmentImage) SetName(v string) *EnvironmentImage {
	s.Name = &v
	return s
}

// A set of Docker images that are related by programming language and are managed
// by AWS CodeBuild.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/EnvironmentLanguage
type EnvironmentLanguage struct {
	_ struct{} `type:"structure"`

	// The list of Docker images that are related by the specified programming language.
	Images []*EnvironmentImage `locationName:"images" type:"list"`

	// The programming language for the Docker images.
	Language *string `locationName:"language" type:"string" enum:"LanguageType"`
}

// String returns the string representation
func (s EnvironmentLanguage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentLanguage) GoString() string {
	return s.String()
}

// SetImages sets the Images field's value.
func (s *EnvironmentLanguage) SetImages(v []*EnvironmentImage) *EnvironmentLanguage {
	s.Images = v
	return s
}

// SetLanguage sets the Language field's value.
func (s *EnvironmentLanguage) SetLanguage(v string) *EnvironmentLanguage {
	s.Language = &v
	return s
}

// A set of Docker images that are related by platform and are managed by AWS
// CodeBuild.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/EnvironmentPlatform
type EnvironmentPlatform struct {
	_ struct{} `type:"structure"`

	// The list of programming languages that are available for the specified platform.
	Languages []*EnvironmentLanguage `locationName:"languages" type:"list"`

	// The platform's name.
	Platform *string `locationName:"platform" type:"string" enum:"PlatformType"`
}

// String returns the string representation
func (s EnvironmentPlatform) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentPlatform) GoString() string {
	return s.String()
}

// SetLanguages sets the Languages field's value.
func (s *EnvironmentPlatform) SetLanguages(v []*EnvironmentLanguage) *EnvironmentPlatform {
	s.Languages = v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EnvironmentPlatform) SetPlatform(v string) *EnvironmentPlatform {
	s.Platform = &v
	return s
}

// Information about an environment variable for a build project or a build.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/EnvironmentVariable
type EnvironmentVariable struct {
	_ struct{} `type:"structure"`

	// The name or key of the environment variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The value of the environment variable.
	//
	// We strongly discourage using environment variables to store sensitive values,
	// especially AWS secret key IDs and secret access keys. Environment variables
	// can be displayed in plain text using tools such as the AWS CodeBuild console
	// and the AWS Command Line Interface (AWS CLI).
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s EnvironmentVariable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentVariable) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnvironmentVariable) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnvironmentVariable"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *EnvironmentVariable) SetName(v string) *EnvironmentVariable {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EnvironmentVariable) SetValue(v string) *EnvironmentVariable {
	s.Value = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsForProjectInput
type ListBuildsForProjectInput struct {
	_ struct{} `type:"structure"`

	// During a previous call, if there are more than 100 items in the list, only
	// the first 100 items are returned, along with a unique string called a next
	// token. To get the next batch of items in the list, call this operation again,
	// adding the next token to the call. To get all of the items in the list, keep
	// calling this operation with each subsequent next token that is returned,
	// until no more next tokens are returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the build project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// The order to list build IDs. Valid values include:
	//
	//    * ASCENDING: List the build IDs in ascending order by build ID.
	//
	//    * DESCENDING: List the build IDs in descending order by build ID.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrderType"`
}

// String returns the string representation
func (s ListBuildsForProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsForProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBuildsForProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBuildsForProjectInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsForProjectInput) SetNextToken(v string) *ListBuildsForProjectInput {
	s.NextToken = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ListBuildsForProjectInput) SetProjectName(v string) *ListBuildsForProjectInput {
	s.ProjectName = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListBuildsForProjectInput) SetSortOrder(v string) *ListBuildsForProjectInput {
	s.SortOrder = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsForProjectOutput
type ListBuildsForProjectOutput struct {
	_ struct{} `type:"structure"`

	// A list of build IDs for the specified build project, with each build ID representing
	// a single build.
	Ids []*string `locationName:"ids" min:"1" type:"list"`

	// If there are more than 100 items in the list, only the first 100 items are
	// returned, along with a unique string called a next token. To get the next
	// batch of items in the list, call this operation again, adding the next token
	// to the call.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBuildsForProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsForProjectOutput) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *ListBuildsForProjectOutput) SetIds(v []*string) *ListBuildsForProjectOutput {
	s.Ids = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsForProjectOutput) SetNextToken(v string) *ListBuildsForProjectOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsInput
type ListBuildsInput struct {
	_ struct{} `type:"structure"`

	// During a previous call, if there are more than 100 items in the list, only
	// the first 100 items are returned, along with a unique string called a next
	// token. To get the next batch of items in the list, call this operation again,
	// adding the next token to the call. To get all of the items in the list, keep
	// calling this operation with each subsequent next token that is returned,
	// until no more next tokens are returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The order to list build IDs. Valid values include:
	//
	//    * ASCENDING: List the build IDs in ascending order by build ID.
	//
	//    * DESCENDING: List the build IDs in descending order by build ID.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrderType"`
}

// String returns the string representation
func (s ListBuildsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsInput) SetNextToken(v string) *ListBuildsInput {
	s.NextToken = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListBuildsInput) SetSortOrder(v string) *ListBuildsInput {
	s.SortOrder = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsOutput
type ListBuildsOutput struct {
	_ struct{} `type:"structure"`

	// A list of build IDs, with each build ID representing a single build.
	Ids []*string `locationName:"ids" min:"1" type:"list"`

	// If there are more than 100 items in the list, only the first 100 items are
	// returned, along with a unique string called a next token. To get the next
	// batch of items in the list, call this operation again, adding the next token
	// to the call.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBuildsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsOutput) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *ListBuildsOutput) SetIds(v []*string) *ListBuildsOutput {
	s.Ids = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsOutput) SetNextToken(v string) *ListBuildsOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCuratedEnvironmentImagesInput
type ListCuratedEnvironmentImagesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListCuratedEnvironmentImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCuratedEnvironmentImagesInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCuratedEnvironmentImagesOutput
type ListCuratedEnvironmentImagesOutput struct {
	_ struct{} `type:"structure"`

	// Information about supported platforms for Docker images that are managed
	// by AWS CodeBuild.
	Platforms []*EnvironmentPlatform `locationName:"platforms" type:"list"`
}

// String returns the string representation
func (s ListCuratedEnvironmentImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCuratedEnvironmentImagesOutput) GoString() string {
	return s.String()
}

// SetPlatforms sets the Platforms field's value.
func (s *ListCuratedEnvironmentImagesOutput) SetPlatforms(v []*EnvironmentPlatform) *ListCuratedEnvironmentImagesOutput {
	s.Platforms = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListProjectsInput
type ListProjectsInput struct {
	_ struct{} `type:"structure"`

	// During a previous call, if there are more than 100 items in the list, only
	// the first 100 items are returned, along with a unique string called a next
	// token. To get the next batch of items in the list, call this operation again,
	// adding the next token to the call. To get all of the items in the list, keep
	// calling this operation with each subsequent next token that is returned,
	// until no more next tokens are returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The criterion to be used to list build project names. Valid values include:
	//
	//    * CREATED_TIME: List the build project names based on when each build
	//    project was created.
	//
	//    * LAST_MODIFIED_TIME: List the build project names based on when information
	//    about each build project was last changed.
	//
	//    * NAME: List the build project names based on each build project's name.
	//
	// Use sortOrder to specify in what order to list the build project names based
	// on the preceding criteria.
	SortBy *string `locationName:"sortBy" type:"string" enum:"ProjectSortByType"`

	// The order in which to list build projects. Valid values include:
	//
	//    * ASCENDING: List the build project names in ascending order.
	//
	//    * DESCENDING: List the build project names in descending order.
	//
	// Use sortBy to specify the criterion to be used to list build project names.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrderType"`
}

// String returns the string representation
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListProjectsInput) SetSortBy(v string) *ListProjectsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListProjectsInput) SetSortOrder(v string) *ListProjectsInput {
	s.SortOrder = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListProjectsOutput
type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more than 100 items in the list, only the first 100 items are
	// returned, along with a unique string called a next token. To get the next
	// batch of items in the list, call this operation again, adding the next token
	// to the call.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of build project names, with each build project name representing
	// a single build project.
	Projects []*string `locationName:"projects" min:"1" type:"list"`
}

// String returns the string representation
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjects sets the Projects field's value.
func (s *ListProjectsOutput) SetProjects(v []*string) *ListProjectsOutput {
	s.Projects = v
	return s
}

// Information about build logs in Amazon CloudWatch Logs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/LogsLocation
type LogsLocation struct {
	_ struct{} `type:"structure"`

	// The URL to an individual build log in Amazon CloudWatch Logs.
	DeepLink *string `locationName:"deepLink" type:"string"`

	// The name of the Amazon CloudWatch Logs group for the build logs.
	GroupName *string `locationName:"groupName" type:"string"`

	// The name of the Amazon CloudWatch Logs stream for the build logs.
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation
func (s LogsLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogsLocation) GoString() string {
	return s.String()
}

// SetDeepLink sets the DeepLink field's value.
func (s *LogsLocation) SetDeepLink(v string) *LogsLocation {
	s.DeepLink = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *LogsLocation) SetGroupName(v string) *LogsLocation {
	s.GroupName = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *LogsLocation) SetStreamName(v string) *LogsLocation {
	s.StreamName = &v
	return s
}

// Additional information about a build phase that has an error. You can use
// this information to help troubleshoot a failed build.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/PhaseContext
type PhaseContext struct {
	_ struct{} `type:"structure"`

	// An explanation of the build phase's context. This explanation might include
	// a command ID and an exit code.
	Message *string `locationName:"message" type:"string"`

	// The status code for the context of the build phase.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation
func (s PhaseContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhaseContext) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *PhaseContext) SetMessage(v string) *PhaseContext {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *PhaseContext) SetStatusCode(v string) *PhaseContext {
	s.StatusCode = &v
	return s
}

// Information about a build project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/Project
type Project struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the build project.
	Arn *string `locationName:"arn" type:"string"`

	// Information about the build output artifacts for the build project.
	Artifacts *ProjectArtifacts `locationName:"artifacts" type:"structure"`

	// When the build project was created, expressed in Unix time format.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// A description that makes the build project easy to identify.
	Description *string `locationName:"description" type:"string"`

	// The AWS Key Management Service (AWS KMS) customer master key (CMK) to be
	// used for encrypting the build output artifacts.
	//
	// This is expressed either as the CMK's Amazon Resource Name (ARN) or, if specified,
	// the CMK's alias (using the format alias/alias-name).
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// Information about the build environment for this build project.
	Environment *ProjectEnvironment `locationName:"environment" type:"structure"`

	// When the build project's settings were last modified, expressed in Unix time
	// format.
	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"unix"`

	// The name of the build project.
	Name *string `locationName:"name" min:"2" type:"string"`

	// The ARN of the AWS Identity and Access Management (IAM) role that enables
	// AWS CodeBuild to interact with dependent AWS services on behalf of the AWS
	// account.
	ServiceRole *string `locationName:"serviceRole" min:"1" type:"string"`

	// Information about the build input source code for this build project.
	Source *ProjectSource `locationName:"source" type:"structure"`

	// The tags for this build project.
	//
	// These tags are available for use by AWS services that support AWS CodeBuild
	// build project tags.
	Tags []*Tag `locationName:"tags" type:"list"`

	// How long, in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait
	// before timing out any related build that did not get marked as completed.
	// The default is 60 minutes.
	TimeoutInMinutes *int64 `locationName:"timeoutInMinutes" min:"5" type:"integer"`
}

// String returns the string representation
func (s Project) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Project) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Project) SetArn(v string) *Project {
	s.Arn = &v
	return s
}

// SetArtifacts sets the Artifacts field's value.
func (s *Project) SetArtifacts(v *ProjectArtifacts) *Project {
	s.Artifacts = v
	return s
}

// SetCreated sets the Created field's value.
func (s *Project) SetCreated(v time.Time) *Project {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Project) SetDescription(v string) *Project {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *Project) SetEncryptionKey(v string) *Project {
	s.EncryptionKey = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *Project) SetEnvironment(v *ProjectEnvironment) *Project {
	s.Environment = v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *Project) SetLastModified(v time.Time) *Project {
	s.LastModified = &v
	return s
}

// SetName sets the Name field's value.
func (s *Project) SetName(v string) *Project {
	s.Name = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *Project) SetServiceRole(v string) *Project {
	s.ServiceRole = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Project) SetSource(v *ProjectSource) *Project {
	s.Source = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Project) SetTags(v []*Tag) *Project {
	s.Tags = v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *Project) SetTimeoutInMinutes(v int64) *Project {
	s.TimeoutInMinutes = &v
	return s
}

// Information about the build output artifacts for the build project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ProjectArtifacts
type ProjectArtifacts struct {
	_ struct{} `type:"structure"`

	// Information about the build output artifact location, as follows:
	//
	//    * If type is set to CODEPIPELINE, then AWS CodePipeline will ignore this
	//    value if specified. This is because AWS CodePipeline manages its build
	//    output locations instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, then this value will be ignored if specified,
	//    because no build output will be produced.
	//
	//    * If type is set to S3, this is the name of the output bucket.
	Location *string `locationName:"location" type:"string"`

	// Along with path and namespaceType, the pattern that AWS CodeBuild will use
	// to name and store the output artifact, as follows:
	//
	//    * If type is set to CODEPIPELINE, then AWS CodePipeline will ignore this
	//    value if specified. This is because AWS CodePipeline manages its build
	//    output names instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, then this value will be ignored if specified,
	//    because no build output will be produced.
	//
	//    * If type is set to S3, this is the name of the output artifact object.
	//
	// For example, if path is set to MyArtifacts, namespaceType is set to BUILD_ID,
	// and name is set to MyArtifact.zip, then the output artifact would be stored
	// in MyArtifacts/build-ID/MyArtifact.zip.
	Name *string `locationName:"name" type:"string"`

	// Along with path and name, the pattern that AWS CodeBuild will use to determine
	// the name and location to store the output artifact, as follows:
	//
	//    * If type is set to CODEPIPELINE, then AWS CodePipeline will ignore this
	//    value if specified. This is because AWS CodePipeline manages its build
	//    output names instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, then this value will be ignored if specified,
	//    because no build output will be produced.
	//
	//    * If type is set to S3, then valid values include:
	//
	// BUILD_ID: Include the build ID in the location of the build output artifact.
	//
	// NONE: Do not include the build ID. This is the default if namespaceType is
	//    not specified.
	//
	// For example, if path is set to MyArtifacts, namespaceType is set to BUILD_ID,
	// and name is set to MyArtifact.zip, then the output artifact would be stored
	// in MyArtifacts/build-ID/MyArtifact.zip.
	NamespaceType *string `locationName:"namespaceType" type:"string" enum:"ArtifactNamespace"`

	// The type of build output artifact to create, as follows:
	//
	//    * If type is set to CODEPIPELINE, then AWS CodePipeline will ignore this
	//    value if specified. This is because AWS CodePipeline manages its build
	//    output artifacts instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, then this value will be ignored if specified,
	//    because no build output will be produced.
	//
	//    * If type is set to S3, valid values include:
	//
	// NONE: AWS CodeBuild will create in the output bucket a folder containing
	//    the build output. This is the default if packaging is not specified.
	//
	// ZIP: AWS CodeBuild will create in the output bucket a ZIP file containing
	//    the build output.
	Packaging *string `locationName:"packaging" type:"string" enum:"ArtifactPackaging"`

	// Along with namespaceType and name, the pattern that AWS CodeBuild will use
	// to name and store the output artifact, as follows:
	//
	//    * If type is set to CODEPIPELINE, then AWS CodePipeline will ignore this
	//    value if specified. This is because AWS CodePipeline manages its build
	//    output names instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, then this value will be ignored if specified,
	//    because no build output will be produced.
	//
	//    * If type is set to S3, this is the path to the output artifact. If path
	//    is not specified, then path will not be used.
	//
	// For example, if path is set to MyArtifacts, namespaceType is set to NONE,
	// and name is set to MyArtifact.zip, then the output artifact would be stored
	// in the output bucket at MyArtifacts/MyArtifact.zip.
	Path *string `locationName:"path" type:"string"`

	// The type of build output artifact. Valid values include:
	//
	//    * CODEPIPELINE: The build project will have build output generated through
	//    AWS CodePipeline.
	//
	//    * NO_ARTIFACTS: The build project will not produce any build output.
	//
	//    * S3: The build project will store build output in Amazon Simple Storage
	//    Service (Amazon S3).
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ArtifactsType"`
}

// String returns the string representation
func (s ProjectArtifacts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectArtifacts) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectArtifacts) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProjectArtifacts"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocation sets the Location field's value.
func (s *ProjectArtifacts) SetLocation(v string) *ProjectArtifacts {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProjectArtifacts) SetName(v string) *ProjectArtifacts {
	s.Name = &v
	return s
}

// SetNamespaceType sets the NamespaceType field's value.
func (s *ProjectArtifacts) SetNamespaceType(v string) *ProjectArtifacts {
	s.NamespaceType = &v
	return s
}

// SetPackaging sets the Packaging field's value.
func (s *ProjectArtifacts) SetPackaging(v string) *ProjectArtifacts {
	s.Packaging = &v
	return s
}

// SetPath sets the Path field's value.
func (s *ProjectArtifacts) SetPath(v string) *ProjectArtifacts {
	s.Path = &v
	return s
}

// SetType sets the Type field's value.
func (s *ProjectArtifacts) SetType(v string) *ProjectArtifacts {
	s.Type = &v
	return s
}

// Information about the build environment of the build project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ProjectEnvironment
type ProjectEnvironment struct {
	_ struct{} `type:"structure"`

	// Information about the compute resources the build project will use. Available
	// values include:
	//
	//    * BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds.
	//
	//    * BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds.
	//
	//    * BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds.
	//
	// ComputeType is a required field
	ComputeType *string `locationName:"computeType" type:"string" required:"true" enum:"ComputeType"`

	// A set of environment variables to make available to builds for this build
	// project.
	EnvironmentVariables []*EnvironmentVariable `locationName:"environmentVariables" type:"list"`

	// The ID of the Docker image to use for this build project.
	//
	// Image is a required field
	Image *string `locationName:"image" min:"1" type:"string" required:"true"`

	// If set to true, enables running the Docker daemon inside a Docker container;
	// otherwise, false or not specified (the default). This value must be set to
	// true only if this build project will be used to build Docker images, and
	// the specified build environment image is not one provided by AWS CodeBuild
	// with Docker support. Otherwise, all associated builds that attempt to interact
	// with the Docker daemon will fail. Note that you must also start the Docker
	// daemon so that your builds can interact with it as needed. One way to do
	// this is to initialize the Docker daemon in the install phase of your build
	// spec by running the following build commands. (Do not run the following build
	// commands if the specified build environment image is provided by AWS CodeBuild
	// with Docker support.)
	//
	// - nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375
	// --storage-driver=vfs& - timeout -t 15 sh -c "until docker info; do echo .;
	// sleep 1; done"
	PrivilegedMode *bool `locationName:"privilegedMode" type:"boolean"`

	// The type of build environment to use for related builds.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"EnvironmentType"`
}

// String returns the string representation
func (s ProjectEnvironment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectEnvironment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectEnvironment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProjectEnvironment"}
	if s.ComputeType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeType"))
	}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.Image != nil && len(*s.Image) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Image", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.EnvironmentVariables != nil {
		for i, v := range s.EnvironmentVariables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EnvironmentVariables", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeType sets the ComputeType field's value.
func (s *ProjectEnvironment) SetComputeType(v string) *ProjectEnvironment {
	s.ComputeType = &v
	return s
}

// SetEnvironmentVariables sets the EnvironmentVariables field's value.
func (s *ProjectEnvironment) SetEnvironmentVariables(v []*EnvironmentVariable) *ProjectEnvironment {
	s.EnvironmentVariables = v
	return s
}

// SetImage sets the Image field's value.
func (s *ProjectEnvironment) SetImage(v string) *ProjectEnvironment {
	s.Image = &v
	return s
}

// SetPrivilegedMode sets the PrivilegedMode field's value.
func (s *ProjectEnvironment) SetPrivilegedMode(v bool) *ProjectEnvironment {
	s.PrivilegedMode = &v
	return s
}

// SetType sets the Type field's value.
func (s *ProjectEnvironment) SetType(v string) *ProjectEnvironment {
	s.Type = &v
	return s
}

// Information about the build input source code for the build project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ProjectSource
type ProjectSource struct {
	_ struct{} `type:"structure"`

	// Information about the authorization settings for AWS CodeBuild to access
	// the source code to be built.
	//
	// This information is for the AWS CodeBuild console's use only. Your code should
	// not get or set this information directly (unless the build project's source
	// type value is GITHUB).
	Auth *SourceAuth `locationName:"auth" type:"structure"`

	// The build spec declaration to use for the builds in this build project.
	//
	// If this value is not specified, a build spec must be included along with
	// the source code to be built.
	Buildspec *string `locationName:"buildspec" type:"string"`

	// Information about the location of the source code to be built. Valid values
	// include:
	//
	//    * For source code settings that are specified in the source action of
	//    a pipeline in AWS CodePipeline, location should not be specified. If it
	//    is specified, AWS CodePipeline will ignore it. This is because AWS CodePipeline
	//    uses the settings in a pipeline's source action instead of this value.
	//
	//    * For source code in an AWS CodeCommit repository, the HTTPS clone URL
	//    to the repository that contains the source code and the build spec (for
	//    example, https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name).
	//
	//    * For source code in an Amazon Simple Storage Service (Amazon S3) input
	//    bucket, the path to the ZIP file that contains the source code (for example,
	//    bucket-name/path/to/object-name.zip)
	//
	//    * For source code in a GitHub repository, the HTTPS clone URL to the repository
	//    that contains the source and the build spec. Also, you must connect your
	//    AWS account to your GitHub account. To do this, use the AWS CodeBuild
	//    console to begin creating a build project. When you use the console to
	//    connect (or reconnect) with GitHub, on the GitHub Authorize application
	//    page that displays, for Organization access, choose Request access next
	//    to each repository you want to allow AWS CodeBuild to have access to.
	//    Then choose Authorize application. (After you have connected to your GitHub
	//    account, you do not need to finish creating the build project, and you
	//    may then leave the AWS CodeBuild console.) To instruct AWS CodeBuild to
	//    then use this connection, in the source object, set the auth object's
	//    type value to OAUTH.
	Location *string `locationName:"location" type:"string"`

	// The type of repository that contains the source code to be built. Valid values
	// include:
	//
	//    * CODECOMMIT: The source code is in an AWS CodeCommit repository.
	//
	//    * CODEPIPELINE: The source code settings are specified in the source action
	//    of a pipeline in AWS CodePipeline.
	//
	//    * GITHUB: The source code is in a GitHub repository.
	//
	//    * S3: The source code is in an Amazon Simple Storage Service (Amazon S3)
	//    input bucket.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SourceType"`
}

// String returns the string representation
func (s ProjectSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProjectSource"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Auth != nil {
		if err := s.Auth.Validate(); err != nil {
			invalidParams.AddNested("Auth", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuth sets the Auth field's value.
func (s *ProjectSource) SetAuth(v *SourceAuth) *ProjectSource {
	s.Auth = v
	return s
}

// SetBuildspec sets the Buildspec field's value.
func (s *ProjectSource) SetBuildspec(v string) *ProjectSource {
	s.Buildspec = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *ProjectSource) SetLocation(v string) *ProjectSource {
	s.Location = &v
	return s
}

// SetType sets the Type field's value.
func (s *ProjectSource) SetType(v string) *ProjectSource {
	s.Type = &v
	return s
}

// Information about the authorization settings for AWS CodeBuild to access
// the source code to be built.
//
// This information is for the AWS CodeBuild console's use only. Your code should
// not get or set this information directly (unless the build project's source
// type value is GITHUB).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/SourceAuth
type SourceAuth struct {
	_ struct{} `type:"structure"`

	// The resource value that applies to the specified authorization type.
	Resource *string `locationName:"resource" type:"string"`

	// The authorization type to use. The only valid value is OAUTH, which represents
	// the OAuth authorization type.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SourceAuthType"`
}

// String returns the string representation
func (s SourceAuth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceAuth) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceAuth) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceAuth"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *SourceAuth) SetResource(v string) *SourceAuth {
	s.Resource = &v
	return s
}

// SetType sets the Type field's value.
func (s *SourceAuth) SetType(v string) *SourceAuth {
	s.Type = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartBuildInput
type StartBuildInput struct {
	_ struct{} `type:"structure"`

	// Build output artifact settings that override, for this build only, the latest
	// ones already defined in the build project.
	ArtifactsOverride *ProjectArtifacts `locationName:"artifactsOverride" type:"structure"`

	// A build spec declaration that overrides, for this build only, the latest
	// one already defined in the build project.
	BuildspecOverride *string `locationName:"buildspecOverride" type:"string"`

	// A set of environment variables that overrides, for this build only, the latest
	// ones already defined in the build project.
	EnvironmentVariablesOverride []*EnvironmentVariable `locationName:"environmentVariablesOverride" type:"list"`

	// The name of the build project to start running a build.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// A version of the build input to be built, for this build only. If not specified,
	// the latest version will be used. If specified, must be one of:
	//
	//    * For AWS CodeCommit or GitHub: the commit ID to use.
	//
	//    * For Amazon Simple Storage Service (Amazon S3): the version ID of the
	//    object representing the build input ZIP file to use.
	SourceVersion *string `locationName:"sourceVersion" type:"string"`

	// The number of build timeout minutes, from 5 to 480 (8 hours), that overrides,
	// for this build only, the latest setting already defined in the build project.
	TimeoutInMinutesOverride *int64 `locationName:"timeoutInMinutesOverride" min:"5" type:"integer"`
}

// String returns the string representation
func (s StartBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartBuildInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}
	if s.TimeoutInMinutesOverride != nil && *s.TimeoutInMinutesOverride < 5 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInMinutesOverride", 5))
	}
	if s.ArtifactsOverride != nil {
		if err := s.ArtifactsOverride.Validate(); err != nil {
			invalidParams.AddNested("ArtifactsOverride", err.(request.ErrInvalidParams))
		}
	}
	if s.EnvironmentVariablesOverride != nil {
		for i, v := range s.EnvironmentVariablesOverride {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EnvironmentVariablesOverride", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifactsOverride sets the ArtifactsOverride field's value.
func (s *StartBuildInput) SetArtifactsOverride(v *ProjectArtifacts) *StartBuildInput {
	s.ArtifactsOverride = v
	return s
}

// SetBuildspecOverride sets the BuildspecOverride field's value.
func (s *StartBuildInput) SetBuildspecOverride(v string) *StartBuildInput {
	s.BuildspecOverride = &v
	return s
}

// SetEnvironmentVariablesOverride sets the EnvironmentVariablesOverride field's value.
func (s *StartBuildInput) SetEnvironmentVariablesOverride(v []*EnvironmentVariable) *StartBuildInput {
	s.EnvironmentVariablesOverride = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *StartBuildInput) SetProjectName(v string) *StartBuildInput {
	s.ProjectName = &v
	return s
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *StartBuildInput) SetSourceVersion(v string) *StartBuildInput {
	s.SourceVersion = &v
	return s
}

// SetTimeoutInMinutesOverride sets the TimeoutInMinutesOverride field's value.
func (s *StartBuildInput) SetTimeoutInMinutesOverride(v int64) *StartBuildInput {
	s.TimeoutInMinutesOverride = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartBuildOutput
type StartBuildOutput struct {
	_ struct{} `type:"structure"`

	// Information about the build to be run.
	Build *Build `locationName:"build" type:"structure"`
}

// String returns the string representation
func (s StartBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartBuildOutput) GoString() string {
	return s.String()
}

// SetBuild sets the Build field's value.
func (s *StartBuildOutput) SetBuild(v *Build) *StartBuildOutput {
	s.Build = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StopBuildInput
type StopBuildInput struct {
	_ struct{} `type:"structure"`

	// The ID of the build.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopBuildInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *StopBuildInput) SetId(v string) *StopBuildInput {
	s.Id = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StopBuildOutput
type StopBuildOutput struct {
	_ struct{} `type:"structure"`

	// Information about the build.
	Build *Build `locationName:"build" type:"structure"`
}

// String returns the string representation
func (s StopBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopBuildOutput) GoString() string {
	return s.String()
}

// SetBuild sets the Build field's value.
func (s *StopBuildOutput) SetBuild(v *Build) *StopBuildOutput {
	s.Build = v
	return s
}

// A tag, consisting of a key and a value.
//
// This tag is available for use by AWS services that support tags in AWS CodeBuild.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The tag's value.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateProjectInput
type UpdateProjectInput struct {
	_ struct{} `type:"structure"`

	// Information to be changed about the build output artifacts for the build
	// project.
	Artifacts *ProjectArtifacts `locationName:"artifacts" type:"structure"`

	// A new or replacement description of the build project.
	Description *string `locationName:"description" type:"string"`

	// The replacement AWS Key Management Service (AWS KMS) customer master key
	// (CMK) to be used for encrypting the build output artifacts.
	//
	// You can specify either the CMK's Amazon Resource Name (ARN) or, if available,
	// the CMK's alias (using the format alias/alias-name).
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// Information to be changed about the build environment for the build project.
	Environment *ProjectEnvironment `locationName:"environment" type:"structure"`

	// The name of the build project.
	//
	// You cannot change a build project's name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The replacement ARN of the AWS Identity and Access Management (IAM) role
	// that enables AWS CodeBuild to interact with dependent AWS services on behalf
	// of the AWS account.
	ServiceRole *string `locationName:"serviceRole" min:"1" type:"string"`

	// Information to be changed about the build input source code for the build
	// project.
	Source *ProjectSource `locationName:"source" type:"structure"`

	// The replacement set of tags for this build project.
	//
	// These tags are available for use by AWS services that support AWS CodeBuild
	// build project tags.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The replacement value in minutes, from 5 to 480 (8 hours), for AWS CodeBuild
	// to wait before timing out any related build that did not get marked as completed.
	TimeoutInMinutes *int64 `locationName:"timeoutInMinutes" min:"5" type:"integer"`
}

// String returns the string representation
func (s UpdateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectInput"}
	if s.EncryptionKey != nil && len(*s.EncryptionKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKey", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ServiceRole != nil && len(*s.ServiceRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceRole", 1))
	}
	if s.TimeoutInMinutes != nil && *s.TimeoutInMinutes < 5 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInMinutes", 5))
	}
	if s.Artifacts != nil {
		if err := s.Artifacts.Validate(); err != nil {
			invalidParams.AddNested("Artifacts", err.(request.ErrInvalidParams))
		}
	}
	if s.Environment != nil {
		if err := s.Environment.Validate(); err != nil {
			invalidParams.AddNested("Environment", err.(request.ErrInvalidParams))
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifacts sets the Artifacts field's value.
func (s *UpdateProjectInput) SetArtifacts(v *ProjectArtifacts) *UpdateProjectInput {
	s.Artifacts = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateProjectInput) SetDescription(v string) *UpdateProjectInput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *UpdateProjectInput) SetEncryptionKey(v string) *UpdateProjectInput {
	s.EncryptionKey = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *UpdateProjectInput) SetEnvironment(v *ProjectEnvironment) *UpdateProjectInput {
	s.Environment = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateProjectInput) SetName(v string) *UpdateProjectInput {
	s.Name = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *UpdateProjectInput) SetServiceRole(v string) *UpdateProjectInput {
	s.ServiceRole = &v
	return s
}

// SetSource sets the Source field's value.
func (s *UpdateProjectInput) SetSource(v *ProjectSource) *UpdateProjectInput {
	s.Source = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateProjectInput) SetTags(v []*Tag) *UpdateProjectInput {
	s.Tags = v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *UpdateProjectInput) SetTimeoutInMinutes(v int64) *UpdateProjectInput {
	s.TimeoutInMinutes = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateProjectOutput
type UpdateProjectOutput struct {
	_ struct{} `type:"structure"`

	// Information about the build project that was changed.
	Project *Project `locationName:"project" type:"structure"`
}

// String returns the string representation
func (s UpdateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *UpdateProjectOutput) SetProject(v *Project) *UpdateProjectOutput {
	s.Project = v
	return s
}

const (
	// ArtifactNamespaceNone is a ArtifactNamespace enum value
	ArtifactNamespaceNone = "NONE"

	// ArtifactNamespaceBuildId is a ArtifactNamespace enum value
	ArtifactNamespaceBuildId = "BUILD_ID"
)

const (
	// ArtifactPackagingNone is a ArtifactPackaging enum value
	ArtifactPackagingNone = "NONE"

	// ArtifactPackagingZip is a ArtifactPackaging enum value
	ArtifactPackagingZip = "ZIP"
)

const (
	// ArtifactsTypeCodepipeline is a ArtifactsType enum value
	ArtifactsTypeCodepipeline = "CODEPIPELINE"

	// ArtifactsTypeS3 is a ArtifactsType enum value
	ArtifactsTypeS3 = "S3"

	// ArtifactsTypeNoArtifacts is a ArtifactsType enum value
	ArtifactsTypeNoArtifacts = "NO_ARTIFACTS"
)

const (
	// BuildPhaseTypeSubmitted is a BuildPhaseType enum value
	BuildPhaseTypeSubmitted = "SUBMITTED"

	// BuildPhaseTypeProvisioning is a BuildPhaseType enum value
	BuildPhaseTypeProvisioning = "PROVISIONING"

	// BuildPhaseTypeDownloadSource is a BuildPhaseType enum value
	BuildPhaseTypeDownloadSource = "DOWNLOAD_SOURCE"

	// BuildPhaseTypeInstall is a BuildPhaseType enum value
	BuildPhaseTypeInstall = "INSTALL"

	// BuildPhaseTypePreBuild is a BuildPhaseType enum value
	BuildPhaseTypePreBuild = "PRE_BUILD"

	// BuildPhaseTypeBuild is a BuildPhaseType enum value
	BuildPhaseTypeBuild = "BUILD"

	// BuildPhaseTypePostBuild is a BuildPhaseType enum value
	BuildPhaseTypePostBuild = "POST_BUILD"

	// BuildPhaseTypeUploadArtifacts is a BuildPhaseType enum value
	BuildPhaseTypeUploadArtifacts = "UPLOAD_ARTIFACTS"

	// BuildPhaseTypeFinalizing is a BuildPhaseType enum value
	BuildPhaseTypeFinalizing = "FINALIZING"

	// BuildPhaseTypeCompleted is a BuildPhaseType enum value
	BuildPhaseTypeCompleted = "COMPLETED"
)

const (
	// ComputeTypeBuildGeneral1Small is a ComputeType enum value
	ComputeTypeBuildGeneral1Small = "BUILD_GENERAL1_SMALL"

	// ComputeTypeBuildGeneral1Medium is a ComputeType enum value
	ComputeTypeBuildGeneral1Medium = "BUILD_GENERAL1_MEDIUM"

	// ComputeTypeBuildGeneral1Large is a ComputeType enum value
	ComputeTypeBuildGeneral1Large = "BUILD_GENERAL1_LARGE"
)

const (
	// EnvironmentTypeLinuxContainer is a EnvironmentType enum value
	EnvironmentTypeLinuxContainer = "LINUX_CONTAINER"
)

const (
	// LanguageTypeJava is a LanguageType enum value
	LanguageTypeJava = "JAVA"

	// LanguageTypePython is a LanguageType enum value
	LanguageTypePython = "PYTHON"

	// LanguageTypeNodeJs is a LanguageType enum value
	LanguageTypeNodeJs = "NODE_JS"

	// LanguageTypeRuby is a LanguageType enum value
	LanguageTypeRuby = "RUBY"

	// LanguageTypeGolang is a LanguageType enum value
	LanguageTypeGolang = "GOLANG"

	// LanguageTypeDocker is a LanguageType enum value
	LanguageTypeDocker = "DOCKER"

	// LanguageTypeAndroid is a LanguageType enum value
	LanguageTypeAndroid = "ANDROID"

	// LanguageTypeBase is a LanguageType enum value
	LanguageTypeBase = "BASE"
)

const (
	// PlatformTypeDebian is a PlatformType enum value
	PlatformTypeDebian = "DEBIAN"

	// PlatformTypeAmazonLinux is a PlatformType enum value
	PlatformTypeAmazonLinux = "AMAZON_LINUX"

	// PlatformTypeUbuntu is a PlatformType enum value
	PlatformTypeUbuntu = "UBUNTU"
)

const (
	// ProjectSortByTypeName is a ProjectSortByType enum value
	ProjectSortByTypeName = "NAME"

	// ProjectSortByTypeCreatedTime is a ProjectSortByType enum value
	ProjectSortByTypeCreatedTime = "CREATED_TIME"

	// ProjectSortByTypeLastModifiedTime is a ProjectSortByType enum value
	ProjectSortByTypeLastModifiedTime = "LAST_MODIFIED_TIME"
)

const (
	// SortOrderTypeAscending is a SortOrderType enum value
	SortOrderTypeAscending = "ASCENDING"

	// SortOrderTypeDescending is a SortOrderType enum value
	SortOrderTypeDescending = "DESCENDING"
)

const (
	// SourceAuthTypeOauth is a SourceAuthType enum value
	SourceAuthTypeOauth = "OAUTH"
)

const (
	// SourceTypeCodecommit is a SourceType enum value
	SourceTypeCodecommit = "CODECOMMIT"

	// SourceTypeCodepipeline is a SourceType enum value
	SourceTypeCodepipeline = "CODEPIPELINE"

	// SourceTypeGithub is a SourceType enum value
	SourceTypeGithub = "GITHUB"

	// SourceTypeS3 is a SourceType enum value
	SourceTypeS3 = "S3"
)

const (
	// StatusTypeSucceeded is a StatusType enum value
	StatusTypeSucceeded = "SUCCEEDED"

	// StatusTypeFailed is a StatusType enum value
	StatusTypeFailed = "FAILED"

	// StatusTypeFault is a StatusType enum value
	StatusTypeFault = "FAULT"

	// StatusTypeTimedOut is a StatusType enum value
	StatusTypeTimedOut = "TIMED_OUT"

	// StatusTypeInProgress is a StatusType enum value
	StatusTypeInProgress = "IN_PROGRESS"

	// StatusTypeStopped is a StatusType enum value
	StatusTypeStopped = "STOPPED"
)
