// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package cloudtrail provides the client and types for making API
// requests to AWS CloudTrail.
//
// This is the CloudTrail API Reference. It provides descriptions of actions,
// data types, common parameters, and common errors for CloudTrail.
//
// CloudTrail is a web service that records AWS API calls for your AWS account
// and delivers log files to an Amazon S3 bucket. The recorded information includes
// the identity of the user, the start time of the AWS API call, the source
// IP address, the request parameters, and the response elements returned by
// the service.
//
// As an alternative to the API, you can use one of the AWS SDKs, which consist
// of libraries and sample code for various programming languages and platforms
// (Java, Ruby, .NET, iOS, Android, etc.). The SDKs provide a convenient way
// to create programmatic access to AWSCloudTrail. For example, the SDKs take
// care of cryptographically signing requests, managing errors, and retrying
// requests automatically. For information about the AWS SDKs, including how
// to download and install them, see the Tools for Amazon Web Services page
// (http://aws.amazon.com/tools/).
//
// See the AWS CloudTrail User Guide (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-user-guide.html)
// for information about the data that is included with each AWS API call listed
// in the log files.
//
// See https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01 for more information on this service.
//
// See cloudtrail package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/cloudtrail/
//
// Using the Client
//
// To use the client for AWS CloudTrail you will first need
// to create a new instance of it.
//
// When creating a client for an AWS service you'll first need to have a Session
// already created. The Session provides configuration that can be shared
// between multiple service clients. Additional configuration can be applied to
// the Session and service's client when they are constructed. The aws package's
// Config type contains several fields such as Region for the AWS Region the
// client should make API requests too. The optional Config value can be provided
// as the variadic argument for Sessions and client creation.
//
// Once the service's client is created you can use it to make API requests the
// AWS service. These clients are safe to use concurrently.
//
//   // Create a session to share configuration, and load external configuration.
//   sess := session.Must(session.NewSession())
//
//   // Create the service's client with the session.
//   svc := cloudtrail.New(sess)
//
// See the SDK's documentation for more information on how to use service clients.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws package's Config type for more information on configuration options.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the AWS CloudTrail client CloudTrail for more
// information on creating the service's client.
// https://docs.aws.amazon.com/sdk-for-go/api/service/cloudtrail/#New
//
// Once the client is created you can make an API request to the service.
// Each API method takes a input parameter, and returns the service response
// and an error.
//
// The API method will document which error codes the service can be returned
// by the operation if the service models the API operation's errors. These
// errors will also be available as const strings prefixed with "ErrCode".
//
//   result, err := svc.AddTags(params)
//   if err != nil {
//       // Cast err to awserr.Error to handle specific error codes.
//       aerr, ok := err.(awserr.Error)
//       if ok && aerr.Code() == <error code to check for> {
//           // Specific error code handling
//       }
//       return err
//   }
//
//   fmt.Println("AddTags result:")
//   fmt.Println(result)
//
// Using the Client with Context
//
// The service's client also provides methods to make API requests with a Context
// value. This allows you to control the timeout, and cancellation of pending
// requests. These methods also take request Option as variadic parameter to apply
// additional configuration to the API request.
//
//   ctx := context.Background()
//
//   result, err := svc.AddTagsWithContext(ctx, params)
//
// See the request package documentation for more information on using Context pattern
// with the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/request/
package cloudtrail
