/* getopt for brain-dead MS Windows */

#include <config.h>

int optind;
char *optarg, optopt;

static char *nextChar;

int
getopt(int argc, char *argv[], char *opts)
{
    char *pos;

    if (optind >= argc)
	return EOF;
    if (!nextChar || !*nextChar) {
	if (++optind >= argc || argv[optind][0] != '-')
	    return EOF;
	nextChar = &argv[optind][1];
    }
    if ((pos = strchr(opts, optopt = *nextChar++)) == NULL || optopt == ':') {
	fprintf(stderr, "%s: invalid option -- %c\n", argv[0], optopt);
	return '?';
    }
    if (pos[1] != ':')
	optarg = NULL;
    else {
	if (*nextChar) {
	    optarg = nextChar;
	    nextChar = NULL;
	}
	else if (optind < argc-1)
	    optarg = argv[++optind];
	else {
	    fprintf(stderr, "%s: option requries an argument -- %c\n", argv[0],
		    optopt);
	    return '?';
	}
    }
    return optopt;
}
