# Announce: Rakudo compiler, Release #150 (2021.09)

On behalf of the Rakudo development team, I’m very happy to announce the
September 2021 release of Rakudo #150. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2021.09:

  + Additions:
    + Introduce the `safe-snapper` module. It is a shorthand
      for loading `Telemetry` and starting a snapper with control-c
      safety, allowing one to stop the script with control-c and
      still get a report [87152eba]
    + Add ability to subtract an `Instant` value from a `DateTime`
      object and vice versa [9a4af4b6]
    + Add `Numeric` coercer to `DateTime` [67138ec0]
  + Changes:
    + Make the `sprintf` method show its format string on error [ea8a95e5][57841911]
    + The `test` named parameter of the `dir` routine now handles Junctions [21a7117d]
    + Improve error message for the `X::Pragma::CannotPrecomp` exception [a52f1f62][fe461d17]
  + Efficiency:
    + Numerous small speed-ups and memory-related improvements
      [94462dfa][3aba9707][3c1c709c]
  + Fixes:
    + Properly handle List of Lists in the `List.fmt` method [a86ec91e]
    + Don't lose concurrent modifications to `%!conc_table` [72bc5623]
    + Fix potential race in `Metamodel::Concretization` [d666dfe8]
    + Make the default scheduler properly see `RAKUDO_MAX_THREADS` env variable [b14d404a]
  + Internal:
    + Support `ROAST_TIMING_SCALE` in telemetry tests [9681a093]
    + Fix false positive in basic telemetry test [c0a6823b]
    + Pass along whether the Rakudo runner was called with `--full-cleanup` [5492452b]
    + Update the concretization table more sparingly [b236dcfd]


The following people contributed to this release:

Will "Coke" Coleda, Tom Browder, Elizabeth Mattijsen, Daniel Sockwell,
JJ Merelo, Daniel Green, keutoi, Stefan Seifert, Vadim Belman,
Oleksandr Kyriukhin, Samantha McVey, Christian Bartolomäus, Jonathan Worthington,
Nicholas Clark, Stoned Elipot, Andinus, Ben Davies, Silvio Mayolo

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2021 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on Libera.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#151), is tentatively scheduled for 2021-10-23.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
