use v6;
# Unicode normalization tests, generated from NormalizationTests.txt in the
# Unicode database by S15-normalization/test-gen.p6.
# Generated from Unicode version 13.0.0.

use Test;

plan 2000;

ok Uni.new(0x1E0A).NFKC.list ~~ (0x1E0A,), '1E0A -> 1E0A';
ok Uni.new(0x1E0C).NFKC.list ~~ (0x1E0C,), '1E0C -> 1E0C';
ok Uni.new(0x1E0A, 0x0323).NFKC.list ~~ (0x1E0C, 0x0307,), '1E0A 0323 -> 1E0C 0307';
ok Uni.new(0x1E0C, 0x0307).NFKC.list ~~ (0x1E0C, 0x0307,), '1E0C 0307 -> 1E0C 0307';
ok Uni.new(0x0044, 0x0307, 0x0323).NFKC.list ~~ (0x1E0C, 0x0307,), '0044 0307 0323 -> 1E0C 0307';
ok Uni.new(0x0044, 0x0323, 0x0307).NFKC.list ~~ (0x1E0C, 0x0307,), '0044 0323 0307 -> 1E0C 0307';
ok Uni.new(0x1E0A, 0x031B).NFKC.list ~~ (0x1E0A, 0x031B,), '1E0A 031B -> 1E0A 031B';
ok Uni.new(0x1E0C, 0x031B).NFKC.list ~~ (0x1E0C, 0x031B,), '1E0C 031B -> 1E0C 031B';
ok Uni.new(0x1E0A, 0x031B, 0x0323).NFKC.list ~~ (0x1E0C, 0x031B, 0x0307,), '1E0A 031B 0323 -> 1E0C 031B 0307';
ok Uni.new(0x1E0C, 0x031B, 0x0307).NFKC.list ~~ (0x1E0C, 0x031B, 0x0307,), '1E0C 031B 0307 -> 1E0C 031B 0307';
ok Uni.new(0x0044, 0x031B, 0x0307, 0x0323).NFKC.list ~~ (0x1E0C, 0x031B, 0x0307,), '0044 031B 0307 0323 -> 1E0C 031B 0307';
ok Uni.new(0x0044, 0x031B, 0x0323, 0x0307).NFKC.list ~~ (0x1E0C, 0x031B, 0x0307,), '0044 031B 0323 0307 -> 1E0C 031B 0307';
ok Uni.new(0x00C8).NFKC.list ~~ (0x00C8,), '00C8 -> 00C8';
ok Uni.new(0x0112).NFKC.list ~~ (0x0112,), '0112 -> 0112';
ok Uni.new(0x0045, 0x0300).NFKC.list ~~ (0x00C8,), '0045 0300 -> 00C8';
ok Uni.new(0x0045, 0x0304).NFKC.list ~~ (0x0112,), '0045 0304 -> 0112';
ok Uni.new(0x1E14).NFKC.list ~~ (0x1E14,), '1E14 -> 1E14';
ok Uni.new(0x0112, 0x0300).NFKC.list ~~ (0x1E14,), '0112 0300 -> 1E14';
ok Uni.new(0x1E14, 0x0304).NFKC.list ~~ (0x1E14, 0x0304,), '1E14 0304 -> 1E14 0304';
ok Uni.new(0x0045, 0x0304, 0x0300).NFKC.list ~~ (0x1E14,), '0045 0304 0300 -> 1E14';
ok Uni.new(0x0045, 0x0300, 0x0304).NFKC.list ~~ (0x00C8, 0x0304,), '0045 0300 0304 -> 00C8 0304';
ok Uni.new(0x05B8, 0x05B9, 0x05B1, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F).NFKC.list ~~ (0x05B1, 0x05B8, 0x05B9, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F,), '05B8 05B9 05B1 0591 05C3 05B0 05AC 059F -> 05B1 05B8 05B9 0591 05C3 05B0 05AC 059F';
ok Uni.new(0x0592, 0x05B7, 0x05BC, 0x05A5, 0x05B0, 0x05C0, 0x05C4, 0x05AD).NFKC.list ~~ (0x05B0, 0x05B7, 0x05BC, 0x05A5, 0x0592, 0x05C0, 0x05AD, 0x05C4,), '0592 05B7 05BC 05A5 05B0 05C0 05C4 05AD -> 05B0 05B7 05BC 05A5 0592 05C0 05AD 05C4';
ok Uni.new(0x1100, 0xAC00, 0x11A8).NFKC.list ~~ (0x1100, 0xAC01,), '1100 AC00 11A8 -> 1100 AC01';
ok Uni.new(0x1100, 0xAC00, 0x11A8, 0x11A8).NFKC.list ~~ (0x1100, 0xAC01, 0x11A8,), '1100 AC00 11A8 11A8 -> 1100 AC01 11A8';
ok Uni.new(0x00A0).NFKC.list ~~ (0x0020,), '00A0 -> 0020';
ok Uni.new(0x00A8).NFKC.list ~~ (0x0020, 0x0308,), '00A8 -> 0020 0308';
ok Uni.new(0x00AA).NFKC.list ~~ (0x0061,), '00AA -> 0061';
ok Uni.new(0x00AF).NFKC.list ~~ (0x0020, 0x0304,), '00AF -> 0020 0304';
ok Uni.new(0x00B2).NFKC.list ~~ (0x0032,), '00B2 -> 0032';
ok Uni.new(0x00B3).NFKC.list ~~ (0x0033,), '00B3 -> 0033';
ok Uni.new(0x00B4).NFKC.list ~~ (0x0020, 0x0301,), '00B4 -> 0020 0301';
ok Uni.new(0x00B5).NFKC.list ~~ (0x03BC,), '00B5 -> 03BC';
ok Uni.new(0x00B8).NFKC.list ~~ (0x0020, 0x0327,), '00B8 -> 0020 0327';
ok Uni.new(0x00B9).NFKC.list ~~ (0x0031,), '00B9 -> 0031';
ok Uni.new(0x00BA).NFKC.list ~~ (0x006F,), '00BA -> 006F';
ok Uni.new(0x00BC).NFKC.list ~~ (0x0031, 0x2044, 0x0034,), '00BC -> 0031 2044 0034';
ok Uni.new(0x00BD).NFKC.list ~~ (0x0031, 0x2044, 0x0032,), '00BD -> 0031 2044 0032';
ok Uni.new(0x00BE).NFKC.list ~~ (0x0033, 0x2044, 0x0034,), '00BE -> 0033 2044 0034';
ok Uni.new(0x00C0).NFKC.list ~~ (0x00C0,), '00C0 -> 00C0';
ok Uni.new(0x00C1).NFKC.list ~~ (0x00C1,), '00C1 -> 00C1';
ok Uni.new(0x00C2).NFKC.list ~~ (0x00C2,), '00C2 -> 00C2';
ok Uni.new(0x00C3).NFKC.list ~~ (0x00C3,), '00C3 -> 00C3';
ok Uni.new(0x00C4).NFKC.list ~~ (0x00C4,), '00C4 -> 00C4';
ok Uni.new(0x00C5).NFKC.list ~~ (0x00C5,), '00C5 -> 00C5';
ok Uni.new(0x00C7).NFKC.list ~~ (0x00C7,), '00C7 -> 00C7';
ok Uni.new(0x00C8).NFKC.list ~~ (0x00C8,), '00C8 -> 00C8';
ok Uni.new(0x00C9).NFKC.list ~~ (0x00C9,), '00C9 -> 00C9';
ok Uni.new(0x00CA).NFKC.list ~~ (0x00CA,), '00CA -> 00CA';
ok Uni.new(0x00CB).NFKC.list ~~ (0x00CB,), '00CB -> 00CB';
ok Uni.new(0x00CC).NFKC.list ~~ (0x00CC,), '00CC -> 00CC';
ok Uni.new(0x00CD).NFKC.list ~~ (0x00CD,), '00CD -> 00CD';
ok Uni.new(0x00CE).NFKC.list ~~ (0x00CE,), '00CE -> 00CE';
ok Uni.new(0x00CF).NFKC.list ~~ (0x00CF,), '00CF -> 00CF';
ok Uni.new(0x00D1).NFKC.list ~~ (0x00D1,), '00D1 -> 00D1';
ok Uni.new(0x00D2).NFKC.list ~~ (0x00D2,), '00D2 -> 00D2';
ok Uni.new(0x00D3).NFKC.list ~~ (0x00D3,), '00D3 -> 00D3';
ok Uni.new(0x00D4).NFKC.list ~~ (0x00D4,), '00D4 -> 00D4';
ok Uni.new(0x00D5).NFKC.list ~~ (0x00D5,), '00D5 -> 00D5';
ok Uni.new(0x00D6).NFKC.list ~~ (0x00D6,), '00D6 -> 00D6';
ok Uni.new(0x00D9).NFKC.list ~~ (0x00D9,), '00D9 -> 00D9';
ok Uni.new(0x00DA).NFKC.list ~~ (0x00DA,), '00DA -> 00DA';
ok Uni.new(0x00DB).NFKC.list ~~ (0x00DB,), '00DB -> 00DB';
ok Uni.new(0x00DC).NFKC.list ~~ (0x00DC,), '00DC -> 00DC';
ok Uni.new(0x00DD).NFKC.list ~~ (0x00DD,), '00DD -> 00DD';
ok Uni.new(0x00E0).NFKC.list ~~ (0x00E0,), '00E0 -> 00E0';
ok Uni.new(0x00E1).NFKC.list ~~ (0x00E1,), '00E1 -> 00E1';
ok Uni.new(0x00E2).NFKC.list ~~ (0x00E2,), '00E2 -> 00E2';
ok Uni.new(0x00E3).NFKC.list ~~ (0x00E3,), '00E3 -> 00E3';
ok Uni.new(0x00E4).NFKC.list ~~ (0x00E4,), '00E4 -> 00E4';
ok Uni.new(0x00E5).NFKC.list ~~ (0x00E5,), '00E5 -> 00E5';
ok Uni.new(0x00E7).NFKC.list ~~ (0x00E7,), '00E7 -> 00E7';
ok Uni.new(0x00E8).NFKC.list ~~ (0x00E8,), '00E8 -> 00E8';
ok Uni.new(0x00E9).NFKC.list ~~ (0x00E9,), '00E9 -> 00E9';
ok Uni.new(0x00EA).NFKC.list ~~ (0x00EA,), '00EA -> 00EA';
ok Uni.new(0x00EB).NFKC.list ~~ (0x00EB,), '00EB -> 00EB';
ok Uni.new(0x00EC).NFKC.list ~~ (0x00EC,), '00EC -> 00EC';
ok Uni.new(0x00ED).NFKC.list ~~ (0x00ED,), '00ED -> 00ED';
ok Uni.new(0x00EE).NFKC.list ~~ (0x00EE,), '00EE -> 00EE';
ok Uni.new(0x00EF).NFKC.list ~~ (0x00EF,), '00EF -> 00EF';
ok Uni.new(0x00F1).NFKC.list ~~ (0x00F1,), '00F1 -> 00F1';
ok Uni.new(0x00F2).NFKC.list ~~ (0x00F2,), '00F2 -> 00F2';
ok Uni.new(0x00F3).NFKC.list ~~ (0x00F3,), '00F3 -> 00F3';
ok Uni.new(0x00F4).NFKC.list ~~ (0x00F4,), '00F4 -> 00F4';
ok Uni.new(0x00F5).NFKC.list ~~ (0x00F5,), '00F5 -> 00F5';
ok Uni.new(0x00F6).NFKC.list ~~ (0x00F6,), '00F6 -> 00F6';
ok Uni.new(0x00F9).NFKC.list ~~ (0x00F9,), '00F9 -> 00F9';
ok Uni.new(0x00FA).NFKC.list ~~ (0x00FA,), '00FA -> 00FA';
ok Uni.new(0x00FB).NFKC.list ~~ (0x00FB,), '00FB -> 00FB';
ok Uni.new(0x00FC).NFKC.list ~~ (0x00FC,), '00FC -> 00FC';
ok Uni.new(0x00FD).NFKC.list ~~ (0x00FD,), '00FD -> 00FD';
ok Uni.new(0x00FF).NFKC.list ~~ (0x00FF,), '00FF -> 00FF';
ok Uni.new(0x0100).NFKC.list ~~ (0x0100,), '0100 -> 0100';
ok Uni.new(0x0101).NFKC.list ~~ (0x0101,), '0101 -> 0101';
ok Uni.new(0x0102).NFKC.list ~~ (0x0102,), '0102 -> 0102';
ok Uni.new(0x0103).NFKC.list ~~ (0x0103,), '0103 -> 0103';
ok Uni.new(0x0104).NFKC.list ~~ (0x0104,), '0104 -> 0104';
ok Uni.new(0x0105).NFKC.list ~~ (0x0105,), '0105 -> 0105';
ok Uni.new(0x0106).NFKC.list ~~ (0x0106,), '0106 -> 0106';
ok Uni.new(0x0107).NFKC.list ~~ (0x0107,), '0107 -> 0107';
ok Uni.new(0x0108).NFKC.list ~~ (0x0108,), '0108 -> 0108';
ok Uni.new(0x0109).NFKC.list ~~ (0x0109,), '0109 -> 0109';
ok Uni.new(0x010A).NFKC.list ~~ (0x010A,), '010A -> 010A';
ok Uni.new(0x010B).NFKC.list ~~ (0x010B,), '010B -> 010B';
ok Uni.new(0x010C).NFKC.list ~~ (0x010C,), '010C -> 010C';
ok Uni.new(0x010D).NFKC.list ~~ (0x010D,), '010D -> 010D';
ok Uni.new(0x010E).NFKC.list ~~ (0x010E,), '010E -> 010E';
ok Uni.new(0x010F).NFKC.list ~~ (0x010F,), '010F -> 010F';
ok Uni.new(0x0112).NFKC.list ~~ (0x0112,), '0112 -> 0112';
ok Uni.new(0x0113).NFKC.list ~~ (0x0113,), '0113 -> 0113';
ok Uni.new(0x0114).NFKC.list ~~ (0x0114,), '0114 -> 0114';
ok Uni.new(0x0115).NFKC.list ~~ (0x0115,), '0115 -> 0115';
ok Uni.new(0x0116).NFKC.list ~~ (0x0116,), '0116 -> 0116';
ok Uni.new(0x0117).NFKC.list ~~ (0x0117,), '0117 -> 0117';
ok Uni.new(0x0118).NFKC.list ~~ (0x0118,), '0118 -> 0118';
ok Uni.new(0x0119).NFKC.list ~~ (0x0119,), '0119 -> 0119';
ok Uni.new(0x011A).NFKC.list ~~ (0x011A,), '011A -> 011A';
ok Uni.new(0x011B).NFKC.list ~~ (0x011B,), '011B -> 011B';
ok Uni.new(0x011C).NFKC.list ~~ (0x011C,), '011C -> 011C';
ok Uni.new(0x011D).NFKC.list ~~ (0x011D,), '011D -> 011D';
ok Uni.new(0x011E).NFKC.list ~~ (0x011E,), '011E -> 011E';
ok Uni.new(0x011F).NFKC.list ~~ (0x011F,), '011F -> 011F';
ok Uni.new(0x0120).NFKC.list ~~ (0x0120,), '0120 -> 0120';
ok Uni.new(0x0121).NFKC.list ~~ (0x0121,), '0121 -> 0121';
ok Uni.new(0x0122).NFKC.list ~~ (0x0122,), '0122 -> 0122';
ok Uni.new(0x0123).NFKC.list ~~ (0x0123,), '0123 -> 0123';
ok Uni.new(0x0124).NFKC.list ~~ (0x0124,), '0124 -> 0124';
ok Uni.new(0x0125).NFKC.list ~~ (0x0125,), '0125 -> 0125';
ok Uni.new(0x0128).NFKC.list ~~ (0x0128,), '0128 -> 0128';
ok Uni.new(0x0129).NFKC.list ~~ (0x0129,), '0129 -> 0129';
ok Uni.new(0x012A).NFKC.list ~~ (0x012A,), '012A -> 012A';
ok Uni.new(0x012B).NFKC.list ~~ (0x012B,), '012B -> 012B';
ok Uni.new(0x012C).NFKC.list ~~ (0x012C,), '012C -> 012C';
ok Uni.new(0x012D).NFKC.list ~~ (0x012D,), '012D -> 012D';
ok Uni.new(0x012E).NFKC.list ~~ (0x012E,), '012E -> 012E';
ok Uni.new(0x012F).NFKC.list ~~ (0x012F,), '012F -> 012F';
ok Uni.new(0x0130).NFKC.list ~~ (0x0130,), '0130 -> 0130';
ok Uni.new(0x0132).NFKC.list ~~ (0x0049, 0x004A,), '0132 -> 0049 004A';
ok Uni.new(0x0133).NFKC.list ~~ (0x0069, 0x006A,), '0133 -> 0069 006A';
ok Uni.new(0x0134).NFKC.list ~~ (0x0134,), '0134 -> 0134';
ok Uni.new(0x0135).NFKC.list ~~ (0x0135,), '0135 -> 0135';
ok Uni.new(0x0136).NFKC.list ~~ (0x0136,), '0136 -> 0136';
ok Uni.new(0x0137).NFKC.list ~~ (0x0137,), '0137 -> 0137';
ok Uni.new(0x0139).NFKC.list ~~ (0x0139,), '0139 -> 0139';
ok Uni.new(0x013A).NFKC.list ~~ (0x013A,), '013A -> 013A';
ok Uni.new(0x013B).NFKC.list ~~ (0x013B,), '013B -> 013B';
ok Uni.new(0x013C).NFKC.list ~~ (0x013C,), '013C -> 013C';
ok Uni.new(0x013D).NFKC.list ~~ (0x013D,), '013D -> 013D';
ok Uni.new(0x013E).NFKC.list ~~ (0x013E,), '013E -> 013E';
ok Uni.new(0x013F).NFKC.list ~~ (0x004C, 0x00B7,), '013F -> 004C 00B7';
ok Uni.new(0x0140).NFKC.list ~~ (0x006C, 0x00B7,), '0140 -> 006C 00B7';
ok Uni.new(0x0143).NFKC.list ~~ (0x0143,), '0143 -> 0143';
ok Uni.new(0x0144).NFKC.list ~~ (0x0144,), '0144 -> 0144';
ok Uni.new(0x0145).NFKC.list ~~ (0x0145,), '0145 -> 0145';
ok Uni.new(0x0146).NFKC.list ~~ (0x0146,), '0146 -> 0146';
ok Uni.new(0x0147).NFKC.list ~~ (0x0147,), '0147 -> 0147';
ok Uni.new(0x0148).NFKC.list ~~ (0x0148,), '0148 -> 0148';
ok Uni.new(0x0149).NFKC.list ~~ (0x02BC, 0x006E,), '0149 -> 02BC 006E';
ok Uni.new(0x014C).NFKC.list ~~ (0x014C,), '014C -> 014C';
ok Uni.new(0x014D).NFKC.list ~~ (0x014D,), '014D -> 014D';
ok Uni.new(0x014E).NFKC.list ~~ (0x014E,), '014E -> 014E';
ok Uni.new(0x014F).NFKC.list ~~ (0x014F,), '014F -> 014F';
ok Uni.new(0x0150).NFKC.list ~~ (0x0150,), '0150 -> 0150';
ok Uni.new(0x0151).NFKC.list ~~ (0x0151,), '0151 -> 0151';
ok Uni.new(0x0154).NFKC.list ~~ (0x0154,), '0154 -> 0154';
ok Uni.new(0x0155).NFKC.list ~~ (0x0155,), '0155 -> 0155';
ok Uni.new(0x0156).NFKC.list ~~ (0x0156,), '0156 -> 0156';
ok Uni.new(0x0157).NFKC.list ~~ (0x0157,), '0157 -> 0157';
ok Uni.new(0x0158).NFKC.list ~~ (0x0158,), '0158 -> 0158';
ok Uni.new(0x0159).NFKC.list ~~ (0x0159,), '0159 -> 0159';
ok Uni.new(0x015A).NFKC.list ~~ (0x015A,), '015A -> 015A';
ok Uni.new(0x015B).NFKC.list ~~ (0x015B,), '015B -> 015B';
ok Uni.new(0x015C).NFKC.list ~~ (0x015C,), '015C -> 015C';
ok Uni.new(0x015D).NFKC.list ~~ (0x015D,), '015D -> 015D';
ok Uni.new(0x015E).NFKC.list ~~ (0x015E,), '015E -> 015E';
ok Uni.new(0x015F).NFKC.list ~~ (0x015F,), '015F -> 015F';
ok Uni.new(0x0160).NFKC.list ~~ (0x0160,), '0160 -> 0160';
ok Uni.new(0x0161).NFKC.list ~~ (0x0161,), '0161 -> 0161';
ok Uni.new(0x0162).NFKC.list ~~ (0x0162,), '0162 -> 0162';
ok Uni.new(0x0163).NFKC.list ~~ (0x0163,), '0163 -> 0163';
ok Uni.new(0x0164).NFKC.list ~~ (0x0164,), '0164 -> 0164';
ok Uni.new(0x0165).NFKC.list ~~ (0x0165,), '0165 -> 0165';
ok Uni.new(0x0168).NFKC.list ~~ (0x0168,), '0168 -> 0168';
ok Uni.new(0x0169).NFKC.list ~~ (0x0169,), '0169 -> 0169';
ok Uni.new(0x016A).NFKC.list ~~ (0x016A,), '016A -> 016A';
ok Uni.new(0x016B).NFKC.list ~~ (0x016B,), '016B -> 016B';
ok Uni.new(0x016C).NFKC.list ~~ (0x016C,), '016C -> 016C';
ok Uni.new(0x016D).NFKC.list ~~ (0x016D,), '016D -> 016D';
ok Uni.new(0x016E).NFKC.list ~~ (0x016E,), '016E -> 016E';
ok Uni.new(0x016F).NFKC.list ~~ (0x016F,), '016F -> 016F';
ok Uni.new(0x0170).NFKC.list ~~ (0x0170,), '0170 -> 0170';
ok Uni.new(0x0171).NFKC.list ~~ (0x0171,), '0171 -> 0171';
ok Uni.new(0x0172).NFKC.list ~~ (0x0172,), '0172 -> 0172';
ok Uni.new(0x0173).NFKC.list ~~ (0x0173,), '0173 -> 0173';
ok Uni.new(0x0174).NFKC.list ~~ (0x0174,), '0174 -> 0174';
ok Uni.new(0x0175).NFKC.list ~~ (0x0175,), '0175 -> 0175';
ok Uni.new(0x0176).NFKC.list ~~ (0x0176,), '0176 -> 0176';
ok Uni.new(0x0177).NFKC.list ~~ (0x0177,), '0177 -> 0177';
ok Uni.new(0x0178).NFKC.list ~~ (0x0178,), '0178 -> 0178';
ok Uni.new(0x0179).NFKC.list ~~ (0x0179,), '0179 -> 0179';
ok Uni.new(0x017A).NFKC.list ~~ (0x017A,), '017A -> 017A';
ok Uni.new(0x017B).NFKC.list ~~ (0x017B,), '017B -> 017B';
ok Uni.new(0x017C).NFKC.list ~~ (0x017C,), '017C -> 017C';
ok Uni.new(0x017D).NFKC.list ~~ (0x017D,), '017D -> 017D';
ok Uni.new(0x017E).NFKC.list ~~ (0x017E,), '017E -> 017E';
ok Uni.new(0x017F).NFKC.list ~~ (0x0073,), '017F -> 0073';
ok Uni.new(0x01A0).NFKC.list ~~ (0x01A0,), '01A0 -> 01A0';
ok Uni.new(0x01A1).NFKC.list ~~ (0x01A1,), '01A1 -> 01A1';
ok Uni.new(0x01AF).NFKC.list ~~ (0x01AF,), '01AF -> 01AF';
ok Uni.new(0x01B0).NFKC.list ~~ (0x01B0,), '01B0 -> 01B0';
ok Uni.new(0x01C4).NFKC.list ~~ (0x0044, 0x017D,), '01C4 -> 0044 017D';
ok Uni.new(0x01C5).NFKC.list ~~ (0x0044, 0x017E,), '01C5 -> 0044 017E';
ok Uni.new(0x01C6).NFKC.list ~~ (0x0064, 0x017E,), '01C6 -> 0064 017E';
ok Uni.new(0x01C7).NFKC.list ~~ (0x004C, 0x004A,), '01C7 -> 004C 004A';
ok Uni.new(0x01C8).NFKC.list ~~ (0x004C, 0x006A,), '01C8 -> 004C 006A';
ok Uni.new(0x01C9).NFKC.list ~~ (0x006C, 0x006A,), '01C9 -> 006C 006A';
ok Uni.new(0x01CA).NFKC.list ~~ (0x004E, 0x004A,), '01CA -> 004E 004A';
ok Uni.new(0x01CB).NFKC.list ~~ (0x004E, 0x006A,), '01CB -> 004E 006A';
ok Uni.new(0x01CC).NFKC.list ~~ (0x006E, 0x006A,), '01CC -> 006E 006A';
ok Uni.new(0x01CD).NFKC.list ~~ (0x01CD,), '01CD -> 01CD';
ok Uni.new(0x01CE).NFKC.list ~~ (0x01CE,), '01CE -> 01CE';
ok Uni.new(0x01CF).NFKC.list ~~ (0x01CF,), '01CF -> 01CF';
ok Uni.new(0x01D0).NFKC.list ~~ (0x01D0,), '01D0 -> 01D0';
ok Uni.new(0x01D1).NFKC.list ~~ (0x01D1,), '01D1 -> 01D1';
ok Uni.new(0x01D2).NFKC.list ~~ (0x01D2,), '01D2 -> 01D2';
ok Uni.new(0x01D3).NFKC.list ~~ (0x01D3,), '01D3 -> 01D3';
ok Uni.new(0x01D4).NFKC.list ~~ (0x01D4,), '01D4 -> 01D4';
ok Uni.new(0x01D5).NFKC.list ~~ (0x01D5,), '01D5 -> 01D5';
ok Uni.new(0x01D6).NFKC.list ~~ (0x01D6,), '01D6 -> 01D6';
ok Uni.new(0x01D7).NFKC.list ~~ (0x01D7,), '01D7 -> 01D7';
ok Uni.new(0x01D8).NFKC.list ~~ (0x01D8,), '01D8 -> 01D8';
ok Uni.new(0x01D9).NFKC.list ~~ (0x01D9,), '01D9 -> 01D9';
ok Uni.new(0x01DA).NFKC.list ~~ (0x01DA,), '01DA -> 01DA';
ok Uni.new(0x01DB).NFKC.list ~~ (0x01DB,), '01DB -> 01DB';
ok Uni.new(0x01DC).NFKC.list ~~ (0x01DC,), '01DC -> 01DC';
ok Uni.new(0x01DE).NFKC.list ~~ (0x01DE,), '01DE -> 01DE';
ok Uni.new(0x01DF).NFKC.list ~~ (0x01DF,), '01DF -> 01DF';
ok Uni.new(0x01E0).NFKC.list ~~ (0x01E0,), '01E0 -> 01E0';
ok Uni.new(0x01E1).NFKC.list ~~ (0x01E1,), '01E1 -> 01E1';
ok Uni.new(0x01E2).NFKC.list ~~ (0x01E2,), '01E2 -> 01E2';
ok Uni.new(0x01E3).NFKC.list ~~ (0x01E3,), '01E3 -> 01E3';
ok Uni.new(0x01E6).NFKC.list ~~ (0x01E6,), '01E6 -> 01E6';
ok Uni.new(0x01E7).NFKC.list ~~ (0x01E7,), '01E7 -> 01E7';
ok Uni.new(0x01E8).NFKC.list ~~ (0x01E8,), '01E8 -> 01E8';
ok Uni.new(0x01E9).NFKC.list ~~ (0x01E9,), '01E9 -> 01E9';
ok Uni.new(0x01EA).NFKC.list ~~ (0x01EA,), '01EA -> 01EA';
ok Uni.new(0x01EB).NFKC.list ~~ (0x01EB,), '01EB -> 01EB';
ok Uni.new(0x01EC).NFKC.list ~~ (0x01EC,), '01EC -> 01EC';
ok Uni.new(0x01ED).NFKC.list ~~ (0x01ED,), '01ED -> 01ED';
ok Uni.new(0x01EE).NFKC.list ~~ (0x01EE,), '01EE -> 01EE';
ok Uni.new(0x01EF).NFKC.list ~~ (0x01EF,), '01EF -> 01EF';
ok Uni.new(0x01F0).NFKC.list ~~ (0x01F0,), '01F0 -> 01F0';
ok Uni.new(0x01F1).NFKC.list ~~ (0x0044, 0x005A,), '01F1 -> 0044 005A';
ok Uni.new(0x01F2).NFKC.list ~~ (0x0044, 0x007A,), '01F2 -> 0044 007A';
ok Uni.new(0x01F3).NFKC.list ~~ (0x0064, 0x007A,), '01F3 -> 0064 007A';
ok Uni.new(0x01F4).NFKC.list ~~ (0x01F4,), '01F4 -> 01F4';
ok Uni.new(0x01F5).NFKC.list ~~ (0x01F5,), '01F5 -> 01F5';
ok Uni.new(0x01F8).NFKC.list ~~ (0x01F8,), '01F8 -> 01F8';
ok Uni.new(0x01F9).NFKC.list ~~ (0x01F9,), '01F9 -> 01F9';
ok Uni.new(0x01FA).NFKC.list ~~ (0x01FA,), '01FA -> 01FA';
ok Uni.new(0x01FB).NFKC.list ~~ (0x01FB,), '01FB -> 01FB';
ok Uni.new(0x01FC).NFKC.list ~~ (0x01FC,), '01FC -> 01FC';
ok Uni.new(0x01FD).NFKC.list ~~ (0x01FD,), '01FD -> 01FD';
ok Uni.new(0x01FE).NFKC.list ~~ (0x01FE,), '01FE -> 01FE';
ok Uni.new(0x01FF).NFKC.list ~~ (0x01FF,), '01FF -> 01FF';
ok Uni.new(0x0200).NFKC.list ~~ (0x0200,), '0200 -> 0200';
ok Uni.new(0x0201).NFKC.list ~~ (0x0201,), '0201 -> 0201';
ok Uni.new(0x0202).NFKC.list ~~ (0x0202,), '0202 -> 0202';
ok Uni.new(0x0203).NFKC.list ~~ (0x0203,), '0203 -> 0203';
ok Uni.new(0x0204).NFKC.list ~~ (0x0204,), '0204 -> 0204';
ok Uni.new(0x0205).NFKC.list ~~ (0x0205,), '0205 -> 0205';
ok Uni.new(0x0206).NFKC.list ~~ (0x0206,), '0206 -> 0206';
ok Uni.new(0x0207).NFKC.list ~~ (0x0207,), '0207 -> 0207';
ok Uni.new(0x0208).NFKC.list ~~ (0x0208,), '0208 -> 0208';
ok Uni.new(0x0209).NFKC.list ~~ (0x0209,), '0209 -> 0209';
ok Uni.new(0x020A).NFKC.list ~~ (0x020A,), '020A -> 020A';
ok Uni.new(0x020B).NFKC.list ~~ (0x020B,), '020B -> 020B';
ok Uni.new(0x020C).NFKC.list ~~ (0x020C,), '020C -> 020C';
ok Uni.new(0x020D).NFKC.list ~~ (0x020D,), '020D -> 020D';
ok Uni.new(0x020E).NFKC.list ~~ (0x020E,), '020E -> 020E';
ok Uni.new(0x020F).NFKC.list ~~ (0x020F,), '020F -> 020F';
ok Uni.new(0x0210).NFKC.list ~~ (0x0210,), '0210 -> 0210';
ok Uni.new(0x0211).NFKC.list ~~ (0x0211,), '0211 -> 0211';
ok Uni.new(0x0212).NFKC.list ~~ (0x0212,), '0212 -> 0212';
ok Uni.new(0x0213).NFKC.list ~~ (0x0213,), '0213 -> 0213';
ok Uni.new(0x0214).NFKC.list ~~ (0x0214,), '0214 -> 0214';
ok Uni.new(0x0215).NFKC.list ~~ (0x0215,), '0215 -> 0215';
ok Uni.new(0x0216).NFKC.list ~~ (0x0216,), '0216 -> 0216';
ok Uni.new(0x0217).NFKC.list ~~ (0x0217,), '0217 -> 0217';
ok Uni.new(0x0218).NFKC.list ~~ (0x0218,), '0218 -> 0218';
ok Uni.new(0x0219).NFKC.list ~~ (0x0219,), '0219 -> 0219';
ok Uni.new(0x021A).NFKC.list ~~ (0x021A,), '021A -> 021A';
ok Uni.new(0x021B).NFKC.list ~~ (0x021B,), '021B -> 021B';
ok Uni.new(0x021E).NFKC.list ~~ (0x021E,), '021E -> 021E';
ok Uni.new(0x021F).NFKC.list ~~ (0x021F,), '021F -> 021F';
ok Uni.new(0x0226).NFKC.list ~~ (0x0226,), '0226 -> 0226';
ok Uni.new(0x0227).NFKC.list ~~ (0x0227,), '0227 -> 0227';
ok Uni.new(0x0228).NFKC.list ~~ (0x0228,), '0228 -> 0228';
ok Uni.new(0x0229).NFKC.list ~~ (0x0229,), '0229 -> 0229';
ok Uni.new(0x022A).NFKC.list ~~ (0x022A,), '022A -> 022A';
ok Uni.new(0x022B).NFKC.list ~~ (0x022B,), '022B -> 022B';
ok Uni.new(0x022C).NFKC.list ~~ (0x022C,), '022C -> 022C';
ok Uni.new(0x022D).NFKC.list ~~ (0x022D,), '022D -> 022D';
ok Uni.new(0x022E).NFKC.list ~~ (0x022E,), '022E -> 022E';
ok Uni.new(0x022F).NFKC.list ~~ (0x022F,), '022F -> 022F';
ok Uni.new(0x0230).NFKC.list ~~ (0x0230,), '0230 -> 0230';
ok Uni.new(0x0231).NFKC.list ~~ (0x0231,), '0231 -> 0231';
ok Uni.new(0x0232).NFKC.list ~~ (0x0232,), '0232 -> 0232';
ok Uni.new(0x0233).NFKC.list ~~ (0x0233,), '0233 -> 0233';
ok Uni.new(0x02B0).NFKC.list ~~ (0x0068,), '02B0 -> 0068';
ok Uni.new(0x02B1).NFKC.list ~~ (0x0266,), '02B1 -> 0266';
ok Uni.new(0x02B2).NFKC.list ~~ (0x006A,), '02B2 -> 006A';
ok Uni.new(0x02B3).NFKC.list ~~ (0x0072,), '02B3 -> 0072';
ok Uni.new(0x02B4).NFKC.list ~~ (0x0279,), '02B4 -> 0279';
ok Uni.new(0x02B5).NFKC.list ~~ (0x027B,), '02B5 -> 027B';
ok Uni.new(0x02B6).NFKC.list ~~ (0x0281,), '02B6 -> 0281';
ok Uni.new(0x02B7).NFKC.list ~~ (0x0077,), '02B7 -> 0077';
ok Uni.new(0x02B8).NFKC.list ~~ (0x0079,), '02B8 -> 0079';
ok Uni.new(0x02D8).NFKC.list ~~ (0x0020, 0x0306,), '02D8 -> 0020 0306';
ok Uni.new(0x02D9).NFKC.list ~~ (0x0020, 0x0307,), '02D9 -> 0020 0307';
ok Uni.new(0x02DA).NFKC.list ~~ (0x0020, 0x030A,), '02DA -> 0020 030A';
ok Uni.new(0x02DB).NFKC.list ~~ (0x0020, 0x0328,), '02DB -> 0020 0328';
ok Uni.new(0x02DC).NFKC.list ~~ (0x0020, 0x0303,), '02DC -> 0020 0303';
ok Uni.new(0x02DD).NFKC.list ~~ (0x0020, 0x030B,), '02DD -> 0020 030B';
ok Uni.new(0x02E0).NFKC.list ~~ (0x0263,), '02E0 -> 0263';
ok Uni.new(0x02E1).NFKC.list ~~ (0x006C,), '02E1 -> 006C';
ok Uni.new(0x02E2).NFKC.list ~~ (0x0073,), '02E2 -> 0073';
ok Uni.new(0x02E3).NFKC.list ~~ (0x0078,), '02E3 -> 0078';
ok Uni.new(0x02E4).NFKC.list ~~ (0x0295,), '02E4 -> 0295';
ok Uni.new(0x0340).NFKC.list ~~ (0x0300,), '0340 -> 0300';
ok Uni.new(0x0341).NFKC.list ~~ (0x0301,), '0341 -> 0301';
ok Uni.new(0x0343).NFKC.list ~~ (0x0313,), '0343 -> 0313';
ok Uni.new(0x0344).NFKC.list ~~ (0x0308, 0x0301,), '0344 -> 0308 0301';
ok Uni.new(0x0374).NFKC.list ~~ (0x02B9,), '0374 -> 02B9';
ok Uni.new(0x037A).NFKC.list ~~ (0x0020, 0x0345,), '037A -> 0020 0345';
ok Uni.new(0x037E).NFKC.list ~~ (0x003B,), '037E -> 003B';
ok Uni.new(0x0384).NFKC.list ~~ (0x0020, 0x0301,), '0384 -> 0020 0301';
ok Uni.new(0x0385).NFKC.list ~~ (0x0020, 0x0308, 0x0301,), '0385 -> 0020 0308 0301';
ok Uni.new(0x0386).NFKC.list ~~ (0x0386,), '0386 -> 0386';
ok Uni.new(0x0387).NFKC.list ~~ (0x00B7,), '0387 -> 00B7';
ok Uni.new(0x0388).NFKC.list ~~ (0x0388,), '0388 -> 0388';
ok Uni.new(0x0389).NFKC.list ~~ (0x0389,), '0389 -> 0389';
ok Uni.new(0x038A).NFKC.list ~~ (0x038A,), '038A -> 038A';
ok Uni.new(0x038C).NFKC.list ~~ (0x038C,), '038C -> 038C';
ok Uni.new(0x038E).NFKC.list ~~ (0x038E,), '038E -> 038E';
ok Uni.new(0x038F).NFKC.list ~~ (0x038F,), '038F -> 038F';
ok Uni.new(0x0390).NFKC.list ~~ (0x0390,), '0390 -> 0390';
ok Uni.new(0x03AA).NFKC.list ~~ (0x03AA,), '03AA -> 03AA';
ok Uni.new(0x03AB).NFKC.list ~~ (0x03AB,), '03AB -> 03AB';
ok Uni.new(0x03AC).NFKC.list ~~ (0x03AC,), '03AC -> 03AC';
ok Uni.new(0x03AD).NFKC.list ~~ (0x03AD,), '03AD -> 03AD';
ok Uni.new(0x03AE).NFKC.list ~~ (0x03AE,), '03AE -> 03AE';
ok Uni.new(0x03AF).NFKC.list ~~ (0x03AF,), '03AF -> 03AF';
ok Uni.new(0x03B0).NFKC.list ~~ (0x03B0,), '03B0 -> 03B0';
ok Uni.new(0x03CA).NFKC.list ~~ (0x03CA,), '03CA -> 03CA';
ok Uni.new(0x03CB).NFKC.list ~~ (0x03CB,), '03CB -> 03CB';
ok Uni.new(0x03CC).NFKC.list ~~ (0x03CC,), '03CC -> 03CC';
ok Uni.new(0x03CD).NFKC.list ~~ (0x03CD,), '03CD -> 03CD';
ok Uni.new(0x03CE).NFKC.list ~~ (0x03CE,), '03CE -> 03CE';
ok Uni.new(0x03D0).NFKC.list ~~ (0x03B2,), '03D0 -> 03B2';
ok Uni.new(0x03D1).NFKC.list ~~ (0x03B8,), '03D1 -> 03B8';
ok Uni.new(0x03D2).NFKC.list ~~ (0x03A5,), '03D2 -> 03A5';
ok Uni.new(0x03D3).NFKC.list ~~ (0x038E,), '03D3 -> 038E';
ok Uni.new(0x03D4).NFKC.list ~~ (0x03AB,), '03D4 -> 03AB';
ok Uni.new(0x03D5).NFKC.list ~~ (0x03C6,), '03D5 -> 03C6';
ok Uni.new(0x03D6).NFKC.list ~~ (0x03C0,), '03D6 -> 03C0';
ok Uni.new(0x03F0).NFKC.list ~~ (0x03BA,), '03F0 -> 03BA';
ok Uni.new(0x03F1).NFKC.list ~~ (0x03C1,), '03F1 -> 03C1';
ok Uni.new(0x03F2).NFKC.list ~~ (0x03C2,), '03F2 -> 03C2';
ok Uni.new(0x03F4).NFKC.list ~~ (0x0398,), '03F4 -> 0398';
ok Uni.new(0x03F5).NFKC.list ~~ (0x03B5,), '03F5 -> 03B5';
ok Uni.new(0x03F9).NFKC.list ~~ (0x03A3,), '03F9 -> 03A3';
ok Uni.new(0x0400).NFKC.list ~~ (0x0400,), '0400 -> 0400';
ok Uni.new(0x0401).NFKC.list ~~ (0x0401,), '0401 -> 0401';
ok Uni.new(0x0403).NFKC.list ~~ (0x0403,), '0403 -> 0403';
ok Uni.new(0x0407).NFKC.list ~~ (0x0407,), '0407 -> 0407';
ok Uni.new(0x040C).NFKC.list ~~ (0x040C,), '040C -> 040C';
ok Uni.new(0x040D).NFKC.list ~~ (0x040D,), '040D -> 040D';
ok Uni.new(0x040E).NFKC.list ~~ (0x040E,), '040E -> 040E';
ok Uni.new(0x0419).NFKC.list ~~ (0x0419,), '0419 -> 0419';
ok Uni.new(0x0439).NFKC.list ~~ (0x0439,), '0439 -> 0439';
ok Uni.new(0x0450).NFKC.list ~~ (0x0450,), '0450 -> 0450';
ok Uni.new(0x0451).NFKC.list ~~ (0x0451,), '0451 -> 0451';
ok Uni.new(0x0453).NFKC.list ~~ (0x0453,), '0453 -> 0453';
ok Uni.new(0x0457).NFKC.list ~~ (0x0457,), '0457 -> 0457';
ok Uni.new(0x045C).NFKC.list ~~ (0x045C,), '045C -> 045C';
ok Uni.new(0x045D).NFKC.list ~~ (0x045D,), '045D -> 045D';
ok Uni.new(0x045E).NFKC.list ~~ (0x045E,), '045E -> 045E';
ok Uni.new(0x0476).NFKC.list ~~ (0x0476,), '0476 -> 0476';
ok Uni.new(0x0477).NFKC.list ~~ (0x0477,), '0477 -> 0477';
ok Uni.new(0x04C1).NFKC.list ~~ (0x04C1,), '04C1 -> 04C1';
ok Uni.new(0x04C2).NFKC.list ~~ (0x04C2,), '04C2 -> 04C2';
ok Uni.new(0x04D0).NFKC.list ~~ (0x04D0,), '04D0 -> 04D0';
ok Uni.new(0x04D1).NFKC.list ~~ (0x04D1,), '04D1 -> 04D1';
ok Uni.new(0x04D2).NFKC.list ~~ (0x04D2,), '04D2 -> 04D2';
ok Uni.new(0x04D3).NFKC.list ~~ (0x04D3,), '04D3 -> 04D3';
ok Uni.new(0x04D6).NFKC.list ~~ (0x04D6,), '04D6 -> 04D6';
ok Uni.new(0x04D7).NFKC.list ~~ (0x04D7,), '04D7 -> 04D7';
ok Uni.new(0x04DA).NFKC.list ~~ (0x04DA,), '04DA -> 04DA';
ok Uni.new(0x04DB).NFKC.list ~~ (0x04DB,), '04DB -> 04DB';
ok Uni.new(0x04DC).NFKC.list ~~ (0x04DC,), '04DC -> 04DC';
ok Uni.new(0x04DD).NFKC.list ~~ (0x04DD,), '04DD -> 04DD';
ok Uni.new(0x04DE).NFKC.list ~~ (0x04DE,), '04DE -> 04DE';
ok Uni.new(0x04DF).NFKC.list ~~ (0x04DF,), '04DF -> 04DF';
ok Uni.new(0x04E2).NFKC.list ~~ (0x04E2,), '04E2 -> 04E2';
ok Uni.new(0x04E3).NFKC.list ~~ (0x04E3,), '04E3 -> 04E3';
ok Uni.new(0x04E4).NFKC.list ~~ (0x04E4,), '04E4 -> 04E4';
ok Uni.new(0x04E5).NFKC.list ~~ (0x04E5,), '04E5 -> 04E5';
ok Uni.new(0x04E6).NFKC.list ~~ (0x04E6,), '04E6 -> 04E6';
ok Uni.new(0x04E7).NFKC.list ~~ (0x04E7,), '04E7 -> 04E7';
ok Uni.new(0x04EA).NFKC.list ~~ (0x04EA,), '04EA -> 04EA';
ok Uni.new(0x04EB).NFKC.list ~~ (0x04EB,), '04EB -> 04EB';
ok Uni.new(0x04EC).NFKC.list ~~ (0x04EC,), '04EC -> 04EC';
ok Uni.new(0x04ED).NFKC.list ~~ (0x04ED,), '04ED -> 04ED';
ok Uni.new(0x04EE).NFKC.list ~~ (0x04EE,), '04EE -> 04EE';
ok Uni.new(0x04EF).NFKC.list ~~ (0x04EF,), '04EF -> 04EF';
ok Uni.new(0x04F0).NFKC.list ~~ (0x04F0,), '04F0 -> 04F0';
ok Uni.new(0x04F1).NFKC.list ~~ (0x04F1,), '04F1 -> 04F1';
ok Uni.new(0x04F2).NFKC.list ~~ (0x04F2,), '04F2 -> 04F2';
ok Uni.new(0x04F3).NFKC.list ~~ (0x04F3,), '04F3 -> 04F3';
ok Uni.new(0x04F4).NFKC.list ~~ (0x04F4,), '04F4 -> 04F4';
ok Uni.new(0x04F5).NFKC.list ~~ (0x04F5,), '04F5 -> 04F5';
ok Uni.new(0x04F8).NFKC.list ~~ (0x04F8,), '04F8 -> 04F8';
ok Uni.new(0x04F9).NFKC.list ~~ (0x04F9,), '04F9 -> 04F9';
ok Uni.new(0x0587).NFKC.list ~~ (0x0565, 0x0582,), '0587 -> 0565 0582';
ok Uni.new(0x0622).NFKC.list ~~ (0x0622,), '0622 -> 0622';
ok Uni.new(0x0623).NFKC.list ~~ (0x0623,), '0623 -> 0623';
ok Uni.new(0x0624).NFKC.list ~~ (0x0624,), '0624 -> 0624';
ok Uni.new(0x0625).NFKC.list ~~ (0x0625,), '0625 -> 0625';
ok Uni.new(0x0626).NFKC.list ~~ (0x0626,), '0626 -> 0626';
ok Uni.new(0x0675).NFKC.list ~~ (0x0627, 0x0674,), '0675 -> 0627 0674';
ok Uni.new(0x0676).NFKC.list ~~ (0x0648, 0x0674,), '0676 -> 0648 0674';
ok Uni.new(0x0677).NFKC.list ~~ (0x06C7, 0x0674,), '0677 -> 06C7 0674';
ok Uni.new(0x0678).NFKC.list ~~ (0x064A, 0x0674,), '0678 -> 064A 0674';
ok Uni.new(0x06C0).NFKC.list ~~ (0x06C0,), '06C0 -> 06C0';
ok Uni.new(0x06C2).NFKC.list ~~ (0x06C2,), '06C2 -> 06C2';
ok Uni.new(0x06D3).NFKC.list ~~ (0x06D3,), '06D3 -> 06D3';
ok Uni.new(0x0929).NFKC.list ~~ (0x0929,), '0929 -> 0929';
ok Uni.new(0x0931).NFKC.list ~~ (0x0931,), '0931 -> 0931';
ok Uni.new(0x0934).NFKC.list ~~ (0x0934,), '0934 -> 0934';
ok Uni.new(0x0958).NFKC.list ~~ (0x0915, 0x093C,), '0958 -> 0915 093C';
ok Uni.new(0x0959).NFKC.list ~~ (0x0916, 0x093C,), '0959 -> 0916 093C';
ok Uni.new(0x095A).NFKC.list ~~ (0x0917, 0x093C,), '095A -> 0917 093C';
ok Uni.new(0x095B).NFKC.list ~~ (0x091C, 0x093C,), '095B -> 091C 093C';
ok Uni.new(0x095C).NFKC.list ~~ (0x0921, 0x093C,), '095C -> 0921 093C';
ok Uni.new(0x095D).NFKC.list ~~ (0x0922, 0x093C,), '095D -> 0922 093C';
ok Uni.new(0x095E).NFKC.list ~~ (0x092B, 0x093C,), '095E -> 092B 093C';
ok Uni.new(0x095F).NFKC.list ~~ (0x092F, 0x093C,), '095F -> 092F 093C';
ok Uni.new(0x09CB).NFKC.list ~~ (0x09CB,), '09CB -> 09CB';
ok Uni.new(0x09CC).NFKC.list ~~ (0x09CC,), '09CC -> 09CC';
ok Uni.new(0x09DC).NFKC.list ~~ (0x09A1, 0x09BC,), '09DC -> 09A1 09BC';
ok Uni.new(0x09DD).NFKC.list ~~ (0x09A2, 0x09BC,), '09DD -> 09A2 09BC';
ok Uni.new(0x09DF).NFKC.list ~~ (0x09AF, 0x09BC,), '09DF -> 09AF 09BC';
ok Uni.new(0x0A33).NFKC.list ~~ (0x0A32, 0x0A3C,), '0A33 -> 0A32 0A3C';
ok Uni.new(0x0A36).NFKC.list ~~ (0x0A38, 0x0A3C,), '0A36 -> 0A38 0A3C';
ok Uni.new(0x0A59).NFKC.list ~~ (0x0A16, 0x0A3C,), '0A59 -> 0A16 0A3C';
ok Uni.new(0x0A5A).NFKC.list ~~ (0x0A17, 0x0A3C,), '0A5A -> 0A17 0A3C';
ok Uni.new(0x0A5B).NFKC.list ~~ (0x0A1C, 0x0A3C,), '0A5B -> 0A1C 0A3C';
ok Uni.new(0x0A5E).NFKC.list ~~ (0x0A2B, 0x0A3C,), '0A5E -> 0A2B 0A3C';
ok Uni.new(0x0B48).NFKC.list ~~ (0x0B48,), '0B48 -> 0B48';
ok Uni.new(0x0B4B).NFKC.list ~~ (0x0B4B,), '0B4B -> 0B4B';
ok Uni.new(0x0B4C).NFKC.list ~~ (0x0B4C,), '0B4C -> 0B4C';
ok Uni.new(0x0B5C).NFKC.list ~~ (0x0B21, 0x0B3C,), '0B5C -> 0B21 0B3C';
ok Uni.new(0x0B5D).NFKC.list ~~ (0x0B22, 0x0B3C,), '0B5D -> 0B22 0B3C';
ok Uni.new(0x0B94).NFKC.list ~~ (0x0B94,), '0B94 -> 0B94';
ok Uni.new(0x0BCA).NFKC.list ~~ (0x0BCA,), '0BCA -> 0BCA';
ok Uni.new(0x0BCB).NFKC.list ~~ (0x0BCB,), '0BCB -> 0BCB';
ok Uni.new(0x0BCC).NFKC.list ~~ (0x0BCC,), '0BCC -> 0BCC';
ok Uni.new(0x0C48).NFKC.list ~~ (0x0C48,), '0C48 -> 0C48';
ok Uni.new(0x0CC0).NFKC.list ~~ (0x0CC0,), '0CC0 -> 0CC0';
ok Uni.new(0x0CC7).NFKC.list ~~ (0x0CC7,), '0CC7 -> 0CC7';
ok Uni.new(0x0CC8).NFKC.list ~~ (0x0CC8,), '0CC8 -> 0CC8';
ok Uni.new(0x0CCA).NFKC.list ~~ (0x0CCA,), '0CCA -> 0CCA';
ok Uni.new(0x0CCB).NFKC.list ~~ (0x0CCB,), '0CCB -> 0CCB';
ok Uni.new(0x0D4A).NFKC.list ~~ (0x0D4A,), '0D4A -> 0D4A';
ok Uni.new(0x0D4B).NFKC.list ~~ (0x0D4B,), '0D4B -> 0D4B';
ok Uni.new(0x0D4C).NFKC.list ~~ (0x0D4C,), '0D4C -> 0D4C';
ok Uni.new(0x0DDA).NFKC.list ~~ (0x0DDA,), '0DDA -> 0DDA';
ok Uni.new(0x0DDC).NFKC.list ~~ (0x0DDC,), '0DDC -> 0DDC';
ok Uni.new(0x0DDD).NFKC.list ~~ (0x0DDD,), '0DDD -> 0DDD';
ok Uni.new(0x0DDE).NFKC.list ~~ (0x0DDE,), '0DDE -> 0DDE';
ok Uni.new(0x0E33).NFKC.list ~~ (0x0E4D, 0x0E32,), '0E33 -> 0E4D 0E32';
ok Uni.new(0x0EB3).NFKC.list ~~ (0x0ECD, 0x0EB2,), '0EB3 -> 0ECD 0EB2';
ok Uni.new(0x0EDC).NFKC.list ~~ (0x0EAB, 0x0E99,), '0EDC -> 0EAB 0E99';
ok Uni.new(0x0EDD).NFKC.list ~~ (0x0EAB, 0x0EA1,), '0EDD -> 0EAB 0EA1';
ok Uni.new(0x0F0C).NFKC.list ~~ (0x0F0B,), '0F0C -> 0F0B';
ok Uni.new(0x0F43).NFKC.list ~~ (0x0F42, 0x0FB7,), '0F43 -> 0F42 0FB7';
ok Uni.new(0x0F4D).NFKC.list ~~ (0x0F4C, 0x0FB7,), '0F4D -> 0F4C 0FB7';
ok Uni.new(0x0F52).NFKC.list ~~ (0x0F51, 0x0FB7,), '0F52 -> 0F51 0FB7';
ok Uni.new(0x0F57).NFKC.list ~~ (0x0F56, 0x0FB7,), '0F57 -> 0F56 0FB7';
ok Uni.new(0x0F5C).NFKC.list ~~ (0x0F5B, 0x0FB7,), '0F5C -> 0F5B 0FB7';
ok Uni.new(0x0F69).NFKC.list ~~ (0x0F40, 0x0FB5,), '0F69 -> 0F40 0FB5';
ok Uni.new(0x0F73).NFKC.list ~~ (0x0F71, 0x0F72,), '0F73 -> 0F71 0F72';
ok Uni.new(0x0F75).NFKC.list ~~ (0x0F71, 0x0F74,), '0F75 -> 0F71 0F74';
ok Uni.new(0x0F76).NFKC.list ~~ (0x0FB2, 0x0F80,), '0F76 -> 0FB2 0F80';
ok Uni.new(0x0F77).NFKC.list ~~ (0x0FB2, 0x0F71, 0x0F80,), '0F77 -> 0FB2 0F71 0F80';
ok Uni.new(0x0F78).NFKC.list ~~ (0x0FB3, 0x0F80,), '0F78 -> 0FB3 0F80';
ok Uni.new(0x0F79).NFKC.list ~~ (0x0FB3, 0x0F71, 0x0F80,), '0F79 -> 0FB3 0F71 0F80';
ok Uni.new(0x0F81).NFKC.list ~~ (0x0F71, 0x0F80,), '0F81 -> 0F71 0F80';
ok Uni.new(0x0F93).NFKC.list ~~ (0x0F92, 0x0FB7,), '0F93 -> 0F92 0FB7';
ok Uni.new(0x0F9D).NFKC.list ~~ (0x0F9C, 0x0FB7,), '0F9D -> 0F9C 0FB7';
ok Uni.new(0x0FA2).NFKC.list ~~ (0x0FA1, 0x0FB7,), '0FA2 -> 0FA1 0FB7';
ok Uni.new(0x0FA7).NFKC.list ~~ (0x0FA6, 0x0FB7,), '0FA7 -> 0FA6 0FB7';
ok Uni.new(0x0FAC).NFKC.list ~~ (0x0FAB, 0x0FB7,), '0FAC -> 0FAB 0FB7';
ok Uni.new(0x0FB9).NFKC.list ~~ (0x0F90, 0x0FB5,), '0FB9 -> 0F90 0FB5';
ok Uni.new(0x1026).NFKC.list ~~ (0x1026,), '1026 -> 1026';
ok Uni.new(0x10FC).NFKC.list ~~ (0x10DC,), '10FC -> 10DC';
ok Uni.new(0x1B06).NFKC.list ~~ (0x1B06,), '1B06 -> 1B06';
ok Uni.new(0x1B08).NFKC.list ~~ (0x1B08,), '1B08 -> 1B08';
ok Uni.new(0x1B0A).NFKC.list ~~ (0x1B0A,), '1B0A -> 1B0A';
ok Uni.new(0x1B0C).NFKC.list ~~ (0x1B0C,), '1B0C -> 1B0C';
ok Uni.new(0x1B0E).NFKC.list ~~ (0x1B0E,), '1B0E -> 1B0E';
ok Uni.new(0x1B12).NFKC.list ~~ (0x1B12,), '1B12 -> 1B12';
ok Uni.new(0x1B3B).NFKC.list ~~ (0x1B3B,), '1B3B -> 1B3B';
ok Uni.new(0x1B3D).NFKC.list ~~ (0x1B3D,), '1B3D -> 1B3D';
ok Uni.new(0x1B40).NFKC.list ~~ (0x1B40,), '1B40 -> 1B40';
ok Uni.new(0x1B41).NFKC.list ~~ (0x1B41,), '1B41 -> 1B41';
ok Uni.new(0x1B43).NFKC.list ~~ (0x1B43,), '1B43 -> 1B43';
ok Uni.new(0x1D2C).NFKC.list ~~ (0x0041,), '1D2C -> 0041';
ok Uni.new(0x1D2D).NFKC.list ~~ (0x00C6,), '1D2D -> 00C6';
ok Uni.new(0x1D2E).NFKC.list ~~ (0x0042,), '1D2E -> 0042';
ok Uni.new(0x1D30).NFKC.list ~~ (0x0044,), '1D30 -> 0044';
ok Uni.new(0x1D31).NFKC.list ~~ (0x0045,), '1D31 -> 0045';
ok Uni.new(0x1D32).NFKC.list ~~ (0x018E,), '1D32 -> 018E';
ok Uni.new(0x1D33).NFKC.list ~~ (0x0047,), '1D33 -> 0047';
ok Uni.new(0x1D34).NFKC.list ~~ (0x0048,), '1D34 -> 0048';
ok Uni.new(0x1D35).NFKC.list ~~ (0x0049,), '1D35 -> 0049';
ok Uni.new(0x1D36).NFKC.list ~~ (0x004A,), '1D36 -> 004A';
ok Uni.new(0x1D37).NFKC.list ~~ (0x004B,), '1D37 -> 004B';
ok Uni.new(0x1D38).NFKC.list ~~ (0x004C,), '1D38 -> 004C';
ok Uni.new(0x1D39).NFKC.list ~~ (0x004D,), '1D39 -> 004D';
ok Uni.new(0x1D3A).NFKC.list ~~ (0x004E,), '1D3A -> 004E';
ok Uni.new(0x1D3C).NFKC.list ~~ (0x004F,), '1D3C -> 004F';
ok Uni.new(0x1D3D).NFKC.list ~~ (0x0222,), '1D3D -> 0222';
ok Uni.new(0x1D3E).NFKC.list ~~ (0x0050,), '1D3E -> 0050';
ok Uni.new(0x1D3F).NFKC.list ~~ (0x0052,), '1D3F -> 0052';
ok Uni.new(0x1D40).NFKC.list ~~ (0x0054,), '1D40 -> 0054';
ok Uni.new(0x1D41).NFKC.list ~~ (0x0055,), '1D41 -> 0055';
ok Uni.new(0x1D42).NFKC.list ~~ (0x0057,), '1D42 -> 0057';
ok Uni.new(0x1D43).NFKC.list ~~ (0x0061,), '1D43 -> 0061';
ok Uni.new(0x1D44).NFKC.list ~~ (0x0250,), '1D44 -> 0250';
ok Uni.new(0x1D45).NFKC.list ~~ (0x0251,), '1D45 -> 0251';
ok Uni.new(0x1D46).NFKC.list ~~ (0x1D02,), '1D46 -> 1D02';
ok Uni.new(0x1D47).NFKC.list ~~ (0x0062,), '1D47 -> 0062';
ok Uni.new(0x1D48).NFKC.list ~~ (0x0064,), '1D48 -> 0064';
ok Uni.new(0x1D49).NFKC.list ~~ (0x0065,), '1D49 -> 0065';
ok Uni.new(0x1D4A).NFKC.list ~~ (0x0259,), '1D4A -> 0259';
ok Uni.new(0x1D4B).NFKC.list ~~ (0x025B,), '1D4B -> 025B';
ok Uni.new(0x1D4C).NFKC.list ~~ (0x025C,), '1D4C -> 025C';
ok Uni.new(0x1D4D).NFKC.list ~~ (0x0067,), '1D4D -> 0067';
ok Uni.new(0x1D4F).NFKC.list ~~ (0x006B,), '1D4F -> 006B';
ok Uni.new(0x1D50).NFKC.list ~~ (0x006D,), '1D50 -> 006D';
ok Uni.new(0x1D51).NFKC.list ~~ (0x014B,), '1D51 -> 014B';
ok Uni.new(0x1D52).NFKC.list ~~ (0x006F,), '1D52 -> 006F';
ok Uni.new(0x1D53).NFKC.list ~~ (0x0254,), '1D53 -> 0254';
ok Uni.new(0x1D54).NFKC.list ~~ (0x1D16,), '1D54 -> 1D16';
ok Uni.new(0x1D55).NFKC.list ~~ (0x1D17,), '1D55 -> 1D17';
ok Uni.new(0x1D56).NFKC.list ~~ (0x0070,), '1D56 -> 0070';
ok Uni.new(0x1D57).NFKC.list ~~ (0x0074,), '1D57 -> 0074';
ok Uni.new(0x1D58).NFKC.list ~~ (0x0075,), '1D58 -> 0075';
ok Uni.new(0x1D59).NFKC.list ~~ (0x1D1D,), '1D59 -> 1D1D';
ok Uni.new(0x1D5A).NFKC.list ~~ (0x026F,), '1D5A -> 026F';
ok Uni.new(0x1D5B).NFKC.list ~~ (0x0076,), '1D5B -> 0076';
ok Uni.new(0x1D5C).NFKC.list ~~ (0x1D25,), '1D5C -> 1D25';
ok Uni.new(0x1D5D).NFKC.list ~~ (0x03B2,), '1D5D -> 03B2';
ok Uni.new(0x1D5E).NFKC.list ~~ (0x03B3,), '1D5E -> 03B3';
ok Uni.new(0x1D5F).NFKC.list ~~ (0x03B4,), '1D5F -> 03B4';
ok Uni.new(0x1D60).NFKC.list ~~ (0x03C6,), '1D60 -> 03C6';
ok Uni.new(0x1D61).NFKC.list ~~ (0x03C7,), '1D61 -> 03C7';
ok Uni.new(0x1D62).NFKC.list ~~ (0x0069,), '1D62 -> 0069';
ok Uni.new(0x1D63).NFKC.list ~~ (0x0072,), '1D63 -> 0072';
ok Uni.new(0x1D64).NFKC.list ~~ (0x0075,), '1D64 -> 0075';
ok Uni.new(0x1D65).NFKC.list ~~ (0x0076,), '1D65 -> 0076';
ok Uni.new(0x1D66).NFKC.list ~~ (0x03B2,), '1D66 -> 03B2';
ok Uni.new(0x1D67).NFKC.list ~~ (0x03B3,), '1D67 -> 03B3';
ok Uni.new(0x1D68).NFKC.list ~~ (0x03C1,), '1D68 -> 03C1';
ok Uni.new(0x1D69).NFKC.list ~~ (0x03C6,), '1D69 -> 03C6';
ok Uni.new(0x1D6A).NFKC.list ~~ (0x03C7,), '1D6A -> 03C7';
ok Uni.new(0x1D78).NFKC.list ~~ (0x043D,), '1D78 -> 043D';
ok Uni.new(0x1D9B).NFKC.list ~~ (0x0252,), '1D9B -> 0252';
ok Uni.new(0x1D9C).NFKC.list ~~ (0x0063,), '1D9C -> 0063';
ok Uni.new(0x1D9D).NFKC.list ~~ (0x0255,), '1D9D -> 0255';
ok Uni.new(0x1D9E).NFKC.list ~~ (0x00F0,), '1D9E -> 00F0';
ok Uni.new(0x1D9F).NFKC.list ~~ (0x025C,), '1D9F -> 025C';
ok Uni.new(0x1DA0).NFKC.list ~~ (0x0066,), '1DA0 -> 0066';
ok Uni.new(0x1DA1).NFKC.list ~~ (0x025F,), '1DA1 -> 025F';
ok Uni.new(0x1DA2).NFKC.list ~~ (0x0261,), '1DA2 -> 0261';
ok Uni.new(0x1DA3).NFKC.list ~~ (0x0265,), '1DA3 -> 0265';
ok Uni.new(0x1DA4).NFKC.list ~~ (0x0268,), '1DA4 -> 0268';
ok Uni.new(0x1DA5).NFKC.list ~~ (0x0269,), '1DA5 -> 0269';
ok Uni.new(0x1DA6).NFKC.list ~~ (0x026A,), '1DA6 -> 026A';
ok Uni.new(0x1DA7).NFKC.list ~~ (0x1D7B,), '1DA7 -> 1D7B';
ok Uni.new(0x1DA8).NFKC.list ~~ (0x029D,), '1DA8 -> 029D';
ok Uni.new(0x1DA9).NFKC.list ~~ (0x026D,), '1DA9 -> 026D';
ok Uni.new(0x1DAA).NFKC.list ~~ (0x1D85,), '1DAA -> 1D85';
ok Uni.new(0x1DAB).NFKC.list ~~ (0x029F,), '1DAB -> 029F';
ok Uni.new(0x1DAC).NFKC.list ~~ (0x0271,), '1DAC -> 0271';
ok Uni.new(0x1DAD).NFKC.list ~~ (0x0270,), '1DAD -> 0270';
ok Uni.new(0x1DAE).NFKC.list ~~ (0x0272,), '1DAE -> 0272';
ok Uni.new(0x1DAF).NFKC.list ~~ (0x0273,), '1DAF -> 0273';
ok Uni.new(0x1DB0).NFKC.list ~~ (0x0274,), '1DB0 -> 0274';
ok Uni.new(0x1DB1).NFKC.list ~~ (0x0275,), '1DB1 -> 0275';
ok Uni.new(0x1DB2).NFKC.list ~~ (0x0278,), '1DB2 -> 0278';
ok Uni.new(0x1DB3).NFKC.list ~~ (0x0282,), '1DB3 -> 0282';
ok Uni.new(0x1DB4).NFKC.list ~~ (0x0283,), '1DB4 -> 0283';
ok Uni.new(0x1DB5).NFKC.list ~~ (0x01AB,), '1DB5 -> 01AB';
ok Uni.new(0x1DB6).NFKC.list ~~ (0x0289,), '1DB6 -> 0289';
ok Uni.new(0x1DB7).NFKC.list ~~ (0x028A,), '1DB7 -> 028A';
ok Uni.new(0x1DB8).NFKC.list ~~ (0x1D1C,), '1DB8 -> 1D1C';
ok Uni.new(0x1DB9).NFKC.list ~~ (0x028B,), '1DB9 -> 028B';
ok Uni.new(0x1DBA).NFKC.list ~~ (0x028C,), '1DBA -> 028C';
ok Uni.new(0x1DBB).NFKC.list ~~ (0x007A,), '1DBB -> 007A';
ok Uni.new(0x1DBC).NFKC.list ~~ (0x0290,), '1DBC -> 0290';
ok Uni.new(0x1DBD).NFKC.list ~~ (0x0291,), '1DBD -> 0291';
ok Uni.new(0x1DBE).NFKC.list ~~ (0x0292,), '1DBE -> 0292';
ok Uni.new(0x1DBF).NFKC.list ~~ (0x03B8,), '1DBF -> 03B8';
ok Uni.new(0x1E00).NFKC.list ~~ (0x1E00,), '1E00 -> 1E00';
ok Uni.new(0x1E01).NFKC.list ~~ (0x1E01,), '1E01 -> 1E01';
ok Uni.new(0x1E02).NFKC.list ~~ (0x1E02,), '1E02 -> 1E02';
ok Uni.new(0x1E03).NFKC.list ~~ (0x1E03,), '1E03 -> 1E03';
ok Uni.new(0x1E04).NFKC.list ~~ (0x1E04,), '1E04 -> 1E04';
ok Uni.new(0x1E05).NFKC.list ~~ (0x1E05,), '1E05 -> 1E05';
ok Uni.new(0x1E06).NFKC.list ~~ (0x1E06,), '1E06 -> 1E06';
ok Uni.new(0x1E07).NFKC.list ~~ (0x1E07,), '1E07 -> 1E07';
ok Uni.new(0x1E08).NFKC.list ~~ (0x1E08,), '1E08 -> 1E08';
ok Uni.new(0x1E09).NFKC.list ~~ (0x1E09,), '1E09 -> 1E09';
ok Uni.new(0x1E0A).NFKC.list ~~ (0x1E0A,), '1E0A -> 1E0A';
ok Uni.new(0x1E0B).NFKC.list ~~ (0x1E0B,), '1E0B -> 1E0B';
ok Uni.new(0x1E0C).NFKC.list ~~ (0x1E0C,), '1E0C -> 1E0C';
ok Uni.new(0x1E0D).NFKC.list ~~ (0x1E0D,), '1E0D -> 1E0D';
ok Uni.new(0x1E0E).NFKC.list ~~ (0x1E0E,), '1E0E -> 1E0E';
ok Uni.new(0x1E0F).NFKC.list ~~ (0x1E0F,), '1E0F -> 1E0F';
ok Uni.new(0x1E10).NFKC.list ~~ (0x1E10,), '1E10 -> 1E10';
ok Uni.new(0x1E11).NFKC.list ~~ (0x1E11,), '1E11 -> 1E11';
ok Uni.new(0x1E12).NFKC.list ~~ (0x1E12,), '1E12 -> 1E12';
ok Uni.new(0x1E13).NFKC.list ~~ (0x1E13,), '1E13 -> 1E13';
ok Uni.new(0x1E14).NFKC.list ~~ (0x1E14,), '1E14 -> 1E14';
ok Uni.new(0x1E15).NFKC.list ~~ (0x1E15,), '1E15 -> 1E15';
ok Uni.new(0x1E16).NFKC.list ~~ (0x1E16,), '1E16 -> 1E16';
ok Uni.new(0x1E17).NFKC.list ~~ (0x1E17,), '1E17 -> 1E17';
ok Uni.new(0x1E18).NFKC.list ~~ (0x1E18,), '1E18 -> 1E18';
ok Uni.new(0x1E19).NFKC.list ~~ (0x1E19,), '1E19 -> 1E19';
ok Uni.new(0x1E1A).NFKC.list ~~ (0x1E1A,), '1E1A -> 1E1A';
ok Uni.new(0x1E1B).NFKC.list ~~ (0x1E1B,), '1E1B -> 1E1B';
ok Uni.new(0x1E1C).NFKC.list ~~ (0x1E1C,), '1E1C -> 1E1C';
ok Uni.new(0x1E1D).NFKC.list ~~ (0x1E1D,), '1E1D -> 1E1D';
ok Uni.new(0x1E1E).NFKC.list ~~ (0x1E1E,), '1E1E -> 1E1E';
ok Uni.new(0x1E1F).NFKC.list ~~ (0x1E1F,), '1E1F -> 1E1F';
ok Uni.new(0x1E20).NFKC.list ~~ (0x1E20,), '1E20 -> 1E20';
ok Uni.new(0x1E21).NFKC.list ~~ (0x1E21,), '1E21 -> 1E21';
ok Uni.new(0x1E22).NFKC.list ~~ (0x1E22,), '1E22 -> 1E22';
ok Uni.new(0x1E23).NFKC.list ~~ (0x1E23,), '1E23 -> 1E23';
ok Uni.new(0x1E24).NFKC.list ~~ (0x1E24,), '1E24 -> 1E24';
ok Uni.new(0x1E25).NFKC.list ~~ (0x1E25,), '1E25 -> 1E25';
ok Uni.new(0x1E26).NFKC.list ~~ (0x1E26,), '1E26 -> 1E26';
ok Uni.new(0x1E27).NFKC.list ~~ (0x1E27,), '1E27 -> 1E27';
ok Uni.new(0x1E28).NFKC.list ~~ (0x1E28,), '1E28 -> 1E28';
ok Uni.new(0x1E29).NFKC.list ~~ (0x1E29,), '1E29 -> 1E29';
ok Uni.new(0x1E2A).NFKC.list ~~ (0x1E2A,), '1E2A -> 1E2A';
ok Uni.new(0x1E2B).NFKC.list ~~ (0x1E2B,), '1E2B -> 1E2B';
ok Uni.new(0x1E2C).NFKC.list ~~ (0x1E2C,), '1E2C -> 1E2C';
ok Uni.new(0x1E2D).NFKC.list ~~ (0x1E2D,), '1E2D -> 1E2D';
ok Uni.new(0x1E2E).NFKC.list ~~ (0x1E2E,), '1E2E -> 1E2E';
ok Uni.new(0x1E2F).NFKC.list ~~ (0x1E2F,), '1E2F -> 1E2F';
ok Uni.new(0x1E30).NFKC.list ~~ (0x1E30,), '1E30 -> 1E30';
ok Uni.new(0x1E31).NFKC.list ~~ (0x1E31,), '1E31 -> 1E31';
ok Uni.new(0x1E32).NFKC.list ~~ (0x1E32,), '1E32 -> 1E32';
ok Uni.new(0x1E33).NFKC.list ~~ (0x1E33,), '1E33 -> 1E33';
ok Uni.new(0x1E34).NFKC.list ~~ (0x1E34,), '1E34 -> 1E34';
ok Uni.new(0x1E35).NFKC.list ~~ (0x1E35,), '1E35 -> 1E35';
ok Uni.new(0x1E36).NFKC.list ~~ (0x1E36,), '1E36 -> 1E36';
ok Uni.new(0x1E37).NFKC.list ~~ (0x1E37,), '1E37 -> 1E37';
ok Uni.new(0x1E38).NFKC.list ~~ (0x1E38,), '1E38 -> 1E38';
ok Uni.new(0x1E39).NFKC.list ~~ (0x1E39,), '1E39 -> 1E39';
ok Uni.new(0x1E3A).NFKC.list ~~ (0x1E3A,), '1E3A -> 1E3A';
ok Uni.new(0x1E3B).NFKC.list ~~ (0x1E3B,), '1E3B -> 1E3B';
ok Uni.new(0x1E3C).NFKC.list ~~ (0x1E3C,), '1E3C -> 1E3C';
ok Uni.new(0x1E3D).NFKC.list ~~ (0x1E3D,), '1E3D -> 1E3D';
ok Uni.new(0x1E3E).NFKC.list ~~ (0x1E3E,), '1E3E -> 1E3E';
ok Uni.new(0x1E3F).NFKC.list ~~ (0x1E3F,), '1E3F -> 1E3F';
ok Uni.new(0x1E40).NFKC.list ~~ (0x1E40,), '1E40 -> 1E40';
ok Uni.new(0x1E41).NFKC.list ~~ (0x1E41,), '1E41 -> 1E41';
ok Uni.new(0x1E42).NFKC.list ~~ (0x1E42,), '1E42 -> 1E42';
ok Uni.new(0x1E43).NFKC.list ~~ (0x1E43,), '1E43 -> 1E43';
ok Uni.new(0x1E44).NFKC.list ~~ (0x1E44,), '1E44 -> 1E44';
ok Uni.new(0x1E45).NFKC.list ~~ (0x1E45,), '1E45 -> 1E45';
ok Uni.new(0x1E46).NFKC.list ~~ (0x1E46,), '1E46 -> 1E46';
ok Uni.new(0x1E47).NFKC.list ~~ (0x1E47,), '1E47 -> 1E47';
ok Uni.new(0x1E48).NFKC.list ~~ (0x1E48,), '1E48 -> 1E48';
ok Uni.new(0x1E49).NFKC.list ~~ (0x1E49,), '1E49 -> 1E49';
ok Uni.new(0x1E4A).NFKC.list ~~ (0x1E4A,), '1E4A -> 1E4A';
ok Uni.new(0x1E4B).NFKC.list ~~ (0x1E4B,), '1E4B -> 1E4B';
ok Uni.new(0x1E4C).NFKC.list ~~ (0x1E4C,), '1E4C -> 1E4C';
ok Uni.new(0x1E4D).NFKC.list ~~ (0x1E4D,), '1E4D -> 1E4D';
ok Uni.new(0x1E4E).NFKC.list ~~ (0x1E4E,), '1E4E -> 1E4E';
ok Uni.new(0x1E4F).NFKC.list ~~ (0x1E4F,), '1E4F -> 1E4F';
ok Uni.new(0x1E50).NFKC.list ~~ (0x1E50,), '1E50 -> 1E50';
ok Uni.new(0x1E51).NFKC.list ~~ (0x1E51,), '1E51 -> 1E51';
ok Uni.new(0x1E52).NFKC.list ~~ (0x1E52,), '1E52 -> 1E52';
ok Uni.new(0x1E53).NFKC.list ~~ (0x1E53,), '1E53 -> 1E53';
ok Uni.new(0x1E54).NFKC.list ~~ (0x1E54,), '1E54 -> 1E54';
ok Uni.new(0x1E55).NFKC.list ~~ (0x1E55,), '1E55 -> 1E55';
ok Uni.new(0x1E56).NFKC.list ~~ (0x1E56,), '1E56 -> 1E56';
ok Uni.new(0x1E57).NFKC.list ~~ (0x1E57,), '1E57 -> 1E57';
ok Uni.new(0x1E58).NFKC.list ~~ (0x1E58,), '1E58 -> 1E58';
ok Uni.new(0x1E59).NFKC.list ~~ (0x1E59,), '1E59 -> 1E59';
ok Uni.new(0x1E5A).NFKC.list ~~ (0x1E5A,), '1E5A -> 1E5A';
ok Uni.new(0x1E5B).NFKC.list ~~ (0x1E5B,), '1E5B -> 1E5B';
ok Uni.new(0x1E5C).NFKC.list ~~ (0x1E5C,), '1E5C -> 1E5C';
ok Uni.new(0x1E5D).NFKC.list ~~ (0x1E5D,), '1E5D -> 1E5D';
ok Uni.new(0x1E5E).NFKC.list ~~ (0x1E5E,), '1E5E -> 1E5E';
ok Uni.new(0x1E5F).NFKC.list ~~ (0x1E5F,), '1E5F -> 1E5F';
ok Uni.new(0x1E60).NFKC.list ~~ (0x1E60,), '1E60 -> 1E60';
ok Uni.new(0x1E61).NFKC.list ~~ (0x1E61,), '1E61 -> 1E61';
ok Uni.new(0x1E62).NFKC.list ~~ (0x1E62,), '1E62 -> 1E62';
ok Uni.new(0x1E63).NFKC.list ~~ (0x1E63,), '1E63 -> 1E63';
ok Uni.new(0x1E64).NFKC.list ~~ (0x1E64,), '1E64 -> 1E64';
ok Uni.new(0x1E65).NFKC.list ~~ (0x1E65,), '1E65 -> 1E65';
ok Uni.new(0x1E66).NFKC.list ~~ (0x1E66,), '1E66 -> 1E66';
ok Uni.new(0x1E67).NFKC.list ~~ (0x1E67,), '1E67 -> 1E67';
ok Uni.new(0x1E68).NFKC.list ~~ (0x1E68,), '1E68 -> 1E68';
ok Uni.new(0x1E69).NFKC.list ~~ (0x1E69,), '1E69 -> 1E69';
ok Uni.new(0x1E6A).NFKC.list ~~ (0x1E6A,), '1E6A -> 1E6A';
ok Uni.new(0x1E6B).NFKC.list ~~ (0x1E6B,), '1E6B -> 1E6B';
ok Uni.new(0x1E6C).NFKC.list ~~ (0x1E6C,), '1E6C -> 1E6C';
ok Uni.new(0x1E6D).NFKC.list ~~ (0x1E6D,), '1E6D -> 1E6D';
ok Uni.new(0x1E6E).NFKC.list ~~ (0x1E6E,), '1E6E -> 1E6E';
ok Uni.new(0x1E6F).NFKC.list ~~ (0x1E6F,), '1E6F -> 1E6F';
ok Uni.new(0x1E70).NFKC.list ~~ (0x1E70,), '1E70 -> 1E70';
ok Uni.new(0x1E71).NFKC.list ~~ (0x1E71,), '1E71 -> 1E71';
ok Uni.new(0x1E72).NFKC.list ~~ (0x1E72,), '1E72 -> 1E72';
ok Uni.new(0x1E73).NFKC.list ~~ (0x1E73,), '1E73 -> 1E73';
ok Uni.new(0x1E74).NFKC.list ~~ (0x1E74,), '1E74 -> 1E74';
ok Uni.new(0x1E75).NFKC.list ~~ (0x1E75,), '1E75 -> 1E75';
ok Uni.new(0x1E76).NFKC.list ~~ (0x1E76,), '1E76 -> 1E76';
ok Uni.new(0x1E77).NFKC.list ~~ (0x1E77,), '1E77 -> 1E77';
ok Uni.new(0x1E78).NFKC.list ~~ (0x1E78,), '1E78 -> 1E78';
ok Uni.new(0x1E79).NFKC.list ~~ (0x1E79,), '1E79 -> 1E79';
ok Uni.new(0x1E7A).NFKC.list ~~ (0x1E7A,), '1E7A -> 1E7A';
ok Uni.new(0x1E7B).NFKC.list ~~ (0x1E7B,), '1E7B -> 1E7B';
ok Uni.new(0x1E7C).NFKC.list ~~ (0x1E7C,), '1E7C -> 1E7C';
ok Uni.new(0x1E7D).NFKC.list ~~ (0x1E7D,), '1E7D -> 1E7D';
ok Uni.new(0x1E7E).NFKC.list ~~ (0x1E7E,), '1E7E -> 1E7E';
ok Uni.new(0x1E7F).NFKC.list ~~ (0x1E7F,), '1E7F -> 1E7F';
ok Uni.new(0x1E80).NFKC.list ~~ (0x1E80,), '1E80 -> 1E80';
ok Uni.new(0x1E81).NFKC.list ~~ (0x1E81,), '1E81 -> 1E81';
ok Uni.new(0x1E82).NFKC.list ~~ (0x1E82,), '1E82 -> 1E82';
ok Uni.new(0x1E83).NFKC.list ~~ (0x1E83,), '1E83 -> 1E83';
ok Uni.new(0x1E84).NFKC.list ~~ (0x1E84,), '1E84 -> 1E84';
ok Uni.new(0x1E85).NFKC.list ~~ (0x1E85,), '1E85 -> 1E85';
ok Uni.new(0x1E86).NFKC.list ~~ (0x1E86,), '1E86 -> 1E86';
ok Uni.new(0x1E87).NFKC.list ~~ (0x1E87,), '1E87 -> 1E87';
ok Uni.new(0x1E88).NFKC.list ~~ (0x1E88,), '1E88 -> 1E88';
ok Uni.new(0x1E89).NFKC.list ~~ (0x1E89,), '1E89 -> 1E89';
ok Uni.new(0x1E8A).NFKC.list ~~ (0x1E8A,), '1E8A -> 1E8A';
ok Uni.new(0x1E8B).NFKC.list ~~ (0x1E8B,), '1E8B -> 1E8B';
ok Uni.new(0x1E8C).NFKC.list ~~ (0x1E8C,), '1E8C -> 1E8C';
ok Uni.new(0x1E8D).NFKC.list ~~ (0x1E8D,), '1E8D -> 1E8D';
ok Uni.new(0x1E8E).NFKC.list ~~ (0x1E8E,), '1E8E -> 1E8E';
ok Uni.new(0x1E8F).NFKC.list ~~ (0x1E8F,), '1E8F -> 1E8F';
ok Uni.new(0x1E90).NFKC.list ~~ (0x1E90,), '1E90 -> 1E90';
ok Uni.new(0x1E91).NFKC.list ~~ (0x1E91,), '1E91 -> 1E91';
ok Uni.new(0x1E92).NFKC.list ~~ (0x1E92,), '1E92 -> 1E92';
ok Uni.new(0x1E93).NFKC.list ~~ (0x1E93,), '1E93 -> 1E93';
ok Uni.new(0x1E94).NFKC.list ~~ (0x1E94,), '1E94 -> 1E94';
ok Uni.new(0x1E95).NFKC.list ~~ (0x1E95,), '1E95 -> 1E95';
ok Uni.new(0x1E96).NFKC.list ~~ (0x1E96,), '1E96 -> 1E96';
ok Uni.new(0x1E97).NFKC.list ~~ (0x1E97,), '1E97 -> 1E97';
ok Uni.new(0x1E98).NFKC.list ~~ (0x1E98,), '1E98 -> 1E98';
ok Uni.new(0x1E99).NFKC.list ~~ (0x1E99,), '1E99 -> 1E99';
ok Uni.new(0x1E9A).NFKC.list ~~ (0x0061, 0x02BE,), '1E9A -> 0061 02BE';
ok Uni.new(0x1E9B).NFKC.list ~~ (0x1E61,), '1E9B -> 1E61';
ok Uni.new(0x1EA0).NFKC.list ~~ (0x1EA0,), '1EA0 -> 1EA0';
ok Uni.new(0x1EA1).NFKC.list ~~ (0x1EA1,), '1EA1 -> 1EA1';
ok Uni.new(0x1EA2).NFKC.list ~~ (0x1EA2,), '1EA2 -> 1EA2';
ok Uni.new(0x1EA3).NFKC.list ~~ (0x1EA3,), '1EA3 -> 1EA3';
ok Uni.new(0x1EA4).NFKC.list ~~ (0x1EA4,), '1EA4 -> 1EA4';
ok Uni.new(0x1EA5).NFKC.list ~~ (0x1EA5,), '1EA5 -> 1EA5';
ok Uni.new(0x1EA6).NFKC.list ~~ (0x1EA6,), '1EA6 -> 1EA6';
ok Uni.new(0x1EA7).NFKC.list ~~ (0x1EA7,), '1EA7 -> 1EA7';
ok Uni.new(0x1EA8).NFKC.list ~~ (0x1EA8,), '1EA8 -> 1EA8';
ok Uni.new(0x1EA9).NFKC.list ~~ (0x1EA9,), '1EA9 -> 1EA9';
ok Uni.new(0x1EAA).NFKC.list ~~ (0x1EAA,), '1EAA -> 1EAA';
ok Uni.new(0x1EAB).NFKC.list ~~ (0x1EAB,), '1EAB -> 1EAB';
ok Uni.new(0x1EAC).NFKC.list ~~ (0x1EAC,), '1EAC -> 1EAC';
ok Uni.new(0x1EAD).NFKC.list ~~ (0x1EAD,), '1EAD -> 1EAD';
ok Uni.new(0x1EAE).NFKC.list ~~ (0x1EAE,), '1EAE -> 1EAE';
ok Uni.new(0x1EAF).NFKC.list ~~ (0x1EAF,), '1EAF -> 1EAF';
ok Uni.new(0x1EB0).NFKC.list ~~ (0x1EB0,), '1EB0 -> 1EB0';
ok Uni.new(0x1EB1).NFKC.list ~~ (0x1EB1,), '1EB1 -> 1EB1';
ok Uni.new(0x1EB2).NFKC.list ~~ (0x1EB2,), '1EB2 -> 1EB2';
ok Uni.new(0x1EB3).NFKC.list ~~ (0x1EB3,), '1EB3 -> 1EB3';
ok Uni.new(0x1EB4).NFKC.list ~~ (0x1EB4,), '1EB4 -> 1EB4';
ok Uni.new(0x1EB5).NFKC.list ~~ (0x1EB5,), '1EB5 -> 1EB5';
ok Uni.new(0x1EB6).NFKC.list ~~ (0x1EB6,), '1EB6 -> 1EB6';
ok Uni.new(0x1EB7).NFKC.list ~~ (0x1EB7,), '1EB7 -> 1EB7';
ok Uni.new(0x1EB8).NFKC.list ~~ (0x1EB8,), '1EB8 -> 1EB8';
ok Uni.new(0x1EB9).NFKC.list ~~ (0x1EB9,), '1EB9 -> 1EB9';
ok Uni.new(0x1EBA).NFKC.list ~~ (0x1EBA,), '1EBA -> 1EBA';
ok Uni.new(0x1EBB).NFKC.list ~~ (0x1EBB,), '1EBB -> 1EBB';
ok Uni.new(0x1EBC).NFKC.list ~~ (0x1EBC,), '1EBC -> 1EBC';
ok Uni.new(0x1EBD).NFKC.list ~~ (0x1EBD,), '1EBD -> 1EBD';
ok Uni.new(0x1EBE).NFKC.list ~~ (0x1EBE,), '1EBE -> 1EBE';
ok Uni.new(0x1EBF).NFKC.list ~~ (0x1EBF,), '1EBF -> 1EBF';
ok Uni.new(0x1EC0).NFKC.list ~~ (0x1EC0,), '1EC0 -> 1EC0';
ok Uni.new(0x1EC1).NFKC.list ~~ (0x1EC1,), '1EC1 -> 1EC1';
ok Uni.new(0x1EC2).NFKC.list ~~ (0x1EC2,), '1EC2 -> 1EC2';
ok Uni.new(0x1EC3).NFKC.list ~~ (0x1EC3,), '1EC3 -> 1EC3';
ok Uni.new(0x1EC4).NFKC.list ~~ (0x1EC4,), '1EC4 -> 1EC4';
ok Uni.new(0x1EC5).NFKC.list ~~ (0x1EC5,), '1EC5 -> 1EC5';
ok Uni.new(0x1EC6).NFKC.list ~~ (0x1EC6,), '1EC6 -> 1EC6';
ok Uni.new(0x1EC7).NFKC.list ~~ (0x1EC7,), '1EC7 -> 1EC7';
ok Uni.new(0x1EC8).NFKC.list ~~ (0x1EC8,), '1EC8 -> 1EC8';
ok Uni.new(0x1EC9).NFKC.list ~~ (0x1EC9,), '1EC9 -> 1EC9';
ok Uni.new(0x1ECA).NFKC.list ~~ (0x1ECA,), '1ECA -> 1ECA';
ok Uni.new(0x1ECB).NFKC.list ~~ (0x1ECB,), '1ECB -> 1ECB';
ok Uni.new(0x1ECC).NFKC.list ~~ (0x1ECC,), '1ECC -> 1ECC';
ok Uni.new(0x1ECD).NFKC.list ~~ (0x1ECD,), '1ECD -> 1ECD';
ok Uni.new(0x1ECE).NFKC.list ~~ (0x1ECE,), '1ECE -> 1ECE';
ok Uni.new(0x1ECF).NFKC.list ~~ (0x1ECF,), '1ECF -> 1ECF';
ok Uni.new(0x1ED0).NFKC.list ~~ (0x1ED0,), '1ED0 -> 1ED0';
ok Uni.new(0x1ED1).NFKC.list ~~ (0x1ED1,), '1ED1 -> 1ED1';
ok Uni.new(0x1ED2).NFKC.list ~~ (0x1ED2,), '1ED2 -> 1ED2';
ok Uni.new(0x1ED3).NFKC.list ~~ (0x1ED3,), '1ED3 -> 1ED3';
ok Uni.new(0x1ED4).NFKC.list ~~ (0x1ED4,), '1ED4 -> 1ED4';
ok Uni.new(0x1ED5).NFKC.list ~~ (0x1ED5,), '1ED5 -> 1ED5';
ok Uni.new(0x1ED6).NFKC.list ~~ (0x1ED6,), '1ED6 -> 1ED6';
ok Uni.new(0x1ED7).NFKC.list ~~ (0x1ED7,), '1ED7 -> 1ED7';
ok Uni.new(0x1ED8).NFKC.list ~~ (0x1ED8,), '1ED8 -> 1ED8';
ok Uni.new(0x1ED9).NFKC.list ~~ (0x1ED9,), '1ED9 -> 1ED9';
ok Uni.new(0x1EDA).NFKC.list ~~ (0x1EDA,), '1EDA -> 1EDA';
ok Uni.new(0x1EDB).NFKC.list ~~ (0x1EDB,), '1EDB -> 1EDB';
ok Uni.new(0x1EDC).NFKC.list ~~ (0x1EDC,), '1EDC -> 1EDC';
ok Uni.new(0x1EDD).NFKC.list ~~ (0x1EDD,), '1EDD -> 1EDD';
ok Uni.new(0x1EDE).NFKC.list ~~ (0x1EDE,), '1EDE -> 1EDE';
ok Uni.new(0x1EDF).NFKC.list ~~ (0x1EDF,), '1EDF -> 1EDF';
ok Uni.new(0x1EE0).NFKC.list ~~ (0x1EE0,), '1EE0 -> 1EE0';
ok Uni.new(0x1EE1).NFKC.list ~~ (0x1EE1,), '1EE1 -> 1EE1';
ok Uni.new(0x1EE2).NFKC.list ~~ (0x1EE2,), '1EE2 -> 1EE2';
ok Uni.new(0x1EE3).NFKC.list ~~ (0x1EE3,), '1EE3 -> 1EE3';
ok Uni.new(0x1EE4).NFKC.list ~~ (0x1EE4,), '1EE4 -> 1EE4';
ok Uni.new(0x1EE5).NFKC.list ~~ (0x1EE5,), '1EE5 -> 1EE5';
ok Uni.new(0x1EE6).NFKC.list ~~ (0x1EE6,), '1EE6 -> 1EE6';
ok Uni.new(0x1EE7).NFKC.list ~~ (0x1EE7,), '1EE7 -> 1EE7';
ok Uni.new(0x1EE8).NFKC.list ~~ (0x1EE8,), '1EE8 -> 1EE8';
ok Uni.new(0x1EE9).NFKC.list ~~ (0x1EE9,), '1EE9 -> 1EE9';
ok Uni.new(0x1EEA).NFKC.list ~~ (0x1EEA,), '1EEA -> 1EEA';
ok Uni.new(0x1EEB).NFKC.list ~~ (0x1EEB,), '1EEB -> 1EEB';
ok Uni.new(0x1EEC).NFKC.list ~~ (0x1EEC,), '1EEC -> 1EEC';
ok Uni.new(0x1EED).NFKC.list ~~ (0x1EED,), '1EED -> 1EED';
ok Uni.new(0x1EEE).NFKC.list ~~ (0x1EEE,), '1EEE -> 1EEE';
ok Uni.new(0x1EEF).NFKC.list ~~ (0x1EEF,), '1EEF -> 1EEF';
ok Uni.new(0x1EF0).NFKC.list ~~ (0x1EF0,), '1EF0 -> 1EF0';
ok Uni.new(0x1EF1).NFKC.list ~~ (0x1EF1,), '1EF1 -> 1EF1';
ok Uni.new(0x1EF2).NFKC.list ~~ (0x1EF2,), '1EF2 -> 1EF2';
ok Uni.new(0x1EF3).NFKC.list ~~ (0x1EF3,), '1EF3 -> 1EF3';
ok Uni.new(0x1EF4).NFKC.list ~~ (0x1EF4,), '1EF4 -> 1EF4';
ok Uni.new(0x1EF5).NFKC.list ~~ (0x1EF5,), '1EF5 -> 1EF5';
ok Uni.new(0x1EF6).NFKC.list ~~ (0x1EF6,), '1EF6 -> 1EF6';
ok Uni.new(0x1EF7).NFKC.list ~~ (0x1EF7,), '1EF7 -> 1EF7';
ok Uni.new(0x1EF8).NFKC.list ~~ (0x1EF8,), '1EF8 -> 1EF8';
ok Uni.new(0x1EF9).NFKC.list ~~ (0x1EF9,), '1EF9 -> 1EF9';
ok Uni.new(0x1F00).NFKC.list ~~ (0x1F00,), '1F00 -> 1F00';
ok Uni.new(0x1F01).NFKC.list ~~ (0x1F01,), '1F01 -> 1F01';
ok Uni.new(0x1F02).NFKC.list ~~ (0x1F02,), '1F02 -> 1F02';
ok Uni.new(0x1F03).NFKC.list ~~ (0x1F03,), '1F03 -> 1F03';
ok Uni.new(0x1F04).NFKC.list ~~ (0x1F04,), '1F04 -> 1F04';
ok Uni.new(0x1F05).NFKC.list ~~ (0x1F05,), '1F05 -> 1F05';
ok Uni.new(0x1F06).NFKC.list ~~ (0x1F06,), '1F06 -> 1F06';
ok Uni.new(0x1F07).NFKC.list ~~ (0x1F07,), '1F07 -> 1F07';
ok Uni.new(0x1F08).NFKC.list ~~ (0x1F08,), '1F08 -> 1F08';
ok Uni.new(0x1F09).NFKC.list ~~ (0x1F09,), '1F09 -> 1F09';
ok Uni.new(0x1F0A).NFKC.list ~~ (0x1F0A,), '1F0A -> 1F0A';
ok Uni.new(0x1F0B).NFKC.list ~~ (0x1F0B,), '1F0B -> 1F0B';
ok Uni.new(0x1F0C).NFKC.list ~~ (0x1F0C,), '1F0C -> 1F0C';
ok Uni.new(0x1F0D).NFKC.list ~~ (0x1F0D,), '1F0D -> 1F0D';
ok Uni.new(0x1F0E).NFKC.list ~~ (0x1F0E,), '1F0E -> 1F0E';
ok Uni.new(0x1F0F).NFKC.list ~~ (0x1F0F,), '1F0F -> 1F0F';
ok Uni.new(0x1F10).NFKC.list ~~ (0x1F10,), '1F10 -> 1F10';
ok Uni.new(0x1F11).NFKC.list ~~ (0x1F11,), '1F11 -> 1F11';
ok Uni.new(0x1F12).NFKC.list ~~ (0x1F12,), '1F12 -> 1F12';
ok Uni.new(0x1F13).NFKC.list ~~ (0x1F13,), '1F13 -> 1F13';
ok Uni.new(0x1F14).NFKC.list ~~ (0x1F14,), '1F14 -> 1F14';
ok Uni.new(0x1F15).NFKC.list ~~ (0x1F15,), '1F15 -> 1F15';
ok Uni.new(0x1F18).NFKC.list ~~ (0x1F18,), '1F18 -> 1F18';
ok Uni.new(0x1F19).NFKC.list ~~ (0x1F19,), '1F19 -> 1F19';
ok Uni.new(0x1F1A).NFKC.list ~~ (0x1F1A,), '1F1A -> 1F1A';
ok Uni.new(0x1F1B).NFKC.list ~~ (0x1F1B,), '1F1B -> 1F1B';
ok Uni.new(0x1F1C).NFKC.list ~~ (0x1F1C,), '1F1C -> 1F1C';
ok Uni.new(0x1F1D).NFKC.list ~~ (0x1F1D,), '1F1D -> 1F1D';
ok Uni.new(0x1F20).NFKC.list ~~ (0x1F20,), '1F20 -> 1F20';
ok Uni.new(0x1F21).NFKC.list ~~ (0x1F21,), '1F21 -> 1F21';
ok Uni.new(0x1F22).NFKC.list ~~ (0x1F22,), '1F22 -> 1F22';
ok Uni.new(0x1F23).NFKC.list ~~ (0x1F23,), '1F23 -> 1F23';
ok Uni.new(0x1F24).NFKC.list ~~ (0x1F24,), '1F24 -> 1F24';
ok Uni.new(0x1F25).NFKC.list ~~ (0x1F25,), '1F25 -> 1F25';
ok Uni.new(0x1F26).NFKC.list ~~ (0x1F26,), '1F26 -> 1F26';
ok Uni.new(0x1F27).NFKC.list ~~ (0x1F27,), '1F27 -> 1F27';
ok Uni.new(0x1F28).NFKC.list ~~ (0x1F28,), '1F28 -> 1F28';
ok Uni.new(0x1F29).NFKC.list ~~ (0x1F29,), '1F29 -> 1F29';
ok Uni.new(0x1F2A).NFKC.list ~~ (0x1F2A,), '1F2A -> 1F2A';
ok Uni.new(0x1F2B).NFKC.list ~~ (0x1F2B,), '1F2B -> 1F2B';
ok Uni.new(0x1F2C).NFKC.list ~~ (0x1F2C,), '1F2C -> 1F2C';
ok Uni.new(0x1F2D).NFKC.list ~~ (0x1F2D,), '1F2D -> 1F2D';
ok Uni.new(0x1F2E).NFKC.list ~~ (0x1F2E,), '1F2E -> 1F2E';
ok Uni.new(0x1F2F).NFKC.list ~~ (0x1F2F,), '1F2F -> 1F2F';
ok Uni.new(0x1F30).NFKC.list ~~ (0x1F30,), '1F30 -> 1F30';
ok Uni.new(0x1F31).NFKC.list ~~ (0x1F31,), '1F31 -> 1F31';
ok Uni.new(0x1F32).NFKC.list ~~ (0x1F32,), '1F32 -> 1F32';
ok Uni.new(0x1F33).NFKC.list ~~ (0x1F33,), '1F33 -> 1F33';
ok Uni.new(0x1F34).NFKC.list ~~ (0x1F34,), '1F34 -> 1F34';
ok Uni.new(0x1F35).NFKC.list ~~ (0x1F35,), '1F35 -> 1F35';
ok Uni.new(0x1F36).NFKC.list ~~ (0x1F36,), '1F36 -> 1F36';
ok Uni.new(0x1F37).NFKC.list ~~ (0x1F37,), '1F37 -> 1F37';
ok Uni.new(0x1F38).NFKC.list ~~ (0x1F38,), '1F38 -> 1F38';
ok Uni.new(0x1F39).NFKC.list ~~ (0x1F39,), '1F39 -> 1F39';
ok Uni.new(0x1F3A).NFKC.list ~~ (0x1F3A,), '1F3A -> 1F3A';
ok Uni.new(0x1F3B).NFKC.list ~~ (0x1F3B,), '1F3B -> 1F3B';
ok Uni.new(0x1F3C).NFKC.list ~~ (0x1F3C,), '1F3C -> 1F3C';
ok Uni.new(0x1F3D).NFKC.list ~~ (0x1F3D,), '1F3D -> 1F3D';
ok Uni.new(0x1F3E).NFKC.list ~~ (0x1F3E,), '1F3E -> 1F3E';
ok Uni.new(0x1F3F).NFKC.list ~~ (0x1F3F,), '1F3F -> 1F3F';
ok Uni.new(0x1F40).NFKC.list ~~ (0x1F40,), '1F40 -> 1F40';
ok Uni.new(0x1F41).NFKC.list ~~ (0x1F41,), '1F41 -> 1F41';
ok Uni.new(0x1F42).NFKC.list ~~ (0x1F42,), '1F42 -> 1F42';
ok Uni.new(0x1F43).NFKC.list ~~ (0x1F43,), '1F43 -> 1F43';
ok Uni.new(0x1F44).NFKC.list ~~ (0x1F44,), '1F44 -> 1F44';
ok Uni.new(0x1F45).NFKC.list ~~ (0x1F45,), '1F45 -> 1F45';
ok Uni.new(0x1F48).NFKC.list ~~ (0x1F48,), '1F48 -> 1F48';
ok Uni.new(0x1F49).NFKC.list ~~ (0x1F49,), '1F49 -> 1F49';
ok Uni.new(0x1F4A).NFKC.list ~~ (0x1F4A,), '1F4A -> 1F4A';
ok Uni.new(0x1F4B).NFKC.list ~~ (0x1F4B,), '1F4B -> 1F4B';
ok Uni.new(0x1F4C).NFKC.list ~~ (0x1F4C,), '1F4C -> 1F4C';
ok Uni.new(0x1F4D).NFKC.list ~~ (0x1F4D,), '1F4D -> 1F4D';
ok Uni.new(0x1F50).NFKC.list ~~ (0x1F50,), '1F50 -> 1F50';
ok Uni.new(0x1F51).NFKC.list ~~ (0x1F51,), '1F51 -> 1F51';
ok Uni.new(0x1F52).NFKC.list ~~ (0x1F52,), '1F52 -> 1F52';
ok Uni.new(0x1F53).NFKC.list ~~ (0x1F53,), '1F53 -> 1F53';
ok Uni.new(0x1F54).NFKC.list ~~ (0x1F54,), '1F54 -> 1F54';
ok Uni.new(0x1F55).NFKC.list ~~ (0x1F55,), '1F55 -> 1F55';
ok Uni.new(0x1F56).NFKC.list ~~ (0x1F56,), '1F56 -> 1F56';
ok Uni.new(0x1F57).NFKC.list ~~ (0x1F57,), '1F57 -> 1F57';
ok Uni.new(0x1F59).NFKC.list ~~ (0x1F59,), '1F59 -> 1F59';
ok Uni.new(0x1F5B).NFKC.list ~~ (0x1F5B,), '1F5B -> 1F5B';
ok Uni.new(0x1F5D).NFKC.list ~~ (0x1F5D,), '1F5D -> 1F5D';
ok Uni.new(0x1F5F).NFKC.list ~~ (0x1F5F,), '1F5F -> 1F5F';
ok Uni.new(0x1F60).NFKC.list ~~ (0x1F60,), '1F60 -> 1F60';
ok Uni.new(0x1F61).NFKC.list ~~ (0x1F61,), '1F61 -> 1F61';
ok Uni.new(0x1F62).NFKC.list ~~ (0x1F62,), '1F62 -> 1F62';
ok Uni.new(0x1F63).NFKC.list ~~ (0x1F63,), '1F63 -> 1F63';
ok Uni.new(0x1F64).NFKC.list ~~ (0x1F64,), '1F64 -> 1F64';
ok Uni.new(0x1F65).NFKC.list ~~ (0x1F65,), '1F65 -> 1F65';
ok Uni.new(0x1F66).NFKC.list ~~ (0x1F66,), '1F66 -> 1F66';
ok Uni.new(0x1F67).NFKC.list ~~ (0x1F67,), '1F67 -> 1F67';
ok Uni.new(0x1F68).NFKC.list ~~ (0x1F68,), '1F68 -> 1F68';
ok Uni.new(0x1F69).NFKC.list ~~ (0x1F69,), '1F69 -> 1F69';
ok Uni.new(0x1F6A).NFKC.list ~~ (0x1F6A,), '1F6A -> 1F6A';
ok Uni.new(0x1F6B).NFKC.list ~~ (0x1F6B,), '1F6B -> 1F6B';
ok Uni.new(0x1F6C).NFKC.list ~~ (0x1F6C,), '1F6C -> 1F6C';
ok Uni.new(0x1F6D).NFKC.list ~~ (0x1F6D,), '1F6D -> 1F6D';
ok Uni.new(0x1F6E).NFKC.list ~~ (0x1F6E,), '1F6E -> 1F6E';
ok Uni.new(0x1F6F).NFKC.list ~~ (0x1F6F,), '1F6F -> 1F6F';
ok Uni.new(0x1F70).NFKC.list ~~ (0x1F70,), '1F70 -> 1F70';
ok Uni.new(0x1F71).NFKC.list ~~ (0x03AC,), '1F71 -> 03AC';
ok Uni.new(0x1F72).NFKC.list ~~ (0x1F72,), '1F72 -> 1F72';
ok Uni.new(0x1F73).NFKC.list ~~ (0x03AD,), '1F73 -> 03AD';
ok Uni.new(0x1F74).NFKC.list ~~ (0x1F74,), '1F74 -> 1F74';
ok Uni.new(0x1F75).NFKC.list ~~ (0x03AE,), '1F75 -> 03AE';
ok Uni.new(0x1F76).NFKC.list ~~ (0x1F76,), '1F76 -> 1F76';
ok Uni.new(0x1F77).NFKC.list ~~ (0x03AF,), '1F77 -> 03AF';
ok Uni.new(0x1F78).NFKC.list ~~ (0x1F78,), '1F78 -> 1F78';
ok Uni.new(0x1F79).NFKC.list ~~ (0x03CC,), '1F79 -> 03CC';
ok Uni.new(0x1F7A).NFKC.list ~~ (0x1F7A,), '1F7A -> 1F7A';
ok Uni.new(0x1F7B).NFKC.list ~~ (0x03CD,), '1F7B -> 03CD';
ok Uni.new(0x1F7C).NFKC.list ~~ (0x1F7C,), '1F7C -> 1F7C';
ok Uni.new(0x1F7D).NFKC.list ~~ (0x03CE,), '1F7D -> 03CE';
ok Uni.new(0x1F80).NFKC.list ~~ (0x1F80,), '1F80 -> 1F80';
ok Uni.new(0x1F81).NFKC.list ~~ (0x1F81,), '1F81 -> 1F81';
ok Uni.new(0x1F82).NFKC.list ~~ (0x1F82,), '1F82 -> 1F82';
ok Uni.new(0x1F83).NFKC.list ~~ (0x1F83,), '1F83 -> 1F83';
ok Uni.new(0x1F84).NFKC.list ~~ (0x1F84,), '1F84 -> 1F84';
ok Uni.new(0x1F85).NFKC.list ~~ (0x1F85,), '1F85 -> 1F85';
ok Uni.new(0x1F86).NFKC.list ~~ (0x1F86,), '1F86 -> 1F86';
ok Uni.new(0x1F87).NFKC.list ~~ (0x1F87,), '1F87 -> 1F87';
ok Uni.new(0x1F88).NFKC.list ~~ (0x1F88,), '1F88 -> 1F88';
ok Uni.new(0x1F89).NFKC.list ~~ (0x1F89,), '1F89 -> 1F89';
ok Uni.new(0x1F8A).NFKC.list ~~ (0x1F8A,), '1F8A -> 1F8A';
ok Uni.new(0x1F8B).NFKC.list ~~ (0x1F8B,), '1F8B -> 1F8B';
ok Uni.new(0x1F8C).NFKC.list ~~ (0x1F8C,), '1F8C -> 1F8C';
ok Uni.new(0x1F8D).NFKC.list ~~ (0x1F8D,), '1F8D -> 1F8D';
ok Uni.new(0x1F8E).NFKC.list ~~ (0x1F8E,), '1F8E -> 1F8E';
ok Uni.new(0x1F8F).NFKC.list ~~ (0x1F8F,), '1F8F -> 1F8F';
ok Uni.new(0x1F90).NFKC.list ~~ (0x1F90,), '1F90 -> 1F90';
ok Uni.new(0x1F91).NFKC.list ~~ (0x1F91,), '1F91 -> 1F91';
ok Uni.new(0x1F92).NFKC.list ~~ (0x1F92,), '1F92 -> 1F92';
ok Uni.new(0x1F93).NFKC.list ~~ (0x1F93,), '1F93 -> 1F93';
ok Uni.new(0x1F94).NFKC.list ~~ (0x1F94,), '1F94 -> 1F94';
ok Uni.new(0x1F95).NFKC.list ~~ (0x1F95,), '1F95 -> 1F95';
ok Uni.new(0x1F96).NFKC.list ~~ (0x1F96,), '1F96 -> 1F96';
ok Uni.new(0x1F97).NFKC.list ~~ (0x1F97,), '1F97 -> 1F97';
ok Uni.new(0x1F98).NFKC.list ~~ (0x1F98,), '1F98 -> 1F98';
ok Uni.new(0x1F99).NFKC.list ~~ (0x1F99,), '1F99 -> 1F99';
ok Uni.new(0x1F9A).NFKC.list ~~ (0x1F9A,), '1F9A -> 1F9A';
ok Uni.new(0x1F9B).NFKC.list ~~ (0x1F9B,), '1F9B -> 1F9B';
ok Uni.new(0x1F9C).NFKC.list ~~ (0x1F9C,), '1F9C -> 1F9C';
ok Uni.new(0x1F9D).NFKC.list ~~ (0x1F9D,), '1F9D -> 1F9D';
ok Uni.new(0x1F9E).NFKC.list ~~ (0x1F9E,), '1F9E -> 1F9E';
ok Uni.new(0x1F9F).NFKC.list ~~ (0x1F9F,), '1F9F -> 1F9F';
ok Uni.new(0x1FA0).NFKC.list ~~ (0x1FA0,), '1FA0 -> 1FA0';
ok Uni.new(0x1FA1).NFKC.list ~~ (0x1FA1,), '1FA1 -> 1FA1';
ok Uni.new(0x1FA2).NFKC.list ~~ (0x1FA2,), '1FA2 -> 1FA2';
ok Uni.new(0x1FA3).NFKC.list ~~ (0x1FA3,), '1FA3 -> 1FA3';
ok Uni.new(0x1FA4).NFKC.list ~~ (0x1FA4,), '1FA4 -> 1FA4';
ok Uni.new(0x1FA5).NFKC.list ~~ (0x1FA5,), '1FA5 -> 1FA5';
ok Uni.new(0x1FA6).NFKC.list ~~ (0x1FA6,), '1FA6 -> 1FA6';
ok Uni.new(0x1FA7).NFKC.list ~~ (0x1FA7,), '1FA7 -> 1FA7';
ok Uni.new(0x1FA8).NFKC.list ~~ (0x1FA8,), '1FA8 -> 1FA8';
ok Uni.new(0x1FA9).NFKC.list ~~ (0x1FA9,), '1FA9 -> 1FA9';
ok Uni.new(0x1FAA).NFKC.list ~~ (0x1FAA,), '1FAA -> 1FAA';
ok Uni.new(0x1FAB).NFKC.list ~~ (0x1FAB,), '1FAB -> 1FAB';
ok Uni.new(0x1FAC).NFKC.list ~~ (0x1FAC,), '1FAC -> 1FAC';
ok Uni.new(0x1FAD).NFKC.list ~~ (0x1FAD,), '1FAD -> 1FAD';
ok Uni.new(0x1FAE).NFKC.list ~~ (0x1FAE,), '1FAE -> 1FAE';
ok Uni.new(0x1FAF).NFKC.list ~~ (0x1FAF,), '1FAF -> 1FAF';
ok Uni.new(0x1FB0).NFKC.list ~~ (0x1FB0,), '1FB0 -> 1FB0';
ok Uni.new(0x1FB1).NFKC.list ~~ (0x1FB1,), '1FB1 -> 1FB1';
ok Uni.new(0x1FB2).NFKC.list ~~ (0x1FB2,), '1FB2 -> 1FB2';
ok Uni.new(0x1FB3).NFKC.list ~~ (0x1FB3,), '1FB3 -> 1FB3';
ok Uni.new(0x1FB4).NFKC.list ~~ (0x1FB4,), '1FB4 -> 1FB4';
ok Uni.new(0x1FB6).NFKC.list ~~ (0x1FB6,), '1FB6 -> 1FB6';
ok Uni.new(0x1FB7).NFKC.list ~~ (0x1FB7,), '1FB7 -> 1FB7';
ok Uni.new(0x1FB8).NFKC.list ~~ (0x1FB8,), '1FB8 -> 1FB8';
ok Uni.new(0x1FB9).NFKC.list ~~ (0x1FB9,), '1FB9 -> 1FB9';
ok Uni.new(0x1FBA).NFKC.list ~~ (0x1FBA,), '1FBA -> 1FBA';
ok Uni.new(0x1FBB).NFKC.list ~~ (0x0386,), '1FBB -> 0386';
ok Uni.new(0x1FBC).NFKC.list ~~ (0x1FBC,), '1FBC -> 1FBC';
ok Uni.new(0x1FBD).NFKC.list ~~ (0x0020, 0x0313,), '1FBD -> 0020 0313';
ok Uni.new(0x1FBE).NFKC.list ~~ (0x03B9,), '1FBE -> 03B9';
ok Uni.new(0x1FBF).NFKC.list ~~ (0x0020, 0x0313,), '1FBF -> 0020 0313';
ok Uni.new(0x1FC0).NFKC.list ~~ (0x0020, 0x0342,), '1FC0 -> 0020 0342';
ok Uni.new(0x1FC1).NFKC.list ~~ (0x0020, 0x0308, 0x0342,), '1FC1 -> 0020 0308 0342';
ok Uni.new(0x1FC2).NFKC.list ~~ (0x1FC2,), '1FC2 -> 1FC2';
ok Uni.new(0x1FC3).NFKC.list ~~ (0x1FC3,), '1FC3 -> 1FC3';
ok Uni.new(0x1FC4).NFKC.list ~~ (0x1FC4,), '1FC4 -> 1FC4';
ok Uni.new(0x1FC6).NFKC.list ~~ (0x1FC6,), '1FC6 -> 1FC6';
ok Uni.new(0x1FC7).NFKC.list ~~ (0x1FC7,), '1FC7 -> 1FC7';
ok Uni.new(0x1FC8).NFKC.list ~~ (0x1FC8,), '1FC8 -> 1FC8';
ok Uni.new(0x1FC9).NFKC.list ~~ (0x0388,), '1FC9 -> 0388';
ok Uni.new(0x1FCA).NFKC.list ~~ (0x1FCA,), '1FCA -> 1FCA';
ok Uni.new(0x1FCB).NFKC.list ~~ (0x0389,), '1FCB -> 0389';
ok Uni.new(0x1FCC).NFKC.list ~~ (0x1FCC,), '1FCC -> 1FCC';
ok Uni.new(0x1FCD).NFKC.list ~~ (0x0020, 0x0313, 0x0300,), '1FCD -> 0020 0313 0300';
ok Uni.new(0x1FCE).NFKC.list ~~ (0x0020, 0x0313, 0x0301,), '1FCE -> 0020 0313 0301';
ok Uni.new(0x1FCF).NFKC.list ~~ (0x0020, 0x0313, 0x0342,), '1FCF -> 0020 0313 0342';
ok Uni.new(0x1FD0).NFKC.list ~~ (0x1FD0,), '1FD0 -> 1FD0';
ok Uni.new(0x1FD1).NFKC.list ~~ (0x1FD1,), '1FD1 -> 1FD1';
ok Uni.new(0x1FD2).NFKC.list ~~ (0x1FD2,), '1FD2 -> 1FD2';
ok Uni.new(0x1FD3).NFKC.list ~~ (0x0390,), '1FD3 -> 0390';
ok Uni.new(0x1FD6).NFKC.list ~~ (0x1FD6,), '1FD6 -> 1FD6';
ok Uni.new(0x1FD7).NFKC.list ~~ (0x1FD7,), '1FD7 -> 1FD7';
ok Uni.new(0x1FD8).NFKC.list ~~ (0x1FD8,), '1FD8 -> 1FD8';
ok Uni.new(0x1FD9).NFKC.list ~~ (0x1FD9,), '1FD9 -> 1FD9';
ok Uni.new(0x1FDA).NFKC.list ~~ (0x1FDA,), '1FDA -> 1FDA';
ok Uni.new(0x1FDB).NFKC.list ~~ (0x038A,), '1FDB -> 038A';
ok Uni.new(0x1FDD).NFKC.list ~~ (0x0020, 0x0314, 0x0300,), '1FDD -> 0020 0314 0300';
ok Uni.new(0x1FDE).NFKC.list ~~ (0x0020, 0x0314, 0x0301,), '1FDE -> 0020 0314 0301';
ok Uni.new(0x1FDF).NFKC.list ~~ (0x0020, 0x0314, 0x0342,), '1FDF -> 0020 0314 0342';
ok Uni.new(0x1FE0).NFKC.list ~~ (0x1FE0,), '1FE0 -> 1FE0';
ok Uni.new(0x1FE1).NFKC.list ~~ (0x1FE1,), '1FE1 -> 1FE1';
ok Uni.new(0x1FE2).NFKC.list ~~ (0x1FE2,), '1FE2 -> 1FE2';
ok Uni.new(0x1FE3).NFKC.list ~~ (0x03B0,), '1FE3 -> 03B0';
ok Uni.new(0x1FE4).NFKC.list ~~ (0x1FE4,), '1FE4 -> 1FE4';
ok Uni.new(0x1FE5).NFKC.list ~~ (0x1FE5,), '1FE5 -> 1FE5';
ok Uni.new(0x1FE6).NFKC.list ~~ (0x1FE6,), '1FE6 -> 1FE6';
ok Uni.new(0x1FE7).NFKC.list ~~ (0x1FE7,), '1FE7 -> 1FE7';
ok Uni.new(0x1FE8).NFKC.list ~~ (0x1FE8,), '1FE8 -> 1FE8';
ok Uni.new(0x1FE9).NFKC.list ~~ (0x1FE9,), '1FE9 -> 1FE9';
ok Uni.new(0x1FEA).NFKC.list ~~ (0x1FEA,), '1FEA -> 1FEA';
ok Uni.new(0x1FEB).NFKC.list ~~ (0x038E,), '1FEB -> 038E';
ok Uni.new(0x1FEC).NFKC.list ~~ (0x1FEC,), '1FEC -> 1FEC';
ok Uni.new(0x1FED).NFKC.list ~~ (0x0020, 0x0308, 0x0300,), '1FED -> 0020 0308 0300';
ok Uni.new(0x1FEE).NFKC.list ~~ (0x0020, 0x0308, 0x0301,), '1FEE -> 0020 0308 0301';
ok Uni.new(0x1FEF).NFKC.list ~~ (0x0060,), '1FEF -> 0060';
ok Uni.new(0x1FF2).NFKC.list ~~ (0x1FF2,), '1FF2 -> 1FF2';
ok Uni.new(0x1FF3).NFKC.list ~~ (0x1FF3,), '1FF3 -> 1FF3';
ok Uni.new(0x1FF4).NFKC.list ~~ (0x1FF4,), '1FF4 -> 1FF4';
ok Uni.new(0x1FF6).NFKC.list ~~ (0x1FF6,), '1FF6 -> 1FF6';
ok Uni.new(0x1FF7).NFKC.list ~~ (0x1FF7,), '1FF7 -> 1FF7';
ok Uni.new(0x1FF8).NFKC.list ~~ (0x1FF8,), '1FF8 -> 1FF8';
ok Uni.new(0x1FF9).NFKC.list ~~ (0x038C,), '1FF9 -> 038C';
ok Uni.new(0x1FFA).NFKC.list ~~ (0x1FFA,), '1FFA -> 1FFA';
ok Uni.new(0x1FFB).NFKC.list ~~ (0x038F,), '1FFB -> 038F';
ok Uni.new(0x1FFC).NFKC.list ~~ (0x1FFC,), '1FFC -> 1FFC';
ok Uni.new(0x1FFD).NFKC.list ~~ (0x0020, 0x0301,), '1FFD -> 0020 0301';
ok Uni.new(0x1FFE).NFKC.list ~~ (0x0020, 0x0314,), '1FFE -> 0020 0314';
ok Uni.new(0x2000).NFKC.list ~~ (0x0020,), '2000 -> 0020';
ok Uni.new(0x2001).NFKC.list ~~ (0x0020,), '2001 -> 0020';
ok Uni.new(0x2002).NFKC.list ~~ (0x0020,), '2002 -> 0020';
ok Uni.new(0x2003).NFKC.list ~~ (0x0020,), '2003 -> 0020';
ok Uni.new(0x2004).NFKC.list ~~ (0x0020,), '2004 -> 0020';
ok Uni.new(0x2005).NFKC.list ~~ (0x0020,), '2005 -> 0020';
ok Uni.new(0x2006).NFKC.list ~~ (0x0020,), '2006 -> 0020';
ok Uni.new(0x2007).NFKC.list ~~ (0x0020,), '2007 -> 0020';
ok Uni.new(0x2008).NFKC.list ~~ (0x0020,), '2008 -> 0020';
ok Uni.new(0x2009).NFKC.list ~~ (0x0020,), '2009 -> 0020';
ok Uni.new(0x200A).NFKC.list ~~ (0x0020,), '200A -> 0020';
ok Uni.new(0x2011).NFKC.list ~~ (0x2010,), '2011 -> 2010';
ok Uni.new(0x2017).NFKC.list ~~ (0x0020, 0x0333,), '2017 -> 0020 0333';
ok Uni.new(0x2024).NFKC.list ~~ (0x002E,), '2024 -> 002E';
ok Uni.new(0x2025).NFKC.list ~~ (0x002E, 0x002E,), '2025 -> 002E 002E';
ok Uni.new(0x2026).NFKC.list ~~ (0x002E, 0x002E, 0x002E,), '2026 -> 002E 002E 002E';
ok Uni.new(0x202F).NFKC.list ~~ (0x0020,), '202F -> 0020';
ok Uni.new(0x2033).NFKC.list ~~ (0x2032, 0x2032,), '2033 -> 2032 2032';
ok Uni.new(0x2034).NFKC.list ~~ (0x2032, 0x2032, 0x2032,), '2034 -> 2032 2032 2032';
ok Uni.new(0x2036).NFKC.list ~~ (0x2035, 0x2035,), '2036 -> 2035 2035';
ok Uni.new(0x2037).NFKC.list ~~ (0x2035, 0x2035, 0x2035,), '2037 -> 2035 2035 2035';
ok Uni.new(0x203C).NFKC.list ~~ (0x0021, 0x0021,), '203C -> 0021 0021';
ok Uni.new(0x203E).NFKC.list ~~ (0x0020, 0x0305,), '203E -> 0020 0305';
ok Uni.new(0x2047).NFKC.list ~~ (0x003F, 0x003F,), '2047 -> 003F 003F';
ok Uni.new(0x2048).NFKC.list ~~ (0x003F, 0x0021,), '2048 -> 003F 0021';
ok Uni.new(0x2049).NFKC.list ~~ (0x0021, 0x003F,), '2049 -> 0021 003F';
ok Uni.new(0x2057).NFKC.list ~~ (0x2032, 0x2032, 0x2032, 0x2032,), '2057 -> 2032 2032 2032 2032';
ok Uni.new(0x205F).NFKC.list ~~ (0x0020,), '205F -> 0020';
ok Uni.new(0x2070).NFKC.list ~~ (0x0030,), '2070 -> 0030';
ok Uni.new(0x2071).NFKC.list ~~ (0x0069,), '2071 -> 0069';
ok Uni.new(0x2074).NFKC.list ~~ (0x0034,), '2074 -> 0034';
ok Uni.new(0x2075).NFKC.list ~~ (0x0035,), '2075 -> 0035';
ok Uni.new(0x2076).NFKC.list ~~ (0x0036,), '2076 -> 0036';
ok Uni.new(0x2077).NFKC.list ~~ (0x0037,), '2077 -> 0037';
ok Uni.new(0x2078).NFKC.list ~~ (0x0038,), '2078 -> 0038';
ok Uni.new(0x2079).NFKC.list ~~ (0x0039,), '2079 -> 0039';
ok Uni.new(0x207A).NFKC.list ~~ (0x002B,), '207A -> 002B';
ok Uni.new(0x207B).NFKC.list ~~ (0x2212,), '207B -> 2212';
ok Uni.new(0x207C).NFKC.list ~~ (0x003D,), '207C -> 003D';
ok Uni.new(0x207D).NFKC.list ~~ (0x0028,), '207D -> 0028';
ok Uni.new(0x207E).NFKC.list ~~ (0x0029,), '207E -> 0029';
ok Uni.new(0x207F).NFKC.list ~~ (0x006E,), '207F -> 006E';
ok Uni.new(0x2080).NFKC.list ~~ (0x0030,), '2080 -> 0030';
ok Uni.new(0x2081).NFKC.list ~~ (0x0031,), '2081 -> 0031';
ok Uni.new(0x2082).NFKC.list ~~ (0x0032,), '2082 -> 0032';
ok Uni.new(0x2083).NFKC.list ~~ (0x0033,), '2083 -> 0033';
ok Uni.new(0x2084).NFKC.list ~~ (0x0034,), '2084 -> 0034';
ok Uni.new(0x2085).NFKC.list ~~ (0x0035,), '2085 -> 0035';
ok Uni.new(0x2086).NFKC.list ~~ (0x0036,), '2086 -> 0036';
ok Uni.new(0x2087).NFKC.list ~~ (0x0037,), '2087 -> 0037';
ok Uni.new(0x2088).NFKC.list ~~ (0x0038,), '2088 -> 0038';
ok Uni.new(0x2089).NFKC.list ~~ (0x0039,), '2089 -> 0039';
ok Uni.new(0x208A).NFKC.list ~~ (0x002B,), '208A -> 002B';
ok Uni.new(0x208B).NFKC.list ~~ (0x2212,), '208B -> 2212';
ok Uni.new(0x208C).NFKC.list ~~ (0x003D,), '208C -> 003D';
ok Uni.new(0x208D).NFKC.list ~~ (0x0028,), '208D -> 0028';
ok Uni.new(0x208E).NFKC.list ~~ (0x0029,), '208E -> 0029';
ok Uni.new(0x2090).NFKC.list ~~ (0x0061,), '2090 -> 0061';
ok Uni.new(0x2091).NFKC.list ~~ (0x0065,), '2091 -> 0065';
ok Uni.new(0x2092).NFKC.list ~~ (0x006F,), '2092 -> 006F';
ok Uni.new(0x2093).NFKC.list ~~ (0x0078,), '2093 -> 0078';
ok Uni.new(0x2094).NFKC.list ~~ (0x0259,), '2094 -> 0259';
ok Uni.new(0x2095).NFKC.list ~~ (0x0068,), '2095 -> 0068';
ok Uni.new(0x2096).NFKC.list ~~ (0x006B,), '2096 -> 006B';
ok Uni.new(0x2097).NFKC.list ~~ (0x006C,), '2097 -> 006C';
ok Uni.new(0x2098).NFKC.list ~~ (0x006D,), '2098 -> 006D';
ok Uni.new(0x2099).NFKC.list ~~ (0x006E,), '2099 -> 006E';
ok Uni.new(0x209A).NFKC.list ~~ (0x0070,), '209A -> 0070';
ok Uni.new(0x209B).NFKC.list ~~ (0x0073,), '209B -> 0073';
ok Uni.new(0x209C).NFKC.list ~~ (0x0074,), '209C -> 0074';
ok Uni.new(0x20A8).NFKC.list ~~ (0x0052, 0x0073,), '20A8 -> 0052 0073';
ok Uni.new(0x2100).NFKC.list ~~ (0x0061, 0x002F, 0x0063,), '2100 -> 0061 002F 0063';
ok Uni.new(0x2101).NFKC.list ~~ (0x0061, 0x002F, 0x0073,), '2101 -> 0061 002F 0073';
ok Uni.new(0x2102).NFKC.list ~~ (0x0043,), '2102 -> 0043';
ok Uni.new(0x2103).NFKC.list ~~ (0x00B0, 0x0043,), '2103 -> 00B0 0043';
ok Uni.new(0x2105).NFKC.list ~~ (0x0063, 0x002F, 0x006F,), '2105 -> 0063 002F 006F';
ok Uni.new(0x2106).NFKC.list ~~ (0x0063, 0x002F, 0x0075,), '2106 -> 0063 002F 0075';
ok Uni.new(0x2107).NFKC.list ~~ (0x0190,), '2107 -> 0190';
ok Uni.new(0x2109).NFKC.list ~~ (0x00B0, 0x0046,), '2109 -> 00B0 0046';
ok Uni.new(0x210A).NFKC.list ~~ (0x0067,), '210A -> 0067';
ok Uni.new(0x210B).NFKC.list ~~ (0x0048,), '210B -> 0048';
ok Uni.new(0x210C).NFKC.list ~~ (0x0048,), '210C -> 0048';
ok Uni.new(0x210D).NFKC.list ~~ (0x0048,), '210D -> 0048';
ok Uni.new(0x210E).NFKC.list ~~ (0x0068,), '210E -> 0068';
ok Uni.new(0x210F).NFKC.list ~~ (0x0127,), '210F -> 0127';
ok Uni.new(0x2110).NFKC.list ~~ (0x0049,), '2110 -> 0049';
ok Uni.new(0x2111).NFKC.list ~~ (0x0049,), '2111 -> 0049';
ok Uni.new(0x2112).NFKC.list ~~ (0x004C,), '2112 -> 004C';
ok Uni.new(0x2113).NFKC.list ~~ (0x006C,), '2113 -> 006C';
ok Uni.new(0x2115).NFKC.list ~~ (0x004E,), '2115 -> 004E';
ok Uni.new(0x2116).NFKC.list ~~ (0x004E, 0x006F,), '2116 -> 004E 006F';
ok Uni.new(0x2119).NFKC.list ~~ (0x0050,), '2119 -> 0050';
ok Uni.new(0x211A).NFKC.list ~~ (0x0051,), '211A -> 0051';
ok Uni.new(0x211B).NFKC.list ~~ (0x0052,), '211B -> 0052';
ok Uni.new(0x211C).NFKC.list ~~ (0x0052,), '211C -> 0052';
ok Uni.new(0x211D).NFKC.list ~~ (0x0052,), '211D -> 0052';
ok Uni.new(0x2120).NFKC.list ~~ (0x0053, 0x004D,), '2120 -> 0053 004D';
ok Uni.new(0x2121).NFKC.list ~~ (0x0054, 0x0045, 0x004C,), '2121 -> 0054 0045 004C';
ok Uni.new(0x2122).NFKC.list ~~ (0x0054, 0x004D,), '2122 -> 0054 004D';
ok Uni.new(0x2124).NFKC.list ~~ (0x005A,), '2124 -> 005A';
ok Uni.new(0x2126).NFKC.list ~~ (0x03A9,), '2126 -> 03A9';
ok Uni.new(0x2128).NFKC.list ~~ (0x005A,), '2128 -> 005A';
ok Uni.new(0x212A).NFKC.list ~~ (0x004B,), '212A -> 004B';
ok Uni.new(0x212B).NFKC.list ~~ (0x00C5,), '212B -> 00C5';
ok Uni.new(0x212C).NFKC.list ~~ (0x0042,), '212C -> 0042';
ok Uni.new(0x212D).NFKC.list ~~ (0x0043,), '212D -> 0043';
ok Uni.new(0x212F).NFKC.list ~~ (0x0065,), '212F -> 0065';
ok Uni.new(0x2130).NFKC.list ~~ (0x0045,), '2130 -> 0045';
ok Uni.new(0x2131).NFKC.list ~~ (0x0046,), '2131 -> 0046';
ok Uni.new(0x2133).NFKC.list ~~ (0x004D,), '2133 -> 004D';
ok Uni.new(0x2134).NFKC.list ~~ (0x006F,), '2134 -> 006F';
ok Uni.new(0x2135).NFKC.list ~~ (0x05D0,), '2135 -> 05D0';
ok Uni.new(0x2136).NFKC.list ~~ (0x05D1,), '2136 -> 05D1';
ok Uni.new(0x2137).NFKC.list ~~ (0x05D2,), '2137 -> 05D2';
ok Uni.new(0x2138).NFKC.list ~~ (0x05D3,), '2138 -> 05D3';
ok Uni.new(0x2139).NFKC.list ~~ (0x0069,), '2139 -> 0069';
ok Uni.new(0x213B).NFKC.list ~~ (0x0046, 0x0041, 0x0058,), '213B -> 0046 0041 0058';
ok Uni.new(0x213C).NFKC.list ~~ (0x03C0,), '213C -> 03C0';
ok Uni.new(0x213D).NFKC.list ~~ (0x03B3,), '213D -> 03B3';
ok Uni.new(0x213E).NFKC.list ~~ (0x0393,), '213E -> 0393';
ok Uni.new(0x213F).NFKC.list ~~ (0x03A0,), '213F -> 03A0';
ok Uni.new(0x2140).NFKC.list ~~ (0x2211,), '2140 -> 2211';
ok Uni.new(0x2145).NFKC.list ~~ (0x0044,), '2145 -> 0044';
ok Uni.new(0x2146).NFKC.list ~~ (0x0064,), '2146 -> 0064';
ok Uni.new(0x2147).NFKC.list ~~ (0x0065,), '2147 -> 0065';
ok Uni.new(0x2148).NFKC.list ~~ (0x0069,), '2148 -> 0069';
ok Uni.new(0x2149).NFKC.list ~~ (0x006A,), '2149 -> 006A';
ok Uni.new(0x2150).NFKC.list ~~ (0x0031, 0x2044, 0x0037,), '2150 -> 0031 2044 0037';
ok Uni.new(0x2151).NFKC.list ~~ (0x0031, 0x2044, 0x0039,), '2151 -> 0031 2044 0039';
ok Uni.new(0x2152).NFKC.list ~~ (0x0031, 0x2044, 0x0031, 0x0030,), '2152 -> 0031 2044 0031 0030';
ok Uni.new(0x2153).NFKC.list ~~ (0x0031, 0x2044, 0x0033,), '2153 -> 0031 2044 0033';
ok Uni.new(0x2154).NFKC.list ~~ (0x0032, 0x2044, 0x0033,), '2154 -> 0032 2044 0033';
ok Uni.new(0x2155).NFKC.list ~~ (0x0031, 0x2044, 0x0035,), '2155 -> 0031 2044 0035';
ok Uni.new(0x2156).NFKC.list ~~ (0x0032, 0x2044, 0x0035,), '2156 -> 0032 2044 0035';
ok Uni.new(0x2157).NFKC.list ~~ (0x0033, 0x2044, 0x0035,), '2157 -> 0033 2044 0035';
ok Uni.new(0x2158).NFKC.list ~~ (0x0034, 0x2044, 0x0035,), '2158 -> 0034 2044 0035';
ok Uni.new(0x2159).NFKC.list ~~ (0x0031, 0x2044, 0x0036,), '2159 -> 0031 2044 0036';
ok Uni.new(0x215A).NFKC.list ~~ (0x0035, 0x2044, 0x0036,), '215A -> 0035 2044 0036';
ok Uni.new(0x215B).NFKC.list ~~ (0x0031, 0x2044, 0x0038,), '215B -> 0031 2044 0038';
ok Uni.new(0x215C).NFKC.list ~~ (0x0033, 0x2044, 0x0038,), '215C -> 0033 2044 0038';
ok Uni.new(0x215D).NFKC.list ~~ (0x0035, 0x2044, 0x0038,), '215D -> 0035 2044 0038';
ok Uni.new(0x215E).NFKC.list ~~ (0x0037, 0x2044, 0x0038,), '215E -> 0037 2044 0038';
ok Uni.new(0x215F).NFKC.list ~~ (0x0031, 0x2044,), '215F -> 0031 2044';
ok Uni.new(0x2160).NFKC.list ~~ (0x0049,), '2160 -> 0049';
ok Uni.new(0x2161).NFKC.list ~~ (0x0049, 0x0049,), '2161 -> 0049 0049';
ok Uni.new(0x2162).NFKC.list ~~ (0x0049, 0x0049, 0x0049,), '2162 -> 0049 0049 0049';
ok Uni.new(0x2163).NFKC.list ~~ (0x0049, 0x0056,), '2163 -> 0049 0056';
ok Uni.new(0x2164).NFKC.list ~~ (0x0056,), '2164 -> 0056';
ok Uni.new(0x2165).NFKC.list ~~ (0x0056, 0x0049,), '2165 -> 0056 0049';
ok Uni.new(0x2166).NFKC.list ~~ (0x0056, 0x0049, 0x0049,), '2166 -> 0056 0049 0049';
ok Uni.new(0x2167).NFKC.list ~~ (0x0056, 0x0049, 0x0049, 0x0049,), '2167 -> 0056 0049 0049 0049';
ok Uni.new(0x2168).NFKC.list ~~ (0x0049, 0x0058,), '2168 -> 0049 0058';
ok Uni.new(0x2169).NFKC.list ~~ (0x0058,), '2169 -> 0058';
ok Uni.new(0x216A).NFKC.list ~~ (0x0058, 0x0049,), '216A -> 0058 0049';
ok Uni.new(0x216B).NFKC.list ~~ (0x0058, 0x0049, 0x0049,), '216B -> 0058 0049 0049';
ok Uni.new(0x216C).NFKC.list ~~ (0x004C,), '216C -> 004C';
ok Uni.new(0x216D).NFKC.list ~~ (0x0043,), '216D -> 0043';
ok Uni.new(0x216E).NFKC.list ~~ (0x0044,), '216E -> 0044';
ok Uni.new(0x216F).NFKC.list ~~ (0x004D,), '216F -> 004D';
ok Uni.new(0x2170).NFKC.list ~~ (0x0069,), '2170 -> 0069';
ok Uni.new(0x2171).NFKC.list ~~ (0x0069, 0x0069,), '2171 -> 0069 0069';
ok Uni.new(0x2172).NFKC.list ~~ (0x0069, 0x0069, 0x0069,), '2172 -> 0069 0069 0069';
ok Uni.new(0x2173).NFKC.list ~~ (0x0069, 0x0076,), '2173 -> 0069 0076';
ok Uni.new(0x2174).NFKC.list ~~ (0x0076,), '2174 -> 0076';
ok Uni.new(0x2175).NFKC.list ~~ (0x0076, 0x0069,), '2175 -> 0076 0069';
ok Uni.new(0x2176).NFKC.list ~~ (0x0076, 0x0069, 0x0069,), '2176 -> 0076 0069 0069';
ok Uni.new(0x2177).NFKC.list ~~ (0x0076, 0x0069, 0x0069, 0x0069,), '2177 -> 0076 0069 0069 0069';
ok Uni.new(0x2178).NFKC.list ~~ (0x0069, 0x0078,), '2178 -> 0069 0078';
ok Uni.new(0x2179).NFKC.list ~~ (0x0078,), '2179 -> 0078';
ok Uni.new(0x217A).NFKC.list ~~ (0x0078, 0x0069,), '217A -> 0078 0069';
ok Uni.new(0x217B).NFKC.list ~~ (0x0078, 0x0069, 0x0069,), '217B -> 0078 0069 0069';
ok Uni.new(0x217C).NFKC.list ~~ (0x006C,), '217C -> 006C';
ok Uni.new(0x217D).NFKC.list ~~ (0x0063,), '217D -> 0063';
ok Uni.new(0x217E).NFKC.list ~~ (0x0064,), '217E -> 0064';
ok Uni.new(0x217F).NFKC.list ~~ (0x006D,), '217F -> 006D';
ok Uni.new(0x2189).NFKC.list ~~ (0x0030, 0x2044, 0x0033,), '2189 -> 0030 2044 0033';
ok Uni.new(0x219A).NFKC.list ~~ (0x219A,), '219A -> 219A';
ok Uni.new(0x219B).NFKC.list ~~ (0x219B,), '219B -> 219B';
ok Uni.new(0x21AE).NFKC.list ~~ (0x21AE,), '21AE -> 21AE';
ok Uni.new(0x21CD).NFKC.list ~~ (0x21CD,), '21CD -> 21CD';
ok Uni.new(0x21CE).NFKC.list ~~ (0x21CE,), '21CE -> 21CE';
ok Uni.new(0x21CF).NFKC.list ~~ (0x21CF,), '21CF -> 21CF';
ok Uni.new(0x2204).NFKC.list ~~ (0x2204,), '2204 -> 2204';
ok Uni.new(0x2209).NFKC.list ~~ (0x2209,), '2209 -> 2209';
ok Uni.new(0x220C).NFKC.list ~~ (0x220C,), '220C -> 220C';
ok Uni.new(0x2224).NFKC.list ~~ (0x2224,), '2224 -> 2224';
ok Uni.new(0x2226).NFKC.list ~~ (0x2226,), '2226 -> 2226';
ok Uni.new(0x222C).NFKC.list ~~ (0x222B, 0x222B,), '222C -> 222B 222B';
ok Uni.new(0x222D).NFKC.list ~~ (0x222B, 0x222B, 0x222B,), '222D -> 222B 222B 222B';
ok Uni.new(0x222F).NFKC.list ~~ (0x222E, 0x222E,), '222F -> 222E 222E';
ok Uni.new(0x2230).NFKC.list ~~ (0x222E, 0x222E, 0x222E,), '2230 -> 222E 222E 222E';
ok Uni.new(0x2241).NFKC.list ~~ (0x2241,), '2241 -> 2241';
ok Uni.new(0x2244).NFKC.list ~~ (0x2244,), '2244 -> 2244';
ok Uni.new(0x2247).NFKC.list ~~ (0x2247,), '2247 -> 2247';
ok Uni.new(0x2249).NFKC.list ~~ (0x2249,), '2249 -> 2249';
ok Uni.new(0x2260).NFKC.list ~~ (0x2260,), '2260 -> 2260';
ok Uni.new(0x2262).NFKC.list ~~ (0x2262,), '2262 -> 2262';
ok Uni.new(0x226D).NFKC.list ~~ (0x226D,), '226D -> 226D';
ok Uni.new(0x226E).NFKC.list ~~ (0x226E,), '226E -> 226E';
ok Uni.new(0x226F).NFKC.list ~~ (0x226F,), '226F -> 226F';
ok Uni.new(0x2270).NFKC.list ~~ (0x2270,), '2270 -> 2270';
ok Uni.new(0x2271).NFKC.list ~~ (0x2271,), '2271 -> 2271';
ok Uni.new(0x2274).NFKC.list ~~ (0x2274,), '2274 -> 2274';
ok Uni.new(0x2275).NFKC.list ~~ (0x2275,), '2275 -> 2275';
ok Uni.new(0x2278).NFKC.list ~~ (0x2278,), '2278 -> 2278';
ok Uni.new(0x2279).NFKC.list ~~ (0x2279,), '2279 -> 2279';
ok Uni.new(0x2280).NFKC.list ~~ (0x2280,), '2280 -> 2280';
ok Uni.new(0x2281).NFKC.list ~~ (0x2281,), '2281 -> 2281';
ok Uni.new(0x2284).NFKC.list ~~ (0x2284,), '2284 -> 2284';
ok Uni.new(0x2285).NFKC.list ~~ (0x2285,), '2285 -> 2285';
ok Uni.new(0x2288).NFKC.list ~~ (0x2288,), '2288 -> 2288';
ok Uni.new(0x2289).NFKC.list ~~ (0x2289,), '2289 -> 2289';
ok Uni.new(0x22AC).NFKC.list ~~ (0x22AC,), '22AC -> 22AC';
ok Uni.new(0x22AD).NFKC.list ~~ (0x22AD,), '22AD -> 22AD';
ok Uni.new(0x22AE).NFKC.list ~~ (0x22AE,), '22AE -> 22AE';
ok Uni.new(0x22AF).NFKC.list ~~ (0x22AF,), '22AF -> 22AF';
ok Uni.new(0x22E0).NFKC.list ~~ (0x22E0,), '22E0 -> 22E0';
ok Uni.new(0x22E1).NFKC.list ~~ (0x22E1,), '22E1 -> 22E1';
ok Uni.new(0x22E2).NFKC.list ~~ (0x22E2,), '22E2 -> 22E2';
ok Uni.new(0x22E3).NFKC.list ~~ (0x22E3,), '22E3 -> 22E3';
ok Uni.new(0x22EA).NFKC.list ~~ (0x22EA,), '22EA -> 22EA';
ok Uni.new(0x22EB).NFKC.list ~~ (0x22EB,), '22EB -> 22EB';
ok Uni.new(0x22EC).NFKC.list ~~ (0x22EC,), '22EC -> 22EC';
ok Uni.new(0x22ED).NFKC.list ~~ (0x22ED,), '22ED -> 22ED';
ok Uni.new(0x2329).NFKC.list ~~ (0x3008,), '2329 -> 3008';
ok Uni.new(0x232A).NFKC.list ~~ (0x3009,), '232A -> 3009';
ok Uni.new(0x2460).NFKC.list ~~ (0x0031,), '2460 -> 0031';
ok Uni.new(0x2461).NFKC.list ~~ (0x0032,), '2461 -> 0032';
ok Uni.new(0x2462).NFKC.list ~~ (0x0033,), '2462 -> 0033';
ok Uni.new(0x2463).NFKC.list ~~ (0x0034,), '2463 -> 0034';
ok Uni.new(0x2464).NFKC.list ~~ (0x0035,), '2464 -> 0035';
ok Uni.new(0x2465).NFKC.list ~~ (0x0036,), '2465 -> 0036';
ok Uni.new(0x2466).NFKC.list ~~ (0x0037,), '2466 -> 0037';
ok Uni.new(0x2467).NFKC.list ~~ (0x0038,), '2467 -> 0038';
ok Uni.new(0x2468).NFKC.list ~~ (0x0039,), '2468 -> 0039';
ok Uni.new(0x2469).NFKC.list ~~ (0x0031, 0x0030,), '2469 -> 0031 0030';
ok Uni.new(0x246A).NFKC.list ~~ (0x0031, 0x0031,), '246A -> 0031 0031';
ok Uni.new(0x246B).NFKC.list ~~ (0x0031, 0x0032,), '246B -> 0031 0032';
ok Uni.new(0x246C).NFKC.list ~~ (0x0031, 0x0033,), '246C -> 0031 0033';
ok Uni.new(0x246D).NFKC.list ~~ (0x0031, 0x0034,), '246D -> 0031 0034';
ok Uni.new(0x246E).NFKC.list ~~ (0x0031, 0x0035,), '246E -> 0031 0035';
ok Uni.new(0x246F).NFKC.list ~~ (0x0031, 0x0036,), '246F -> 0031 0036';
ok Uni.new(0x2470).NFKC.list ~~ (0x0031, 0x0037,), '2470 -> 0031 0037';
ok Uni.new(0x2471).NFKC.list ~~ (0x0031, 0x0038,), '2471 -> 0031 0038';
ok Uni.new(0x2472).NFKC.list ~~ (0x0031, 0x0039,), '2472 -> 0031 0039';
ok Uni.new(0x2473).NFKC.list ~~ (0x0032, 0x0030,), '2473 -> 0032 0030';
ok Uni.new(0x2474).NFKC.list ~~ (0x0028, 0x0031, 0x0029,), '2474 -> 0028 0031 0029';
ok Uni.new(0x2475).NFKC.list ~~ (0x0028, 0x0032, 0x0029,), '2475 -> 0028 0032 0029';
ok Uni.new(0x2476).NFKC.list ~~ (0x0028, 0x0033, 0x0029,), '2476 -> 0028 0033 0029';
ok Uni.new(0x2477).NFKC.list ~~ (0x0028, 0x0034, 0x0029,), '2477 -> 0028 0034 0029';
ok Uni.new(0x2478).NFKC.list ~~ (0x0028, 0x0035, 0x0029,), '2478 -> 0028 0035 0029';
ok Uni.new(0x2479).NFKC.list ~~ (0x0028, 0x0036, 0x0029,), '2479 -> 0028 0036 0029';
ok Uni.new(0x247A).NFKC.list ~~ (0x0028, 0x0037, 0x0029,), '247A -> 0028 0037 0029';
ok Uni.new(0x247B).NFKC.list ~~ (0x0028, 0x0038, 0x0029,), '247B -> 0028 0038 0029';
ok Uni.new(0x247C).NFKC.list ~~ (0x0028, 0x0039, 0x0029,), '247C -> 0028 0039 0029';
ok Uni.new(0x247D).NFKC.list ~~ (0x0028, 0x0031, 0x0030, 0x0029,), '247D -> 0028 0031 0030 0029';
ok Uni.new(0x247E).NFKC.list ~~ (0x0028, 0x0031, 0x0031, 0x0029,), '247E -> 0028 0031 0031 0029';
ok Uni.new(0x247F).NFKC.list ~~ (0x0028, 0x0031, 0x0032, 0x0029,), '247F -> 0028 0031 0032 0029';
ok Uni.new(0x2480).NFKC.list ~~ (0x0028, 0x0031, 0x0033, 0x0029,), '2480 -> 0028 0031 0033 0029';
ok Uni.new(0x2481).NFKC.list ~~ (0x0028, 0x0031, 0x0034, 0x0029,), '2481 -> 0028 0031 0034 0029';
ok Uni.new(0x2482).NFKC.list ~~ (0x0028, 0x0031, 0x0035, 0x0029,), '2482 -> 0028 0031 0035 0029';
ok Uni.new(0x2483).NFKC.list ~~ (0x0028, 0x0031, 0x0036, 0x0029,), '2483 -> 0028 0031 0036 0029';
ok Uni.new(0x2484).NFKC.list ~~ (0x0028, 0x0031, 0x0037, 0x0029,), '2484 -> 0028 0031 0037 0029';
ok Uni.new(0x2485).NFKC.list ~~ (0x0028, 0x0031, 0x0038, 0x0029,), '2485 -> 0028 0031 0038 0029';
ok Uni.new(0x2486).NFKC.list ~~ (0x0028, 0x0031, 0x0039, 0x0029,), '2486 -> 0028 0031 0039 0029';
ok Uni.new(0x2487).NFKC.list ~~ (0x0028, 0x0032, 0x0030, 0x0029,), '2487 -> 0028 0032 0030 0029';
ok Uni.new(0x2488).NFKC.list ~~ (0x0031, 0x002E,), '2488 -> 0031 002E';
ok Uni.new(0x2489).NFKC.list ~~ (0x0032, 0x002E,), '2489 -> 0032 002E';
ok Uni.new(0x248A).NFKC.list ~~ (0x0033, 0x002E,), '248A -> 0033 002E';
ok Uni.new(0x248B).NFKC.list ~~ (0x0034, 0x002E,), '248B -> 0034 002E';
ok Uni.new(0x248C).NFKC.list ~~ (0x0035, 0x002E,), '248C -> 0035 002E';
ok Uni.new(0x248D).NFKC.list ~~ (0x0036, 0x002E,), '248D -> 0036 002E';
ok Uni.new(0x248E).NFKC.list ~~ (0x0037, 0x002E,), '248E -> 0037 002E';
ok Uni.new(0x248F).NFKC.list ~~ (0x0038, 0x002E,), '248F -> 0038 002E';
ok Uni.new(0x2490).NFKC.list ~~ (0x0039, 0x002E,), '2490 -> 0039 002E';
ok Uni.new(0x2491).NFKC.list ~~ (0x0031, 0x0030, 0x002E,), '2491 -> 0031 0030 002E';
ok Uni.new(0x2492).NFKC.list ~~ (0x0031, 0x0031, 0x002E,), '2492 -> 0031 0031 002E';
ok Uni.new(0x2493).NFKC.list ~~ (0x0031, 0x0032, 0x002E,), '2493 -> 0031 0032 002E';
ok Uni.new(0x2494).NFKC.list ~~ (0x0031, 0x0033, 0x002E,), '2494 -> 0031 0033 002E';
ok Uni.new(0x2495).NFKC.list ~~ (0x0031, 0x0034, 0x002E,), '2495 -> 0031 0034 002E';
ok Uni.new(0x2496).NFKC.list ~~ (0x0031, 0x0035, 0x002E,), '2496 -> 0031 0035 002E';
ok Uni.new(0x2497).NFKC.list ~~ (0x0031, 0x0036, 0x002E,), '2497 -> 0031 0036 002E';
ok Uni.new(0x2498).NFKC.list ~~ (0x0031, 0x0037, 0x002E,), '2498 -> 0031 0037 002E';
ok Uni.new(0x2499).NFKC.list ~~ (0x0031, 0x0038, 0x002E,), '2499 -> 0031 0038 002E';
ok Uni.new(0x249A).NFKC.list ~~ (0x0031, 0x0039, 0x002E,), '249A -> 0031 0039 002E';
ok Uni.new(0x249B).NFKC.list ~~ (0x0032, 0x0030, 0x002E,), '249B -> 0032 0030 002E';
ok Uni.new(0x249C).NFKC.list ~~ (0x0028, 0x0061, 0x0029,), '249C -> 0028 0061 0029';
ok Uni.new(0x249D).NFKC.list ~~ (0x0028, 0x0062, 0x0029,), '249D -> 0028 0062 0029';
ok Uni.new(0x249E).NFKC.list ~~ (0x0028, 0x0063, 0x0029,), '249E -> 0028 0063 0029';
ok Uni.new(0x249F).NFKC.list ~~ (0x0028, 0x0064, 0x0029,), '249F -> 0028 0064 0029';
ok Uni.new(0x24A0).NFKC.list ~~ (0x0028, 0x0065, 0x0029,), '24A0 -> 0028 0065 0029';
ok Uni.new(0x24A1).NFKC.list ~~ (0x0028, 0x0066, 0x0029,), '24A1 -> 0028 0066 0029';
ok Uni.new(0x24A2).NFKC.list ~~ (0x0028, 0x0067, 0x0029,), '24A2 -> 0028 0067 0029';
ok Uni.new(0x24A3).NFKC.list ~~ (0x0028, 0x0068, 0x0029,), '24A3 -> 0028 0068 0029';
ok Uni.new(0x24A4).NFKC.list ~~ (0x0028, 0x0069, 0x0029,), '24A4 -> 0028 0069 0029';
ok Uni.new(0x24A5).NFKC.list ~~ (0x0028, 0x006A, 0x0029,), '24A5 -> 0028 006A 0029';
ok Uni.new(0x24A6).NFKC.list ~~ (0x0028, 0x006B, 0x0029,), '24A6 -> 0028 006B 0029';
ok Uni.new(0x24A7).NFKC.list ~~ (0x0028, 0x006C, 0x0029,), '24A7 -> 0028 006C 0029';
ok Uni.new(0x24A8).NFKC.list ~~ (0x0028, 0x006D, 0x0029,), '24A8 -> 0028 006D 0029';
ok Uni.new(0x24A9).NFKC.list ~~ (0x0028, 0x006E, 0x0029,), '24A9 -> 0028 006E 0029';
ok Uni.new(0x24AA).NFKC.list ~~ (0x0028, 0x006F, 0x0029,), '24AA -> 0028 006F 0029';
ok Uni.new(0x24AB).NFKC.list ~~ (0x0028, 0x0070, 0x0029,), '24AB -> 0028 0070 0029';
ok Uni.new(0x24AC).NFKC.list ~~ (0x0028, 0x0071, 0x0029,), '24AC -> 0028 0071 0029';
ok Uni.new(0x24AD).NFKC.list ~~ (0x0028, 0x0072, 0x0029,), '24AD -> 0028 0072 0029';
ok Uni.new(0x24AE).NFKC.list ~~ (0x0028, 0x0073, 0x0029,), '24AE -> 0028 0073 0029';
ok Uni.new(0x24AF).NFKC.list ~~ (0x0028, 0x0074, 0x0029,), '24AF -> 0028 0074 0029';
ok Uni.new(0x24B0).NFKC.list ~~ (0x0028, 0x0075, 0x0029,), '24B0 -> 0028 0075 0029';
ok Uni.new(0x24B1).NFKC.list ~~ (0x0028, 0x0076, 0x0029,), '24B1 -> 0028 0076 0029';
ok Uni.new(0x24B2).NFKC.list ~~ (0x0028, 0x0077, 0x0029,), '24B2 -> 0028 0077 0029';
ok Uni.new(0x24B3).NFKC.list ~~ (0x0028, 0x0078, 0x0029,), '24B3 -> 0028 0078 0029';
ok Uni.new(0x24B4).NFKC.list ~~ (0x0028, 0x0079, 0x0029,), '24B4 -> 0028 0079 0029';
ok Uni.new(0x24B5).NFKC.list ~~ (0x0028, 0x007A, 0x0029,), '24B5 -> 0028 007A 0029';
ok Uni.new(0x24B6).NFKC.list ~~ (0x0041,), '24B6 -> 0041';
ok Uni.new(0x24B7).NFKC.list ~~ (0x0042,), '24B7 -> 0042';
ok Uni.new(0x24B8).NFKC.list ~~ (0x0043,), '24B8 -> 0043';
ok Uni.new(0x24B9).NFKC.list ~~ (0x0044,), '24B9 -> 0044';
ok Uni.new(0x24BA).NFKC.list ~~ (0x0045,), '24BA -> 0045';
ok Uni.new(0x24BB).NFKC.list ~~ (0x0046,), '24BB -> 0046';
ok Uni.new(0x24BC).NFKC.list ~~ (0x0047,), '24BC -> 0047';
ok Uni.new(0x24BD).NFKC.list ~~ (0x0048,), '24BD -> 0048';
ok Uni.new(0x24BE).NFKC.list ~~ (0x0049,), '24BE -> 0049';
ok Uni.new(0x24BF).NFKC.list ~~ (0x004A,), '24BF -> 004A';
ok Uni.new(0x24C0).NFKC.list ~~ (0x004B,), '24C0 -> 004B';
ok Uni.new(0x24C1).NFKC.list ~~ (0x004C,), '24C1 -> 004C';
ok Uni.new(0x24C2).NFKC.list ~~ (0x004D,), '24C2 -> 004D';
ok Uni.new(0x24C3).NFKC.list ~~ (0x004E,), '24C3 -> 004E';
ok Uni.new(0x24C4).NFKC.list ~~ (0x004F,), '24C4 -> 004F';
ok Uni.new(0x24C5).NFKC.list ~~ (0x0050,), '24C5 -> 0050';
ok Uni.new(0x24C6).NFKC.list ~~ (0x0051,), '24C6 -> 0051';
ok Uni.new(0x24C7).NFKC.list ~~ (0x0052,), '24C7 -> 0052';
ok Uni.new(0x24C8).NFKC.list ~~ (0x0053,), '24C8 -> 0053';
ok Uni.new(0x24C9).NFKC.list ~~ (0x0054,), '24C9 -> 0054';
ok Uni.new(0x24CA).NFKC.list ~~ (0x0055,), '24CA -> 0055';
ok Uni.new(0x24CB).NFKC.list ~~ (0x0056,), '24CB -> 0056';
ok Uni.new(0x24CC).NFKC.list ~~ (0x0057,), '24CC -> 0057';
ok Uni.new(0x24CD).NFKC.list ~~ (0x0058,), '24CD -> 0058';
ok Uni.new(0x24CE).NFKC.list ~~ (0x0059,), '24CE -> 0059';
ok Uni.new(0x24CF).NFKC.list ~~ (0x005A,), '24CF -> 005A';
ok Uni.new(0x24D0).NFKC.list ~~ (0x0061,), '24D0 -> 0061';
ok Uni.new(0x24D1).NFKC.list ~~ (0x0062,), '24D1 -> 0062';
ok Uni.new(0x24D2).NFKC.list ~~ (0x0063,), '24D2 -> 0063';
ok Uni.new(0x24D3).NFKC.list ~~ (0x0064,), '24D3 -> 0064';
ok Uni.new(0x24D4).NFKC.list ~~ (0x0065,), '24D4 -> 0065';
ok Uni.new(0x24D5).NFKC.list ~~ (0x0066,), '24D5 -> 0066';
ok Uni.new(0x24D6).NFKC.list ~~ (0x0067,), '24D6 -> 0067';
ok Uni.new(0x24D7).NFKC.list ~~ (0x0068,), '24D7 -> 0068';
ok Uni.new(0x24D8).NFKC.list ~~ (0x0069,), '24D8 -> 0069';
ok Uni.new(0x24D9).NFKC.list ~~ (0x006A,), '24D9 -> 006A';
ok Uni.new(0x24DA).NFKC.list ~~ (0x006B,), '24DA -> 006B';
ok Uni.new(0x24DB).NFKC.list ~~ (0x006C,), '24DB -> 006C';
ok Uni.new(0x24DC).NFKC.list ~~ (0x006D,), '24DC -> 006D';
ok Uni.new(0x24DD).NFKC.list ~~ (0x006E,), '24DD -> 006E';
ok Uni.new(0x24DE).NFKC.list ~~ (0x006F,), '24DE -> 006F';
ok Uni.new(0x24DF).NFKC.list ~~ (0x0070,), '24DF -> 0070';
ok Uni.new(0x24E0).NFKC.list ~~ (0x0071,), '24E0 -> 0071';
ok Uni.new(0x24E1).NFKC.list ~~ (0x0072,), '24E1 -> 0072';
ok Uni.new(0x24E2).NFKC.list ~~ (0x0073,), '24E2 -> 0073';
ok Uni.new(0x24E3).NFKC.list ~~ (0x0074,), '24E3 -> 0074';
ok Uni.new(0x24E4).NFKC.list ~~ (0x0075,), '24E4 -> 0075';
ok Uni.new(0x24E5).NFKC.list ~~ (0x0076,), '24E5 -> 0076';
ok Uni.new(0x24E6).NFKC.list ~~ (0x0077,), '24E6 -> 0077';
ok Uni.new(0x24E7).NFKC.list ~~ (0x0078,), '24E7 -> 0078';
ok Uni.new(0x24E8).NFKC.list ~~ (0x0079,), '24E8 -> 0079';
ok Uni.new(0x24E9).NFKC.list ~~ (0x007A,), '24E9 -> 007A';
ok Uni.new(0x24EA).NFKC.list ~~ (0x0030,), '24EA -> 0030';
ok Uni.new(0x2A0C).NFKC.list ~~ (0x222B, 0x222B, 0x222B, 0x222B,), '2A0C -> 222B 222B 222B 222B';
ok Uni.new(0x2A74).NFKC.list ~~ (0x003A, 0x003A, 0x003D,), '2A74 -> 003A 003A 003D';
ok Uni.new(0x2A75).NFKC.list ~~ (0x003D, 0x003D,), '2A75 -> 003D 003D';
ok Uni.new(0x2A76).NFKC.list ~~ (0x003D, 0x003D, 0x003D,), '2A76 -> 003D 003D 003D';
ok Uni.new(0x2ADC).NFKC.list ~~ (0x2ADD, 0x0338,), '2ADC -> 2ADD 0338';
ok Uni.new(0x2C7C).NFKC.list ~~ (0x006A,), '2C7C -> 006A';
ok Uni.new(0x2C7D).NFKC.list ~~ (0x0056,), '2C7D -> 0056';
ok Uni.new(0x2D6F).NFKC.list ~~ (0x2D61,), '2D6F -> 2D61';
ok Uni.new(0x2E9F).NFKC.list ~~ (0x6BCD,), '2E9F -> 6BCD';
ok Uni.new(0x2EF3).NFKC.list ~~ (0x9F9F,), '2EF3 -> 9F9F';
ok Uni.new(0x2F00).NFKC.list ~~ (0x4E00,), '2F00 -> 4E00';
ok Uni.new(0x2F01).NFKC.list ~~ (0x4E28,), '2F01 -> 4E28';
ok Uni.new(0x2F02).NFKC.list ~~ (0x4E36,), '2F02 -> 4E36';
ok Uni.new(0x2F03).NFKC.list ~~ (0x4E3F,), '2F03 -> 4E3F';
ok Uni.new(0x2F04).NFKC.list ~~ (0x4E59,), '2F04 -> 4E59';
ok Uni.new(0x2F05).NFKC.list ~~ (0x4E85,), '2F05 -> 4E85';
ok Uni.new(0x2F06).NFKC.list ~~ (0x4E8C,), '2F06 -> 4E8C';
ok Uni.new(0x2F07).NFKC.list ~~ (0x4EA0,), '2F07 -> 4EA0';
ok Uni.new(0x2F08).NFKC.list ~~ (0x4EBA,), '2F08 -> 4EBA';
ok Uni.new(0x2F09).NFKC.list ~~ (0x513F,), '2F09 -> 513F';
ok Uni.new(0x2F0A).NFKC.list ~~ (0x5165,), '2F0A -> 5165';
ok Uni.new(0x2F0B).NFKC.list ~~ (0x516B,), '2F0B -> 516B';
ok Uni.new(0x2F0C).NFKC.list ~~ (0x5182,), '2F0C -> 5182';
ok Uni.new(0x2F0D).NFKC.list ~~ (0x5196,), '2F0D -> 5196';
ok Uni.new(0x2F0E).NFKC.list ~~ (0x51AB,), '2F0E -> 51AB';
ok Uni.new(0x2F0F).NFKC.list ~~ (0x51E0,), '2F0F -> 51E0';
ok Uni.new(0x2F10).NFKC.list ~~ (0x51F5,), '2F10 -> 51F5';
ok Uni.new(0x2F11).NFKC.list ~~ (0x5200,), '2F11 -> 5200';
ok Uni.new(0x2F12).NFKC.list ~~ (0x529B,), '2F12 -> 529B';
ok Uni.new(0x2F13).NFKC.list ~~ (0x52F9,), '2F13 -> 52F9';
ok Uni.new(0x2F14).NFKC.list ~~ (0x5315,), '2F14 -> 5315';
ok Uni.new(0x2F15).NFKC.list ~~ (0x531A,), '2F15 -> 531A';
ok Uni.new(0x2F16).NFKC.list ~~ (0x5338,), '2F16 -> 5338';
ok Uni.new(0x2F17).NFKC.list ~~ (0x5341,), '2F17 -> 5341';
ok Uni.new(0x2F18).NFKC.list ~~ (0x535C,), '2F18 -> 535C';
ok Uni.new(0x2F19).NFKC.list ~~ (0x5369,), '2F19 -> 5369';
ok Uni.new(0x2F1A).NFKC.list ~~ (0x5382,), '2F1A -> 5382';
ok Uni.new(0x2F1B).NFKC.list ~~ (0x53B6,), '2F1B -> 53B6';
ok Uni.new(0x2F1C).NFKC.list ~~ (0x53C8,), '2F1C -> 53C8';
ok Uni.new(0x2F1D).NFKC.list ~~ (0x53E3,), '2F1D -> 53E3';
ok Uni.new(0x2F1E).NFKC.list ~~ (0x56D7,), '2F1E -> 56D7';
ok Uni.new(0x2F1F).NFKC.list ~~ (0x571F,), '2F1F -> 571F';
ok Uni.new(0x2F20).NFKC.list ~~ (0x58EB,), '2F20 -> 58EB';
ok Uni.new(0x2F21).NFKC.list ~~ (0x5902,), '2F21 -> 5902';
ok Uni.new(0x2F22).NFKC.list ~~ (0x590A,), '2F22 -> 590A';
ok Uni.new(0x2F23).NFKC.list ~~ (0x5915,), '2F23 -> 5915';
ok Uni.new(0x2F24).NFKC.list ~~ (0x5927,), '2F24 -> 5927';
ok Uni.new(0x2F25).NFKC.list ~~ (0x5973,), '2F25 -> 5973';
ok Uni.new(0x2F26).NFKC.list ~~ (0x5B50,), '2F26 -> 5B50';
ok Uni.new(0x2F27).NFKC.list ~~ (0x5B80,), '2F27 -> 5B80';
ok Uni.new(0x2F28).NFKC.list ~~ (0x5BF8,), '2F28 -> 5BF8';
ok Uni.new(0x2F29).NFKC.list ~~ (0x5C0F,), '2F29 -> 5C0F';
ok Uni.new(0x2F2A).NFKC.list ~~ (0x5C22,), '2F2A -> 5C22';
ok Uni.new(0x2F2B).NFKC.list ~~ (0x5C38,), '2F2B -> 5C38';
ok Uni.new(0x2F2C).NFKC.list ~~ (0x5C6E,), '2F2C -> 5C6E';
ok Uni.new(0x2F2D).NFKC.list ~~ (0x5C71,), '2F2D -> 5C71';
ok Uni.new(0x2F2E).NFKC.list ~~ (0x5DDB,), '2F2E -> 5DDB';
ok Uni.new(0x2F2F).NFKC.list ~~ (0x5DE5,), '2F2F -> 5DE5';
ok Uni.new(0x2F30).NFKC.list ~~ (0x5DF1,), '2F30 -> 5DF1';
ok Uni.new(0x2F31).NFKC.list ~~ (0x5DFE,), '2F31 -> 5DFE';
ok Uni.new(0x2F32).NFKC.list ~~ (0x5E72,), '2F32 -> 5E72';
ok Uni.new(0x2F33).NFKC.list ~~ (0x5E7A,), '2F33 -> 5E7A';
ok Uni.new(0x2F34).NFKC.list ~~ (0x5E7F,), '2F34 -> 5E7F';
ok Uni.new(0x2F35).NFKC.list ~~ (0x5EF4,), '2F35 -> 5EF4';
ok Uni.new(0x2F36).NFKC.list ~~ (0x5EFE,), '2F36 -> 5EFE';
ok Uni.new(0x2F37).NFKC.list ~~ (0x5F0B,), '2F37 -> 5F0B';
ok Uni.new(0x2F38).NFKC.list ~~ (0x5F13,), '2F38 -> 5F13';
ok Uni.new(0x2F39).NFKC.list ~~ (0x5F50,), '2F39 -> 5F50';
ok Uni.new(0x2F3A).NFKC.list ~~ (0x5F61,), '2F3A -> 5F61';
ok Uni.new(0x2F3B).NFKC.list ~~ (0x5F73,), '2F3B -> 5F73';
ok Uni.new(0x2F3C).NFKC.list ~~ (0x5FC3,), '2F3C -> 5FC3';
ok Uni.new(0x2F3D).NFKC.list ~~ (0x6208,), '2F3D -> 6208';
ok Uni.new(0x2F3E).NFKC.list ~~ (0x6236,), '2F3E -> 6236';
ok Uni.new(0x2F3F).NFKC.list ~~ (0x624B,), '2F3F -> 624B';
ok Uni.new(0x2F40).NFKC.list ~~ (0x652F,), '2F40 -> 652F';
ok Uni.new(0x2F41).NFKC.list ~~ (0x6534,), '2F41 -> 6534';
ok Uni.new(0x2F42).NFKC.list ~~ (0x6587,), '2F42 -> 6587';
ok Uni.new(0x2F43).NFKC.list ~~ (0x6597,), '2F43 -> 6597';
ok Uni.new(0x2F44).NFKC.list ~~ (0x65A4,), '2F44 -> 65A4';
ok Uni.new(0x2F45).NFKC.list ~~ (0x65B9,), '2F45 -> 65B9';
ok Uni.new(0x2F46).NFKC.list ~~ (0x65E0,), '2F46 -> 65E0';
ok Uni.new(0x2F47).NFKC.list ~~ (0x65E5,), '2F47 -> 65E5';
ok Uni.new(0x2F48).NFKC.list ~~ (0x66F0,), '2F48 -> 66F0';
ok Uni.new(0x2F49).NFKC.list ~~ (0x6708,), '2F49 -> 6708';
ok Uni.new(0x2F4A).NFKC.list ~~ (0x6728,), '2F4A -> 6728';
ok Uni.new(0x2F4B).NFKC.list ~~ (0x6B20,), '2F4B -> 6B20';
ok Uni.new(0x2F4C).NFKC.list ~~ (0x6B62,), '2F4C -> 6B62';
ok Uni.new(0x2F4D).NFKC.list ~~ (0x6B79,), '2F4D -> 6B79';
ok Uni.new(0x2F4E).NFKC.list ~~ (0x6BB3,), '2F4E -> 6BB3';
ok Uni.new(0x2F4F).NFKC.list ~~ (0x6BCB,), '2F4F -> 6BCB';
ok Uni.new(0x2F50).NFKC.list ~~ (0x6BD4,), '2F50 -> 6BD4';
ok Uni.new(0x2F51).NFKC.list ~~ (0x6BDB,), '2F51 -> 6BDB';
ok Uni.new(0x2F52).NFKC.list ~~ (0x6C0F,), '2F52 -> 6C0F';
ok Uni.new(0x2F53).NFKC.list ~~ (0x6C14,), '2F53 -> 6C14';
ok Uni.new(0x2F54).NFKC.list ~~ (0x6C34,), '2F54 -> 6C34';
ok Uni.new(0x2F55).NFKC.list ~~ (0x706B,), '2F55 -> 706B';
ok Uni.new(0x2F56).NFKC.list ~~ (0x722A,), '2F56 -> 722A';
ok Uni.new(0x2F57).NFKC.list ~~ (0x7236,), '2F57 -> 7236';
ok Uni.new(0x2F58).NFKC.list ~~ (0x723B,), '2F58 -> 723B';
ok Uni.new(0x2F59).NFKC.list ~~ (0x723F,), '2F59 -> 723F';
ok Uni.new(0x2F5A).NFKC.list ~~ (0x7247,), '2F5A -> 7247';
ok Uni.new(0x2F5B).NFKC.list ~~ (0x7259,), '2F5B -> 7259';
ok Uni.new(0x2F5C).NFKC.list ~~ (0x725B,), '2F5C -> 725B';
ok Uni.new(0x2F5D).NFKC.list ~~ (0x72AC,), '2F5D -> 72AC';
ok Uni.new(0x2F5E).NFKC.list ~~ (0x7384,), '2F5E -> 7384';
ok Uni.new(0x2F5F).NFKC.list ~~ (0x7389,), '2F5F -> 7389';
ok Uni.new(0x2F60).NFKC.list ~~ (0x74DC,), '2F60 -> 74DC';
ok Uni.new(0x2F61).NFKC.list ~~ (0x74E6,), '2F61 -> 74E6';
ok Uni.new(0x2F62).NFKC.list ~~ (0x7518,), '2F62 -> 7518';
ok Uni.new(0x2F63).NFKC.list ~~ (0x751F,), '2F63 -> 751F';
ok Uni.new(0x2F64).NFKC.list ~~ (0x7528,), '2F64 -> 7528';
ok Uni.new(0x2F65).NFKC.list ~~ (0x7530,), '2F65 -> 7530';
ok Uni.new(0x2F66).NFKC.list ~~ (0x758B,), '2F66 -> 758B';
ok Uni.new(0x2F67).NFKC.list ~~ (0x7592,), '2F67 -> 7592';
ok Uni.new(0x2F68).NFKC.list ~~ (0x7676,), '2F68 -> 7676';
ok Uni.new(0x2F69).NFKC.list ~~ (0x767D,), '2F69 -> 767D';
ok Uni.new(0x2F6A).NFKC.list ~~ (0x76AE,), '2F6A -> 76AE';
ok Uni.new(0x2F6B).NFKC.list ~~ (0x76BF,), '2F6B -> 76BF';
ok Uni.new(0x2F6C).NFKC.list ~~ (0x76EE,), '2F6C -> 76EE';
ok Uni.new(0x2F6D).NFKC.list ~~ (0x77DB,), '2F6D -> 77DB';
ok Uni.new(0x2F6E).NFKC.list ~~ (0x77E2,), '2F6E -> 77E2';
ok Uni.new(0x2F6F).NFKC.list ~~ (0x77F3,), '2F6F -> 77F3';
ok Uni.new(0x2F70).NFKC.list ~~ (0x793A,), '2F70 -> 793A';
ok Uni.new(0x2F71).NFKC.list ~~ (0x79B8,), '2F71 -> 79B8';
ok Uni.new(0x2F72).NFKC.list ~~ (0x79BE,), '2F72 -> 79BE';
ok Uni.new(0x2F73).NFKC.list ~~ (0x7A74,), '2F73 -> 7A74';
ok Uni.new(0x2F74).NFKC.list ~~ (0x7ACB,), '2F74 -> 7ACB';
ok Uni.new(0x2F75).NFKC.list ~~ (0x7AF9,), '2F75 -> 7AF9';
ok Uni.new(0x2F76).NFKC.list ~~ (0x7C73,), '2F76 -> 7C73';
ok Uni.new(0x2F77).NFKC.list ~~ (0x7CF8,), '2F77 -> 7CF8';
ok Uni.new(0x2F78).NFKC.list ~~ (0x7F36,), '2F78 -> 7F36';
ok Uni.new(0x2F79).NFKC.list ~~ (0x7F51,), '2F79 -> 7F51';
ok Uni.new(0x2F7A).NFKC.list ~~ (0x7F8A,), '2F7A -> 7F8A';
ok Uni.new(0x2F7B).NFKC.list ~~ (0x7FBD,), '2F7B -> 7FBD';
ok Uni.new(0x2F7C).NFKC.list ~~ (0x8001,), '2F7C -> 8001';
ok Uni.new(0x2F7D).NFKC.list ~~ (0x800C,), '2F7D -> 800C';
ok Uni.new(0x2F7E).NFKC.list ~~ (0x8012,), '2F7E -> 8012';
ok Uni.new(0x2F7F).NFKC.list ~~ (0x8033,), '2F7F -> 8033';
ok Uni.new(0x2F80).NFKC.list ~~ (0x807F,), '2F80 -> 807F';
ok Uni.new(0x2F81).NFKC.list ~~ (0x8089,), '2F81 -> 8089';
ok Uni.new(0x2F82).NFKC.list ~~ (0x81E3,), '2F82 -> 81E3';
ok Uni.new(0x2F83).NFKC.list ~~ (0x81EA,), '2F83 -> 81EA';
ok Uni.new(0x2F84).NFKC.list ~~ (0x81F3,), '2F84 -> 81F3';
ok Uni.new(0x2F85).NFKC.list ~~ (0x81FC,), '2F85 -> 81FC';
ok Uni.new(0x2F86).NFKC.list ~~ (0x820C,), '2F86 -> 820C';
ok Uni.new(0x2F87).NFKC.list ~~ (0x821B,), '2F87 -> 821B';
ok Uni.new(0x2F88).NFKC.list ~~ (0x821F,), '2F88 -> 821F';
ok Uni.new(0x2F89).NFKC.list ~~ (0x826E,), '2F89 -> 826E';
ok Uni.new(0x2F8A).NFKC.list ~~ (0x8272,), '2F8A -> 8272';
ok Uni.new(0x2F8B).NFKC.list ~~ (0x8278,), '2F8B -> 8278';
ok Uni.new(0x2F8C).NFKC.list ~~ (0x864D,), '2F8C -> 864D';
ok Uni.new(0x2F8D).NFKC.list ~~ (0x866B,), '2F8D -> 866B';
ok Uni.new(0x2F8E).NFKC.list ~~ (0x8840,), '2F8E -> 8840';
ok Uni.new(0x2F8F).NFKC.list ~~ (0x884C,), '2F8F -> 884C';
ok Uni.new(0x2F90).NFKC.list ~~ (0x8863,), '2F90 -> 8863';
ok Uni.new(0x2F91).NFKC.list ~~ (0x897E,), '2F91 -> 897E';
ok Uni.new(0x2F92).NFKC.list ~~ (0x898B,), '2F92 -> 898B';
ok Uni.new(0x2F93).NFKC.list ~~ (0x89D2,), '2F93 -> 89D2';
ok Uni.new(0x2F94).NFKC.list ~~ (0x8A00,), '2F94 -> 8A00';
ok Uni.new(0x2F95).NFKC.list ~~ (0x8C37,), '2F95 -> 8C37';
ok Uni.new(0x2F96).NFKC.list ~~ (0x8C46,), '2F96 -> 8C46';
ok Uni.new(0x2F97).NFKC.list ~~ (0x8C55,), '2F97 -> 8C55';
ok Uni.new(0x2F98).NFKC.list ~~ (0x8C78,), '2F98 -> 8C78';
ok Uni.new(0x2F99).NFKC.list ~~ (0x8C9D,), '2F99 -> 8C9D';
ok Uni.new(0x2F9A).NFKC.list ~~ (0x8D64,), '2F9A -> 8D64';
ok Uni.new(0x2F9B).NFKC.list ~~ (0x8D70,), '2F9B -> 8D70';
ok Uni.new(0x2F9C).NFKC.list ~~ (0x8DB3,), '2F9C -> 8DB3';
ok Uni.new(0x2F9D).NFKC.list ~~ (0x8EAB,), '2F9D -> 8EAB';
ok Uni.new(0x2F9E).NFKC.list ~~ (0x8ECA,), '2F9E -> 8ECA';
ok Uni.new(0x2F9F).NFKC.list ~~ (0x8F9B,), '2F9F -> 8F9B';
ok Uni.new(0x2FA0).NFKC.list ~~ (0x8FB0,), '2FA0 -> 8FB0';
ok Uni.new(0x2FA1).NFKC.list ~~ (0x8FB5,), '2FA1 -> 8FB5';
ok Uni.new(0x2FA2).NFKC.list ~~ (0x9091,), '2FA2 -> 9091';
ok Uni.new(0x2FA3).NFKC.list ~~ (0x9149,), '2FA3 -> 9149';
ok Uni.new(0x2FA4).NFKC.list ~~ (0x91C6,), '2FA4 -> 91C6';
ok Uni.new(0x2FA5).NFKC.list ~~ (0x91CC,), '2FA5 -> 91CC';
ok Uni.new(0x2FA6).NFKC.list ~~ (0x91D1,), '2FA6 -> 91D1';
ok Uni.new(0x2FA7).NFKC.list ~~ (0x9577,), '2FA7 -> 9577';
ok Uni.new(0x2FA8).NFKC.list ~~ (0x9580,), '2FA8 -> 9580';
ok Uni.new(0x2FA9).NFKC.list ~~ (0x961C,), '2FA9 -> 961C';
ok Uni.new(0x2FAA).NFKC.list ~~ (0x96B6,), '2FAA -> 96B6';
ok Uni.new(0x2FAB).NFKC.list ~~ (0x96B9,), '2FAB -> 96B9';
ok Uni.new(0x2FAC).NFKC.list ~~ (0x96E8,), '2FAC -> 96E8';
ok Uni.new(0x2FAD).NFKC.list ~~ (0x9751,), '2FAD -> 9751';
ok Uni.new(0x2FAE).NFKC.list ~~ (0x975E,), '2FAE -> 975E';
ok Uni.new(0x2FAF).NFKC.list ~~ (0x9762,), '2FAF -> 9762';
ok Uni.new(0x2FB0).NFKC.list ~~ (0x9769,), '2FB0 -> 9769';
ok Uni.new(0x2FB1).NFKC.list ~~ (0x97CB,), '2FB1 -> 97CB';
ok Uni.new(0x2FB2).NFKC.list ~~ (0x97ED,), '2FB2 -> 97ED';
ok Uni.new(0x2FB3).NFKC.list ~~ (0x97F3,), '2FB3 -> 97F3';
ok Uni.new(0x2FB4).NFKC.list ~~ (0x9801,), '2FB4 -> 9801';
ok Uni.new(0x2FB5).NFKC.list ~~ (0x98A8,), '2FB5 -> 98A8';
ok Uni.new(0x2FB6).NFKC.list ~~ (0x98DB,), '2FB6 -> 98DB';
ok Uni.new(0x2FB7).NFKC.list ~~ (0x98DF,), '2FB7 -> 98DF';
ok Uni.new(0x2FB8).NFKC.list ~~ (0x9996,), '2FB8 -> 9996';
ok Uni.new(0x2FB9).NFKC.list ~~ (0x9999,), '2FB9 -> 9999';
ok Uni.new(0x2FBA).NFKC.list ~~ (0x99AC,), '2FBA -> 99AC';
ok Uni.new(0x2FBB).NFKC.list ~~ (0x9AA8,), '2FBB -> 9AA8';
ok Uni.new(0x2FBC).NFKC.list ~~ (0x9AD8,), '2FBC -> 9AD8';
ok Uni.new(0x2FBD).NFKC.list ~~ (0x9ADF,), '2FBD -> 9ADF';
ok Uni.new(0x2FBE).NFKC.list ~~ (0x9B25,), '2FBE -> 9B25';
ok Uni.new(0x2FBF).NFKC.list ~~ (0x9B2F,), '2FBF -> 9B2F';
ok Uni.new(0x2FC0).NFKC.list ~~ (0x9B32,), '2FC0 -> 9B32';
ok Uni.new(0x2FC1).NFKC.list ~~ (0x9B3C,), '2FC1 -> 9B3C';
ok Uni.new(0x2FC2).NFKC.list ~~ (0x9B5A,), '2FC2 -> 9B5A';
ok Uni.new(0x2FC3).NFKC.list ~~ (0x9CE5,), '2FC3 -> 9CE5';
ok Uni.new(0x2FC4).NFKC.list ~~ (0x9E75,), '2FC4 -> 9E75';
ok Uni.new(0x2FC5).NFKC.list ~~ (0x9E7F,), '2FC5 -> 9E7F';
ok Uni.new(0x2FC6).NFKC.list ~~ (0x9EA5,), '2FC6 -> 9EA5';
ok Uni.new(0x2FC7).NFKC.list ~~ (0x9EBB,), '2FC7 -> 9EBB';
ok Uni.new(0x2FC8).NFKC.list ~~ (0x9EC3,), '2FC8 -> 9EC3';
ok Uni.new(0x2FC9).NFKC.list ~~ (0x9ECD,), '2FC9 -> 9ECD';
ok Uni.new(0x2FCA).NFKC.list ~~ (0x9ED1,), '2FCA -> 9ED1';
ok Uni.new(0x2FCB).NFKC.list ~~ (0x9EF9,), '2FCB -> 9EF9';
ok Uni.new(0x2FCC).NFKC.list ~~ (0x9EFD,), '2FCC -> 9EFD';
ok Uni.new(0x2FCD).NFKC.list ~~ (0x9F0E,), '2FCD -> 9F0E';
ok Uni.new(0x2FCE).NFKC.list ~~ (0x9F13,), '2FCE -> 9F13';
ok Uni.new(0x2FCF).NFKC.list ~~ (0x9F20,), '2FCF -> 9F20';
ok Uni.new(0x2FD0).NFKC.list ~~ (0x9F3B,), '2FD0 -> 9F3B';
ok Uni.new(0x2FD1).NFKC.list ~~ (0x9F4A,), '2FD1 -> 9F4A';
ok Uni.new(0x2FD2).NFKC.list ~~ (0x9F52,), '2FD2 -> 9F52';
ok Uni.new(0x2FD3).NFKC.list ~~ (0x9F8D,), '2FD3 -> 9F8D';
ok Uni.new(0x2FD4).NFKC.list ~~ (0x9F9C,), '2FD4 -> 9F9C';
ok Uni.new(0x2FD5).NFKC.list ~~ (0x9FA0,), '2FD5 -> 9FA0';
ok Uni.new(0x3000).NFKC.list ~~ (0x0020,), '3000 -> 0020';
ok Uni.new(0x3036).NFKC.list ~~ (0x3012,), '3036 -> 3012';
ok Uni.new(0x3038).NFKC.list ~~ (0x5341,), '3038 -> 5341';
ok Uni.new(0x3039).NFKC.list ~~ (0x5344,), '3039 -> 5344';
ok Uni.new(0x303A).NFKC.list ~~ (0x5345,), '303A -> 5345';
ok Uni.new(0x304C).NFKC.list ~~ (0x304C,), '304C -> 304C';
ok Uni.new(0x304E).NFKC.list ~~ (0x304E,), '304E -> 304E';
ok Uni.new(0x3050).NFKC.list ~~ (0x3050,), '3050 -> 3050';
ok Uni.new(0x3052).NFKC.list ~~ (0x3052,), '3052 -> 3052';
ok Uni.new(0x3054).NFKC.list ~~ (0x3054,), '3054 -> 3054';
ok Uni.new(0x3056).NFKC.list ~~ (0x3056,), '3056 -> 3056';
ok Uni.new(0x3058).NFKC.list ~~ (0x3058,), '3058 -> 3058';
ok Uni.new(0x305A).NFKC.list ~~ (0x305A,), '305A -> 305A';
ok Uni.new(0x305C).NFKC.list ~~ (0x305C,), '305C -> 305C';
ok Uni.new(0x305E).NFKC.list ~~ (0x305E,), '305E -> 305E';
ok Uni.new(0x3060).NFKC.list ~~ (0x3060,), '3060 -> 3060';
ok Uni.new(0x3062).NFKC.list ~~ (0x3062,), '3062 -> 3062';
ok Uni.new(0x3065).NFKC.list ~~ (0x3065,), '3065 -> 3065';
ok Uni.new(0x3067).NFKC.list ~~ (0x3067,), '3067 -> 3067';
ok Uni.new(0x3069).NFKC.list ~~ (0x3069,), '3069 -> 3069';
ok Uni.new(0x3070).NFKC.list ~~ (0x3070,), '3070 -> 3070';
ok Uni.new(0x3071).NFKC.list ~~ (0x3071,), '3071 -> 3071';
ok Uni.new(0x3073).NFKC.list ~~ (0x3073,), '3073 -> 3073';
ok Uni.new(0x3074).NFKC.list ~~ (0x3074,), '3074 -> 3074';
ok Uni.new(0x3076).NFKC.list ~~ (0x3076,), '3076 -> 3076';
ok Uni.new(0x3077).NFKC.list ~~ (0x3077,), '3077 -> 3077';
ok Uni.new(0x3079).NFKC.list ~~ (0x3079,), '3079 -> 3079';
ok Uni.new(0x307A).NFKC.list ~~ (0x307A,), '307A -> 307A';
ok Uni.new(0x307C).NFKC.list ~~ (0x307C,), '307C -> 307C';
ok Uni.new(0x307D).NFKC.list ~~ (0x307D,), '307D -> 307D';
ok Uni.new(0x3094).NFKC.list ~~ (0x3094,), '3094 -> 3094';
ok Uni.new(0x309B).NFKC.list ~~ (0x0020, 0x3099,), '309B -> 0020 3099';
ok Uni.new(0x309C).NFKC.list ~~ (0x0020, 0x309A,), '309C -> 0020 309A';
ok Uni.new(0x309E).NFKC.list ~~ (0x309E,), '309E -> 309E';
ok Uni.new(0x309F).NFKC.list ~~ (0x3088, 0x308A,), '309F -> 3088 308A';
ok Uni.new(0x30AC).NFKC.list ~~ (0x30AC,), '30AC -> 30AC';
ok Uni.new(0x30AE).NFKC.list ~~ (0x30AE,), '30AE -> 30AE';
ok Uni.new(0x30B0).NFKC.list ~~ (0x30B0,), '30B0 -> 30B0';
ok Uni.new(0x30B2).NFKC.list ~~ (0x30B2,), '30B2 -> 30B2';
ok Uni.new(0x30B4).NFKC.list ~~ (0x30B4,), '30B4 -> 30B4';
ok Uni.new(0x30B6).NFKC.list ~~ (0x30B6,), '30B6 -> 30B6';
ok Uni.new(0x30B8).NFKC.list ~~ (0x30B8,), '30B8 -> 30B8';
ok Uni.new(0x30BA).NFKC.list ~~ (0x30BA,), '30BA -> 30BA';
ok Uni.new(0x30BC).NFKC.list ~~ (0x30BC,), '30BC -> 30BC';
ok Uni.new(0x30BE).NFKC.list ~~ (0x30BE,), '30BE -> 30BE';
ok Uni.new(0x30C0).NFKC.list ~~ (0x30C0,), '30C0 -> 30C0';
ok Uni.new(0x30C2).NFKC.list ~~ (0x30C2,), '30C2 -> 30C2';
ok Uni.new(0x30C5).NFKC.list ~~ (0x30C5,), '30C5 -> 30C5';
ok Uni.new(0x30C7).NFKC.list ~~ (0x30C7,), '30C7 -> 30C7';
ok Uni.new(0x30C9).NFKC.list ~~ (0x30C9,), '30C9 -> 30C9';
ok Uni.new(0x30D0).NFKC.list ~~ (0x30D0,), '30D0 -> 30D0';
ok Uni.new(0x30D1).NFKC.list ~~ (0x30D1,), '30D1 -> 30D1';
ok Uni.new(0x30D3).NFKC.list ~~ (0x30D3,), '30D3 -> 30D3';
ok Uni.new(0x30D4).NFKC.list ~~ (0x30D4,), '30D4 -> 30D4';
ok Uni.new(0x30D6).NFKC.list ~~ (0x30D6,), '30D6 -> 30D6';
ok Uni.new(0x30D7).NFKC.list ~~ (0x30D7,), '30D7 -> 30D7';
ok Uni.new(0x30D9).NFKC.list ~~ (0x30D9,), '30D9 -> 30D9';
ok Uni.new(0x30DA).NFKC.list ~~ (0x30DA,), '30DA -> 30DA';
ok Uni.new(0x30DC).NFKC.list ~~ (0x30DC,), '30DC -> 30DC';
ok Uni.new(0x30DD).NFKC.list ~~ (0x30DD,), '30DD -> 30DD';
ok Uni.new(0x30F4).NFKC.list ~~ (0x30F4,), '30F4 -> 30F4';
ok Uni.new(0x30F7).NFKC.list ~~ (0x30F7,), '30F7 -> 30F7';
ok Uni.new(0x30F8).NFKC.list ~~ (0x30F8,), '30F8 -> 30F8';
ok Uni.new(0x30F9).NFKC.list ~~ (0x30F9,), '30F9 -> 30F9';
ok Uni.new(0x30FA).NFKC.list ~~ (0x30FA,), '30FA -> 30FA';
ok Uni.new(0x30FE).NFKC.list ~~ (0x30FE,), '30FE -> 30FE';
ok Uni.new(0x30FF).NFKC.list ~~ (0x30B3, 0x30C8,), '30FF -> 30B3 30C8';
ok Uni.new(0x3131).NFKC.list ~~ (0x1100,), '3131 -> 1100';
ok Uni.new(0x3132).NFKC.list ~~ (0x1101,), '3132 -> 1101';
ok Uni.new(0x3133).NFKC.list ~~ (0x11AA,), '3133 -> 11AA';
ok Uni.new(0x3134).NFKC.list ~~ (0x1102,), '3134 -> 1102';
ok Uni.new(0x3135).NFKC.list ~~ (0x11AC,), '3135 -> 11AC';
ok Uni.new(0x3136).NFKC.list ~~ (0x11AD,), '3136 -> 11AD';
ok Uni.new(0x3137).NFKC.list ~~ (0x1103,), '3137 -> 1103';
ok Uni.new(0x3138).NFKC.list ~~ (0x1104,), '3138 -> 1104';
ok Uni.new(0x3139).NFKC.list ~~ (0x1105,), '3139 -> 1105';
ok Uni.new(0x313A).NFKC.list ~~ (0x11B0,), '313A -> 11B0';
ok Uni.new(0x313B).NFKC.list ~~ (0x11B1,), '313B -> 11B1';
ok Uni.new(0x313C).NFKC.list ~~ (0x11B2,), '313C -> 11B2';
ok Uni.new(0x313D).NFKC.list ~~ (0x11B3,), '313D -> 11B3';
ok Uni.new(0x313E).NFKC.list ~~ (0x11B4,), '313E -> 11B4';
ok Uni.new(0x313F).NFKC.list ~~ (0x11B5,), '313F -> 11B5';
ok Uni.new(0x3140).NFKC.list ~~ (0x111A,), '3140 -> 111A';
ok Uni.new(0x3141).NFKC.list ~~ (0x1106,), '3141 -> 1106';
ok Uni.new(0x3142).NFKC.list ~~ (0x1107,), '3142 -> 1107';
ok Uni.new(0x3143).NFKC.list ~~ (0x1108,), '3143 -> 1108';
ok Uni.new(0x3144).NFKC.list ~~ (0x1121,), '3144 -> 1121';
ok Uni.new(0x3145).NFKC.list ~~ (0x1109,), '3145 -> 1109';
ok Uni.new(0x3146).NFKC.list ~~ (0x110A,), '3146 -> 110A';
ok Uni.new(0x3147).NFKC.list ~~ (0x110B,), '3147 -> 110B';
ok Uni.new(0x3148).NFKC.list ~~ (0x110C,), '3148 -> 110C';
ok Uni.new(0x3149).NFKC.list ~~ (0x110D,), '3149 -> 110D';
ok Uni.new(0x314A).NFKC.list ~~ (0x110E,), '314A -> 110E';
ok Uni.new(0x314B).NFKC.list ~~ (0x110F,), '314B -> 110F';
ok Uni.new(0x314C).NFKC.list ~~ (0x1110,), '314C -> 1110';
ok Uni.new(0x314D).NFKC.list ~~ (0x1111,), '314D -> 1111';
ok Uni.new(0x314E).NFKC.list ~~ (0x1112,), '314E -> 1112';
ok Uni.new(0x314F).NFKC.list ~~ (0x1161,), '314F -> 1161';
ok Uni.new(0x3150).NFKC.list ~~ (0x1162,), '3150 -> 1162';
ok Uni.new(0x3151).NFKC.list ~~ (0x1163,), '3151 -> 1163';
ok Uni.new(0x3152).NFKC.list ~~ (0x1164,), '3152 -> 1164';
ok Uni.new(0x3153).NFKC.list ~~ (0x1165,), '3153 -> 1165';
ok Uni.new(0x3154).NFKC.list ~~ (0x1166,), '3154 -> 1166';
ok Uni.new(0x3155).NFKC.list ~~ (0x1167,), '3155 -> 1167';
ok Uni.new(0x3156).NFKC.list ~~ (0x1168,), '3156 -> 1168';
ok Uni.new(0x3157).NFKC.list ~~ (0x1169,), '3157 -> 1169';
ok Uni.new(0x3158).NFKC.list ~~ (0x116A,), '3158 -> 116A';
ok Uni.new(0x3159).NFKC.list ~~ (0x116B,), '3159 -> 116B';
ok Uni.new(0x315A).NFKC.list ~~ (0x116C,), '315A -> 116C';
ok Uni.new(0x315B).NFKC.list ~~ (0x116D,), '315B -> 116D';
ok Uni.new(0x315C).NFKC.list ~~ (0x116E,), '315C -> 116E';
ok Uni.new(0x315D).NFKC.list ~~ (0x116F,), '315D -> 116F';
ok Uni.new(0x315E).NFKC.list ~~ (0x1170,), '315E -> 1170';
ok Uni.new(0x315F).NFKC.list ~~ (0x1171,), '315F -> 1171';
ok Uni.new(0x3160).NFKC.list ~~ (0x1172,), '3160 -> 1172';
ok Uni.new(0x3161).NFKC.list ~~ (0x1173,), '3161 -> 1173';
ok Uni.new(0x3162).NFKC.list ~~ (0x1174,), '3162 -> 1174';
ok Uni.new(0x3163).NFKC.list ~~ (0x1175,), '3163 -> 1175';
ok Uni.new(0x3164).NFKC.list ~~ (0x1160,), '3164 -> 1160';
ok Uni.new(0x3165).NFKC.list ~~ (0x1114,), '3165 -> 1114';
ok Uni.new(0x3166).NFKC.list ~~ (0x1115,), '3166 -> 1115';
ok Uni.new(0x3167).NFKC.list ~~ (0x11C7,), '3167 -> 11C7';
ok Uni.new(0x3168).NFKC.list ~~ (0x11C8,), '3168 -> 11C8';
ok Uni.new(0x3169).NFKC.list ~~ (0x11CC,), '3169 -> 11CC';
ok Uni.new(0x316A).NFKC.list ~~ (0x11CE,), '316A -> 11CE';
ok Uni.new(0x316B).NFKC.list ~~ (0x11D3,), '316B -> 11D3';
ok Uni.new(0x316C).NFKC.list ~~ (0x11D7,), '316C -> 11D7';
ok Uni.new(0x316D).NFKC.list ~~ (0x11D9,), '316D -> 11D9';
ok Uni.new(0x316E).NFKC.list ~~ (0x111C,), '316E -> 111C';
ok Uni.new(0x316F).NFKC.list ~~ (0x11DD,), '316F -> 11DD';
ok Uni.new(0x3170).NFKC.list ~~ (0x11DF,), '3170 -> 11DF';
ok Uni.new(0x3171).NFKC.list ~~ (0x111D,), '3171 -> 111D';
ok Uni.new(0x3172).NFKC.list ~~ (0x111E,), '3172 -> 111E';
ok Uni.new(0x3173).NFKC.list ~~ (0x1120,), '3173 -> 1120';
ok Uni.new(0x3174).NFKC.list ~~ (0x1122,), '3174 -> 1122';
ok Uni.new(0x3175).NFKC.list ~~ (0x1123,), '3175 -> 1123';
ok Uni.new(0x3176).NFKC.list ~~ (0x1127,), '3176 -> 1127';
ok Uni.new(0x3177).NFKC.list ~~ (0x1129,), '3177 -> 1129';
ok Uni.new(0x3178).NFKC.list ~~ (0x112B,), '3178 -> 112B';
ok Uni.new(0x3179).NFKC.list ~~ (0x112C,), '3179 -> 112C';
ok Uni.new(0x317A).NFKC.list ~~ (0x112D,), '317A -> 112D';
ok Uni.new(0x317B).NFKC.list ~~ (0x112E,), '317B -> 112E';
ok Uni.new(0x317C).NFKC.list ~~ (0x112F,), '317C -> 112F';
ok Uni.new(0x317D).NFKC.list ~~ (0x1132,), '317D -> 1132';
ok Uni.new(0x317E).NFKC.list ~~ (0x1136,), '317E -> 1136';
ok Uni.new(0x317F).NFKC.list ~~ (0x1140,), '317F -> 1140';
ok Uni.new(0x3180).NFKC.list ~~ (0x1147,), '3180 -> 1147';
ok Uni.new(0x3181).NFKC.list ~~ (0x114C,), '3181 -> 114C';
ok Uni.new(0x3182).NFKC.list ~~ (0x11F1,), '3182 -> 11F1';
ok Uni.new(0x3183).NFKC.list ~~ (0x11F2,), '3183 -> 11F2';
ok Uni.new(0x3184).NFKC.list ~~ (0x1157,), '3184 -> 1157';
ok Uni.new(0x3185).NFKC.list ~~ (0x1158,), '3185 -> 1158';
ok Uni.new(0x3186).NFKC.list ~~ (0x1159,), '3186 -> 1159';
ok Uni.new(0x3187).NFKC.list ~~ (0x1184,), '3187 -> 1184';
ok Uni.new(0x3188).NFKC.list ~~ (0x1185,), '3188 -> 1185';
ok Uni.new(0x3189).NFKC.list ~~ (0x1188,), '3189 -> 1188';
ok Uni.new(0x318A).NFKC.list ~~ (0x1191,), '318A -> 1191';
ok Uni.new(0x318B).NFKC.list ~~ (0x1192,), '318B -> 1192';
ok Uni.new(0x318C).NFKC.list ~~ (0x1194,), '318C -> 1194';
ok Uni.new(0x318D).NFKC.list ~~ (0x119E,), '318D -> 119E';
ok Uni.new(0x318E).NFKC.list ~~ (0x11A1,), '318E -> 11A1';
ok Uni.new(0x3192).NFKC.list ~~ (0x4E00,), '3192 -> 4E00';
ok Uni.new(0x3193).NFKC.list ~~ (0x4E8C,), '3193 -> 4E8C';
ok Uni.new(0x3194).NFKC.list ~~ (0x4E09,), '3194 -> 4E09';
ok Uni.new(0x3195).NFKC.list ~~ (0x56DB,), '3195 -> 56DB';
ok Uni.new(0x3196).NFKC.list ~~ (0x4E0A,), '3196 -> 4E0A';
ok Uni.new(0x3197).NFKC.list ~~ (0x4E2D,), '3197 -> 4E2D';
ok Uni.new(0x3198).NFKC.list ~~ (0x4E0B,), '3198 -> 4E0B';
ok Uni.new(0x3199).NFKC.list ~~ (0x7532,), '3199 -> 7532';
ok Uni.new(0x319A).NFKC.list ~~ (0x4E59,), '319A -> 4E59';
ok Uni.new(0x319B).NFKC.list ~~ (0x4E19,), '319B -> 4E19';
ok Uni.new(0x319C).NFKC.list ~~ (0x4E01,), '319C -> 4E01';
ok Uni.new(0x319D).NFKC.list ~~ (0x5929,), '319D -> 5929';
ok Uni.new(0x319E).NFKC.list ~~ (0x5730,), '319E -> 5730';
ok Uni.new(0x319F).NFKC.list ~~ (0x4EBA,), '319F -> 4EBA';
ok Uni.new(0x3200).NFKC.list ~~ (0x0028, 0x1100, 0x0029,), '3200 -> 0028 1100 0029';
ok Uni.new(0x3201).NFKC.list ~~ (0x0028, 0x1102, 0x0029,), '3201 -> 0028 1102 0029';
ok Uni.new(0x3202).NFKC.list ~~ (0x0028, 0x1103, 0x0029,), '3202 -> 0028 1103 0029';
ok Uni.new(0x3203).NFKC.list ~~ (0x0028, 0x1105, 0x0029,), '3203 -> 0028 1105 0029';
ok Uni.new(0x3204).NFKC.list ~~ (0x0028, 0x1106, 0x0029,), '3204 -> 0028 1106 0029';
ok Uni.new(0x3205).NFKC.list ~~ (0x0028, 0x1107, 0x0029,), '3205 -> 0028 1107 0029';
ok Uni.new(0x3206).NFKC.list ~~ (0x0028, 0x1109, 0x0029,), '3206 -> 0028 1109 0029';
ok Uni.new(0x3207).NFKC.list ~~ (0x0028, 0x110B, 0x0029,), '3207 -> 0028 110B 0029';
ok Uni.new(0x3208).NFKC.list ~~ (0x0028, 0x110C, 0x0029,), '3208 -> 0028 110C 0029';
ok Uni.new(0x3209).NFKC.list ~~ (0x0028, 0x110E, 0x0029,), '3209 -> 0028 110E 0029';
ok Uni.new(0x320A).NFKC.list ~~ (0x0028, 0x110F, 0x0029,), '320A -> 0028 110F 0029';
ok Uni.new(0x320B).NFKC.list ~~ (0x0028, 0x1110, 0x0029,), '320B -> 0028 1110 0029';
ok Uni.new(0x320C).NFKC.list ~~ (0x0028, 0x1111, 0x0029,), '320C -> 0028 1111 0029';
ok Uni.new(0x320D).NFKC.list ~~ (0x0028, 0x1112, 0x0029,), '320D -> 0028 1112 0029';
ok Uni.new(0x320E).NFKC.list ~~ (0x0028, 0xAC00, 0x0029,), '320E -> 0028 AC00 0029';
ok Uni.new(0x320F).NFKC.list ~~ (0x0028, 0xB098, 0x0029,), '320F -> 0028 B098 0029';
ok Uni.new(0x3210).NFKC.list ~~ (0x0028, 0xB2E4, 0x0029,), '3210 -> 0028 B2E4 0029';
ok Uni.new(0x3211).NFKC.list ~~ (0x0028, 0xB77C, 0x0029,), '3211 -> 0028 B77C 0029';
ok Uni.new(0x3212).NFKC.list ~~ (0x0028, 0xB9C8, 0x0029,), '3212 -> 0028 B9C8 0029';
ok Uni.new(0x3213).NFKC.list ~~ (0x0028, 0xBC14, 0x0029,), '3213 -> 0028 BC14 0029';
ok Uni.new(0x3214).NFKC.list ~~ (0x0028, 0xC0AC, 0x0029,), '3214 -> 0028 C0AC 0029';
ok Uni.new(0x3215).NFKC.list ~~ (0x0028, 0xC544, 0x0029,), '3215 -> 0028 C544 0029';
ok Uni.new(0x3216).NFKC.list ~~ (0x0028, 0xC790, 0x0029,), '3216 -> 0028 C790 0029';
ok Uni.new(0x3217).NFKC.list ~~ (0x0028, 0xCC28, 0x0029,), '3217 -> 0028 CC28 0029';
ok Uni.new(0x3218).NFKC.list ~~ (0x0028, 0xCE74, 0x0029,), '3218 -> 0028 CE74 0029';
ok Uni.new(0x3219).NFKC.list ~~ (0x0028, 0xD0C0, 0x0029,), '3219 -> 0028 D0C0 0029';
ok Uni.new(0x321A).NFKC.list ~~ (0x0028, 0xD30C, 0x0029,), '321A -> 0028 D30C 0029';
ok Uni.new(0x321B).NFKC.list ~~ (0x0028, 0xD558, 0x0029,), '321B -> 0028 D558 0029';
ok Uni.new(0x321C).NFKC.list ~~ (0x0028, 0xC8FC, 0x0029,), '321C -> 0028 C8FC 0029';
ok Uni.new(0x321D).NFKC.list ~~ (0x0028, 0xC624, 0xC804, 0x0029,), '321D -> 0028 C624 C804 0029';
ok Uni.new(0x321E).NFKC.list ~~ (0x0028, 0xC624, 0xD6C4, 0x0029,), '321E -> 0028 C624 D6C4 0029';
ok Uni.new(0x3220).NFKC.list ~~ (0x0028, 0x4E00, 0x0029,), '3220 -> 0028 4E00 0029';
ok Uni.new(0x3221).NFKC.list ~~ (0x0028, 0x4E8C, 0x0029,), '3221 -> 0028 4E8C 0029';
ok Uni.new(0x3222).NFKC.list ~~ (0x0028, 0x4E09, 0x0029,), '3222 -> 0028 4E09 0029';
ok Uni.new(0x3223).NFKC.list ~~ (0x0028, 0x56DB, 0x0029,), '3223 -> 0028 56DB 0029';
ok Uni.new(0x3224).NFKC.list ~~ (0x0028, 0x4E94, 0x0029,), '3224 -> 0028 4E94 0029';
ok Uni.new(0x3225).NFKC.list ~~ (0x0028, 0x516D, 0x0029,), '3225 -> 0028 516D 0029';
ok Uni.new(0x3226).NFKC.list ~~ (0x0028, 0x4E03, 0x0029,), '3226 -> 0028 4E03 0029';
ok Uni.new(0x3227).NFKC.list ~~ (0x0028, 0x516B, 0x0029,), '3227 -> 0028 516B 0029';
ok Uni.new(0x3228).NFKC.list ~~ (0x0028, 0x4E5D, 0x0029,), '3228 -> 0028 4E5D 0029';
ok Uni.new(0x3229).NFKC.list ~~ (0x0028, 0x5341, 0x0029,), '3229 -> 0028 5341 0029';
ok Uni.new(0x322A).NFKC.list ~~ (0x0028, 0x6708, 0x0029,), '322A -> 0028 6708 0029';
ok Uni.new(0x322B).NFKC.list ~~ (0x0028, 0x706B, 0x0029,), '322B -> 0028 706B 0029';
ok Uni.new(0x322C).NFKC.list ~~ (0x0028, 0x6C34, 0x0029,), '322C -> 0028 6C34 0029';
ok Uni.new(0x322D).NFKC.list ~~ (0x0028, 0x6728, 0x0029,), '322D -> 0028 6728 0029';
ok Uni.new(0x322E).NFKC.list ~~ (0x0028, 0x91D1, 0x0029,), '322E -> 0028 91D1 0029';
ok Uni.new(0x322F).NFKC.list ~~ (0x0028, 0x571F, 0x0029,), '322F -> 0028 571F 0029';
ok Uni.new(0x3230).NFKC.list ~~ (0x0028, 0x65E5, 0x0029,), '3230 -> 0028 65E5 0029';
ok Uni.new(0x3231).NFKC.list ~~ (0x0028, 0x682A, 0x0029,), '3231 -> 0028 682A 0029';
ok Uni.new(0x3232).NFKC.list ~~ (0x0028, 0x6709, 0x0029,), '3232 -> 0028 6709 0029';
ok Uni.new(0x3233).NFKC.list ~~ (0x0028, 0x793E, 0x0029,), '3233 -> 0028 793E 0029';
ok Uni.new(0x3234).NFKC.list ~~ (0x0028, 0x540D, 0x0029,), '3234 -> 0028 540D 0029';
ok Uni.new(0x3235).NFKC.list ~~ (0x0028, 0x7279, 0x0029,), '3235 -> 0028 7279 0029';
ok Uni.new(0x3236).NFKC.list ~~ (0x0028, 0x8CA1, 0x0029,), '3236 -> 0028 8CA1 0029';
ok Uni.new(0x3237).NFKC.list ~~ (0x0028, 0x795D, 0x0029,), '3237 -> 0028 795D 0029';
ok Uni.new(0x3238).NFKC.list ~~ (0x0028, 0x52B4, 0x0029,), '3238 -> 0028 52B4 0029';
ok Uni.new(0x3239).NFKC.list ~~ (0x0028, 0x4EE3, 0x0029,), '3239 -> 0028 4EE3 0029';
ok Uni.new(0x323A).NFKC.list ~~ (0x0028, 0x547C, 0x0029,), '323A -> 0028 547C 0029';
ok Uni.new(0x323B).NFKC.list ~~ (0x0028, 0x5B66, 0x0029,), '323B -> 0028 5B66 0029';
ok Uni.new(0x323C).NFKC.list ~~ (0x0028, 0x76E3, 0x0029,), '323C -> 0028 76E3 0029';
ok Uni.new(0x323D).NFKC.list ~~ (0x0028, 0x4F01, 0x0029,), '323D -> 0028 4F01 0029';
ok Uni.new(0x323E).NFKC.list ~~ (0x0028, 0x8CC7, 0x0029,), '323E -> 0028 8CC7 0029';
ok Uni.new(0x323F).NFKC.list ~~ (0x0028, 0x5354, 0x0029,), '323F -> 0028 5354 0029';
ok Uni.new(0x3240).NFKC.list ~~ (0x0028, 0x796D, 0x0029,), '3240 -> 0028 796D 0029';
ok Uni.new(0x3241).NFKC.list ~~ (0x0028, 0x4F11, 0x0029,), '3241 -> 0028 4F11 0029';
ok Uni.new(0x3242).NFKC.list ~~ (0x0028, 0x81EA, 0x0029,), '3242 -> 0028 81EA 0029';
ok Uni.new(0x3243).NFKC.list ~~ (0x0028, 0x81F3, 0x0029,), '3243 -> 0028 81F3 0029';
ok Uni.new(0x3244).NFKC.list ~~ (0x554F,), '3244 -> 554F';
ok Uni.new(0x3245).NFKC.list ~~ (0x5E7C,), '3245 -> 5E7C';
ok Uni.new(0x3246).NFKC.list ~~ (0x6587,), '3246 -> 6587';
ok Uni.new(0x3247).NFKC.list ~~ (0x7B8F,), '3247 -> 7B8F';
ok Uni.new(0x3250).NFKC.list ~~ (0x0050, 0x0054, 0x0045,), '3250 -> 0050 0054 0045';
ok Uni.new(0x3251).NFKC.list ~~ (0x0032, 0x0031,), '3251 -> 0032 0031';
ok Uni.new(0x3252).NFKC.list ~~ (0x0032, 0x0032,), '3252 -> 0032 0032';
ok Uni.new(0x3253).NFKC.list ~~ (0x0032, 0x0033,), '3253 -> 0032 0033';
ok Uni.new(0x3254).NFKC.list ~~ (0x0032, 0x0034,), '3254 -> 0032 0034';
ok Uni.new(0x3255).NFKC.list ~~ (0x0032, 0x0035,), '3255 -> 0032 0035';
ok Uni.new(0x3256).NFKC.list ~~ (0x0032, 0x0036,), '3256 -> 0032 0036';
ok Uni.new(0x3257).NFKC.list ~~ (0x0032, 0x0037,), '3257 -> 0032 0037';
ok Uni.new(0x3258).NFKC.list ~~ (0x0032, 0x0038,), '3258 -> 0032 0038';
ok Uni.new(0x3259).NFKC.list ~~ (0x0032, 0x0039,), '3259 -> 0032 0039';
ok Uni.new(0x325A).NFKC.list ~~ (0x0033, 0x0030,), '325A -> 0033 0030';
ok Uni.new(0x325B).NFKC.list ~~ (0x0033, 0x0031,), '325B -> 0033 0031';
ok Uni.new(0x325C).NFKC.list ~~ (0x0033, 0x0032,), '325C -> 0033 0032';
ok Uni.new(0x325D).NFKC.list ~~ (0x0033, 0x0033,), '325D -> 0033 0033';
ok Uni.new(0x325E).NFKC.list ~~ (0x0033, 0x0034,), '325E -> 0033 0034';
ok Uni.new(0x325F).NFKC.list ~~ (0x0033, 0x0035,), '325F -> 0033 0035';
ok Uni.new(0x3260).NFKC.list ~~ (0x1100,), '3260 -> 1100';
ok Uni.new(0x3261).NFKC.list ~~ (0x1102,), '3261 -> 1102';
ok Uni.new(0x3262).NFKC.list ~~ (0x1103,), '3262 -> 1103';
ok Uni.new(0x3263).NFKC.list ~~ (0x1105,), '3263 -> 1105';
ok Uni.new(0x3264).NFKC.list ~~ (0x1106,), '3264 -> 1106';
ok Uni.new(0x3265).NFKC.list ~~ (0x1107,), '3265 -> 1107';
ok Uni.new(0x3266).NFKC.list ~~ (0x1109,), '3266 -> 1109';
ok Uni.new(0x3267).NFKC.list ~~ (0x110B,), '3267 -> 110B';
ok Uni.new(0x3268).NFKC.list ~~ (0x110C,), '3268 -> 110C';
ok Uni.new(0x3269).NFKC.list ~~ (0x110E,), '3269 -> 110E';
ok Uni.new(0x326A).NFKC.list ~~ (0x110F,), '326A -> 110F';
ok Uni.new(0x326B).NFKC.list ~~ (0x1110,), '326B -> 1110';
ok Uni.new(0x326C).NFKC.list ~~ (0x1111,), '326C -> 1111';
ok Uni.new(0x326D).NFKC.list ~~ (0x1112,), '326D -> 1112';
ok Uni.new(0x326E).NFKC.list ~~ (0xAC00,), '326E -> AC00';
ok Uni.new(0x326F).NFKC.list ~~ (0xB098,), '326F -> B098';
ok Uni.new(0x3270).NFKC.list ~~ (0xB2E4,), '3270 -> B2E4';
ok Uni.new(0x3271).NFKC.list ~~ (0xB77C,), '3271 -> B77C';
ok Uni.new(0x3272).NFKC.list ~~ (0xB9C8,), '3272 -> B9C8';
ok Uni.new(0x3273).NFKC.list ~~ (0xBC14,), '3273 -> BC14';
ok Uni.new(0x3274).NFKC.list ~~ (0xC0AC,), '3274 -> C0AC';
ok Uni.new(0x3275).NFKC.list ~~ (0xC544,), '3275 -> C544';
ok Uni.new(0x3276).NFKC.list ~~ (0xC790,), '3276 -> C790';
ok Uni.new(0x3277).NFKC.list ~~ (0xCC28,), '3277 -> CC28';
ok Uni.new(0x3278).NFKC.list ~~ (0xCE74,), '3278 -> CE74';
ok Uni.new(0x3279).NFKC.list ~~ (0xD0C0,), '3279 -> D0C0';
ok Uni.new(0x327A).NFKC.list ~~ (0xD30C,), '327A -> D30C';
ok Uni.new(0x327B).NFKC.list ~~ (0xD558,), '327B -> D558';
ok Uni.new(0x327C).NFKC.list ~~ (0xCC38, 0xACE0,), '327C -> CC38 ACE0';
ok Uni.new(0x327D).NFKC.list ~~ (0xC8FC, 0xC758,), '327D -> C8FC C758';
ok Uni.new(0x327E).NFKC.list ~~ (0xC6B0,), '327E -> C6B0';
ok Uni.new(0x3280).NFKC.list ~~ (0x4E00,), '3280 -> 4E00';
ok Uni.new(0x3281).NFKC.list ~~ (0x4E8C,), '3281 -> 4E8C';
ok Uni.new(0x3282).NFKC.list ~~ (0x4E09,), '3282 -> 4E09';
ok Uni.new(0x3283).NFKC.list ~~ (0x56DB,), '3283 -> 56DB';
ok Uni.new(0x3284).NFKC.list ~~ (0x4E94,), '3284 -> 4E94';
ok Uni.new(0x3285).NFKC.list ~~ (0x516D,), '3285 -> 516D';
ok Uni.new(0x3286).NFKC.list ~~ (0x4E03,), '3286 -> 4E03';
ok Uni.new(0x3287).NFKC.list ~~ (0x516B,), '3287 -> 516B';
ok Uni.new(0x3288).NFKC.list ~~ (0x4E5D,), '3288 -> 4E5D';
ok Uni.new(0x3289).NFKC.list ~~ (0x5341,), '3289 -> 5341';
ok Uni.new(0x328A).NFKC.list ~~ (0x6708,), '328A -> 6708';
ok Uni.new(0x328B).NFKC.list ~~ (0x706B,), '328B -> 706B';
ok Uni.new(0x328C).NFKC.list ~~ (0x6C34,), '328C -> 6C34';
ok Uni.new(0x328D).NFKC.list ~~ (0x6728,), '328D -> 6728';
ok Uni.new(0x328E).NFKC.list ~~ (0x91D1,), '328E -> 91D1';
ok Uni.new(0x328F).NFKC.list ~~ (0x571F,), '328F -> 571F';
ok Uni.new(0x3290).NFKC.list ~~ (0x65E5,), '3290 -> 65E5';
ok Uni.new(0x3291).NFKC.list ~~ (0x682A,), '3291 -> 682A';
ok Uni.new(0x3292).NFKC.list ~~ (0x6709,), '3292 -> 6709';
ok Uni.new(0x3293).NFKC.list ~~ (0x793E,), '3293 -> 793E';
ok Uni.new(0x3294).NFKC.list ~~ (0x540D,), '3294 -> 540D';
ok Uni.new(0x3295).NFKC.list ~~ (0x7279,), '3295 -> 7279';
ok Uni.new(0x3296).NFKC.list ~~ (0x8CA1,), '3296 -> 8CA1';
