use v6;
# Unicode normalization tests, generated from NormalizationTests.txt in the
# Unicode database by S15-normalization/test-gen.p6.
# Generated from Unicode version 13.0.0.

use Test;

plan 2000;

ok Uni.new(0x1E0A).NFC.list ~~ (0x1E0A,), '1E0A -> 1E0A';
ok Uni.new(0x1E0C).NFC.list ~~ (0x1E0C,), '1E0C -> 1E0C';
ok Uni.new(0x1E0A, 0x0323).NFC.list ~~ (0x1E0C, 0x0307,), '1E0A 0323 -> 1E0C 0307';
ok Uni.new(0x1E0C, 0x0307).NFC.list ~~ (0x1E0C, 0x0307,), '1E0C 0307 -> 1E0C 0307';
ok Uni.new(0x0044, 0x0307, 0x0323).NFC.list ~~ (0x1E0C, 0x0307,), '0044 0307 0323 -> 1E0C 0307';
ok Uni.new(0x0044, 0x0323, 0x0307).NFC.list ~~ (0x1E0C, 0x0307,), '0044 0323 0307 -> 1E0C 0307';
ok Uni.new(0x1E0A, 0x031B).NFC.list ~~ (0x1E0A, 0x031B,), '1E0A 031B -> 1E0A 031B';
ok Uni.new(0x1E0C, 0x031B).NFC.list ~~ (0x1E0C, 0x031B,), '1E0C 031B -> 1E0C 031B';
ok Uni.new(0x1E0A, 0x031B, 0x0323).NFC.list ~~ (0x1E0C, 0x031B, 0x0307,), '1E0A 031B 0323 -> 1E0C 031B 0307';
ok Uni.new(0x1E0C, 0x031B, 0x0307).NFC.list ~~ (0x1E0C, 0x031B, 0x0307,), '1E0C 031B 0307 -> 1E0C 031B 0307';
ok Uni.new(0x0044, 0x031B, 0x0307, 0x0323).NFC.list ~~ (0x1E0C, 0x031B, 0x0307,), '0044 031B 0307 0323 -> 1E0C 031B 0307';
ok Uni.new(0x0044, 0x031B, 0x0323, 0x0307).NFC.list ~~ (0x1E0C, 0x031B, 0x0307,), '0044 031B 0323 0307 -> 1E0C 031B 0307';
ok Uni.new(0x00C8).NFC.list ~~ (0x00C8,), '00C8 -> 00C8';
ok Uni.new(0x0112).NFC.list ~~ (0x0112,), '0112 -> 0112';
ok Uni.new(0x0045, 0x0300).NFC.list ~~ (0x00C8,), '0045 0300 -> 00C8';
ok Uni.new(0x0045, 0x0304).NFC.list ~~ (0x0112,), '0045 0304 -> 0112';
ok Uni.new(0x1E14).NFC.list ~~ (0x1E14,), '1E14 -> 1E14';
ok Uni.new(0x0112, 0x0300).NFC.list ~~ (0x1E14,), '0112 0300 -> 1E14';
ok Uni.new(0x1E14, 0x0304).NFC.list ~~ (0x1E14, 0x0304,), '1E14 0304 -> 1E14 0304';
ok Uni.new(0x0045, 0x0304, 0x0300).NFC.list ~~ (0x1E14,), '0045 0304 0300 -> 1E14';
ok Uni.new(0x0045, 0x0300, 0x0304).NFC.list ~~ (0x00C8, 0x0304,), '0045 0300 0304 -> 00C8 0304';
ok Uni.new(0x05B8, 0x05B9, 0x05B1, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F).NFC.list ~~ (0x05B1, 0x05B8, 0x05B9, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F,), '05B8 05B9 05B1 0591 05C3 05B0 05AC 059F -> 05B1 05B8 05B9 0591 05C3 05B0 05AC 059F';
ok Uni.new(0x0592, 0x05B7, 0x05BC, 0x05A5, 0x05B0, 0x05C0, 0x05C4, 0x05AD).NFC.list ~~ (0x05B0, 0x05B7, 0x05BC, 0x05A5, 0x0592, 0x05C0, 0x05AD, 0x05C4,), '0592 05B7 05BC 05A5 05B0 05C0 05C4 05AD -> 05B0 05B7 05BC 05A5 0592 05C0 05AD 05C4';
ok Uni.new(0x1100, 0xAC00, 0x11A8).NFC.list ~~ (0x1100, 0xAC01,), '1100 AC00 11A8 -> 1100 AC01';
ok Uni.new(0x1100, 0xAC00, 0x11A8, 0x11A8).NFC.list ~~ (0x1100, 0xAC01, 0x11A8,), '1100 AC00 11A8 11A8 -> 1100 AC01 11A8';
ok Uni.new(0x00A0).NFC.list ~~ (0x00A0,), '00A0 -> 00A0';
ok Uni.new(0x00A8).NFC.list ~~ (0x00A8,), '00A8 -> 00A8';
ok Uni.new(0x00AA).NFC.list ~~ (0x00AA,), '00AA -> 00AA';
ok Uni.new(0x00AF).NFC.list ~~ (0x00AF,), '00AF -> 00AF';
ok Uni.new(0x00B2).NFC.list ~~ (0x00B2,), '00B2 -> 00B2';
ok Uni.new(0x00B3).NFC.list ~~ (0x00B3,), '00B3 -> 00B3';
ok Uni.new(0x00B4).NFC.list ~~ (0x00B4,), '00B4 -> 00B4';
ok Uni.new(0x00B5).NFC.list ~~ (0x00B5,), '00B5 -> 00B5';
ok Uni.new(0x00B8).NFC.list ~~ (0x00B8,), '00B8 -> 00B8';
ok Uni.new(0x00B9).NFC.list ~~ (0x00B9,), '00B9 -> 00B9';
ok Uni.new(0x00BA).NFC.list ~~ (0x00BA,), '00BA -> 00BA';
ok Uni.new(0x00BC).NFC.list ~~ (0x00BC,), '00BC -> 00BC';
ok Uni.new(0x00BD).NFC.list ~~ (0x00BD,), '00BD -> 00BD';
ok Uni.new(0x00BE).NFC.list ~~ (0x00BE,), '00BE -> 00BE';
ok Uni.new(0x00C0).NFC.list ~~ (0x00C0,), '00C0 -> 00C0';
ok Uni.new(0x00C1).NFC.list ~~ (0x00C1,), '00C1 -> 00C1';
ok Uni.new(0x00C2).NFC.list ~~ (0x00C2,), '00C2 -> 00C2';
ok Uni.new(0x00C3).NFC.list ~~ (0x00C3,), '00C3 -> 00C3';
ok Uni.new(0x00C4).NFC.list ~~ (0x00C4,), '00C4 -> 00C4';
ok Uni.new(0x00C5).NFC.list ~~ (0x00C5,), '00C5 -> 00C5';
ok Uni.new(0x00C7).NFC.list ~~ (0x00C7,), '00C7 -> 00C7';
ok Uni.new(0x00C8).NFC.list ~~ (0x00C8,), '00C8 -> 00C8';
ok Uni.new(0x00C9).NFC.list ~~ (0x00C9,), '00C9 -> 00C9';
ok Uni.new(0x00CA).NFC.list ~~ (0x00CA,), '00CA -> 00CA';
ok Uni.new(0x00CB).NFC.list ~~ (0x00CB,), '00CB -> 00CB';
ok Uni.new(0x00CC).NFC.list ~~ (0x00CC,), '00CC -> 00CC';
ok Uni.new(0x00CD).NFC.list ~~ (0x00CD,), '00CD -> 00CD';
ok Uni.new(0x00CE).NFC.list ~~ (0x00CE,), '00CE -> 00CE';
ok Uni.new(0x00CF).NFC.list ~~ (0x00CF,), '00CF -> 00CF';
ok Uni.new(0x00D1).NFC.list ~~ (0x00D1,), '00D1 -> 00D1';
ok Uni.new(0x00D2).NFC.list ~~ (0x00D2,), '00D2 -> 00D2';
ok Uni.new(0x00D3).NFC.list ~~ (0x00D3,), '00D3 -> 00D3';
ok Uni.new(0x00D4).NFC.list ~~ (0x00D4,), '00D4 -> 00D4';
ok Uni.new(0x00D5).NFC.list ~~ (0x00D5,), '00D5 -> 00D5';
ok Uni.new(0x00D6).NFC.list ~~ (0x00D6,), '00D6 -> 00D6';
ok Uni.new(0x00D9).NFC.list ~~ (0x00D9,), '00D9 -> 00D9';
ok Uni.new(0x00DA).NFC.list ~~ (0x00DA,), '00DA -> 00DA';
ok Uni.new(0x00DB).NFC.list ~~ (0x00DB,), '00DB -> 00DB';
ok Uni.new(0x00DC).NFC.list ~~ (0x00DC,), '00DC -> 00DC';
ok Uni.new(0x00DD).NFC.list ~~ (0x00DD,), '00DD -> 00DD';
ok Uni.new(0x00E0).NFC.list ~~ (0x00E0,), '00E0 -> 00E0';
ok Uni.new(0x00E1).NFC.list ~~ (0x00E1,), '00E1 -> 00E1';
ok Uni.new(0x00E2).NFC.list ~~ (0x00E2,), '00E2 -> 00E2';
ok Uni.new(0x00E3).NFC.list ~~ (0x00E3,), '00E3 -> 00E3';
ok Uni.new(0x00E4).NFC.list ~~ (0x00E4,), '00E4 -> 00E4';
ok Uni.new(0x00E5).NFC.list ~~ (0x00E5,), '00E5 -> 00E5';
ok Uni.new(0x00E7).NFC.list ~~ (0x00E7,), '00E7 -> 00E7';
ok Uni.new(0x00E8).NFC.list ~~ (0x00E8,), '00E8 -> 00E8';
ok Uni.new(0x00E9).NFC.list ~~ (0x00E9,), '00E9 -> 00E9';
ok Uni.new(0x00EA).NFC.list ~~ (0x00EA,), '00EA -> 00EA';
ok Uni.new(0x00EB).NFC.list ~~ (0x00EB,), '00EB -> 00EB';
ok Uni.new(0x00EC).NFC.list ~~ (0x00EC,), '00EC -> 00EC';
ok Uni.new(0x00ED).NFC.list ~~ (0x00ED,), '00ED -> 00ED';
ok Uni.new(0x00EE).NFC.list ~~ (0x00EE,), '00EE -> 00EE';
ok Uni.new(0x00EF).NFC.list ~~ (0x00EF,), '00EF -> 00EF';
ok Uni.new(0x00F1).NFC.list ~~ (0x00F1,), '00F1 -> 00F1';
ok Uni.new(0x00F2).NFC.list ~~ (0x00F2,), '00F2 -> 00F2';
ok Uni.new(0x00F3).NFC.list ~~ (0x00F3,), '00F3 -> 00F3';
ok Uni.new(0x00F4).NFC.list ~~ (0x00F4,), '00F4 -> 00F4';
ok Uni.new(0x00F5).NFC.list ~~ (0x00F5,), '00F5 -> 00F5';
ok Uni.new(0x00F6).NFC.list ~~ (0x00F6,), '00F6 -> 00F6';
ok Uni.new(0x00F9).NFC.list ~~ (0x00F9,), '00F9 -> 00F9';
ok Uni.new(0x00FA).NFC.list ~~ (0x00FA,), '00FA -> 00FA';
ok Uni.new(0x00FB).NFC.list ~~ (0x00FB,), '00FB -> 00FB';
ok Uni.new(0x00FC).NFC.list ~~ (0x00FC,), '00FC -> 00FC';
ok Uni.new(0x00FD).NFC.list ~~ (0x00FD,), '00FD -> 00FD';
ok Uni.new(0x00FF).NFC.list ~~ (0x00FF,), '00FF -> 00FF';
ok Uni.new(0x0100).NFC.list ~~ (0x0100,), '0100 -> 0100';
ok Uni.new(0x0101).NFC.list ~~ (0x0101,), '0101 -> 0101';
ok Uni.new(0x0102).NFC.list ~~ (0x0102,), '0102 -> 0102';
ok Uni.new(0x0103).NFC.list ~~ (0x0103,), '0103 -> 0103';
ok Uni.new(0x0104).NFC.list ~~ (0x0104,), '0104 -> 0104';
ok Uni.new(0x0105).NFC.list ~~ (0x0105,), '0105 -> 0105';
ok Uni.new(0x0106).NFC.list ~~ (0x0106,), '0106 -> 0106';
ok Uni.new(0x0107).NFC.list ~~ (0x0107,), '0107 -> 0107';
ok Uni.new(0x0108).NFC.list ~~ (0x0108,), '0108 -> 0108';
ok Uni.new(0x0109).NFC.list ~~ (0x0109,), '0109 -> 0109';
ok Uni.new(0x010A).NFC.list ~~ (0x010A,), '010A -> 010A';
ok Uni.new(0x010B).NFC.list ~~ (0x010B,), '010B -> 010B';
ok Uni.new(0x010C).NFC.list ~~ (0x010C,), '010C -> 010C';
ok Uni.new(0x010D).NFC.list ~~ (0x010D,), '010D -> 010D';
ok Uni.new(0x010E).NFC.list ~~ (0x010E,), '010E -> 010E';
ok Uni.new(0x010F).NFC.list ~~ (0x010F,), '010F -> 010F';
ok Uni.new(0x0112).NFC.list ~~ (0x0112,), '0112 -> 0112';
ok Uni.new(0x0113).NFC.list ~~ (0x0113,), '0113 -> 0113';
ok Uni.new(0x0114).NFC.list ~~ (0x0114,), '0114 -> 0114';
ok Uni.new(0x0115).NFC.list ~~ (0x0115,), '0115 -> 0115';
ok Uni.new(0x0116).NFC.list ~~ (0x0116,), '0116 -> 0116';
ok Uni.new(0x0117).NFC.list ~~ (0x0117,), '0117 -> 0117';
ok Uni.new(0x0118).NFC.list ~~ (0x0118,), '0118 -> 0118';
ok Uni.new(0x0119).NFC.list ~~ (0x0119,), '0119 -> 0119';
ok Uni.new(0x011A).NFC.list ~~ (0x011A,), '011A -> 011A';
ok Uni.new(0x011B).NFC.list ~~ (0x011B,), '011B -> 011B';
ok Uni.new(0x011C).NFC.list ~~ (0x011C,), '011C -> 011C';
ok Uni.new(0x011D).NFC.list ~~ (0x011D,), '011D -> 011D';
ok Uni.new(0x011E).NFC.list ~~ (0x011E,), '011E -> 011E';
ok Uni.new(0x011F).NFC.list ~~ (0x011F,), '011F -> 011F';
ok Uni.new(0x0120).NFC.list ~~ (0x0120,), '0120 -> 0120';
ok Uni.new(0x0121).NFC.list ~~ (0x0121,), '0121 -> 0121';
ok Uni.new(0x0122).NFC.list ~~ (0x0122,), '0122 -> 0122';
ok Uni.new(0x0123).NFC.list ~~ (0x0123,), '0123 -> 0123';
ok Uni.new(0x0124).NFC.list ~~ (0x0124,), '0124 -> 0124';
ok Uni.new(0x0125).NFC.list ~~ (0x0125,), '0125 -> 0125';
ok Uni.new(0x0128).NFC.list ~~ (0x0128,), '0128 -> 0128';
ok Uni.new(0x0129).NFC.list ~~ (0x0129,), '0129 -> 0129';
ok Uni.new(0x012A).NFC.list ~~ (0x012A,), '012A -> 012A';
ok Uni.new(0x012B).NFC.list ~~ (0x012B,), '012B -> 012B';
ok Uni.new(0x012C).NFC.list ~~ (0x012C,), '012C -> 012C';
ok Uni.new(0x012D).NFC.list ~~ (0x012D,), '012D -> 012D';
ok Uni.new(0x012E).NFC.list ~~ (0x012E,), '012E -> 012E';
ok Uni.new(0x012F).NFC.list ~~ (0x012F,), '012F -> 012F';
ok Uni.new(0x0130).NFC.list ~~ (0x0130,), '0130 -> 0130';
ok Uni.new(0x0132).NFC.list ~~ (0x0132,), '0132 -> 0132';
ok Uni.new(0x0133).NFC.list ~~ (0x0133,), '0133 -> 0133';
ok Uni.new(0x0134).NFC.list ~~ (0x0134,), '0134 -> 0134';
ok Uni.new(0x0135).NFC.list ~~ (0x0135,), '0135 -> 0135';
ok Uni.new(0x0136).NFC.list ~~ (0x0136,), '0136 -> 0136';
ok Uni.new(0x0137).NFC.list ~~ (0x0137,), '0137 -> 0137';
ok Uni.new(0x0139).NFC.list ~~ (0x0139,), '0139 -> 0139';
ok Uni.new(0x013A).NFC.list ~~ (0x013A,), '013A -> 013A';
ok Uni.new(0x013B).NFC.list ~~ (0x013B,), '013B -> 013B';
ok Uni.new(0x013C).NFC.list ~~ (0x013C,), '013C -> 013C';
ok Uni.new(0x013D).NFC.list ~~ (0x013D,), '013D -> 013D';
ok Uni.new(0x013E).NFC.list ~~ (0x013E,), '013E -> 013E';
ok Uni.new(0x013F).NFC.list ~~ (0x013F,), '013F -> 013F';
ok Uni.new(0x0140).NFC.list ~~ (0x0140,), '0140 -> 0140';
ok Uni.new(0x0143).NFC.list ~~ (0x0143,), '0143 -> 0143';
ok Uni.new(0x0144).NFC.list ~~ (0x0144,), '0144 -> 0144';
ok Uni.new(0x0145).NFC.list ~~ (0x0145,), '0145 -> 0145';
ok Uni.new(0x0146).NFC.list ~~ (0x0146,), '0146 -> 0146';
ok Uni.new(0x0147).NFC.list ~~ (0x0147,), '0147 -> 0147';
ok Uni.new(0x0148).NFC.list ~~ (0x0148,), '0148 -> 0148';
ok Uni.new(0x0149).NFC.list ~~ (0x0149,), '0149 -> 0149';
ok Uni.new(0x014C).NFC.list ~~ (0x014C,), '014C -> 014C';
ok Uni.new(0x014D).NFC.list ~~ (0x014D,), '014D -> 014D';
ok Uni.new(0x014E).NFC.list ~~ (0x014E,), '014E -> 014E';
ok Uni.new(0x014F).NFC.list ~~ (0x014F,), '014F -> 014F';
ok Uni.new(0x0150).NFC.list ~~ (0x0150,), '0150 -> 0150';
ok Uni.new(0x0151).NFC.list ~~ (0x0151,), '0151 -> 0151';
ok Uni.new(0x0154).NFC.list ~~ (0x0154,), '0154 -> 0154';
ok Uni.new(0x0155).NFC.list ~~ (0x0155,), '0155 -> 0155';
ok Uni.new(0x0156).NFC.list ~~ (0x0156,), '0156 -> 0156';
ok Uni.new(0x0157).NFC.list ~~ (0x0157,), '0157 -> 0157';
ok Uni.new(0x0158).NFC.list ~~ (0x0158,), '0158 -> 0158';
ok Uni.new(0x0159).NFC.list ~~ (0x0159,), '0159 -> 0159';
ok Uni.new(0x015A).NFC.list ~~ (0x015A,), '015A -> 015A';
ok Uni.new(0x015B).NFC.list ~~ (0x015B,), '015B -> 015B';
ok Uni.new(0x015C).NFC.list ~~ (0x015C,), '015C -> 015C';
ok Uni.new(0x015D).NFC.list ~~ (0x015D,), '015D -> 015D';
ok Uni.new(0x015E).NFC.list ~~ (0x015E,), '015E -> 015E';
ok Uni.new(0x015F).NFC.list ~~ (0x015F,), '015F -> 015F';
ok Uni.new(0x0160).NFC.list ~~ (0x0160,), '0160 -> 0160';
ok Uni.new(0x0161).NFC.list ~~ (0x0161,), '0161 -> 0161';
ok Uni.new(0x0162).NFC.list ~~ (0x0162,), '0162 -> 0162';
ok Uni.new(0x0163).NFC.list ~~ (0x0163,), '0163 -> 0163';
ok Uni.new(0x0164).NFC.list ~~ (0x0164,), '0164 -> 0164';
ok Uni.new(0x0165).NFC.list ~~ (0x0165,), '0165 -> 0165';
ok Uni.new(0x0168).NFC.list ~~ (0x0168,), '0168 -> 0168';
ok Uni.new(0x0169).NFC.list ~~ (0x0169,), '0169 -> 0169';
ok Uni.new(0x016A).NFC.list ~~ (0x016A,), '016A -> 016A';
ok Uni.new(0x016B).NFC.list ~~ (0x016B,), '016B -> 016B';
ok Uni.new(0x016C).NFC.list ~~ (0x016C,), '016C -> 016C';
ok Uni.new(0x016D).NFC.list ~~ (0x016D,), '016D -> 016D';
ok Uni.new(0x016E).NFC.list ~~ (0x016E,), '016E -> 016E';
ok Uni.new(0x016F).NFC.list ~~ (0x016F,), '016F -> 016F';
ok Uni.new(0x0170).NFC.list ~~ (0x0170,), '0170 -> 0170';
ok Uni.new(0x0171).NFC.list ~~ (0x0171,), '0171 -> 0171';
ok Uni.new(0x0172).NFC.list ~~ (0x0172,), '0172 -> 0172';
ok Uni.new(0x0173).NFC.list ~~ (0x0173,), '0173 -> 0173';
ok Uni.new(0x0174).NFC.list ~~ (0x0174,), '0174 -> 0174';
ok Uni.new(0x0175).NFC.list ~~ (0x0175,), '0175 -> 0175';
ok Uni.new(0x0176).NFC.list ~~ (0x0176,), '0176 -> 0176';
ok Uni.new(0x0177).NFC.list ~~ (0x0177,), '0177 -> 0177';
ok Uni.new(0x0178).NFC.list ~~ (0x0178,), '0178 -> 0178';
ok Uni.new(0x0179).NFC.list ~~ (0x0179,), '0179 -> 0179';
ok Uni.new(0x017A).NFC.list ~~ (0x017A,), '017A -> 017A';
ok Uni.new(0x017B).NFC.list ~~ (0x017B,), '017B -> 017B';
ok Uni.new(0x017C).NFC.list ~~ (0x017C,), '017C -> 017C';
ok Uni.new(0x017D).NFC.list ~~ (0x017D,), '017D -> 017D';
ok Uni.new(0x017E).NFC.list ~~ (0x017E,), '017E -> 017E';
ok Uni.new(0x017F).NFC.list ~~ (0x017F,), '017F -> 017F';
ok Uni.new(0x01A0).NFC.list ~~ (0x01A0,), '01A0 -> 01A0';
ok Uni.new(0x01A1).NFC.list ~~ (0x01A1,), '01A1 -> 01A1';
ok Uni.new(0x01AF).NFC.list ~~ (0x01AF,), '01AF -> 01AF';
ok Uni.new(0x01B0).NFC.list ~~ (0x01B0,), '01B0 -> 01B0';
ok Uni.new(0x01C4).NFC.list ~~ (0x01C4,), '01C4 -> 01C4';
ok Uni.new(0x01C5).NFC.list ~~ (0x01C5,), '01C5 -> 01C5';
ok Uni.new(0x01C6).NFC.list ~~ (0x01C6,), '01C6 -> 01C6';
ok Uni.new(0x01C7).NFC.list ~~ (0x01C7,), '01C7 -> 01C7';
ok Uni.new(0x01C8).NFC.list ~~ (0x01C8,), '01C8 -> 01C8';
ok Uni.new(0x01C9).NFC.list ~~ (0x01C9,), '01C9 -> 01C9';
ok Uni.new(0x01CA).NFC.list ~~ (0x01CA,), '01CA -> 01CA';
ok Uni.new(0x01CB).NFC.list ~~ (0x01CB,), '01CB -> 01CB';
ok Uni.new(0x01CC).NFC.list ~~ (0x01CC,), '01CC -> 01CC';
ok Uni.new(0x01CD).NFC.list ~~ (0x01CD,), '01CD -> 01CD';
ok Uni.new(0x01CE).NFC.list ~~ (0x01CE,), '01CE -> 01CE';
ok Uni.new(0x01CF).NFC.list ~~ (0x01CF,), '01CF -> 01CF';
ok Uni.new(0x01D0).NFC.list ~~ (0x01D0,), '01D0 -> 01D0';
ok Uni.new(0x01D1).NFC.list ~~ (0x01D1,), '01D1 -> 01D1';
ok Uni.new(0x01D2).NFC.list ~~ (0x01D2,), '01D2 -> 01D2';
ok Uni.new(0x01D3).NFC.list ~~ (0x01D3,), '01D3 -> 01D3';
ok Uni.new(0x01D4).NFC.list ~~ (0x01D4,), '01D4 -> 01D4';
ok Uni.new(0x01D5).NFC.list ~~ (0x01D5,), '01D5 -> 01D5';
ok Uni.new(0x01D6).NFC.list ~~ (0x01D6,), '01D6 -> 01D6';
ok Uni.new(0x01D7).NFC.list ~~ (0x01D7,), '01D7 -> 01D7';
ok Uni.new(0x01D8).NFC.list ~~ (0x01D8,), '01D8 -> 01D8';
ok Uni.new(0x01D9).NFC.list ~~ (0x01D9,), '01D9 -> 01D9';
ok Uni.new(0x01DA).NFC.list ~~ (0x01DA,), '01DA -> 01DA';
ok Uni.new(0x01DB).NFC.list ~~ (0x01DB,), '01DB -> 01DB';
ok Uni.new(0x01DC).NFC.list ~~ (0x01DC,), '01DC -> 01DC';
ok Uni.new(0x01DE).NFC.list ~~ (0x01DE,), '01DE -> 01DE';
ok Uni.new(0x01DF).NFC.list ~~ (0x01DF,), '01DF -> 01DF';
ok Uni.new(0x01E0).NFC.list ~~ (0x01E0,), '01E0 -> 01E0';
ok Uni.new(0x01E1).NFC.list ~~ (0x01E1,), '01E1 -> 01E1';
ok Uni.new(0x01E2).NFC.list ~~ (0x01E2,), '01E2 -> 01E2';
ok Uni.new(0x01E3).NFC.list ~~ (0x01E3,), '01E3 -> 01E3';
ok Uni.new(0x01E6).NFC.list ~~ (0x01E6,), '01E6 -> 01E6';
ok Uni.new(0x01E7).NFC.list ~~ (0x01E7,), '01E7 -> 01E7';
ok Uni.new(0x01E8).NFC.list ~~ (0x01E8,), '01E8 -> 01E8';
ok Uni.new(0x01E9).NFC.list ~~ (0x01E9,), '01E9 -> 01E9';
ok Uni.new(0x01EA).NFC.list ~~ (0x01EA,), '01EA -> 01EA';
ok Uni.new(0x01EB).NFC.list ~~ (0x01EB,), '01EB -> 01EB';
ok Uni.new(0x01EC).NFC.list ~~ (0x01EC,), '01EC -> 01EC';
ok Uni.new(0x01ED).NFC.list ~~ (0x01ED,), '01ED -> 01ED';
ok Uni.new(0x01EE).NFC.list ~~ (0x01EE,), '01EE -> 01EE';
ok Uni.new(0x01EF).NFC.list ~~ (0x01EF,), '01EF -> 01EF';
ok Uni.new(0x01F0).NFC.list ~~ (0x01F0,), '01F0 -> 01F0';
ok Uni.new(0x01F1).NFC.list ~~ (0x01F1,), '01F1 -> 01F1';
ok Uni.new(0x01F2).NFC.list ~~ (0x01F2,), '01F2 -> 01F2';
ok Uni.new(0x01F3).NFC.list ~~ (0x01F3,), '01F3 -> 01F3';
ok Uni.new(0x01F4).NFC.list ~~ (0x01F4,), '01F4 -> 01F4';
ok Uni.new(0x01F5).NFC.list ~~ (0x01F5,), '01F5 -> 01F5';
ok Uni.new(0x01F8).NFC.list ~~ (0x01F8,), '01F8 -> 01F8';
ok Uni.new(0x01F9).NFC.list ~~ (0x01F9,), '01F9 -> 01F9';
ok Uni.new(0x01FA).NFC.list ~~ (0x01FA,), '01FA -> 01FA';
ok Uni.new(0x01FB).NFC.list ~~ (0x01FB,), '01FB -> 01FB';
ok Uni.new(0x01FC).NFC.list ~~ (0x01FC,), '01FC -> 01FC';
ok Uni.new(0x01FD).NFC.list ~~ (0x01FD,), '01FD -> 01FD';
ok Uni.new(0x01FE).NFC.list ~~ (0x01FE,), '01FE -> 01FE';
ok Uni.new(0x01FF).NFC.list ~~ (0x01FF,), '01FF -> 01FF';
ok Uni.new(0x0200).NFC.list ~~ (0x0200,), '0200 -> 0200';
ok Uni.new(0x0201).NFC.list ~~ (0x0201,), '0201 -> 0201';
ok Uni.new(0x0202).NFC.list ~~ (0x0202,), '0202 -> 0202';
ok Uni.new(0x0203).NFC.list ~~ (0x0203,), '0203 -> 0203';
ok Uni.new(0x0204).NFC.list ~~ (0x0204,), '0204 -> 0204';
ok Uni.new(0x0205).NFC.list ~~ (0x0205,), '0205 -> 0205';
ok Uni.new(0x0206).NFC.list ~~ (0x0206,), '0206 -> 0206';
ok Uni.new(0x0207).NFC.list ~~ (0x0207,), '0207 -> 0207';
ok Uni.new(0x0208).NFC.list ~~ (0x0208,), '0208 -> 0208';
ok Uni.new(0x0209).NFC.list ~~ (0x0209,), '0209 -> 0209';
ok Uni.new(0x020A).NFC.list ~~ (0x020A,), '020A -> 020A';
ok Uni.new(0x020B).NFC.list ~~ (0x020B,), '020B -> 020B';
ok Uni.new(0x020C).NFC.list ~~ (0x020C,), '020C -> 020C';
ok Uni.new(0x020D).NFC.list ~~ (0x020D,), '020D -> 020D';
ok Uni.new(0x020E).NFC.list ~~ (0x020E,), '020E -> 020E';
ok Uni.new(0x020F).NFC.list ~~ (0x020F,), '020F -> 020F';
ok Uni.new(0x0210).NFC.list ~~ (0x0210,), '0210 -> 0210';
ok Uni.new(0x0211).NFC.list ~~ (0x0211,), '0211 -> 0211';
ok Uni.new(0x0212).NFC.list ~~ (0x0212,), '0212 -> 0212';
ok Uni.new(0x0213).NFC.list ~~ (0x0213,), '0213 -> 0213';
ok Uni.new(0x0214).NFC.list ~~ (0x0214,), '0214 -> 0214';
ok Uni.new(0x0215).NFC.list ~~ (0x0215,), '0215 -> 0215';
ok Uni.new(0x0216).NFC.list ~~ (0x0216,), '0216 -> 0216';
ok Uni.new(0x0217).NFC.list ~~ (0x0217,), '0217 -> 0217';
ok Uni.new(0x0218).NFC.list ~~ (0x0218,), '0218 -> 0218';
ok Uni.new(0x0219).NFC.list ~~ (0x0219,), '0219 -> 0219';
ok Uni.new(0x021A).NFC.list ~~ (0x021A,), '021A -> 021A';
ok Uni.new(0x021B).NFC.list ~~ (0x021B,), '021B -> 021B';
ok Uni.new(0x021E).NFC.list ~~ (0x021E,), '021E -> 021E';
ok Uni.new(0x021F).NFC.list ~~ (0x021F,), '021F -> 021F';
ok Uni.new(0x0226).NFC.list ~~ (0x0226,), '0226 -> 0226';
ok Uni.new(0x0227).NFC.list ~~ (0x0227,), '0227 -> 0227';
ok Uni.new(0x0228).NFC.list ~~ (0x0228,), '0228 -> 0228';
ok Uni.new(0x0229).NFC.list ~~ (0x0229,), '0229 -> 0229';
ok Uni.new(0x022A).NFC.list ~~ (0x022A,), '022A -> 022A';
ok Uni.new(0x022B).NFC.list ~~ (0x022B,), '022B -> 022B';
ok Uni.new(0x022C).NFC.list ~~ (0x022C,), '022C -> 022C';
ok Uni.new(0x022D).NFC.list ~~ (0x022D,), '022D -> 022D';
ok Uni.new(0x022E).NFC.list ~~ (0x022E,), '022E -> 022E';
ok Uni.new(0x022F).NFC.list ~~ (0x022F,), '022F -> 022F';
ok Uni.new(0x0230).NFC.list ~~ (0x0230,), '0230 -> 0230';
ok Uni.new(0x0231).NFC.list ~~ (0x0231,), '0231 -> 0231';
ok Uni.new(0x0232).NFC.list ~~ (0x0232,), '0232 -> 0232';
ok Uni.new(0x0233).NFC.list ~~ (0x0233,), '0233 -> 0233';
ok Uni.new(0x02B0).NFC.list ~~ (0x02B0,), '02B0 -> 02B0';
ok Uni.new(0x02B1).NFC.list ~~ (0x02B1,), '02B1 -> 02B1';
ok Uni.new(0x02B2).NFC.list ~~ (0x02B2,), '02B2 -> 02B2';
ok Uni.new(0x02B3).NFC.list ~~ (0x02B3,), '02B3 -> 02B3';
ok Uni.new(0x02B4).NFC.list ~~ (0x02B4,), '02B4 -> 02B4';
ok Uni.new(0x02B5).NFC.list ~~ (0x02B5,), '02B5 -> 02B5';
ok Uni.new(0x02B6).NFC.list ~~ (0x02B6,), '02B6 -> 02B6';
ok Uni.new(0x02B7).NFC.list ~~ (0x02B7,), '02B7 -> 02B7';
ok Uni.new(0x02B8).NFC.list ~~ (0x02B8,), '02B8 -> 02B8';
ok Uni.new(0x02D8).NFC.list ~~ (0x02D8,), '02D8 -> 02D8';
ok Uni.new(0x02D9).NFC.list ~~ (0x02D9,), '02D9 -> 02D9';
ok Uni.new(0x02DA).NFC.list ~~ (0x02DA,), '02DA -> 02DA';
ok Uni.new(0x02DB).NFC.list ~~ (0x02DB,), '02DB -> 02DB';
ok Uni.new(0x02DC).NFC.list ~~ (0x02DC,), '02DC -> 02DC';
ok Uni.new(0x02DD).NFC.list ~~ (0x02DD,), '02DD -> 02DD';
ok Uni.new(0x02E0).NFC.list ~~ (0x02E0,), '02E0 -> 02E0';
ok Uni.new(0x02E1).NFC.list ~~ (0x02E1,), '02E1 -> 02E1';
ok Uni.new(0x02E2).NFC.list ~~ (0x02E2,), '02E2 -> 02E2';
ok Uni.new(0x02E3).NFC.list ~~ (0x02E3,), '02E3 -> 02E3';
ok Uni.new(0x02E4).NFC.list ~~ (0x02E4,), '02E4 -> 02E4';
ok Uni.new(0x0340).NFC.list ~~ (0x0300,), '0340 -> 0300';
ok Uni.new(0x0341).NFC.list ~~ (0x0301,), '0341 -> 0301';
ok Uni.new(0x0343).NFC.list ~~ (0x0313,), '0343 -> 0313';
ok Uni.new(0x0344).NFC.list ~~ (0x0308, 0x0301,), '0344 -> 0308 0301';
ok Uni.new(0x0374).NFC.list ~~ (0x02B9,), '0374 -> 02B9';
ok Uni.new(0x037A).NFC.list ~~ (0x037A,), '037A -> 037A';
ok Uni.new(0x037E).NFC.list ~~ (0x003B,), '037E -> 003B';
ok Uni.new(0x0384).NFC.list ~~ (0x0384,), '0384 -> 0384';
ok Uni.new(0x0385).NFC.list ~~ (0x0385,), '0385 -> 0385';
ok Uni.new(0x0386).NFC.list ~~ (0x0386,), '0386 -> 0386';
ok Uni.new(0x0387).NFC.list ~~ (0x00B7,), '0387 -> 00B7';
ok Uni.new(0x0388).NFC.list ~~ (0x0388,), '0388 -> 0388';
ok Uni.new(0x0389).NFC.list ~~ (0x0389,), '0389 -> 0389';
ok Uni.new(0x038A).NFC.list ~~ (0x038A,), '038A -> 038A';
ok Uni.new(0x038C).NFC.list ~~ (0x038C,), '038C -> 038C';
ok Uni.new(0x038E).NFC.list ~~ (0x038E,), '038E -> 038E';
ok Uni.new(0x038F).NFC.list ~~ (0x038F,), '038F -> 038F';
ok Uni.new(0x0390).NFC.list ~~ (0x0390,), '0390 -> 0390';
ok Uni.new(0x03AA).NFC.list ~~ (0x03AA,), '03AA -> 03AA';
ok Uni.new(0x03AB).NFC.list ~~ (0x03AB,), '03AB -> 03AB';
ok Uni.new(0x03AC).NFC.list ~~ (0x03AC,), '03AC -> 03AC';
ok Uni.new(0x03AD).NFC.list ~~ (0x03AD,), '03AD -> 03AD';
ok Uni.new(0x03AE).NFC.list ~~ (0x03AE,), '03AE -> 03AE';
ok Uni.new(0x03AF).NFC.list ~~ (0x03AF,), '03AF -> 03AF';
ok Uni.new(0x03B0).NFC.list ~~ (0x03B0,), '03B0 -> 03B0';
ok Uni.new(0x03CA).NFC.list ~~ (0x03CA,), '03CA -> 03CA';
ok Uni.new(0x03CB).NFC.list ~~ (0x03CB,), '03CB -> 03CB';
ok Uni.new(0x03CC).NFC.list ~~ (0x03CC,), '03CC -> 03CC';
ok Uni.new(0x03CD).NFC.list ~~ (0x03CD,), '03CD -> 03CD';
ok Uni.new(0x03CE).NFC.list ~~ (0x03CE,), '03CE -> 03CE';
ok Uni.new(0x03D0).NFC.list ~~ (0x03D0,), '03D0 -> 03D0';
ok Uni.new(0x03D1).NFC.list ~~ (0x03D1,), '03D1 -> 03D1';
ok Uni.new(0x03D2).NFC.list ~~ (0x03D2,), '03D2 -> 03D2';
ok Uni.new(0x03D3).NFC.list ~~ (0x03D3,), '03D3 -> 03D3';
ok Uni.new(0x03D4).NFC.list ~~ (0x03D4,), '03D4 -> 03D4';
ok Uni.new(0x03D5).NFC.list ~~ (0x03D5,), '03D5 -> 03D5';
ok Uni.new(0x03D6).NFC.list ~~ (0x03D6,), '03D6 -> 03D6';
ok Uni.new(0x03F0).NFC.list ~~ (0x03F0,), '03F0 -> 03F0';
ok Uni.new(0x03F1).NFC.list ~~ (0x03F1,), '03F1 -> 03F1';
ok Uni.new(0x03F2).NFC.list ~~ (0x03F2,), '03F2 -> 03F2';
ok Uni.new(0x03F4).NFC.list ~~ (0x03F4,), '03F4 -> 03F4';
ok Uni.new(0x03F5).NFC.list ~~ (0x03F5,), '03F5 -> 03F5';
ok Uni.new(0x03F9).NFC.list ~~ (0x03F9,), '03F9 -> 03F9';
ok Uni.new(0x0400).NFC.list ~~ (0x0400,), '0400 -> 0400';
ok Uni.new(0x0401).NFC.list ~~ (0x0401,), '0401 -> 0401';
ok Uni.new(0x0403).NFC.list ~~ (0x0403,), '0403 -> 0403';
ok Uni.new(0x0407).NFC.list ~~ (0x0407,), '0407 -> 0407';
ok Uni.new(0x040C).NFC.list ~~ (0x040C,), '040C -> 040C';
ok Uni.new(0x040D).NFC.list ~~ (0x040D,), '040D -> 040D';
ok Uni.new(0x040E).NFC.list ~~ (0x040E,), '040E -> 040E';
ok Uni.new(0x0419).NFC.list ~~ (0x0419,), '0419 -> 0419';
ok Uni.new(0x0439).NFC.list ~~ (0x0439,), '0439 -> 0439';
ok Uni.new(0x0450).NFC.list ~~ (0x0450,), '0450 -> 0450';
ok Uni.new(0x0451).NFC.list ~~ (0x0451,), '0451 -> 0451';
ok Uni.new(0x0453).NFC.list ~~ (0x0453,), '0453 -> 0453';
ok Uni.new(0x0457).NFC.list ~~ (0x0457,), '0457 -> 0457';
ok Uni.new(0x045C).NFC.list ~~ (0x045C,), '045C -> 045C';
ok Uni.new(0x045D).NFC.list ~~ (0x045D,), '045D -> 045D';
ok Uni.new(0x045E).NFC.list ~~ (0x045E,), '045E -> 045E';
ok Uni.new(0x0476).NFC.list ~~ (0x0476,), '0476 -> 0476';
ok Uni.new(0x0477).NFC.list ~~ (0x0477,), '0477 -> 0477';
ok Uni.new(0x04C1).NFC.list ~~ (0x04C1,), '04C1 -> 04C1';
ok Uni.new(0x04C2).NFC.list ~~ (0x04C2,), '04C2 -> 04C2';
ok Uni.new(0x04D0).NFC.list ~~ (0x04D0,), '04D0 -> 04D0';
ok Uni.new(0x04D1).NFC.list ~~ (0x04D1,), '04D1 -> 04D1';
ok Uni.new(0x04D2).NFC.list ~~ (0x04D2,), '04D2 -> 04D2';
ok Uni.new(0x04D3).NFC.list ~~ (0x04D3,), '04D3 -> 04D3';
ok Uni.new(0x04D6).NFC.list ~~ (0x04D6,), '04D6 -> 04D6';
ok Uni.new(0x04D7).NFC.list ~~ (0x04D7,), '04D7 -> 04D7';
ok Uni.new(0x04DA).NFC.list ~~ (0x04DA,), '04DA -> 04DA';
ok Uni.new(0x04DB).NFC.list ~~ (0x04DB,), '04DB -> 04DB';
ok Uni.new(0x04DC).NFC.list ~~ (0x04DC,), '04DC -> 04DC';
ok Uni.new(0x04DD).NFC.list ~~ (0x04DD,), '04DD -> 04DD';
ok Uni.new(0x04DE).NFC.list ~~ (0x04DE,), '04DE -> 04DE';
ok Uni.new(0x04DF).NFC.list ~~ (0x04DF,), '04DF -> 04DF';
ok Uni.new(0x04E2).NFC.list ~~ (0x04E2,), '04E2 -> 04E2';
ok Uni.new(0x04E3).NFC.list ~~ (0x04E3,), '04E3 -> 04E3';
ok Uni.new(0x04E4).NFC.list ~~ (0x04E4,), '04E4 -> 04E4';
ok Uni.new(0x04E5).NFC.list ~~ (0x04E5,), '04E5 -> 04E5';
ok Uni.new(0x04E6).NFC.list ~~ (0x04E6,), '04E6 -> 04E6';
ok Uni.new(0x04E7).NFC.list ~~ (0x04E7,), '04E7 -> 04E7';
ok Uni.new(0x04EA).NFC.list ~~ (0x04EA,), '04EA -> 04EA';
ok Uni.new(0x04EB).NFC.list ~~ (0x04EB,), '04EB -> 04EB';
ok Uni.new(0x04EC).NFC.list ~~ (0x04EC,), '04EC -> 04EC';
ok Uni.new(0x04ED).NFC.list ~~ (0x04ED,), '04ED -> 04ED';
ok Uni.new(0x04EE).NFC.list ~~ (0x04EE,), '04EE -> 04EE';
ok Uni.new(0x04EF).NFC.list ~~ (0x04EF,), '04EF -> 04EF';
ok Uni.new(0x04F0).NFC.list ~~ (0x04F0,), '04F0 -> 04F0';
ok Uni.new(0x04F1).NFC.list ~~ (0x04F1,), '04F1 -> 04F1';
ok Uni.new(0x04F2).NFC.list ~~ (0x04F2,), '04F2 -> 04F2';
ok Uni.new(0x04F3).NFC.list ~~ (0x04F3,), '04F3 -> 04F3';
ok Uni.new(0x04F4).NFC.list ~~ (0x04F4,), '04F4 -> 04F4';
ok Uni.new(0x04F5).NFC.list ~~ (0x04F5,), '04F5 -> 04F5';
ok Uni.new(0x04F8).NFC.list ~~ (0x04F8,), '04F8 -> 04F8';
ok Uni.new(0x04F9).NFC.list ~~ (0x04F9,), '04F9 -> 04F9';
ok Uni.new(0x0587).NFC.list ~~ (0x0587,), '0587 -> 0587';
ok Uni.new(0x0622).NFC.list ~~ (0x0622,), '0622 -> 0622';
ok Uni.new(0x0623).NFC.list ~~ (0x0623,), '0623 -> 0623';
ok Uni.new(0x0624).NFC.list ~~ (0x0624,), '0624 -> 0624';
ok Uni.new(0x0625).NFC.list ~~ (0x0625,), '0625 -> 0625';
ok Uni.new(0x0626).NFC.list ~~ (0x0626,), '0626 -> 0626';
ok Uni.new(0x0675).NFC.list ~~ (0x0675,), '0675 -> 0675';
ok Uni.new(0x0676).NFC.list ~~ (0x0676,), '0676 -> 0676';
ok Uni.new(0x0677).NFC.list ~~ (0x0677,), '0677 -> 0677';
ok Uni.new(0x0678).NFC.list ~~ (0x0678,), '0678 -> 0678';
ok Uni.new(0x06C0).NFC.list ~~ (0x06C0,), '06C0 -> 06C0';
ok Uni.new(0x06C2).NFC.list ~~ (0x06C2,), '06C2 -> 06C2';
ok Uni.new(0x06D3).NFC.list ~~ (0x06D3,), '06D3 -> 06D3';
ok Uni.new(0x0929).NFC.list ~~ (0x0929,), '0929 -> 0929';
ok Uni.new(0x0931).NFC.list ~~ (0x0931,), '0931 -> 0931';
ok Uni.new(0x0934).NFC.list ~~ (0x0934,), '0934 -> 0934';
ok Uni.new(0x0958).NFC.list ~~ (0x0915, 0x093C,), '0958 -> 0915 093C';
ok Uni.new(0x0959).NFC.list ~~ (0x0916, 0x093C,), '0959 -> 0916 093C';
ok Uni.new(0x095A).NFC.list ~~ (0x0917, 0x093C,), '095A -> 0917 093C';
ok Uni.new(0x095B).NFC.list ~~ (0x091C, 0x093C,), '095B -> 091C 093C';
ok Uni.new(0x095C).NFC.list ~~ (0x0921, 0x093C,), '095C -> 0921 093C';
ok Uni.new(0x095D).NFC.list ~~ (0x0922, 0x093C,), '095D -> 0922 093C';
ok Uni.new(0x095E).NFC.list ~~ (0x092B, 0x093C,), '095E -> 092B 093C';
ok Uni.new(0x095F).NFC.list ~~ (0x092F, 0x093C,), '095F -> 092F 093C';
ok Uni.new(0x09CB).NFC.list ~~ (0x09CB,), '09CB -> 09CB';
ok Uni.new(0x09CC).NFC.list ~~ (0x09CC,), '09CC -> 09CC';
ok Uni.new(0x09DC).NFC.list ~~ (0x09A1, 0x09BC,), '09DC -> 09A1 09BC';
ok Uni.new(0x09DD).NFC.list ~~ (0x09A2, 0x09BC,), '09DD -> 09A2 09BC';
ok Uni.new(0x09DF).NFC.list ~~ (0x09AF, 0x09BC,), '09DF -> 09AF 09BC';
ok Uni.new(0x0A33).NFC.list ~~ (0x0A32, 0x0A3C,), '0A33 -> 0A32 0A3C';
ok Uni.new(0x0A36).NFC.list ~~ (0x0A38, 0x0A3C,), '0A36 -> 0A38 0A3C';
ok Uni.new(0x0A59).NFC.list ~~ (0x0A16, 0x0A3C,), '0A59 -> 0A16 0A3C';
ok Uni.new(0x0A5A).NFC.list ~~ (0x0A17, 0x0A3C,), '0A5A -> 0A17 0A3C';
ok Uni.new(0x0A5B).NFC.list ~~ (0x0A1C, 0x0A3C,), '0A5B -> 0A1C 0A3C';
ok Uni.new(0x0A5E).NFC.list ~~ (0x0A2B, 0x0A3C,), '0A5E -> 0A2B 0A3C';
ok Uni.new(0x0B48).NFC.list ~~ (0x0B48,), '0B48 -> 0B48';
ok Uni.new(0x0B4B).NFC.list ~~ (0x0B4B,), '0B4B -> 0B4B';
ok Uni.new(0x0B4C).NFC.list ~~ (0x0B4C,), '0B4C -> 0B4C';
ok Uni.new(0x0B5C).NFC.list ~~ (0x0B21, 0x0B3C,), '0B5C -> 0B21 0B3C';
ok Uni.new(0x0B5D).NFC.list ~~ (0x0B22, 0x0B3C,), '0B5D -> 0B22 0B3C';
ok Uni.new(0x0B94).NFC.list ~~ (0x0B94,), '0B94 -> 0B94';
ok Uni.new(0x0BCA).NFC.list ~~ (0x0BCA,), '0BCA -> 0BCA';
ok Uni.new(0x0BCB).NFC.list ~~ (0x0BCB,), '0BCB -> 0BCB';
ok Uni.new(0x0BCC).NFC.list ~~ (0x0BCC,), '0BCC -> 0BCC';
ok Uni.new(0x0C48).NFC.list ~~ (0x0C48,), '0C48 -> 0C48';
ok Uni.new(0x0CC0).NFC.list ~~ (0x0CC0,), '0CC0 -> 0CC0';
ok Uni.new(0x0CC7).NFC.list ~~ (0x0CC7,), '0CC7 -> 0CC7';
ok Uni.new(0x0CC8).NFC.list ~~ (0x0CC8,), '0CC8 -> 0CC8';
ok Uni.new(0x0CCA).NFC.list ~~ (0x0CCA,), '0CCA -> 0CCA';
ok Uni.new(0x0CCB).NFC.list ~~ (0x0CCB,), '0CCB -> 0CCB';
ok Uni.new(0x0D4A).NFC.list ~~ (0x0D4A,), '0D4A -> 0D4A';
ok Uni.new(0x0D4B).NFC.list ~~ (0x0D4B,), '0D4B -> 0D4B';
ok Uni.new(0x0D4C).NFC.list ~~ (0x0D4C,), '0D4C -> 0D4C';
ok Uni.new(0x0DDA).NFC.list ~~ (0x0DDA,), '0DDA -> 0DDA';
ok Uni.new(0x0DDC).NFC.list ~~ (0x0DDC,), '0DDC -> 0DDC';
ok Uni.new(0x0DDD).NFC.list ~~ (0x0DDD,), '0DDD -> 0DDD';
ok Uni.new(0x0DDE).NFC.list ~~ (0x0DDE,), '0DDE -> 0DDE';
ok Uni.new(0x0E33).NFC.list ~~ (0x0E33,), '0E33 -> 0E33';
ok Uni.new(0x0EB3).NFC.list ~~ (0x0EB3,), '0EB3 -> 0EB3';
ok Uni.new(0x0EDC).NFC.list ~~ (0x0EDC,), '0EDC -> 0EDC';
ok Uni.new(0x0EDD).NFC.list ~~ (0x0EDD,), '0EDD -> 0EDD';
ok Uni.new(0x0F0C).NFC.list ~~ (0x0F0C,), '0F0C -> 0F0C';
ok Uni.new(0x0F43).NFC.list ~~ (0x0F42, 0x0FB7,), '0F43 -> 0F42 0FB7';
ok Uni.new(0x0F4D).NFC.list ~~ (0x0F4C, 0x0FB7,), '0F4D -> 0F4C 0FB7';
ok Uni.new(0x0F52).NFC.list ~~ (0x0F51, 0x0FB7,), '0F52 -> 0F51 0FB7';
ok Uni.new(0x0F57).NFC.list ~~ (0x0F56, 0x0FB7,), '0F57 -> 0F56 0FB7';
ok Uni.new(0x0F5C).NFC.list ~~ (0x0F5B, 0x0FB7,), '0F5C -> 0F5B 0FB7';
ok Uni.new(0x0F69).NFC.list ~~ (0x0F40, 0x0FB5,), '0F69 -> 0F40 0FB5';
ok Uni.new(0x0F73).NFC.list ~~ (0x0F71, 0x0F72,), '0F73 -> 0F71 0F72';
ok Uni.new(0x0F75).NFC.list ~~ (0x0F71, 0x0F74,), '0F75 -> 0F71 0F74';
ok Uni.new(0x0F76).NFC.list ~~ (0x0FB2, 0x0F80,), '0F76 -> 0FB2 0F80';
ok Uni.new(0x0F77).NFC.list ~~ (0x0F77,), '0F77 -> 0F77';
ok Uni.new(0x0F78).NFC.list ~~ (0x0FB3, 0x0F80,), '0F78 -> 0FB3 0F80';
ok Uni.new(0x0F79).NFC.list ~~ (0x0F79,), '0F79 -> 0F79';
ok Uni.new(0x0F81).NFC.list ~~ (0x0F71, 0x0F80,), '0F81 -> 0F71 0F80';
ok Uni.new(0x0F93).NFC.list ~~ (0x0F92, 0x0FB7,), '0F93 -> 0F92 0FB7';
ok Uni.new(0x0F9D).NFC.list ~~ (0x0F9C, 0x0FB7,), '0F9D -> 0F9C 0FB7';
ok Uni.new(0x0FA2).NFC.list ~~ (0x0FA1, 0x0FB7,), '0FA2 -> 0FA1 0FB7';
ok Uni.new(0x0FA7).NFC.list ~~ (0x0FA6, 0x0FB7,), '0FA7 -> 0FA6 0FB7';
ok Uni.new(0x0FAC).NFC.list ~~ (0x0FAB, 0x0FB7,), '0FAC -> 0FAB 0FB7';
ok Uni.new(0x0FB9).NFC.list ~~ (0x0F90, 0x0FB5,), '0FB9 -> 0F90 0FB5';
ok Uni.new(0x1026).NFC.list ~~ (0x1026,), '1026 -> 1026';
ok Uni.new(0x10FC).NFC.list ~~ (0x10FC,), '10FC -> 10FC';
ok Uni.new(0x1B06).NFC.list ~~ (0x1B06,), '1B06 -> 1B06';
ok Uni.new(0x1B08).NFC.list ~~ (0x1B08,), '1B08 -> 1B08';
ok Uni.new(0x1B0A).NFC.list ~~ (0x1B0A,), '1B0A -> 1B0A';
ok Uni.new(0x1B0C).NFC.list ~~ (0x1B0C,), '1B0C -> 1B0C';
ok Uni.new(0x1B0E).NFC.list ~~ (0x1B0E,), '1B0E -> 1B0E';
ok Uni.new(0x1B12).NFC.list ~~ (0x1B12,), '1B12 -> 1B12';
ok Uni.new(0x1B3B).NFC.list ~~ (0x1B3B,), '1B3B -> 1B3B';
ok Uni.new(0x1B3D).NFC.list ~~ (0x1B3D,), '1B3D -> 1B3D';
ok Uni.new(0x1B40).NFC.list ~~ (0x1B40,), '1B40 -> 1B40';
ok Uni.new(0x1B41).NFC.list ~~ (0x1B41,), '1B41 -> 1B41';
ok Uni.new(0x1B43).NFC.list ~~ (0x1B43,), '1B43 -> 1B43';
ok Uni.new(0x1D2C).NFC.list ~~ (0x1D2C,), '1D2C -> 1D2C';
ok Uni.new(0x1D2D).NFC.list ~~ (0x1D2D,), '1D2D -> 1D2D';
ok Uni.new(0x1D2E).NFC.list ~~ (0x1D2E,), '1D2E -> 1D2E';
ok Uni.new(0x1D30).NFC.list ~~ (0x1D30,), '1D30 -> 1D30';
ok Uni.new(0x1D31).NFC.list ~~ (0x1D31,), '1D31 -> 1D31';
ok Uni.new(0x1D32).NFC.list ~~ (0x1D32,), '1D32 -> 1D32';
ok Uni.new(0x1D33).NFC.list ~~ (0x1D33,), '1D33 -> 1D33';
ok Uni.new(0x1D34).NFC.list ~~ (0x1D34,), '1D34 -> 1D34';
ok Uni.new(0x1D35).NFC.list ~~ (0x1D35,), '1D35 -> 1D35';
ok Uni.new(0x1D36).NFC.list ~~ (0x1D36,), '1D36 -> 1D36';
ok Uni.new(0x1D37).NFC.list ~~ (0x1D37,), '1D37 -> 1D37';
ok Uni.new(0x1D38).NFC.list ~~ (0x1D38,), '1D38 -> 1D38';
ok Uni.new(0x1D39).NFC.list ~~ (0x1D39,), '1D39 -> 1D39';
ok Uni.new(0x1D3A).NFC.list ~~ (0x1D3A,), '1D3A -> 1D3A';
ok Uni.new(0x1D3C).NFC.list ~~ (0x1D3C,), '1D3C -> 1D3C';
ok Uni.new(0x1D3D).NFC.list ~~ (0x1D3D,), '1D3D -> 1D3D';
ok Uni.new(0x1D3E).NFC.list ~~ (0x1D3E,), '1D3E -> 1D3E';
ok Uni.new(0x1D3F).NFC.list ~~ (0x1D3F,), '1D3F -> 1D3F';
ok Uni.new(0x1D40).NFC.list ~~ (0x1D40,), '1D40 -> 1D40';
ok Uni.new(0x1D41).NFC.list ~~ (0x1D41,), '1D41 -> 1D41';
ok Uni.new(0x1D42).NFC.list ~~ (0x1D42,), '1D42 -> 1D42';
ok Uni.new(0x1D43).NFC.list ~~ (0x1D43,), '1D43 -> 1D43';
ok Uni.new(0x1D44).NFC.list ~~ (0x1D44,), '1D44 -> 1D44';
ok Uni.new(0x1D45).NFC.list ~~ (0x1D45,), '1D45 -> 1D45';
ok Uni.new(0x1D46).NFC.list ~~ (0x1D46,), '1D46 -> 1D46';
ok Uni.new(0x1D47).NFC.list ~~ (0x1D47,), '1D47 -> 1D47';
ok Uni.new(0x1D48).NFC.list ~~ (0x1D48,), '1D48 -> 1D48';
ok Uni.new(0x1D49).NFC.list ~~ (0x1D49,), '1D49 -> 1D49';
ok Uni.new(0x1D4A).NFC.list ~~ (0x1D4A,), '1D4A -> 1D4A';
ok Uni.new(0x1D4B).NFC.list ~~ (0x1D4B,), '1D4B -> 1D4B';
ok Uni.new(0x1D4C).NFC.list ~~ (0x1D4C,), '1D4C -> 1D4C';
ok Uni.new(0x1D4D).NFC.list ~~ (0x1D4D,), '1D4D -> 1D4D';
ok Uni.new(0x1D4F).NFC.list ~~ (0x1D4F,), '1D4F -> 1D4F';
ok Uni.new(0x1D50).NFC.list ~~ (0x1D50,), '1D50 -> 1D50';
ok Uni.new(0x1D51).NFC.list ~~ (0x1D51,), '1D51 -> 1D51';
ok Uni.new(0x1D52).NFC.list ~~ (0x1D52,), '1D52 -> 1D52';
ok Uni.new(0x1D53).NFC.list ~~ (0x1D53,), '1D53 -> 1D53';
ok Uni.new(0x1D54).NFC.list ~~ (0x1D54,), '1D54 -> 1D54';
ok Uni.new(0x1D55).NFC.list ~~ (0x1D55,), '1D55 -> 1D55';
ok Uni.new(0x1D56).NFC.list ~~ (0x1D56,), '1D56 -> 1D56';
ok Uni.new(0x1D57).NFC.list ~~ (0x1D57,), '1D57 -> 1D57';
ok Uni.new(0x1D58).NFC.list ~~ (0x1D58,), '1D58 -> 1D58';
ok Uni.new(0x1D59).NFC.list ~~ (0x1D59,), '1D59 -> 1D59';
ok Uni.new(0x1D5A).NFC.list ~~ (0x1D5A,), '1D5A -> 1D5A';
ok Uni.new(0x1D5B).NFC.list ~~ (0x1D5B,), '1D5B -> 1D5B';
ok Uni.new(0x1D5C).NFC.list ~~ (0x1D5C,), '1D5C -> 1D5C';
ok Uni.new(0x1D5D).NFC.list ~~ (0x1D5D,), '1D5D -> 1D5D';
ok Uni.new(0x1D5E).NFC.list ~~ (0x1D5E,), '1D5E -> 1D5E';
ok Uni.new(0x1D5F).NFC.list ~~ (0x1D5F,), '1D5F -> 1D5F';
ok Uni.new(0x1D60).NFC.list ~~ (0x1D60,), '1D60 -> 1D60';
ok Uni.new(0x1D61).NFC.list ~~ (0x1D61,), '1D61 -> 1D61';
ok Uni.new(0x1D62).NFC.list ~~ (0x1D62,), '1D62 -> 1D62';
ok Uni.new(0x1D63).NFC.list ~~ (0x1D63,), '1D63 -> 1D63';
ok Uni.new(0x1D64).NFC.list ~~ (0x1D64,), '1D64 -> 1D64';
ok Uni.new(0x1D65).NFC.list ~~ (0x1D65,), '1D65 -> 1D65';
ok Uni.new(0x1D66).NFC.list ~~ (0x1D66,), '1D66 -> 1D66';
ok Uni.new(0x1D67).NFC.list ~~ (0x1D67,), '1D67 -> 1D67';
ok Uni.new(0x1D68).NFC.list ~~ (0x1D68,), '1D68 -> 1D68';
ok Uni.new(0x1D69).NFC.list ~~ (0x1D69,), '1D69 -> 1D69';
ok Uni.new(0x1D6A).NFC.list ~~ (0x1D6A,), '1D6A -> 1D6A';
ok Uni.new(0x1D78).NFC.list ~~ (0x1D78,), '1D78 -> 1D78';
ok Uni.new(0x1D9B).NFC.list ~~ (0x1D9B,), '1D9B -> 1D9B';
ok Uni.new(0x1D9C).NFC.list ~~ (0x1D9C,), '1D9C -> 1D9C';
ok Uni.new(0x1D9D).NFC.list ~~ (0x1D9D,), '1D9D -> 1D9D';
ok Uni.new(0x1D9E).NFC.list ~~ (0x1D9E,), '1D9E -> 1D9E';
ok Uni.new(0x1D9F).NFC.list ~~ (0x1D9F,), '1D9F -> 1D9F';
ok Uni.new(0x1DA0).NFC.list ~~ (0x1DA0,), '1DA0 -> 1DA0';
ok Uni.new(0x1DA1).NFC.list ~~ (0x1DA1,), '1DA1 -> 1DA1';
ok Uni.new(0x1DA2).NFC.list ~~ (0x1DA2,), '1DA2 -> 1DA2';
ok Uni.new(0x1DA3).NFC.list ~~ (0x1DA3,), '1DA3 -> 1DA3';
ok Uni.new(0x1DA4).NFC.list ~~ (0x1DA4,), '1DA4 -> 1DA4';
ok Uni.new(0x1DA5).NFC.list ~~ (0x1DA5,), '1DA5 -> 1DA5';
ok Uni.new(0x1DA6).NFC.list ~~ (0x1DA6,), '1DA6 -> 1DA6';
ok Uni.new(0x1DA7).NFC.list ~~ (0x1DA7,), '1DA7 -> 1DA7';
ok Uni.new(0x1DA8).NFC.list ~~ (0x1DA8,), '1DA8 -> 1DA8';
ok Uni.new(0x1DA9).NFC.list ~~ (0x1DA9,), '1DA9 -> 1DA9';
ok Uni.new(0x1DAA).NFC.list ~~ (0x1DAA,), '1DAA -> 1DAA';
ok Uni.new(0x1DAB).NFC.list ~~ (0x1DAB,), '1DAB -> 1DAB';
ok Uni.new(0x1DAC).NFC.list ~~ (0x1DAC,), '1DAC -> 1DAC';
ok Uni.new(0x1DAD).NFC.list ~~ (0x1DAD,), '1DAD -> 1DAD';
ok Uni.new(0x1DAE).NFC.list ~~ (0x1DAE,), '1DAE -> 1DAE';
ok Uni.new(0x1DAF).NFC.list ~~ (0x1DAF,), '1DAF -> 1DAF';
ok Uni.new(0x1DB0).NFC.list ~~ (0x1DB0,), '1DB0 -> 1DB0';
ok Uni.new(0x1DB1).NFC.list ~~ (0x1DB1,), '1DB1 -> 1DB1';
ok Uni.new(0x1DB2).NFC.list ~~ (0x1DB2,), '1DB2 -> 1DB2';
ok Uni.new(0x1DB3).NFC.list ~~ (0x1DB3,), '1DB3 -> 1DB3';
ok Uni.new(0x1DB4).NFC.list ~~ (0x1DB4,), '1DB4 -> 1DB4';
ok Uni.new(0x1DB5).NFC.list ~~ (0x1DB5,), '1DB5 -> 1DB5';
ok Uni.new(0x1DB6).NFC.list ~~ (0x1DB6,), '1DB6 -> 1DB6';
ok Uni.new(0x1DB7).NFC.list ~~ (0x1DB7,), '1DB7 -> 1DB7';
ok Uni.new(0x1DB8).NFC.list ~~ (0x1DB8,), '1DB8 -> 1DB8';
ok Uni.new(0x1DB9).NFC.list ~~ (0x1DB9,), '1DB9 -> 1DB9';
ok Uni.new(0x1DBA).NFC.list ~~ (0x1DBA,), '1DBA -> 1DBA';
ok Uni.new(0x1DBB).NFC.list ~~ (0x1DBB,), '1DBB -> 1DBB';
ok Uni.new(0x1DBC).NFC.list ~~ (0x1DBC,), '1DBC -> 1DBC';
ok Uni.new(0x1DBD).NFC.list ~~ (0x1DBD,), '1DBD -> 1DBD';
ok Uni.new(0x1DBE).NFC.list ~~ (0x1DBE,), '1DBE -> 1DBE';
ok Uni.new(0x1DBF).NFC.list ~~ (0x1DBF,), '1DBF -> 1DBF';
ok Uni.new(0x1E00).NFC.list ~~ (0x1E00,), '1E00 -> 1E00';
ok Uni.new(0x1E01).NFC.list ~~ (0x1E01,), '1E01 -> 1E01';
ok Uni.new(0x1E02).NFC.list ~~ (0x1E02,), '1E02 -> 1E02';
ok Uni.new(0x1E03).NFC.list ~~ (0x1E03,), '1E03 -> 1E03';
ok Uni.new(0x1E04).NFC.list ~~ (0x1E04,), '1E04 -> 1E04';
ok Uni.new(0x1E05).NFC.list ~~ (0x1E05,), '1E05 -> 1E05';
ok Uni.new(0x1E06).NFC.list ~~ (0x1E06,), '1E06 -> 1E06';
ok Uni.new(0x1E07).NFC.list ~~ (0x1E07,), '1E07 -> 1E07';
ok Uni.new(0x1E08).NFC.list ~~ (0x1E08,), '1E08 -> 1E08';
ok Uni.new(0x1E09).NFC.list ~~ (0x1E09,), '1E09 -> 1E09';
ok Uni.new(0x1E0A).NFC.list ~~ (0x1E0A,), '1E0A -> 1E0A';
ok Uni.new(0x1E0B).NFC.list ~~ (0x1E0B,), '1E0B -> 1E0B';
ok Uni.new(0x1E0C).NFC.list ~~ (0x1E0C,), '1E0C -> 1E0C';
ok Uni.new(0x1E0D).NFC.list ~~ (0x1E0D,), '1E0D -> 1E0D';
ok Uni.new(0x1E0E).NFC.list ~~ (0x1E0E,), '1E0E -> 1E0E';
ok Uni.new(0x1E0F).NFC.list ~~ (0x1E0F,), '1E0F -> 1E0F';
ok Uni.new(0x1E10).NFC.list ~~ (0x1E10,), '1E10 -> 1E10';
ok Uni.new(0x1E11).NFC.list ~~ (0x1E11,), '1E11 -> 1E11';
ok Uni.new(0x1E12).NFC.list ~~ (0x1E12,), '1E12 -> 1E12';
ok Uni.new(0x1E13).NFC.list ~~ (0x1E13,), '1E13 -> 1E13';
ok Uni.new(0x1E14).NFC.list ~~ (0x1E14,), '1E14 -> 1E14';
ok Uni.new(0x1E15).NFC.list ~~ (0x1E15,), '1E15 -> 1E15';
ok Uni.new(0x1E16).NFC.list ~~ (0x1E16,), '1E16 -> 1E16';
ok Uni.new(0x1E17).NFC.list ~~ (0x1E17,), '1E17 -> 1E17';
ok Uni.new(0x1E18).NFC.list ~~ (0x1E18,), '1E18 -> 1E18';
ok Uni.new(0x1E19).NFC.list ~~ (0x1E19,), '1E19 -> 1E19';
ok Uni.new(0x1E1A).NFC.list ~~ (0x1E1A,), '1E1A -> 1E1A';
ok Uni.new(0x1E1B).NFC.list ~~ (0x1E1B,), '1E1B -> 1E1B';
ok Uni.new(0x1E1C).NFC.list ~~ (0x1E1C,), '1E1C -> 1E1C';
ok Uni.new(0x1E1D).NFC.list ~~ (0x1E1D,), '1E1D -> 1E1D';
ok Uni.new(0x1E1E).NFC.list ~~ (0x1E1E,), '1E1E -> 1E1E';
ok Uni.new(0x1E1F).NFC.list ~~ (0x1E1F,), '1E1F -> 1E1F';
ok Uni.new(0x1E20).NFC.list ~~ (0x1E20,), '1E20 -> 1E20';
ok Uni.new(0x1E21).NFC.list ~~ (0x1E21,), '1E21 -> 1E21';
ok Uni.new(0x1E22).NFC.list ~~ (0x1E22,), '1E22 -> 1E22';
ok Uni.new(0x1E23).NFC.list ~~ (0x1E23,), '1E23 -> 1E23';
ok Uni.new(0x1E24).NFC.list ~~ (0x1E24,), '1E24 -> 1E24';
ok Uni.new(0x1E25).NFC.list ~~ (0x1E25,), '1E25 -> 1E25';
ok Uni.new(0x1E26).NFC.list ~~ (0x1E26,), '1E26 -> 1E26';
ok Uni.new(0x1E27).NFC.list ~~ (0x1E27,), '1E27 -> 1E27';
ok Uni.new(0x1E28).NFC.list ~~ (0x1E28,), '1E28 -> 1E28';
ok Uni.new(0x1E29).NFC.list ~~ (0x1E29,), '1E29 -> 1E29';
ok Uni.new(0x1E2A).NFC.list ~~ (0x1E2A,), '1E2A -> 1E2A';
ok Uni.new(0x1E2B).NFC.list ~~ (0x1E2B,), '1E2B -> 1E2B';
ok Uni.new(0x1E2C).NFC.list ~~ (0x1E2C,), '1E2C -> 1E2C';
ok Uni.new(0x1E2D).NFC.list ~~ (0x1E2D,), '1E2D -> 1E2D';
ok Uni.new(0x1E2E).NFC.list ~~ (0x1E2E,), '1E2E -> 1E2E';
ok Uni.new(0x1E2F).NFC.list ~~ (0x1E2F,), '1E2F -> 1E2F';
ok Uni.new(0x1E30).NFC.list ~~ (0x1E30,), '1E30 -> 1E30';
ok Uni.new(0x1E31).NFC.list ~~ (0x1E31,), '1E31 -> 1E31';
ok Uni.new(0x1E32).NFC.list ~~ (0x1E32,), '1E32 -> 1E32';
ok Uni.new(0x1E33).NFC.list ~~ (0x1E33,), '1E33 -> 1E33';
ok Uni.new(0x1E34).NFC.list ~~ (0x1E34,), '1E34 -> 1E34';
ok Uni.new(0x1E35).NFC.list ~~ (0x1E35,), '1E35 -> 1E35';
ok Uni.new(0x1E36).NFC.list ~~ (0x1E36,), '1E36 -> 1E36';
ok Uni.new(0x1E37).NFC.list ~~ (0x1E37,), '1E37 -> 1E37';
ok Uni.new(0x1E38).NFC.list ~~ (0x1E38,), '1E38 -> 1E38';
ok Uni.new(0x1E39).NFC.list ~~ (0x1E39,), '1E39 -> 1E39';
ok Uni.new(0x1E3A).NFC.list ~~ (0x1E3A,), '1E3A -> 1E3A';
ok Uni.new(0x1E3B).NFC.list ~~ (0x1E3B,), '1E3B -> 1E3B';
ok Uni.new(0x1E3C).NFC.list ~~ (0x1E3C,), '1E3C -> 1E3C';
ok Uni.new(0x1E3D).NFC.list ~~ (0x1E3D,), '1E3D -> 1E3D';
ok Uni.new(0x1E3E).NFC.list ~~ (0x1E3E,), '1E3E -> 1E3E';
ok Uni.new(0x1E3F).NFC.list ~~ (0x1E3F,), '1E3F -> 1E3F';
ok Uni.new(0x1E40).NFC.list ~~ (0x1E40,), '1E40 -> 1E40';
ok Uni.new(0x1E41).NFC.list ~~ (0x1E41,), '1E41 -> 1E41';
ok Uni.new(0x1E42).NFC.list ~~ (0x1E42,), '1E42 -> 1E42';
ok Uni.new(0x1E43).NFC.list ~~ (0x1E43,), '1E43 -> 1E43';
ok Uni.new(0x1E44).NFC.list ~~ (0x1E44,), '1E44 -> 1E44';
ok Uni.new(0x1E45).NFC.list ~~ (0x1E45,), '1E45 -> 1E45';
ok Uni.new(0x1E46).NFC.list ~~ (0x1E46,), '1E46 -> 1E46';
ok Uni.new(0x1E47).NFC.list ~~ (0x1E47,), '1E47 -> 1E47';
ok Uni.new(0x1E48).NFC.list ~~ (0x1E48,), '1E48 -> 1E48';
ok Uni.new(0x1E49).NFC.list ~~ (0x1E49,), '1E49 -> 1E49';
ok Uni.new(0x1E4A).NFC.list ~~ (0x1E4A,), '1E4A -> 1E4A';
ok Uni.new(0x1E4B).NFC.list ~~ (0x1E4B,), '1E4B -> 1E4B';
ok Uni.new(0x1E4C).NFC.list ~~ (0x1E4C,), '1E4C -> 1E4C';
ok Uni.new(0x1E4D).NFC.list ~~ (0x1E4D,), '1E4D -> 1E4D';
ok Uni.new(0x1E4E).NFC.list ~~ (0x1E4E,), '1E4E -> 1E4E';
ok Uni.new(0x1E4F).NFC.list ~~ (0x1E4F,), '1E4F -> 1E4F';
ok Uni.new(0x1E50).NFC.list ~~ (0x1E50,), '1E50 -> 1E50';
ok Uni.new(0x1E51).NFC.list ~~ (0x1E51,), '1E51 -> 1E51';
ok Uni.new(0x1E52).NFC.list ~~ (0x1E52,), '1E52 -> 1E52';
ok Uni.new(0x1E53).NFC.list ~~ (0x1E53,), '1E53 -> 1E53';
ok Uni.new(0x1E54).NFC.list ~~ (0x1E54,), '1E54 -> 1E54';
ok Uni.new(0x1E55).NFC.list ~~ (0x1E55,), '1E55 -> 1E55';
ok Uni.new(0x1E56).NFC.list ~~ (0x1E56,), '1E56 -> 1E56';
ok Uni.new(0x1E57).NFC.list ~~ (0x1E57,), '1E57 -> 1E57';
ok Uni.new(0x1E58).NFC.list ~~ (0x1E58,), '1E58 -> 1E58';
ok Uni.new(0x1E59).NFC.list ~~ (0x1E59,), '1E59 -> 1E59';
ok Uni.new(0x1E5A).NFC.list ~~ (0x1E5A,), '1E5A -> 1E5A';
ok Uni.new(0x1E5B).NFC.list ~~ (0x1E5B,), '1E5B -> 1E5B';
ok Uni.new(0x1E5C).NFC.list ~~ (0x1E5C,), '1E5C -> 1E5C';
ok Uni.new(0x1E5D).NFC.list ~~ (0x1E5D,), '1E5D -> 1E5D';
ok Uni.new(0x1E5E).NFC.list ~~ (0x1E5E,), '1E5E -> 1E5E';
ok Uni.new(0x1E5F).NFC.list ~~ (0x1E5F,), '1E5F -> 1E5F';
ok Uni.new(0x1E60).NFC.list ~~ (0x1E60,), '1E60 -> 1E60';
ok Uni.new(0x1E61).NFC.list ~~ (0x1E61,), '1E61 -> 1E61';
ok Uni.new(0x1E62).NFC.list ~~ (0x1E62,), '1E62 -> 1E62';
ok Uni.new(0x1E63).NFC.list ~~ (0x1E63,), '1E63 -> 1E63';
ok Uni.new(0x1E64).NFC.list ~~ (0x1E64,), '1E64 -> 1E64';
ok Uni.new(0x1E65).NFC.list ~~ (0x1E65,), '1E65 -> 1E65';
ok Uni.new(0x1E66).NFC.list ~~ (0x1E66,), '1E66 -> 1E66';
ok Uni.new(0x1E67).NFC.list ~~ (0x1E67,), '1E67 -> 1E67';
ok Uni.new(0x1E68).NFC.list ~~ (0x1E68,), '1E68 -> 1E68';
ok Uni.new(0x1E69).NFC.list ~~ (0x1E69,), '1E69 -> 1E69';
ok Uni.new(0x1E6A).NFC.list ~~ (0x1E6A,), '1E6A -> 1E6A';
ok Uni.new(0x1E6B).NFC.list ~~ (0x1E6B,), '1E6B -> 1E6B';
ok Uni.new(0x1E6C).NFC.list ~~ (0x1E6C,), '1E6C -> 1E6C';
ok Uni.new(0x1E6D).NFC.list ~~ (0x1E6D,), '1E6D -> 1E6D';
ok Uni.new(0x1E6E).NFC.list ~~ (0x1E6E,), '1E6E -> 1E6E';
ok Uni.new(0x1E6F).NFC.list ~~ (0x1E6F,), '1E6F -> 1E6F';
ok Uni.new(0x1E70).NFC.list ~~ (0x1E70,), '1E70 -> 1E70';
ok Uni.new(0x1E71).NFC.list ~~ (0x1E71,), '1E71 -> 1E71';
ok Uni.new(0x1E72).NFC.list ~~ (0x1E72,), '1E72 -> 1E72';
ok Uni.new(0x1E73).NFC.list ~~ (0x1E73,), '1E73 -> 1E73';
ok Uni.new(0x1E74).NFC.list ~~ (0x1E74,), '1E74 -> 1E74';
ok Uni.new(0x1E75).NFC.list ~~ (0x1E75,), '1E75 -> 1E75';
ok Uni.new(0x1E76).NFC.list ~~ (0x1E76,), '1E76 -> 1E76';
ok Uni.new(0x1E77).NFC.list ~~ (0x1E77,), '1E77 -> 1E77';
ok Uni.new(0x1E78).NFC.list ~~ (0x1E78,), '1E78 -> 1E78';
ok Uni.new(0x1E79).NFC.list ~~ (0x1E79,), '1E79 -> 1E79';
ok Uni.new(0x1E7A).NFC.list ~~ (0x1E7A,), '1E7A -> 1E7A';
ok Uni.new(0x1E7B).NFC.list ~~ (0x1E7B,), '1E7B -> 1E7B';
ok Uni.new(0x1E7C).NFC.list ~~ (0x1E7C,), '1E7C -> 1E7C';
ok Uni.new(0x1E7D).NFC.list ~~ (0x1E7D,), '1E7D -> 1E7D';
ok Uni.new(0x1E7E).NFC.list ~~ (0x1E7E,), '1E7E -> 1E7E';
ok Uni.new(0x1E7F).NFC.list ~~ (0x1E7F,), '1E7F -> 1E7F';
ok Uni.new(0x1E80).NFC.list ~~ (0x1E80,), '1E80 -> 1E80';
ok Uni.new(0x1E81).NFC.list ~~ (0x1E81,), '1E81 -> 1E81';
ok Uni.new(0x1E82).NFC.list ~~ (0x1E82,), '1E82 -> 1E82';
ok Uni.new(0x1E83).NFC.list ~~ (0x1E83,), '1E83 -> 1E83';
ok Uni.new(0x1E84).NFC.list ~~ (0x1E84,), '1E84 -> 1E84';
ok Uni.new(0x1E85).NFC.list ~~ (0x1E85,), '1E85 -> 1E85';
ok Uni.new(0x1E86).NFC.list ~~ (0x1E86,), '1E86 -> 1E86';
ok Uni.new(0x1E87).NFC.list ~~ (0x1E87,), '1E87 -> 1E87';
ok Uni.new(0x1E88).NFC.list ~~ (0x1E88,), '1E88 -> 1E88';
ok Uni.new(0x1E89).NFC.list ~~ (0x1E89,), '1E89 -> 1E89';
ok Uni.new(0x1E8A).NFC.list ~~ (0x1E8A,), '1E8A -> 1E8A';
ok Uni.new(0x1E8B).NFC.list ~~ (0x1E8B,), '1E8B -> 1E8B';
ok Uni.new(0x1E8C).NFC.list ~~ (0x1E8C,), '1E8C -> 1E8C';
ok Uni.new(0x1E8D).NFC.list ~~ (0x1E8D,), '1E8D -> 1E8D';
ok Uni.new(0x1E8E).NFC.list ~~ (0x1E8E,), '1E8E -> 1E8E';
ok Uni.new(0x1E8F).NFC.list ~~ (0x1E8F,), '1E8F -> 1E8F';
ok Uni.new(0x1E90).NFC.list ~~ (0x1E90,), '1E90 -> 1E90';
ok Uni.new(0x1E91).NFC.list ~~ (0x1E91,), '1E91 -> 1E91';
ok Uni.new(0x1E92).NFC.list ~~ (0x1E92,), '1E92 -> 1E92';
ok Uni.new(0x1E93).NFC.list ~~ (0x1E93,), '1E93 -> 1E93';
ok Uni.new(0x1E94).NFC.list ~~ (0x1E94,), '1E94 -> 1E94';
ok Uni.new(0x1E95).NFC.list ~~ (0x1E95,), '1E95 -> 1E95';
ok Uni.new(0x1E96).NFC.list ~~ (0x1E96,), '1E96 -> 1E96';
ok Uni.new(0x1E97).NFC.list ~~ (0x1E97,), '1E97 -> 1E97';
ok Uni.new(0x1E98).NFC.list ~~ (0x1E98,), '1E98 -> 1E98';
ok Uni.new(0x1E99).NFC.list ~~ (0x1E99,), '1E99 -> 1E99';
ok Uni.new(0x1E9A).NFC.list ~~ (0x1E9A,), '1E9A -> 1E9A';
ok Uni.new(0x1E9B).NFC.list ~~ (0x1E9B,), '1E9B -> 1E9B';
ok Uni.new(0x1EA0).NFC.list ~~ (0x1EA0,), '1EA0 -> 1EA0';
ok Uni.new(0x1EA1).NFC.list ~~ (0x1EA1,), '1EA1 -> 1EA1';
ok Uni.new(0x1EA2).NFC.list ~~ (0x1EA2,), '1EA2 -> 1EA2';
ok Uni.new(0x1EA3).NFC.list ~~ (0x1EA3,), '1EA3 -> 1EA3';
ok Uni.new(0x1EA4).NFC.list ~~ (0x1EA4,), '1EA4 -> 1EA4';
ok Uni.new(0x1EA5).NFC.list ~~ (0x1EA5,), '1EA5 -> 1EA5';
ok Uni.new(0x1EA6).NFC.list ~~ (0x1EA6,), '1EA6 -> 1EA6';
ok Uni.new(0x1EA7).NFC.list ~~ (0x1EA7,), '1EA7 -> 1EA7';
ok Uni.new(0x1EA8).NFC.list ~~ (0x1EA8,), '1EA8 -> 1EA8';
ok Uni.new(0x1EA9).NFC.list ~~ (0x1EA9,), '1EA9 -> 1EA9';
ok Uni.new(0x1EAA).NFC.list ~~ (0x1EAA,), '1EAA -> 1EAA';
ok Uni.new(0x1EAB).NFC.list ~~ (0x1EAB,), '1EAB -> 1EAB';
ok Uni.new(0x1EAC).NFC.list ~~ (0x1EAC,), '1EAC -> 1EAC';
ok Uni.new(0x1EAD).NFC.list ~~ (0x1EAD,), '1EAD -> 1EAD';
ok Uni.new(0x1EAE).NFC.list ~~ (0x1EAE,), '1EAE -> 1EAE';
ok Uni.new(0x1EAF).NFC.list ~~ (0x1EAF,), '1EAF -> 1EAF';
ok Uni.new(0x1EB0).NFC.list ~~ (0x1EB0,), '1EB0 -> 1EB0';
ok Uni.new(0x1EB1).NFC.list ~~ (0x1EB1,), '1EB1 -> 1EB1';
ok Uni.new(0x1EB2).NFC.list ~~ (0x1EB2,), '1EB2 -> 1EB2';
ok Uni.new(0x1EB3).NFC.list ~~ (0x1EB3,), '1EB3 -> 1EB3';
ok Uni.new(0x1EB4).NFC.list ~~ (0x1EB4,), '1EB4 -> 1EB4';
ok Uni.new(0x1EB5).NFC.list ~~ (0x1EB5,), '1EB5 -> 1EB5';
ok Uni.new(0x1EB6).NFC.list ~~ (0x1EB6,), '1EB6 -> 1EB6';
ok Uni.new(0x1EB7).NFC.list ~~ (0x1EB7,), '1EB7 -> 1EB7';
ok Uni.new(0x1EB8).NFC.list ~~ (0x1EB8,), '1EB8 -> 1EB8';
ok Uni.new(0x1EB9).NFC.list ~~ (0x1EB9,), '1EB9 -> 1EB9';
ok Uni.new(0x1EBA).NFC.list ~~ (0x1EBA,), '1EBA -> 1EBA';
ok Uni.new(0x1EBB).NFC.list ~~ (0x1EBB,), '1EBB -> 1EBB';
ok Uni.new(0x1EBC).NFC.list ~~ (0x1EBC,), '1EBC -> 1EBC';
ok Uni.new(0x1EBD).NFC.list ~~ (0x1EBD,), '1EBD -> 1EBD';
ok Uni.new(0x1EBE).NFC.list ~~ (0x1EBE,), '1EBE -> 1EBE';
ok Uni.new(0x1EBF).NFC.list ~~ (0x1EBF,), '1EBF -> 1EBF';
ok Uni.new(0x1EC0).NFC.list ~~ (0x1EC0,), '1EC0 -> 1EC0';
ok Uni.new(0x1EC1).NFC.list ~~ (0x1EC1,), '1EC1 -> 1EC1';
ok Uni.new(0x1EC2).NFC.list ~~ (0x1EC2,), '1EC2 -> 1EC2';
ok Uni.new(0x1EC3).NFC.list ~~ (0x1EC3,), '1EC3 -> 1EC3';
ok Uni.new(0x1EC4).NFC.list ~~ (0x1EC4,), '1EC4 -> 1EC4';
ok Uni.new(0x1EC5).NFC.list ~~ (0x1EC5,), '1EC5 -> 1EC5';
ok Uni.new(0x1EC6).NFC.list ~~ (0x1EC6,), '1EC6 -> 1EC6';
ok Uni.new(0x1EC7).NFC.list ~~ (0x1EC7,), '1EC7 -> 1EC7';
ok Uni.new(0x1EC8).NFC.list ~~ (0x1EC8,), '1EC8 -> 1EC8';
ok Uni.new(0x1EC9).NFC.list ~~ (0x1EC9,), '1EC9 -> 1EC9';
ok Uni.new(0x1ECA).NFC.list ~~ (0x1ECA,), '1ECA -> 1ECA';
ok Uni.new(0x1ECB).NFC.list ~~ (0x1ECB,), '1ECB -> 1ECB';
ok Uni.new(0x1ECC).NFC.list ~~ (0x1ECC,), '1ECC -> 1ECC';
ok Uni.new(0x1ECD).NFC.list ~~ (0x1ECD,), '1ECD -> 1ECD';
ok Uni.new(0x1ECE).NFC.list ~~ (0x1ECE,), '1ECE -> 1ECE';
ok Uni.new(0x1ECF).NFC.list ~~ (0x1ECF,), '1ECF -> 1ECF';
ok Uni.new(0x1ED0).NFC.list ~~ (0x1ED0,), '1ED0 -> 1ED0';
ok Uni.new(0x1ED1).NFC.list ~~ (0x1ED1,), '1ED1 -> 1ED1';
ok Uni.new(0x1ED2).NFC.list ~~ (0x1ED2,), '1ED2 -> 1ED2';
ok Uni.new(0x1ED3).NFC.list ~~ (0x1ED3,), '1ED3 -> 1ED3';
ok Uni.new(0x1ED4).NFC.list ~~ (0x1ED4,), '1ED4 -> 1ED4';
ok Uni.new(0x1ED5).NFC.list ~~ (0x1ED5,), '1ED5 -> 1ED5';
ok Uni.new(0x1ED6).NFC.list ~~ (0x1ED6,), '1ED6 -> 1ED6';
ok Uni.new(0x1ED7).NFC.list ~~ (0x1ED7,), '1ED7 -> 1ED7';
ok Uni.new(0x1ED8).NFC.list ~~ (0x1ED8,), '1ED8 -> 1ED8';
ok Uni.new(0x1ED9).NFC.list ~~ (0x1ED9,), '1ED9 -> 1ED9';
ok Uni.new(0x1EDA).NFC.list ~~ (0x1EDA,), '1EDA -> 1EDA';
ok Uni.new(0x1EDB).NFC.list ~~ (0x1EDB,), '1EDB -> 1EDB';
ok Uni.new(0x1EDC).NFC.list ~~ (0x1EDC,), '1EDC -> 1EDC';
ok Uni.new(0x1EDD).NFC.list ~~ (0x1EDD,), '1EDD -> 1EDD';
ok Uni.new(0x1EDE).NFC.list ~~ (0x1EDE,), '1EDE -> 1EDE';
ok Uni.new(0x1EDF).NFC.list ~~ (0x1EDF,), '1EDF -> 1EDF';
ok Uni.new(0x1EE0).NFC.list ~~ (0x1EE0,), '1EE0 -> 1EE0';
ok Uni.new(0x1EE1).NFC.list ~~ (0x1EE1,), '1EE1 -> 1EE1';
ok Uni.new(0x1EE2).NFC.list ~~ (0x1EE2,), '1EE2 -> 1EE2';
ok Uni.new(0x1EE3).NFC.list ~~ (0x1EE3,), '1EE3 -> 1EE3';
ok Uni.new(0x1EE4).NFC.list ~~ (0x1EE4,), '1EE4 -> 1EE4';
ok Uni.new(0x1EE5).NFC.list ~~ (0x1EE5,), '1EE5 -> 1EE5';
ok Uni.new(0x1EE6).NFC.list ~~ (0x1EE6,), '1EE6 -> 1EE6';
ok Uni.new(0x1EE7).NFC.list ~~ (0x1EE7,), '1EE7 -> 1EE7';
ok Uni.new(0x1EE8).NFC.list ~~ (0x1EE8,), '1EE8 -> 1EE8';
ok Uni.new(0x1EE9).NFC.list ~~ (0x1EE9,), '1EE9 -> 1EE9';
ok Uni.new(0x1EEA).NFC.list ~~ (0x1EEA,), '1EEA -> 1EEA';
ok Uni.new(0x1EEB).NFC.list ~~ (0x1EEB,), '1EEB -> 1EEB';
ok Uni.new(0x1EEC).NFC.list ~~ (0x1EEC,), '1EEC -> 1EEC';
ok Uni.new(0x1EED).NFC.list ~~ (0x1EED,), '1EED -> 1EED';
ok Uni.new(0x1EEE).NFC.list ~~ (0x1EEE,), '1EEE -> 1EEE';
ok Uni.new(0x1EEF).NFC.list ~~ (0x1EEF,), '1EEF -> 1EEF';
ok Uni.new(0x1EF0).NFC.list ~~ (0x1EF0,), '1EF0 -> 1EF0';
ok Uni.new(0x1EF1).NFC.list ~~ (0x1EF1,), '1EF1 -> 1EF1';
ok Uni.new(0x1EF2).NFC.list ~~ (0x1EF2,), '1EF2 -> 1EF2';
ok Uni.new(0x1EF3).NFC.list ~~ (0x1EF3,), '1EF3 -> 1EF3';
ok Uni.new(0x1EF4).NFC.list ~~ (0x1EF4,), '1EF4 -> 1EF4';
ok Uni.new(0x1EF5).NFC.list ~~ (0x1EF5,), '1EF5 -> 1EF5';
ok Uni.new(0x1EF6).NFC.list ~~ (0x1EF6,), '1EF6 -> 1EF6';
ok Uni.new(0x1EF7).NFC.list ~~ (0x1EF7,), '1EF7 -> 1EF7';
ok Uni.new(0x1EF8).NFC.list ~~ (0x1EF8,), '1EF8 -> 1EF8';
ok Uni.new(0x1EF9).NFC.list ~~ (0x1EF9,), '1EF9 -> 1EF9';
ok Uni.new(0x1F00).NFC.list ~~ (0x1F00,), '1F00 -> 1F00';
ok Uni.new(0x1F01).NFC.list ~~ (0x1F01,), '1F01 -> 1F01';
ok Uni.new(0x1F02).NFC.list ~~ (0x1F02,), '1F02 -> 1F02';
ok Uni.new(0x1F03).NFC.list ~~ (0x1F03,), '1F03 -> 1F03';
ok Uni.new(0x1F04).NFC.list ~~ (0x1F04,), '1F04 -> 1F04';
ok Uni.new(0x1F05).NFC.list ~~ (0x1F05,), '1F05 -> 1F05';
ok Uni.new(0x1F06).NFC.list ~~ (0x1F06,), '1F06 -> 1F06';
ok Uni.new(0x1F07).NFC.list ~~ (0x1F07,), '1F07 -> 1F07';
ok Uni.new(0x1F08).NFC.list ~~ (0x1F08,), '1F08 -> 1F08';
ok Uni.new(0x1F09).NFC.list ~~ (0x1F09,), '1F09 -> 1F09';
ok Uni.new(0x1F0A).NFC.list ~~ (0x1F0A,), '1F0A -> 1F0A';
ok Uni.new(0x1F0B).NFC.list ~~ (0x1F0B,), '1F0B -> 1F0B';
ok Uni.new(0x1F0C).NFC.list ~~ (0x1F0C,), '1F0C -> 1F0C';
ok Uni.new(0x1F0D).NFC.list ~~ (0x1F0D,), '1F0D -> 1F0D';
ok Uni.new(0x1F0E).NFC.list ~~ (0x1F0E,), '1F0E -> 1F0E';
ok Uni.new(0x1F0F).NFC.list ~~ (0x1F0F,), '1F0F -> 1F0F';
ok Uni.new(0x1F10).NFC.list ~~ (0x1F10,), '1F10 -> 1F10';
ok Uni.new(0x1F11).NFC.list ~~ (0x1F11,), '1F11 -> 1F11';
ok Uni.new(0x1F12).NFC.list ~~ (0x1F12,), '1F12 -> 1F12';
ok Uni.new(0x1F13).NFC.list ~~ (0x1F13,), '1F13 -> 1F13';
ok Uni.new(0x1F14).NFC.list ~~ (0x1F14,), '1F14 -> 1F14';
ok Uni.new(0x1F15).NFC.list ~~ (0x1F15,), '1F15 -> 1F15';
ok Uni.new(0x1F18).NFC.list ~~ (0x1F18,), '1F18 -> 1F18';
ok Uni.new(0x1F19).NFC.list ~~ (0x1F19,), '1F19 -> 1F19';
ok Uni.new(0x1F1A).NFC.list ~~ (0x1F1A,), '1F1A -> 1F1A';
ok Uni.new(0x1F1B).NFC.list ~~ (0x1F1B,), '1F1B -> 1F1B';
ok Uni.new(0x1F1C).NFC.list ~~ (0x1F1C,), '1F1C -> 1F1C';
ok Uni.new(0x1F1D).NFC.list ~~ (0x1F1D,), '1F1D -> 1F1D';
ok Uni.new(0x1F20).NFC.list ~~ (0x1F20,), '1F20 -> 1F20';
ok Uni.new(0x1F21).NFC.list ~~ (0x1F21,), '1F21 -> 1F21';
ok Uni.new(0x1F22).NFC.list ~~ (0x1F22,), '1F22 -> 1F22';
ok Uni.new(0x1F23).NFC.list ~~ (0x1F23,), '1F23 -> 1F23';
ok Uni.new(0x1F24).NFC.list ~~ (0x1F24,), '1F24 -> 1F24';
ok Uni.new(0x1F25).NFC.list ~~ (0x1F25,), '1F25 -> 1F25';
ok Uni.new(0x1F26).NFC.list ~~ (0x1F26,), '1F26 -> 1F26';
ok Uni.new(0x1F27).NFC.list ~~ (0x1F27,), '1F27 -> 1F27';
ok Uni.new(0x1F28).NFC.list ~~ (0x1F28,), '1F28 -> 1F28';
ok Uni.new(0x1F29).NFC.list ~~ (0x1F29,), '1F29 -> 1F29';
ok Uni.new(0x1F2A).NFC.list ~~ (0x1F2A,), '1F2A -> 1F2A';
ok Uni.new(0x1F2B).NFC.list ~~ (0x1F2B,), '1F2B -> 1F2B';
ok Uni.new(0x1F2C).NFC.list ~~ (0x1F2C,), '1F2C -> 1F2C';
ok Uni.new(0x1F2D).NFC.list ~~ (0x1F2D,), '1F2D -> 1F2D';
ok Uni.new(0x1F2E).NFC.list ~~ (0x1F2E,), '1F2E -> 1F2E';
ok Uni.new(0x1F2F).NFC.list ~~ (0x1F2F,), '1F2F -> 1F2F';
ok Uni.new(0x1F30).NFC.list ~~ (0x1F30,), '1F30 -> 1F30';
ok Uni.new(0x1F31).NFC.list ~~ (0x1F31,), '1F31 -> 1F31';
ok Uni.new(0x1F32).NFC.list ~~ (0x1F32,), '1F32 -> 1F32';
ok Uni.new(0x1F33).NFC.list ~~ (0x1F33,), '1F33 -> 1F33';
ok Uni.new(0x1F34).NFC.list ~~ (0x1F34,), '1F34 -> 1F34';
ok Uni.new(0x1F35).NFC.list ~~ (0x1F35,), '1F35 -> 1F35';
ok Uni.new(0x1F36).NFC.list ~~ (0x1F36,), '1F36 -> 1F36';
ok Uni.new(0x1F37).NFC.list ~~ (0x1F37,), '1F37 -> 1F37';
ok Uni.new(0x1F38).NFC.list ~~ (0x1F38,), '1F38 -> 1F38';
ok Uni.new(0x1F39).NFC.list ~~ (0x1F39,), '1F39 -> 1F39';
ok Uni.new(0x1F3A).NFC.list ~~ (0x1F3A,), '1F3A -> 1F3A';
ok Uni.new(0x1F3B).NFC.list ~~ (0x1F3B,), '1F3B -> 1F3B';
ok Uni.new(0x1F3C).NFC.list ~~ (0x1F3C,), '1F3C -> 1F3C';
ok Uni.new(0x1F3D).NFC.list ~~ (0x1F3D,), '1F3D -> 1F3D';
ok Uni.new(0x1F3E).NFC.list ~~ (0x1F3E,), '1F3E -> 1F3E';
ok Uni.new(0x1F3F).NFC.list ~~ (0x1F3F,), '1F3F -> 1F3F';
ok Uni.new(0x1F40).NFC.list ~~ (0x1F40,), '1F40 -> 1F40';
ok Uni.new(0x1F41).NFC.list ~~ (0x1F41,), '1F41 -> 1F41';
ok Uni.new(0x1F42).NFC.list ~~ (0x1F42,), '1F42 -> 1F42';
ok Uni.new(0x1F43).NFC.list ~~ (0x1F43,), '1F43 -> 1F43';
ok Uni.new(0x1F44).NFC.list ~~ (0x1F44,), '1F44 -> 1F44';
ok Uni.new(0x1F45).NFC.list ~~ (0x1F45,), '1F45 -> 1F45';
ok Uni.new(0x1F48).NFC.list ~~ (0x1F48,), '1F48 -> 1F48';
ok Uni.new(0x1F49).NFC.list ~~ (0x1F49,), '1F49 -> 1F49';
ok Uni.new(0x1F4A).NFC.list ~~ (0x1F4A,), '1F4A -> 1F4A';
ok Uni.new(0x1F4B).NFC.list ~~ (0x1F4B,), '1F4B -> 1F4B';
ok Uni.new(0x1F4C).NFC.list ~~ (0x1F4C,), '1F4C -> 1F4C';
ok Uni.new(0x1F4D).NFC.list ~~ (0x1F4D,), '1F4D -> 1F4D';
ok Uni.new(0x1F50).NFC.list ~~ (0x1F50,), '1F50 -> 1F50';
ok Uni.new(0x1F51).NFC.list ~~ (0x1F51,), '1F51 -> 1F51';
ok Uni.new(0x1F52).NFC.list ~~ (0x1F52,), '1F52 -> 1F52';
ok Uni.new(0x1F53).NFC.list ~~ (0x1F53,), '1F53 -> 1F53';
ok Uni.new(0x1F54).NFC.list ~~ (0x1F54,), '1F54 -> 1F54';
ok Uni.new(0x1F55).NFC.list ~~ (0x1F55,), '1F55 -> 1F55';
ok Uni.new(0x1F56).NFC.list ~~ (0x1F56,), '1F56 -> 1F56';
ok Uni.new(0x1F57).NFC.list ~~ (0x1F57,), '1F57 -> 1F57';
ok Uni.new(0x1F59).NFC.list ~~ (0x1F59,), '1F59 -> 1F59';
ok Uni.new(0x1F5B).NFC.list ~~ (0x1F5B,), '1F5B -> 1F5B';
ok Uni.new(0x1F5D).NFC.list ~~ (0x1F5D,), '1F5D -> 1F5D';
ok Uni.new(0x1F5F).NFC.list ~~ (0x1F5F,), '1F5F -> 1F5F';
ok Uni.new(0x1F60).NFC.list ~~ (0x1F60,), '1F60 -> 1F60';
ok Uni.new(0x1F61).NFC.list ~~ (0x1F61,), '1F61 -> 1F61';
ok Uni.new(0x1F62).NFC.list ~~ (0x1F62,), '1F62 -> 1F62';
ok Uni.new(0x1F63).NFC.list ~~ (0x1F63,), '1F63 -> 1F63';
ok Uni.new(0x1F64).NFC.list ~~ (0x1F64,), '1F64 -> 1F64';
ok Uni.new(0x1F65).NFC.list ~~ (0x1F65,), '1F65 -> 1F65';
ok Uni.new(0x1F66).NFC.list ~~ (0x1F66,), '1F66 -> 1F66';
ok Uni.new(0x1F67).NFC.list ~~ (0x1F67,), '1F67 -> 1F67';
ok Uni.new(0x1F68).NFC.list ~~ (0x1F68,), '1F68 -> 1F68';
ok Uni.new(0x1F69).NFC.list ~~ (0x1F69,), '1F69 -> 1F69';
ok Uni.new(0x1F6A).NFC.list ~~ (0x1F6A,), '1F6A -> 1F6A';
ok Uni.new(0x1F6B).NFC.list ~~ (0x1F6B,), '1F6B -> 1F6B';
ok Uni.new(0x1F6C).NFC.list ~~ (0x1F6C,), '1F6C -> 1F6C';
ok Uni.new(0x1F6D).NFC.list ~~ (0x1F6D,), '1F6D -> 1F6D';
ok Uni.new(0x1F6E).NFC.list ~~ (0x1F6E,), '1F6E -> 1F6E';
ok Uni.new(0x1F6F).NFC.list ~~ (0x1F6F,), '1F6F -> 1F6F';
ok Uni.new(0x1F70).NFC.list ~~ (0x1F70,), '1F70 -> 1F70';
ok Uni.new(0x1F71).NFC.list ~~ (0x03AC,), '1F71 -> 03AC';
ok Uni.new(0x1F72).NFC.list ~~ (0x1F72,), '1F72 -> 1F72';
ok Uni.new(0x1F73).NFC.list ~~ (0x03AD,), '1F73 -> 03AD';
ok Uni.new(0x1F74).NFC.list ~~ (0x1F74,), '1F74 -> 1F74';
ok Uni.new(0x1F75).NFC.list ~~ (0x03AE,), '1F75 -> 03AE';
ok Uni.new(0x1F76).NFC.list ~~ (0x1F76,), '1F76 -> 1F76';
ok Uni.new(0x1F77).NFC.list ~~ (0x03AF,), '1F77 -> 03AF';
ok Uni.new(0x1F78).NFC.list ~~ (0x1F78,), '1F78 -> 1F78';
ok Uni.new(0x1F79).NFC.list ~~ (0x03CC,), '1F79 -> 03CC';
ok Uni.new(0x1F7A).NFC.list ~~ (0x1F7A,), '1F7A -> 1F7A';
ok Uni.new(0x1F7B).NFC.list ~~ (0x03CD,), '1F7B -> 03CD';
ok Uni.new(0x1F7C).NFC.list ~~ (0x1F7C,), '1F7C -> 1F7C';
ok Uni.new(0x1F7D).NFC.list ~~ (0x03CE,), '1F7D -> 03CE';
ok Uni.new(0x1F80).NFC.list ~~ (0x1F80,), '1F80 -> 1F80';
ok Uni.new(0x1F81).NFC.list ~~ (0x1F81,), '1F81 -> 1F81';
ok Uni.new(0x1F82).NFC.list ~~ (0x1F82,), '1F82 -> 1F82';
ok Uni.new(0x1F83).NFC.list ~~ (0x1F83,), '1F83 -> 1F83';
ok Uni.new(0x1F84).NFC.list ~~ (0x1F84,), '1F84 -> 1F84';
ok Uni.new(0x1F85).NFC.list ~~ (0x1F85,), '1F85 -> 1F85';
ok Uni.new(0x1F86).NFC.list ~~ (0x1F86,), '1F86 -> 1F86';
ok Uni.new(0x1F87).NFC.list ~~ (0x1F87,), '1F87 -> 1F87';
ok Uni.new(0x1F88).NFC.list ~~ (0x1F88,), '1F88 -> 1F88';
ok Uni.new(0x1F89).NFC.list ~~ (0x1F89,), '1F89 -> 1F89';
ok Uni.new(0x1F8A).NFC.list ~~ (0x1F8A,), '1F8A -> 1F8A';
ok Uni.new(0x1F8B).NFC.list ~~ (0x1F8B,), '1F8B -> 1F8B';
ok Uni.new(0x1F8C).NFC.list ~~ (0x1F8C,), '1F8C -> 1F8C';
ok Uni.new(0x1F8D).NFC.list ~~ (0x1F8D,), '1F8D -> 1F8D';
ok Uni.new(0x1F8E).NFC.list ~~ (0x1F8E,), '1F8E -> 1F8E';
ok Uni.new(0x1F8F).NFC.list ~~ (0x1F8F,), '1F8F -> 1F8F';
ok Uni.new(0x1F90).NFC.list ~~ (0x1F90,), '1F90 -> 1F90';
ok Uni.new(0x1F91).NFC.list ~~ (0x1F91,), '1F91 -> 1F91';
ok Uni.new(0x1F92).NFC.list ~~ (0x1F92,), '1F92 -> 1F92';
ok Uni.new(0x1F93).NFC.list ~~ (0x1F93,), '1F93 -> 1F93';
ok Uni.new(0x1F94).NFC.list ~~ (0x1F94,), '1F94 -> 1F94';
ok Uni.new(0x1F95).NFC.list ~~ (0x1F95,), '1F95 -> 1F95';
ok Uni.new(0x1F96).NFC.list ~~ (0x1F96,), '1F96 -> 1F96';
ok Uni.new(0x1F97).NFC.list ~~ (0x1F97,), '1F97 -> 1F97';
ok Uni.new(0x1F98).NFC.list ~~ (0x1F98,), '1F98 -> 1F98';
ok Uni.new(0x1F99).NFC.list ~~ (0x1F99,), '1F99 -> 1F99';
ok Uni.new(0x1F9A).NFC.list ~~ (0x1F9A,), '1F9A -> 1F9A';
ok Uni.new(0x1F9B).NFC.list ~~ (0x1F9B,), '1F9B -> 1F9B';
ok Uni.new(0x1F9C).NFC.list ~~ (0x1F9C,), '1F9C -> 1F9C';
ok Uni.new(0x1F9D).NFC.list ~~ (0x1F9D,), '1F9D -> 1F9D';
ok Uni.new(0x1F9E).NFC.list ~~ (0x1F9E,), '1F9E -> 1F9E';
ok Uni.new(0x1F9F).NFC.list ~~ (0x1F9F,), '1F9F -> 1F9F';
ok Uni.new(0x1FA0).NFC.list ~~ (0x1FA0,), '1FA0 -> 1FA0';
ok Uni.new(0x1FA1).NFC.list ~~ (0x1FA1,), '1FA1 -> 1FA1';
ok Uni.new(0x1FA2).NFC.list ~~ (0x1FA2,), '1FA2 -> 1FA2';
ok Uni.new(0x1FA3).NFC.list ~~ (0x1FA3,), '1FA3 -> 1FA3';
ok Uni.new(0x1FA4).NFC.list ~~ (0x1FA4,), '1FA4 -> 1FA4';
ok Uni.new(0x1FA5).NFC.list ~~ (0x1FA5,), '1FA5 -> 1FA5';
ok Uni.new(0x1FA6).NFC.list ~~ (0x1FA6,), '1FA6 -> 1FA6';
ok Uni.new(0x1FA7).NFC.list ~~ (0x1FA7,), '1FA7 -> 1FA7';
ok Uni.new(0x1FA8).NFC.list ~~ (0x1FA8,), '1FA8 -> 1FA8';
ok Uni.new(0x1FA9).NFC.list ~~ (0x1FA9,), '1FA9 -> 1FA9';
ok Uni.new(0x1FAA).NFC.list ~~ (0x1FAA,), '1FAA -> 1FAA';
ok Uni.new(0x1FAB).NFC.list ~~ (0x1FAB,), '1FAB -> 1FAB';
ok Uni.new(0x1FAC).NFC.list ~~ (0x1FAC,), '1FAC -> 1FAC';
ok Uni.new(0x1FAD).NFC.list ~~ (0x1FAD,), '1FAD -> 1FAD';
ok Uni.new(0x1FAE).NFC.list ~~ (0x1FAE,), '1FAE -> 1FAE';
ok Uni.new(0x1FAF).NFC.list ~~ (0x1FAF,), '1FAF -> 1FAF';
ok Uni.new(0x1FB0).NFC.list ~~ (0x1FB0,), '1FB0 -> 1FB0';
ok Uni.new(0x1FB1).NFC.list ~~ (0x1FB1,), '1FB1 -> 1FB1';
ok Uni.new(0x1FB2).NFC.list ~~ (0x1FB2,), '1FB2 -> 1FB2';
ok Uni.new(0x1FB3).NFC.list ~~ (0x1FB3,), '1FB3 -> 1FB3';
ok Uni.new(0x1FB4).NFC.list ~~ (0x1FB4,), '1FB4 -> 1FB4';
ok Uni.new(0x1FB6).NFC.list ~~ (0x1FB6,), '1FB6 -> 1FB6';
ok Uni.new(0x1FB7).NFC.list ~~ (0x1FB7,), '1FB7 -> 1FB7';
ok Uni.new(0x1FB8).NFC.list ~~ (0x1FB8,), '1FB8 -> 1FB8';
ok Uni.new(0x1FB9).NFC.list ~~ (0x1FB9,), '1FB9 -> 1FB9';
ok Uni.new(0x1FBA).NFC.list ~~ (0x1FBA,), '1FBA -> 1FBA';
ok Uni.new(0x1FBB).NFC.list ~~ (0x0386,), '1FBB -> 0386';
ok Uni.new(0x1FBC).NFC.list ~~ (0x1FBC,), '1FBC -> 1FBC';
ok Uni.new(0x1FBD).NFC.list ~~ (0x1FBD,), '1FBD -> 1FBD';
ok Uni.new(0x1FBE).NFC.list ~~ (0x03B9,), '1FBE -> 03B9';
ok Uni.new(0x1FBF).NFC.list ~~ (0x1FBF,), '1FBF -> 1FBF';
ok Uni.new(0x1FC0).NFC.list ~~ (0x1FC0,), '1FC0 -> 1FC0';
ok Uni.new(0x1FC1).NFC.list ~~ (0x1FC1,), '1FC1 -> 1FC1';
ok Uni.new(0x1FC2).NFC.list ~~ (0x1FC2,), '1FC2 -> 1FC2';
ok Uni.new(0x1FC3).NFC.list ~~ (0x1FC3,), '1FC3 -> 1FC3';
ok Uni.new(0x1FC4).NFC.list ~~ (0x1FC4,), '1FC4 -> 1FC4';
ok Uni.new(0x1FC6).NFC.list ~~ (0x1FC6,), '1FC6 -> 1FC6';
ok Uni.new(0x1FC7).NFC.list ~~ (0x1FC7,), '1FC7 -> 1FC7';
ok Uni.new(0x1FC8).NFC.list ~~ (0x1FC8,), '1FC8 -> 1FC8';
ok Uni.new(0x1FC9).NFC.list ~~ (0x0388,), '1FC9 -> 0388';
ok Uni.new(0x1FCA).NFC.list ~~ (0x1FCA,), '1FCA -> 1FCA';
ok Uni.new(0x1FCB).NFC.list ~~ (0x0389,), '1FCB -> 0389';
ok Uni.new(0x1FCC).NFC.list ~~ (0x1FCC,), '1FCC -> 1FCC';
ok Uni.new(0x1FCD).NFC.list ~~ (0x1FCD,), '1FCD -> 1FCD';
ok Uni.new(0x1FCE).NFC.list ~~ (0x1FCE,), '1FCE -> 1FCE';
ok Uni.new(0x1FCF).NFC.list ~~ (0x1FCF,), '1FCF -> 1FCF';
ok Uni.new(0x1FD0).NFC.list ~~ (0x1FD0,), '1FD0 -> 1FD0';
ok Uni.new(0x1FD1).NFC.list ~~ (0x1FD1,), '1FD1 -> 1FD1';
ok Uni.new(0x1FD2).NFC.list ~~ (0x1FD2,), '1FD2 -> 1FD2';
ok Uni.new(0x1FD3).NFC.list ~~ (0x0390,), '1FD3 -> 0390';
ok Uni.new(0x1FD6).NFC.list ~~ (0x1FD6,), '1FD6 -> 1FD6';
ok Uni.new(0x1FD7).NFC.list ~~ (0x1FD7,), '1FD7 -> 1FD7';
ok Uni.new(0x1FD8).NFC.list ~~ (0x1FD8,), '1FD8 -> 1FD8';
ok Uni.new(0x1FD9).NFC.list ~~ (0x1FD9,), '1FD9 -> 1FD9';
ok Uni.new(0x1FDA).NFC.list ~~ (0x1FDA,), '1FDA -> 1FDA';
ok Uni.new(0x1FDB).NFC.list ~~ (0x038A,), '1FDB -> 038A';
ok Uni.new(0x1FDD).NFC.list ~~ (0x1FDD,), '1FDD -> 1FDD';
ok Uni.new(0x1FDE).NFC.list ~~ (0x1FDE,), '1FDE -> 1FDE';
ok Uni.new(0x1FDF).NFC.list ~~ (0x1FDF,), '1FDF -> 1FDF';
ok Uni.new(0x1FE0).NFC.list ~~ (0x1FE0,), '1FE0 -> 1FE0';
ok Uni.new(0x1FE1).NFC.list ~~ (0x1FE1,), '1FE1 -> 1FE1';
ok Uni.new(0x1FE2).NFC.list ~~ (0x1FE2,), '1FE2 -> 1FE2';
ok Uni.new(0x1FE3).NFC.list ~~ (0x03B0,), '1FE3 -> 03B0';
ok Uni.new(0x1FE4).NFC.list ~~ (0x1FE4,), '1FE4 -> 1FE4';
ok Uni.new(0x1FE5).NFC.list ~~ (0x1FE5,), '1FE5 -> 1FE5';
ok Uni.new(0x1FE6).NFC.list ~~ (0x1FE6,), '1FE6 -> 1FE6';
ok Uni.new(0x1FE7).NFC.list ~~ (0x1FE7,), '1FE7 -> 1FE7';
ok Uni.new(0x1FE8).NFC.list ~~ (0x1FE8,), '1FE8 -> 1FE8';
ok Uni.new(0x1FE9).NFC.list ~~ (0x1FE9,), '1FE9 -> 1FE9';
ok Uni.new(0x1FEA).NFC.list ~~ (0x1FEA,), '1FEA -> 1FEA';
ok Uni.new(0x1FEB).NFC.list ~~ (0x038E,), '1FEB -> 038E';
ok Uni.new(0x1FEC).NFC.list ~~ (0x1FEC,), '1FEC -> 1FEC';
ok Uni.new(0x1FED).NFC.list ~~ (0x1FED,), '1FED -> 1FED';
ok Uni.new(0x1FEE).NFC.list ~~ (0x0385,), '1FEE -> 0385';
ok Uni.new(0x1FEF).NFC.list ~~ (0x0060,), '1FEF -> 0060';
ok Uni.new(0x1FF2).NFC.list ~~ (0x1FF2,), '1FF2 -> 1FF2';
ok Uni.new(0x1FF3).NFC.list ~~ (0x1FF3,), '1FF3 -> 1FF3';
ok Uni.new(0x1FF4).NFC.list ~~ (0x1FF4,), '1FF4 -> 1FF4';
ok Uni.new(0x1FF6).NFC.list ~~ (0x1FF6,), '1FF6 -> 1FF6';
ok Uni.new(0x1FF7).NFC.list ~~ (0x1FF7,), '1FF7 -> 1FF7';
ok Uni.new(0x1FF8).NFC.list ~~ (0x1FF8,), '1FF8 -> 1FF8';
ok Uni.new(0x1FF9).NFC.list ~~ (0x038C,), '1FF9 -> 038C';
ok Uni.new(0x1FFA).NFC.list ~~ (0x1FFA,), '1FFA -> 1FFA';
ok Uni.new(0x1FFB).NFC.list ~~ (0x038F,), '1FFB -> 038F';
ok Uni.new(0x1FFC).NFC.list ~~ (0x1FFC,), '1FFC -> 1FFC';
ok Uni.new(0x1FFD).NFC.list ~~ (0x00B4,), '1FFD -> 00B4';
ok Uni.new(0x1FFE).NFC.list ~~ (0x1FFE,), '1FFE -> 1FFE';
ok Uni.new(0x2000).NFC.list ~~ (0x2002,), '2000 -> 2002';
ok Uni.new(0x2001).NFC.list ~~ (0x2003,), '2001 -> 2003';
ok Uni.new(0x2002).NFC.list ~~ (0x2002,), '2002 -> 2002';
ok Uni.new(0x2003).NFC.list ~~ (0x2003,), '2003 -> 2003';
ok Uni.new(0x2004).NFC.list ~~ (0x2004,), '2004 -> 2004';
ok Uni.new(0x2005).NFC.list ~~ (0x2005,), '2005 -> 2005';
ok Uni.new(0x2006).NFC.list ~~ (0x2006,), '2006 -> 2006';
ok Uni.new(0x2007).NFC.list ~~ (0x2007,), '2007 -> 2007';
ok Uni.new(0x2008).NFC.list ~~ (0x2008,), '2008 -> 2008';
ok Uni.new(0x2009).NFC.list ~~ (0x2009,), '2009 -> 2009';
ok Uni.new(0x200A).NFC.list ~~ (0x200A,), '200A -> 200A';
ok Uni.new(0x2011).NFC.list ~~ (0x2011,), '2011 -> 2011';
ok Uni.new(0x2017).NFC.list ~~ (0x2017,), '2017 -> 2017';
ok Uni.new(0x2024).NFC.list ~~ (0x2024,), '2024 -> 2024';
ok Uni.new(0x2025).NFC.list ~~ (0x2025,), '2025 -> 2025';
ok Uni.new(0x2026).NFC.list ~~ (0x2026,), '2026 -> 2026';
ok Uni.new(0x202F).NFC.list ~~ (0x202F,), '202F -> 202F';
ok Uni.new(0x2033).NFC.list ~~ (0x2033,), '2033 -> 2033';
ok Uni.new(0x2034).NFC.list ~~ (0x2034,), '2034 -> 2034';
ok Uni.new(0x2036).NFC.list ~~ (0x2036,), '2036 -> 2036';
ok Uni.new(0x2037).NFC.list ~~ (0x2037,), '2037 -> 2037';
ok Uni.new(0x203C).NFC.list ~~ (0x203C,), '203C -> 203C';
ok Uni.new(0x203E).NFC.list ~~ (0x203E,), '203E -> 203E';
ok Uni.new(0x2047).NFC.list ~~ (0x2047,), '2047 -> 2047';
ok Uni.new(0x2048).NFC.list ~~ (0x2048,), '2048 -> 2048';
ok Uni.new(0x2049).NFC.list ~~ (0x2049,), '2049 -> 2049';
ok Uni.new(0x2057).NFC.list ~~ (0x2057,), '2057 -> 2057';
ok Uni.new(0x205F).NFC.list ~~ (0x205F,), '205F -> 205F';
ok Uni.new(0x2070).NFC.list ~~ (0x2070,), '2070 -> 2070';
ok Uni.new(0x2071).NFC.list ~~ (0x2071,), '2071 -> 2071';
ok Uni.new(0x2074).NFC.list ~~ (0x2074,), '2074 -> 2074';
ok Uni.new(0x2075).NFC.list ~~ (0x2075,), '2075 -> 2075';
ok Uni.new(0x2076).NFC.list ~~ (0x2076,), '2076 -> 2076';
ok Uni.new(0x2077).NFC.list ~~ (0x2077,), '2077 -> 2077';
ok Uni.new(0x2078).NFC.list ~~ (0x2078,), '2078 -> 2078';
ok Uni.new(0x2079).NFC.list ~~ (0x2079,), '2079 -> 2079';
ok Uni.new(0x207A).NFC.list ~~ (0x207A,), '207A -> 207A';
ok Uni.new(0x207B).NFC.list ~~ (0x207B,), '207B -> 207B';
ok Uni.new(0x207C).NFC.list ~~ (0x207C,), '207C -> 207C';
ok Uni.new(0x207D).NFC.list ~~ (0x207D,), '207D -> 207D';
ok Uni.new(0x207E).NFC.list ~~ (0x207E,), '207E -> 207E';
ok Uni.new(0x207F).NFC.list ~~ (0x207F,), '207F -> 207F';
ok Uni.new(0x2080).NFC.list ~~ (0x2080,), '2080 -> 2080';
ok Uni.new(0x2081).NFC.list ~~ (0x2081,), '2081 -> 2081';
ok Uni.new(0x2082).NFC.list ~~ (0x2082,), '2082 -> 2082';
ok Uni.new(0x2083).NFC.list ~~ (0x2083,), '2083 -> 2083';
ok Uni.new(0x2084).NFC.list ~~ (0x2084,), '2084 -> 2084';
ok Uni.new(0x2085).NFC.list ~~ (0x2085,), '2085 -> 2085';
ok Uni.new(0x2086).NFC.list ~~ (0x2086,), '2086 -> 2086';
ok Uni.new(0x2087).NFC.list ~~ (0x2087,), '2087 -> 2087';
ok Uni.new(0x2088).NFC.list ~~ (0x2088,), '2088 -> 2088';
ok Uni.new(0x2089).NFC.list ~~ (0x2089,), '2089 -> 2089';
ok Uni.new(0x208A).NFC.list ~~ (0x208A,), '208A -> 208A';
ok Uni.new(0x208B).NFC.list ~~ (0x208B,), '208B -> 208B';
ok Uni.new(0x208C).NFC.list ~~ (0x208C,), '208C -> 208C';
ok Uni.new(0x208D).NFC.list ~~ (0x208D,), '208D -> 208D';
ok Uni.new(0x208E).NFC.list ~~ (0x208E,), '208E -> 208E';
ok Uni.new(0x2090).NFC.list ~~ (0x2090,), '2090 -> 2090';
ok Uni.new(0x2091).NFC.list ~~ (0x2091,), '2091 -> 2091';
ok Uni.new(0x2092).NFC.list ~~ (0x2092,), '2092 -> 2092';
ok Uni.new(0x2093).NFC.list ~~ (0x2093,), '2093 -> 2093';
ok Uni.new(0x2094).NFC.list ~~ (0x2094,), '2094 -> 2094';
ok Uni.new(0x2095).NFC.list ~~ (0x2095,), '2095 -> 2095';
ok Uni.new(0x2096).NFC.list ~~ (0x2096,), '2096 -> 2096';
ok Uni.new(0x2097).NFC.list ~~ (0x2097,), '2097 -> 2097';
ok Uni.new(0x2098).NFC.list ~~ (0x2098,), '2098 -> 2098';
ok Uni.new(0x2099).NFC.list ~~ (0x2099,), '2099 -> 2099';
ok Uni.new(0x209A).NFC.list ~~ (0x209A,), '209A -> 209A';
ok Uni.new(0x209B).NFC.list ~~ (0x209B,), '209B -> 209B';
ok Uni.new(0x209C).NFC.list ~~ (0x209C,), '209C -> 209C';
ok Uni.new(0x20A8).NFC.list ~~ (0x20A8,), '20A8 -> 20A8';
ok Uni.new(0x2100).NFC.list ~~ (0x2100,), '2100 -> 2100';
ok Uni.new(0x2101).NFC.list ~~ (0x2101,), '2101 -> 2101';
ok Uni.new(0x2102).NFC.list ~~ (0x2102,), '2102 -> 2102';
ok Uni.new(0x2103).NFC.list ~~ (0x2103,), '2103 -> 2103';
ok Uni.new(0x2105).NFC.list ~~ (0x2105,), '2105 -> 2105';
ok Uni.new(0x2106).NFC.list ~~ (0x2106,), '2106 -> 2106';
ok Uni.new(0x2107).NFC.list ~~ (0x2107,), '2107 -> 2107';
ok Uni.new(0x2109).NFC.list ~~ (0x2109,), '2109 -> 2109';
ok Uni.new(0x210A).NFC.list ~~ (0x210A,), '210A -> 210A';
ok Uni.new(0x210B).NFC.list ~~ (0x210B,), '210B -> 210B';
ok Uni.new(0x210C).NFC.list ~~ (0x210C,), '210C -> 210C';
ok Uni.new(0x210D).NFC.list ~~ (0x210D,), '210D -> 210D';
ok Uni.new(0x210E).NFC.list ~~ (0x210E,), '210E -> 210E';
ok Uni.new(0x210F).NFC.list ~~ (0x210F,), '210F -> 210F';
ok Uni.new(0x2110).NFC.list ~~ (0x2110,), '2110 -> 2110';
ok Uni.new(0x2111).NFC.list ~~ (0x2111,), '2111 -> 2111';
ok Uni.new(0x2112).NFC.list ~~ (0x2112,), '2112 -> 2112';
ok Uni.new(0x2113).NFC.list ~~ (0x2113,), '2113 -> 2113';
ok Uni.new(0x2115).NFC.list ~~ (0x2115,), '2115 -> 2115';
ok Uni.new(0x2116).NFC.list ~~ (0x2116,), '2116 -> 2116';
ok Uni.new(0x2119).NFC.list ~~ (0x2119,), '2119 -> 2119';
ok Uni.new(0x211A).NFC.list ~~ (0x211A,), '211A -> 211A';
ok Uni.new(0x211B).NFC.list ~~ (0x211B,), '211B -> 211B';
ok Uni.new(0x211C).NFC.list ~~ (0x211C,), '211C -> 211C';
ok Uni.new(0x211D).NFC.list ~~ (0x211D,), '211D -> 211D';
ok Uni.new(0x2120).NFC.list ~~ (0x2120,), '2120 -> 2120';
ok Uni.new(0x2121).NFC.list ~~ (0x2121,), '2121 -> 2121';
ok Uni.new(0x2122).NFC.list ~~ (0x2122,), '2122 -> 2122';
ok Uni.new(0x2124).NFC.list ~~ (0x2124,), '2124 -> 2124';
ok Uni.new(0x2126).NFC.list ~~ (0x03A9,), '2126 -> 03A9';
ok Uni.new(0x2128).NFC.list ~~ (0x2128,), '2128 -> 2128';
ok Uni.new(0x212A).NFC.list ~~ (0x004B,), '212A -> 004B';
ok Uni.new(0x212B).NFC.list ~~ (0x00C5,), '212B -> 00C5';
ok Uni.new(0x212C).NFC.list ~~ (0x212C,), '212C -> 212C';
ok Uni.new(0x212D).NFC.list ~~ (0x212D,), '212D -> 212D';
ok Uni.new(0x212F).NFC.list ~~ (0x212F,), '212F -> 212F';
ok Uni.new(0x2130).NFC.list ~~ (0x2130,), '2130 -> 2130';
ok Uni.new(0x2131).NFC.list ~~ (0x2131,), '2131 -> 2131';
ok Uni.new(0x2133).NFC.list ~~ (0x2133,), '2133 -> 2133';
ok Uni.new(0x2134).NFC.list ~~ (0x2134,), '2134 -> 2134';
ok Uni.new(0x2135).NFC.list ~~ (0x2135,), '2135 -> 2135';
ok Uni.new(0x2136).NFC.list ~~ (0x2136,), '2136 -> 2136';
ok Uni.new(0x2137).NFC.list ~~ (0x2137,), '2137 -> 2137';
ok Uni.new(0x2138).NFC.list ~~ (0x2138,), '2138 -> 2138';
ok Uni.new(0x2139).NFC.list ~~ (0x2139,), '2139 -> 2139';
ok Uni.new(0x213B).NFC.list ~~ (0x213B,), '213B -> 213B';
ok Uni.new(0x213C).NFC.list ~~ (0x213C,), '213C -> 213C';
ok Uni.new(0x213D).NFC.list ~~ (0x213D,), '213D -> 213D';
ok Uni.new(0x213E).NFC.list ~~ (0x213E,), '213E -> 213E';
ok Uni.new(0x213F).NFC.list ~~ (0x213F,), '213F -> 213F';
ok Uni.new(0x2140).NFC.list ~~ (0x2140,), '2140 -> 2140';
ok Uni.new(0x2145).NFC.list ~~ (0x2145,), '2145 -> 2145';
ok Uni.new(0x2146).NFC.list ~~ (0x2146,), '2146 -> 2146';
ok Uni.new(0x2147).NFC.list ~~ (0x2147,), '2147 -> 2147';
ok Uni.new(0x2148).NFC.list ~~ (0x2148,), '2148 -> 2148';
ok Uni.new(0x2149).NFC.list ~~ (0x2149,), '2149 -> 2149';
ok Uni.new(0x2150).NFC.list ~~ (0x2150,), '2150 -> 2150';
ok Uni.new(0x2151).NFC.list ~~ (0x2151,), '2151 -> 2151';
ok Uni.new(0x2152).NFC.list ~~ (0x2152,), '2152 -> 2152';
ok Uni.new(0x2153).NFC.list ~~ (0x2153,), '2153 -> 2153';
ok Uni.new(0x2154).NFC.list ~~ (0x2154,), '2154 -> 2154';
ok Uni.new(0x2155).NFC.list ~~ (0x2155,), '2155 -> 2155';
ok Uni.new(0x2156).NFC.list ~~ (0x2156,), '2156 -> 2156';
ok Uni.new(0x2157).NFC.list ~~ (0x2157,), '2157 -> 2157';
ok Uni.new(0x2158).NFC.list ~~ (0x2158,), '2158 -> 2158';
ok Uni.new(0x2159).NFC.list ~~ (0x2159,), '2159 -> 2159';
ok Uni.new(0x215A).NFC.list ~~ (0x215A,), '215A -> 215A';
ok Uni.new(0x215B).NFC.list ~~ (0x215B,), '215B -> 215B';
ok Uni.new(0x215C).NFC.list ~~ (0x215C,), '215C -> 215C';
ok Uni.new(0x215D).NFC.list ~~ (0x215D,), '215D -> 215D';
ok Uni.new(0x215E).NFC.list ~~ (0x215E,), '215E -> 215E';
ok Uni.new(0x215F).NFC.list ~~ (0x215F,), '215F -> 215F';
ok Uni.new(0x2160).NFC.list ~~ (0x2160,), '2160 -> 2160';
ok Uni.new(0x2161).NFC.list ~~ (0x2161,), '2161 -> 2161';
ok Uni.new(0x2162).NFC.list ~~ (0x2162,), '2162 -> 2162';
ok Uni.new(0x2163).NFC.list ~~ (0x2163,), '2163 -> 2163';
ok Uni.new(0x2164).NFC.list ~~ (0x2164,), '2164 -> 2164';
ok Uni.new(0x2165).NFC.list ~~ (0x2165,), '2165 -> 2165';
ok Uni.new(0x2166).NFC.list ~~ (0x2166,), '2166 -> 2166';
ok Uni.new(0x2167).NFC.list ~~ (0x2167,), '2167 -> 2167';
ok Uni.new(0x2168).NFC.list ~~ (0x2168,), '2168 -> 2168';
ok Uni.new(0x2169).NFC.list ~~ (0x2169,), '2169 -> 2169';
ok Uni.new(0x216A).NFC.list ~~ (0x216A,), '216A -> 216A';
ok Uni.new(0x216B).NFC.list ~~ (0x216B,), '216B -> 216B';
ok Uni.new(0x216C).NFC.list ~~ (0x216C,), '216C -> 216C';
ok Uni.new(0x216D).NFC.list ~~ (0x216D,), '216D -> 216D';
ok Uni.new(0x216E).NFC.list ~~ (0x216E,), '216E -> 216E';
ok Uni.new(0x216F).NFC.list ~~ (0x216F,), '216F -> 216F';
ok Uni.new(0x2170).NFC.list ~~ (0x2170,), '2170 -> 2170';
ok Uni.new(0x2171).NFC.list ~~ (0x2171,), '2171 -> 2171';
ok Uni.new(0x2172).NFC.list ~~ (0x2172,), '2172 -> 2172';
ok Uni.new(0x2173).NFC.list ~~ (0x2173,), '2173 -> 2173';
ok Uni.new(0x2174).NFC.list ~~ (0x2174,), '2174 -> 2174';
ok Uni.new(0x2175).NFC.list ~~ (0x2175,), '2175 -> 2175';
ok Uni.new(0x2176).NFC.list ~~ (0x2176,), '2176 -> 2176';
ok Uni.new(0x2177).NFC.list ~~ (0x2177,), '2177 -> 2177';
ok Uni.new(0x2178).NFC.list ~~ (0x2178,), '2178 -> 2178';
ok Uni.new(0x2179).NFC.list ~~ (0x2179,), '2179 -> 2179';
ok Uni.new(0x217A).NFC.list ~~ (0x217A,), '217A -> 217A';
ok Uni.new(0x217B).NFC.list ~~ (0x217B,), '217B -> 217B';
ok Uni.new(0x217C).NFC.list ~~ (0x217C,), '217C -> 217C';
ok Uni.new(0x217D).NFC.list ~~ (0x217D,), '217D -> 217D';
ok Uni.new(0x217E).NFC.list ~~ (0x217E,), '217E -> 217E';
ok Uni.new(0x217F).NFC.list ~~ (0x217F,), '217F -> 217F';
ok Uni.new(0x2189).NFC.list ~~ (0x2189,), '2189 -> 2189';
ok Uni.new(0x219A).NFC.list ~~ (0x219A,), '219A -> 219A';
ok Uni.new(0x219B).NFC.list ~~ (0x219B,), '219B -> 219B';
ok Uni.new(0x21AE).NFC.list ~~ (0x21AE,), '21AE -> 21AE';
ok Uni.new(0x21CD).NFC.list ~~ (0x21CD,), '21CD -> 21CD';
ok Uni.new(0x21CE).NFC.list ~~ (0x21CE,), '21CE -> 21CE';
ok Uni.new(0x21CF).NFC.list ~~ (0x21CF,), '21CF -> 21CF';
ok Uni.new(0x2204).NFC.list ~~ (0x2204,), '2204 -> 2204';
ok Uni.new(0x2209).NFC.list ~~ (0x2209,), '2209 -> 2209';
ok Uni.new(0x220C).NFC.list ~~ (0x220C,), '220C -> 220C';
ok Uni.new(0x2224).NFC.list ~~ (0x2224,), '2224 -> 2224';
ok Uni.new(0x2226).NFC.list ~~ (0x2226,), '2226 -> 2226';
ok Uni.new(0x222C).NFC.list ~~ (0x222C,), '222C -> 222C';
ok Uni.new(0x222D).NFC.list ~~ (0x222D,), '222D -> 222D';
ok Uni.new(0x222F).NFC.list ~~ (0x222F,), '222F -> 222F';
ok Uni.new(0x2230).NFC.list ~~ (0x2230,), '2230 -> 2230';
ok Uni.new(0x2241).NFC.list ~~ (0x2241,), '2241 -> 2241';
ok Uni.new(0x2244).NFC.list ~~ (0x2244,), '2244 -> 2244';
ok Uni.new(0x2247).NFC.list ~~ (0x2247,), '2247 -> 2247';
ok Uni.new(0x2249).NFC.list ~~ (0x2249,), '2249 -> 2249';
ok Uni.new(0x2260).NFC.list ~~ (0x2260,), '2260 -> 2260';
ok Uni.new(0x2262).NFC.list ~~ (0x2262,), '2262 -> 2262';
ok Uni.new(0x226D).NFC.list ~~ (0x226D,), '226D -> 226D';
ok Uni.new(0x226E).NFC.list ~~ (0x226E,), '226E -> 226E';
ok Uni.new(0x226F).NFC.list ~~ (0x226F,), '226F -> 226F';
ok Uni.new(0x2270).NFC.list ~~ (0x2270,), '2270 -> 2270';
ok Uni.new(0x2271).NFC.list ~~ (0x2271,), '2271 -> 2271';
ok Uni.new(0x2274).NFC.list ~~ (0x2274,), '2274 -> 2274';
ok Uni.new(0x2275).NFC.list ~~ (0x2275,), '2275 -> 2275';
ok Uni.new(0x2278).NFC.list ~~ (0x2278,), '2278 -> 2278';
ok Uni.new(0x2279).NFC.list ~~ (0x2279,), '2279 -> 2279';
ok Uni.new(0x2280).NFC.list ~~ (0x2280,), '2280 -> 2280';
ok Uni.new(0x2281).NFC.list ~~ (0x2281,), '2281 -> 2281';
ok Uni.new(0x2284).NFC.list ~~ (0x2284,), '2284 -> 2284';
ok Uni.new(0x2285).NFC.list ~~ (0x2285,), '2285 -> 2285';
ok Uni.new(0x2288).NFC.list ~~ (0x2288,), '2288 -> 2288';
ok Uni.new(0x2289).NFC.list ~~ (0x2289,), '2289 -> 2289';
ok Uni.new(0x22AC).NFC.list ~~ (0x22AC,), '22AC -> 22AC';
ok Uni.new(0x22AD).NFC.list ~~ (0x22AD,), '22AD -> 22AD';
ok Uni.new(0x22AE).NFC.list ~~ (0x22AE,), '22AE -> 22AE';
ok Uni.new(0x22AF).NFC.list ~~ (0x22AF,), '22AF -> 22AF';
ok Uni.new(0x22E0).NFC.list ~~ (0x22E0,), '22E0 -> 22E0';
ok Uni.new(0x22E1).NFC.list ~~ (0x22E1,), '22E1 -> 22E1';
ok Uni.new(0x22E2).NFC.list ~~ (0x22E2,), '22E2 -> 22E2';
ok Uni.new(0x22E3).NFC.list ~~ (0x22E3,), '22E3 -> 22E3';
ok Uni.new(0x22EA).NFC.list ~~ (0x22EA,), '22EA -> 22EA';
ok Uni.new(0x22EB).NFC.list ~~ (0x22EB,), '22EB -> 22EB';
ok Uni.new(0x22EC).NFC.list ~~ (0x22EC,), '22EC -> 22EC';
ok Uni.new(0x22ED).NFC.list ~~ (0x22ED,), '22ED -> 22ED';
ok Uni.new(0x2329).NFC.list ~~ (0x3008,), '2329 -> 3008';
ok Uni.new(0x232A).NFC.list ~~ (0x3009,), '232A -> 3009';
ok Uni.new(0x2460).NFC.list ~~ (0x2460,), '2460 -> 2460';
ok Uni.new(0x2461).NFC.list ~~ (0x2461,), '2461 -> 2461';
ok Uni.new(0x2462).NFC.list ~~ (0x2462,), '2462 -> 2462';
ok Uni.new(0x2463).NFC.list ~~ (0x2463,), '2463 -> 2463';
ok Uni.new(0x2464).NFC.list ~~ (0x2464,), '2464 -> 2464';
ok Uni.new(0x2465).NFC.list ~~ (0x2465,), '2465 -> 2465';
ok Uni.new(0x2466).NFC.list ~~ (0x2466,), '2466 -> 2466';
ok Uni.new(0x2467).NFC.list ~~ (0x2467,), '2467 -> 2467';
ok Uni.new(0x2468).NFC.list ~~ (0x2468,), '2468 -> 2468';
ok Uni.new(0x2469).NFC.list ~~ (0x2469,), '2469 -> 2469';
ok Uni.new(0x246A).NFC.list ~~ (0x246A,), '246A -> 246A';
ok Uni.new(0x246B).NFC.list ~~ (0x246B,), '246B -> 246B';
ok Uni.new(0x246C).NFC.list ~~ (0x246C,), '246C -> 246C';
ok Uni.new(0x246D).NFC.list ~~ (0x246D,), '246D -> 246D';
ok Uni.new(0x246E).NFC.list ~~ (0x246E,), '246E -> 246E';
ok Uni.new(0x246F).NFC.list ~~ (0x246F,), '246F -> 246F';
ok Uni.new(0x2470).NFC.list ~~ (0x2470,), '2470 -> 2470';
ok Uni.new(0x2471).NFC.list ~~ (0x2471,), '2471 -> 2471';
ok Uni.new(0x2472).NFC.list ~~ (0x2472,), '2472 -> 2472';
ok Uni.new(0x2473).NFC.list ~~ (0x2473,), '2473 -> 2473';
ok Uni.new(0x2474).NFC.list ~~ (0x2474,), '2474 -> 2474';
ok Uni.new(0x2475).NFC.list ~~ (0x2475,), '2475 -> 2475';
ok Uni.new(0x2476).NFC.list ~~ (0x2476,), '2476 -> 2476';
ok Uni.new(0x2477).NFC.list ~~ (0x2477,), '2477 -> 2477';
ok Uni.new(0x2478).NFC.list ~~ (0x2478,), '2478 -> 2478';
ok Uni.new(0x2479).NFC.list ~~ (0x2479,), '2479 -> 2479';
ok Uni.new(0x247A).NFC.list ~~ (0x247A,), '247A -> 247A';
ok Uni.new(0x247B).NFC.list ~~ (0x247B,), '247B -> 247B';
ok Uni.new(0x247C).NFC.list ~~ (0x247C,), '247C -> 247C';
ok Uni.new(0x247D).NFC.list ~~ (0x247D,), '247D -> 247D';
ok Uni.new(0x247E).NFC.list ~~ (0x247E,), '247E -> 247E';
ok Uni.new(0x247F).NFC.list ~~ (0x247F,), '247F -> 247F';
ok Uni.new(0x2480).NFC.list ~~ (0x2480,), '2480 -> 2480';
ok Uni.new(0x2481).NFC.list ~~ (0x2481,), '2481 -> 2481';
ok Uni.new(0x2482).NFC.list ~~ (0x2482,), '2482 -> 2482';
ok Uni.new(0x2483).NFC.list ~~ (0x2483,), '2483 -> 2483';
ok Uni.new(0x2484).NFC.list ~~ (0x2484,), '2484 -> 2484';
ok Uni.new(0x2485).NFC.list ~~ (0x2485,), '2485 -> 2485';
ok Uni.new(0x2486).NFC.list ~~ (0x2486,), '2486 -> 2486';
ok Uni.new(0x2487).NFC.list ~~ (0x2487,), '2487 -> 2487';
ok Uni.new(0x2488).NFC.list ~~ (0x2488,), '2488 -> 2488';
ok Uni.new(0x2489).NFC.list ~~ (0x2489,), '2489 -> 2489';
ok Uni.new(0x248A).NFC.list ~~ (0x248A,), '248A -> 248A';
ok Uni.new(0x248B).NFC.list ~~ (0x248B,), '248B -> 248B';
ok Uni.new(0x248C).NFC.list ~~ (0x248C,), '248C -> 248C';
ok Uni.new(0x248D).NFC.list ~~ (0x248D,), '248D -> 248D';
ok Uni.new(0x248E).NFC.list ~~ (0x248E,), '248E -> 248E';
ok Uni.new(0x248F).NFC.list ~~ (0x248F,), '248F -> 248F';
ok Uni.new(0x2490).NFC.list ~~ (0x2490,), '2490 -> 2490';
ok Uni.new(0x2491).NFC.list ~~ (0x2491,), '2491 -> 2491';
ok Uni.new(0x2492).NFC.list ~~ (0x2492,), '2492 -> 2492';
ok Uni.new(0x2493).NFC.list ~~ (0x2493,), '2493 -> 2493';
ok Uni.new(0x2494).NFC.list ~~ (0x2494,), '2494 -> 2494';
ok Uni.new(0x2495).NFC.list ~~ (0x2495,), '2495 -> 2495';
ok Uni.new(0x2496).NFC.list ~~ (0x2496,), '2496 -> 2496';
ok Uni.new(0x2497).NFC.list ~~ (0x2497,), '2497 -> 2497';
ok Uni.new(0x2498).NFC.list ~~ (0x2498,), '2498 -> 2498';
ok Uni.new(0x2499).NFC.list ~~ (0x2499,), '2499 -> 2499';
ok Uni.new(0x249A).NFC.list ~~ (0x249A,), '249A -> 249A';
ok Uni.new(0x249B).NFC.list ~~ (0x249B,), '249B -> 249B';
ok Uni.new(0x249C).NFC.list ~~ (0x249C,), '249C -> 249C';
ok Uni.new(0x249D).NFC.list ~~ (0x249D,), '249D -> 249D';
ok Uni.new(0x249E).NFC.list ~~ (0x249E,), '249E -> 249E';
ok Uni.new(0x249F).NFC.list ~~ (0x249F,), '249F -> 249F';
ok Uni.new(0x24A0).NFC.list ~~ (0x24A0,), '24A0 -> 24A0';
ok Uni.new(0x24A1).NFC.list ~~ (0x24A1,), '24A1 -> 24A1';
ok Uni.new(0x24A2).NFC.list ~~ (0x24A2,), '24A2 -> 24A2';
ok Uni.new(0x24A3).NFC.list ~~ (0x24A3,), '24A3 -> 24A3';
ok Uni.new(0x24A4).NFC.list ~~ (0x24A4,), '24A4 -> 24A4';
ok Uni.new(0x24A5).NFC.list ~~ (0x24A5,), '24A5 -> 24A5';
ok Uni.new(0x24A6).NFC.list ~~ (0x24A6,), '24A6 -> 24A6';
ok Uni.new(0x24A7).NFC.list ~~ (0x24A7,), '24A7 -> 24A7';
ok Uni.new(0x24A8).NFC.list ~~ (0x24A8,), '24A8 -> 24A8';
ok Uni.new(0x24A9).NFC.list ~~ (0x24A9,), '24A9 -> 24A9';
ok Uni.new(0x24AA).NFC.list ~~ (0x24AA,), '24AA -> 24AA';
ok Uni.new(0x24AB).NFC.list ~~ (0x24AB,), '24AB -> 24AB';
ok Uni.new(0x24AC).NFC.list ~~ (0x24AC,), '24AC -> 24AC';
ok Uni.new(0x24AD).NFC.list ~~ (0x24AD,), '24AD -> 24AD';
ok Uni.new(0x24AE).NFC.list ~~ (0x24AE,), '24AE -> 24AE';
ok Uni.new(0x24AF).NFC.list ~~ (0x24AF,), '24AF -> 24AF';
ok Uni.new(0x24B0).NFC.list ~~ (0x24B0,), '24B0 -> 24B0';
ok Uni.new(0x24B1).NFC.list ~~ (0x24B1,), '24B1 -> 24B1';
ok Uni.new(0x24B2).NFC.list ~~ (0x24B2,), '24B2 -> 24B2';
ok Uni.new(0x24B3).NFC.list ~~ (0x24B3,), '24B3 -> 24B3';
ok Uni.new(0x24B4).NFC.list ~~ (0x24B4,), '24B4 -> 24B4';
ok Uni.new(0x24B5).NFC.list ~~ (0x24B5,), '24B5 -> 24B5';
ok Uni.new(0x24B6).NFC.list ~~ (0x24B6,), '24B6 -> 24B6';
ok Uni.new(0x24B7).NFC.list ~~ (0x24B7,), '24B7 -> 24B7';
ok Uni.new(0x24B8).NFC.list ~~ (0x24B8,), '24B8 -> 24B8';
ok Uni.new(0x24B9).NFC.list ~~ (0x24B9,), '24B9 -> 24B9';
ok Uni.new(0x24BA).NFC.list ~~ (0x24BA,), '24BA -> 24BA';
ok Uni.new(0x24BB).NFC.list ~~ (0x24BB,), '24BB -> 24BB';
ok Uni.new(0x24BC).NFC.list ~~ (0x24BC,), '24BC -> 24BC';
ok Uni.new(0x24BD).NFC.list ~~ (0x24BD,), '24BD -> 24BD';
ok Uni.new(0x24BE).NFC.list ~~ (0x24BE,), '24BE -> 24BE';
ok Uni.new(0x24BF).NFC.list ~~ (0x24BF,), '24BF -> 24BF';
ok Uni.new(0x24C0).NFC.list ~~ (0x24C0,), '24C0 -> 24C0';
ok Uni.new(0x24C1).NFC.list ~~ (0x24C1,), '24C1 -> 24C1';
ok Uni.new(0x24C2).NFC.list ~~ (0x24C2,), '24C2 -> 24C2';
ok Uni.new(0x24C3).NFC.list ~~ (0x24C3,), '24C3 -> 24C3';
ok Uni.new(0x24C4).NFC.list ~~ (0x24C4,), '24C4 -> 24C4';
ok Uni.new(0x24C5).NFC.list ~~ (0x24C5,), '24C5 -> 24C5';
ok Uni.new(0x24C6).NFC.list ~~ (0x24C6,), '24C6 -> 24C6';
ok Uni.new(0x24C7).NFC.list ~~ (0x24C7,), '24C7 -> 24C7';
ok Uni.new(0x24C8).NFC.list ~~ (0x24C8,), '24C8 -> 24C8';
ok Uni.new(0x24C9).NFC.list ~~ (0x24C9,), '24C9 -> 24C9';
ok Uni.new(0x24CA).NFC.list ~~ (0x24CA,), '24CA -> 24CA';
ok Uni.new(0x24CB).NFC.list ~~ (0x24CB,), '24CB -> 24CB';
ok Uni.new(0x24CC).NFC.list ~~ (0x24CC,), '24CC -> 24CC';
ok Uni.new(0x24CD).NFC.list ~~ (0x24CD,), '24CD -> 24CD';
ok Uni.new(0x24CE).NFC.list ~~ (0x24CE,), '24CE -> 24CE';
ok Uni.new(0x24CF).NFC.list ~~ (0x24CF,), '24CF -> 24CF';
ok Uni.new(0x24D0).NFC.list ~~ (0x24D0,), '24D0 -> 24D0';
ok Uni.new(0x24D1).NFC.list ~~ (0x24D1,), '24D1 -> 24D1';
ok Uni.new(0x24D2).NFC.list ~~ (0x24D2,), '24D2 -> 24D2';
ok Uni.new(0x24D3).NFC.list ~~ (0x24D3,), '24D3 -> 24D3';
ok Uni.new(0x24D4).NFC.list ~~ (0x24D4,), '24D4 -> 24D4';
ok Uni.new(0x24D5).NFC.list ~~ (0x24D5,), '24D5 -> 24D5';
ok Uni.new(0x24D6).NFC.list ~~ (0x24D6,), '24D6 -> 24D6';
ok Uni.new(0x24D7).NFC.list ~~ (0x24D7,), '24D7 -> 24D7';
ok Uni.new(0x24D8).NFC.list ~~ (0x24D8,), '24D8 -> 24D8';
ok Uni.new(0x24D9).NFC.list ~~ (0x24D9,), '24D9 -> 24D9';
ok Uni.new(0x24DA).NFC.list ~~ (0x24DA,), '24DA -> 24DA';
ok Uni.new(0x24DB).NFC.list ~~ (0x24DB,), '24DB -> 24DB';
ok Uni.new(0x24DC).NFC.list ~~ (0x24DC,), '24DC -> 24DC';
ok Uni.new(0x24DD).NFC.list ~~ (0x24DD,), '24DD -> 24DD';
ok Uni.new(0x24DE).NFC.list ~~ (0x24DE,), '24DE -> 24DE';
ok Uni.new(0x24DF).NFC.list ~~ (0x24DF,), '24DF -> 24DF';
ok Uni.new(0x24E0).NFC.list ~~ (0x24E0,), '24E0 -> 24E0';
ok Uni.new(0x24E1).NFC.list ~~ (0x24E1,), '24E1 -> 24E1';
ok Uni.new(0x24E2).NFC.list ~~ (0x24E2,), '24E2 -> 24E2';
ok Uni.new(0x24E3).NFC.list ~~ (0x24E3,), '24E3 -> 24E3';
ok Uni.new(0x24E4).NFC.list ~~ (0x24E4,), '24E4 -> 24E4';
ok Uni.new(0x24E5).NFC.list ~~ (0x24E5,), '24E5 -> 24E5';
ok Uni.new(0x24E6).NFC.list ~~ (0x24E6,), '24E6 -> 24E6';
ok Uni.new(0x24E7).NFC.list ~~ (0x24E7,), '24E7 -> 24E7';
ok Uni.new(0x24E8).NFC.list ~~ (0x24E8,), '24E8 -> 24E8';
ok Uni.new(0x24E9).NFC.list ~~ (0x24E9,), '24E9 -> 24E9';
ok Uni.new(0x24EA).NFC.list ~~ (0x24EA,), '24EA -> 24EA';
ok Uni.new(0x2A0C).NFC.list ~~ (0x2A0C,), '2A0C -> 2A0C';
ok Uni.new(0x2A74).NFC.list ~~ (0x2A74,), '2A74 -> 2A74';
ok Uni.new(0x2A75).NFC.list ~~ (0x2A75,), '2A75 -> 2A75';
ok Uni.new(0x2A76).NFC.list ~~ (0x2A76,), '2A76 -> 2A76';
ok Uni.new(0x2ADC).NFC.list ~~ (0x2ADD, 0x0338,), '2ADC -> 2ADD 0338';
ok Uni.new(0x2C7C).NFC.list ~~ (0x2C7C,), '2C7C -> 2C7C';
ok Uni.new(0x2C7D).NFC.list ~~ (0x2C7D,), '2C7D -> 2C7D';
ok Uni.new(0x2D6F).NFC.list ~~ (0x2D6F,), '2D6F -> 2D6F';
ok Uni.new(0x2E9F).NFC.list ~~ (0x2E9F,), '2E9F -> 2E9F';
ok Uni.new(0x2EF3).NFC.list ~~ (0x2EF3,), '2EF3 -> 2EF3';
ok Uni.new(0x2F00).NFC.list ~~ (0x2F00,), '2F00 -> 2F00';
ok Uni.new(0x2F01).NFC.list ~~ (0x2F01,), '2F01 -> 2F01';
ok Uni.new(0x2F02).NFC.list ~~ (0x2F02,), '2F02 -> 2F02';
ok Uni.new(0x2F03).NFC.list ~~ (0x2F03,), '2F03 -> 2F03';
ok Uni.new(0x2F04).NFC.list ~~ (0x2F04,), '2F04 -> 2F04';
ok Uni.new(0x2F05).NFC.list ~~ (0x2F05,), '2F05 -> 2F05';
ok Uni.new(0x2F06).NFC.list ~~ (0x2F06,), '2F06 -> 2F06';
ok Uni.new(0x2F07).NFC.list ~~ (0x2F07,), '2F07 -> 2F07';
ok Uni.new(0x2F08).NFC.list ~~ (0x2F08,), '2F08 -> 2F08';
ok Uni.new(0x2F09).NFC.list ~~ (0x2F09,), '2F09 -> 2F09';
ok Uni.new(0x2F0A).NFC.list ~~ (0x2F0A,), '2F0A -> 2F0A';
ok Uni.new(0x2F0B).NFC.list ~~ (0x2F0B,), '2F0B -> 2F0B';
ok Uni.new(0x2F0C).NFC.list ~~ (0x2F0C,), '2F0C -> 2F0C';
ok Uni.new(0x2F0D).NFC.list ~~ (0x2F0D,), '2F0D -> 2F0D';
ok Uni.new(0x2F0E).NFC.list ~~ (0x2F0E,), '2F0E -> 2F0E';
ok Uni.new(0x2F0F).NFC.list ~~ (0x2F0F,), '2F0F -> 2F0F';
ok Uni.new(0x2F10).NFC.list ~~ (0x2F10,), '2F10 -> 2F10';
ok Uni.new(0x2F11).NFC.list ~~ (0x2F11,), '2F11 -> 2F11';
ok Uni.new(0x2F12).NFC.list ~~ (0x2F12,), '2F12 -> 2F12';
ok Uni.new(0x2F13).NFC.list ~~ (0x2F13,), '2F13 -> 2F13';
ok Uni.new(0x2F14).NFC.list ~~ (0x2F14,), '2F14 -> 2F14';
ok Uni.new(0x2F15).NFC.list ~~ (0x2F15,), '2F15 -> 2F15';
ok Uni.new(0x2F16).NFC.list ~~ (0x2F16,), '2F16 -> 2F16';
ok Uni.new(0x2F17).NFC.list ~~ (0x2F17,), '2F17 -> 2F17';
ok Uni.new(0x2F18).NFC.list ~~ (0x2F18,), '2F18 -> 2F18';
ok Uni.new(0x2F19).NFC.list ~~ (0x2F19,), '2F19 -> 2F19';
ok Uni.new(0x2F1A).NFC.list ~~ (0x2F1A,), '2F1A -> 2F1A';
ok Uni.new(0x2F1B).NFC.list ~~ (0x2F1B,), '2F1B -> 2F1B';
ok Uni.new(0x2F1C).NFC.list ~~ (0x2F1C,), '2F1C -> 2F1C';
ok Uni.new(0x2F1D).NFC.list ~~ (0x2F1D,), '2F1D -> 2F1D';
ok Uni.new(0x2F1E).NFC.list ~~ (0x2F1E,), '2F1E -> 2F1E';
ok Uni.new(0x2F1F).NFC.list ~~ (0x2F1F,), '2F1F -> 2F1F';
ok Uni.new(0x2F20).NFC.list ~~ (0x2F20,), '2F20 -> 2F20';
ok Uni.new(0x2F21).NFC.list ~~ (0x2F21,), '2F21 -> 2F21';
ok Uni.new(0x2F22).NFC.list ~~ (0x2F22,), '2F22 -> 2F22';
ok Uni.new(0x2F23).NFC.list ~~ (0x2F23,), '2F23 -> 2F23';
ok Uni.new(0x2F24).NFC.list ~~ (0x2F24,), '2F24 -> 2F24';
ok Uni.new(0x2F25).NFC.list ~~ (0x2F25,), '2F25 -> 2F25';
ok Uni.new(0x2F26).NFC.list ~~ (0x2F26,), '2F26 -> 2F26';
ok Uni.new(0x2F27).NFC.list ~~ (0x2F27,), '2F27 -> 2F27';
ok Uni.new(0x2F28).NFC.list ~~ (0x2F28,), '2F28 -> 2F28';
ok Uni.new(0x2F29).NFC.list ~~ (0x2F29,), '2F29 -> 2F29';
ok Uni.new(0x2F2A).NFC.list ~~ (0x2F2A,), '2F2A -> 2F2A';
ok Uni.new(0x2F2B).NFC.list ~~ (0x2F2B,), '2F2B -> 2F2B';
ok Uni.new(0x2F2C).NFC.list ~~ (0x2F2C,), '2F2C -> 2F2C';
ok Uni.new(0x2F2D).NFC.list ~~ (0x2F2D,), '2F2D -> 2F2D';
ok Uni.new(0x2F2E).NFC.list ~~ (0x2F2E,), '2F2E -> 2F2E';
ok Uni.new(0x2F2F).NFC.list ~~ (0x2F2F,), '2F2F -> 2F2F';
ok Uni.new(0x2F30).NFC.list ~~ (0x2F30,), '2F30 -> 2F30';
ok Uni.new(0x2F31).NFC.list ~~ (0x2F31,), '2F31 -> 2F31';
ok Uni.new(0x2F32).NFC.list ~~ (0x2F32,), '2F32 -> 2F32';
ok Uni.new(0x2F33).NFC.list ~~ (0x2F33,), '2F33 -> 2F33';
ok Uni.new(0x2F34).NFC.list ~~ (0x2F34,), '2F34 -> 2F34';
ok Uni.new(0x2F35).NFC.list ~~ (0x2F35,), '2F35 -> 2F35';
ok Uni.new(0x2F36).NFC.list ~~ (0x2F36,), '2F36 -> 2F36';
ok Uni.new(0x2F37).NFC.list ~~ (0x2F37,), '2F37 -> 2F37';
ok Uni.new(0x2F38).NFC.list ~~ (0x2F38,), '2F38 -> 2F38';
ok Uni.new(0x2F39).NFC.list ~~ (0x2F39,), '2F39 -> 2F39';
ok Uni.new(0x2F3A).NFC.list ~~ (0x2F3A,), '2F3A -> 2F3A';
ok Uni.new(0x2F3B).NFC.list ~~ (0x2F3B,), '2F3B -> 2F3B';
ok Uni.new(0x2F3C).NFC.list ~~ (0x2F3C,), '2F3C -> 2F3C';
ok Uni.new(0x2F3D).NFC.list ~~ (0x2F3D,), '2F3D -> 2F3D';
ok Uni.new(0x2F3E).NFC.list ~~ (0x2F3E,), '2F3E -> 2F3E';
ok Uni.new(0x2F3F).NFC.list ~~ (0x2F3F,), '2F3F -> 2F3F';
ok Uni.new(0x2F40).NFC.list ~~ (0x2F40,), '2F40 -> 2F40';
ok Uni.new(0x2F41).NFC.list ~~ (0x2F41,), '2F41 -> 2F41';
ok Uni.new(0x2F42).NFC.list ~~ (0x2F42,), '2F42 -> 2F42';
ok Uni.new(0x2F43).NFC.list ~~ (0x2F43,), '2F43 -> 2F43';
ok Uni.new(0x2F44).NFC.list ~~ (0x2F44,), '2F44 -> 2F44';
ok Uni.new(0x2F45).NFC.list ~~ (0x2F45,), '2F45 -> 2F45';
ok Uni.new(0x2F46).NFC.list ~~ (0x2F46,), '2F46 -> 2F46';
ok Uni.new(0x2F47).NFC.list ~~ (0x2F47,), '2F47 -> 2F47';
ok Uni.new(0x2F48).NFC.list ~~ (0x2F48,), '2F48 -> 2F48';
ok Uni.new(0x2F49).NFC.list ~~ (0x2F49,), '2F49 -> 2F49';
ok Uni.new(0x2F4A).NFC.list ~~ (0x2F4A,), '2F4A -> 2F4A';
ok Uni.new(0x2F4B).NFC.list ~~ (0x2F4B,), '2F4B -> 2F4B';
ok Uni.new(0x2F4C).NFC.list ~~ (0x2F4C,), '2F4C -> 2F4C';
ok Uni.new(0x2F4D).NFC.list ~~ (0x2F4D,), '2F4D -> 2F4D';
ok Uni.new(0x2F4E).NFC.list ~~ (0x2F4E,), '2F4E -> 2F4E';
ok Uni.new(0x2F4F).NFC.list ~~ (0x2F4F,), '2F4F -> 2F4F';
ok Uni.new(0x2F50).NFC.list ~~ (0x2F50,), '2F50 -> 2F50';
ok Uni.new(0x2F51).NFC.list ~~ (0x2F51,), '2F51 -> 2F51';
ok Uni.new(0x2F52).NFC.list ~~ (0x2F52,), '2F52 -> 2F52';
ok Uni.new(0x2F53).NFC.list ~~ (0x2F53,), '2F53 -> 2F53';
ok Uni.new(0x2F54).NFC.list ~~ (0x2F54,), '2F54 -> 2F54';
ok Uni.new(0x2F55).NFC.list ~~ (0x2F55,), '2F55 -> 2F55';
ok Uni.new(0x2F56).NFC.list ~~ (0x2F56,), '2F56 -> 2F56';
ok Uni.new(0x2F57).NFC.list ~~ (0x2F57,), '2F57 -> 2F57';
ok Uni.new(0x2F58).NFC.list ~~ (0x2F58,), '2F58 -> 2F58';
ok Uni.new(0x2F59).NFC.list ~~ (0x2F59,), '2F59 -> 2F59';
ok Uni.new(0x2F5A).NFC.list ~~ (0x2F5A,), '2F5A -> 2F5A';
ok Uni.new(0x2F5B).NFC.list ~~ (0x2F5B,), '2F5B -> 2F5B';
ok Uni.new(0x2F5C).NFC.list ~~ (0x2F5C,), '2F5C -> 2F5C';
ok Uni.new(0x2F5D).NFC.list ~~ (0x2F5D,), '2F5D -> 2F5D';
ok Uni.new(0x2F5E).NFC.list ~~ (0x2F5E,), '2F5E -> 2F5E';
ok Uni.new(0x2F5F).NFC.list ~~ (0x2F5F,), '2F5F -> 2F5F';
ok Uni.new(0x2F60).NFC.list ~~ (0x2F60,), '2F60 -> 2F60';
ok Uni.new(0x2F61).NFC.list ~~ (0x2F61,), '2F61 -> 2F61';
ok Uni.new(0x2F62).NFC.list ~~ (0x2F62,), '2F62 -> 2F62';
ok Uni.new(0x2F63).NFC.list ~~ (0x2F63,), '2F63 -> 2F63';
ok Uni.new(0x2F64).NFC.list ~~ (0x2F64,), '2F64 -> 2F64';
ok Uni.new(0x2F65).NFC.list ~~ (0x2F65,), '2F65 -> 2F65';
ok Uni.new(0x2F66).NFC.list ~~ (0x2F66,), '2F66 -> 2F66';
ok Uni.new(0x2F67).NFC.list ~~ (0x2F67,), '2F67 -> 2F67';
ok Uni.new(0x2F68).NFC.list ~~ (0x2F68,), '2F68 -> 2F68';
ok Uni.new(0x2F69).NFC.list ~~ (0x2F69,), '2F69 -> 2F69';
ok Uni.new(0x2F6A).NFC.list ~~ (0x2F6A,), '2F6A -> 2F6A';
ok Uni.new(0x2F6B).NFC.list ~~ (0x2F6B,), '2F6B -> 2F6B';
ok Uni.new(0x2F6C).NFC.list ~~ (0x2F6C,), '2F6C -> 2F6C';
ok Uni.new(0x2F6D).NFC.list ~~ (0x2F6D,), '2F6D -> 2F6D';
ok Uni.new(0x2F6E).NFC.list ~~ (0x2F6E,), '2F6E -> 2F6E';
ok Uni.new(0x2F6F).NFC.list ~~ (0x2F6F,), '2F6F -> 2F6F';
ok Uni.new(0x2F70).NFC.list ~~ (0x2F70,), '2F70 -> 2F70';
ok Uni.new(0x2F71).NFC.list ~~ (0x2F71,), '2F71 -> 2F71';
ok Uni.new(0x2F72).NFC.list ~~ (0x2F72,), '2F72 -> 2F72';
ok Uni.new(0x2F73).NFC.list ~~ (0x2F73,), '2F73 -> 2F73';
ok Uni.new(0x2F74).NFC.list ~~ (0x2F74,), '2F74 -> 2F74';
ok Uni.new(0x2F75).NFC.list ~~ (0x2F75,), '2F75 -> 2F75';
ok Uni.new(0x2F76).NFC.list ~~ (0x2F76,), '2F76 -> 2F76';
ok Uni.new(0x2F77).NFC.list ~~ (0x2F77,), '2F77 -> 2F77';
ok Uni.new(0x2F78).NFC.list ~~ (0x2F78,), '2F78 -> 2F78';
ok Uni.new(0x2F79).NFC.list ~~ (0x2F79,), '2F79 -> 2F79';
ok Uni.new(0x2F7A).NFC.list ~~ (0x2F7A,), '2F7A -> 2F7A';
ok Uni.new(0x2F7B).NFC.list ~~ (0x2F7B,), '2F7B -> 2F7B';
ok Uni.new(0x2F7C).NFC.list ~~ (0x2F7C,), '2F7C -> 2F7C';
ok Uni.new(0x2F7D).NFC.list ~~ (0x2F7D,), '2F7D -> 2F7D';
ok Uni.new(0x2F7E).NFC.list ~~ (0x2F7E,), '2F7E -> 2F7E';
ok Uni.new(0x2F7F).NFC.list ~~ (0x2F7F,), '2F7F -> 2F7F';
ok Uni.new(0x2F80).NFC.list ~~ (0x2F80,), '2F80 -> 2F80';
ok Uni.new(0x2F81).NFC.list ~~ (0x2F81,), '2F81 -> 2F81';
ok Uni.new(0x2F82).NFC.list ~~ (0x2F82,), '2F82 -> 2F82';
ok Uni.new(0x2F83).NFC.list ~~ (0x2F83,), '2F83 -> 2F83';
ok Uni.new(0x2F84).NFC.list ~~ (0x2F84,), '2F84 -> 2F84';
ok Uni.new(0x2F85).NFC.list ~~ (0x2F85,), '2F85 -> 2F85';
ok Uni.new(0x2F86).NFC.list ~~ (0x2F86,), '2F86 -> 2F86';
ok Uni.new(0x2F87).NFC.list ~~ (0x2F87,), '2F87 -> 2F87';
ok Uni.new(0x2F88).NFC.list ~~ (0x2F88,), '2F88 -> 2F88';
ok Uni.new(0x2F89).NFC.list ~~ (0x2F89,), '2F89 -> 2F89';
ok Uni.new(0x2F8A).NFC.list ~~ (0x2F8A,), '2F8A -> 2F8A';
ok Uni.new(0x2F8B).NFC.list ~~ (0x2F8B,), '2F8B -> 2F8B';
ok Uni.new(0x2F8C).NFC.list ~~ (0x2F8C,), '2F8C -> 2F8C';
ok Uni.new(0x2F8D).NFC.list ~~ (0x2F8D,), '2F8D -> 2F8D';
ok Uni.new(0x2F8E).NFC.list ~~ (0x2F8E,), '2F8E -> 2F8E';
ok Uni.new(0x2F8F).NFC.list ~~ (0x2F8F,), '2F8F -> 2F8F';
ok Uni.new(0x2F90).NFC.list ~~ (0x2F90,), '2F90 -> 2F90';
ok Uni.new(0x2F91).NFC.list ~~ (0x2F91,), '2F91 -> 2F91';
ok Uni.new(0x2F92).NFC.list ~~ (0x2F92,), '2F92 -> 2F92';
ok Uni.new(0x2F93).NFC.list ~~ (0x2F93,), '2F93 -> 2F93';
ok Uni.new(0x2F94).NFC.list ~~ (0x2F94,), '2F94 -> 2F94';
ok Uni.new(0x2F95).NFC.list ~~ (0x2F95,), '2F95 -> 2F95';
ok Uni.new(0x2F96).NFC.list ~~ (0x2F96,), '2F96 -> 2F96';
ok Uni.new(0x2F97).NFC.list ~~ (0x2F97,), '2F97 -> 2F97';
ok Uni.new(0x2F98).NFC.list ~~ (0x2F98,), '2F98 -> 2F98';
ok Uni.new(0x2F99).NFC.list ~~ (0x2F99,), '2F99 -> 2F99';
ok Uni.new(0x2F9A).NFC.list ~~ (0x2F9A,), '2F9A -> 2F9A';
ok Uni.new(0x2F9B).NFC.list ~~ (0x2F9B,), '2F9B -> 2F9B';
ok Uni.new(0x2F9C).NFC.list ~~ (0x2F9C,), '2F9C -> 2F9C';
ok Uni.new(0x2F9D).NFC.list ~~ (0x2F9D,), '2F9D -> 2F9D';
ok Uni.new(0x2F9E).NFC.list ~~ (0x2F9E,), '2F9E -> 2F9E';
ok Uni.new(0x2F9F).NFC.list ~~ (0x2F9F,), '2F9F -> 2F9F';
ok Uni.new(0x2FA0).NFC.list ~~ (0x2FA0,), '2FA0 -> 2FA0';
ok Uni.new(0x2FA1).NFC.list ~~ (0x2FA1,), '2FA1 -> 2FA1';
ok Uni.new(0x2FA2).NFC.list ~~ (0x2FA2,), '2FA2 -> 2FA2';
ok Uni.new(0x2FA3).NFC.list ~~ (0x2FA3,), '2FA3 -> 2FA3';
ok Uni.new(0x2FA4).NFC.list ~~ (0x2FA4,), '2FA4 -> 2FA4';
ok Uni.new(0x2FA5).NFC.list ~~ (0x2FA5,), '2FA5 -> 2FA5';
ok Uni.new(0x2FA6).NFC.list ~~ (0x2FA6,), '2FA6 -> 2FA6';
ok Uni.new(0x2FA7).NFC.list ~~ (0x2FA7,), '2FA7 -> 2FA7';
ok Uni.new(0x2FA8).NFC.list ~~ (0x2FA8,), '2FA8 -> 2FA8';
ok Uni.new(0x2FA9).NFC.list ~~ (0x2FA9,), '2FA9 -> 2FA9';
ok Uni.new(0x2FAA).NFC.list ~~ (0x2FAA,), '2FAA -> 2FAA';
ok Uni.new(0x2FAB).NFC.list ~~ (0x2FAB,), '2FAB -> 2FAB';
ok Uni.new(0x2FAC).NFC.list ~~ (0x2FAC,), '2FAC -> 2FAC';
ok Uni.new(0x2FAD).NFC.list ~~ (0x2FAD,), '2FAD -> 2FAD';
ok Uni.new(0x2FAE).NFC.list ~~ (0x2FAE,), '2FAE -> 2FAE';
ok Uni.new(0x2FAF).NFC.list ~~ (0x2FAF,), '2FAF -> 2FAF';
ok Uni.new(0x2FB0).NFC.list ~~ (0x2FB0,), '2FB0 -> 2FB0';
ok Uni.new(0x2FB1).NFC.list ~~ (0x2FB1,), '2FB1 -> 2FB1';
ok Uni.new(0x2FB2).NFC.list ~~ (0x2FB2,), '2FB2 -> 2FB2';
ok Uni.new(0x2FB3).NFC.list ~~ (0x2FB3,), '2FB3 -> 2FB3';
ok Uni.new(0x2FB4).NFC.list ~~ (0x2FB4,), '2FB4 -> 2FB4';
ok Uni.new(0x2FB5).NFC.list ~~ (0x2FB5,), '2FB5 -> 2FB5';
ok Uni.new(0x2FB6).NFC.list ~~ (0x2FB6,), '2FB6 -> 2FB6';
ok Uni.new(0x2FB7).NFC.list ~~ (0x2FB7,), '2FB7 -> 2FB7';
ok Uni.new(0x2FB8).NFC.list ~~ (0x2FB8,), '2FB8 -> 2FB8';
ok Uni.new(0x2FB9).NFC.list ~~ (0x2FB9,), '2FB9 -> 2FB9';
ok Uni.new(0x2FBA).NFC.list ~~ (0x2FBA,), '2FBA -> 2FBA';
ok Uni.new(0x2FBB).NFC.list ~~ (0x2FBB,), '2FBB -> 2FBB';
ok Uni.new(0x2FBC).NFC.list ~~ (0x2FBC,), '2FBC -> 2FBC';
ok Uni.new(0x2FBD).NFC.list ~~ (0x2FBD,), '2FBD -> 2FBD';
ok Uni.new(0x2FBE).NFC.list ~~ (0x2FBE,), '2FBE -> 2FBE';
ok Uni.new(0x2FBF).NFC.list ~~ (0x2FBF,), '2FBF -> 2FBF';
ok Uni.new(0x2FC0).NFC.list ~~ (0x2FC0,), '2FC0 -> 2FC0';
ok Uni.new(0x2FC1).NFC.list ~~ (0x2FC1,), '2FC1 -> 2FC1';
ok Uni.new(0x2FC2).NFC.list ~~ (0x2FC2,), '2FC2 -> 2FC2';
ok Uni.new(0x2FC3).NFC.list ~~ (0x2FC3,), '2FC3 -> 2FC3';
ok Uni.new(0x2FC4).NFC.list ~~ (0x2FC4,), '2FC4 -> 2FC4';
ok Uni.new(0x2FC5).NFC.list ~~ (0x2FC5,), '2FC5 -> 2FC5';
ok Uni.new(0x2FC6).NFC.list ~~ (0x2FC6,), '2FC6 -> 2FC6';
ok Uni.new(0x2FC7).NFC.list ~~ (0x2FC7,), '2FC7 -> 2FC7';
ok Uni.new(0x2FC8).NFC.list ~~ (0x2FC8,), '2FC8 -> 2FC8';
ok Uni.new(0x2FC9).NFC.list ~~ (0x2FC9,), '2FC9 -> 2FC9';
ok Uni.new(0x2FCA).NFC.list ~~ (0x2FCA,), '2FCA -> 2FCA';
ok Uni.new(0x2FCB).NFC.list ~~ (0x2FCB,), '2FCB -> 2FCB';
ok Uni.new(0x2FCC).NFC.list ~~ (0x2FCC,), '2FCC -> 2FCC';
ok Uni.new(0x2FCD).NFC.list ~~ (0x2FCD,), '2FCD -> 2FCD';
ok Uni.new(0x2FCE).NFC.list ~~ (0x2FCE,), '2FCE -> 2FCE';
ok Uni.new(0x2FCF).NFC.list ~~ (0x2FCF,), '2FCF -> 2FCF';
ok Uni.new(0x2FD0).NFC.list ~~ (0x2FD0,), '2FD0 -> 2FD0';
ok Uni.new(0x2FD1).NFC.list ~~ (0x2FD1,), '2FD1 -> 2FD1';
ok Uni.new(0x2FD2).NFC.list ~~ (0x2FD2,), '2FD2 -> 2FD2';
ok Uni.new(0x2FD3).NFC.list ~~ (0x2FD3,), '2FD3 -> 2FD3';
ok Uni.new(0x2FD4).NFC.list ~~ (0x2FD4,), '2FD4 -> 2FD4';
ok Uni.new(0x2FD5).NFC.list ~~ (0x2FD5,), '2FD5 -> 2FD5';
ok Uni.new(0x3000).NFC.list ~~ (0x3000,), '3000 -> 3000';
ok Uni.new(0x3036).NFC.list ~~ (0x3036,), '3036 -> 3036';
ok Uni.new(0x3038).NFC.list ~~ (0x3038,), '3038 -> 3038';
ok Uni.new(0x3039).NFC.list ~~ (0x3039,), '3039 -> 3039';
ok Uni.new(0x303A).NFC.list ~~ (0x303A,), '303A -> 303A';
ok Uni.new(0x304C).NFC.list ~~ (0x304C,), '304C -> 304C';
ok Uni.new(0x304E).NFC.list ~~ (0x304E,), '304E -> 304E';
ok Uni.new(0x3050).NFC.list ~~ (0x3050,), '3050 -> 3050';
ok Uni.new(0x3052).NFC.list ~~ (0x3052,), '3052 -> 3052';
ok Uni.new(0x3054).NFC.list ~~ (0x3054,), '3054 -> 3054';
ok Uni.new(0x3056).NFC.list ~~ (0x3056,), '3056 -> 3056';
ok Uni.new(0x3058).NFC.list ~~ (0x3058,), '3058 -> 3058';
ok Uni.new(0x305A).NFC.list ~~ (0x305A,), '305A -> 305A';
ok Uni.new(0x305C).NFC.list ~~ (0x305C,), '305C -> 305C';
ok Uni.new(0x305E).NFC.list ~~ (0x305E,), '305E -> 305E';
ok Uni.new(0x3060).NFC.list ~~ (0x3060,), '3060 -> 3060';
ok Uni.new(0x3062).NFC.list ~~ (0x3062,), '3062 -> 3062';
ok Uni.new(0x3065).NFC.list ~~ (0x3065,), '3065 -> 3065';
ok Uni.new(0x3067).NFC.list ~~ (0x3067,), '3067 -> 3067';
ok Uni.new(0x3069).NFC.list ~~ (0x3069,), '3069 -> 3069';
ok Uni.new(0x3070).NFC.list ~~ (0x3070,), '3070 -> 3070';
ok Uni.new(0x3071).NFC.list ~~ (0x3071,), '3071 -> 3071';
ok Uni.new(0x3073).NFC.list ~~ (0x3073,), '3073 -> 3073';
ok Uni.new(0x3074).NFC.list ~~ (0x3074,), '3074 -> 3074';
ok Uni.new(0x3076).NFC.list ~~ (0x3076,), '3076 -> 3076';
ok Uni.new(0x3077).NFC.list ~~ (0x3077,), '3077 -> 3077';
ok Uni.new(0x3079).NFC.list ~~ (0x3079,), '3079 -> 3079';
ok Uni.new(0x307A).NFC.list ~~ (0x307A,), '307A -> 307A';
ok Uni.new(0x307C).NFC.list ~~ (0x307C,), '307C -> 307C';
ok Uni.new(0x307D).NFC.list ~~ (0x307D,), '307D -> 307D';
ok Uni.new(0x3094).NFC.list ~~ (0x3094,), '3094 -> 3094';
ok Uni.new(0x309B).NFC.list ~~ (0x309B,), '309B -> 309B';
ok Uni.new(0x309C).NFC.list ~~ (0x309C,), '309C -> 309C';
ok Uni.new(0x309E).NFC.list ~~ (0x309E,), '309E -> 309E';
ok Uni.new(0x309F).NFC.list ~~ (0x309F,), '309F -> 309F';
ok Uni.new(0x30AC).NFC.list ~~ (0x30AC,), '30AC -> 30AC';
ok Uni.new(0x30AE).NFC.list ~~ (0x30AE,), '30AE -> 30AE';
ok Uni.new(0x30B0).NFC.list ~~ (0x30B0,), '30B0 -> 30B0';
ok Uni.new(0x30B2).NFC.list ~~ (0x30B2,), '30B2 -> 30B2';
ok Uni.new(0x30B4).NFC.list ~~ (0x30B4,), '30B4 -> 30B4';
ok Uni.new(0x30B6).NFC.list ~~ (0x30B6,), '30B6 -> 30B6';
ok Uni.new(0x30B8).NFC.list ~~ (0x30B8,), '30B8 -> 30B8';
ok Uni.new(0x30BA).NFC.list ~~ (0x30BA,), '30BA -> 30BA';
ok Uni.new(0x30BC).NFC.list ~~ (0x30BC,), '30BC -> 30BC';
ok Uni.new(0x30BE).NFC.list ~~ (0x30BE,), '30BE -> 30BE';
ok Uni.new(0x30C0).NFC.list ~~ (0x30C0,), '30C0 -> 30C0';
ok Uni.new(0x30C2).NFC.list ~~ (0x30C2,), '30C2 -> 30C2';
ok Uni.new(0x30C5).NFC.list ~~ (0x30C5,), '30C5 -> 30C5';
ok Uni.new(0x30C7).NFC.list ~~ (0x30C7,), '30C7 -> 30C7';
ok Uni.new(0x30C9).NFC.list ~~ (0x30C9,), '30C9 -> 30C9';
ok Uni.new(0x30D0).NFC.list ~~ (0x30D0,), '30D0 -> 30D0';
ok Uni.new(0x30D1).NFC.list ~~ (0x30D1,), '30D1 -> 30D1';
ok Uni.new(0x30D3).NFC.list ~~ (0x30D3,), '30D3 -> 30D3';
ok Uni.new(0x30D4).NFC.list ~~ (0x30D4,), '30D4 -> 30D4';
ok Uni.new(0x30D6).NFC.list ~~ (0x30D6,), '30D6 -> 30D6';
ok Uni.new(0x30D7).NFC.list ~~ (0x30D7,), '30D7 -> 30D7';
ok Uni.new(0x30D9).NFC.list ~~ (0x30D9,), '30D9 -> 30D9';
ok Uni.new(0x30DA).NFC.list ~~ (0x30DA,), '30DA -> 30DA';
ok Uni.new(0x30DC).NFC.list ~~ (0x30DC,), '30DC -> 30DC';
ok Uni.new(0x30DD).NFC.list ~~ (0x30DD,), '30DD -> 30DD';
ok Uni.new(0x30F4).NFC.list ~~ (0x30F4,), '30F4 -> 30F4';
ok Uni.new(0x30F7).NFC.list ~~ (0x30F7,), '30F7 -> 30F7';
ok Uni.new(0x30F8).NFC.list ~~ (0x30F8,), '30F8 -> 30F8';
ok Uni.new(0x30F9).NFC.list ~~ (0x30F9,), '30F9 -> 30F9';
ok Uni.new(0x30FA).NFC.list ~~ (0x30FA,), '30FA -> 30FA';
ok Uni.new(0x30FE).NFC.list ~~ (0x30FE,), '30FE -> 30FE';
ok Uni.new(0x30FF).NFC.list ~~ (0x30FF,), '30FF -> 30FF';
ok Uni.new(0x3131).NFC.list ~~ (0x3131,), '3131 -> 3131';
ok Uni.new(0x3132).NFC.list ~~ (0x3132,), '3132 -> 3132';
ok Uni.new(0x3133).NFC.list ~~ (0x3133,), '3133 -> 3133';
ok Uni.new(0x3134).NFC.list ~~ (0x3134,), '3134 -> 3134';
ok Uni.new(0x3135).NFC.list ~~ (0x3135,), '3135 -> 3135';
ok Uni.new(0x3136).NFC.list ~~ (0x3136,), '3136 -> 3136';
ok Uni.new(0x3137).NFC.list ~~ (0x3137,), '3137 -> 3137';
ok Uni.new(0x3138).NFC.list ~~ (0x3138,), '3138 -> 3138';
ok Uni.new(0x3139).NFC.list ~~ (0x3139,), '3139 -> 3139';
ok Uni.new(0x313A).NFC.list ~~ (0x313A,), '313A -> 313A';
ok Uni.new(0x313B).NFC.list ~~ (0x313B,), '313B -> 313B';
ok Uni.new(0x313C).NFC.list ~~ (0x313C,), '313C -> 313C';
ok Uni.new(0x313D).NFC.list ~~ (0x313D,), '313D -> 313D';
ok Uni.new(0x313E).NFC.list ~~ (0x313E,), '313E -> 313E';
ok Uni.new(0x313F).NFC.list ~~ (0x313F,), '313F -> 313F';
ok Uni.new(0x3140).NFC.list ~~ (0x3140,), '3140 -> 3140';
ok Uni.new(0x3141).NFC.list ~~ (0x3141,), '3141 -> 3141';
ok Uni.new(0x3142).NFC.list ~~ (0x3142,), '3142 -> 3142';
ok Uni.new(0x3143).NFC.list ~~ (0x3143,), '3143 -> 3143';
ok Uni.new(0x3144).NFC.list ~~ (0x3144,), '3144 -> 3144';
ok Uni.new(0x3145).NFC.list ~~ (0x3145,), '3145 -> 3145';
ok Uni.new(0x3146).NFC.list ~~ (0x3146,), '3146 -> 3146';
ok Uni.new(0x3147).NFC.list ~~ (0x3147,), '3147 -> 3147';
ok Uni.new(0x3148).NFC.list ~~ (0x3148,), '3148 -> 3148';
ok Uni.new(0x3149).NFC.list ~~ (0x3149,), '3149 -> 3149';
ok Uni.new(0x314A).NFC.list ~~ (0x314A,), '314A -> 314A';
ok Uni.new(0x314B).NFC.list ~~ (0x314B,), '314B -> 314B';
ok Uni.new(0x314C).NFC.list ~~ (0x314C,), '314C -> 314C';
ok Uni.new(0x314D).NFC.list ~~ (0x314D,), '314D -> 314D';
ok Uni.new(0x314E).NFC.list ~~ (0x314E,), '314E -> 314E';
ok Uni.new(0x314F).NFC.list ~~ (0x314F,), '314F -> 314F';
ok Uni.new(0x3150).NFC.list ~~ (0x3150,), '3150 -> 3150';
ok Uni.new(0x3151).NFC.list ~~ (0x3151,), '3151 -> 3151';
ok Uni.new(0x3152).NFC.list ~~ (0x3152,), '3152 -> 3152';
ok Uni.new(0x3153).NFC.list ~~ (0x3153,), '3153 -> 3153';
ok Uni.new(0x3154).NFC.list ~~ (0x3154,), '3154 -> 3154';
ok Uni.new(0x3155).NFC.list ~~ (0x3155,), '3155 -> 3155';
ok Uni.new(0x3156).NFC.list ~~ (0x3156,), '3156 -> 3156';
ok Uni.new(0x3157).NFC.list ~~ (0x3157,), '3157 -> 3157';
ok Uni.new(0x3158).NFC.list ~~ (0x3158,), '3158 -> 3158';
ok Uni.new(0x3159).NFC.list ~~ (0x3159,), '3159 -> 3159';
ok Uni.new(0x315A).NFC.list ~~ (0x315A,), '315A -> 315A';
ok Uni.new(0x315B).NFC.list ~~ (0x315B,), '315B -> 315B';
ok Uni.new(0x315C).NFC.list ~~ (0x315C,), '315C -> 315C';
ok Uni.new(0x315D).NFC.list ~~ (0x315D,), '315D -> 315D';
ok Uni.new(0x315E).NFC.list ~~ (0x315E,), '315E -> 315E';
ok Uni.new(0x315F).NFC.list ~~ (0x315F,), '315F -> 315F';
ok Uni.new(0x3160).NFC.list ~~ (0x3160,), '3160 -> 3160';
ok Uni.new(0x3161).NFC.list ~~ (0x3161,), '3161 -> 3161';
ok Uni.new(0x3162).NFC.list ~~ (0x3162,), '3162 -> 3162';
ok Uni.new(0x3163).NFC.list ~~ (0x3163,), '3163 -> 3163';
ok Uni.new(0x3164).NFC.list ~~ (0x3164,), '3164 -> 3164';
ok Uni.new(0x3165).NFC.list ~~ (0x3165,), '3165 -> 3165';
ok Uni.new(0x3166).NFC.list ~~ (0x3166,), '3166 -> 3166';
ok Uni.new(0x3167).NFC.list ~~ (0x3167,), '3167 -> 3167';
ok Uni.new(0x3168).NFC.list ~~ (0x3168,), '3168 -> 3168';
ok Uni.new(0x3169).NFC.list ~~ (0x3169,), '3169 -> 3169';
ok Uni.new(0x316A).NFC.list ~~ (0x316A,), '316A -> 316A';
ok Uni.new(0x316B).NFC.list ~~ (0x316B,), '316B -> 316B';
ok Uni.new(0x316C).NFC.list ~~ (0x316C,), '316C -> 316C';
ok Uni.new(0x316D).NFC.list ~~ (0x316D,), '316D -> 316D';
ok Uni.new(0x316E).NFC.list ~~ (0x316E,), '316E -> 316E';
ok Uni.new(0x316F).NFC.list ~~ (0x316F,), '316F -> 316F';
ok Uni.new(0x3170).NFC.list ~~ (0x3170,), '3170 -> 3170';
ok Uni.new(0x3171).NFC.list ~~ (0x3171,), '3171 -> 3171';
ok Uni.new(0x3172).NFC.list ~~ (0x3172,), '3172 -> 3172';
ok Uni.new(0x3173).NFC.list ~~ (0x3173,), '3173 -> 3173';
ok Uni.new(0x3174).NFC.list ~~ (0x3174,), '3174 -> 3174';
ok Uni.new(0x3175).NFC.list ~~ (0x3175,), '3175 -> 3175';
ok Uni.new(0x3176).NFC.list ~~ (0x3176,), '3176 -> 3176';
ok Uni.new(0x3177).NFC.list ~~ (0x3177,), '3177 -> 3177';
ok Uni.new(0x3178).NFC.list ~~ (0x3178,), '3178 -> 3178';
ok Uni.new(0x3179).NFC.list ~~ (0x3179,), '3179 -> 3179';
ok Uni.new(0x317A).NFC.list ~~ (0x317A,), '317A -> 317A';
ok Uni.new(0x317B).NFC.list ~~ (0x317B,), '317B -> 317B';
ok Uni.new(0x317C).NFC.list ~~ (0x317C,), '317C -> 317C';
ok Uni.new(0x317D).NFC.list ~~ (0x317D,), '317D -> 317D';
ok Uni.new(0x317E).NFC.list ~~ (0x317E,), '317E -> 317E';
ok Uni.new(0x317F).NFC.list ~~ (0x317F,), '317F -> 317F';
ok Uni.new(0x3180).NFC.list ~~ (0x3180,), '3180 -> 3180';
ok Uni.new(0x3181).NFC.list ~~ (0x3181,), '3181 -> 3181';
ok Uni.new(0x3182).NFC.list ~~ (0x3182,), '3182 -> 3182';
ok Uni.new(0x3183).NFC.list ~~ (0x3183,), '3183 -> 3183';
ok Uni.new(0x3184).NFC.list ~~ (0x3184,), '3184 -> 3184';
ok Uni.new(0x3185).NFC.list ~~ (0x3185,), '3185 -> 3185';
ok Uni.new(0x3186).NFC.list ~~ (0x3186,), '3186 -> 3186';
ok Uni.new(0x3187).NFC.list ~~ (0x3187,), '3187 -> 3187';
ok Uni.new(0x3188).NFC.list ~~ (0x3188,), '3188 -> 3188';
ok Uni.new(0x3189).NFC.list ~~ (0x3189,), '3189 -> 3189';
ok Uni.new(0x318A).NFC.list ~~ (0x318A,), '318A -> 318A';
ok Uni.new(0x318B).NFC.list ~~ (0x318B,), '318B -> 318B';
ok Uni.new(0x318C).NFC.list ~~ (0x318C,), '318C -> 318C';
ok Uni.new(0x318D).NFC.list ~~ (0x318D,), '318D -> 318D';
ok Uni.new(0x318E).NFC.list ~~ (0x318E,), '318E -> 318E';
ok Uni.new(0x3192).NFC.list ~~ (0x3192,), '3192 -> 3192';
ok Uni.new(0x3193).NFC.list ~~ (0x3193,), '3193 -> 3193';
ok Uni.new(0x3194).NFC.list ~~ (0x3194,), '3194 -> 3194';
ok Uni.new(0x3195).NFC.list ~~ (0x3195,), '3195 -> 3195';
ok Uni.new(0x3196).NFC.list ~~ (0x3196,), '3196 -> 3196';
ok Uni.new(0x3197).NFC.list ~~ (0x3197,), '3197 -> 3197';
ok Uni.new(0x3198).NFC.list ~~ (0x3198,), '3198 -> 3198';
ok Uni.new(0x3199).NFC.list ~~ (0x3199,), '3199 -> 3199';
ok Uni.new(0x319A).NFC.list ~~ (0x319A,), '319A -> 319A';
ok Uni.new(0x319B).NFC.list ~~ (0x319B,), '319B -> 319B';
ok Uni.new(0x319C).NFC.list ~~ (0x319C,), '319C -> 319C';
ok Uni.new(0x319D).NFC.list ~~ (0x319D,), '319D -> 319D';
ok Uni.new(0x319E).NFC.list ~~ (0x319E,), '319E -> 319E';
ok Uni.new(0x319F).NFC.list ~~ (0x319F,), '319F -> 319F';
ok Uni.new(0x3200).NFC.list ~~ (0x3200,), '3200 -> 3200';
ok Uni.new(0x3201).NFC.list ~~ (0x3201,), '3201 -> 3201';
ok Uni.new(0x3202).NFC.list ~~ (0x3202,), '3202 -> 3202';
ok Uni.new(0x3203).NFC.list ~~ (0x3203,), '3203 -> 3203';
ok Uni.new(0x3204).NFC.list ~~ (0x3204,), '3204 -> 3204';
ok Uni.new(0x3205).NFC.list ~~ (0x3205,), '3205 -> 3205';
ok Uni.new(0x3206).NFC.list ~~ (0x3206,), '3206 -> 3206';
ok Uni.new(0x3207).NFC.list ~~ (0x3207,), '3207 -> 3207';
ok Uni.new(0x3208).NFC.list ~~ (0x3208,), '3208 -> 3208';
ok Uni.new(0x3209).NFC.list ~~ (0x3209,), '3209 -> 3209';
ok Uni.new(0x320A).NFC.list ~~ (0x320A,), '320A -> 320A';
ok Uni.new(0x320B).NFC.list ~~ (0x320B,), '320B -> 320B';
ok Uni.new(0x320C).NFC.list ~~ (0x320C,), '320C -> 320C';
ok Uni.new(0x320D).NFC.list ~~ (0x320D,), '320D -> 320D';
ok Uni.new(0x320E).NFC.list ~~ (0x320E,), '320E -> 320E';
ok Uni.new(0x320F).NFC.list ~~ (0x320F,), '320F -> 320F';
ok Uni.new(0x3210).NFC.list ~~ (0x3210,), '3210 -> 3210';
ok Uni.new(0x3211).NFC.list ~~ (0x3211,), '3211 -> 3211';
ok Uni.new(0x3212).NFC.list ~~ (0x3212,), '3212 -> 3212';
ok Uni.new(0x3213).NFC.list ~~ (0x3213,), '3213 -> 3213';
ok Uni.new(0x3214).NFC.list ~~ (0x3214,), '3214 -> 3214';
ok Uni.new(0x3215).NFC.list ~~ (0x3215,), '3215 -> 3215';
ok Uni.new(0x3216).NFC.list ~~ (0x3216,), '3216 -> 3216';
ok Uni.new(0x3217).NFC.list ~~ (0x3217,), '3217 -> 3217';
ok Uni.new(0x3218).NFC.list ~~ (0x3218,), '3218 -> 3218';
ok Uni.new(0x3219).NFC.list ~~ (0x3219,), '3219 -> 3219';
ok Uni.new(0x321A).NFC.list ~~ (0x321A,), '321A -> 321A';
ok Uni.new(0x321B).NFC.list ~~ (0x321B,), '321B -> 321B';
ok Uni.new(0x321C).NFC.list ~~ (0x321C,), '321C -> 321C';
ok Uni.new(0x321D).NFC.list ~~ (0x321D,), '321D -> 321D';
ok Uni.new(0x321E).NFC.list ~~ (0x321E,), '321E -> 321E';
ok Uni.new(0x3220).NFC.list ~~ (0x3220,), '3220 -> 3220';
ok Uni.new(0x3221).NFC.list ~~ (0x3221,), '3221 -> 3221';
ok Uni.new(0x3222).NFC.list ~~ (0x3222,), '3222 -> 3222';
ok Uni.new(0x3223).NFC.list ~~ (0x3223,), '3223 -> 3223';
ok Uni.new(0x3224).NFC.list ~~ (0x3224,), '3224 -> 3224';
ok Uni.new(0x3225).NFC.list ~~ (0x3225,), '3225 -> 3225';
ok Uni.new(0x3226).NFC.list ~~ (0x3226,), '3226 -> 3226';
ok Uni.new(0x3227).NFC.list ~~ (0x3227,), '3227 -> 3227';
ok Uni.new(0x3228).NFC.list ~~ (0x3228,), '3228 -> 3228';
ok Uni.new(0x3229).NFC.list ~~ (0x3229,), '3229 -> 3229';
ok Uni.new(0x322A).NFC.list ~~ (0x322A,), '322A -> 322A';
ok Uni.new(0x322B).NFC.list ~~ (0x322B,), '322B -> 322B';
ok Uni.new(0x322C).NFC.list ~~ (0x322C,), '322C -> 322C';
ok Uni.new(0x322D).NFC.list ~~ (0x322D,), '322D -> 322D';
ok Uni.new(0x322E).NFC.list ~~ (0x322E,), '322E -> 322E';
ok Uni.new(0x322F).NFC.list ~~ (0x322F,), '322F -> 322F';
ok Uni.new(0x3230).NFC.list ~~ (0x3230,), '3230 -> 3230';
ok Uni.new(0x3231).NFC.list ~~ (0x3231,), '3231 -> 3231';
ok Uni.new(0x3232).NFC.list ~~ (0x3232,), '3232 -> 3232';
ok Uni.new(0x3233).NFC.list ~~ (0x3233,), '3233 -> 3233';
ok Uni.new(0x3234).NFC.list ~~ (0x3234,), '3234 -> 3234';
ok Uni.new(0x3235).NFC.list ~~ (0x3235,), '3235 -> 3235';
ok Uni.new(0x3236).NFC.list ~~ (0x3236,), '3236 -> 3236';
ok Uni.new(0x3237).NFC.list ~~ (0x3237,), '3237 -> 3237';
ok Uni.new(0x3238).NFC.list ~~ (0x3238,), '3238 -> 3238';
ok Uni.new(0x3239).NFC.list ~~ (0x3239,), '3239 -> 3239';
ok Uni.new(0x323A).NFC.list ~~ (0x323A,), '323A -> 323A';
ok Uni.new(0x323B).NFC.list ~~ (0x323B,), '323B -> 323B';
ok Uni.new(0x323C).NFC.list ~~ (0x323C,), '323C -> 323C';
ok Uni.new(0x323D).NFC.list ~~ (0x323D,), '323D -> 323D';
ok Uni.new(0x323E).NFC.list ~~ (0x323E,), '323E -> 323E';
ok Uni.new(0x323F).NFC.list ~~ (0x323F,), '323F -> 323F';
ok Uni.new(0x3240).NFC.list ~~ (0x3240,), '3240 -> 3240';
ok Uni.new(0x3241).NFC.list ~~ (0x3241,), '3241 -> 3241';
ok Uni.new(0x3242).NFC.list ~~ (0x3242,), '3242 -> 3242';
ok Uni.new(0x3243).NFC.list ~~ (0x3243,), '3243 -> 3243';
ok Uni.new(0x3244).NFC.list ~~ (0x3244,), '3244 -> 3244';
ok Uni.new(0x3245).NFC.list ~~ (0x3245,), '3245 -> 3245';
ok Uni.new(0x3246).NFC.list ~~ (0x3246,), '3246 -> 3246';
ok Uni.new(0x3247).NFC.list ~~ (0x3247,), '3247 -> 3247';
ok Uni.new(0x3250).NFC.list ~~ (0x3250,), '3250 -> 3250';
ok Uni.new(0x3251).NFC.list ~~ (0x3251,), '3251 -> 3251';
ok Uni.new(0x3252).NFC.list ~~ (0x3252,), '3252 -> 3252';
ok Uni.new(0x3253).NFC.list ~~ (0x3253,), '3253 -> 3253';
ok Uni.new(0x3254).NFC.list ~~ (0x3254,), '3254 -> 3254';
ok Uni.new(0x3255).NFC.list ~~ (0x3255,), '3255 -> 3255';
ok Uni.new(0x3256).NFC.list ~~ (0x3256,), '3256 -> 3256';
ok Uni.new(0x3257).NFC.list ~~ (0x3257,), '3257 -> 3257';
ok Uni.new(0x3258).NFC.list ~~ (0x3258,), '3258 -> 3258';
ok Uni.new(0x3259).NFC.list ~~ (0x3259,), '3259 -> 3259';
ok Uni.new(0x325A).NFC.list ~~ (0x325A,), '325A -> 325A';
ok Uni.new(0x325B).NFC.list ~~ (0x325B,), '325B -> 325B';
ok Uni.new(0x325C).NFC.list ~~ (0x325C,), '325C -> 325C';
ok Uni.new(0x325D).NFC.list ~~ (0x325D,), '325D -> 325D';
ok Uni.new(0x325E).NFC.list ~~ (0x325E,), '325E -> 325E';
ok Uni.new(0x325F).NFC.list ~~ (0x325F,), '325F -> 325F';
ok Uni.new(0x3260).NFC.list ~~ (0x3260,), '3260 -> 3260';
ok Uni.new(0x3261).NFC.list ~~ (0x3261,), '3261 -> 3261';
ok Uni.new(0x3262).NFC.list ~~ (0x3262,), '3262 -> 3262';
ok Uni.new(0x3263).NFC.list ~~ (0x3263,), '3263 -> 3263';
ok Uni.new(0x3264).NFC.list ~~ (0x3264,), '3264 -> 3264';
ok Uni.new(0x3265).NFC.list ~~ (0x3265,), '3265 -> 3265';
ok Uni.new(0x3266).NFC.list ~~ (0x3266,), '3266 -> 3266';
ok Uni.new(0x3267).NFC.list ~~ (0x3267,), '3267 -> 3267';
ok Uni.new(0x3268).NFC.list ~~ (0x3268,), '3268 -> 3268';
ok Uni.new(0x3269).NFC.list ~~ (0x3269,), '3269 -> 3269';
ok Uni.new(0x326A).NFC.list ~~ (0x326A,), '326A -> 326A';
ok Uni.new(0x326B).NFC.list ~~ (0x326B,), '326B -> 326B';
ok Uni.new(0x326C).NFC.list ~~ (0x326C,), '326C -> 326C';
ok Uni.new(0x326D).NFC.list ~~ (0x326D,), '326D -> 326D';
ok Uni.new(0x326E).NFC.list ~~ (0x326E,), '326E -> 326E';
ok Uni.new(0x326F).NFC.list ~~ (0x326F,), '326F -> 326F';
ok Uni.new(0x3270).NFC.list ~~ (0x3270,), '3270 -> 3270';
ok Uni.new(0x3271).NFC.list ~~ (0x3271,), '3271 -> 3271';
ok Uni.new(0x3272).NFC.list ~~ (0x3272,), '3272 -> 3272';
ok Uni.new(0x3273).NFC.list ~~ (0x3273,), '3273 -> 3273';
ok Uni.new(0x3274).NFC.list ~~ (0x3274,), '3274 -> 3274';
ok Uni.new(0x3275).NFC.list ~~ (0x3275,), '3275 -> 3275';
ok Uni.new(0x3276).NFC.list ~~ (0x3276,), '3276 -> 3276';
ok Uni.new(0x3277).NFC.list ~~ (0x3277,), '3277 -> 3277';
ok Uni.new(0x3278).NFC.list ~~ (0x3278,), '3278 -> 3278';
ok Uni.new(0x3279).NFC.list ~~ (0x3279,), '3279 -> 3279';
ok Uni.new(0x327A).NFC.list ~~ (0x327A,), '327A -> 327A';
ok Uni.new(0x327B).NFC.list ~~ (0x327B,), '327B -> 327B';
ok Uni.new(0x327C).NFC.list ~~ (0x327C,), '327C -> 327C';
ok Uni.new(0x327D).NFC.list ~~ (0x327D,), '327D -> 327D';
ok Uni.new(0x327E).NFC.list ~~ (0x327E,), '327E -> 327E';
ok Uni.new(0x3280).NFC.list ~~ (0x3280,), '3280 -> 3280';
ok Uni.new(0x3281).NFC.list ~~ (0x3281,), '3281 -> 3281';
ok Uni.new(0x3282).NFC.list ~~ (0x3282,), '3282 -> 3282';
ok Uni.new(0x3283).NFC.list ~~ (0x3283,), '3283 -> 3283';
ok Uni.new(0x3284).NFC.list ~~ (0x3284,), '3284 -> 3284';
ok Uni.new(0x3285).NFC.list ~~ (0x3285,), '3285 -> 3285';
ok Uni.new(0x3286).NFC.list ~~ (0x3286,), '3286 -> 3286';
ok Uni.new(0x3287).NFC.list ~~ (0x3287,), '3287 -> 3287';
ok Uni.new(0x3288).NFC.list ~~ (0x3288,), '3288 -> 3288';
ok Uni.new(0x3289).NFC.list ~~ (0x3289,), '3289 -> 3289';
ok Uni.new(0x328A).NFC.list ~~ (0x328A,), '328A -> 328A';
ok Uni.new(0x328B).NFC.list ~~ (0x328B,), '328B -> 328B';
ok Uni.new(0x328C).NFC.list ~~ (0x328C,), '328C -> 328C';
ok Uni.new(0x328D).NFC.list ~~ (0x328D,), '328D -> 328D';
ok Uni.new(0x328E).NFC.list ~~ (0x328E,), '328E -> 328E';
ok Uni.new(0x328F).NFC.list ~~ (0x328F,), '328F -> 328F';
ok Uni.new(0x3290).NFC.list ~~ (0x3290,), '3290 -> 3290';
ok Uni.new(0x3291).NFC.list ~~ (0x3291,), '3291 -> 3291';
ok Uni.new(0x3292).NFC.list ~~ (0x3292,), '3292 -> 3292';
ok Uni.new(0x3293).NFC.list ~~ (0x3293,), '3293 -> 3293';
ok Uni.new(0x3294).NFC.list ~~ (0x3294,), '3294 -> 3294';
ok Uni.new(0x3295).NFC.list ~~ (0x3295,), '3295 -> 3295';
ok Uni.new(0x3296).NFC.list ~~ (0x3296,), '3296 -> 3296';
