# Announce: Rakudo Perl 6 compiler, Release #127 (2018.10)

On behalf of the Rakudo development team, I’m very happy to announce the
October 2018 release of Rakudo Perl 6 #127. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo.

Upcoming releases in 2018 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <https://rakudo.org/files/rakudo>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<https://rakudo.org/files/star>.

The changes in this release are outlined below:

New in 2018.10:
  + SPECIAL NOTES:
    + This is the first Rakudo release that comes with an additional
      JS backend. See `6pad` project for running Perl 6 code directly
      in your browser.
  + Deprecations:
    + Deprecated `gethostname()` in favor of `$*KERNEL.hostname` [f7fa5185]
  + Fixes:
    + Fixed/improved divide-by-zero errors in
        `Rational.floor`/`.ceiling`/`.Str` [a639fa9c][6d70346c]
    + Fixed semantics of `[Nil]` [88e6de22]
    + Fixed issue with custom `bless` method [64137bd2]
    + Made nativecall's `postcircumfix:<[ ]>` return containers [be2d4cb4]
    + Fixed hash descriptor when doing `Hash[Int].new` [9acbf000][ea710414]
    + `Nil` is now allowed in initialization and assignment of hashes
        [f61ba41a][605bcb39][7e86d4e3]
    + Fixed ContainerDescriptor for arrays with a dimension of three [a2e78ec8]
    + Fixed indexing of shaped arrays with a dimension higher than 3 [0307c366]
    + `.in-timezone`s value is now coerced to Int [c8438e6a]
    + Stub methods from roles are now verified [fd5d5bdf]
    + Fixed double-closing of handles in `.lines` when `:close` and
        `$limit` are used [6edb142f]
    + Fixed closing of handles in `IO::Handle.lines` when `$limit`
        is used [c1c75740]
    + Consistified Rat.base to fail instead of throw [a804ab57]
    + Fixed enforcing of return constraints on multi method stubs [abba67b2]
    + Various improvements to produced messages [cc2fcc9a][560e94ef]
        [bf10f4c5][243a2f01][7d02b949][9894eda5][0243275d]
  + Additions:
    + [6.d] Constructs `$()`/`@()`/`%()` no longer have any `$/`-related
        magic [bb88a032]
    + [6.d] DefiniteHOWs' (type smileys) default default is now the base
        type [38b198c9]
    + Zero-Denominator Rationals are now normalized on creation [671c4115]
        [75ec2248]
    + Made `my @a is List = 1,2,3,4` work [2bdf2b35]
    + Using `is Type` on `@` and `%` attributes is now allowed [b537ce2e]
    + Added a BOM on `open` for utf16 filehandles [959b89cf][479348f3]
    + Added initial support for Unicode 11.0 [5c272ee4]
    + Pluggable `MAIN` interface refactored, documented and tested
        [f234b9af][35f3d83d][7c9b2955][33c24153][8c3a4131][fbfccfa2]][341190e2][24413b5f[2c43d2bf]
    + Usage message now limits itself to partially matching candidates
        [0d1be77e]
    + Added additional dashed variants for utf16le and utf16be [4307996a]
    + Added `Parameter.coerce_type` method [0243275d]
    + Added `Code.cando` method to allow for `.cando` on all `Callable`s
        [45eeab78][69533b50]
  + Removals:
    + Removed --encoding support [bea08ec6][31b19d09]
  + Efficiency:
    + Made Hash.push/append between 1.2x and 1.4x as fast [12cfde2a]
    + Made `"".ord` orders of magnitude faster [b22edce4]
    + Made `==` with Rationals up to 1.55x as fast [c5a2eb81]
    + Made Rational `===` Rational 2.47x as fast [97e8413b]
    + Made many cases of `for (range-like things)` up to 150x as fast
        [2dd02751][645eeb52][dfd6450d][49baea70][89787028][2af789d7]
    + Made `[42]` not allocate anything anymore [8c4546bb]
    + Made `[@a]` and `[1,2,3]` about 1.4x as fast [e430813f]
    + Made `Array.List` coercion 1.5x as fast [3d405e89]
    + Made `.isa` about 2x as fast [4e8740c8]
    + Made `infix:<%%>` 10.42x as fast on natives [3d161a56]
    + Other minor optimizations [464a86b1][ab83b9d8][8cc3d5d7][b107cda5]
  + Internal:
    + Made `make` an only [369068ae]
    + Added skip-one method to appropriate PredictiveIterators [e54885e5]
    + More things are now initialized at setting compile time
        [06dfbf02][688cbac1][92735770]
    + Simplified initialization of `CompUnit::RepositoryRegistry`
        [0425d927][8e1cd01a]
    + Introduced `IterationBuffer.List` [8c10da6a]
    + Made it not go through `.new` if we can `nqp::create` [84311b77]
    + Made sure `.STORE` only works on instances [9daac683]
    + Added `$*INSIDE-EVAL` to mark that we're inside an `EVAL` [73b7c603]


The following people contributed to this release:

Zoffix Znet, Elizabeth Mattijsen, Paweł Murias, JJ Merelo, Tom Browder,
Bart Wiegmans, Jonathan Worthington, Will "Coke" Coleda,
Aleks-Daniel Jakimenko-Aleksejev, Samantha McVey, thebooort,
Juan Julián Merelo Guervós, Ben Davies, Fernando Correa de Oliveira,
Timo Paulssen, Daniel Green, MorayJ, Valentin Anger,
threadless-screw, Jeremy Studer, Nick Logan, finanalyst, Alexander,
Amir Aharoni, Claudio Ramirez, Luis F. Uceta, Nacho Mas, Richard Hainsworth,
Alex Schroeder, Bartosz Janus, Brad Gilbert, Jared Miller, Jason Cole,
Jonathan Beebe, Patrick Sebastian Böker, Rafael Schipiura,
Tzu-Li "tison" Chen, Tzu-Li Chen, sarna

If you would like to contribute or find out more information, visit
<https://perl6.org>, <https://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#128), is tentatively scheduled for 2018-11-17.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
