# Announce: Rakudo Perl 6 compiler, Release #96 (2016.02)

On behalf of the Rakudo development team, I’m very happy to announce the
February 2016 release of Rakudo Perl 6 #96. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2016 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to insure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The Rakudo Perl compiler follows a monthly release cycle, but please bear
with us post-Christmas. We are working hard to insure that we don’t break
anything now that we have a released spec, and it make take us a few months
to settle back into a rhythm.

The changes in this release are outlined below:

New in 2016.02:
 + Fixes:
   + Many memory leaks fixed in MoarVM
   + Set.hash now returns an object hash (RT #127402)
   + Use the order of arguments in usage display, rather than hash order
   + Specifying ::a now gives proper compile time error (RT #127504)
   + Enums with a type object now fail with an NYI error
   + .first(:end) on uncached iterators no longer fails
 + Additions:
   + REPL now supports multi-line statements (experimental)
   + Can now uninstall distributions
 + Efficiency:
   + Str.trans can now be up to 160x faster
   + @a.chrs noq 3x faster, chrs(@a) now 9x faster

These are only some of the changes in this release. For a more
detailed list, see “docs/ChangeLog”.

The following people contributed to this release:

Elizabeth Mattijsen, Pawel Murias, Jonathan Worthington, Will "Coke" Coleda,
Rob Hoelz, Moritz Lenz, Tobias Leich, Salvador Ortiz, Donald Hunter,
Timo Paulssen, niner, Stefan Seifert, Aleks-Daniel Jakimenko-Aleksejev,
Dave Rolsky, Jonathan Stowe, LLFourn, Nick Logan, okaoka, John Spurr,
Páll Haraldsson, Carl Masak, Zoffix Znet, Sylvain Colinet, Andy Weidenbaum,
Tommy Stanton

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

The next release of Rakudo (#97), is tentatively scheduled for 19 March 2016.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility. Rakudo Star
is meant for early adopters who wish to explore what’s possible with
Rakudo Perl 6 and provide feedback on what works, what doesn’t, and
what else they would like to see included in the distribution.
