#! /bin/sh

export PATH=/bin:/usr/bin:/sbin:/usr/sbin

# delete a template user

D_USER="$1"
D_HOME="/var/${D_USER}"

user=`whoami`

if [ x${user} != x"root" ]; then
    echo $0 must be run as root 1>&2
    exit 1
fi

niutil -destroy . /users/${D_USER} 2>/dev/null
niutil -destroy . /groups/${D_USER} 2>/dev/null

if [ -d ${D_HOME} ]; then
    rm -rf ${D_HOME}
fi

exit 0
