#import "RXTableView.h"

@implementation RXTableView

- ( void )awakeFromNib
{
    NSTextFieldCell		*cell = [[ NSTextFieldCell alloc ] init ];
    NSArray			*columns = [ self tableColumns ];
    int				i;
    
    [ cell setDrawsBackground: NO ];
    //[ cell setEditable: YES ];
    
    for ( i = 0; i < [ columns count ]; i++ ) {
        [[ columns objectAtIndex: i ] setDataCell: cell ];
    }
    [ cell release ];
}

/* catch delete key events */
- ( void )keyDown: ( NSEvent * )theEvent
{
    unichar 		key = [[ theEvent charactersIgnoringModifiers ] characterAtIndex: 0 ];
    
    if ( key == NSDeleteCharacter && [ self numberOfRows ] > 0
                                    && [ self selectedRow ] != -1 ) {
        if ( [[ self dataSource ] respondsToSelector: @selector( deleteSelectedLines: ) ] ) {
            [[ self dataSource ] performSelector: @selector( deleteSelectedLines: )
                                withObject: self
                                afterDelay: 0.0 ];
        }
    } else {
        [ super keyDown: theEvent ];
    }
}

/* needed to allow tabbing into table view */
- ( BOOL )needsPanelToBecomeKey
{
    return( YES );
}

@end
