/*
Copyright (c) 2002 Regents of The University of Michigan.
All Rights Reserved.

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appears in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of The University
of Michigan not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission. This software is supplied as is without expressed or
implied warranties of any kind.

Research Systems Unix Group
The University of Michigan
c/o Wesley Craig
4251 Plymouth Road B1F2, #2600
Ann Arbor, MI 48105-2785

http://rsug.itd.umich.edu/software/radmind
radmind@umich.edu
*/

#import "RXPrefs.h"

@implementation RXPrefs

- ( id )init
{
    self = [ super init ];
 
    return( self );
}

- ( void )awakeFromNib
{
    [ prefPanel center ];
}

- ( void )reloadDefaults
{
    NSUserDefaults      *defaults = [ NSUserDefaults standardUserDefaults ];
    NSString            *basepath = [ defaults objectForKey: @"RTEBasePath" ];
    BOOL		wildcard = [ defaults boolForKey: @"RTEWildcardSearches" ];
    float               fontsize = [ defaults floatForKey: @"RTETextFontSize" ];
                                        
    if ( basepath == nil ) {
        basepath = @"/";
    }
    
    if ( fontsize <= 0.0 ) {
        fontsize = 12.0;
        [ defaults setFloat: 12.0 forKey: @"RTETextFontSize" ];
    }
    
    [ prefBasePathPopUp selectItemWithTitle: basepath ];
    [ prefTranscriptFontSizeStepper setFloatValue: fontsize ];
    [ prefTranscriptFontSize setFloatValue: fontsize ];
    
    if ( wildcard ) {
	[ prefWildcardSwitch setState: NSOnState ];
    } else {
	[ prefWildcardSwitch setState: NSOffState ];
    }
}

- ( void )displayPreferencesPane
{
    [ self reloadDefaults ];
    [ prefPanel makeKeyAndOrderFront: nil ];
}

- ( IBAction )prefSetBasePath: ( id )sender
{
    NSString            *basepath = nil;
    
    if ( ! [ sender isKindOfClass: [ NSPopUpButton class ]] ) {
        NSBeep();
        return;
    }
    
    basepath = [ sender titleOfSelectedItem ];
    
    [[ NSUserDefaults standardUserDefaults ] setObject: basepath
                                                forKey: @"RTEBasePath" ];
}

- ( IBAction )toggleWildcardSearches: ( id )sender
{
    BOOL		wildcard = NO;
    
    if ( [ sender state ] == NSOnState ) {
	wildcard = YES;
    }
    
    [[ NSUserDefaults standardUserDefaults ]
	    setBool: wildcard forKey: @"RTEWildcardSearches" ];
}

- ( IBAction )setTranscriptFontSize: ( id )sender
{
    float               fontsize;
    
    if (( fontsize = [ sender floatValue ] ) <= 0 ||
                fontsize > 72 ) {
        fontsize = 12.0;
    }

    [[ NSUserDefaults standardUserDefaults ] setFloat: fontsize
                                            forKey: @"RTETextFontSize" ];
    [[ NSUserDefaults standardUserDefaults ] synchronize ];
    
    [[ NSDistributedNotificationCenter defaultCenter ]
                    postNotificationName: RTEFontSizeChangedNotification
                    object: nil ];
}

- ( IBAction )changeTranscriptFontSize: ( id )sender
{
    if ( ! [ sender isKindOfClass: [ NSStepper class ]] ) {
        NSBeep();
        return;
    }
    
    [ prefTranscriptFontSize setFloatValue: [ sender floatValue ]];
    
    [ NSObject cancelPreviousPerformRequestsWithTarget: self
                            selector: @selector( setTranscriptFontSize: )
                            object: prefTranscriptFontSize ];
    [ self performSelector: @selector( setTranscriptFontSize: )
                            withObject: prefTranscriptFontSize
                            afterDelay: 1.0 ];
}

@end
