/*
Copyright (c) 2002 Regents of The University of Michigan.
All Rights Reserved.

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appears in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of The University
of Michigan not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission. This software is supplied as is without expressed or
implied warranties of any kind.

Research Systems Unix Group
The University of Michigan
c/o Wesley Craig
4251 Plymouth Road B1F2, #2600
Ann Arbor, MI 48105-2785

http://rsug.itd.umich.edu/software/radmind
radmind@umich.edu
*/

#import "RXAppController.h"

#include <CoreFoundation/CoreFoundation.h>

#include <sys/types.h>
#include <pwd.h>
#include <unistd.h>

@implementation RXAppController

- ( id )init
{
    self = [ super init ];
    prefController = nil;
    _rteUserName = nil;
    
    return( self );
}

#ifdef notdef
- ( void )awakeFromNib
{
    [[ NSAppleEventManager sharedAppleEventManager ]
            setEventHandler: self
            andSelector: @selector( handleOpenDocEvent:andReplyWithEvent: )
            forEventClass: 'aevt'
            andEventID: 'odoc' ];
}

- ( void )handleOpenDocEvent: ( NSAppleEventDescriptor * )inEvent
            andReplyWithEvent: ( NSAppleEventDescriptor * )replyEvent
{
    NSAppleEventDescriptor	*desc;
    NSString			*hfspath = nil;
    NSString			*posixpath = nil;
    CFURLRef			url = NULL;
    id				doc;
    
    desc = [ inEvent paramDescriptorForKeyword: keyDirectObject ];
    
    if ( desc == nil ) {
        NSLog( @"Event has no direct object" );
        return;
    }
    
    hfspath = [ NSString stringWithUTF8String: [[ desc data ] bytes ]];
NSLog( @"hfspath: %@", hfspath );

    if ( hfspath == nil ) {
        NSLog( @"nothing" );
    }
    
    url = CFURLCreateWithFileSystemPath( kCFAllocatorDefault,
                ( CFStringRef )hfspath, kCFURLHFSPathStyle, NO );
    posixpath = ( NSString * )CFURLCopyFileSystemPath( url, kCFURLPOSIXPathStyle );
    
    NSLog( @"path: %@", posixpath );
    
    doc = [[ NSDocumentController sharedDocumentController ]
                openDocumentWithContentsOfFile: posixpath
                display: YES ];
        
    if ( doc == nil ) {
        NSLog( @"odoc failed" );
    }
        
    if ( url != NULL ) {
        CFRelease( url );
    }
    if ( posixpath != nil ) {
        [ posixpath release ];
    }
}
#endif notdef

- ( IBAction )getPrefPanel: ( id )sender
{
    if ( prefController == nil ) {
        prefController = [[ RXPrefs alloc ] init ];
        [ NSBundle loadNibNamed: @"RXPrefs" owner: prefController ];
    }
    
    [ prefController displayPreferencesPane ];
}

- ( NSString * )sessionUserName
{
    return( _rteUserName );
}

/* NSApp delegate methods */
- ( BOOL )applicationShouldOpenUntitledFile: ( NSApplication * )app
{
    return( NO );
}

- ( void )applicationDidFinishLaunching: ( NSNotification * )notification
{
    struct passwd	*pw;
    uid_t		uid = getuid();
    
    if (( pw = getpwuid( uid )) == NULL ) {
	NSLog( @"Couldn't get user name for uid %d", uid );
	_rteUserName = [[ NSString stringWithString: @"unknown" ] retain ];
    } else {
	_rteUserName = [[ NSString stringWithUTF8String: pw->pw_name ] retain ];
    }
}

@end
