#import "RTEInfoPanelController.h"

@implementation RTEInfoPanelController

/* accessors */
- ( id )infoDictionary
{
    return( _rteInfoDictionary );
}

- ( void )setInfoDictionary: ( id )infoDictionary
{
    if ( _rteInfoDictionary != nil ) {
	[ _rteInfoDictionary release ];
	_rteInfoDictionary = nil;
    }
    _rteInfoDictionary = [ infoDictionary retain ];
}
/* end accessors */

- ( id )init
{
    self = [ super init ];
    _rteInfoDictionary = nil;
    
    return( self );
}

- ( void )awakeFromNib
{
    [ rteInfoObjectName setStringValue: @"" ];
    [ window setDelegate: self ];
}

- ( IBAction )showWindow: ( id )sender
{
    NSRect	    originalRect = [ rteInfoObjectName frame ];
    NSRect	    newRect = originalRect;
    NSTextView	    *tv;
    NSPoint	    newo = originalRect.origin;
    float	    oy = originalRect.origin.y;
    
    [ rteInfoObjectName setStringValue:
	    [[ self infoDictionary ] objectForKey: @"path" ]];

    newRect.size.height = 10000;
    tv = [[ NSTextView alloc ] initWithFrame: newRect ];
    [ tv setString: [ rteInfoObjectName stringValue ]];
    [ tv sizeToFit ];
    newRect = [[ tv layoutManager ] usedRectForTextContainer: [ tv textContainer ]];
    newRect.size.width = originalRect.size.width;

    newo.y = ( oy - ( newRect.size.height - originalRect.size.height ));
    newRect.origin = newo;

    [ tv release ];
    
    [ rteInfoObjectName setFrame: newRect ];
    [ rteInfoObjectName calcSize ];

    [ self setDocument: [[ NSDocumentController sharedDocumentController ]
			    currentDocument ]];
    [ super showWindow: nil ];
}

- ( void )windowWillClose: ( NSNotification * )notification
{
    [ self autorelease ];
}

- ( void )dealloc
{
    if ( _rteInfoDictionary != nil ) {
	[ _rteInfoDictionary release ];
	_rteInfoDictionary = nil;
    }
    
    [ super dealloc ];
}

@end