#import "RMSplitView.h"

static NSTimer      *resizeTimer = nil;
static float        pcheight = 0.0;
static float        chunk = 0.0;

@implementation RMSplitView

/* don't show the divider; no resizing of the info pane */
- ( float )dividerThickness
{
    return( 0.0 );
}

- ( BOOL )isSubviewCollapsed: ( NSView * )subview
{
    NSRect          sr = [ subview frame ];
    
    if ( [ self isVertical ] ) {
        if ( ! NSWidth( sr )) {
            return( YES );
        }
    } else {
        if ( ! NSHeight( sr )) {
            return( YES );
        }
    }
    
    return( [ super isSubviewCollapsed: subview ] );
}

- ( void )collapseSubView: ( NSView * )subview animate: ( BOOL )animate
{
    NSArray         *subviews = [ self subviews ];
    NSView          *collapsing = nil, *expanding = nil;
    NSRect          collapsingRect, expandingRect;
    
    if ( [ subviews count ] != 2 ||
                ! [ subviews containsObject: subview ] ) {
        return;
    }
    
    if ( resizeTimer ) {
        [ resizeTimer invalidate ];
        resizeTimer = nil;
    }
    
    if ( [ subview isEqual: [ subviews objectAtIndex: 0 ]] ) {
        collapsing = [ subviews objectAtIndex: 0 ];
        expanding = [ subviews objectAtIndex: 1 ];
    } else if ( [ subview isEqual: [ subviews objectAtIndex: 1 ]] ) {
        collapsing = [ subviews objectAtIndex: 1 ];
        expanding = [ subviews objectAtIndex: 0 ];
    }
    
    collapsingRect = [ collapsing frame ];
    expandingRect = [ expanding frame ];
        
    /* XXX check -isVertical and adjust width */
    
    if ( NSHeight( collapsingRect ) == 0.0 ) {
        return;
    }
    pcheight = NSHeight( collapsingRect );
    
    if ( animate ) {
        NSDictionary    *animateInfo;
        
        animateInfo = [ NSDictionary dictionaryWithObjectsAndKeys:
                            [ NSNumber numberWithInt: RMSplitViewCollapsing ],
                                @"action",
                                expanding, @"expanding",
                                collapsing, @"shrinking", nil ];
                                
        chunk = ( pcheight / 10.0 );
        resizeTimer = [ NSTimer scheduledTimerWithTimeInterval: 0.02
                                target: self
                                selector: @selector( animateResize: )
                                userInfo: animateInfo
                                repeats: YES ];
        return;
    }
    
    expandingRect.size.height += NSHeight( collapsingRect );
    collapsingRect.size.height = 0.0;
    [ collapsing setFrame: collapsingRect ];
    [ expanding setFrame: expandingRect ];
    [ self adjustSubviews ];
}

- ( void )expandSubView: ( NSView * )subview animate: ( BOOL )animate
{
    NSArray         *subviews = [ self subviews ];
    NSView          *expanding = nil, *shrinking = nil;
    NSRect          expandingRect, shrinkingRect;
    
    if ( [ subviews count ] != 2 ||
                ! [ subviews containsObject: subview ] ) {
        return;
    }
    
    if ( [ subview isEqual: [ subviews objectAtIndex: 0 ]] ) {
        expanding = [ subviews objectAtIndex: 0 ];
        shrinking = [ subviews objectAtIndex: 1 ];
    } else if ( [ subview isEqual: [ subviews objectAtIndex: 1 ]] ) {
        expanding = [ subviews objectAtIndex: 1 ];
        shrinking = [ subviews objectAtIndex: 0 ];
    }
    
    if ( resizeTimer ) {
        [ resizeTimer invalidate ];
        resizeTimer = nil;
    }
    
    shrinkingRect = [ shrinking frame ];
    expandingRect = [ expanding frame ];
    
    if ( NSHeight( expandingRect ) != 0.0 ) {
        return;
    }
    
    if ( animate ) {
        NSDictionary    *animateInfo;
        
        animateInfo = [ NSDictionary dictionaryWithObjectsAndKeys:
                            [ NSNumber numberWithInt: RMSplitViewExpanding ],
                                @"action",
                                expanding, @"expanding",
                                shrinking, @"shrinking", nil ];
                                
        chunk = ( pcheight / 10.0 );
        resizeTimer = [ NSTimer scheduledTimerWithTimeInterval: 0.02
                                target: self
                                selector: @selector( animateResize: )
                                userInfo: animateInfo
                                repeats: YES ];
        return;
    }
    
    expandingRect.size.height += pcheight;
    shrinkingRect.size.height -= pcheight;
    [ expanding setFrame: expandingRect ];
    [ shrinking setFrame: shrinkingRect ];
    
    [ self adjustSubviews ];
}

- ( void )animateResize: ( NSTimer * )timer
{
    NSDictionary    *userInfo = [ timer userInfo ];
    NSView          *exp, *shr;
    NSRect          expr, shrr;
    int             action = [[ userInfo objectForKey: @"action" ] intValue ];
    float           target = 0.0;
    
    exp = [ userInfo objectForKey: @"expanding" ];
    shr = [ userInfo objectForKey: @"shrinking" ];
    expr = [ exp frame ];
    shrr = [ shr frame ];
    
    expr.size.height += chunk;
    shrr.size.height -= chunk;
    
    switch ( action ) {
    case RMSplitViewExpanding:
        target = pcheight;
        if ( expr.size.height > pcheight ) {
            shrr.size.height += ( expr.size.height - pcheight );
            expr.size.height = pcheight;
        }
        break;
        
    case RMSplitViewCollapsing:
        target = 0.0;
        if ( shrr.size.height < 0.0 ) {
            expr.size.height += shrr.size.height;
            shrr.size.height = 0.0;
        }
        break;
        
    default:
        NSLog( @"unknown animation action %d", action );
        return;
    }
    
    [ exp setFrame: expr ];
    [ shr setFrame: shrr ];
    
    [ self adjustSubviews ];
    
    if ( NSHeight( action ? shrr : expr ) == target ) {
        goto ANIMATION_DONE;
    }
    chunk += ( chunk / 2 );
    
    return;
    
ANIMATION_DONE:
    [ resizeTimer invalidate ];
    resizeTimer = nil;
}

@end
