#import "NSMutableDictionary(RXAdditions).h"

#include <sys/param.h>
#include "argcargv.h"
#include "code.h"

#define	KNOWNTYPES	"+-abcdDfhlps"

@implementation NSMutableDictionary(RXAdditions)

    int
isknowntype( char type )
{
    if ( strchr( KNOWNTYPES, type ) == NULL ) {
        return( 0 );
    }
    return( 1 );
}

+ ( NSMutableDictionary * )dictionaryForType: ( char )type
                        atTIndex: ( long )index
                        withArgc: ( int )argc
                        withArgv: ( char ** )argv
                        line: ( char * )line
{
    NSMutableDictionary		*dict = nil;
    char			plusminus = '0';
    char			**targv;
    int				tac = argc;

    if ( *argv[ 0 ] == '-' || *argv[ 0 ] == '+' ) {
        plusminus = *argv[ 0 ];
        targv = ++argv;
        tac--;
    } else {
        plusminus = '0';
        targv = argv;
    }
    
    if ( argc > 0 ) {
        switch( type ) {
        case 'f':
        case 'a':
            dict = [ NSMutableDictionary dictionaryWithObjectsAndKeys:
                    [ NSString stringWithFormat: @"%d", index ], @"tindex",
                    [ NSString stringWithUTF8String: targv[ 0 ]], @"type",
                    [ NSString stringWithUTF8String: decode( targv[ 1 ] ) ], @"path",
                    [ NSString stringWithUTF8String: targv[ 2 ]], @"perm",
                    [ NSString stringWithUTF8String: targv[ 3 ]], @"owner",
                    [ NSString stringWithUTF8String: targv[ 4 ]], @"group",
                    [ NSString stringWithUTF8String: targv[ 5 ]], @"mtime",
                    [ NSString stringWithUTF8String: targv[ 6 ]], @"size",
                    [ NSString stringWithUTF8String: targv[ 7 ]], @"cksum", 
                    [ NSString stringWithFormat: @"%c", plusminus ], @"pm", nil ];
                
            break;
        case 'b':
        case 'c':
            dict =
                [ NSMutableDictionary dictionaryWithObjectsAndKeys:
                [ NSString stringWithFormat: @"%d", index ], @"tindex",
                [ NSString stringWithUTF8String: targv[ 0 ]], @"type",
                [ NSString stringWithUTF8String: decode( targv[ 1 ] ) ], @"path",
                [ NSString stringWithUTF8String: targv[ 2 ]], @"perm",
                [ NSString stringWithUTF8String: targv[ 3 ]], @"owner",
                [ NSString stringWithUTF8String: targv[ 4 ]], @"group",
                [ NSString stringWithUTF8String: targv[ 5 ]], @"major",
                [ NSString stringWithUTF8String: targv[ 6 ]], @"minor", 
                [ NSString stringWithFormat: @"%c", plusminus ], @"pm", nil ];
            break;
        case 'D':
        case 'p':
        case 's':
            dict =
                [ NSMutableDictionary dictionaryWithObjectsAndKeys:
                [ NSString stringWithFormat: @"%d", index ], @"tindex",
                [ NSString stringWithUTF8String: targv[ 0 ]], @"type",
                [ NSString stringWithUTF8String: decode( targv[ 1 ] )], @"path",
                [ NSString stringWithUTF8String: targv[ 2 ]], @"perm",
                [ NSString stringWithUTF8String: targv[ 3 ]], @"owner",
                [ NSString stringWithUTF8String: targv[ 4 ]], @"group", 
                [ NSString stringWithFormat: @"%c", plusminus ], @"pm", nil ];
            break;
        case 'd':
            if ( tac == 6 ) {
                dict = 
                    [ NSMutableDictionary dictionaryWithObjectsAndKeys:
                    [ NSString stringWithFormat: @"%d", index ], @"tindex",
                    [ NSString stringWithUTF8String: targv[ 0 ]], @"type",
                    [ NSString stringWithUTF8String: decode( targv[ 1 ] )], @"path",
                    [ NSString stringWithUTF8String: targv[ 2 ]], @"perm",
                    [ NSString stringWithUTF8String: targv[ 3 ]], @"owner",
                    [ NSString stringWithUTF8String: targv[ 4 ]], @"group", 
                    [ NSString stringWithUTF8String: targv[ 5 ]], @"finfo",
                    [ NSString stringWithFormat: @"%c", plusminus ], @"pm", nil ];
            } else if ( tac == 5 ) {
                dict =
                    [ NSMutableDictionary dictionaryWithObjectsAndKeys:
                    [ NSString stringWithFormat: @"%d", index ], @"tindex",
                    [ NSString stringWithUTF8String: targv[ 0 ]], @"type",
                    [ NSString stringWithUTF8String: decode( targv[ 1 ] )], @"path",
                    [ NSString stringWithUTF8String: targv[ 2 ]], @"perm",
                    [ NSString stringWithUTF8String: targv[ 3 ]], @"owner",
                    [ NSString stringWithUTF8String: targv[ 4 ]], @"group", 
                    [ NSString stringWithFormat: @"%c", plusminus ], @"pm", nil ];
            }
            break;

        case 'h':
        case 'l':
            dict =
                [ NSMutableDictionary dictionaryWithObjectsAndKeys:
                    [ NSString stringWithFormat: @"%d", index ], @"tindex",
                    [ NSString stringWithUTF8String: targv[ 0 ]], @"type",
                    [ NSString stringWithUTF8String: decode( targv[ 1 ] )], @"path",
                    @"????", @"dest",
                    [ NSString stringWithFormat: @"%c", plusminus ], @"pm", nil ];
                
            if ( tac == 3 ) {
                char        *dest = decode( targv[ 2 ] );
                
                [ dict setObject: [ NSString stringWithUTF8String: dest ] forKey: @"dest" ];
            }
            
            break;
            
        case '0':
            /* apply-able transcript header line, e.g., 'baseload-stuff.T:' */
            dict =
                [ NSMutableDictionary dictionaryWithObjectsAndKeys:
                [ NSString stringWithFormat: @"%d", index ], @"tindex",
                @"0", @"type",
                [ NSString stringWithUTF8String: line ], @"path",
                [ NSString stringWithFormat: @"%c", plusminus ], @"pm", nil ];
            break;

        default:
            dict = nil;
            break;
        }
    }
    
    return( dict );
}

+ ( NSMutableDictionary * )dictionaryForLine: ( NSString * )line
{
    int			tac, conv, len;
    char		**targv;
    char		type;
    char		buf[ MAXPATHLEN * 2 ] = { 0 };
    char		l[ MAXPATHLEN * 2 ] = { 0 };
    NSMutableDictionary	*dict;
    CFRange             range = { 0, 0 };
        
    if ( [ line characterAtIndex: 0 ] == '\n' ) {
        return( nil );
    }
    
    range.length = ( CFIndex )[ line length ];
    
    /*
     * this is faster than -UTF8String, since
     * -UTF8String might need to allocate a buffer
     * when called.
     */
    if ( CFStringGetBytes(( CFStringRef )line, range,
            kCFStringEncodingUTF8, '?',
            FALSE, ( UInt8 * )buf, MAXPATHLEN * 2, ( CFIndex * )&conv ) == 0 ) {
        NSLog( @"CFStringGetBytes for %@ failed", line );
        return( nil );
    }
    
    len = strlcpy( l, buf, ( MAXPATHLEN * 2 ));
    tac = argcargv( buf, &targv );

    if ( tac < 0 ) {
        return( nil ); /* sanity check */
    }
    
    if ( tac > 1 && isknowntype( *targv[ 0 ] )) {
        switch ( *targv[ 0 ] ) {
        case '-':
        case '+':
            type = *targv[ 1 ];
            break;
        
        default:
            type = *targv[ 0 ];
            break;
        }
    } else {
        type = '0';
    }

    dict = [ NSMutableDictionary dictionaryForType: type
                        atTIndex: 0
                        withArgc: tac
                        withArgv: targv
                        line: l ];
    
    return( dict );
}

@end
