#include <sys/types.h>
#include <sys/param.h>
#include <sys/sysctl.h>
#include <sys/time.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <paths.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "srvprocinfo.h"

    int
get_srv_procinfo( char *procinfo, int infolen, pid_t *epid )
{
    char		*procname = "radmind", *curproc = NULL;
    char		timestr[ MAXPATHLEN ];
    pid_t		pid, ppid, srvpid = -1;
    size_t		bufsize = 0, numproc = 0;
    struct kinfo_proc	*kp;
    struct timeval	tv;
    struct tm		*tm;
    unsigned int	children = 0;
    int			err = 0, i = 0;
    int			mib[ 6 ] = { CTL_KERN, KERN_PROC, KERN_PROC_ALL,
								0, 0, 0 };

    if (( err = sysctl( mib, 3, NULL, &bufsize, NULL, 0 )) != 0 ) {
	fprintf( stderr, "sysctl failed: %s (%d)\n", strerror( errno ), err );
	return( -1 );
    }

    if (( kp = ( struct kinfo_proc * )malloc( bufsize )) == NULL ) {
	perror( "malloc" );
	return( -1 );
    }

    if (( err = sysctl( mib, 3, kp, &bufsize, NULL, 0 )) != 0 ) {
	fprintf( stderr, "sysctl failed: %s (%d)\n", strerror( errno ), err );
	free( kp );
	return( -1 );
    }

    numproc = bufsize / sizeof( struct kinfo_proc );

    for ( i = 0; i < numproc; i++ ) {
	if (( pid = kp[ i ].kp_proc.p_pid ) <= 0 ) {
	    continue;
	}

	if (( curproc = kp[ i ].kp_proc.p_comm ) == NULL ) {
	    continue;
	}

	if ( strncmp( procname, curproc, MAXCOMLEN ) == 0 ) {
	    /* we want the parent radmind server process */
	    if (( ppid = kp[ i ].kp_eproc.e_ppid ) == 1 ) {
		srvpid = pid;

		/* get start time of process */
		tv = kp[ i ].kp_proc.p_starttime;
		tm = localtime(( time_t * )&tv.tv_sec );
		if ( strftime( timestr, MAXPATHLEN, "%e %b %R %Y", tm ) == 0 ) {
		    if ( snprintf( timestr, MAXPATHLEN, "%u",
				( unsigned int )tv.tv_sec ) >= MAXPATHLEN ) {
			snprintf( timestr, MAXPATHLEN, "0" );
		    }           
		} 

		break;
	    } else {
		children++;
	    }
	}
    }

    if ( kp != NULL ) {
	free( kp );
    }

    if ( srvpid == -1 ) { /* server isn't running */
	if ( snprintf( procinfo, infolen, "%s is stopped.", procname )
			>= infolen ) {
	    fprintf( stderr, "String too long\n" );
	}
	return( 0 );
    }

    if ( snprintf( procinfo, infolen, "pid %d, %d %s connected\n Started %s",
                    srvpid, children, ( children == 1 ? "client" : "clients" ),
                    timestr ) >= infolen ) {
	fprintf( stderr, "procinfo too long\n" );
    }
    
    *epid = srvpid;
		
    return( 1 );
}
