#include <sys/types.h>
#include <sys/param.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>

#include "radpaths.h"

    int
radpathconv( char *src, char *dest, char *oldkey,
			char *newkey, unsigned int len )
{
    char	abspath[ MAXPATHLEN ];
    char	*p = NULL, *relpath = NULL;

    if ( strlen( src ) >= sizeof( abspath )) {
	fprintf( stderr, "%s: too long\n", src );
	goto error;
    }
    strcpy( abspath, src );

    if (( p = strstr( abspath, oldkey )) == NULL ) {
	fprintf( stderr, "No \"%s\" in %s\n", oldkey, abspath );
	goto error;
    }

    if (( relpath = strchr( p, '/' )) == NULL ) {
	fprintf( stderr, "No '/' in %s\n", p );
	goto error;
    }

    *p = '\0';

    if ( snprintf( dest, len, "%s%s%s", abspath, newkey, relpath ) >= len ) {
	fprintf( stderr, "%s%s%s: path too long\n", abspath, newkey, relpath );
	goto error;
    }

    return( 0 );

error:
    return( -1 );
}

    int
fpath2tpath( char *fpath, char *tpath, unsigned int len )
{
    return( radpathconv( fpath, tpath, "file", "transcript", len ));
}

    int
tpath2fpath( char *tpath, char *fpath, unsigned int len )
{
    return( radpathconv( tpath, fpath, "transcript", "file", len ));
}
