/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */
 
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "makedir.h"
#include "radpaths.h"

extern int	errno;

/*
 * create a directory with default permissions.
 * exit if an error other than EEXIST occurs
 */
    void
makedir( char *dirpath )
{
    if ( mkdir( dirpath, 0755 ) < 0 ) {
	if ( errno != EEXIST ) {
	    fprintf( stderr, "mkdir %s: %s\n", dirpath, strerror( errno ));
	    exit( errno );
	}
    }
}

/*
 * make a new subdirectory for loadsets
 * given a path in _RADMIND_DIR/transcript
 *
 * return values:
 * 0: success
 * 1: error
 */
    int
newsubdir( char *tdirpath )
{
    char	fdirpath[ MAXPATHLEN ];

    if ( tpath2fpath( tdirpath, fdirpath, MAXPATHLEN ) != 0 ) {
	return( 1 );
    }

    makedir( tdirpath );
    makedir( fdirpath );

    return( 0 );
}
