/* RSMPreferences */

#import <Cocoa/Cocoa.h>

#include <sys/types.h>

@class RASTableView;

@interface RSMPreferences : NSObject
{
    IBOutlet NSPanel	    *rsmPrefWindow;
    IBOutlet NSTabView      *rsmPrefTabView;
    
    /* server settings pane */
    IBOutlet NSBox	    *rsmPrefServerPaneBox;
	IBOutlet NSButton       *rsmPrefAllowedUsersButton;
	IBOutlet NSPanel	*rsmPrefAllowedUsersPanel;
	IBOutlet RASTableView   *rsmPrefAllowedUsersTable;
	IBOutlet NSPopUpButton	*rsmPrefCompressionLevelPopUp;
	IBOutlet NSTextField    *rsmPrefMaxConnections;
	IBOutlet NSTextField    *rsmPrefRadmindDirectory;
	IBOutlet NSTextField    *rsmPrefRadmindPort;
	IBOutlet NSTextField    *rsmPrefRadmindUmask;
	IBOutlet NSButton       *rsmPrefRendezvousSwitch;
	IBOutlet NSTextField    *rsmPrefServerProcessInfo;
	IBOutlet NSTextField    *rsmPrefServerStatusField;
	IBOutlet NSButton       *rsmPrefServerStartStopButton;
	IBOutlet NSPopUpButton  *rsmPrefSSLLevel;
	IBOutlet NSButton       *rsmPrefUserAuthenticationSwitch;
    
    /* general pane */
    IBOutlet NSBox	    *rsmPrefGeneralPaneBox;
	IBOutlet NSMatrix   *rsmPrefCaseSensitivityMatrix;
	
    /* advanced pane */
    IBOutlet NSBox	    *rsmPrefAdvancedPaneBox;
	IBOutlet NSButton	*rsmPrefDefineRightsSwitch;
	IBOutlet NSTextField    *rsmPrefTimeoutField;
	IBOutlet NSStepper	*rsmPrefTimeoutStepper;
    
@private
    BOOL                    _rsmServerIsRunning;
    pid_t                   _rsmServerPID;
    NSTimer                 *_rsmServerStatusTimer;
    NSString		    *_rsmPrefsSessionTmpDir;
    NSMutableArray	    *_rsmPrefsAllowedUsers;
}

/* preference panel actions */
- ( IBAction )startRadmindServer: ( id )sender;
- ( IBAction )stopRadmindServer: ( id )sender;
- ( IBAction )toggleUserAuthentication: ( id )sender;
- ( IBAction )editAllowedUsers: ( id )sender;
- ( IBAction )saveAllowedUsers: ( id )sender;
- ( IBAction )addAllowedUser: ( id )sender;
- ( IBAction )removeAllowedUser: ( id )sender;
- ( IBAction )dismissAllowedUsersPanel: ( id )sender;
- ( IBAction )setRadmindDirectoryPath: ( id )sender;
- ( IBAction )setRadmindPort: ( id )sender;
- ( IBAction )setMaxConnections: ( id )sender;
- ( IBAction )setUmask: ( id )sender;
- ( IBAction )setCaseSensitivity: ( id )sender;
- ( IBAction )setCompressionLevel: ( id )sender;

- ( IBAction )toggleSessionRights: ( id )sender;
- ( IBAction )setAuthorizationTimeout: ( id )sender;

/* authorization handler */
- ( void )doAuthorizedTask: ( NSArray * )authorizedTaskParameters
            rightName: ( char * )rightName;

/* misc methods to assist display of prefs */
- ( void )showPreferencesPanel;
- ( void )preferencesError: ( NSString * )fmt, ...;
- ( void )refreshServerStatusDisplay;
- ( void )reloadDefaults;
- ( void )toolbarSetup;

/* server status accessor methods */
- ( BOOL )serverIsRunning;
- ( void )setServerIsRunning: ( BOOL )running;
- ( pid_t )serverPID;
- ( void )setServerPID: ( pid_t )pid;
- ( NSString * )sessionTemporaryDirectory;
- ( void )setSessionTemporaryDirectory: ( NSString * )path;
- ( NSMutableArray * )allowedUsers;
- ( void )setAllowedUsers: ( NSMutableArray * )users;

@end
