#import "RSMLogger.h"

@implementation RSMLogger

- ( void )awakeFromNib
{
    [ rsmLoggerTextView setString: @"" ];
    [ rsmLoggerTextView setContinuousSpellCheckingEnabled: NO ];
    [ rsmLoggerTextView setEditable: NO ];
}

- ( void )addText: ( NSString * )text isError: ( BOOL )error
{
    NSMutableAttributedString   *attr = nil;
    NSColor                     *color = nil;
    
    if ( [ text isEqualToString: @"" ] || [ text length ] == 0 ) {
        return;
    }
    
    if ( error ) {
        color = [ NSColor redColor ];
    } else {
        color = [ NSColor blackColor ];
    }
    
    attr = [[ NSMutableAttributedString alloc ] initWithString: text ];
    
    [ rsmLoggerTextView setEditable: YES ];
    [ rsmLoggerTextView setSelectedRange:
                NSMakeRange( [[ rsmLoggerTextView textStorage ] length ], 0 ) ];
                
    [ attr beginEditing ];
    [ attr addAttribute: NSForegroundColorAttributeName
            value: color
            range: [ text rangeOfString: text ]];
    [ attr endEditing ];
    
    [ rsmLoggerTextView insertText: attr ];
    [ rsmLoggerTextView setEditable: NO ];
    
    [ attr release ];
}

- ( void )showLogWindow: ( id )sender
{
    [ rsmLoggerWindow makeKeyAndOrderFront: nil ];
}

@end
