/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import <Cocoa/Cocoa.h>
#import "RASTableView.h"

#define SERVERCONF	@"/var/radmind/config"

#define RASToolbarRefreshIdentifier		@"refresh"
#define RASToolbarSaveConfigIdentifier		@"saveconfig"
#define RSMToolbarNewClientIdentifier		@"newclient"
#define RSMToolbarDeleteClientIdentifier	@"deleteclient"
#define RSMToolbarToggleCommentIdentifier       @"RSMToggleComment"
#define RSMToolbarNewCommentIdentifier          @"RSMNewComment"

@class RAServerAuth;
@class RSMLoadsetEditor;
@class RSMLoadsetManager;
@class RSMPreferences;

@interface RAServerController : NSObject
{
    IBOutlet RASTableView	*hostsTable;
    IBOutlet NSWindow 		*serverWindow;
    
    IBOutlet NSPanel		*gatheringSheet;
    IBOutlet NSProgressIndicator	*gatheringProgBar;
    
    IBOutlet RSMLoadsetEditor	*loadsetEditor;
    IBOutlet RSMLoadsetManager	*loadsetManager;
    
@private
    RAServerAuth		*sa;
    RSMPreferences              *prefs;
    NSMutableArray		*serverConfig;
    NSArray			*_allCommandFiles;
    BOOL			_isConfigFileEdited;
    NSMutableArray		*_validClients;
    int				dragOriginRow;
    int                         _rsmThreadID;
    NSString			*_rsmTmpDirectory;
    
    /* DO */
    NSConnection		*connectionToServerAuth;
}

/* preferences */
- ( IBAction )showPreferences: ( id )sender;

/* config file actions */
- ( IBAction )addNewClientToConfigFile: ( id )sender;
- ( IBAction )deleteClientFromConfigFile: ( id )sender;
- ( IBAction )saveConfigFile: ( id )sender;

- ( int )configHelperThreadID;
- ( void )setConfigHelperThreadID: ( int )ID;

- ( BOOL )isConfigFileEdited;
- ( void )setConfigFileEdited: ( BOOL )edit;

- ( int )dragOriginRow;
- ( void )setDragOriginRow: ( int )row;

- ( void )setCommandFileList: ( NSMutableArray * )commandFiles;
- ( NSArray * )availableCommandFiles;

- ( NSArray * )validClients;
- ( void )addToValidClients: ( NSString * )client;
- ( void )removeFromValidClients: ( NSString * )client;

- ( void )setSessionTmpDirectory: ( NSString * )tmpdir;
- ( NSString * )sessionTmpDirectory;

- ( void )setupCommandFilePopupButtons;
- ( void )toolbarSetup;
- ( IBAction )reloadServerInformation: ( id )sender;
- ( oneway void )firstServerInfoLoad;
- ( void )setServer: ( id )serverObject andThreadID: ( int )threadID;

- ( oneway void )command: ( int )cmd finishedWithStatus: ( int )status
                                inThread: ( int )ID;
- ( void )loadServerInfoWithCommand: ( int )cmd arguments: ( NSArray * )args;
- ( void )readRadmindServerConfigFile;

- ( void )toolError: ( char * )error fromThreadWithID: ( int )ID;
- ( void )authorizationFailedInThreadWithID: ( int )ID;

- ( oneway void )setCurrentCommandPID: ( pid_t )pid threadID: ( int )ID;

@end

/* delegate methods */
@interface NSObject(RAServerController)
- ( NSString * )sessionTmpDirectory;
@end
