/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */
 
#import <AppKit/AppKit.h>


@interface RASTableView : NSTableView
{
@private
    int			rClickedRow;
    BOOL		_drawsStripes;
    int			_umTableViewDragColumn;
}

- ( BOOL )drawsStripes;
- ( void )setDrawsStripes: ( BOOL )stripes;

- ( int )dragColumn;
- ( void )setDragColumn: ( int )column;

- ( int )rClickedRow;


@end

@interface NSObject(RASTableViewDelegate)

- ( NSMenu * )menuForTable: ( RASTableView * )table
                tableColumn: ( int )column row: ( int )row;
- ( BOOL )handleKeyEvent: ( NSEvent * )theEvent fromTable: ( id )tableView;
- ( void )handleChangedText: ( NSString * )string forTable: ( id )tableView;

@end