#import "RAOutlineView.h"

@implementation RAOutlineView

- ( id )init
{
    self = [ super init ];
    _rsmOutlineViewClickTimer = nil;
    _rsmLastSelectedRow = -1;
    
    return( self );
}

- ( void )restartClickTimer
{
    _rsmOutlineViewClickTimer = [ NSTimer scheduledTimerWithTimeInterval: 1.0
					    target: self
					    selector: @selector( timerBeginEditingName: )
					    userInfo: nil
					    repeats: NO ];
}

- ( void )clearClickTimer
{
    if ( _rsmOutlineViewClickTimer != nil ) {
	[ _rsmOutlineViewClickTimer invalidate ];
    }
    _rsmOutlineViewClickTimer = nil;
    
    [ self setLastSelectedRow: -1 ];
}

- ( int )lastSelectedRow
{
    return( _rsmLastSelectedRow );
}

- ( void )setLastSelectedRow: ( int )row
{
    _rsmLastSelectedRow = row;
}

/* workaround for tablecolumn bug, which always draws its cells' backgrounds */
- ( void )awakeFromNib
{
    NSArray			*columns = [ self tableColumns ];
    id				cell = nil;
    int				i;
    
    _drawsStripes = NO;
    
    for ( i = 0; i < [ columns count ]; i++ ) {
        cell = [[ columns objectAtIndex: i ] dataCell ];
        
        if ( [ cell isKindOfClass: [ NSTextFieldCell class ]] ) {
            [ cell setDrawsBackground: NO ];
            [ cell setFont: [ NSFont systemFontOfSize: 12.0 ]];
        }
    }
}

#ifdef notdef
- ( void )dragImage: ( NSImage * )anImage at: ( NSPoint )imageLoc offset: ( NSSize )mouseOffset
        event: ( NSEvent * )theEvent pasteboard: ( NSPasteboard * )pboard source: ( id )sourceObject
        slideBack: ( BOOL )slideBack
{
    int                 row = [ self rowAtPoint: imageLoc ];
    int                 column = [ self columnAtPoint: imageLoc ];
    NSRect		imageframe = [ self frameOfCellAtColumn: column row: row ];
    float		width = NSWidth( imageframe );
    float		height = NSHeight( [ self bounds ] );
    NSSize		imagesize = NSMakeSize( width, height );
    NSImage		*image = [[ NSImage alloc ] initWithSize: imagesize ];
    
    /* only draw the portion from the filename column */
    [ image lockFocus ];
    //[[ NSColor blueColor ] set ];
    //NSRectFill( imageframe );
    [ anImage dissolveToPoint: NSZeroPoint fraction: 1.0 ];
    [ image unlockFocus ];

    [ super dragImage: image at: imageLoc offset: mouseOffset
            event: theEvent pasteboard: pboard source: sourceObject
            slideBack: slideBack ];
    [ image release ];
}
#endif notdef

#ifdef notdef
- ( NSMenu * )menuForEvent: ( NSEvent * )event
{
    NSPoint	p = [ self convertPoint: [ event locationInWindow ]
                            fromView: nil ];
    int		column = [ self columnAtPoint: p ];
    int		row = [ self rowAtPoint: p ];
    
    rClickedRow = 0;
    
    if ( column == 0 && row >= 0  &&
        [[ self delegate ] respondsToSelector:
                @selector( menuForTable: tableColumn: row: ) ] ) {
        rClickedRow = row;
        [ self selectRow: row byExtendingSelection: NO ];
        [[ self window ] makeFirstResponder: self ];
        return( [[ self delegate ] menuForTable: self
                                    tableColumn: column
                                    row: row ] );
    }
    return( nil );
}
#endif notdef

- ( int )rClickedRow
{
    return( rClickedRow );
}

- ( void )timerBeginEditingName: ( NSTimer * )timer
{
    int		row = [ self selectedRow ];
    id		cell;

    if ( row < 0 ) {
	return;
    }

    cell = [[[ self tableColumns ] objectAtIndex: 0 ]
		dataCellForRow: row ];

    [ cell setEditable: YES ];
    [ cell setScrollable: YES ];
    [ self selectRow: row byExtendingSelection: NO ];

    [ self editColumn: 0 row: row
	    withEvent: nil
	    select: YES ];

    _rsmOutlineViewClickTimer = nil;
}

- ( void )keyDown: ( NSEvent * )event
{
    if ( [[ self delegate ] respondsToSelector: @selector( handleKeyEvent:fromTable: ) ] ) {
        if ( [[ self delegate ] handleKeyEvent: event fromTable: self ] ) {
            return;
        }
    }
    
    [ super keyDown: event ];
}

- ( void )textDidEndEditing: ( NSNotification * )aNotification
{
    int			tm = [[[ aNotification userInfo ]
				objectForKey: @"NSTextMovement" ] intValue ];
    
    if ( tm == NSReturnTextMovement || tm == NSTabTextMovement ) {
	NSMutableDictionary	*newUserInfo;
	NSNotification		*newNotification;
	
        if ( [[ self dataSource ] respondsToSelector:
		    @selector( handleChangedText:forTable: ) ] ) {
            [[ self dataSource ]
		    handleChangedText: [[ aNotification object ] string ]
		    forTable: self ];
        }
        
	newUserInfo = [ NSMutableDictionary dictionaryWithDictionary:
				[ aNotification userInfo ]];
	[ newUserInfo setObject:
		    [ NSNumber numberWithInt: NSIllegalTextMovement ]
		    forKey: @"NSTextMovement" ];
	newNotification = [ NSNotification
				notificationWithName: [ aNotification name ]
				object: [ aNotification object ]
				userInfo: newUserInfo ];
		
	[ super textDidEndEditing: newNotification ];
        [[ self window ] makeFirstResponder: self ];
	return;
    }
    
    [ super textDidEndEditing: aNotification ];
}

@end
