/* RAOutlineView */

#import <Cocoa/Cocoa.h>

@interface RAOutlineView : NSOutlineView
{
@private
    NSTimer		*_rsmOutlineViewClickTimer;
    int			rClickedRow;
    int			_rsmLastSelectedRow;
    BOOL		_drawsStripes;
}

- ( int )rClickedRow;

- ( void )restartClickTimer;
- ( void )clearClickTimer;
- ( int )lastSelectedRow;
- ( void )setLastSelectedRow: ( int )row;

@end

@interface NSObject(RAOutlineViewDelegate)

- ( NSMenu * )menuForTable: ( RAOutlineView * )table
                tableColumn: ( int )column row: ( int )row;
- ( BOOL )handleKeyEvent: ( NSEvent * )theEvent fromTable: ( id )tableView;
- ( void )handleChangedText: ( NSString * )string forTable: ( id )tableView;

@end
