#include <sys/types.h>
#include <sys/param.h>
#include <sys/sysctl.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "pidforname.h"

/*
 * retrieve a process id number for a given process name
 */
    pid_t
pidforname( char *name )
{
    char		*procname = NULL;
    pid_t		pid;
    int			err = 0, i = 0;
    size_t		bufsize = 0, numproc = 0;
    struct kinfo_proc	*kp;
    int			mib[ 6 ] = { CTL_KERN, KERN_PROC, KERN_PROC_ALL,
								0, 0, 0 };

    if (( err = sysctl( mib, 3, NULL, &bufsize, NULL, 0 )) != 0 ) {
	fprintf( stderr, "sysctl failed: %s (%d)\n", strerror( errno ), err );
	exit( 2 );
    }

    if (( kp = ( struct kinfo_proc * )malloc( bufsize )) == NULL ) {
	perror( "malloc" );
	exit( 2 );
    }

    if (( err = sysctl( mib, 3, kp, &bufsize, NULL, 0 )) != 0 ) {
	fprintf( stderr, "sysctl failed: %s (%d)\n", strerror( errno ), err );
	exit( 2 );
    }

    numproc = bufsize / sizeof( struct kinfo_proc );

    for ( i = 0; i < numproc; i++ ) {
	if (( pid = kp[ i ].kp_proc.p_pid ) <= 0 ) {
	    continue;
	}

	if (( procname = kp[ i ].kp_proc.p_comm ) == NULL ) {
	    continue;
	}

	if ( strncmp( procname, name, MAXCOMLEN ) == 0 ) {
	    free( kp );
	    return( pid );
	}
    }

    if ( kp != NULL ) {
	free( kp );
    }

    return( -1 );
}
