/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import <Cocoa/Cocoa.h>

#import "RACertificateManager.h"
#import "RAScriptManager.h"

#define RAPrefToolbarGeneralIdentifier		@"RAGeneralPrefs"
#define RAPrefToolbarSecurityIdentifier		@"RASecurityPrefs"
#define RAPrefToolbarTranscriptIdentifier	@"RATranscriptPrefs"
#define RAPrefToolbarAdvancedIdentifier		@"RAAdvancedPrefs"
#define RAPrefToolbarAutomationIdentifier	@"RAAutomationPrefs"
#define RAPrefToolbarUserManagmentIdentifier    @"RAUserManagementPrefs"

@interface RCMPreferences : NSObject
{
    IBOutlet NSPanel 		*prefPanel;
    IBOutlet NSBox		*contentBox;
    
    /* add radmind default server sheet */
    IBOutlet NSPanel		*prefNewServerSheet;
    IBOutlet NSTextField	*prefNewServerField;
    IBOutlet NSButton		*prefNewServerAddButton;
    
    /* edit radmind server list sheet */
    IBOutlet NSPanel		*prefEditRadmindListSheet;
    IBOutlet NSButton		*prefDeleteRadmindServerButton;
    IBOutlet NSTableView	*prefRadmindServerTable;
    IBOutlet NSBox		*prefRadmindServerSettingBox; 
    IBOutlet NSTextField	*prefRadmindServerSettingPort;
    IBOutlet NSPopUpButton	*prefRadmindServerSettingCompressionLevel;
    
    /* general prefs view */
    IBOutlet NSView		*generalPrefsView;
    IBOutlet NSMatrix 		*prefGlobalCksum;
    IBOutlet NSPopUpButton 	*prefRadmindHost;
    IBOutlet NSTextField	*prefServerCompressionSummary;
    IBOutlet NSTextField	*prefServerPortSummary;
    IBOutlet NSButton		*prefEnableRadmindUpdateMonitor;
    IBOutlet NSButton		*prefLapplyForce;
    IBOutlet NSButton		*prefIgnoreLcreateErrors;
    IBOutlet NSButton		*prefAlwaysPreApply;
    IBOutlet NSButton		*prefAlwaysPostApply;
    
    /* security prefs view */
    IBOutlet NSView		*securityPrefsView;
    IBOutlet NSPopUpButton	*prefTLSLevel;
    IBOutlet NSButton		*prefEnableUserAuth;
    IBOutlet NSTextField	*prefUserAuthName;
    
    /* transcript prefs view */
    IBOutlet NSView		*transcriptPrefsView;
    IBOutlet NSPopUpButton	*prefFsdiffPath;
    IBOutlet NSPopUpButton	*prefTransEditor;
    IBOutlet NSPopUpButton	*prefCaseSensitivityPopUp;
    
    /* automation prefs view */
    IBOutlet NSView		*automationPrefsView;
    IBOutlet NSButton		*autoEnableScheduleSwitch;
    IBOutlet NSPopUpButton	*autoSchedulePopUpButton;
    IBOutlet NSButton		*autoEnableLoginHookSwitch;
    IBOutlet NSButton		*autoEnableLogoutHookSwitch;
    IBOutlet NSButton		*autoContinueIfInterruptedSwitch;
    
    /* user management view */
    IBOutlet NSView             *userManagementView;
    IBOutlet NSButton           *prefUserManagementSwitch;
    IBOutlet NSTextField        *prefTemplateUserNameField;
    IBOutlet NSTextField        *prefMaxHomeLifeField;
    IBOutlet NSTextField        *prefMaxDiskUsageField;
    
    /* advanced prefs view */
    IBOutlet NSView		*advancedPrefsView;
    IBOutlet NSTextField        *prefGlobalPreferencesDateField;
    
@private
    NSMutableArray		*radmindServerList;
    RACertificateManager	*certificateManager;
    RAScriptManager		*scriptManager;
}

- ( IBAction )showGeneralPreferences: ( id )sender;
- ( IBAction )showAutomationPreferences: ( id )sender;

- ( IBAction )chooseAlternateEditor: ( id )sender;

/* general prefs actions */
- ( IBAction )setDefaultServer: ( id )sender;
- ( IBAction )setPort: ( id )sender;
- ( IBAction )setUseChecksums: ( id )sender;
- ( IBAction )toggleForceLockRemoval: ( id )sender;
- ( IBAction )toggleIgnoreUploadErrors: ( id )sender;
- ( IBAction )toggleAlwaysPreApplySwitch: ( id )sender;
- ( IBAction )toggleAlwaysPostApplySwitch: ( id )sender;
- ( IBAction )manageScripts: ( id )sender;

/* radmind update monitor actions and associated methods */
- ( IBAction )toggleRadmindUpdateMonitor: ( id )sender;
- ( void )enableRadmindUpdateMonitor;
- ( void )disableRadmindUpdateMonitor;

/* security prefs actions */
- ( IBAction )toggleUserAuth: ( id )sender;
- ( IBAction )setUsername: ( id )sender;
- ( IBAction )setTLSLevel: ( id )sender;
- ( IBAction )manageCertificates: ( id )sender;

/* transcript prefs actions */
- ( IBAction )setTranscriptEditor: ( id )sender;
- ( IBAction )setFsdiffPath: ( id )sender;
- ( IBAction )setCaseSensitivity: ( id )sender;

/* automation configuration actions */
- ( IBAction )toggleEnableScheduleSwitch: ( id )sender;
- ( IBAction )visitiHookHomepage: ( id )sender;
- ( IBAction )setAutomationConfiguration: ( id )sender;

/* user management actions */
- ( IBAction )toggleUserManagement: ( id )sender;
- ( IBAction )saveUserManagementSettings: ( id )sender;

/* advanced prefs actions */
- ( IBAction )setGlobalPreferences: ( id )sender;

- ( void )prefsReload;
- ( NSPanel * )prefPanel;

- ( IBAction )editRadmindServerList: ( id )sender;
- ( IBAction )setCompressionLevel: ( id )sender;
- ( IBAction )addRadmindServerToTable: ( id )sender;
- ( IBAction )deleteRadmindServerFromTable: ( id )sender;
- ( IBAction )okEditServerTable: ( id )sender;

@end
