/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "RASTableView.h"

@implementation RASTableView

- ( void )dragImage: ( NSImage * )anImage at: ( NSPoint )imageLoc offset: ( NSSize )mouseOffset
        event: ( NSEvent * )theEvent pasteboard: ( NSPasteboard * )pboard
	source: ( id )sourceObject slideBack: ( BOOL )slideBack
{
    NSTableColumn	*column = [[ self tableColumns ] objectAtIndex: 0 ];
    float		width = [ column width ];
    float		height = 16.0;
    NSImage		*image = nil;
    NSView		*view;
    
    if (( view = [[ self superview ] superview ] ) == nil ) {
	view = self;
    }
    height = NSHeight( [ view frame ] );

    image = [[ NSImage alloc ] initWithSize: NSMakeSize( width, height ) ];

    /* only draw the portion from the filename column */
    [ image lockFocus ];
    [ anImage dissolveToPoint: NSZeroPoint fraction: 1.0 ];
    [ image unlockFocus ];
    
    [ super dragImage: image
	    at: imageLoc 
	    offset: mouseOffset
	    event: theEvent
	    pasteboard: pboard
	    source: sourceObject
	    slideBack: slideBack ];
	    
    [ image release ];
}

- ( NSMenu * )menuForEvent: ( NSEvent * )event
{
    NSPoint	p = [ self convertPoint: [ event locationInWindow ]
                            fromView: nil ];
    int		column = [ self columnAtPoint: p ];
    int		row = [ self rowAtPoint: p ];
    
    rClickedRow = 0;
    
    if ( column == 0 && row >= 0  &&
        [[ self delegate ] respondsToSelector:
                @selector( menuForTable: tableColumn: row: ) ] ) {
        rClickedRow = row;
        return( [[ self delegate ] menuForTable: self
                                    tableColumn: column
                                    row: row ] );
    }
    return( nil );
}

- ( int )rClickedRow
{
    return( rClickedRow );
}

- ( NSDragOperation )draggingSourceOperationMaskForLocal: ( BOOL )isLocal
{
    return( NSDragOperationCopy );
}

- ( void )textDidEndEditing: ( NSNotification * )aNotification
{
    int			tm = [[[ aNotification userInfo ]
				objectForKey: @"NSTextMovement" ] intValue ];
    
    if ( tm == NSReturnTextMovement || tm == NSTabTextMovement ) {
	NSMutableDictionary	*newUserInfo;
	NSNotification		*newNotification;
	
        if ( [[ self dataSource ] respondsToSelector:
		    @selector( handleChangedText:forTable: ) ] ) {
            [[ self dataSource ]
		    handleChangedText: [[ aNotification object ] string ]
		    forTable: self ];
        }
        
	newUserInfo = [ NSMutableDictionary dictionaryWithDictionary:
				[ aNotification userInfo ]];
	[ newUserInfo setObject:
		    [ NSNumber numberWithInt: NSIllegalTextMovement ]
		    forKey: @"NSTextMovement" ];
	newNotification = [ NSNotification
				notificationWithName: [ aNotification name ]
				object: [ aNotification object ]
				userInfo: newUserInfo ];
		
	[ super textDidEndEditing: newNotification ];
        [[ self window ] makeFirstResponder: self ];
	return;
    }
    
    [ super textDidEndEditing: aNotification ];
}

@end
