/*
 * Copyright (c) 2006 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "RAEditorLauncher.h"

@implementation RAEditorLauncher

+ ( RAEditorLauncher * )sharedInstance
{
    static RAEditorLauncher       *sharedInstance = nil;
   
    if ( !sharedInstance ) {
        sharedInstance = [[ RAEditorLauncher alloc ] init ];
    }

    return( [ sharedInstance autorelease ] );
}

- ( BOOL )viewTrans: ( NSString * )tPath withTextEditor: ( NSString * )editor
{
    NSUserDefaults		*defaults;
    NSArray			*altEditors;
    NSString			*bundleID = @"edu.umich.radmindtranscripteditor";
    NSString			*rtepath;
    NSAppleScript               *as = nil;
    NSDictionary                *errorDictionary = nil;
    NSString                    *scriptSource = nil;
    int				i;
    
    if ( [ editor isEqualToString: @"Radmind Transcript Editor" ] ) {
	if (( rtepath = [[ NSWorkspace sharedWorkspace ]
		    absolutePathForAppBundleWithIdentifier: bundleID ] ) == nil ) {
	    rtepath = [[ NSBundle mainBundle ]
			pathForResource: editor ofType: @"app" ];
	    if ( rtepath == nil ) {
		NSRunAlertPanel( NSLocalizedString( @"Error", @"Error" ),
			NSLocalizedString(
				@"Couldn't locate the Radmind Transcript Editor",
				@"Couldn't locate the Radmind Transcript Editor" ),
			NSLocalizedString( @"OK", @"OK" ), @"", @"" );
		return( NO );
	    }
	}

        if ( tPath == nil ) {
            if ( ![[ NSWorkspace sharedWorkspace ] openFile: rtepath ] ) {
                NSRunAlertPanel( @"Couldn't launch Radmind Transcript Editor",
                            @"", @"OK", @"", @"" );
                return( NO );
            }
            return( YES );
        }
        /*
	 * this fails if tPath isn't readable by the user.
	 * should use NSWorkspace's launchAppWithBundleIdentifier...
	 * and pass doc path as part of paramdescriptor
	 */
        if ( ![[ NSWorkspace sharedWorkspace ] openFile: tPath
                            withApplication: rtepath
                            andDeactivate: YES ] ) {
            NSRunAlertPanel( @"Error launching editing session.",
                            @"Couldn't launch Radmind Transcript Editor",
                            @"OK", @"", @"" );
            return( NO );
        }
    
        return( YES );
    }
    
    defaults = [ NSUserDefaults standardUserDefaults ];
    altEditors = [ defaults objectForKey: @"alteditors" ];
    
    for ( i = 0; i < [ altEditors count ]; i++ ) {
        if ( [ editor isEqualToString: [[ altEditors objectAtIndex: i ]
                                                objectForKey: @"name" ]] ) {
            if ( ! [[ NSWorkspace sharedWorkspace ] openFile: tPath
                    withApplication: [[ altEditors objectAtIndex: i ]
                                            objectForKey: @"path" ]
                    andDeactivate: YES ] ) {
                NSRunAlertPanel( @"Error launching editing session.",
                    @"Couldn't launch %@", @"OK", @"", @"",
                        [[ altEditors objectAtIndex: i ] objectForKey: @"name" ] );
                return( NO );
            }
            return( YES );
        }
    }

    scriptSource = [ NSString stringWithFormat: 
			@"tell application \"Terminal\"\r"
			    @"activate\r"
			    @"do script \"/usr/bin/sudo %@ \\\"%@\\\"; exit\"\r"
			@"end tell", editor, tPath ];
    
    as = [[[ NSAppleScript alloc ] initWithSource: scriptSource ] autorelease ];
    if ( [ as executeAndReturnError: &errorDictionary ] == nil ) {
        NSLog( @"Failed to open terminal with AppleScript: %@",
                [ errorDictionary objectForKey: @"NSAppleScriptErrorMessage" ] );
        return( NO );
    }

    return( YES );
}

@end
