/* RACertificateManager */

#import <Cocoa/Cocoa.h>
#import <SecurityInterface/SFCertificatePanel.h>
#import <SecurityInterface/SFCertificateView.h>

#import "RASTableView.h"

@interface RACertificateManager : NSObject
{
    IBOutlet NSPanel		*certificatePanel;
    IBOutlet RASTableView	*certificateTable;
    
@private
    NSArray			*_raCertificateArray;
}

/* certificate dictionary accessor methods */
- ( void )setCertificateArray: ( NSArray * )array;
- ( NSArray * )certificateArray;

/* management actions */
- ( IBAction )installCertificates:( id )sender;
- ( void )installCertificate: ( NSString * )certificatePath;
- ( IBAction )removeCertificates: ( id )sender;
- ( IBAction )viewCertificates: ( id )sender;

/* display methods */
- ( void )showCertificateManagementPanelForWindow: ( NSWindow * )window;
- ( IBAction )dismissCertificateManagementPanel: ( id )sender;

@end
