\name{wl}
\alias{wl}
\alias{load}
\alias{ws}
\alias{rb}

\title{Load or Save a Workspace}
\description{
  Functions for loading and saving R workspaces.  \code{wl} is used to load a 
  workspace, \code{ws} is used to save a workspace, and \code{rb} is used to 
  load a backup version of the current workspace (automatic backup must be 
  enabled to use this feature, see the "Preferences" section of the \pkg{rNMR} 
  manual for more information).  Note: \code{wl} and performs the same function 
  as \code{load}.
}
\usage{
wl(fileName, plot=TRUE, clearAll = TRUE)
load(fileName, plot=TRUE, clearAll = TRUE)
ws(fileName)
rb()
}

\arguments{
  \item{fileName}{optional character string argument giving the full path to the
  file being loaded or saved.  A file selection window is opened if this
  argument is not provided.} 
  \item{plot}{logical; redraws the main spectrum on loading if \code{TRUE}.}
  \item{clearAll}{logical; clears previous objects from the global environment 
  before loading the workspace if \code{TRUE}.}
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{rNMR}} for other rNMR help topics.}

\keyword{file}