\name{tableEdit}
\alias{tableEdit}

\title{Table editing GUI}
\description{
  A GUI for editing and sorting tables.
}
\usage{
tableEdit(data, editable = rep(TRUE, ncol(data)),	title = 'rNMR', colVer = NULL, 
	errMsgs = rep(paste('Data type for new entry must',
	'match the data type for a given column.'), ncol(data)))
}

\arguments{
  \item{data}{data.frame or character string/vector; the table to sort/edit or
  a vector of valid file names.}
  \item{editable}{logical vector; indicates which columns may be edited, must
  be equal in length to the number of columns in \code{data}.}
  \item{title}{character string; the title for the GUI.}
  \item{colVer}{function list; functions, one for each column, used to verify 
  the entries in each column.  Functions should return \code{TRUE} or 
  \code{FALSE} and should be capable of vector operations.}
  \item{errMsgs}{character vector; error messages to display if functions in 
  \code{colVer} return \code{FALSE}, should be the same length as \code{colVer}.  
  If \code{NULL}, no error messages are displayed.}
}

\details{
  \code{tableEdit} displays a GUI for editing and sorting tables.  Tables must
  be valid data.frames with columns of equal length.  The \code{editable} 
  argument must be a logical vector indicating which columns in \code{data} may 
  be edited.  If any of the values in \code{editable} are \code{TRUE}, entries
  from the corresponding columns in \code{data} may be edited by clicking on a 
  table entry in the GUI.  To edit multiple entries, select the items in the 
  table you wish to edit, type your changes in the text box at the bottom of 
  the GUI, and press the \bold{Apply} button.  Rows in the table may be edited 
  using the options provided at the bottom of the GUI.
  
  Functions provided by the \code{colVer} argument will be used to verify the
  data in each column.  \code{colVer}, if provided, must be a list of functions
  that return \code{TRUE} or \code{FALSE}.  If a function returns \code{TRUE}, 
  the new entry(s) will be accepted and the table will be modified.  If 
  \code{FALSE}, the table will not be modified and a general error message will
  be displayed.  The \code{errMsgs} argument allows custom error messages to be
  displayed for each function.  Both of these arguments are optional, but if
  provided, they must have length equal to the number of columns in the table.  
  Before functions in \code{colVer} are applied, \code{tableEdit} attempts to 
  coerce entries in each column to a type matching that of the input table 
  (i.e. - if the entries in a given column were passed to \code{tableEdit} as 
  type \code{numeric}, \code{tableEdit} will attempt to coerce new entries to 
  \code{numeric}, returning \code{NA} for values that fail).  A practical 
  example of this functionality can be seen in the ROI table editor (see 
  \code{\link{re}}).
}

\value{
	If the \bold{OK} is pressed, the table will be returned with any modifications
	as a \code{data.frame} with column names matching those of the input table.  
	Note that the "significant figures" option within the GUI only affects how the 
	data is displayed, the values returned after pressing the \bold{OK} will 
	remain unchanged.  Pressing the \bold{Cancel} button will close the GUI and 
	return \code{NULL}.  Pressing the \bold{Export} button will save the data as a 
	tab-delimited text file, exactly as it appears in the table.
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{fs}} for sorting files;  \code{\link{re}} for editing 
and sorting ROIs; \code{\link{toolkit}} for other \pkg{rNMR} utility functions.}

\keyword{internal}