\name{roi}
\alias{roi}
\alias{ra}
\alias{rc}
\alias{rcd}
\alias{rci}
\alias{rdAll}
\alias{rDel}
\alias{re}
\alias{red}
\alias{rei}
\alias{rmd}
\alias{rml}
\alias{rmr}
\alias{rmu}
\alias{rn}
\alias{rr}
\alias{rs}
\alias{rsAll}
\alias{rsf}
\alias{rSum}
\alias{rv}
\alias{rvm}
\alias{rvs}
\alias{se}


\title{Regions of Interest (ROIs)}
\description{
  Functions for creating, changing, selecting, and displaying Regions of 
  Interest (ROIs).  \dfn{ROIs} are user designated subsections of a spectrum, 
  usually used to designate peaks.  ROIs are defined by a chemical shift range 
  and can be extracted from one or multiple spectra.
}
\usage{
roi()
rn(...)
ra(w1Delta = globalSettings$roi.w1, w2Delta = globalSettings$roi.w2, 
	p = globalSettings$roi.pad, noiseFilt = globalSettings$roi.noiseFilt, ...)

rc(massCenter = TRUE, inTable)
rmr(p = 1)
rml(p = 1)
rmu(p = 1)
rmd(p = 1)
rei(p = 1)
red(p = 1)
rci(p = 1)
rcd(p = 1)
re(table = NULL)

rr()
rs(preSel = NULL, parent = NULL,  ...)
rsf()
rsAll()
rdAll()
rDel(roiNames)

rSum(ask = TRUE, sumFiles, sumRois, sumType, normType = "none", normList = NA)

rv()
rvs(...)
rvm(...)

se(summary = NULL)
}

\arguments{
  \item{w1Delta}{positive numeric; the width of each ROI window in the indirect 
  dimension (in ppm).  If \code{NULL}, the width is chosen automatically based 
  on data observed in the window.}
  \item{w2Delta}{positive numeric; the width of each ROI window in the direct 
  dimension (in ppm).  If \code{NULL}, the width is chosen automatically based 
  on data observed in the window.}
  \item{p}{numeric; for the \code{ra} function, \code{p} is the padding 
  percentage to be added to peak widths in 2D spectra when creating ROIs.  For
  all other functions, \code{p} is the percentage of an ROI with which to move, 
  expand, or contract the ROI.}
  \item{table}{data.frame; an ROI table to edit.}
  \item{noiseFilt}{integer; either \code{0}, \code{1} or \code{2}.  \code{0} 
  does not apply a noise filter, \code{1} applies a mild filter (adjacent points 
  in the direct dimension must be above the noise threshold), and \code{2} 
  applies a strong filter (all adjacent points must be above the noise 
  threshold.}
  \item{massCenter}{logical; \code{TRUE} centers peaks by center of mass, 
  \code{FALSE} centers peaks by maximum signal observed.}
  \item{inTable}{Used internally by \pkg{rNMR}.}
  \item{preSel}{integer; bypasses user prompts and indicates the plot from 
  which ROIs will be selected.  \code{1} selects from a list, \code{2} from 
  the main plot window, \code{3} from the subplot window, and \code{4} from 
  the multiple file window.} 
  \item{parent}{optional Tk toplevel object to set as a parent window for a 
	newly created dialog.  If provided, the dialog will appear near its parent
	and will bring the parent toplevel object to the front.  This is 
	particularly useful for displaying message or error dialogs in response to
	user interactions within rNMR GUIs.}
	\item{roiNames}{character vector; names of ROIs to be deleted.}
	\item{ask}{logical; if \code{TRUE}, a series of dialogs are displayed 
  to obtain input parameters from the user and all other arguments will be 
  ignored.}
  \item{sumFiles}{character string/vector; spectrum name(s) as returned by 
	names(fileFolder).}
  \item{sumRois}{character string/vector; ROIs to be included in the summary.}
  \item{sumType}{character string; indicates how the ROI data should be 
  summarized, must be one of \code{maximum}, \code{minimum}, \code{absMax}, 
  \code{area}, \code{absArea}, \code{w1}, or \code{w2}.}
  \item{normType}{character string; indicates how the ROI data should be 
  normalized, must be one of \code{none}, \code{internal}, \code{crossSpec}, 
  \code{signal/noise}, or \code{sum}.}
  \item{normList}{characters string or vector; one or more files or ROIs 
  to be used when normalizing the ROI data (only applicable if normType is set 
  to \code{internal} or \code{crossSpec}.}
  \item{summary}{data.frame; an ROI summary to edit (just the data section).}
  \item{\dots}{Additional arguments can be passed to internal peak picking 
  functions (see \code{\link{addArg}}).}
}

\details{
  \code{roi} displays the ROI GUI. The "Edit" tab allows users to edit, delete, 
  and create new ROIs using the buttons on the left side of the tab.  ROIs can 
  be modified by selecting the desired edit mode using the move/expand/contract 
  radio buttons located along the top, followed by clicking on the appropriate 
  arrow button to adjust active ROIs by the increment provided in the center 
  box.  The adjustment increment may be defined in units of percent (of the ROIs
  current width or height) or by PPM.  Only active (selected) ROIs will be
  modified.
  
  The "Select" tab provides an interface for selecting ROIs.  Selected ROIs are
  referred to as "active", as the majority of the available ROI functions are
  performed only on those that are currently selected.  Refer to the \code{rs}
  function (below) for more on selecting ROIs.
  
  Display options for ROIs are contained within the "Display" tab.  The check
  boxes within the "Windows" section control where ROIs are displayed.  The 
  \dfn{subplot window} displays all ROIs from the current spectrum.  The 
  \dfn{multiple file window} displays active ROIs from selected spectra.  The
  maximum intensity for each ROI may be displayed in this window using the "ROI
  Maxima" option.  The options on the left side of the tab control how ROIs are 
  displayed.  Press the \bold{Apply} button to save any changes made to the ROI 
  appearance settings.
  
  The "Auto" tab contains options for automatic ROI generation using the 
  \code{ra()} function.  The "Fixed W1", "Fixed W2", "Padding", and "Noise 
  Filter" options are passed to \code{ra()} as the \code{w1Delta}, 
  \code{w2Delta}, \code{p}, and \code{noiseFilt} arguments, respectively, 
  defined above.
  
  Data from ROIs across multiple files may be summarized using the "Summary" 
  tab.  To select which files to include in the summary, select "All", "Active",
  or "Custom".  The "Active" option selects all files displayed in the multiple 
  file window.  A specific file set may be selected for included in the summary
  by selecting the "Custom" option.  The ROI selection options function in the
  same manner.  Spectral data from the specified files and ROIs may be 
  summarized using the options provided in the "Type" drop-down menu.  Data may 
  be summarized by peak maximum, absolute max, minimum, area, absolute area, or 
  by chemical shift (at the absolute maximum intensity). 
  
  The "custom" option found in the "Type" drop-down menu allows the ROI data to
  be summarized using a custom function provided by the user.  Note that this 
  option is provided as a convenience for experienced \pkg{rNMR} users and must
  be used cautiously to avoid generating errors.  Before the summary is 
  generated, a dialog will be displayed with the names of any functions that are 
  present in the global environment for the current R session.  Functions used 
  to summarize ROI data must accept at least one argument and must be capable of 
  operating on matrices.  When the summary is generated, the \code{rSum()} 
  function will pass the data contained within a single ROI for a single 
  spectrum as the first argument to the custom function selected from the 
  dialog.  The data will match the format of the return value of the 
  \code{\link{ed}} function, a list containing file parameters (labeled 
  "file.par"), shifts in each dimension (labeled "w1" and "w2"), and the 
  spectral data for the ROI as a transposed matrix (labeled "data").  The 
  graphics parameters for each file in the summary will be passed to the 
  function as a second argument (if applicable).  See \code{\link{fileFolder}} 
  for a more detailed explanation of each of these sections.  The summary 
  function must return a single numeric value and must be initialized within 
  the global environment before the summary is generated.  For instance, the 
  "maximum" summary type option uses the following function to summarize data 
  from each ROI in each file:
  
  \code{function(x, parm){max(x$data)}}
  
  In this example, the ROI data is passed to argument \code{x} and only the 
  maximum intensity within the matrix is returned.  The graphics parameters for
  the file containing the ROI data are passed to the \code{parm} argument but 
  are not used.  It may be helpful to look at the source code for the 
  \code{rSum()} function to get a better feel for how ROI data is summarized 
  before using the custom summary option.
  
  Summary data may be normalized by selecting from the "Normalization" drop-down 
  menu. Selecting "internal" will normalize the data by an internal standard, 
  designated by adding one or more ROIs to the "Normalization files/ROIs" list.  
  Data collected from these standards will be collected under the same 
  conditions as the summary data (i.e.- ROIs summarized by maximum intensity 
  will be normalized by the mean maximum intensity of the designated ROIs).  
  Selecting "across spectra" will normalize the data to ROI data from a 
  particular file, or the mean of the data from several files (also designated
  using the "Normalization files/ROIs" list). Selecting "signal to noise" will 
  normalize the summary data to the noise level in each file.  The "constant 
  sum" option normalizes the data by the constant sum of the spectral data from 
  each file.
}	

\section{Shortcut functions}{
\describe{
  \item{\code{rn}}{Manually create an ROI by clicking on points within the main 
  plot window.  Two successive mouse clicks indicate opposite corners of the ROI
  being defined.  To exit ROI creation mode, right-click within the main plot
  window.}
  \item{\code{ra}}{Automatically generates ROIs from visible peaks in the main 
  plot window.} 
  \item{\code{rc}}{Centers active ROIs.}
  \item{\code{rmr}}{Moves active ROIs right.}
  \item{\code{rml}}{Moves active ROIs left.}
  \item{\code{rmu}}{Moves active ROIs up.}
  \item{\code{rmd}}{Moves active ROIs down.}
  \item{\code{rei}}{Expands active ROIs in the indirect dimension.}
  \item{\code{red}}{Expands active ROIs in the direct dimension.}
  \item{\code{rci}}{Contracts active ROIs in the indirect dimension.}
  \item{\code{rcd}}{Contracts active ROIs in the direct dimension.}
  \item{\code{re}}{Allows the current ROI table to be edited using \pkg{rNMR}'s 
  \code{\link{tableEdit}} function.  If the \code{table} argument is provided, 
  this table will be edited and returned, the current ROI table will not be 
  affected.  See \code{\link{import}} for more information on ROI table 
  structure.}
  \item{\code{rr}}{Renames active ROIs.}
  \item{\code{rs}}{Select (activate) ROIs from a list, the main plot window, 
  a region within the main plot window, the subplot window, or the multiple file 
  window.  Click on an ROI in the main plot or subplot windows to select it.  To 
  exit selection mode, right-click within the appropriate window.  Selecting 
  ROIs in the multiple file window switches the main plot window to the desired 
  spectrum and zooms in on the selected ROI.  Only active ROIs are displayed in 
  the multiple file window.  To activate additional ROIs, click on the ROI names 
  at the top of the multiple file window (Windows platforms only).  To change 
  which spectra are displayed within the multiple file window, click on one of 
  the file names in the leftmost portion of the window (Windows platforms 
  only).}	
  \item{\code{rsf}}{Select files for display within the multiple file window.}
  \item{\code{rsAll}}{Selects (activates) all ROIs}
  \item{\code{rdAll}}{Deselects (deactivates) all ROIs}
  \item{\code{rDel}}{Delete ROIs; preselected items in the list indicate ROIs 
  that are currently active.}
  \item{\code{rvs}}{Displays the subplot window.}
  \item{\code{rv}}{Toggles the ROI display in the main plot window.}
  \item{\code{rSum}}{Generates an ROI summary.  Summary parameters may be 
  provided as arguments to the function or may be selected by the user using a
  series of dialog windows.  See the description of the "Summary" tab in the ROI
  GUI (above) for more information on how summaries are generated.}
  \item{\code{rvm}}{Displays the multiple file window.}
  \item{\code{se}}{Allows the current ROI summary to be edited using 
  \pkg{rNMR}'s \code{\link{tableEdit}} function.  If the \code{table} argument 
  is provided, this table will be edited and returned, the current ROI summary 
  will not be affected.  See \code{\link{import}} for more information on ROI 
  summary structure.}
  }
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{import}} for importing/exporting ROI tables and summaries;  
\code{\link{ed}} for extracting data from ROI tables and summaries; 
\code{\link{rNMR}} for other rNMR help topics.}

\keyword{aplot}
\keyword{iplot}