\name{rNMRutils}
\alias{rNMRutils}
\alias{myAssign}
\alias{myFile}
\alias{wc}

\title{Utilities for interacting with the rNMR environment}

\description{The functions detailed below perform basic functions designed to 
ease interaction with the \pkg{rNMR} environment.
}
\usage{
myAssign(in.name = NULL, in.object, save.backup = TRUE)
myFile(fileName, open)
wc(fileName=FALSE)
}

\arguments{
  \item{z}{numeric vector; for 3D files, the z-vaule(s) for the spectrum or 
  spectra.}
  \item{in.name}{character string; name to apply to the newly assigned object.}
  \item{in.object}{R object; object to be assigned.}
  \item{save.backup}{logical; creates an entry in the undo list if \code{TRUE}.}
  \item{fileName}{character string or vector; the full path name(s) for the
  spectrum/spectra/file connection.}
  \item{open}{character string; type of file connection to open, see 
  \code{\link{file}}.}
  \item{fileName}{logical; returns the full file path  for the current spectrum 
  if \code{TRUE}.}
}

\details{
\describe{
  \item{\code{myAssign}}{Modified version of R's \code{\link{assign}} function; 
  assigns an R object to the global environment and saves a copy of the rNMR 
  environment to \code{\link{oldFolder}} for use with the \code{\link{ud}},
  \code{\link{rd}}, and \code{\link{zp}} functions.}
  \item{\code{myFile}}{Modified version of R's \code{\link{file}} function; 
  creates a connection to the designated file, as named in 
  \code{\link{fileFolder}}, and gives the user the option of updating the file's
  location if the file can not be found at its previous location.  This function
  is provided to ensure that relocated files can still be viewed in \pkg{rNMR}, 
  particularly when working with previously saved workspaces.}
  \item{\code{wc}}{Returns the file path or the position (default) in 
  \code{\link{fileFolder}} for the currently displayed spectrum.}
  }
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{toolkit}} for other \pkg{rNMR} utility functions.}

\keyword{internal}
