\name{peak picking}
\alias{pp}
\alias{pa}
\alias{paAll}
\alias{pw}
\alias{pwAll}
\alias{pReg}
\alias{pm}
\alias{ph}
\alias{pDel}
\alias{pDelAll}
\alias{pe}
\alias{pv}
\alias{nf}
\alias{rp}
\alias{rpAll}

\title{Peak picking}

\description{
  Peak picking functions.
}

\usage{
pp()
pa(...)
paAll(...)
pw(append = TRUE, ...)
pwAll(append = TRUE, ...)
pReg(fileName = currentSpectrum, append = TRUE, ...)
pm(fileName = currentSpectrum, append = TRUE, ...)
ph(forcePoint = FALSE)
pDel()
pDelAll()
pe(table)
pv()
nf(noiseFilt)
rp(fileName = currentSpectrum, append = TRUE, parent = NULL, ...)
rpAll(append = TRUE, ...)
}

\arguments{
  \item{append}{logical;  \code{TRUE} appends new peaks to the previous list.}
  \item{fileName}{character string or vector; spectrum name(s) as they appear 
  in fileFolder, defaults to the current spectrum.}
  \item{forcePoint}{logical;  when \code{TRUE}, the intensity and chemical 
  shifts will be taken from the closest data point in the spectrum; when 
  \code{FALSE} the intensity is taken from the closest data point but chemical 
  shifts will not be corrected to match the spectrum.}
  \item{table}{data.frame; a peak table to edit.}
  \item{noiseFilt}{integer; either \code{0}, \code{1} or \code{2}.  \code{0} 
  does not apply a noise filter, \code{1} applies a mild filter (adjacent points 
  in the direct dimension must be above the noise threshold), and \code{2} 
  applies a strong filter (all adjacent points must be above the noise 
  threshold).}
  \item{parent}{optional Tk toplevel object to set as a parent window for the 
	newly created dialog.  If provided, the dialog will appear near its parent
	and will bring the parent toplevel object to the front.  This is 
	particularly useful for displaying message or error dialogs in response to
	user interactions within rNMR GUIs.}
  \item{\dots}{Additional arguments can be passed to internal peak picking 
	functions (see \code{\link{addArg}}).}
}

\details{
  \code{pp} displays a peak picking GUI.  Changes are only applied to files 
  selected from the files list.  Double-clicking on a file name within the files 
  list will switch the current spectrum to the file selected.  The noise filter 
  options call on the \code{nf} function detailed below.  The 1D threshold 
  option must be a numeric value indicating the number of standard deviations 
  away from the noise to set as the minimum peak pick threshold in 1D spectra.  
  Changes made to the 1D threshold are not saved until the \bold{Apply} button 
  is pressed.  This option is not required for 2D spectra, as the peak picking 
  threshold is determined by the displayed contour level(see \code{\link{ct}}).  
  The \bold{Full}, \bold{Region}, \bold{ROI}, \bold{Hand}, \bold{Edit list}, and 
  \bold{Clear list} buttons call the \code{pa}, \code{pReg}, \code{rp}, 
  \code{ph}, \code{pe}, and \code{pDel} functions, respectively.  These 
  functions are detailed below.  Peak lists may be imported, exported, or 
  uploaded to the MMCD (Madison Metabolomics Consortium Database, see 
  \code{\link{mmcd}}) using the \bold{Import}, \bold{Export}, and \bold{MMCD} 
  buttons, respectively.    
}
  
\section{Shortcut functions}{
\describe{
  \item{\code{pa}}{Peak picks the entire spectrum.}  
  \item{\code{paAll}}{Peak picks the full chemical shift range in all open 
  spectra.}
  \item{\code{pw}}{Peak picks the chemical shift range displayed in the main 
  plot window.}  
  \item{\code{pwAll}}{Peak picks the chemical shift range displayed in the main
  plot window in all open spectra.}
  \item{\code{pReg}}{Peak picks a user designated region.}  
  \item{\code{pm}}{Peak picks the maximum intensity found within a designated
  region defined interactively by the in the main plot window.}  
  \item{\code{ph}}{Manual peak picking; Peak markers are placed by clicking on 
  a point within the main plot window.  By default, \code{forcePoint} is set to 
  \code{FALSE} and markers are placed at the exact cursor location when clicked.  
  To exit manual peak picking mode, right-click in the main plot window.}
  \item{\code{pDel}}{Clears picked peaks from the current spectrum.} 
  \item{\code{pDelAll}}{Clears picked peaks in all open spectra.}
  \item{\code{pe}}{Allows the current spectrum's peak list to be edited using 
  \pkg{rNMR}'s \code{\link{tableEdit}} function.  If the \code{table} argument 
  is provided, this table will be edited and returned, the peak list for the 
  current spectrum will not be affected.  See \code{\link{import}} for more 
  information on peak list structure.}
  \item{\code{pv}}{Turns the peak display on and off.}
  \item{\code{rp}}{Peak picks inside or outside existing ROI's in the current 
  spectrum.}  
  \item{\code{rpAll}}{Peak picks existing ROI's in all open spectra.} 
  }
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{ct}} for changing plot settings; \code{\link{roi}} for 
creating ROIs; \code{\link{import}} for importing/exporting \pkg{rNMR} peak 
lists; \code{\link{ed}} for extracting data from \pkg{rNMR} peak lists; 
\code{\link{rNMR}} for other rNMR help topics.}

\keyword{aplot}
\keyword{iplot}
