\name{plotUtils}
\alias{plotUtils}
\alias{draw2D}
\alias{drawNMR}
\alias{plot1D}
\alias{plot2D}
\alias{proj1D}
\alias{ucsf1D}
\alias{ucsf2D}
\alias{ucsfHead}

\title{rNMR Plotting utilities}

\description{Utilities for plotting one and two-dimensional spectra in 
\pkg{rNMR}.
}

\usage{
draw2D(in.folder = fileFolder[[wc()]], 
	w1Range = in.folder$graphics.par$usr[3:4], 
	w2Range = in.folder$graphics.par$usr[1:2], 
	pos.zlim = c(in.folder$file.par$noise_est * in.folder$graphics.par$clevel, 
	in.folder$file.par$noise_est * in.folder$graphics.par$clevel * 
	in.folder$graphics.par$nlevels), neg.zlim = -(rev(pos.zlim)), 
	type = in.folder$graphics.par$type, 
	pos.color = in.folder$graphics.par$pos.color, 
	neg.color = in.folder$graphics.par$neg.color, 
	nlevels = in.folder$graphics.par$nlevels, 
	conDisp = in.folder$graphics.par$conDisp, 
	xlab = paste(in.folder$file.par$nucleus[2], "PPM", sep = " "), 
	ylab = paste(in.folder$file.par$nucleus[1], "PPM", sep = " "), 
	main = in.folder$file.par$user_title, roiMax = globalSettings$roiMax, 
	add = FALSE, axes = TRUE, ...)
drawNMR(in.folder = fileFolder[[wc()]], w1Range, w2Range, pos.zlim, neg.zlim, 
	type, pos.color, neg.color, nlevels, conDisp, bg, fg, col.axis, col.lab, 
	col.main, col.sub, col, xlab = NULL, ylab = NULL, 
	main = in.folder$file.par$user_title, add = FALSE, p.window = "main", 
	axes = TRUE, offset = 0, ...)
plot1D(in.folder = fileFolder[[wc()]], 
	w1Range = in.folder$graphics.par$usr[3:4], 
	w2Range = in.folder$graphics.par$usr[1:2], 
	col = in.folder$graphics.par$proj.color, 
	type = in.folder$graphics.par$type, xlab = NULL, ylab = NULL, 
	main = in.folder$file.par$user_title, 
	roiMax = globalSettings$roiMax, add = FALSE, axes = TRUE, offset = 0, ...)
plot2D(in.folder = fileFolder[[wc()]], 
	w1Range = in.folder$graphics.par$usr[3:4], 
	w2Range = in.folder$graphics.par$usr[1:2], 
	pos.zlim = c(in.folder$file.par$noise_est * in.folder$graphics.par$clevel, 
	in.folder$file.par$noise_est * in.folder$graphics.par$clevel * 
	in.folder$graphics.par$nlevels), neg.zlim = -(rev(pos.zlim)), 
	type = in.folder$graphics.par$type, 
	pos.color = in.folder$graphics.par$pos.color, 
	neg.color = in.folder$graphics.par$neg.color, 
	nlevels = in.folder$graphics.par$nlevels, 
	conDisp = in.folder$graphics.par$conDisp, 
	xlab = paste(in.folder$file.par$nucleus[2]), 
	ylab = paste(in.folder$file.par$nucleus[1]), 
	main = in.folder$file.par$user_title, add = FALSE, axes = TRUE, ...)	
proj1D(in.folder = fileFolder[[wc()]], 
	w1Range = in.folder$graphics.par$usr[3:4],
	w2Range = in.folder$graphics.par$usr[1:2],
	col = in.folder$graphics.par$proj.color, filter = globalSettings$filter,
	proj.direct = globalSettings$proj.direct, type = globalSettings$proj.type,
	xy = NULL, ...)
ucsf1D(file.name = NULL, w2Range = NULL, file.par = NULL)
ucsf2D(file.name = NULL, w1Range = NULL, w2Range = NULL, file.par = NULL)
ucsfHead(file.name = NULL, print.info = TRUE)
}

\arguments{
  \item{in.folder}{list; file and graphics parameters for the file to be plotted
    as listed in \code{\link{fileFolder}}.}
  \item{w1Range}{numeric vector; chemical shift range in the indirect dimension,
    default is the most recent setting used with the file, the format is 
    \code{c(lower,upper)}.}
  \item{w2Range}{numeric vector; chemical shift range in the direct dimension,
    default is the most recent setting used with the file.  The format is 
    \code{c(lower,upper)}.}
  \item{pos.zlim}{numeric vector; min and max positive intensities to be 
    displayed, default is the most recent setting used with the file.  The 
    format is \code{c(lower,upper)}.}
  \item{neg.zlim}{numeric vector; min and max negative intensities to be 
    displayed, default is the most recent setting used with the file.  The 
    format is \code{c(lower,upper)}.}
  \item{type}{see \code{\link{plot}}.}
  \item{pos.color}{character string; color for positive contours, default is the
    most recent setting for the file, see \code{\link{colors}} for the many 
    color options.}
  \item{neg.color}{character string; color for negative contours, default is the
    most recent setting for the file, see \code{\link{colors}} for the many 
    color options.}
  \item{nlevels}{numeric; the number of contour intervals to be drawn, the 
    default is the most recent setting used for the file.}
  \item{conDisp}{logical vector; \code{c(TRUE, TRUE)} plots positive and 
    negative contours, \code{c(TRUE, FALSE)} plots only positive, 
    \code{c(FALSE, TRUE)} plots only the negative contours, 
    \code{c(FALSE, FALSE)} does not plot any contours.}
  \item{xlab}{see \code{\link{plot}}.}
  \item{ylab}{see \code{\link{plot}}.}
  \item{main}{see \code{\link{plot}}.}
  \item{roiMax}{logical; if \code{TRUE}, plots a point on the maximum visible 
  	signal in the window.}
  \item{add}{logical; if \code{TRUE}, adds new data to an existing plot, 
    if \code{FALSE} generates a new plot.}
  \item{axes}{logical; if \code{TRUE}, makes \code{\link{pretty}} labels.}
  \item{bg}{see \code{\link{par}}.}
  \item{fg}{see \code{\link{par}}.}
  \item{col.axis}{see \code{\link{par}}.}
  \item{col.lab}{see \code{\link{par}}.}
  \item{col.main}{see \code{\link{par}}.}
  \item{col.sub}{see \code{\link{par}}.}
  \item{col}{see \code{\link{par}}.}
  \item{p.window}{character string; the window to be used for the plot, can be 
    \code{"main"}, \code{"sub"}, \code{"multi"}, or \code{"stats"}.}
  \item{offset}{numeric; the percentage of the total z range with which to 
    displace a spectrum. This is used to create stacked 1D spectra.}
	\item{filter}{function; a vector capable function (e.g. min, max, sd) used 
		to filter 2D data into a 1D projection, non function arguments prompt users 
		to select a slice.}  
 	\item{proj.direct}{numeric; \code{1} projects data across the direct axis, 
 		\code{2} across the indirect.}
 	\item{xy}{numeric; x and y coordinates indicating the slice to display.  The
 		optional argument may be supplied as an alternative to interactive slice
 		selection.}  
  \item{file.name}{character string; full path for the file to be read, 
    \code{NULL} will open a file selection window.}
  \item{file.par}{list; file parameters as found in the header of the ucsf file
    designated by the \code{file.name} parameter.  This argument is optional and
    is used to speed up graphics by foregoing noise estimation.}
  \item{\dots}{additional graphics parameters can be passed to \code{par}.}
  \item{print.info}{logical; prints header information if \code{TRUE}.}
}

\details{
\describe{
  \item{\code{draw2D}}{Draws a 2D NMR spectrum from a binary connection.  This 
    function replaces \code{plot2D} when creating ROI subplot and multiple file 
    windows, as it is more efficient for batch operations.}
  \item{\code{drawNMR}}{Wrapper and routing function for lower level plotting 
  	functions in \pkg{rNMR}.}
  \item{\code{plot1D} and \code{plot2D}}{Draw sparky (ucsf) format spectra from
    a binary connection.}
  \item{\code{proj1D}}{Projects a 2D spectrum into a single dimension.}
  \item{\code{ucsf1D} and \code{ucsf2D}}{Read sparky (ucsf) format spectra and 
   return data within the specified range.  The "data" section }
  \item{\code{ucsfHead}}{Read header information from a sparky (ucsf) format 
	 spectrum and return data used to populate "file.par" section of
	 \code{\link{fileFolder}}.}
  }
}

\value{ 
\code{ucsf1D()} and \code{ucsf2D()} return a list containing:

\code{file.par} - Header information for the spectrum including file name, 
nuclei, number of dimensions, spectrum width, etc.

\code{w1} - Chemical shifts in the indirect dimension.

\code{w2} - Chemical shifts in the direct dimension.

\code{data} - The data from the spectrum, as a matrix of intensities for 2D 
spectra or a vector for 1D slices and plots.  The first data point in a 
matrix of 2D intensities, [1, 1], corresponds to the downfield-most point, 
in both dimensions, for the spectrum.  The last data point in the matrix 
corresponds to the upfield-most point, in both dimensions, for the spectrum.  
In other words, if you traverse the matrix by rows, data points in the 
matrix start at the bottom-left of the spectrum and move up and to the right 
(as the spectrum would normally be viewed). See \code{\link{import}} for 
details on the contents of the ROI table, ROI summary, and peak list 
objects.

\code{ucsfHead()} returns a list containing the same fields present in the 
"file.par" section of \code{\link{fileFolder}}.
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{toolkit}} for other \pkg{rNMR} utility functions.}

\keyword{internal}