\name{1D slice}
\alias{pj}
\alias{vs}
\alias{pjv}

\title{1D slices and projections}
\description{
  Functions for viewing 1D slices and projections of 2D data.
}
\usage{
pj()
pjv()
vs(proj.direct = NULL, \dots)
}

\arguments{
  \item{proj.direct}{integer; \code{1} returns direct slices, \code{2} returns 
  indirect slices, \code{NULL} opens a selection window.}
  \item{\dots}{Additional arguments can be passed to internal 1D plotting
  functions (see \code{\link{addArg}}).}
}
\details{
  \code{pj} displays a GUI for viewing 1D slices and projections.  This 
  function may only be called when the current spectrum is two-dimensional.
  The 1D slice buttons call the \code{vs} function detailed below.  1D 
  projections are one-dimensional representations of two-dimensional data and
  can be displayed by selecting the appropriate radio button within the GUI.
  The "Type" option determines how the projection is displayed and may be one of
  the following:  pseudo1D, max, min, or absolute max.  The pseudo1D function 
  evaluates the absolute maximum at each increment and returns the value with 
  its original sign.  Note:  1D projections are generated from the current 
  window.  Peaks outside of the current chemical shift range will not be 
  included in the projection.    
}   
  
\section{Shortcut functions}{
\describe{
  \item{\code{pjv}}{Turn 1D projection display on and off.}
  \item{\code{vs}}{Displays a 1D slice of the data along the desired dimension.  
  The location of the slice is defined by clicking within the main plot window.  
  Successive clicks will clear the previous slice and display a new one.  To 
  exit view slice mode, right-click in the main plot window.}
  }       
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{ct}} for plot settings; \code{\link{ol}} for overlays; 
\code{\link{rNMR}} for other rNMR help topics.}

\keyword{aplot}
\keyword{iplot}