\name{perspective settings}
\alias{per}
\alias{spin}
\alias{rotc}
\alias{rotcc}
\alias{rotu}
\alias{rotd}

\title{Perspective plot settings}
\description{
  Functions for viewing 3D perspective plots of 2D NMR data.
}
\usage{
per()
spin(...)
rotc(degrees = 10, ...)
rotcc(degrees = 10, ...)
rotu(degrees = 10, ...)
rotd(degrees = 10, ...)
}

\arguments{
  \item{degrees}{numeric; the number of degrees to rotate the perspective plot 
  by.}
  \item{\dots}{Additional arguments can be passed to internal peak picking 
  functions (see \code{\link{addArg}}).}
}
\details{
  \code{per} displays a GUI for perspective plots.  The rotate/zoom/scroll radio 
  buttons located along the top are used to interact with the plot.  Select the
  desired option then click on the appropriate arrow button to rotate, zoom, or
  scroll by the increment provided in the center box. The \bold{Center} button 
  centers the plot on the peak's center of mass (see \code{\link{zc}}).  The 
  \bold{Spin} button calls the \code{spin} function detailed below. 
}	 
  
\section{Shortcut functions}{
\describe{
  \item{\code{spin}}{Rotates the perspective plot a full 360 degrees gradually.}
  \item{\code{rotc}, \code{rotcc}, \code{rotu}, and \code{rotd}}{Rotate the 
  perspective  plot clockwise, counter-clockwise, up, or down respcectively by 
  10 degrees.} 
  }
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{ct}} for plot settings; \code{\link{zm}} for zoom 
functions; \code{\link{persp}} for R's perspective plotting feature; 
\code{\link{rNMR}} for other rNMR help topics.}

\keyword{iplot}