\name{import}
\alias{import}
\alias{export}

\title{Import or export rNMR data tables}
\description{
  Functions for importing and exporting peak lists, ROI tables, and ROI 
  summaries.
}
\usage{
import(object, parent=NULL)
export(object, parent=NULL)
}

\arguments{
  \item{object}{optional character string argument giving the name of the 
  \pkg{rNMR} object to import/export, either 'ROI table', 'ROI summary', or 
  'Peak list'.} 
  \item{parent}{optional Tk toplevel object to set as a parent window for the 
  	newly created dialog.  If provided, the dialog will appear near its parent
  	and will bring the parent toplevel object to the front.  This is 
  	particularly useful for displaying message or error dialogs in response to
  	user interactions within rNMR GUIs.}
}

\details{
  The import and export functions load or save tab delimited text files with the
  formats detailed below. 
  
  \dfn{ROI tables} detail the existing set of ROIs.  ROI tables must contain the
  following seven columns:
  \enumerate{  
  \item Name - character value, the names of the ROIs.
  \item w2_downfield - numeric, the w2 downfield shift boundary for the ROI.
  \item w2_upfield - numeric, the w2 upfield shift boundary for the ROI.
  \item w1_downfield - numeric, the w1 downfield shift boundary for the ROI.
  \item w1_upfield - numeric, the w1 upfield shift boundary for the ROI.
  \item ACTIVE - logical, \code{TRUE} indicates that the ROI is active 
  (selected).
  \item nDim - numeric, either \code{1} or \code{2} indicating the number of
	dimensions for the spectrum in which the ROI was originally designated.
  }
  See \code{\link{roi}} for more information on creating ROIs.
  
  \dfn{ROI summaries} extract data from existing ROIs.  Each row in a summary 
  represents data from a single file.  The columns in an ROI summary are defined 
  as follows:
  \enumerate{  
  \item FILE - character string, file names for the spectra used in generating
  the summary.
  \item \emph{ROI name} - numeric, each additional column contains the name of
  an ROI (a character string containing no spaces) used in generating the 
  summary with entries containing data extracted from each spectra included in
  the summary. 
  }
  See \code{\link{rSum}} for more information on generating ROI summaries.
  
  \dfn{Peak lists} contain information on peaks picked in a particular 
  spectrum and must contain the following columns:
  \enumerate{
  \item Index - numeric, a unique identifier for the peak.
  \item w1 - numeric, chemical shift in the indirect dimension for the peak.
  \item w2 - numeric, chemical shift in the direct dimension for the peak.
  \item Height - numeric, the height associated with the peak.
  \item Assignment - character, a label for the peak.
  }
  Additional columns may be included but will not be evaluated by \pkg{rNMR}.
  Only the "w2" and "w1" columns need to be included when importing peak tables.
  See \code{\link{pp}} for more information on generating peak lists.
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{ed}} for extracting data from \pkg{rNMR} plots and tables; 
\code{\link{pp}} for generating peak lists; \code{\link{roi}} for generating
ROI tables; \code{\link{rSum}} for generating ROI summaries; \code{\link{rNMR}}
for other rNMR help topics.}

\keyword{file}
\keyword{data}