\name{graphicUtils}
\alias{graphicUtils}
\alias{bringFocus}
\alias{cw}
\alias{refresh}
\alias{setWindow}

\title{rNMR graphics window utilities}

\description{Utilities for creating and switching between \pkg{rNMR} graphics 
devices.
}

\usage{
bringFocus(dev = -1)
cw(dev = NULL)
refresh(main.plot = TRUE, overlay = TRUE, sub.plot = TRUE, multi.plot = TRUE, 
	...)
setWindow(p.window = "main", ...)
}

\arguments{
  \item{dev}{numeric; device number or \code{-1} for the R console.  A \code{2} 
  corresponds to the main plot window, \code{3} to the multiple file window, 
  \code{4} to the subplot window, and \code{5} to the stats window.}
  \item{main.plot}{logical; if \code{TRUE}, refreshes the main plot window.}
  \item{overlay}{logical; if \code{TRUE}, replots overlays.}
  \item{sub.plot}{logical; if \code{TRUE}, refreshes the sub plot window.}
  \item{multi.plot}{logical; if \code{TRUE}, refreshes the multiple file 
  window.}
  \item{p.window}{character string; the window type, can be \code{"main"}, 
  \code{"sub"}, \code{"multi"}, or \code{"stats"}.}
  \item{\dots}{Additional arguments can be passed to \code{\link{par}}
  (\code{setWindow}) or internal plotting functions (see \code{\link{addArg}}).}
}

\details{
\describe{
  \item{\code{bringFocus}}{Modified version of R's \code{bringToTop}
  function designed to run only on Windows platforms.}
  \item{\code{cw}}{Cycles through open graphics windows or activates the
  designated device (if provided).}
  \item{\code{refresh}}{Refreshes plot devices.}
  \item{\code{setWindow}}{Makes a new plotting window with the correct title, 
  width, and height or activates the designated device (if provided).}
  }
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{toolkit}} for other \pkg{rNMR} utility functions.}

\keyword{internal}
