\name{globalSettings}
\alias{globalSettings}

\title{
rNMR object globalSettings
}

\description{
The \code{globalSettings} object stores the current set of global graphics and
plot settings as a named list (detailed below).  The values for these parameters 
are taken from \code{\link{defaultSettings}} when \pkg{rNMR} loads.
}

\arguments{
  \item{offset}{numeric; the percent of total intensity range with which to 
    displace each spectrum. This is used to create stacked 1D spectra and is not 
    passed to 2D plots.}
  \item{position.1D}{numeric; the vertical position of 1D plots within the
    spectral window.}
 	\item{filter}{function; a function used to create a 1D projection, must be
    capable of being applied to a vector (e.g. \code{min}, \code{max}, 
    \code{sd}).  Function must accept \code{x} as its only argument.}
  \item{proj.direct}{integer \code{1} or \code{2}; if \code{1} a projection of 
  	the direct dimension is displayed, \code{2} displays the indirect 
  	dimension.}
  \item{proj.mode}{logical; if \code{TRUE} displays a 1D representation of a 
  	2D spectrum.}
  \item{proj.type}{specifies the type of projection to be generated;  
  	"\code{auto}" displays a solid line, "\code{p}" displays only points, and 
  	"\code{b}" displays points connected by a line.}
  \item{peak.disp}{logical; if \code{TRUE} markers and labels are displayed over
  	picked peaks.}	
	\item{peak.noiseFilt}{integer; peak picking filter.  \code{0} does not apply a 
		noise filter, \code{1} applies a mild filter (adjacent points in the direct 
		dimension must be above the noise threshold), and \code{2} applies a strong 
		filter (all adjacent points must be above the noise threshold).}
  \item{thresh.1D}{numeric; the peak picking threshold for 1D spectra.}
  \item{peak.pch}{integer or character; the symbol used for peak markers for 
  	picked peaks.  Equivalent to R's \code{pch} graphical parameter, accepts any 
  	ASCII character as well as integer values corresponding to predefined 
  	symbols in R (see \code{\link{par}}).}	
  \item{peak.cex}{numeric (positive); the magnification for peak labels and 
  	markers for picked peaks.  Equivalent to R's \code{cex} graphical parameter 
  	(see \code{\link{par}}).}
  \item{peak.labelPos}{justification for peak label text.  Must be one of 
  	\code{"top"}, \code{"bottom"}, \code{"left"}, \code{"right"}, or 
  	\code{"center"}.}
  \item{roiMain}{logical; if \code{TRUE} displays ROIs in the main plot 
  	window.}
  \item{roiMax}{logical; if \code{TRUE} displays a marker in the subplot and 
  	multiple file windows on the absolute maximum visible signals within the 
  	ROIs.}
  \item{roi.bcolor}{color setting for active and inactive ROI boxes.  Must be
  	a vector of length two: \code{c(active, inactive)}.  See \code{\link{colors}}
    for a list of usable colors.}
  \item{roi.tcolor}{color setting for active and inactive ROI labels.  Must be
  	a vector of length two: \code{c(active, inactive)}.  See \code{\link{colors}}
    for a list of usable colors.}
  \item{roi.lwd}{numeric; line width for ROI boxes.  Equivalent to R's 
  	\code{lwd} graphical parameter (see \code{\link{par}}).}
  \item{roi.lty}{box type for active and inactive ROIs.  Must be a vector of
  	length 2, \code{c(active, inactive)}.  Equivalent to R's \code{lty} 
  	graphical parameter (see \code{\link{par}}).  Valid options include: 
  	\code{"solid"}, \code{"dashed"}, \code{"dotted"}, \code{"dotdash"}, 
  	\code{"longdash"}, \code{"twodash"}, or \code{"blank"}.}
  \item{roi.cex}{numeric (positive); text magnification for ROI labels.  
  	Equivalent to R's	\code{cex} graphical parameter (see \code{\link{par}}).}
 	\item{roi.labelPos}{justification for ROI label text.  Must be one of 
  	\code{"top"}, \code{"bottom"}, \code{"left"}, \code{"right"}, or 
  	\code{"center"}.}
  \item{roi.noiseFilt}{integer; filter for automatic ROI generation (see 
  	\code{\link{ra}}).  \code{0} does not apply a noise filter, \code{1} applies 
  	a mild filter (adjacent points in the direct dimension must be above the 
  	noise threshold), and \code{2} applies a strong	filter (all adjacent points 
  	must be above the noise threshold).  Note that setting the ROI noise filter
  	to zero may result in errors when using \code{\link{ra}} in certain 
  	spectra.}
  \item{roi.w1}{numeric; fixed size in the indirect dimension (in ppm) for ROIs 
  	generated automatically using \code{\link{ra}}.}
  \item{roi.w2}{numeric; fixed size in the direct dimension (in ppm) for ROIs 
  	generated automatically using \code{\link{ra}}.}
  \item{roi.pad}{numeric; padding percentage applied to ROIs generated 
  	automatically using \code{\link{ra}}. This padding is added to the area 
  	surrounding the peaks within an ROI and is only applied to the height/width
  	of an ROI if the corresponding \code{roi.w1}/\code{roi.w2} argument is not 
  	provided.
  }
  \item{cex.roi.multi}{numeric (positive); the magnification for ROI labels in 
  	the multiple file window (see \code{\link{rvm}}).  Equivalent to R's 
  	\code{cex} graphical parameter (see \code{\link{par}}).}
  \item{cex.files.multi}{numeric  (positive); the magnification for file names 
  	in the multiple file window (see \code{\link{rvm}}).  Equivalent to R's 
  	\code{cex} graphical parameter (see \code{\link{par}}).}
  \item{cex.roi.sub}{numeric (positive); the magnification for ROI labels in the 
  	subplot	window (see \code{\link{rvs}}).  Equivalent to R's \code{cex} 
  	graphical	parameter (see \code{\link{par}}).}
  \item{size.main}{numeric; the dimensions (in inches) for the main plot 
  	window, of the form \code{c(width, height)}.}
  \item{size.sub}{numeric; the dimensions (in inches) for the subplot	window, of 
  	the form \code{c(width, height)}.}
  \item{size.multi}{numeric; the dimensions (in inches) for the multiple file 
  	window, of the form \code{c(width, height)}.}
  \item{mar}{numeric; the number of lines of margin space to be used in the main
  	plot window.  See \code{\link{par}}.}
  \item{mar.sub}{numeric; the number of lines of margin space to be used in the 
  	subplot window (in between ROI plots).  Equivalent to R's \code{mar} 
  	graphical parameter (see \code{\link{par}}).}
  \item{mar.multi}{numeric; the number of lines of margin space to be used in 
  	the multiple file window (in between ROI plots).  Equivalent to R's 
  	\code{mar} graphical parameter (see \code{\link{par}}).}
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{rNMRobjects}} for other other objects used by the 
\pkg{rNMR} package; \code{\link{rNMRutils}} for functions used for interacting
with \pkg{rNMR} objects.}

\keyword{internal}
