\name{Plot settings}
\alias{ct}
\alias{ctu}
\alias{ctd}
\alias{da}
\alias{di}
\alias{dp}
\alias{dr}
\alias{drf}
\alias{vp}
\alias{vpu}
\alias{vpd}
\alias{dd}

\title{Plot settings}
\description{
  Functions for changing plot settings.
}
\usage{
ct()
ctd(n = 1, ...)
ctu(n = 1, ...)
da(...)
di(...)
dp(...)
dr(nlevels = 20, ...)
drf(...)
vp(position = NULL)
vpu(p = 5)
vpd(p = 5)
dd(...)
}

\arguments{
  \item{n}{positive numeric; the number of standard deviations to increase or
  decrease the plotting threshold.}
  \item{nlevels}{positive integer; the number of contour intervals to be 
  drawn.}
  \item{position}{numeric value between 0 and 100 that expresses the percentage 
  of the visible range shown below the mean spectral noise level. The default 
  value 5, creates plots with 5 percent of the intensity range below the average 
  noise.  Note:  this argument applies to 1D spectra only.}
  \item{p}{numeric value between 0 and 100; the amount to increase or decrease 
  the 1D vertical position.}
  \item{\dots}{Additional arguments can be passed to internal plotting functions
  (see \code{\link{addArg}}).}
}

\details{
  \code{ct} displays a GUI for adjusting plot settings.  Changes are only 
  applied to files selected from the files list.  Double-clicking on a
  file name within the files list will switch the current spectrum to the file
  selected.  To adjust the contour settings use the scales provided. A scale's 
  upper limits may be adjusted using the left and right arrow buttons adjacent 
  to the scale. This will also change the scale's resolution (increment).  The 
  \bold{Defaults} button restores settings to their default values.
}
  
\section{Shortcut functions}{
\describe{
  \item{\code{ctu} and \code{ctd}}{Raise or lower the contour level of the 
  current spectrum.}
  \item{\code{da}}{Redraws the plot with the graphic type automatically set 
  based on the size of the spectral window.  Large plots are drawn using images 
  (see \code{\link{image}}) to provide a faster refresh rate while smaller plots 
  are drawn using contours (see \code{\link{contour}}) to provide a higher level 
  of detail.}
  \item{\code{di}}{Redraws the spectrum as an image plot 
  (see \code{\link{image}}).}
  \item{\code{dr}}{Redraws the spectrum as a contour plot 
  (see \code{\link{contour}}).}
  \item{\code{drf}}{Redraws the spectrum as a filled contour plot
  (see \code{\link{filled.contour}}).}
  \item{\code{dp}}{Redraws the data within the current window as a perspective 
  plot (see \code{\link{persp}}) Note:  perspective plots may only be drawn for
  small sectral windows.}
  \item{\code{vp}}{Changes the vertical position of 1D spectra.}
  \item{\code{vpu}}{Increases the vertical position of 1D spectra.}
  \item{\code{vpd}}{Decreases the vertical position of 1D spectra.}
  \item{\code{dd}}{Redraws the current spectrum without changing previous 
  graphics and plot settings.}
  }
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{co}} for color settings; \code{\link{per}} for perspective
plot settings; \code{\link{ol}} for overlays; 
\code{\link{rNMR}} for other rNMR help topics.}

\keyword{iplot}