/* SIMPLESQL.C 

   Usage: simplesql sqlcommand

   Example: $ simplesql "select * from institutions"

*/
#include <stdio.h>

main( argc, argv )
int argc;
char **argv;
{
int i, stat, nfields;
char *fields[80];

/* check command line args.. */
if( argc != 2 ) { fprintf( stderr, "usage: simplesql  sqlcommand\n" ); exit( 1 ); }

/* get config file.. */
stat = SHSQL_allconfig();
if( stat != 0 ) { fprintf( stderr, "error %d on attempt to read config file\n", stat ); exit( 1 ); }

/* submit the SQL command.. */
stat = SHSQL_sql( 0, argv[1] );
if( stat != 0 ) { fprintf( stderr, "error %d on SQL command\n", stat ); exit( 1 ); }

/* fetch the result field names and print them.. */
stat = SHSQL_getnames( 0, fields, &nfields );
for( i = 0; i < nfields; i++ ) printf( "%s	", fields[i] );
printf( "\n" );

/* fetch the result rows and print them.. */
while( 1 ) {
	stat = SHSQL_getrow( 0, fields, &nfields );
	if( stat == 1 ) break; /* no more rows */
	else if( stat > 1 ) { fprintf( stderr, "error %d on SQL row retrieval\n", stat ); exit( 1 ); }

	for( i = 0; i < nfields; i++ ) printf( "%s	", fields[i] );
	printf( "\n" );
	}
	
/* display a row count.. */
printf( "\n%d rows retrieved.\n", SHSQL_getnrows( 0 ) );

exit( 0 );
}

