/* TESTRUN1.C

   This performs a series of retrievals and is designed to test for any
   persistent problems such as running out of file descriptors, etc.

   It also tests nested retrievals, the outer one on channel 0 and 
   the inner ones on channel 1.

   Usage: testrun1
   SHSQL_DB must be set to   ./exampledb 
   and the ./exampledb/testruns/setup script must have already been run to build indexes.

*/
#include <stdio.h>

main()
{
int i, j, k, stat;
int ndescfields, nfields;
char *descfields[5], *fields[80];
char buf[512];

/* get config file.. */
stat = SHSQL_allconfig();
if( stat != 0 ) { fprintf( stderr, "error %d on attempt to read config file\n", stat ); exit( 1 ); }

/* run the whole thing 5 times.. */
for( k = 0; k < 5; k++ ) {

	printf( "\n\nRound %d ======== \n", k+1 );

	/* submit SQL SELECT on channel 0 to retrieve all desc codes.. */
	stat = SHSQL_sql( 0, "select * from pointdesc" );
	if( stat != 0 ) fprintf( stderr, "error %d on 'select * from pointdesc'\n", stat );

	
	/* loop thru desc codes.. */
	for( i = 0; ; i++ ) {
	
		stat = SHSQL_getrow( 0, descfields, &ndescfields );
		if( stat != 0 ) break;
	
		printf( "%s	", descfields[0] );
	
		/* submit SQL SELECT on channel 1 to retrieve all entries belonging to the desc code.. */
		sprintf( buf, "select * from nzplaces where desc_code = '%s' maxrows 20000", descfields[0] );
		stat = SHSQL_sql( 1, buf );
		if( stat != 0 ) fprintf( stderr, "error %d on '%s'\n", stat, buf );
		
		/* retrieve the rows */
		for( j = 0; ; j++ ) {
			stat = SHSQL_getrow( 1, fields, &nfields );
			if( stat != 0 ) break;
			}
		if( stat > 1 ) fprintf( stderr, "channel 1, error %d\n", stat );	
		printf( "%d rows\n", j );
		}
	if( stat > 1 ) fprintf( stderr, "channel 0, error %d\n", stat );	
	printf( "%d codes\n", i );
	}
}
