/* CUSTOM_FUNCTION - 
 *	Custom functions may be invoked from scripts just like the built-in functions
 * 	 or by prefacing with two dollar-signs ($$) for slightly better performance.
 *
 *	This function will be called any time that a custom function is encountered.  
 * 	Arguments are:
 *		name = the function name (without leading dollar signs)
 *		arg[] = an array of pointers to arguments
 *		nargs = number of arguments
 *		result = you should copy your result into this variable
 *		typ = you should set this to either NUMBER or ALPHA
 *
 *	This function should return 0 on success or 1 if named function not found or some 
 *	other error.
 */
#include <string.h>

extern int atoi(), TDH_reslimits();

#ifdef ENABLE_PL
  extern int PL_custom_function();
#endif

#define NUMBER 0
#define ALPHA 1

int
custom_function( name, arg, nargs, result, typ )
char *name;
char *arg[];
int nargs;
char *result;
int *typ;
{ 
int i;

/* example:
 * if( strcmp( name, "myfunc" )==0 ) {
 *	sprintf( result, "%d", do_something( arg[0], arg[1] ) );
 *	*typ = NUMBER;
 *	return( 0 );
 *	}
 * else if( strcmp( name, "anotherfunc" )==0 ) { ..etc..
 */

if( strcmp( name, "cpulimit" )==0 ) {
	i = atoi( arg[0] );
	TDH_reslimits( "cpu", i );
	strcpy( result, "0" );
	return( 0 );
	}

#ifdef ENABLE_PL
  /* if function name not found above, see if it's a ploticus custom function.. */
  i = PL_custom_function( name, arg, nargs, result, typ );
  return( i );
#endif

return( 1 ); 
}

