/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import quickfix.ConfigError;
import quickfix.DayConverter;
import quickfix.FieldConvertError;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SystemTime;

class SessionSchedule {
    private static final int NOT_SET = -1;
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{2}):(\\d{2}):(\\d{2})(.*)");
    private final TimeEndPoint startTime;
    private final TimeEndPoint endTime;

    SessionSchedule(SessionSettings settings, SessionID sessionID) throws ConfigError, FieldConvertError {
        boolean startDayPresent = settings.isSetting(sessionID, "StartDay");
        boolean endDayPresent = settings.isSetting(sessionID, "EndDay");
        if (startDayPresent && !endDayPresent) {
            throw new ConfigError("Session " + sessionID + ": StartDay used without EndDay");
        }
        if (endDayPresent && !startDayPresent) {
            throw new ConfigError("Session " + sessionID + ": EndDay used without StartDay");
        }
        TimeZone defaultTimeZone = this.getDefaultTimeZone(settings, sessionID);
        this.startTime = this.getTimeEndPoint(settings, sessionID, defaultTimeZone, "StartTime", "StartDay");
        this.endTime = this.getTimeEndPoint(settings, sessionID, defaultTimeZone, "EndTime", "EndDay");
    }

    private TimeEndPoint getTimeEndPoint(SessionSettings settings, SessionID sessionID, TimeZone defaultTimeZone, String timeSetting, String daySetting) throws ConfigError, FieldConvertError {
        Matcher matcher = TIME_PATTERN.matcher(settings.getString(sessionID, timeSetting));
        if (!matcher.find()) {
            throw new ConfigError("Session " + sessionID + ": could not parse time '" + settings.getString(sessionID, timeSetting) + "'.");
        }
        TimeZone timeZone = this.getTimeZone(matcher.group(4), defaultTimeZone);
        Calendar localTime = SystemTime.getUtcCalendar();
        localTime.setTimeZone(timeZone);
        localTime.set(11, Integer.parseInt(matcher.group(1)));
        localTime.set(12, Integer.parseInt(matcher.group(2)));
        localTime.set(13, Integer.parseInt(matcher.group(3)));
        int scheduleDay = this.getDay(settings, sessionID, daySetting, -1);
        if (scheduleDay != -1) {
            localTime.set(7, scheduleDay);
        }
        Calendar utcTime = SystemTime.getUtcCalendar();
        utcTime.setTime(localTime.getTime());
        return new TimeEndPoint(scheduleDay == -1 ? -1 : utcTime.get(7), utcTime, timeZone);
    }

    private TimeZone getDefaultTimeZone(SessionSettings settings, SessionID sessionID) throws ConfigError, FieldConvertError {
        TimeZone sessionTimeZone;
        if (settings.isSetting(sessionID, "TimeZone")) {
            String sessionTimeZoneID = settings.getString(sessionID, "TimeZone");
            sessionTimeZone = TimeZone.getTimeZone(sessionTimeZoneID);
            if ("GMT".equals(sessionTimeZone.getID()) && !"GMT".equals(sessionTimeZoneID)) {
                throw new ConfigError("Unrecognized time zone '" + sessionTimeZoneID + "' for session " + sessionID);
            }
        } else {
            sessionTimeZone = TimeZone.getTimeZone("UTC");
        }
        return sessionTimeZone;
    }

    private TimeZone getTimeZone(String tz, TimeZone defaultZone) {
        return "".equals(tz) ? defaultZone : TimeZone.getTimeZone(tz.trim());
    }

    private TimeInterval theMostRecentIntervalBefore(Calendar t) {
        TimeInterval timeInterval = new TimeInterval();
        Calendar intervalStart = timeInterval.getStart();
        intervalStart.setTimeInMillis(t.getTimeInMillis());
        intervalStart.set(11, this.startTime.getHour());
        intervalStart.set(12, this.startTime.getMinute());
        intervalStart.set(13, this.startTime.getSecond());
        intervalStart.set(14, 0);
        if (this.isSet(this.startTime.getDay())) {
            intervalStart.set(7, this.startTime.getDay());
            if (intervalStart.getTimeInMillis() > t.getTimeInMillis()) {
                intervalStart.add(3, -1);
            }
        } else if (intervalStart.getTimeInMillis() > t.getTimeInMillis()) {
            intervalStart.add(6, -1);
        }
        Calendar intervalEnd = timeInterval.getEnd();
        intervalEnd.setTimeInMillis(intervalStart.getTimeInMillis());
        intervalEnd.set(11, this.endTime.getHour());
        intervalEnd.set(12, this.endTime.getMinute());
        intervalEnd.set(13, this.endTime.getSecond());
        intervalEnd.set(14, 0);
        if (this.isSet(this.endTime.getDay())) {
            intervalEnd.set(7, this.endTime.getDay());
            if (intervalEnd.getTimeInMillis() <= intervalStart.getTimeInMillis()) {
                intervalEnd.add(4, 1);
            }
        } else if (intervalEnd.getTimeInMillis() <= intervalStart.getTimeInMillis()) {
            intervalEnd.add(7, 1);
        }
        return timeInterval;
    }

    public boolean isSameSession(Calendar time1, Calendar time2) {
        TimeInterval interval1 = this.theMostRecentIntervalBefore(time1);
        if (!interval1.isContainingTime(time1)) {
            return false;
        }
        TimeInterval interval2 = this.theMostRecentIntervalBefore(time2);
        if (!interval2.isContainingTime(time2)) {
            return false;
        }
        return interval1.equals(interval2);
    }

    private boolean isDailySession() {
        return !this.isSet(this.startTime.getDay()) && !this.isSet(this.endTime.getDay());
    }

    public boolean isSessionTime() {
        Calendar now = SystemTime.getUtcCalendar();
        TimeInterval interval = this.theMostRecentIntervalBefore(now);
        return interval.isContainingTime(now);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat dowFormat = new SimpleDateFormat("EEEE");
        dowFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss z");
        timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        TimeInterval ti = this.theMostRecentIntervalBefore(SystemTime.getUtcCalendar());
        this.formatTimeInterval(buf, ti, timeFormat, false);
        if (this.startTime.getTimeZone() != SystemTime.UTC_TIMEZONE || this.endTime.getTimeZone() != SystemTime.UTC_TIMEZONE) {
            buf.append(" (");
            this.formatTimeInterval(buf, ti, timeFormat, true);
            buf.append(")");
        }
        return buf.toString();
    }

    private void formatTimeInterval(StringBuffer buf, TimeInterval timeInterval, SimpleDateFormat timeFormat, boolean local) {
        if (!this.isDailySession()) {
            buf.append("weekly, ");
            this.formatDayOfWeek(buf, this.startTime.getDay());
            buf.append(" ");
        } else {
            buf.append("daily, ");
        }
        if (local) {
            timeFormat.setTimeZone(this.startTime.getTimeZone());
        }
        buf.append(timeFormat.format(timeInterval.getStart().getTime()));
        buf.append(" - ");
        if (!this.isDailySession()) {
            this.formatDayOfWeek(buf, this.endTime.getDay());
            buf.append(" ");
        }
        if (local) {
            timeFormat.setTimeZone(this.endTime.getTimeZone());
        }
        buf.append(timeFormat.format(timeInterval.getEnd().getTime()));
    }

    private void formatDayOfWeek(StringBuffer buf, int dayOfWeek) {
        try {
            String dayName = DayConverter.toString(dayOfWeek).toUpperCase();
            if (dayName.length() > 3) {
                dayName = dayName.substring(0, 3);
            }
            buf.append(dayName);
        }
        catch (ConfigError e) {
            buf.append("[Error: unknown day " + dayOfWeek + "]");
        }
    }

    private int getDay(SessionSettings settings, SessionID sessionID, String key, int defaultValue) throws ConfigError, FieldConvertError {
        return settings.isSetting(sessionID, key) ? DayConverter.toInteger(settings.getString(sessionID, key)) : -1;
    }

    private boolean isSet(int value) {
        return value != -1;
    }

    private int timeInSeconds(int hour, int minute, int second) {
        return hour * 3600 + minute * 60 + second;
    }

    private static class TimeInterval {
        private Calendar start = SystemTime.getUtcCalendar();
        private Calendar end = SystemTime.getUtcCalendar();
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$quickfix$SessionSchedule;

        private TimeInterval() {
        }

        public boolean isContainingTime(Calendar t) {
            return t.equals(this.start) || t.equals(this.end) || t.after(this.start) && t.before(this.end);
        }

        public String toString() {
            return this.start.getTime() + " --> " + this.end.getTime();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimeInterval)) {
                return false;
            }
            TimeInterval otherInterval = (TimeInterval)other;
            return this.start.equals(otherInterval.start) && this.end.equals(otherInterval.end);
        }

        public int hashCode() {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"hashCode not supported");
            }
            return 0;
        }

        public Calendar getStart() {
            return this.start;
        }

        public Calendar getEnd() {
            return this.end;
        }

        static {
            Class<?> clazz = class$quickfix$SessionSchedule;
            if (clazz == null) {
                clazz = class$quickfix$SessionSchedule = new SessionSchedule[0].getClass().getComponentType();
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }
    }

    private class TimeEndPoint {
        private final int weekDay;
        private final int hour;
        private final int minute;
        private final int second;
        private final int timeInSeconds;
        private final TimeZone tz;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$quickfix$SessionSchedule;

        public TimeEndPoint(int day, Calendar c, TimeZone tz) {
            this(day, c.get(11), c.get(12), c.get(13), tz);
        }

        public TimeEndPoint(int day, int hour, int minute, int second, TimeZone tz) {
            this.weekDay = day;
            this.hour = hour;
            this.minute = minute;
            this.second = second;
            this.tz = tz;
            this.timeInSeconds = SessionSchedule.this.timeInSeconds(hour, minute, second);
        }

        public int getHour() {
            return this.hour;
        }

        public int getMinute() {
            return this.minute;
        }

        public int getSecond() {
            return this.second;
        }

        public String toString() {
            try {
                return (SessionSchedule.this.isSet(this.weekDay) ? "d=" + DayConverter.toString(this.weekDay) + "," : "") + this.hour + ":" + this.minute + ":" + this.second + " " + this.tz;
            }
            catch (ConfigError e) {
                return "ERROR: " + e.getMessage();
            }
        }

        public int getDay() {
            return this.weekDay;
        }

        public int getTimeInSeconds() {
            return this.timeInSeconds;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof TimeEndPoint) {
                TimeEndPoint otherTime = (TimeEndPoint)o;
                return this.timeInSeconds == otherTime.timeInSeconds;
            }
            return false;
        }

        public int hashCode() {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"hashCode not supported");
            }
            return 0;
        }

        public TimeZone getTimeZone() {
            return this.tz;
        }

        static {
            Class<?> clazz = class$quickfix$SessionSchedule;
            if (clazz == null) {
                clazz = class$quickfix$SessionSchedule = new SessionSchedule[0].getClass().getComponentType();
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }
    }
}

