#ifndef FIX_VALUES_H
#define FIX_VALUES_H

#include <string>

namespace FIX
{
  const int DeliveryForm_BOOKENTRY = 1;
  const int DeliveryForm_BEARER = 2;
  const int DeliveryForm_BOOK_ENTRY = 1;
  const int ExecRestatementReason_WAREHOUSE_RECAP = 10;
  const int ExecRestatementReason_CANCEL_ON_SYSTEM_FAILURE = 7;
  const int ExecRestatementReason_PARTIAL_DECLINE_OF_ORDERQTY = 5;
  const int ExecRestatementReason_GT_CORPORATE_ACTION = 0;
  const int ExecRestatementReason_PEG_REFRESH = 11;
  const int ExecRestatementReason_CANCELED_NOT_BEST = 9;
  const int ExecRestatementReason_CANCEL_ON_TRADING_HALT = 6;
  const int ExecRestatementReason_VERBAL_CHANGE = 2;
  const int ExecRestatementReason_OTHER = 99;
  const int ExecRestatementReason_BROKER_OPTION = 4;
  const int ExecRestatementReason_REPRICING_OF_ORDER = 3;
  const int ExecRestatementReason_MARKET = 8;
  const int ExecRestatementReason_GT_RENEWAL = 1;
  const int AllocIntermedReqType_PENDING_RELEASE = 2;
  const int AllocIntermedReqType_PENDING_REVERSAL = 3;
  const int AllocIntermedReqType_ACCOUNT_LEVEL_REJECT = 6;
  const int AllocIntermedReqType_BLOCK_LEVEL_REJECT = 5;
  const int AllocIntermedReqType_PENDING_ACCEPT = 1;
  const int AllocIntermedReqType_ACCEPT = 4;
  const int SecurityListTypeSource_GICS = 3;
  const int SecurityListTypeSource_NAICS = 2;
  const int SecurityListTypeSource_ICB = 1;
  const int CollInquiryQualifier_OUTSTANDING_TRADES = 7;
  const int CollInquiryQualifier_PARTIALLY_ASSIGNED = 5;
  const int CollInquiryQualifier_TRADE_DATE = 0;
  const int CollInquiryQualifier_FULLY_ASSIGNED = 6;
  const int CollInquiryQualifier_SUBSTITUTION_ELIGIBLE = 3;
  const int CollInquiryQualifier_NOT_ASSIGNED = 4;
  const int CollInquiryQualifier_COLLATERAL_INSTRUMENT = 2;
  const int CollInquiryQualifier_TRADEDATE = 0;
  const int CollInquiryQualifier_COLLATERALINSTRUMENT = 2;
  const int CollInquiryQualifier_GC_INSTRUMENT = 1;
  const int ContingencyType_ONE_UPDATES_THE_OTHER_4 = 4;
  const int ContingencyType_ONE_TRIGGERS_THE_OTHER = 2;
  const int ContingencyType_ONE_CANCELS_THE_OTHER = 1;
  const int ContingencyType_ONE_UPDATES_THE_OTHER_3 = 3;
  const char EmailType_NEW = '0';
  const char EmailType_REPLY = '1';
  const char EmailType_ADMIN_REPLY = '2';
  const char IOIQltyInd_MEDIUM = 'M';
  const char IOIQltyInd_HIGH = 'H';
  const char IOIQltyInd_LOW = 'L';
  const int MultiLegRptTypeReq_REPORT_BY_INSTRUMENT_LEGS_BELONGING_TO_THE_MULTILEG_SECURITY_ONLY = 2;
  const int MultiLegRptTypeReq_REPORT_BY_MULTILEG_SECURITY_AND_BY_INSTRUMENT_LEGS_BELONGING_TO_THE_MULTILEG_SECURITY = 1;
  const int MultiLegRptTypeReq_REPORT_BY_MULITLEG_SECURITY_ONLY = 0;
  const int AccountType_HOUSE_TRADER = 3;
  const int AccountType_ACCOUNT_IS_CARRIED_ON_CUSTOMER_SIDE_OF_THE_BOOKS = 1;
  const int AccountType_ACCOUNT_IS_CARRIED_ON_NON_CUSTOMER_SIDE_OF_BOOKS = 2;
  const int AccountType_FLOOR_TRADER = 4;
  const int AccountType_JOINT_BACK_OFFICE_ACCOUNT = 8;
  const int AccountType_ACCOUNT_IS_CARRIED_ON_NON_CUSTOMER_SIDE_OF_BOOKS_AND_IS_CROSS_MARGINED = 6;
  const int AccountType_ACCOUNT_IS_CARRIED_ON_CUSTOMER_SIDE_OF_BOOKS = 1;
  const int AccountType_JOINT_BACKOFFICE_ACCOUNT = 8;
  const int AccountType_ACCOUNT_IS_HOUSE_TRADER_AND_IS_CROSS_MARGINED = 7;
  const int HaltReasonInt_ADDITIONAL_INFORMATION = 3;
  const int HaltReasonInt_NEWS_PENDING = 4;
  const int HaltReasonInt_ORDER_INFLUX = 1;
  const int HaltReasonInt_NEWS_DISSEMINATION = 0;
  const int HaltReasonInt_EQUIPMENT_CHANGEOVER = 5;
  const int HaltReasonInt_ORDER_IMBALANCE = 2;
  const char ClearingFeeIndicator_106H_AND_106J_FIRMS[] = "H";
  const char ClearingFeeIndicator_1ST_YEAR_DELEGATE_TRADING_FOR_HIS_OWN_ACCOUNT[] = "1";
  const char ClearingFeeIndicator_GIM_IDEM_AND_COM_MEMBERSHIP_INTEREST_HOLDERS[] = "I";
  const char ClearingFeeIndicator_2ND_YEAR_DELEGATE_TRADING_FOR_HIS_OWN_ACCOUNT[] = "2";
  const char ClearingFeeIndicator_4TH_YEAR_DELEGATE_TRADING_FOR_HIS_OWN_ACCOUNT[] = "4";
  const char ClearingFeeIndicator_3RD_YEAR_DELEGATE_TRADING_FOR_OWN_ACCOUNT[] = "3";
  const char ClearingFeeIndicator_LESSEE_106F_EMPLOYEES[] = "L";
  const char ClearingFeeIndicator_NON_MEMBER_AND_CUSTOMER[] = "C";
  const char ClearingFeeIndicator_5TH_YEAR_DELEGATE_TRADING_FOR_HIS_OWN_ACCOUNT[] = "5";
  const char ClearingFeeIndicator_FULL_AND_ASSOCIATE_MEMBER_TRADING_FOR_OWN_ACCOUNT_AND_AS_FLOOR_BROKERS[] = "F";
  const char ClearingFeeIndicator_CBOE_MEMBER[] = "B";
  const char ClearingFeeIndicator_1ST_YEAR_DELEGATE_TRADING_FOR_OWN_ACCOUNT[] = "1";
  const char ClearingFeeIndicator_5TH_YEAR_DELEGATE_TRADING_FOR_OWN_ACCOUNT[] = "5";
  const char ClearingFeeIndicator_LESSEE_AND_106F_EMPLOYEES[] = "L";
  const char ClearingFeeIndicator_FULL_AND_ASSOCIATE_MEMBER_TRADING_FOR_OWN_ACCOUNT_AND_AS_FLOOR[] = "F";
  const char ClearingFeeIndicator_3RD_YEAR_DELEGATE_TRADING_FOR_HIS_OWN_ACCOUNT[] = "3";
  const char ClearingFeeIndicator_2ND_YEAR_DELEGATE_TRADING_FOR_OWN_ACCOUNT[] = "2";
  const char ClearingFeeIndicator_EQUITY_MEMBER_AND_CLEARING_MEMBER[] = "E";
  const char ClearingFeeIndicator_ALL_OTHER_OWNERSHIP_TYPES[] = "M";
  const char ClearingFeeIndicator_6TH_YEAR_AND_BEYOND_DELEGATE_TRADING_FOR_HIS_OWN_ACCOUNT[] = "9";
  const char ClearingFeeIndicator_4TH_YEAR_DELEGATE_TRADING_FOR_OWN_ACCOUNT[] = "4";
  const char ClearingFeeIndicator_6TH_YEAR_DELEGATE_TRADING_FOR_OWN_ACCOUNT[] = "9";
  const int BidType_DISCLOSED_STYLE = 2;
  const int BidType_NO_BIDDING_PROCESS = 3;
  const int BidType_DISCLOSED_SYTLE = 2;
  const int BidType_NON_DISCLOSED_STYLE = 1;
  const int QuotePriceType_PER_SHARE = 2;
  const int QuotePriceType_PREMIUM_PERCENTAGE_POINTS_OVER_PAR = 5;
  const int QuotePriceType_DISCOUNT_PERCENTAGE_POINTS_BELOW_PAR = 4;
  const int QuotePriceType_YIELD = 10;
  const int QuotePriceType_PREMIUM = 5;
  const int QuotePriceType_TED_YIELD = 8;
  const int QuotePriceType_FIXED_AMOUNT = 3;
  const int QuotePriceType_DISCOUNT = 4;
  const int QuotePriceType_YIELD_SPREAD = 9;
  const int QuotePriceType_TED_PRICE = 7;
  const int QuotePriceType_PERCENT = 1;
  const int QuotePriceType_SPREAD = 6;
  const int QuotePriceType_BASIS_POINTS_RELATIVE_TO_BENCHMARK = 6;
  const int MultilegPriceMethod_CONTRACT_WEIGHTED_AVERAGE_PRICE = 4;
  const int MultilegPriceMethod_REVERSED_NET_PRICE = 1;
  const int MultilegPriceMethod_MULTIPLIED_PRICE = 5;
  const int MultilegPriceMethod_INDIVIDUAL = 3;
  const int MultilegPriceMethod_YIELD_DIFFERENCE = 2;
  const int MultilegPriceMethod_NET_PRICE = 0;
  const int ListMethod_PRE_LISTED_ONLY = 0;
  const int ListMethod_USER_REQUESTED = 1;
  const char MDImplicitDelete_NO = 'N';
  const char MDImplicitDelete_YES = 'Y';
  const int RoutingType_TARGET_LIST = 2;
  const int RoutingType_TARGET_FIRM = 1;
  const int RoutingType_BLOCK_LIST = 4;
  const int RoutingType_BLOCK_FIRM = 3;
  const char BidTradeType_AGENCY = 'A';
  const char BidTradeType_VWAP_GUARANTEE = 'G';
  const char BidTradeType_RISK_TRADE = 'R';
  const char BidTradeType_GUARANTEED_CLOSE = 'J';
  const int OrdRejReason_INCORRECT_ALLOCATED_QUANTITY = 14;
  const int OrdRejReason_DUPLICATE_OF_A_VERBALLY_COMMUNICATED_ORDER = 7;
  const int OrdRejReason_ORDER_EXCEEDS_LIMIT = 3;
  const int OrdRejReason_EXCHANGE_CLOSED = 2;
  const int OrdRejReason_SURVEILLENCE_OPTION = 12;
  const int OrdRejReason_UNKNOWN_ORDER = 5;
  const int OrdRejReason_UNSUPPORTED_ORDER_CHARACTERISTIC = 11;
  const int OrdRejReason_DUPLICATE_ORDER = 6;
  const int OrdRejReason_TOO_LATE_TO_ENTER = 4;
  const int OrdRejReason_UNSUPPORTED_ORDER_CHARACTERISTIC12_SURVEILLENCE_OPTION = 11;
  const int OrdRejReason_INCORRECT_QUANTITY = 13;
  const int OrdRejReason_INVALID_PRICE_INCREMENT = 18;
  const int OrdRejReason_UNKNOWN_ACCOUNT = 15;
  const int OrdRejReason_INVALID_INVESTOR_ID = 10;
  const int OrdRejReason_UNKNOWN_SYMBOL = 1;
  const int OrdRejReason_OTHER = 99;
  const int OrdRejReason_BROKER = 0;
  const int OrdRejReason_BROKER_OPTION = 0;
  const int OrdRejReason_PRICE_EXCEEDS_CURRENT_PRICE_BAND = 16;
  const int OrdRejReason_TRADE_ALONG_REQUIRED = 9;
  const int OrdRejReason_STALE_ORDER = 8;
  const int MaturityMonthYearIncrementUnits_WEEKS = 2;
  const int MaturityMonthYearIncrementUnits_MONTHS = 0;
  const int MaturityMonthYearIncrementUnits_YEARS = 3;
  const int MaturityMonthYearIncrementUnits_DAYS = 1;
  const char DisplayWhen_EXHAUST = '2';
  const char DisplayWhen_IMMEDIATE = '1';
  const int ApplQueueAction_END_SESSION = 3;
  const int ApplQueueAction_QUEUE_FLUSHED = 1;
  const int ApplQueueAction_OVERLAY_LAST = 2;
  const int ApplQueueAction_NO_ACTION_TAKEN = 0;
  const char RegistTransType_REPLACE = '1';
  const char RegistTransType_NEW = '0';
  const char RegistTransType_CANCEL = '2';
  const int PriceType_PRODUCT_TICKS_IN_HALFS = 13;
  const int PriceType_PER_SHARE = 2;
  const int PriceType_DISCOUNT_PERCENTAGE_POINTS_BELOW_PAR = 4;
  const int PriceType_PREMIUM_PERCENTAGE_POINTS_OVER_PAR = 5;
  const int PriceType_PRODUCT_TICKS_IN_FOURTHS = 14;
  const int PriceType_YIELD = 9;
  const int PriceType_TED_YIELD = 8;
  const int PriceType_PREMIUM = 5;
  const int PriceType_FIXED_AMOUNT = 3;
  const int PriceType_DISCOUNT = 4;
  const int PriceType_PRODUCT_TICKS_IN_SIXTY_FORTHS = 18;
  const int PriceType_PRODUCT_TICKS_IN_ONE_TWENTY_EIGHTS = 19;
  const int PriceType_PERCENTAGE = 1;
  const int PriceType_PRODUCT_TICKS_IN_EIGHTS = 15;
  const int PriceType_PRODUCT_TICKS_IN_THIRTY_SECONDS = 17;
  const int PriceType_PRODUCT_TICKS_IN_SIXTEENTHS = 16;
  const int PriceType_PER_UNIT = 2;
  const int PriceType_VARIABLE_CABINET_TRADE_PRICE = 11;
  const int PriceType_TED_PRICE = 7;
  const int PriceType_SPREAD = 6;
  const int PriceType_FIXED_CABINET_TRADE_PRICE = 10;
  const int PriceType_BASIS_POINTS_RELATIVE_TO_BENCHMARK = 6;
  const int SettlObligMode_PRELIMINARY = 1;
  const int SettlObligMode_FINAL = 2;
  const char SecurityUpdateAction_DELETE = 'D';
  const char SecurityUpdateAction_ADD = 'A';
  const char SecurityUpdateAction_MODIFY = 'M';
  const int NetworkRequestType_STOP_SUBSCRIBING = 4;
  const int NetworkRequestType_SUBSCRIBE = 2;
  const int NetworkRequestType_SNAPSHOT = 1;
  const int NetworkRequestType_LEVEL_OF_DETAIL_THEN_NOCOMPIDS_BECOMES_REQUIRED = 8;
  const int PartyRole_EXECUTION_VENUE = 73;
  const int PartyRole_CLIENT_ID = 3;
  const int PartyRole_MARKET_DATA_ENTRY_ORIGINATOR = 74;
  const int PartyRole_ORDER_ORIGINATION_FIRM = 13;
  const int PartyRole_PLEDGEE_ACCOUNT = 51;
  const int PartyRole_CONTRA_TRADER = 37;
  const int PartyRole_MULTILATERAL_TRADING_FACILITY = 64;
  const int PartyRole_CENTRAL_REGISTRATION_DEPOSITORY = 82;
  const int PartyRole_REPORT_ORIGINATOR = 62;
  const int PartyRole_TRANSFER_TO_FIRM = 40;
  const int PartyRole_BROKERCLEARINGID = 81;
  const int PartyRole_ASSET_MANAGER = 49;
  const int PartyRole_INTRODUCING_BROKER = 60;
  const int PartyRole_LOCATE_LENDING_FIRM = 8;
  const int PartyRole_CONTRA_CLEARING_FIRM = 18;
  const int PartyRole_CORRESPONDENT_CLEARING_ORGANIZATION = 25;
  const int PartyRole_CUSTODIAN = 28;
  const int PartyRole_GIVEUP_CLEARING_FIRM = 14;
  const int PartyRole_EXECUTING_TRADER = 12;
  const int PartyRole_EXECUTING_UNIT = 59;
  const int PartyRole_BROKER_OF_CREDIT = 2;
  const int PartyRole_CORRESPONDANT_CLEARING_FIRM = 15;
  const int PartyRole_SETTLEMENT_LOCATION = 10;
  const int PartyRole_THIRD_PARTY_ALLOCATION_FIRM = 47;
  const int PartyRole_ORDER_ORIGINATION_TRADER = 11;
  const int PartyRole_HOST_COMPETENT_AUTHORITY = 68;
  const int PartyRole_ORDER_ENTRY_OPERATOR_ID = 44;
  const int PartyRole_SPONSORING_FIRM = 19;
  const int PartyRole_INTRODUCING_FIRM = 6;
  const int PartyRole_CLEARING_FIRM = 4;
  const int PartyRole_CONTRA_POSITION_ACCOUNT = 41;
  const int PartyRole_INVESTOR_ID = 5;
  const int PartyRole_ENTERING_TRADER = 36;
  const int PartyRole_LOCATE = 8;
  const int PartyRole_LARGE_TRADER_REPORTABLE_ACCOUNT = 52;
  const int PartyRole_ACCEPTABLE_SETTLING_COUNTERPARTY = 84;
  const int PartyRole_PRIME_BROKER_PROVIDING_GENERAL_TRADE_SERVICES = 79;
  const int PartyRole_FORIEGN_FIRM = 46;
  const int PartyRole_ACCEPTABLE_COUNTERPARTY = 56;
  const int PartyRole_CUSTOMER_ACCOUNT = 24;
  const int PartyRole_POSITION_ACCOUNT = 38;
  const int PartyRole_LIQUIDITY_PROVIDER = 35;
  const int PartyRole_MARKET_MAKER = 66;
  const int PartyRole_AGENT = 30;
  const int PartyRole_ENTERING_UNIT = 58;
  const int PartyRole_FOREIGN_FIRM = 46;
  const int PartyRole_CLEARING_ACCOUNT = 83;
  const int PartyRole_HOME_COMPETENT_AUTHORITY = 69;
  const int PartyRole_INTERESTED_PARTY = 33;
  const int PartyRole_SESSION_ID = 55;
  const int PartyRole_REPORTING_INTERMEDIARY = 72;
  const int PartyRole_INVESTMENT_FIRM = 67;
  const int PartyRole_TRADER_MNEMONIC = 53;
  const int PartyRole_INTERNAL_CARRY_ACCOUNT = 43;
  const int PartyRole_CONTRA_FIRM = 17;
  const int PartyRole_CORRESPONDENT_BROKER = 26;
  const int PartyRole_CLEARING_ORGANIZATION = 21;
  const int PartyRole_SUB_CUSTODIAN = 31;
  const int PartyRole_BUYER_SELLER = 27;
  const int PartyRole_STEP_OUT_FIRM = 80;
  const int PartyRole_MARKET_DATA_MARKET = 77;
  const int PartyRole_EXCHANGE = 22;
  const int PartyRole_CLAIMING_ACCOUNT = 48;
  const int PartyRole_SECONDARY_ACCOUNT_NUMBER = 45;
  const int PartyRole_ALLOCATION_ENTITY = 78;
  const int PartyRole_INTERMEDIARY = 29;
  const int PartyRole_EXECUTING_FIRM = 1;
  const int PartyRole_LOCATION_ID = 75;
  const int PartyRole_DESK_ID = 76;
  const int PartyRole_EXECUTING_SYSTEM = 16;
  const int PartyRole_BENEFICIARY = 32;
  const int PartyRole_FUND_MANAGER_CLIENT_ID = 9;
  const int PartyRole_CONTRA_INVESTOR_ID = 39;
  const int PartyRole_UNACCEPTABLE_COUNTERPARTY = 57;
  const int PartyRole_UNDERLYING_CONTRA_FIRM = 20;
  const int PartyRole_QUOTE_ORIGINATOR = 61;
  const int PartyRole_REGULATED_MARKET = 65;
  const int PartyRole_COMPETENT_AUTHORITY_OF_THE_TRANSACTION = 71;
  const int PartyRole_ENTERING_FIRM = 7;
  const int PartyRole_UNACCEPTABLE_SETTLING_COUNTERPARTY = 85;
  const int PartyRole_SENDER_LOCATION = 54;
  const int PartyRole_SYSTEMATIC_INTERNALISER = 63;
  const int PartyRole_CONTRA_EXCHANGE = 42;
  const int PartyRole_REGULATORY_BODY = 34;
  const int PartyRole_PLEDGOR_ACCOUNT = 50;
  const int PartyRole_COMPETENT_AUTHORITY_OF_THE_MOST_RELEVANT_MARKET_IN_TERMS_OF_LIQUIDITY = 70;
  const char AssignmentMethod_PRO_RATA = 'P';
  const char AssignmentMethod_RANDOM = 'R';
  const char AssignmentMethod_PRORATA = 'P';
  const int StrategyParameterType_TZTIMEONLY = 27;
  const int StrategyParameterType_MONTHYEAR = 18;
  const int StrategyParameterType_PRICE = 8;
  const int StrategyParameterType_QTY = 7;
  const int StrategyParameterType_BOOLEAN = 13;
  const int StrategyParameterType_MULTIPLECHARVALUE = 15;
  const int StrategyParameterType_CHAR = 12;
  const int StrategyParameterType_NUMINGROUP = 3;
  const int StrategyParameterType_TAGNUM = 5;
  const int StrategyParameterType_COUNTRY = 25;
  const int StrategyParameterType_TENOR = 29;
  const int StrategyParameterType_LOCALMKTTIME = 21;
  const int StrategyParameterType_INT = 1;
  const int StrategyParameterType_LOCALMKTDATE = 21;
  const int StrategyParameterType_EXCHANGE = 17;
  const int StrategyParameterType_LANGUAGE = 26;
  const int StrategyParameterType_PERCENTAGE = 11;
  const int StrategyParameterType_LENGTH = 2;
  const int StrategyParameterType_TZTIMESTAMP = 28;
  const int StrategyParameterType_MULTIPLESTRINGVALUE = 24;
  const int StrategyParameterType_UTCTIMESTAMP = 19;
  const int StrategyParameterType_DATA = 23;
  const int StrategyParameterType_CURRENCY = 16;
  const int StrategyParameterType_STRING = 14;
  const int StrategyParameterType_AMT = 10;
  const int StrategyParameterType_FLOAT = 6;
  const int StrategyParameterType_UTCDATE = 22;
  const int StrategyParameterType_UTCTIMEONLY = 20;
  const int StrategyParameterType_SEQNUM = 4;
  const int StrategyParameterType_UTCDATEONLY = 22;
  const int StrategyParameterType_PRICEOFFSET = 9;
  const int EncryptMethod_PGP_DES_MD5 = 5;
  const int EncryptMethod_PKCS_DES = 3;
  const int EncryptMethod_PKCS = 1;
  const int EncryptMethod_PGP_DES = 4;
  const int EncryptMethod_NONE = 0;
  const int EncryptMethod_DES = 2;
  const int EncryptMethod_NONE_OTHER = 0;
  const int EncryptMethod_PEM_DES_MD5 = 6;
  const char PosAmtType_ACCRUED_COUPON_AMOUNT[] = "ACPN";
  const char PosAmtType_PREMIUM_AMOUNT[] = "PREM";
  const char PosAmtType_INCREMENTAL_COLLATERALIZED_MARK_TO_MARKET[] = "ICMTM";
  const char PosAmtType_TOTAL_BANKED_AMOUNT[] = "BANK";
  const char PosAmtType_FINAL_MARK_TO_MARKET_AMOUNT[] = "FMTM";
  const char PosAmtType_SETTLEMENT_VALUE[] = "SETL";
  const char PosAmtType_CASH_AMOUNT[] = "CASH";
  const char PosAmtType_INITIAL_TRADE_COUPON_AMOUNT[] = "ICPN";
  const char PosAmtType_INCREMENTAL_ACCRUED_COUPON[] = "IACPN";
  const char PosAmtType_VALUE_ADJUSTED_AMOUNT[] = "VADJ";
  const char PosAmtType_START_OF_DAY_MARK_TO_MARKET_AMOUNT[] = "SMTM";
  const char PosAmtType_COLLATERALIZED_MARK_TO_MARKET[] = "CMTM";
  const char PosAmtType_CASH_RESIDUAL_AMOUNT[] = "CRES";
  const char PosAmtType_COMPENSATION_AMOUNT[] = "DLV";
  const char PosAmtType_TRADE_VARIATION_AMOUNT[] = "TVAR";
  const char PosAmtType_COUPON_AMOUNT[] = "CPN";
  const char PosAmtType_TOTAL_COLLATERALIZED_AMOUNT[] = "COLAT";
  const char PosAmtType_INCREMENTAL_MARK_TO_MARKET_AMOUNT[] = "IMTM";
  const char ResetSeqNumFlag_NO = 'N';
  const char ResetSeqNumFlag_YES = 'Y';
  const int CollInquiryResult_NO_COLLATERAL_FOUND_FOR_THE_ORDER_SPECIFIED = 7;
  const int CollInquiryResult_INVALID_DESTINATION_REQUESTED = 5;
  const int CollInquiryResult_UNAUTHORIZED_FOR_COLLATERAL_INQUIRY = 9;
  const int CollInquiryResult_INVALID_OR_UNKNOWN_COLLATERAL_TYPE = 2;
  const int CollInquiryResult_SUCCESSFUL = 0;
  const int CollInquiryResult_OTHER = 99;
  const int CollInquiryResult_COLLATERAL_INQUIRY_TYPE_NOT_SUPPORTED = 8;
  const int CollInquiryResult_INVALID_OR_UNKNOWN_INSTRUMENT = 1;
  const int CollInquiryResult_INVALID_PARTIES = 3;
  const int CollInquiryResult_INVALID_TRANSPORT_TYPE_REQUESTED = 4;
  const int CollInquiryResult_NO_COLLATERAL_FOUND_FOR_THE_TRADE_SPECIFIED = 6;
  const int CollAsgnRespType_DECLINED = 2;
  const int CollAsgnRespType_RECEIVED = 0;
  const int CollAsgnRespType_REJECTED = 3;
  const int CollAsgnRespType_ACCEPTED = 1;
  const char UnsolicitedIndicator_NO = 'N';
  const char UnsolicitedIndicator_YES = 'Y';
  const int QuoteEntryRejectReason_INVALID_PRICE = 8;
  const int QuoteEntryRejectReason_NOT_AUTHORIZED_TO_QUOTE_SECURITY = 9;
  const int QuoteEntryRejectReason_TOO_LATE_TO_ENTER = 4;
  const int QuoteEntryRejectReason_QUOTE_EXCEEDS_LIMIT = 3;
  const int QuoteEntryRejectReason_EXCHANGE = 2;
  const int QuoteEntryRejectReason_UNKNOWN_SYMBOL = 1;
  const int QuoteEntryRejectReason_INVALID_BID_ASK_SPREAD = 7;
  const int QuoteEntryRejectReason_UNKNOWN_QUOTE = 5;
  const int QuoteEntryRejectReason_DUPLICATE_QUOTE = 6;
  const char OrderCapacity_PROPRIETARY = 'G';
  const char OrderCapacity_RISKLESS_PRINCIPAL = 'R';
  const char OrderCapacity_AGENT_FOR_OTHER_MEMBER = 'W';
  const char OrderCapacity_PRINCIPAL = 'P';
  const char OrderCapacity_AGENCY = 'A';
  const char OrderCapacity_INDIVIDUAL = 'I';
  const int QuoteAckStatus_CANCELED_FOR_UNDERLYING = 3;
  const int QuoteAckStatus_CANCELED_ALL = 4;
  const int QuoteAckStatus_CANCELED_FOR_SECURITY_TYPE = 2;
  const int QuoteAckStatus_REJECTED = 5;
  const int QuoteAckStatus_CANCELED_FOR_SYMBOL = 1;
  const int QuoteAckStatus_ACCEPTED = 0;
  const int UserRequestType_CHANGE_PASSWORD_FOR_USER = 3;
  const int UserRequestType_CHANGEPASSWORDFORUSER = 3;
  const int UserRequestType_LOGOFFUSER = 2;
  const int UserRequestType_LOG_OFF_USER = 2;
  const int UserRequestType_REQUEST_INDIVIDUAL_USER_STATUS = 4;
  const int UserRequestType_LOGONUSER = 1;
  const int UserRequestType_LOG_ON_USER = 1;
  const int TradeReportTransType_REPLACE = 2;
  const int TradeReportTransType_NEW = 0;
  const int TradeReportTransType_REVERSE = 4;
  const int TradeReportTransType_CANCEL = 1;
  const int TradeReportTransType_CANCEL_DUE_TO_BACK_OUT_OF_TRADE = 5;
  const int TradeReportTransType_RELEASE = 3;
  const char AdvSide_CROSS = 'X';
  const char AdvSide_TRADE = 'T';
  const char AdvSide_BUY = 'B';
  const char AdvSide_SELL = 'S';
  const int CoveredOrUncovered_COVERED = 0;
  const int CoveredOrUncovered_UNCOVERED = 1;
  const int AcctIDSource_TFM = 3;
  const int AcctIDSource_BIC = 1;
  const int AcctIDSource_OTHER = 99;
  const int AcctIDSource_OMGEO = 4;
  const int AcctIDSource_DTCC_CODE = 5;
  const int AcctIDSource_SID_CODE = 2;
  const int TradeRequestType_UNMATCHED_TRADES_THAT_MATCH_CRITERIA = 2;
  const int TradeRequestType_ALL_TRADES = 0;
  const int TradeRequestType_MATCHED_TRADES_MATCHING_CRITERIA_PROVIDED_ON_REQUEST = 1;
  const int TradeRequestType_UNREPORTED_TRADES_THAT_MATCH_CRITERIA = 3;
  const int TradeRequestType_ADVISORIES_THAT_MATCH_CRITERIA = 4;
  const int TradSesStatus_HALTED = 1;
  const int TradSesStatus_REQUEST_REJECTED = 6;
  const int TradSesStatus_OPEN = 2;
  const int TradSesStatus_PRE_OPEN = 4;
  const int TradSesStatus_UNKNOWN = 0;
  const int TradSesStatus_PRE_CLOSE = 5;
  const int TradSesStatus_CLOSED = 3;
  const int PegPriceType_LAST_PEG = 1;
  const int PegPriceType_PRIMARY_PEG = 5;
  const int PegPriceType_OPENING_PEG = 3;
  const int PegPriceType_FIXED_PEG_TO_LOCAL_BEST_BID_OR_OFFER_AT_TIME_OF_ORDER = 6;
  const int PegPriceType_TRAILING_STOP_PEG = 8;
  const int PegPriceType_PEG_TO_LIMIT_PRICE = 9;
  const int PegPriceType_MID_PRICE_PEG = 2;
  const int PegPriceType_MARKET_PEG = 4;
  const int PegPriceType_PEG_TO_VWAP = 7;
  const int StreamAsgnRejReason_NO_AVAILABLE_STREAM = 3;
  const int StreamAsgnRejReason_EXCEEDS_MAXIMUM_SIZE = 1;
  const int StreamAsgnRejReason_UNKNOWN_CLIENT = 0;
  const int StreamAsgnRejReason_UNKNOWN_OR_INVALID_CURRENCY_PAIR = 2;
  const int StreamAsgnRejReason_OTHER = 99;
  const char ValuationMethod_FUTURES_STYLE_WITH_AN_ATTACHED_CASH_ADJUSTMENT[] = "FUTDA";
  const char ValuationMethod_PREMIUM_STYLE[] = "EQTY";
  const char ValuationMethod_CDS_IN_DELIVERY[] = "CDSD";
  const char ValuationMethod_CDS_STYLE_COLLATERALIZATION_OF_MARKET_TO_MARKET_AND_COUPON[] = "CDS";
  const char ValuationMethod_FUTURES_STYLE_MARK_TO_MARKET[] = "FUT";
  const char TriggerType_SPECIFIED_TRADING_SESSION = '2';
  const char TriggerType_NEXT_AUCTION = '3';
  const char TriggerType_PRICE_MOVEMENT = '4';
  const char TriggerType_PARTIAL_EXECUTION = '1';
  const char PriceProtectionScope_LOCAL = '1';
  const char PriceProtectionScope_NONE = '0';
  const char PriceProtectionScope_GLOBAL = '3';
  const char PriceProtectionScope_NATIONAL = '2';
  const int TradeReportRejectReason_INVALID_PARTY_INFORMATION = 1;
  const int TradeReportRejectReason_UNAUTHORIZED_TO_REPORT_TRADES = 3;
  const int TradeReportRejectReason_INVALID_PARTY_ONFORMATION = 1;
  const int TradeReportRejectReason_UNKNOWN_INSTRUMENT = 2;
  const int TradeReportRejectReason_SUCCESSFUL = 0;
  const int TradeReportRejectReason_OTHER = 99;
  const int TradeReportRejectReason_INVALID_TRADE_TYPE = 4;
  const int SecurityListType_NEWSPAPER_LIST = 4;
  const int SecurityListType_TRADING_LIST = 2;
  const int SecurityListType_INDUSTRY_CLASSIFICATION = 1;
  const int SecurityListType_MARKET = 3;
  const int QuoteRejectReason_QUOTE_LOCKED = 11;
  const int QuoteRejectReason_INVALID_OR_UNKNOWN_ISSUER_OF_UNDERLYING_SECURITY = 13;
  const int QuoteRejectReason_INVALID_PRICE = 8;
  const int QuoteRejectReason_NOT_AUTHORIZED_TO_QUOTE_SECURITY = 9;
  const int QuoteRejectReason_TOO_LATE_TO_ENTER = 4;
  const int QuoteRejectReason_EXCHANGE = 2;
  const int QuoteRejectReason_UNKNOWN_SYMBOL = 1;
  const int QuoteRejectReason_OTHER = 99;
  const int QuoteRejectReason_INVALID_BID_ASK_SPREAD = 7;
  const int QuoteRejectReason_UNKNOWN_QUOTE = 5;
  const int QuoteRejectReason_INVALID_OR_UNKNOWN_SECURITY_ISSUER = 12;
  const int QuoteRejectReason_DUPLICATE_QUOTE = 6;
  const int QuoteRejectReason_PRICE_EXCEEDS_CURRENT_PRICE_BAND = 10;
  const int QuoteRejectReason_QUOTE_REQUEST_EXCEEDS_LIMIT = 3;
  const char PossResend_NO = 'N';
  const char PossResend_YES = 'Y';
  const int QuantityType_SHARES = 1;
  const int QuantityType_CURRENTFACE = 3;
  const int QuantityType_PAR = 8;
  const int QuantityType_BONDS = 2;
  const int QuantityType_ORIGINALFACE = 4;
  const int QuantityType_CONTRACTS = 6;
  const int QuantityType_OTHER = 7;
  const int QuantityType_CURRENCY = 5;
  const int ComplexEventPriceBoundaryMethod_GREATER_THAN_OR_EQUAL_TO_COMPLEXEVENTPRICE = 4;
  const int ComplexEventPriceBoundaryMethod_EQUAL_TO_COMPLEXEVENTPRICE = 3;
  const int ComplexEventPriceBoundaryMethod_LESS_THAN_COMPLEXEVENTPRICE = 1;
  const int ComplexEventPriceBoundaryMethod_GREATER_THAN_COMPLEXEVENTPRICE = 5;
  const int ComplexEventPriceBoundaryMethod_LESS_THAN_OR_EQUAL_TO_COMPLEXEVENTPRICE = 2;
  const int ImpliedMarketIndicator_BOTH_IMPLIED_IN_AND_IMPLIED_OUT = 3;
  const int ImpliedMarketIndicator_NOT_IMPLIED = 0;
  const int ImpliedMarketIndicator_IMPLIED_OUT = 2;
  const int ImpliedMarketIndicator_IMPLIED_IN = 1;
  const int QuoteRequestType_AUTOMATIC = 2;
  const int QuoteRequestType_MANUAL = 1;
  const int SecurityRequestResult_NO_INSTRUMENTS_FOUND_THAT_MATCH_SELECTION_CRITERIA = 2;
  const int SecurityRequestResult_NOT_AUTHORIZED_TO_RETRIEVE_INSTRUMENT_DATA = 3;
  const int SecurityRequestResult_INSTRUMENT_DATA_TEMPORARILY_UNAVAILABLE = 4;
  const int SecurityRequestResult_VALID_REQUEST = 0;
  const int SecurityRequestResult_INVALID_OR_UNSUPPORTED_REQUEST = 1;
  const int SecurityRequestResult_REQUEST_FOR_INSTRUMENT_DATA_NOT_SUPPORTED = 5;
  const char OrderRestrictions_ISSUER_HOLDING = 'B';
  const char OrderRestrictions_ACTING_AS_MARKET_MAKER_OR_SPECIALIST_IN_THE_SECURITY = '5';
  const char OrderRestrictions_NON_ALGORITHMIC = 'D';
  const char OrderRestrictions_EXTNERAL_INTER_CONNECTED_MARKET_LINKAGE = '9';
  const char OrderRestrictions_NON_INDEX_ARBITRAGE = '3';
  const char OrderRestrictions_ACTING_AS_MARKET_MAKER_OF_SPECIALIST_IN_THE_UNDERLYING_SECURITY_OF_A_DERIVATIVE_SEUCIRTY = '6';
  const char OrderRestrictions_PROGRAM_TRADE = '1';
  const char OrderRestrictions_ISSUE_PRICE_STABILIZATION = 'C';
  const char OrderRestrictions_CROSS = 'F';
  const char OrderRestrictions_EXTERNAL_INTER_CONNECTED_MARKET_LINKAGE = '9';
  const char OrderRestrictions_FOREIGN_ENTITY = '7';
  const char OrderRestrictions_INDEX_ARBITRAGE = '2';
  const char OrderRestrictions_EXTERNAL_MARKET_PARTICIPANT = '8';
  const char OrderRestrictions_ALGORITHMIC = 'E';
  const char OrderRestrictions_ACTING_AS_MARKET_MAKER_OR_SPECIALIST_IN_THE_UNDERLYING_SECURITY_OF_A_DERIVATIVE_SECURITY = '6';
  const char OrderRestrictions_RISKLESS_ARBITRAGE = 'A';
  const char OrderRestrictions_COMPETING_MARKET_MAKER = '4';
  const char ListExecInstType_WAIT_FOR_EXECUT_INSTRUCTION = '2';
  const char ListExecInstType_EXCHANGE_SWITCH_CIV_ORDER_SELL_DRIVEN = '3';
  const char ListExecInstType_EXCHANGE_SWITCH_CIV_ORDER_BUY_DRIVEN_CASH_WITHDRAW = '5';
  const char ListExecInstType_EXCHANGE_SWITCH_CIV_ORDER_3 = '3';
  const char ListExecInstType_IMMEDIATE = '1';
  const char ListExecInstType_EXCHANGE_SWITCH_CIV_ORDER_4 = '4';
  const char ListExecInstType_EXCHANGE_SWITCH_CIV_ORDER_5 = '5';
  const char ListExecInstType_EXCHANGE_SWITCH_CIV_ORDER_BUY_DRIVEN_CASH_TOP_UP = '4';
  const char ListExecInstType_WAIT_FOR_EXECUTE_INSTRUCTION = '2';
  const int DistribPaymentMethod_FED_WIRE = 7;
  const int DistribPaymentMethod_EUROCLEAR = 3;
  const int DistribPaymentMethod_ACH_CREDIT = 9;
  const int DistribPaymentMethod_TELEGRAPHIC_TRANSFER = 6;
  const int DistribPaymentMethod_FEDWIRE = 7;
  const int DistribPaymentMethod_CHEQUE = 5;
  const int DistribPaymentMethod_DIRECT_CREDIT = 8;
  const int DistribPaymentMethod_CREST = 1;
  const int DistribPaymentMethod_HIGH_VALUE_CLEARING_SYSTEM = 11;
  const int DistribPaymentMethod_CLEARSTREAM = 4;
  const int DistribPaymentMethod_BPAY = 10;
  const int DistribPaymentMethod_NSCC = 2;
  const int DistribPaymentMethod_HIGH_VALUE_CLEARING_SYSTEM_HVACS = 11;
  const int DistribPaymentMethod_REINVEST_IN_FUND = 12;
  const int OrderHandlingInstSource_NASD_OATS = 1;
  const int AffirmStatus_AFFIRMED = 3;
  const int AffirmStatus_CONFIRM_REJECTED_IE_NOT_AFFIRMED = 2;
  const int AffirmStatus_RECEIVED = 1;
  const int OrigCustOrderCapacity_CLEARING_FIRM_TRADING_FOR_ITS_PROPRIETARY_ACCOUNT = 2;
  const int OrigCustOrderCapacity_MEMBER_TRADING_FOR_THEIR_OWN_ACCOUNT = 1;
  const int OrigCustOrderCapacity_MEMBER_TRADING_FOR_ANOTHER_MEMBER = 3;
  const int OrigCustOrderCapacity_ALL_OTHER = 4;
  const int AllocMethod_GUARANTOR = 2;
  const int AllocMethod_AUTOMATIC = 1;
  const int AllocMethod_MANUAL = 3;
  const char MassCancelResponse_CANCEL_ORDERS_FOR_A_SECURITY = '1';
  const char MassCancelResponse_CANCEL_ORDERS_FOR_ISSUER_OF_UNDERLYING_SECURITY = 'C';
  const char MassCancelResponse_CANCEL_ORDERS_FOR_A_SECURITY_GROUP = 'A';
  const char MassCancelResponse_CANCEL_ORDERS_FOR_A_MARKET = '8';
  const char MassCancelResponse_CANCEL_ORDERS_FOR_A_MARKET_SEGMENT = '9';
  const char MassCancelResponse_CANCEL_ORDERS_FOR_A_SECURITYTYPE = '5';
  const char MassCancelResponse_CANCEL_ORDERS_FOR_A_TRADING_SESSION = '6';
  const char MassCancelResponse_CANCEL_ORDERS_FOR_AN_UNDERLYING_SECURITY = '2';
  const char MassCancelResponse_CANCEL_ALL_ORDERS = '7';
  const char MassCancelResponse_CANCEL_REQUEST_REJECTED = '0';
  const char MassCancelResponse_CANCEL_ORDERS_FOR_A_SECURITIES_ISSUER = 'B';
  const char MassCancelResponse_CANCEL_ORDERS_FOR_A_CFICODE = '4';
  const char MassCancelResponse_CANCEL_ORDERS_FOR_A_PRODUCT = '3';
  const int StreamAsgnReqType_STREAM_ASSIGNMENT_FOR_NEW_CUSTOMER = 1;
  const int StreamAsgnReqType_STREAM_ASSIGNMENT_FOR_EXISTING_CUSTOMER = 2;
  const char SymbolSfx_EUCP_WITH_LUMP_SUM_INTEREST_RATHER_THAN_DISCOUNT_PRICE[] = "CD";
  const char SymbolSfx_WHEN_ISSUED_FOR_A_SECURITY_TO_BE_REISSUED_UNDER_AN_OLD_CUSIP_OR_ISIN[] = "WI";
  const char ExDestinationIDSource_PROPRIETARY = 'D';
  const char ExDestinationIDSource_GENERALLY_ACCEPTED_MARKET_PARTICIPANT_IDENTIFIER = 'C';
  const char ExDestinationIDSource_BIC = 'B';
  const char ExDestinationIDSource_MIC = 'G';
  const char ExDestinationIDSource_ISO_COUNTRY_CODE = 'E';
  const int SecurityListRequestType_MARKETID_OR_MARKETID_PLUS_MARKETSEGMENTID = 5;
  const int SecurityListRequestType_SYMBOL = 0;
  const int SecurityListRequestType_SECURITYTYPE_AND_OR_CFICODE = 1;
  const int SecurityListRequestType_TRADINGSESSIONID = 3;
  const int SecurityListRequestType_ALL_SECURITIES = 4;
  const int SecurityListRequestType_PRODUCT = 2;
  const int CollAsgnReason_TIME_WARNING = 2;
  const int CollAsgnReason_ADVERSE_TAX_EVENT = 7;
  const int CollAsgnReason_MARGIN_DEFICIENCY = 3;
  const int CollAsgnReason_SCHEDULED = 1;
  const int CollAsgnReason_INITIAL = 0;
  const int CollAsgnReason_FORWARD_COLLATERAL_DEMAND = 5;
  const int CollAsgnReason_EVENT_OF_DEFAULT = 6;
  const int CollAsgnReason_MARGIN_EXCESS = 4;
  const int SettlPriceType_FINAL = 1;
  const int SettlPriceType_THEORETICAL = 2;
  const char DealingCapacity_RISKLESS_PRINCIPAL = 'R';
  const char DealingCapacity_PRINCIPAL = 'P';
  const char DealingCapacity_AGENT = 'A';
  const int RateSourceType_SECONDARY = 1;
  const int RateSourceType_PRIMARY = 0;
  const char AggregatedBook_NO = 'N';
  const char AggregatedBook_YES = 'Y';
  const int PosQtyStatus_SUBMITTED = 0;
  const int PosQtyStatus_REJECTED = 2;
  const int PosQtyStatus_ACCEPTED = 1;
  const char MsgType_TradingSessionStatusRequest[] = "g";
  const char MsgType_ListStatus[] = "N";
  const char MsgType_Email[] = "C";
  const char MsgType_ListExecute[] = "L";
  const char MsgType_Confirmation[] = "AK";
  const char MsgType_NewOrderMultileg[] = "AB";
  const char MsgType_MarketDataIncrementalRefresh[] = "X";
  const char MsgType_TradeCaptureReport[] = "AE";
  const char MsgType_RequestForPositionsAck[] = "AO";
  const char MsgType_StreamAssignmentRequest[] = "CC";
  const char MsgType_SecurityListRequest[] = "x";
  const char MsgType_CollateralReport[] = "BA";
  const char MsgType_PositionMaintenanceReport[] = "AM";
  const char MsgType_PositionReport[] = "AP";
  const char MsgType_StreamAssignmentReportACK[] = "CE";
  const char MsgType_UserRequest[] = "BE";
  const char MsgType_PositionMaintenanceRequest[] = "AL";
  const char MsgType_NetworkCounterpartySystemStatusResponse[] = "BD";
  const char MsgType_NewOrderCross[] = "s";
  const char MsgType_AdjustedPositionReport[] = "BL";
  const char MsgType_Logon[] = "A";
  const char MsgType_IOI[] = "6";
  const char MsgType_ListStrikePrice[] = "m";
  const char MsgType_BidRequest[] = "k";
  const char MsgType_TradingSessionStatus[] = "h";
  const char MsgType_RegistrationInstructionsResponse[] = "p";
  const char MsgType_Advertisement[] = "7";
  const char MsgType_MassQuote[] = "i";
  const char MsgType_Logout[] = "5";
  const char MsgType_AllocationReport[] = "AS";
  const char MsgType_SecurityDefinitionUpdateReport[] = "BP";
  const char MsgType_ListStatusRequest[] = "M";
  const char MsgType_BusinessMessageReject[] = "j";
  const char MsgType_ConfirmationAck[] = "AU";
  const char MsgType_XMLnonFIX[] = "n";
  const char MsgType_TestRequest[] = "1";
  const char MsgType_SecurityList[] = "y";
  const char MsgType_ListCancelRequest[] = "K";
  const char MsgType_News[] = "B";
  const char MsgType_TradingSessionListUpdateReport[] = "BS";
  const char MsgType_Heartbeat[] = "0";
  const char MsgType_QuoteAcknowledgement[] = "b";
  const char MsgType_AllocationReportAck[] = "AT";
  const char MsgType_ConfirmationRequest[] = "BH";
  const char MsgType_OrderMassActionReport[] = "BZ";
  const char MsgType_CollateralInquiry[] = "BB";
  const char MsgType_SecurityTypeRequest[] = "v";
  const char MsgType_NewOrderList[] = "E";
  const char MsgType_ExecutionAcknowledgement[] = "BN";
  const char MsgType_TradingSessionListRequest[] = "BI";
  const char MsgType_SecurityTypes[] = "w";
  const char MsgType_MarketDefinition[] = "BU";
  const char MsgType_SequenceReset[] = "4";
  const char MsgType_CollateralResponse[] = "AZ";
  const char MsgType_MassQuoteAcknowledgement[] = "b";
  const char MsgType_QuoteResponse[] = "AJ";
  const char MsgType_QuoteStatusRequest[] = "a";
  const char MsgType_QuoteCancel[] = "Z";
  const char MsgType_ContraryIntentionReport[] = "BO";
  const char MsgType_CrossOrderCancelRequest[] = "u";
  const char MsgType_NewOrderSingle[] = "D";
  const char MsgType_DerivativeSecurityListRequest[] = "z";
  const char MsgType_CollateralRequest[] = "AX";
  const char MsgType_UserNotification[] = "CB";
  const char MsgType_UserResponse[] = "BF";
  const char MsgType_DontKnowTrade[] = "Q";
  const char MsgType_TradeCaptureReportAck[] = "AR";
  const char MsgType_ApplicationMessageRequest[] = "BW";
  const char MsgType_MultilegOrderCancelReplace[] = "AC";
  const char MsgType_OrderCancelReject[] = "9";
  const char MsgType_ExecutionReport[] = "8";
  const char MsgType_QuoteStatusReport[] = "AI";
  const char MsgType_ResendRequest[] = "2";
  const char MsgType_Quote[] = "S";
  const char MsgType_SettlementInstructionRequest[] = "AV";
  const char MsgType_SecurityListUpdateReport[] = "BK";
  const char MsgType_AllocationInstructionAlert[] = "BM";
  const char MsgType_TradeCaptureReportRequestAck[] = "AQ";
  const char MsgType_AllocationInstruction[] = "J";
  const char MsgType_Allocation[] = "J";
  const char MsgType_RegistrationInstructions[] = "o";
  const char MsgType_SecurityDefinition[] = "d";
  const char MsgType_SecurityDefinitionRequest[] = "c";
  const char MsgType_SecurityStatus[] = "f";
  const char MsgType_ApplicationMessageReport[] = "BY";
  const char MsgType_DerivativeSecurityList[] = "AA";
  const char MsgType_NetworkCounterpartySystemStatusRequest[] = "BC";
  const char MsgType_MarketDefinitionRequest[] = "BT";
  const char MsgType_Reject[] = "3";
  const char MsgType_DerivativeSecurityListUpdateReport[] = "BR";
  const char MsgType_QuoteRequestReject[] = "AG";
  const char MsgType_OrderMassStatusRequest[] = "AF";
  const char MsgType_ApplicationMessageRequestAck[] = "BX";
  const char MsgType_SecurityStatusRequest[] = "e";
  const char MsgType_MarketDefinitionUpdateReport[] = "BV";
  const char MsgType_CrossOrderCancelReplaceRequest[] = "t";
  const char MsgType_OrderMassCancelReport[] = "r";
  const char MsgType_AssignmentReport[] = "AW";
  const char MsgType_BidResponse[] = "l";
  const char MsgType_RequestForPositions[] = "AN";
  const char MsgType_SettlementObligationReport[] = "BQ";
  const char MsgType_OrderMassCancelRequest[] = "q";
  const char MsgType_TradingSessionList[] = "BJ";
  const char MsgType_OrderStatusRequest[] = "H";
  const char MsgType_CollateralAssignment[] = "AY";
  const char MsgType_StreamAssignmentReport[] = "CD";
  const char MsgType_OrderMassActionRequest[] = "CA";
  const char MsgType_AllocationAck[] = "P";
  const char MsgType_QuoteRequest[] = "R";
  const char MsgType_CollateralInquiryAck[] = "BG";
  const char MsgType_MarketDataSnapshotFullRefresh[] = "W";
  const char MsgType_SettlementInstructions[] = "T";
  const char MsgType_OrderCancelReplaceRequest[] = "G";
  const char MsgType_TradeCaptureReportRequest[] = "AD";
  const char MsgType_RFQRequest[] = "AH";
  const char MsgType_OrderCancelRequest[] = "F";
  const char MsgType_MultilegOrderCancelReplaceRequest[] = "AC";
  const char MsgType_AllocationInstructionAck[] = "P";
  const char MsgType_MarketDataRequest[] = "V";
  const char MsgType_MarketDataRequestReject[] = "Y";
  const char MultiLegReportingType_SINGLE_SECURITY = '1';
  const char MultiLegReportingType_MULTI_LEG_SECURITY = '3';
  const char MultiLegReportingType_INDIVIDUAL_LEG_OF_A_MULTI_LEG_SECURITY = '2';
  const char MultiLegReportingType_INDIVIDUAL_LEG_OF_A_MULTILEG_SECURITY = '2';
  const char IDSource_EXCHANGE_SYMBOL[] = "8";
  const char IDSource_RIC_CODE[] = "5";
  const char IDSource_ISO_CURRENCY_CODE[] = "6";
  const char IDSource_ISIN_NUMBER[] = "4";
  const char IDSource_SEDOL[] = "2";
  const char IDSource_ISO_COUNTRY_CODE[] = "7";
  const char IDSource_CONSOLIDATED_TAPE_ASSOCIATION[] = "9";
  const char IDSource_QUIK[] = "3";
  const char IDSource_CUSIP[] = "1";
  const char OrdStatus_NEW = '0';
  const char OrdStatus_CALCULATED = 'B';
  const char OrdStatus_PENDING_CANCEL = '6';
  const char OrdStatus_PENDING_CANCEL_REPLACE = '6';
  const char OrdStatus_PENDING_NEW = 'A';
  const char OrdStatus_STOPPED = '7';
  const char OrdStatus_FILLED = '2';
  const char OrdStatus_PENDING_REPLACE = 'E';
  const char OrdStatus_CANCELED = '4';
  const char OrdStatus_ACCEPTED_FOR_BIDDING = 'D';
  const char OrdStatus_SUSPENDED = '9';
  const char OrdStatus_REJECTED = '8';
  const char OrdStatus_PARTIALLY_FILLED = '1';
  const char OrdStatus_EXPIRED = 'C';
  const char OrdStatus_REPLACED = '5';
  const char OrdStatus_DONE_FOR_DAY = '3';
  const int CustomerOrFirm_FIRM = 1;
  const int CustomerOrFirm_CUSTOMER = 0;
  const int AdjustmentType_DELTA_MINUS = 2;
  const int AdjustmentType_DELTA_PLUS = 1;
  const int AdjustmentType_FINAL = 3;
  const int AdjustmentType_PROCESS_REQUEST_AS_MARGIN_DISPOSITION = 0;
  const char AsOfIndicator_TRUE = '1';
  const char AsOfIndicator_FALSE = '0';
  const int MassActionScope_ALL_ORDERS_FOR_A_MARKET_SEGMENT = 9;
  const int MassActionScope_ALL_ORDERS_FOR_A_MARKET = 8;
  const int MassActionScope_ALL_ORDERS_FOR_AN_UNDERLYING_SECURITY = 2;
  const int MassActionScope_ALL_ORDERS = 7;
  const int MassActionScope_ALL_ORDERS_FOR_A_CFICODE = 4;
  const int MassActionScope_CANCEL_FOR_ISSUER_OF_UNDERLYING_SECURITY = 12;
  const int MassActionScope_ALL_ORDERS_FOR_A_SECURITY = 1;
  const int MassActionScope_ALL_ORDERS_FOR_A_TRADING_SESSION = 6;
  const int MassActionScope_CANCEL_FOR_SECURITY_ISSUER = 11;
  const int MassActionScope_ALL_ORDERS_FOR_A_SECURITY_GROUP = 10;
  const int MassActionScope_ALL_ORDERS_FOR_A_PRODUCT = 3;
  const int MassActionScope_ALL_ORDERS_FOR_A_SECURITYTYPE = 5;
  const char VenueType_PIT = 'P';
  const char VenueType_EX_PIT = 'X';
  const char VenueType_ELECTRONIC = 'E';
  const int MassActionType_CANCEL_ORDERS = 3;
  const int MassActionType_RELEASE_ORDERS_FROM_SUSPENSION = 2;
  const int MassActionType_SUSPEND_ORDERS = 1;
  const int PosMaintResult_SUCCESSFUL_COMPLETION = 0;
  const int PosMaintResult_OTHER = 99;
  const int PosMaintResult_REJECTED = 1;
  const char IOIShares_MEDIUM[] = "M";
  const char IOIShares_LARGE[] = "L";
  const char IOIShares_SMALL[] = "S";
  const int PegOffsetType_PRICE = 0;
  const int PegOffsetType_PRICE_TIER = 3;
  const int PegOffsetType_TICKS = 2;
  const int PegOffsetType_BASIS_POINTS = 1;
  const int MassCancelRejectReason_INVALID_OR_UNKOWN_MARKET_SEGMENT = 8;
  const int MassCancelRejectReason_INVALID_OR_UNKNOWN_SECURITY = 1;
  const int MassCancelRejectReason_MASS_CANCEL_NOT_SUPPORTED = 0;
  const int MassCancelRejectReason_INVALID_OR_UNKNOWN_SECURITY_GROUP = 9;
  const int MassCancelRejectReason_INVALID_OR_UNKOWN_UNDERLYING_SECURITY = 2;
  const int MassCancelRejectReason_INVALID_OR_UNKNOWN_ISSUER_OF_UNDERLYING_SECURITY = 11;
  const int MassCancelRejectReason_INVALID_OR_UNKNOWN_SECURITYTYPE = 5;
  const int MassCancelRejectReason_INVALID_OR_UNKNOWN_CFICODE = 4;
  const int MassCancelRejectReason_INVALID_OR_UNKNOWN_TRADING_SESSION = 6;
  const int MassCancelRejectReason_INVALID_OR_UNKNOWN_MARKET = 7;
  const int MassCancelRejectReason_INVALID_OR_UNKNOWN_SECURITY_TYPE = 5;
  const int MassCancelRejectReason_OTHER = 99;
  const int MassCancelRejectReason_INVALID_OR_UNKNOWN_SECURITY_ISSUER = 10;
  const int MassCancelRejectReason_INVALID_OR_UNKNOWN_PRODUCT = 3;
  const int MassCancelRejectReason_INVALID_OR_UNKNOWN_UNDERLYING = 2;
  const int ResponseTransportType_INBAND = 0;
  const int ResponseTransportType_OUT_OF_BAND = 1;
  const int ResponseTransportType_INBAND_TRANSPORT_THE_REQUEST_WAS_SENT_OVER = 0;
  const int ResponseTransportType_OUT_OF_BAND_PRE_ARRANGED_OUT_OF_BAND_DELIVERY_MECHANISM = 1;
  const int TradSesStatusRejReason_UNKNOWN_OR_INVALID_TRADINGSESSIONID = 1;
  const int TradSesStatusRejReason_OTHER = 99;
  const int TrdRegTimestampType_EXECUTION_TIME = 1;
  const int TrdRegTimestampType_TIME_IN = 2;
  const int TrdRegTimestampType_SUBMISSION_TO_CLEARING = 7;
  const int TrdRegTimestampType_DESK_RECEIPT = 6;
  const int TrdRegTimestampType_BROKER_RECEIPT = 4;
  const int TrdRegTimestampType_BROKER_EXECUTION = 5;
  const int TrdRegTimestampType_TIME_OUT = 3;
  const char ApplVerID_FIX50SP1[] = "8";
  const char ApplVerID_FIX27[] = "0";
  const char ApplVerID_FIX50SP2[] = "9";
  const char ApplVerID_FIX50[] = "7";
  const char ApplVerID_FIX40[] = "2";
  const char ApplVerID_FIX41[] = "3";
  const char ApplVerID_FIX30[] = "1";
  const char ApplVerID_FIX42[] = "4";
  const char ApplVerID_FIX43[] = "5";
  const char ApplVerID_FIX44[] = "6";
  const char HandlInst_MANUAL_ORDER_BEST_EXECUTION = '3';
  const char HandlInst_AUTOMATED_EXECUTION_ORDER_PRIVATE_NO_BROKER_INTERVENTION = '1';
  const char HandlInst_AUTOMATED_EXECUTION_ORDER_PUBLIC_BROKER_INTERVENTION_OK = '2';
  const char TradingSessionSubID_POST_TRADING[] = "5";
  const char TradingSessionSubID_INTRADAY_AUCTION[] = "6";
  const char TradingSessionSubID_PRE_TRADING[] = "1";
  const char TradingSessionSubID_QUIESCENT[] = "7";
  const char TradingSessionSubID_3[] = "3";
  const char TradingSessionSubID_OPENING_OR_OPENING_AUCTION[] = "2";
  const char TradingSessionSubID_CLOSING_OR_CLOSING_AUCTION[] = "4";
  const char MDEntryType_SWAP_VALUE_FACTOR = 'S';
  const char MDEntryType_COMPOSITE_UNDERLYING_PRICE = 'D';
  const char MDEntryType_SESSION_HIGH_BID = 'N';
  const char MDEntryType_OPEN_INTEREST = 'C';
  const char MDEntryType_CLOSING_PRICE = '5';
  const char MDEntryType_PRIOR_SETTLE_PRICE = 'M';
  const char MDEntryType_TRADING_SESSION_VWAP_PRICE = '9';
  const char MDEntryType_TRADING_SESSION_LOW_PRICE = '8';
  const char MDEntryType_SETTLE_HIGH_PRICE = 'K';
  const char MDEntryType_IMBALANCE = 'A';
  const char MDEntryType_FIXING_PRICE = 'W';
  const char MDEntryType_CASH_RATE = 'X';
  const char MDEntryType_OPENING_PRICE = '4';
  const char MDEntryType_TRADE = '2';
  const char MDEntryType_CUMULATIVE_VALUE_ADJUSTMENT_FOR_SHORT_POSITIONS = 'V';
  const char MDEntryType_SIMULATED_SELL_PRICE = 'E';
  const char MDEntryType_EMPTY_BOOK = 'J';
  const char MDEntryType_AUCTION_CLEARING_PRICE = 'Q';
  const char MDEntryType_BID = '0';
  const char MDEntryType_RECOVERY_RATE_FOR_SHORT = 'a';
  const char MDEntryType_SIMULATED_BUY_PRICE = 'F';
  const char MDEntryType_EARLY_PRICES = 'P';
  const char MDEntryType_TRADING_SESSION_HIGH_PRICE = '7';
  const char MDEntryType_INDEX_VALUE = '3';
  const char MDEntryType_RECOVERY_RATE_FOR_LONG = 'Z';
  const char MDEntryType_DAILY_VALUE_ADJUSTMENT_FOR_LONG_POSITIONS = 'R';
  const char MDEntryType_MID_PRICE = 'H';
  const char MDEntryType_RECOVERY_RATE = 'Y';
  const char MDEntryType_CUMULATIVE_VALUE_ADJUSTMENT_FOR_LONG_POSITIONS = 'T';
  const char MDEntryType_DAILY_VALUE_ADJUSTMENT_FOR_SHORT_POSITIONS = 'U';
  const char MDEntryType_MARGIN_RATE = 'G';
  const char MDEntryType_SETTLE_LOW_PRICE = 'L';
  const char MDEntryType_SESSION_LOW_OFFER = 'O';
  const char MDEntryType_TRADE_VOLUME = 'B';
  const char MDEntryType_SETTLEMENT_PRICE = '6';
  const char MDEntryType_OFFER = '1';
  const int PegMoveType_FLOATING = 0;
  const int PegMoveType_FIXED = 1;
  const int AvgPxIndicator_LAST_TRADE_IN_THE_AVERAGE_PRICE_GROUP_IDENTIFIED_BY_THE_TRADELINKID = 2;
  const int AvgPxIndicator_NO_AVERAGE_PRICING = 0;
  const int AvgPxIndicator_TRADE_IS_PART_OF_AN_AVERAGE_PRICE_GROUP_IDENTIFIED_BY_THE_TRADELINKID = 1;
  const int AvgPxIndicator_LAST_TRADE_IS_THE_AVERAGE_PRICE_GROUP_IDENTIFIED_BY_THE_TRADELINKID = 2;
  const char CancellationRights_NO_WAIVER_AGREEMENT = 'M';
  const char CancellationRights_NO_M = 'M';
  const char CancellationRights_NO_N = 'N';
  const char CancellationRights_NO_INSTITUTIONAL = 'O';
  const char CancellationRights_YES = 'Y';
  const char CancellationRights_NO_O = 'O';
  const char CancellationRights_NO_EXECUTION_ONLY = 'N';
  const char ExecPriceType_CREATION_PRICE = 'C';
  const char ExecPriceType_CREATION_PRICE_PLUS_ADJUSTMENT_PERCENT = 'D';
  const char ExecPriceType_OFFER_PRICE_MINUS_ADJUSTMENT = 'P';
  const char ExecPriceType_OFFER_PRICE_MINUS_ADJUSTMENT_AMOUNT = 'Q';
  const char ExecPriceType_CREATION_PRICE_PLUS_ADJUSTMENT_AMOUNT = 'E';
  const char ExecPriceType_OFFER_PRICE_MINUS_ADJUSTMENT_PERCENT = 'P';
  const char ExecPriceType_BID_PRICE = 'B';
  const char ExecPriceType_SINGLE_PRICE = 'S';
  const char ExecPriceType_CREATION_PRICE_PLUS_ADJUSTMENT = 'D';
  const char ExecPriceType_OFFER_PRICE = 'O';
  const int AllocSettlInstType_PHONE_FOR_INSTRUCTIONS = 4;
  const int AllocSettlInstType_SSI_DB_IDS_PROVIDED = 3;
  const int AllocSettlInstType_FULL_DETAILS_PROVIDED = 2;
  const int AllocSettlInstType_DERIVE_FROM_PARAMETERS_PROVIDED = 1;
  const int AllocSettlInstType_USE_DEFAULT_INSTRUCTIONS = 0;
  const int StatsType_AVERAGE_PRICE = 3;
  const int StatsType_HIGH = 2;
  const int StatsType_EXCHANGE_LAST = 1;
  const int StatsType_TURNOVER = 4;
  const int TradSesMode_SIMULATED = 2;
  const int TradSesMode_PRODUCTION = 3;
  const int TradSesMode_TESTING = 1;
  const char SettlInstSource_INSTITUTIONS_INSTRUCTIONS = '2';
  const char SettlInstSource_BROKERS_INSTRUCTIONS = '1';
  const char SettlInstSource_INVESTOR = '3';
  const int ExpType_DIFFERENCE = 5;
  const int ExpType_FINAL_WILL_BE_EXERCISED = 3;
  const int ExpType_NON_AUTO_EXERCISE = 2;
  const int ExpType_CONTRARY_INTENTION = 4;
  const int ExpType_AUTO_EXERCISE = 1;
  const char SettlInstTransType_REPLACE = 'R';
  const char SettlInstTransType_NEW = 'N';
  const char SettlInstTransType_RESTATE = 'T';
  const char SettlInstTransType_CANCEL = 'C';
  const int TradeRequestResult_INVALID_DESTINATION_REQUESTED = 5;
  const int TradeRequestResult_UNAUTHORIZED_ROR_TRADE_CAPTURE_REPORT_REQUEST = 9;
  const int TradeRequestResult_UNAUTHORIZED_FOR_TRADE_CAPTURE_REPORT_REQUEST = 9;
  const int TradeRequestResult_SUCCESSFUL = 0;
  const int TradeRequestResult_OTHER = 99;
  const int TradeRequestResult_INVALID_OR_UNKNOWN_INSTRUMENT = 1;
  const int TradeRequestResult_INVALID_PARTIES = 3;
  const int TradeRequestResult_INVALID_TYPE_OF_TRADE_REQUESTED = 2;
  const int TradeRequestResult_NOT_AUTHORIZED = 9;
  const int TradeRequestResult_INVALID_TRANSPORT_TYPE_REQUESTED = 4;
  const int TradeRequestResult_TRADEREQUESTTYPE_NOT_SUPPORTED = 8;
  const char TestMessageIndicator_NO = 'N';
  const char TestMessageIndicator_YES = 'Y';
  const int ExpirationCycle_TRADING_ELIGIBILITY_EXPIRATION_SPECIFIED_IN_THE_DATE_AND_TIME_FIELDS_EVENTDATE = 2;
  const int ExpirationCycle_EXPIRE_ON_TRADING_SESSION_CLOSE = 0;
  const int ExpirationCycle_EXPIRE_ON_TRADING_SESSION_OPEN = 1;
  const int AllocCancReplaceReason_CHANGE_IN_UNDERLYING_ORDER_DETAILS = 2;
  const int AllocCancReplaceReason_OTHER = 99;
  const int AllocCancReplaceReason_ORIGINAL_DETAILS_INCOMPLETE_INCORRECT = 1;
  const int CxlRejReason_DUPLICATE_CLORDID = 6;
  const int CxlRejReason_PRICE_EXCEEDS_CURRENT_PRICE = 7;
  const int CxlRejReason_DUPLICATE_CLORDID_RECEIVED = 6;
  const int CxlRejReason_UNKNOWN_ORDER = 1;
  const int CxlRejReason_TOO_LATE_TO_CANCEL = 0;
  const int CxlRejReason_INVALID_PRICE_INCREMENT = 18;
  const int CxlRejReason_ORIGORDMODTIME = 5;
  const int CxlRejReason_OTHER = 99;
  const int CxlRejReason_BROKER = 2;
  const int CxlRejReason_BROKER_OPTION = 2;
  const int CxlRejReason_UNABLE_TO_PROCESS_ORDER_MASS_CANCEL_REQUEST = 4;
  const int CxlRejReason_ORDER_ALREADY_IN_PENDING_CANCEL_OR_PENDING_REPLACE_STATUS = 3;
  const int CxlRejReason_PRICE_EXCEEDS_CURRENT_PRICE_BAND = 8;
  const int CxlRejReason_ORIGORDMODTIME_DID_NOT_MATCH_LAST_TRANSACTTIME_OF_ORDER = 5;
  const int RespondentType_SPECIFIED_MARKET_PARTICIPANTS = 2;
  const int RespondentType_ALL_MARKET_MAKERS = 3;
  const int RespondentType_ALL_MARKET_PARTICIPANTS = 1;
  const int RespondentType_PRIMARY_MARKET_MAKER = 4;
  const char DKReason_NO_MATCHING_ORDER = 'D';
  const char DKReason_PRICE_EXCEEDS_LIMIT = 'E';
  const char DKReason_QUANTITY_EXCEEDS_ORDER = 'C';
  const char DKReason_UNKNOWN_SYMBOL = 'A';
  const char DKReason_OTHER = 'Z';
  const char DKReason_WRONG_SIDE = 'B';
  const char DKReason_CALCULATION_DIFFERENCE = 'F';
  const char PositionEffect_DEFAULT = 'D';
  const char PositionEffect_CLOSE = 'C';
  const char PositionEffect_CLOSE_BUT_NOTIFY_ON_OPEN = 'N';
  const char PositionEffect_OPEN = 'O';
  const char PositionEffect_FIFO = 'F';
  const char PositionEffect_ROLLED = 'R';
  const char TriggerAction_ACTIVATE = '1';
  const char TriggerAction_MODIFY = '2';
  const char TriggerAction_CANCEL = '3';
  const int ClearingInstruction_EXCLUDE_FROM_ALL_NETTING = 1;
  const int ClearingInstruction_AUTOMATIC_POSTING_MODE = 9;
  const int ClearingInstruction_MULTILATERAL_NETTING = 5;
  const int ClearingInstruction_EXCLUDE_FROM_CENTRAL_COUNTERPARTY = 7;
  const int ClearingInstruction_AUTOMATIC_GIVE_UP_MODE = 10;
  const int ClearingInstruction_CUSTOMER_TRADE = 12;
  const int ClearingInstruction_EX_CLEARING = 3;
  const int ClearingInstruction_CLEAR_AGAINST_CENTRAL_COUNTERPARTY = 6;
  const int ClearingInstruction_BILATERAL_NETTING_ONLY = 2;
  const int ClearingInstruction_PROCESS_NORMALLY = 0;
  const int ClearingInstruction_SPECIAL_TRADE = 4;
  const int ClearingInstruction_MANUAL_MODE = 8;
  const int ClearingInstruction_QUALIFIED_SERVICE_REPRESENTATIVE_QSR = 11;
  const int ClearingInstruction_QUALIFIED_SERVICE_REPRESENTATIVE = 11;
  const int ClearingInstruction_SELF_CLEARING = 13;
  const char OpenCloseSettlFlag_SESSION_OPEN = '1';
  const char OpenCloseSettlFlag_EXPECTED_ENTRY = '3';
  const char OpenCloseSettlFlag_DAILY_OPEN = '0';
  const char OpenCloseSettlFlag_THEORETICAL_PRICE_VALUE = '5';
  const char OpenCloseSettlFlag_ENTRY_FROM_PREVIOUS_BUSINESS_DAY = '4';
  const char OpenCloseSettlFlag_DELIVERY_SETTLEMENT_ENTRY = '2';
  const int DiscretionMoveType_FLOATING = 0;
  const int DiscretionMoveType_FIXED = 1;
  const int MDUpdateType_INCREMENTAL_REFRESH = 1;
  const int MDUpdateType_FULL_REFRESH = 0;
  const char TickDirection_MINUS_TICK = '2';
  const char TickDirection_ZERO_PLUS_TICK = '1';
  const char TickDirection_ZERO_MINUS_TICK = '3';
  const char TickDirection_PLUS_TICK = '0';
  const char YieldType_MARK_TO_MARKET_YIELD[] = "MARK";
  const char YieldType_CLOSING_YIELD_MOST_RECENT_QUARTER[] = "LASTQUARTER";
  const char YieldType_YIELD_TO_MATURITY[] = "MATURITY";
  const char YieldType_COMPOUND_YIELD_THE_YIELD_OF_CERTAIN_JAPANESE_BONDS_BASED_ON_ITS_PRICE_CERTAIN_JAPANESE_BONDS_HAVE_IRREGULAR_FIRST_OR_LAST_COUPONS_AND_THE_YIELD_IS_CALCULATED_COMPOUND_FOR_THESE_IRREGULAR_PERIODS[] = "COMPOUND";
  const char YieldType_PREVIOUS_CLOSE_YIELD[] = "PREVCLOSE";
  const char YieldType_YIELD_AT_ISSUE[] = "ATISSUE";
  const char YieldType_YIELD_TO_NEXT_REFUND[] = "NEXTREFUND";
  const char YieldType_AFTER_TAX_YIELD[] = "AFTERTAX";
  const char YieldType_GVNT_EQUIVALENT_YIELD[] = "GOVTEQUIV";
  const char YieldType_YIELD_TO_SHORTEST_AVERAGE_LIFE_SAME_AS_AVGLIFE_ABOVE[] = "SHORTAVGLIFE";
  const char YieldType_YIELD_CHANGE_SINCE_CLOSE_THE_CHANGE_IN_THE_YIELD_SINCE_THE_PREVIOUS_DAYS_CLOSING_YIELD[] = "CHANGE";
  const char YieldType_CURRENT_YIELD_ANNUAL_INTEREST_ON_A_BOND_DIVIDED_BY_THE_MARKET_VALUE_THE_ACTUAL_INCOME_RATE_OF_RETURN_AS_OPPOSED_TO_THE_COUPON_RATE_EXPRESSED_AS_A_PERCENTAGE[] = "CURRENT";
  const char YieldType_YIELD_TO_MATURITY_THE_YIELD_OF_A_BOND_TO_ITS_MATURITY_DATE[] = "MATURITY";
  const char YieldType_CLOSING_YIELD_MOST_RECENT_YEAR[] = "LASTYEAR";
  const char YieldType_YIELD_TO_NEXT_CALL[] = "CALL";
  const char YieldType_YIELD_CHANGE_SINCE_CLOSE[] = "CHANGE";
  const char YieldType_PROCEEDS_YIELD[] = "PROCEEDS";
  const char YieldType_TAX_EQUIVALENT_YIELD_THE_AFTER_TAX_YIELD_GROSSED_UP_BY_THE_MAXIMUM_FEDERAL_TAX_RATE_OF_396_FOR_COMPARISON_TO_TAXABLE_YIELDS[] = "TAXEQUIV";
  const char YieldType_INVERSE_FLOATER_BOND_YIELD_INVERSE_FLOATER_SEMI_ANNUAL_BOND_EQUIVALENT_RATE[] = "INVERSEFLOATER";
  const char YieldType_CURRENT_YIELD[] = "CURRENT";
  const char YieldType_BOOK_YIELD_THE_YIELD_OF_A_SECURITY_CALCULATED_BY_USING_ITS_BOOK_VALUE_INSTEAD_OF_THE_CURRENT_MARKET_PRICE_THIS_TERM_IS_TYPICALLY_USED_IN_THE_US_DOMESTIC_MARKET[] = "BOOK";
  const char YieldType_COMPOUND_YIELD[] = "COMPOUND";
  const char YieldType_YIELD_TO_NEXT_PUT_THE_YIELD_TO_THE_DATE_AT_WHICH_THE_BOND_HOLDER_CAN_NEXT_PUT_THE_BOND_TO_THE_ISSUER[] = "PUT";
  const char YieldType_GOVERNMENT_EQUIVALENT_YIELD_ASK_YIELD_BASED_ON_SEMI_ANNUAL_COUPONS_COMPOUNDING_IN_ALL_PERIODS_AND_ACTUAL_ACTUAL_CALENDAR[] = "GOVTEQUIV";
  const char YieldType_YIELD_TO_TENDER_DATE_THE_YIELD_ON_A_MUNICIPAL_BOND_TO_ITS_MANDATORY_TENDER_DATE[] = "TENDER";
  const char YieldType_YIELD_TO_AVG_MATURITY[] = "AVGMATURITY";
  const char YieldType_OPEN_AVERAGE_YIELD_THE_AVERAGE_YIELD_OF_THE_RESPECTIVE_SECURITIES_IN_THE_PORTFOLIO[] = "OPENAVG";
  const char YieldType_YIELD_TO_TENDER_DATE[] = "TENDER";
  const char YieldType_CLOSING_YIELD_MOST_RECENT_MONTH_THE_YIELD_OF_A_BOND_BASED_ON_THE_CLOSING_PRICE_AS_OF_THE_MOST_RECENT_MONTHS_END[] = "LASTMONTH";
  const char YieldType_CLOSING_YIELD_MOST_RECENT_YEAR_THE_YIELD_OF_A_BOND_BASED_ON_THE_CLOSING_PRICE_AS_OF_THE_MOST_RECENT_YEARS_END[] = "LASTYEAR";
  const char YieldType_ANNUAL_YIELD[] = "ANNUAL";
  const char YieldType_YIELD_TO_WORST[] = "WORST";
  const char YieldType_YIELD_TO_NEXT_PUT[] = "PUT";
  const char YieldType_BOOK_YIELD[] = "BOOK";
  const char YieldType_TRUE_YIELD[] = "TRUE";
  const char YieldType_TRUE_YIELD_THE_YIELD_CALCULATED_WITH_COUPON_DATES_MOVED_FROM_A_WEEKEND_OR_HOLIDAY_TO_THE_NEXT_VALID_SETTLEMENT_DATE[] = "TRUE";
  const char YieldType_SEMI_ANNUAL_YIELD_THE_YIELD_OF_A_BOND_WHOSE_COUPON_PAYMENTS_ARE_REINVESTED_SEMI_ANNUALLY[] = "SEMIANNUAL";
  const char YieldType_CLOSING_YIELD_THE_YIELD_OF_A_BOND_BASED_ON_THE_CLOSING_PRICE[] = "CLOSE";
  const char YieldType_TAX_EQUIVALENT_YIELD[] = "TAXEQUIV";
  const char YieldType_PREVIOUS_CLOSE_YIELD_THE_YIELD_OF_A_BOND_BASED_ON_THE_CLOSING_PRICE_1_DAY_AGO[] = "PREVCLOSE";
  const char YieldType_YIELD_VALUE_OF_1_32_THE_AMOUNT_THAT_THE_YIELD_WILL_CHANGE_FOR_A_1_32ND_CHANGE_IN_PRICE[] = "VALUE1/32";
  const char YieldType_TRUE_GROSS_YIELD[] = "GROSS";
  const char YieldType_YIELD_TO_LONGEST_AVERAGE[] = "LONGEST";
  const char YieldType_INVERSE_FLOATER_BOND_YIELD[] = "INVERSEFLOATER";
  const char YieldType_CLOSING_YIELD_MOST_RECENT_MONTH[] = "LASTMONTH";
  const char YieldType_YIELD_TO_AVERAGE_LIFE_THE_YIELD_ASSUMING_THAT_ALL_SINKS[] = "AVGLIFE";
  const char YieldType_CLOSING_YIELD_MOST_RECENT_QUARTER_THE_YIELD_OF_A_BOND_BASED_ON_THE_CLOSING_PRICE_AS_OF_THE_MOST_RECENT_QUARTERS_END[] = "LASTQUARTER";
  const char YieldType_YIELD_TO_SHORTEST_AVERAGE[] = "SHORTEST";
  const char YieldType_OPEN_AVERAGE_YIELD[] = "OPENAVG";
  const char YieldType_TRUE_GROSS_YIELD_YIELD_CALCULATED_USING_THE_PRICE_INCLUDING_ACCRUED_INTEREST_WHERE_COUPON_DATES_ARE_MOVED_FROM_HOLIDAYS_AND_WEEKENDS_TO_THE_NEXT_TRADING_DAY[] = "GROSS";
  const char YieldType_PROCEEDS_YIELD_THE_CD_EQUIVALENT_YIELD_WHEN_THE_REMAINING_TIME_TO_MATURITY_IS_LESS_THAN_TWO_YEARS[] = "PROCEEDS";
  const char YieldType_YIELD_WITH_INFLATION_ASSUMPTION[] = "INFLATION";
  const char YieldType_YIELD_TO_LONGEST_AVERAGE_LIFE_THE_YIELD_ASSUMING_ONLY_MANDATORY_SINKS_ARE_TAKEN_THIS_RESULTS_IN_A_LOWER_PAYDOWN_OF_DEBT_THE_YIELD_IS_THEN_CALCULATED_TO_THE_FINAL_PAYMENT_DATE[] = "LONGAVGLIFE";
  const char YieldType_MARK_TO_MARKET_YIELD_AN_ADJUSTMENT_IN_THE_VALUATION_OF_A_SECURITIES_PORTFOLIO_TO_REFLECT_THE_CURRENT_MARKET_VALUES_OF_THE_RESPECTIVE_SECURITIES_IN_THE_PORTFOLIO[] = "MARK";
  const char YieldType_YIELD_TO_AVERAGE_MATURITY[] = "AVGMATURITY";
  const char YieldType_YIELD_TO_WORST_CONVENTION_THE_LOWEST_YIELD_TO_ALL_POSSIBLE_REDEMPTION_DATE_SCENARIOS[] = "WORST";
  const char YieldType_YIELD_TO_NEXT_CALL_THE_YIELD_OF_A_BOND_TO_THE_NEXT_POSSIBLE_CALL_DATE[] = "CALL";
  const char YieldType_SIMPLE_YIELD[] = "SIMPLE";
  const char YieldType_ANNUAL_YIELD_THE_ANNUAL_INTEREST_OR_DIVIDEND_INCOME_AN_INVESTMENT_EARNS_EXPRESSED_AS_A_PERCENTAGE_OF_THE_INVESTMENTS_TOTAL_VALUE[] = "ANNUAL";
  const char YieldType_SEMI_ANNUAL_YIELD[] = "SEMIANNUAL";
  const char YieldType_MOST_RECENT_CLOSING_YIELD[] = "LASTCLOSE";
  const char YieldType_GOVERNMENT_EQUIVALENT_YIELD[] = "GOVTEQUIV";
  const char YieldType_YIELD_TO_SHORTEST_AVERAGE_LIFE[] = "SHORTAVGLIFE";
  const char YieldType_CLOSING_YIELD[] = "CLOSE";
  const char YieldType_YIELD_WITH_INFLATION_ASSUMPTION_BASED_ON_PRICE_THE_RETURN_AN_INVESTOR_WOULD_REQUIRE_ON_A_NORMAL_BOND_THAT_WOULD_MAKE_THE_REAL_RETURN_EQUAL_TO_THAT_OF_THE_INFLATION_INDEXED_BOND_ASSUMING_A_CONSTANT_INFLATION_RATE[] = "INFLATION";
  const char YieldType_YIELD_VALUE_OF_1_32[] = "VALUE1_32";
  const char YieldType_MOST_RECENT_CLOSING_YIELD_THE_LAST_AVAILABLE_YIELD_STORED_IN_HISTORY_COMPUTED_USING_PRICE[] = "LASTCLOSE";
  const char YieldType_YIELD_TO_LONGEST_AVERAGE_LIFE[] = "LONGAVGLIFE";
  const char YieldType_SIMPLE_YIELD_THE_YIELD_OF_A_BOND_ASSUMING_NO_REINVESTMENT_OF_COUPON_PAYMENTS[] = "SIMPLE";
  const char YieldType_YIELD_TO_AVERAGE_MATURITY_THE_YIELD_ACHIEVED_BY_SUBSTITUTING_A_BONDS_AVERAGE_MATURITY_FOR_THE_ISSUES_FINAL_MATURITY_DATE[] = "AVGMATURITY";
  const int PegScope_NATIONAL_XXCLUDING_LOCAL = 4;
  const int PegScope_NATIONAL_EXCLUDING_LOCAL = 4;
  const int PegScope_LOCAL = 1;
  const int PegScope_GLOBAL = 3;
  const int PegScope_NATIONAL = 2;
  const int SettlDeliveryType_TRI_PARTY = 2;
  const int SettlDeliveryType_HOLD_IN_CUSTODY = 3;
  const int SettlDeliveryType_FREE = 1;
  const int SettlDeliveryType_VERSUS_PAYMENT_DELIVER = 0;
  const int SettlDeliveryType_FREE_DELIVER = 1;
  const int SettlDeliveryType_VERSUS_PAYMENT = 0;
  const int DiscretionLimitType_STRICT = 1;
  const int DiscretionLimitType_OR_BETTER = 0;
  const int DiscretionLimitType_OR_WORSE = 2;
  const int DiscretionLimitType_STRICT_LIMIT_IS_A_STRICT_LIMIT = 1;
  const int DiscretionLimitType_OR_WORSE_FOR_A_BUY_THE_DISCRETION_PRICE_IS_A_MINIMUM_AND_FOR_A_SELL_THE_DISCRETION_PRICE_IS_A_MAXIMUM = 2;
  const char ExerciseMethod_AUTOMATIC = 'A';
  const char ExerciseMethod_MANUAL = 'M';
  const char WorkingIndicator_NO = 'N';
  const char WorkingIndicator_YES = 'Y';
  const int SideMultiLegReportingType_MULTILEG_SECURITY = 3;
  const int SideMultiLegReportingType_SINGLE_SECURITY = 1;
  const int SideMultiLegReportingType_MULTI_LEG_SECURITY = 3;
  const int SideMultiLegReportingType_INDIVIDUAL_LEG_OF_A_MULTI_LEG_SECURITY = 2;
  const int SideMultiLegReportingType_INDIVIDUAL_LEG_OF_A_MULTILEG_SECURITY = 2;
  const int ConfirmRejReason_MISSING_SETTLEMENT_INSTRUCTIONS = 2;
  const int ConfirmRejReason_OTHER = 99;
  const int ConfirmRejReason_MISMATCHED_ACCOUNT = 1;
  const char BidRequestTransType_NEW = 'N';
  const char BidRequestTransType_NO = 'N';
  const char BidRequestTransType_CANCEL = 'C';
  const int MassActionRejectReason_INVALID_OR_UNKNOWN_SECURITY = 1;
  const int MassActionRejectReason_INVALID_OR_UNKNOWN_SECURITY_GROUP = 9;
  const int MassActionRejectReason_INVALID_OR_UNKNOWN_ISSUER_OF_UNDERLYING_SECURITY = 11;
  const int MassActionRejectReason_INVALID_OR_UNKNOWN_SECURITYTYPE = 5;
  const int MassActionRejectReason_INVALID_OR_UNKNOWN_CFICODE = 4;
  const int MassActionRejectReason_INVALID_OR_UNKNOWN_UNDERLYING_SECURITY = 2;
  const int MassActionRejectReason_INVALID_OR_UNKNOWN_TRADING_SESSION = 6;
  const int MassActionRejectReason_INVALID_OR_UNKNOWN_MARKET_SEGMENT = 8;
  const int MassActionRejectReason_INVALID_OR_UNKNOWN_MARKET = 7;
  const int MassActionRejectReason_MASS_ACTION_NOT_SUPPORTED = 0;
  const int MassActionRejectReason_OTHER = 99;
  const int MassActionRejectReason_INVALID_OR_UNKNOWN_SECURITY_ISSUER = 10;
  const int MassActionRejectReason_INVALID_OR_UNKNOWN_PRODUCT = 3;
  const int CollApplType_GENERAL = 1;
  const int CollApplType_SPECIFIC_DEPOSIT = 0;
  const int ConfirmType_CONFIRMATION = 2;
  const int ConfirmType_CONFIRMATION_REQUEST_REJECTED = 3;
  const int ConfirmType_STATUS = 1;
  const int MDQuoteType_INDICATIVE = 0;
  const int MDQuoteType_RESTRICTED_TRADEABLE = 2;
  const int MDQuoteType_INDICATIVE_AND_TRADEABLE = 4;
  const int MDQuoteType_TRADEABLE = 1;
  const int MDQuoteType_COUNTER = 3;
  const int QtyType_CONTRACTS = 1;
  const int QtyType_UNITS_OF_MEASURE_PER_TIME_UNIT = 2;
  const int QtyType_UNITS = 0;
  const int QuoteRespType_END_TRADE = 7;
  const int QuoteRespType_COVER = 4;
  const int QuoteRespType_HIT_LIFT = 1;
  const int QuoteRespType_DONE_AWAY = 5;
  const int QuoteRespType_TIMED_OUT = 8;
  const int QuoteRespType_PASS = 6;
  const int QuoteRespType_EXPIRED = 3;
  const int QuoteRespType_COUNTER = 2;
  const char IOINaturalFlag_NO = 'N';
  const char IOINaturalFlag_YES = 'Y';
  const char SettlObligSource_INSTRUCTIONS_OF_BROKER = '1';
  const char SettlObligSource_INVESTOR = '3';
  const char SettlObligSource_INSTRUCTIONS_FOR_INSTITUTION = '2';
  const int TrdSubType_ON_HOURS_TRADE = 34;
  const int TrdSubType_INTERIM_PROTECTED_TRADE = 38;
  const int TrdSubType_K = 16;
  const int TrdSubType_LC = 17;
  const int TrdSubType_WN = 31;
  const int TrdSubType_CONVERTED_SWAP = 36;
  const int TrdSubType_B = 15;
  const int TrdSubType_M = 18;
  const int TrdSubType_RT = 28;
  const int TrdSubType_ONSET_DUE_TO_AN_ALLOCATION = 6;
  const int TrdSubType_CMTA = 0;
  const int TrdSubType_INTERNAL_TRANSFER_OR_ADJUSTMENT = 1;
  const int TrdSubType_DIFFERENTIAL_SPREAD = 7;
  const int TrdSubType_TRANSACTION_FROM_EXERCISE = 9;
  const int TrdSubType_TRANSACTION_FROM_ASSIGNMENT = 10;
  const int TrdSubType_N = 19;
  const int TrdSubType_IMPLIED_SPREAD_LEG_EXECUTED_AGAINST_AN_OUTRIGHT = 8;
  const int TrdSubType_NR = 21;
  const int TrdSubType_SW = 29;
  const int TrdSubType_OTC_QUOTE = 35;
  const int TrdSubType_ADVISORY_FOR_CONTRA_SIDE = 4;
  const int TrdSubType_OFFSET_DUE_TO_AN_ALLOCATION = 5;
  const int TrdSubType_P = 22;
  const int TrdSubType_CROSSED_TRADE = 37;
  const int TrdSubType_PA = 23;
  const int TrdSubType_EXTERNAL_TRANSFER_OR_TRANSFER_OF_ACCOUNT = 2;
  const int TrdSubType_R = 26;
  const int TrdSubType_RO = 27;
  const int TrdSubType_WT = 32;
  const int TrdSubType_OFF_HOURS_TRADE = 33;
  const int TrdSubType_REJECT_FOR_SUBMITTING_SIDE = 3;
  const int TrdSubType_ONSET_DUT_TO_AN_ALLOCATION = 6;
  const int TrdSubType_AI = 14;
  const int TrdSubType_PC = 24;
  const int TrdSubType_PN = 25;
  const int TrdSubType_LARGE_IN_SCALE = 39;
  const int TrdSubType_NM = 20;
  const int TrdSubType_T = 30;
  const int TrdSubType_ACATS = 11;
  const char ExecTransType_NEW = '0';
  const char ExecTransType_CORRECT = '2';
  const char ExecTransType_CANCEL = '1';
  const char ExecTransType_STATUS = '3';
  const char DayBookingInst_CAN_TRIGGER_BOOKING_WITHOUT_REFERENCE_TO_THE_ORDER_INITIATOR = '0';
  const char DayBookingInst_ACCUMULATE = '2';
  const char DayBookingInst_SPEAK_WITH_ORDER_INITIATOR_BEFORE_BOOKING = '1';
  const int FlowScheduleType_NERC_EASTERN_OFF_PEAK = 0;
  const int FlowScheduleType_NERC_WESTERN_PEAK = 4;
  const int FlowScheduleType_NERC_EASTERN_PEAK = 3;
  const int FlowScheduleType_NERC_CALENDAR_ALL_DAYS_IN_MONTH = 2;
  const int FlowScheduleType_NERC_WESTERN_OFF_PEAK = 1;
  const int MDOriginType_CROSS = 2;
  const int MDOriginType_OFF_BOOK = 1;
  const int MDOriginType_BOOK = 0;
  const int CollInquiryStatus_COMPLETED = 2;
  const int CollInquiryStatus_ACCEPTED_WITH_WARNINGS = 1;
  const int CollInquiryStatus_REJECTED = 4;
  const int CollInquiryStatus_ACCEPTED = 0;
  const int CollInquiryStatus_COMPLETED_WITH_WARNINGS = 3;
  const int CPProgram_OTHER = 99;
  const int CPProgram_3 = 1;
  const int CPProgram_4 = 2;
  const int PosReqType_POSITIONS = 0;
  const int PosReqType_BACKOUT_MESSAGE = 5;
  const int PosReqType_DELTA_POSITIONS = 6;
  const int PosReqType_SETTLEMENT_ACTIVITY = 4;
  const int PosReqType_TRADES = 1;
  const int PosReqType_EXERCISES = 2;
  const int PosReqType_ASSIGNMENTS = 3;
  const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_AN_UNDERLYING_SECURITY = 2;
  const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_A_SECURITY = 1;
  const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_A_CFICODE = 4;
  const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_A_PARTYID = 8;
  const int MassStatusReqType_STATUS_FOR_SECURITY_ISSUER = 9;
  const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_A_TRADING_SESSION = 6;
  const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_A_PRODUCT = 3;
  const int MassStatusReqType_STATUS_FOR_ORDERS_FOR_A_SECURITYTYPE = 5;
  const int MassStatusReqType_STATUS_FOR_ALL_ORDERS = 7;
  const int MassStatusReqType_STATUS_FOR_ISSUER_OF_UNDERLYING_SECURITY = 10;
  const char SubscriptionRequestType_DISABLE_PREVIOUS_SNAPSHOT_PLUS_UPDATE_REQUEST = '2';
  const char SubscriptionRequestType_SNAPSHOT_PLUS_UPDATES = '1';
  const char SubscriptionRequestType_SNAPSHOT = '0';
  const int NewsCategory_MARKETPLACE_NEWS = 1;
  const int NewsCategory_TECHNICAL_NEWS = 3;
  const int NewsCategory_COMPANY_NEWS = 0;
  const int NewsCategory_OTHER_NEWS = 99;
  const int NewsCategory_FINANCIAL_MARKET_NEWS = 2;
  const char IOIQty_MEDIUM[] = "M";
  const char IOIQty_LARGE[] = "L";
  const char IOIQty_SMALL[] = "S";
  const char IOIQty_UNDISCLOSED_QUANTITY[] = "U";
  const int ApplResponseError_USER_NOT_AUTHORIZED_FOR_APPLICATION = 2;
  const int ApplResponseError_APPLICATION_DOES_NOT_EXIST = 0;
  const int ApplResponseError_MESSAGES_REQUESTED_ARE_NOT_AVAILABLE = 1;
  const char TriggerPriceDirection_TRIGGER_IF_THE_PRICE_OF_THE_SPECIFIED_TYPE_GOES_DOWN_TO_OR_THROUGH_THE_SPECIFIED_TRIGGER_PRICE = 'D';
  const char TriggerPriceDirection_TRIGGER_IF_THE_PRICE_OF_THE_SPECIFIED_TYPE_GOES_UP_TO_OR_THROUGH_THE_SPECIFIED_TRIGGER_PRICE = 'U';
  const int LastLiquidityInd_LIQUIDITY_ROUTED_OUT = 3;
  const int LastLiquidityInd_AUCTION = 4;
  const int LastLiquidityInd_ADDED_LIQUIDITY = 1;
  const int LastLiquidityInd_REMOVED_LIQUIDITY = 2;
  const int StrikePriceDeterminationMethod_STRIKE_SET_TO_AVERAGE_OF_UNDERLYING_SETTLEMENT_PRICE_ACROSS_THE_LIFE_OF_THE_OPTION = 3;
  const int StrikePriceDeterminationMethod_STRIKE_SET_AT_EXPIRATION_TO_UNDERLYING_OR_OTHER_VALUE = 2;
  const int StrikePriceDeterminationMethod_FIXED_STRIKE = 1;
  const int StrikePriceDeterminationMethod_STRIKE_SET_TO_OPTIMAL_VALUE = 4;
  const int TargetStrategy_PARTICIPATE = 2;
  const int TargetStrategy_MININIZE_MARKET_IMPACT = 3;
  const int TargetStrategy_VWAP = 1;
  const char DueToRelated_NO = 'N';
  const char DueToRelated_YES = 'Y';
  const char UnderlyingCashType_DIFF[] = "DIFF";
  const char UnderlyingCashType_FIXED[] = "FIXED";
  const int CustOrderCapacity_CLEARING_FIRM_TRADING_FOR_ITS_PROPRIETARY_ACCOUNT = 2;
  const int CustOrderCapacity_MEMBER_TRADING_FOR_THEIR_OWN_ACCOUNT = 1;
  const int CustOrderCapacity_MEMBER_TRADING_FOR_ANOTHER_MEMBER = 3;
  const int CustOrderCapacity_ALL_OTHER = 4;
  const char OwnershipType_JOINT_TRUSTEES = '2';
  const char OwnershipType_JOINT_INVESTORS = 'J';
  const char OwnershipType_TENANTS_IN_COMMON = 'T';
  const char UnitOfMeasure_US_DOLLARS[] = "USD";
  const char UnitOfMeasure_TONS[] = "tn";
  const char UnitOfMeasure_TROY_OUNCES[] = "oz_tr";
  const char UnitOfMeasure_MEGAWATT_HOURS[] = "MWh";
  const char UnitOfMeasure_ONE_MILLION_BTU[] = "MMBtu";
  const char UnitOfMeasure_BILLION_CUBIC_FEET[] = "Bcf";
  const char UnitOfMeasure_MILLION_BARRELS[] = "MMbbl";
  const char UnitOfMeasure_GALLONS[] = "Gal";
  const char UnitOfMeasure_BARRELS[] = "Bbl";
  const char UnitOfMeasure_POUNDS[] = "lbs";
  const char UnitOfMeasure_METRIC_TONS[] = "t";
  const char UnitOfMeasure_ALLOWANCES[] = "Alw";
  const char UnitOfMeasure_BUSHELS[] = "Bu";
  const char SettlmntTyp_WHEN_AND_IF_ISSUED = '7';
  const char SettlmntTyp_T_PLUS_1 = 'A';
  const char SettlmntTyp_FUTURE = '6';
  const char SettlmntTyp_SELLERS_OPTION = '8';
  const char SettlmntTyp_T_PLUS_2 = '3';
  const char SettlmntTyp_T_PLUS_3 = '4';
  const char SettlmntTyp_T_PLUS_4 = '5';
  const char SettlmntTyp_REGULAR = '0';
  const char SettlmntTyp_T_PLUS_5 = '9';
  const char SettlmntTyp_WHEN_ISSUED = '7';
  const char SettlmntTyp_NEXT_DAY = '2';
  const char SettlmntTyp_CASH = '1';
  const int TradePublishIndicator_DO_NOT_PUBLISH_TRADE = 0;
  const int TradePublishIndicator_DEFERRED_PUBLICATION = 2;
  const int TradePublishIndicator_PUBLISH_TRADE = 1;
  const int ApplResponseType_MESSAGES_NOT_AVAILABLE = 2;
  const int ApplResponseType_APPLICATION_DOES_NOT_EXIST = 1;
  const int ApplResponseType_REQUEST_SUCCESSFULLY_PROCESSED = 0;
  const int StandInstDbType_DTC_SID = 1;
  const int StandInstDbType_ACCOUNTNET = 4;
  const int StandInstDbType_A_GLOBAL_CUSTODIAN = 3;
  const int StandInstDbType_THOMSON_ALERT = 2;
  const int StandInstDbType_OTHER = 0;
  const int QuoteEntryStatus_CROSS_MARKET_WARNING = 13;
  const int QuoteEntryStatus_LOCKED_MARKET_WARNING = 12;
  const int QuoteEntryStatus_CANCELED_DUE_TO_CROSS_MARKET = 15;
  const int QuoteEntryStatus_CANCELED_DUE_TO_LOCK_MARKET = 14;
  const int QuoteEntryStatus_REJECTED = 5;
  const int QuoteEntryStatus_EXPIRED = 7;
  const int QuoteEntryStatus_REMOVED_FROM_MARKET = 6;
  const int QuoteEntryStatus_ACCEPTED = 0;
  const int QuoteEntryStatus_ACTIVE = 16;
  const char TriggerPriceType_BEST_MID = '6';
  const char TriggerPriceType_BEST_BID_OR_LAST_TRADE = '4';
  const char TriggerPriceType_BEST_BID = '3';
  const char TriggerPriceType_BEST_OFFER_OR_LAST_TRADE = '5';
  const char TriggerPriceType_BEST_OFFER = '1';
  const char TriggerPriceType_LAST_TRADE = '2';
  const int SettlInstReqRejCode_UNABLE_TO_PROCESS_REQUEST = 0;
  const int SettlInstReqRejCode_NO_MATCHING_SETTLEMENT_INSTRUCTIONS_FOUND = 2;
  const int SettlInstReqRejCode_UNKNOWN_ACCOUNT = 1;
  const int SettlInstReqRejCode_OTHER = 99;
  const char Urgency_FLASH = '1';
  const char Urgency_NORMAL = '0';
  const char Urgency_BACKGROUND = '2';
  const int CollAsgnTransType_REPLACE = 1;
  const int CollAsgnTransType_NEW = 0;
  const int CollAsgnTransType_REVERSE = 4;
  const int CollAsgnTransType_CANCEL = 2;
  const int CollAsgnTransType_RELEASE = 3;
  const int PaymentMethod_FED_WIRE = 7;
  const int PaymentMethod_EUROCLEAR = 3;
  const int PaymentMethod_ACH_CREDIT = 13;
  const int PaymentMethod_TELEGRAPHIC_TRANSFER = 6;
  const int PaymentMethod_FEDWIRE = 7;
  const int PaymentMethod_DIRECT_DEBIT = 9;
  const int PaymentMethod_CREDIT_CARD = 11;
  const int PaymentMethod_CHEQUE = 5;
  const int PaymentMethod_DIRECT_CREDIT = 10;
  const int PaymentMethod_CREST = 1;
  const int PaymentMethod_HIGH_VALUE_CLEARING_SYSTEM = 15;
  const int PaymentMethod_CLEARSTREAM = 4;
  const int PaymentMethod_BPAY = 14;
  const int PaymentMethod_NSCC = 2;
  const int PaymentMethod_DEBIT_CARD = 8;
  const int PaymentMethod_ACH_DEBIT = 12;
  const char TriggerPriceTypeScope_LOCAL = '1';
  const char TriggerPriceTypeScope_NONE = '0';
  const char TriggerPriceTypeScope_GLOBAL = '3';
  const char TriggerPriceTypeScope_NATIONAL = '2';
  const int PegLimitType_STRICT = 1;
  const int PegLimitType_OR_BETTER = 0;
  const int PegLimitType_OR_WORSE = 2;
  const int PegLimitType_STRICT_LIMIT_IS_A_STRICT_LIMIT = 1;
  const int PegLimitType_OR_WORSE_FOR_A_BUY_THE_PEG_LIMIT_IS_A_MINIMUM_AND_FOR_A_SELL_THE_PEG_LIMIT_IS_A_MAXIMUM = 2;
  const char Side_BORROW = 'G';
  const char Side_BUY_MINUS = '3';
  const char Side_SUBSCRIBE = 'D';
  const char Side_CROSS_SHORT_EXEMPT = 'A';
  const char Side_UNDISCLOSED = '7';
  const char Side_CROSS = '8';
  const char Side_SELL_SHORT_EXEMPT = '6';
  const char Side_BUY = '1';
  const char Side_CROSS_SHORT_EXXMPT = 'A';
  const char Side_SELL = '2';
  const char Side_LEND = 'F';
  const char Side_SELL_SHORT = '5';
  const char Side_OPPOSITE = 'C';
  const char Side_CROSS_SHORT = '9';
  const char Side_SELL_PLUS = '4';
  const char Side_REDEEM = 'E';
  const char Side_AS_DEFINED = 'B';
  const int ContAmtType_EXIT_CHARGE = 10;
  const int ContAmtType_DILUTION_LEVY_AMOUNT = 7;
  const int ContAmtType_DILUTION_LEVY_PERCENT = 8;
  const int ContAmtType_DISCOUNT_AMOUNT = 5;
  const int ContAmtType_COMMISSION = 2;
  const int ContAmtType_INITIAL_CHARGE_PERCENT = 4;
  const int ContAmtType_DILUTION_LEVY = 8;
  const int ContAmtType_COMMISSION_AMOUNT = 1;
  const int ContAmtType_NET_SETTLEMENT_AMOUNT = 15;
  const int ContAmtType_FUND_BASED_RENEWAL_COMMISSION = 11;
  const int ContAmtType_DISCOUNT = 6;
  const int ContAmtType_FUND_BASED_RENEWAL_COMMISSION_AMOUNT_13 = 13;
  const int ContAmtType_EXIT_CHARGE_AMOUNT = 9;
  const int ContAmtType_INITIAL_CHARGE = 4;
  const int ContAmtType_DISCOUNT_PERCENT = 6;
  const int ContAmtType_EXIT_CHARGE_PERCENT = 10;
  const int ContAmtType_FUND_BASED_RENEWAL_COMMISSION_AMOUNT_14 = 14;
  const int ContAmtType_COMMISSION_PERCENT = 2;
  const int ContAmtType_FUND_BASED_RENEWAL_COMMISSION_PERCENT = 11;
  const int ContAmtType_PROJECTED_FUND_VALUE = 12;
  const int ContAmtType_INITIAL_CHARGE_AMOUNT = 3;
  const char OrderCategory_IMPLIED_ORDER = '7';
  const char OrderCategory_STREAMING_PRICE = '9';
  const char OrderCategory_QUOTE_REQUEST = '6';
  const char OrderCategory_CROSS_ORDER = '8';
  const char OrderCategory_MULTILEG_ORDER = '4';
  const char OrderCategory_PRIVATELY_NEGOTIATED_TRADE = '3';
  const char OrderCategory_QUOTE = '2';
  const char OrderCategory_ORDER = '1';
  const char OrderCategory_LINKED_ORDER = '5';
  const char AdvTransType_REPLACE[] = "R";
  const char AdvTransType_NEW[] = "N";
  const char AdvTransType_CANCEL[] = "C";
  const char PublishTrdIndicator_NO = 'N';
  const char PublishTrdIndicator_YES = 'Y';
  const int SecurityResponseType_LIST_OF_SECURITIES_RETURNED_PER_REQUEST = 4;
  const int SecurityResponseType_LIST_OF_SECURITY_TYPES_RETURNED_PER_REQUEST = 3;
  const int SecurityResponseType_ACCEPT_SECURITY_PROPOSAL_WITH_REVISIONS_AS_INDICATED_IN_THE_MESSAGE = 2;
  const int SecurityResponseType_ACCEPT_SECURITY_PROPOSAL_AS_IS = 1;
  const int SecurityResponseType_REJECT_SECURITY_PROPOSAL = 5;
  const int SecurityResponseType_CAN_NOT_MATCH_SELECTION_CRITERIA = 6;
  const int SecurityResponseType_CANNOT_MATCH_SELECTION_CRITERIA = 6;
  const int SessionStatus_PASSWORD_EXPIRED = 8;
  const int SessionStatus_SESSION_LOGOUT_COMPLETE = 4;
  const int SessionStatus_INVALID_USERNAME_OR_PASSWORD = 5;
  const int SessionStatus_SESSION_ACTIVE = 0;
  const int SessionStatus_SESSION_PASSWORD_CHANGED = 1;
  const int SessionStatus_ACCOUNT_LOCKED = 6;
  const int SessionStatus_LOGONS_ARE_NOT_ALLOWED_AT_THIS_TIME = 7;
  const int SessionStatus_SESSION_PASSWORD_DUE_TO_EXPIRE = 2;
  const int SessionStatus_NEW_SESSION_PASSWORD_DOES_NOT_COMPLY_WITH_POLICY = 3;
  const int AllocAccountType_HOUSE_TRADER = 3;
  const int AllocAccountType_FLOOR_TRADER = 4;
  const int AllocAccountType_ACCOUNT_IS_CARRIED_ON_NON_CUSTOMER_SIDE_OF_BOOKS = 2;
  const int AllocAccountType_JOINT_BACK_OFFICE_ACCOUNT = 8;
  const int AllocAccountType_ACCOUNT_IS_CARRIED_ON_NON_CUSTOMER_SIDE_OF_BOOKS_AND_IS_CROSS_MARGINED = 6;
  const int AllocAccountType_ACCOUNT_IS_CARRIED_ON_CUSTOMER_SIDE_OF_BOOKS = 1;
  const int AllocAccountType_ACCOUNT_IS_CARRIED_PN_CUSTOMER_SIDE_OF_BOOKS = 1;
  const int AllocAccountType_JOINT_BACKOFFICE_ACCOUNT = 8;
  const int AllocAccountType_ACCOUNT_IS_HOUSE_TRADER_AND_IS_CROSS_MARGINED = 7;
  const char AllocTransType_REPLACE = '1';
  const char AllocTransType_NEW = '0';
  const char AllocTransType_CALCULATED = '4';
  const char AllocTransType_PRELIMINARY = '3';
  const char AllocTransType_CANCEL = '2';
  const char AllocTransType_REVERSAL = '6';
  const char AllocTransType_CALCULATED_WITHOUT_PRELIMINARY = '5';
  const int ExpirationQtyType_DIFFERENCE = 5;
  const int ExpirationQtyType_FINAL_WILL_BE_EXERCISED = 3;
  const int ExpirationQtyType_NON_AUTO_EXERCISE = 2;
  const int ExpirationQtyType_CONTRARY_INTENTION = 4;
  const int ExpirationQtyType_AUTO_EXERCISE = 1;
  const int AllocHandlInst_FORWARD_AND_MATCH = 3;
  const int AllocHandlInst_FORWARD = 2;
  const int AllocHandlInst_MATCH = 1;
  const int TradeRequestStatus_COMPLETED = 1;
  const int TradeRequestStatus_REJECTED = 2;
  const int TradeRequestStatus_ACCEPTED = 0;
  const char PreallocMethod_DO_NOT_PRO_RATA_DISCUSS_FIRST = '1';
  const char PreallocMethod_PRO_RATA = '0';
  const char PreallocMethod_DO_NOT_PRO_RATA = '1';
  const int TaxAdvantageType_457 = 23;
  const int TaxAdvantageType_MAXI_ISA = 1;
  const int TaxAdvantageType_EMPLOYEE_CURRENT_YEAR = 10;
  const int TaxAdvantageType_EMPLOYEE_9 = 9;
  const int TaxAdvantageType_403 = 22;
  const int TaxAdvantageType_KEOGH = 18;
  const int TaxAdvantageType_401K = 20;
  const int TaxAdvantageType_SELF_DIRECTED_IRA = 21;
  const int TaxAdvantageType_DEFINED_CONTRIBUTION_PLAN = 15;
  const int TaxAdvantageType_INDIVIDUAL_RETIREMENT_ACCOUNT_16 = 16;
  const int TaxAdvantageType_ROTH_IRA_24 = 24;
  const int TaxAdvantageType_CURRENT_YEAR_PAYMENT = 6;
  const int TaxAdvantageType_MINI_INSURANCE_ISA = 5;
  const int TaxAdvantageType_INDIVIDUAL_RETIREMENT_ACCOUNT_17 = 17;
  const int TaxAdvantageType_EDUCATION_IRA_28 = 28;
  const int TaxAdvantageType_ROTH_IRA_25 = 25;
  const int TaxAdvantageType_INDIVIDUAL_RETIREMENT_ACCOUNT = 16;
  const int TaxAdvantageType_EMPLOYEE_10 = 10;
  const int TaxAdvantageType_EDUCATION_IRA_29 = 29;
  const int TaxAdvantageType_PRIOR_YEAR_PAYMENT = 7;
  const int TaxAdvantageType_INDIVIDUAL_RETIREMENT_ACCOUNT_ROLLOVER = 17;
  const int TaxAdvantageType_EMPLOYER_11 = 11;
  const int TaxAdvantageType_ASSET_TRANSFER = 8;
  const int TaxAdvantageType_EMPLOYER_12 = 12;
  const int TaxAdvantageType_OTHER = 999;
  const int TaxAdvantageType_MINI_STOCKS_AND_SHARES_ISA = 4;
  const int TaxAdvantageType_EMPLOYEE = 9;
  const int TaxAdvantageType_ROTH_CONVERSION_IRA_26 = 26;
  const int TaxAdvantageType_MINI_CASH_ISA = 3;
  const int TaxAdvantageType_ROTH_CONVERSION_IRA_27 = 27;
  const int TaxAdvantageType_NONE_NOT_APPLICABLE = 0;
  const int TaxAdvantageType_TESSA = 2;
  const int TaxAdvantageType_NON_FUND_QUALIFIED_PLAN = 14;
  const int TaxAdvantageType_EMPLOYER_CURRENT_YEAR = 12;
  const int TaxAdvantageType_EMPLOYER = 11;
  const int TaxAdvantageType_PROFIT_SHARING_PLAN = 19;
  const int TaxAdvantageType_401 = 20;
  const int TaxAdvantageType_NON_FUND_PROTOTYPE_IRA = 13;
  const char MessageEncoding_EUC_JP[] = "EUC-JP";
  const char MessageEncoding_SHIFT_JIS[] = "SHIFT_JIS";
  const char MessageEncoding_UTF_8[] = "UTF-8";
  const char MessageEncoding_ISO_2022_JP[] = "ISO-2022-JP";
  const char MessageEncoding_EUC[] = "EUC-JP";
  const char MessageEncoding_JIS[] = "ISO-2022-JP";
  const char MessageEncoding_FOR_USING_SJIS[] = "Shift_JIS";
  const char MessageEncoding_UNICODE[] = "UTF-8";
  const char TimeInForce_GOOD_TILL_CROSSING = '5';
  const char TimeInForce_FILL_OR_KILL = '4';
  const char TimeInForce_GOOD_TILL_DATE = '6';
  const char TimeInForce_GOOD_TILL_CANCEL = '1';
  const char TimeInForce_DAY = '0';
  const char TimeInForce_AT_CROSSING = '9';
  const char TimeInForce_IMMEDIATE_OR_CANCEL = '3';
  const char TimeInForce_GOOD_THROUGH_CROSSING = '8';
  const char TimeInForce_AT_THE_CLOSE = '7';
  const char TimeInForce_AT_THE_OPENING = '2';
  const char IOIQualifier_THROUGH_THE_DAY = 'T';
  const char IOIQualifier_INDIDCATION = 'W';
  const char IOIQualifier_AT_THE_MARKET = 'Q';
  const char IOIQualifier_AT_THE_MIDPOINT = 'Y';
  const char IOIQualifier_CROSSING_OPPORTUNITY = 'X';
  const char IOIQualifier_CURRENT_QUOTE = 'Q';
  const char IOIQualifier_IN_TOUCH_WITH = 'I';
  const char IOIQualifier_ALL_OR_NONE = 'A';
  const char IOIQualifier_TAKING_A_POSITION = 'P';
  const char IOIQualifier_AT_THE_OPEN = 'O';
  const char IOIQualifier_PORTFOLIO_SHOW_N = 'S';
  const char IOIQualifier_MARKET_ON_CLOSE = 'B';
  const char IOIQualifier_VERSUS = 'V';
  const char IOIQualifier_LIMIT = 'L';
  const char IOIQualifier_PORTFOLIO_SHOWN = 'S';
  const char IOIQualifier_READY_TO_TRADE = 'R';
  const char IOIQualifier_PRE_OPEN = 'Z';
  const char IOIQualifier_INDICATION = 'W';
  const char IOIQualifier_MORE_BEHIND = 'M';
  const char IOIQualifier_VWAP = 'D';
  const char IOIQualifier_AT_THE_CLOSE = 'C';
  const int StrikePriceBoundaryMethod_GREATER_THAN_OR_EQUAL_TO_UNDERLYING_PRICE_IS_IN_THE_MONEY = 4;
  const int StrikePriceBoundaryMethod_GREATER_THAN_UNDERLYING_IS_IN_THE_MONEY = 5;
  const int StrikePriceBoundaryMethod_LESS_THAN_OR_EQUAL_TO_THE_UNDERLYING_PRICE_IS_IN_THE_MONEY = 2;
  const int StrikePriceBoundaryMethod_LESS_THAN_UNDERLYING_PRICE_IS_IN_THE_MONEY = 1;
  const int StrikePriceBoundaryMethod_EQUAL_TO_THE_UNDERLYING_PRICE_IS_IN_THE_MONEY = 3;
  const char MiscFeeType_CONVERSION[] = "11";
  const char MiscFeeType_CONSUMPTION_TAX[] = "9";
  const char MiscFeeType_LOCAL_COMMISSION[] = "3";
  const char MiscFeeType_TAX[] = "2";
  const char MiscFeeType_MARKUP[] = "8";
  const char MiscFeeType_SECURITY_LENDING[] = "14";
  const char MiscFeeType_PER_TRANSACTION[] = "10";
  const char MiscFeeType_REGULATORY[] = "1";
  const char MiscFeeType_STAMP[] = "5";
  const char MiscFeeType_TRANSFER_FEE[] = "13";
  const char MiscFeeType_AGENT[] = "12";
  const char MiscFeeType_OTHER[] = "7";
  const char MiscFeeType_EXCHANGE_FEES[] = "4";
  const char MiscFeeType_LEVY[] = "6";
  const char SecurityIDSource_OPTION_PRICE_REPORTING_AUTHORITY[] = "J";
  const char SecurityIDSource_CLEARING_HOUSE[] = "H";
  const char SecurityIDSource_EXCHANGE_SYMBOL[] = "8";
  const char SecurityIDSource_SICOVAM[] = "E";
  const char SecurityIDSource_ISDA_FPML_PRODUCT_URL[] = "K";
  const char SecurityIDSource_ISDA_FPML_PRODUCT_SPECIFICATION[] = "I";
  const char SecurityIDSource_RIC_CODE[] = "5";
  const char SecurityIDSource_ISO_CURRENCY_CODE[] = "6";
  const char SecurityIDSource_COMMON[] = "G";
  const char SecurityIDSource_VALOREN[] = "D";
  const char SecurityIDSource_BELGIAN[] = "F";
  const char SecurityIDSource_OPTIONS_PRICE_REPORTING_AUTHORITY[] = "J";
  const char SecurityIDSource_ISIN_NUMBER[] = "4";
  const char SecurityIDSource_SEDOL[] = "2";
  const char SecurityIDSource_ISO_COUNTRY_CODE[] = "7";
  const char SecurityIDSource_LETTER_OF_CREDIT[] = "L";
  const char SecurityIDSource_BLOOMBERG_SYMBOL[] = "A";
  const char SecurityIDSource_WERTPAPIER[] = "B";
  const char SecurityIDSource_MARKETPLACE_ASSIGNED_IDENTIFIER[] = "M";
  const char SecurityIDSource_CONSOLIDATED_TAPE_ASSOCIATION[] = "9";
  const char SecurityIDSource_DUTCH[] = "C";
  const char SecurityIDSource_QUIK[] = "3";
  const char SecurityIDSource_CUSIP[] = "1";
  const int NewsRefType_OTHER_LANGUAGE = 1;
  const int NewsRefType_COMPLIMENTARY = 2;
  const int NewsRefType_REPLACEMENT = 0;
  const char TriggerOrderType_LIMIT = '2';
  const char TriggerOrderType_MARKET = '1';
  const int CrossType_CROSS_TRADE_IS_EXECUTED_WITH_EXISTING_ORDERS_WITH_THE_SAME_PRICE_IN_THE_CASE_OTHER_ORDERS_EXIST_WITH_THE_SAME_PRICE_THE_QUANTITY_OF_THE_CROSS_IS_EXECUTED_AGAINST_THE_EXISTING_ORDERS_AND_QUOTES_THE_REMAINDER_OF_THE_CROSS_IS_EXECUTED_AGAINST_THE_OTHER_SIDE_OF_THE_CROSS_THE_TWO_SIDES_POTENTIALLY_HAVE_DIFFERENT_QUANTITIES = 4;
  const int CrossType_CROSS_AON = 1;
  const int CrossType_CROSS_TRADE_WHICH_IS_PARTIALLY_EXECUTED_WITH_THE_UNFILLED_PORTIONS_REMAINING_ACTIVE_ONE_SIDE_OF_THE_CROSS_IS_FULLY_EXECUTED = 3;
  const int CrossType_CROSS_TRADE_WHICH_IS_EXECUTED_COMPLETELY_OR_NOT_BOTH_SIDES_ARE_TREATED_IN_THE_SAME_MANNER_THIS_IS_EQUIVALENT_TO_AN_ALL_OR_NONE = 1;
  const int CrossType_CROSS_TRADE_IS_EXECUTED_WITH_EXISTING_ORDERS_WITH_THE_SAME_PRICE = 4;
  const int CrossType_CROSS_ONE_SIDE = 3;
  const int CrossType_CROSS_SAME_PRICE = 4;
  const int CrossType_CROSS_IOC = 2;
  const int CrossType_CROSS_TRADE_WHICH_IS_EXECUTED_PARTIALLY_AND_THE_REST_IS_CANCELLED_ONE_SIDE_IS_FULLY_EXECUTED_THE_OTHER_SIDE_IS_PARTIALLY_EXECUTED_WITH_THE_REMAINDER_BEING_CANCELLED_THIS_IS_EQUIVALENT_TO_AN_IMMEDIATE_OR_CANCEL_ON_THE_OTHER_SIDE = 2;
  const int CrossType_CROSS_TRADE_WHICH_IS_EXECUTED_PARTIALLY_AND_THE_REST_IS_CANCELLED_ONE_SIDE_IS_FULLY_EXECUTED_THE_OTHER_SIDE_IS_PARTIALLY_EXECUTED_WITH_THE_REMAINDER_BEING_CANCELLED_THIS_IS_EQUIVALENT_TO_AN_IMMEDIATE_OR_CANCEL_ON_THE_OTHER_SIDE_NOTE_THE_CROSSPRIORITZATION = 2;
  const char OpenCloseSettleFlag_SESSION_OPEN = '1';
  const char OpenCloseSettleFlag_DAILY_OPEN = '0';
  const char OpenCloseSettleFlag_EXPECTED_PRICE = '3';
  const char OpenCloseSettleFlag_PRICE_FROM_PREVIOUS_BUSINESS_DAY = '4';
  const char OpenCloseSettleFlag_DELIVERY_SETTLEMENT_PRICE = '2';
  const int MDBookType_PRICE_DEPTH = 2;
  const int MDBookType_ORDER_DEPTH = 3;
  const int MDBookType_TOP_OF_BOOK = 1;
  const char BasisPxType_VWAP_THROUGH_A_DAY_EXCEPT_YORI = '9';
  const char BasisPxType_VWAP_THROUGH_A_MORNING_SESSION = '7';
  const char BasisPxType_CLOSING_PRICE = '3';
  const char BasisPxType_VWAP_THROUGH_A_DAY = '6';
  const char BasisPxType_OTHERS = 'Z';
  const char BasisPxType_OPEN = 'D';
  const char BasisPxType_CLOSING_PRICE_AT_MORNING_SESSION = '2';
  const char BasisPxType_CURRENT_PRICE = '4';
  const char BasisPxType_SQ = '5';
  const char BasisPxType_STRIKE = 'C';
  const char BasisPxType_VWAP_THROUGH_AN_AFTERNOON_SESSION_EXCEPT_YORI = 'B';
  const char BasisPxType_VWAP_THROUGH_A_MORNING_SESSION_EXCEPT_YORI = 'A';
  const char BasisPxType_VWAP_THROUGH_AN_AFTERNOON_SESSION = '8';
  const int ComplexEventType_ROLLING_BARRIER = 9;
  const int ComplexEventType_UNDERLYING = 7;
  const int ComplexEventType_KNOCK_OUT_UP = 5;
  const int ComplexEventType_KNOCK_IN_UP = 3;
  const int ComplexEventType_KOCK_IN_DOWN = 4;
  const int ComplexEventType_TRIGGER = 2;
  const int ComplexEventType_RESET_BARRIER = 8;
  const int ComplexEventType_CAPPED = 1;
  const int ComplexEventType_KNOCK_OUT_DOWN = 6;
  const int MassActionResponse_REJECTED = 0;
  const int MassActionResponse_ACCEPTED = 1;
  const int SecurityRequestType_MARKETID_OR_MARKETID_PLUS_MARKETSEGMENTID = 9;
  const int SecurityRequestType_REQUEST_LIST_SECURITY_TYPES = 2;
  const int SecurityRequestType_REQUEST_LIST_SECURITIES = 3;
  const int SecurityRequestType_SYMBOL = 4;
  const int SecurityRequestType_SECURITYTYPE_AND_OR_CFICODE = 5;
  const int SecurityRequestType_REQUEST_SECURITY_IDENTITY_FOR_THE_SPECIFICATIONS_PROVIDED = 1;
  const int SecurityRequestType_TRADINGSESSIONID = 7;
  const int SecurityRequestType_PRODUCT = 6;
  const int SecurityRequestType_ALL_SECURITIES = 8;
  const int SecurityRequestType_REQUEST_SECURITY_IDENTITY_AND_SPECIFICATIONS = 0;
  const int ListRejectReason_EXCHANGE_CLOSED = 2;
  const int ListRejectReason_UNKNOWN_ORDER = 5;
  const int ListRejectReason_UNSUPPORTED_ORDER_CHARACTERISTIC = 11;
  const int ListRejectReason_DUPLICATE_ORDER = 6;
  const int ListRejectReason_TOO_LATE_TO_ENTER = 4;
  const int ListRejectReason_OTHER = 99;
  const int ListRejectReason_BROKER = 0;
  const char DeskType_PROPRIETARY[] = "PR";
  const char DeskType_ARBITRAGE[] = "AR";
  const char DeskType_TRADING[] = "T";
  const char DeskType_DERIVATIVES[] = "D";
  const char DeskType_SALES[] = "S";
  const char DeskType_INSTITUTIONAL[] = "IS";
  const char DeskType_INTERNATIONAL[] = "IN";
  const char DeskType_AGENCY[] = "A";
  const char DeskType_PREFERRED_TRADING[] = "PF";
  const char DeskType_OTHER[] = "O";
  const char DeskType_PROGRAM_TRADING[] = "PT";
  const char SettlType_WHEN_AND_IF_ISSUED[] = "7";
  const char SettlType_FUTURE[] = "6";
  const char SettlType_BROKEN_DATE[] = "B";
  const char SettlType_SELLERS_OPTION[] = "8";
  const char SettlType_T_PLUS_2[] = "3";
  const char SettlType_T_PLUS_3[] = "4";
  const char SettlType_T_PLUS_4[] = "5";
  const char SettlType_REGULAR[] = "0";
  const char SettlType_FX_SPOT_NEXT_SETTLEMENT[] = "C";
  const char SettlType_T_PLUS_5[] = "9";
  const char SettlType_NEXT_DAY[] = "2";
  const char SettlType_CASH[] = "1";
  const char OpenClose_CLOSE = 'C';
  const char OpenClose_OPEN = 'O';
  const int ContractMultiplierUnit_SHARES = 0;
  const int ContractMultiplierUnit_HOURS = 1;
  const int ContractMultiplierUnit_DAYS = 2;
  const int TrdType_VOLUME_WEIGHTED_AVERAGE_TRADE = 51;
  const int TrdType_FUTURES_LARGE_ORDER_EXECUTION = 17;
  const int TrdType_EXCHANGE_OF_FUTURES_FOR_FUTURES = 18;
  const int TrdType_SPECIAL_EX_CAPITAL_REPAYMENTS = 35;
  const int TrdType_BLOCK_TRADE_38 = 38;
  const int TrdType_DELTA_NEUTRAL_TRANSACTION = 46;
  const int TrdType_LATE_TRADE = 4;
  const int TrdType_CASH_SETTLEMENT = 29;
  const int TrdType_SPECIAL_CUM_CAPITAL_REPAYMENTS = 34;
  const int TrdType_SPECIAL_CUM_BONUS = 36;
  const int TrdType_BLOCK_TRADES = 40;
  const int TrdType_ALL_OR_NONE = 16;
  const int TrdType_OPTION_EXERCISE = 45;
  const int TrdType_FINANCING_TRANSACTION = 47;
  const int TrdType_TRANSFER = 3;
  const int TrdType_TRADING_AT_SETTLEMENT = 15;
  const int TrdType_SPECIAL_EX_DIVIDEND = 26;
  const int TrdType_SPECIAL_EX_COUPON = 28;
  const int TrdType_SPECIAL_PRICE = 30;
  const int TrdType_SPECIAL_CUM_RIGHTS = 32;
  const int TrdType_SPECIAL_EX_BONUS = 37;
  const int TrdType_REGULAR_TRADE = 0;
  const int TrdType_EXCHANGE_GRANTED_TRADE = 52;
  const int TrdType_EXCHANGE_BASIS_FACILITY = 55;
  const int TrdType_BLOCK_TRADE_1 = 1;
  const int TrdType_ERROR_TRADE = 24;
  const int TrdType_NAME_CHANGE = 41;
  const int TrdType_LATE_BUNCHED_TRADE = 8;
  const int TrdType_EFP = 2;
  const int TrdType_NON_STANDARD_SETTLEMENT = 48;
  const int TrdType_EXCHANGE_FOR_RISK = 11;
  const int TrdType_EXCHANGE_FOR_SWAP = 12;
  const int TrdType_EXCHANGE_OF_FUTURES_FOR = 13;
  const int TrdType_OPTION_INTERIM_TRADE = 19;
  const int TrdType_PRIVATELY_NEGOTIATED_TRADES = 22;
  const int TrdType_SUBSTITUTION_OF_FUTURES_FOR_FORWARDS = 23;
  const int TrdType_SPECIAL_CUM_DIVIDEND = 25;
  const int TrdType_GUARANTEED_DELIVERY = 31;
  const int TrdType_PROROGATION_SELL = 44;
  const int TrdType_PRIOR_REFERENCE_PRICE_TRADE = 9;
  const int TrdType_PORTFOLIO_TRADE = 50;
  const int TrdType_WORKED_PRINCIPAL_TRADE = 39;
  const int TrdType_PORTFOLIO_TRANSFER = 42;
  const int TrdType_WEIGHTED_AVERAGE_PRICE_TRADE = 6;
  const int TrdType_EXCHANGE_OF_OPTIONS_FOR_OPTIONS = 14;
  const int TrdType_SPECIAL_CUM_COUPON = 27;
  const int TrdType_T_TRADE = 5;
  const int TrdType_BLOCK_TRADE = 1;
  const int TrdType_OTC = 54;
  const int TrdType_AFTER_HOURS_TRADE = 10;
  const int TrdType_DERIVATIVE_RELATED_TRANSACTION = 49;
  const int TrdType_REPURCHASE_AGREEMENT = 53;
  const int TrdType_SPECIAL_EX_RIGHTS = 33;
  const int TrdType_PROROGATION_BUY = 43;
  const int TrdType_OPTION_CABINET_TRADE = 20;
  const int TrdType_BUNCHED_TRADE = 7;
  const char RestructuringType_MODIFIED_MOD_RESTRUCTURING[] = "MM";
  const char RestructuringType_FULL_RESTRUCTURING[] = "FR";
  const char RestructuringType_NO_RESTRUCTURING_SPECIFIED[] = "XR";
  const char RestructuringType_MODIFIED_RESTRUCTURING[] = "MR";
  const int ProgRptReqs_REAL_TIME_EXECUTION_REPORTS = 3;
  const int ProgRptReqs_BUYSIDE_EXPLICITLY_REQUESTS_STATUS_USING_STATUSREQUEST = 1;
  const int ProgRptReqs_SELL_SIDE_PERIODICALLY_SENDS_STATUS_USING_LIST_STATUS_PERIOD_OPTIONALLY_SPECIFIED_IN_PROGRESSPERIOD = 2;
  const int ProgRptReqs_BUY_SIDE_EXPLICITLY_REQUESTS_STATUS_USING_STATUE_REQUEST = 1;
  const int ProgRptReqs_SELLSIDE_PERIODICALLY_SENDS_STATUS_USING_LISTSTATUS_PERIOD_OPTIONALLY_SPECIFIED_IN_PROGRESSPERIOD = 2;
  const char TradingSessionID_EVENING[] = "5";
  const char TradingSessionID_AFTER_HOURS[] = "6";
  const char TradingSessionID_HALFDAY[] = "2";
  const char TradingSessionID_DAY[] = "1";
  const char TradingSessionID_MORNING[] = "3";
  const char TradingSessionID_AFTERNOON[] = "4";
  const int ListOrderStatus_CANCELING = 4;
  const int ListOrderStatus_REJECT = 7;
  const int ListOrderStatus_ALL_DONE = 6;
  const int ListOrderStatus_IN_BIDDING_PROCESS = 1;
  const int ListOrderStatus_RECEIVED_FOR_EXECUTION = 2;
  const int ListOrderStatus_ALERT = 5;
  const int ListOrderStatus_RECEIVEDFOREXECUTION = 2;
  const int ListOrderStatus_INBIDDINGPROCESS = 1;
  const int ListOrderStatus_CANCELLING = 4;
  const int ListOrderStatus_EXECUTING = 3;
  const char RegistStatus_REJECT = 'R';
  const char RegistStatus_REMINDER_IE_REGISTRATION_INSTRUCTIONS_ARE_STILL_OUTSTANDING = 'N';
  const char RegistStatus_REJECTED = 'R';
  const char RegistStatus_ACCEPTED = 'A';
  const char RegistStatus_REMINDER = 'N';
  const char RegistStatus_HELD = 'H';
  const char RegistStatus_ACCEPT = 'A';
  const int UnderlyingPriceDeterminationMethod_OPTIMAL_VALUE = 3;
  const int UnderlyingPriceDeterminationMethod_SPECIAL_REFERENCE = 2;
  const int UnderlyingPriceDeterminationMethod_AVERAGE_VALUE = 4;
  const int UnderlyingPriceDeterminationMethod_REGULAR = 1;
  const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_SECURITY = '1';
  const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_SECURITY_GROUP = 'A';
  const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_MARKET = '8';
  const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_MARKET_SEGMENT = '9';
  const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_SECURITYTYPE = '5';
  const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_TRADING_SESSION = '6';
  const char MassCancelRequestType_CANCEL_FOR_ISSUER_OF_UNDERLYING_SECURITY = 'C';
  const char MassCancelRequestType_CANCEL_ORDERS_FOR_AN_UNDERLYING_SECURITY = '2';
  const char MassCancelRequestType_CANCEL_ALL_ORDERS = '7';
  const char MassCancelRequestType_CANCEL_FOR_SECURITY_ISSUER = 'B';
  const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_PRODUCT = '3';
  const char MassCancelRequestType_CANCEL_ORDERS_FOR_A_CFICODE = '4';
  const char CxlRejResponseTo_ORDER_CANCEL_REQUEST = '1';
  const char CxlRejResponseTo_ORDER_CANCEL_REPLACE_REQUEST = '2';
  const int QuoteCancelType_CANCEL_BY_QUOTETYPE = 6;
  const int QuoteCancelType_CANCEL_FOR_ONE_OR_MORE_SECURITIES = 1;
  const int QuoteCancelType_CANCEL_QUOTE_SPECIFIED_IN_QUOTEID = 5;
  const int QuoteCancelType_CANCEL_FOR_UNDERLYING_SYMBOL = 3;
  const int QuoteCancelType_CANCEL_ALL_QUOTES = 4;
  const int QuoteCancelType_CANCEL_FOR_UNDERLYING_SECURITY = 3;
  const int QuoteCancelType_CANCEL_FOR_ISSUER_OF_UNDERLYING_SECURITY = 8;
  const int QuoteCancelType_CANCEL_FOR_SECURITY_ISSUER = 7;
  const int QuoteCancelType_CANCEL_FOR_ALL_QUOTES = 4;
  const int QuoteCancelType_CANCEL_FOR_SECURITY_TYPE = 2;
  const int QuoteCancelType_CANCEL_FOR_SYMBOL = 1;
  const char StipulationType_YIELD_TO_MATURITY[] = "YTM";
  const char StipulationType_ALTERNATIVE_MINIMUM_TAX[] = "AMT";
  const char StipulationType_WEIGHTED_AVERAGE_LIFE_COUPON_VALUE_IN_PERCENT[] = "WAL";
  const char StipulationType_GEOGRAPHICS_AND_RANGE[] = "GEOG";
  const char StipulationType_COUPON_RANGE[] = "COUPON";
  const char StipulationType_BANK_QUALIFIED[] = "BANKQUAL";
  const char StipulationType_RATING_SOURCE_AND_RANGE[] = "RATING";
  const char StipulationType_SUBSTITUTIONS_FREQUENCY[] = "SUBSFREQ";
  const char StipulationType_MINIMUM_DENOMINATION[] = "MINDNOM";
  const char StipulationType_AVAILABLE_OFFER_QUANTITY_TO_BE_SHOWN_TO_THE_STREET[] = "AVAILQTY";
  const char StipulationType_MAXIMUM_ORDER_SIZE[] = "MAXORDQTY";
  const char StipulationType_ABSOLUTE_PREPAYMENT_SPEED[] = "ABS";
  const char StipulationType_PRICING_FREQUENCY[] = "PRICEFREQ";
  const char StipulationType_CONSTANT_PREPAYMENT_YIELD[] = "CPY";
  const char StipulationType_YIELD_RANGE[] = "YIELD";
  const char StipulationType_PRINCIPAL_OF_ROLLING_OR_CLOSING_TRADE[] = "REFPRIN";
  const char StipulationType_BENCHMARK_PRICE_SOURCE[] = "PXSOURCE";
  const char StipulationType_MAXIMUM_SUBSTITUTIONS[] = "MAXSUBS";
  const char StipulationType_PERCENT_OF_PROSPECTUS_PREPAYMENT_CURVE[] = "PPC";
  const char StipulationType_MONTHLY_PREPAYMENT_RATE[] = "MPR";
  const char StipulationType_PURPOSE[] = "PURPOSE";
  const char StipulationType_WHOLE_POOL[] = "WHOLE";
  const char StipulationType_WEIGHTED_AVERAGE_LOAN_AGE[] = "WALA";
  const char StipulationType_WEIGHTED_AVERAGE_LIFE_COUPON[] = "WAL";
  const char StipulationType_POOLS_MAXIMUM[] = "PMAX";
  const char StipulationType_MINIMUM_QUANTITY[] = "MINQTY";
  const char StipulationType_FINAL_CPR_OF_HOME_EQUITY_PREPAYMENT_CURVE[] = "HEP";
  const char StipulationType_VALUATION_DISCOUNT[] = "HAIRCUT";
  const char StipulationType_GEOGRAPHICS[] = "GEOG";
  const char StipulationType_AMT[] = "AMT";
  const char StipulationType_WEIGHTED_AVERAGE_MATURITY[] = "WAM";
  const char StipulationType_CALL_PROTECTION[] = "PROTECT";
  const char StipulationType_EXPLICIT_LOT_IDENTIFIER[] = "LOT";
  const char StipulationType_FREEFORM_TEXT[] = "TEXT";
  const char StipulationType_TRADE_VARIANCE[] = "TRDVAR";
  const char StipulationType_WEIGHTED_AVERAGE_COUPONVALUE_IN_PERCENT[] = "WAC";
  const char StipulationType_OFFER_PRICE_TO_BE_SHOWN_TO_INTERNAL_BROKERS[] = "INTERNALPX";
  const char StipulationType_STRUCTURE[] = "STRUCT";
  const char StipulationType_RESTRICTED[] = "RESTRICTED";
  const char StipulationType_CONSTANT_PREPAYMENT_PENALTY[] = "CPP";
  const char StipulationType_OFFER_QUANTITY_TO_BE_SHOWN_TO_INTERNAL_BROKERS[] = "INTERNALQTY";
  const char StipulationType_REFERENCE_TO_ROLLING_OR_CLOSING_TRADE[] = "REFTRADE";
  const char StipulationType_PERCENT_OF_MANUFACTURED_HOUSING_PREPAYMENT_CURVE[] = "MHP";
  const char StipulationType_TYPE_OF_REDEMPTION[] = "REDEMPTION";
  const char StipulationType_SECURITYTYPE_INCLUDED_OR_EXCLUDED[] = "SECTYPE";
  const char StipulationType_PAYMENT_FREQUENCY_CALENDAR[] = "PAYFREQ";
  const char StipulationType_AUTO_REINVESTMENT_AT_RATE_OR_BETTER[] = "AUTOREINV";
  const char StipulationType_ISSUERS_TICKER[] = "ISSUER";
  const char StipulationType_MAXIMUM_LOAN_BALANCE[] = "MAXBAL";
  const char StipulationType_BROKER_SALES_CREDIT_OVERRIDE[] = "SALESCREDITOVR";
  const char StipulationType_OF_BMA_PREPAYMENT_CURVE[] = "PSA";
  const char StipulationType_ISO_CURRENCY_CODE[] = "CURRENCY";
  const char StipulationType_MARKET_SECTOR[] = "SECTOR";
  const char StipulationType_POOL_IDENTIFIER[] = "POOL";
  const char StipulationType_TYPE_OF_ROLL_TRADE[] = "ROLLTYPE";
  const char StipulationType_SECURITY_TYPE_INCLUDED_OR_EXCLUDED[] = "SECTYPE";
  const char StipulationType_YEAR_OF_ISSUE[] = "ISSUE";
  const char StipulationType_LOOKBACK_DAYS[] = "LOOKBACK";
  const char StipulationType_TYPE_OF_REDEMPTION_VALUES_ARE_NONCALLABLE_CALLABLE_PREFUNDED_ESCROWEDTOMATURITY_PUTABLE_CONVERTIBLE[] = "REDEMPTION";
  const char StipulationType_MATURITY_YEAR[] = "MAT";
  const char StipulationType_CUSTOM_START_END_DATE[] = "CUSTOMDATE";
  const char StipulationType_ORDER_QUANTITY_INCREMENT[] = "ORDRINCR";
  const char StipulationType_DISCOUNT_RATE[] = "DISCOUNT";
  const char StipulationType_PERCENT_OF_BMA_PREPAYMENT_CURVE[] = "PSA";
  const char StipulationType_CONSTANT_PREPAYMENT_RATE[] = "CPR";
  const char StipulationType_OF_PROSPECTUS_PREPAYMENT_CURVE[] = "PPC";
  const char StipulationType_AVERAGE_LOAN_SIZE[] = "AVSIZE";
  const char StipulationType_TRADERS_CREDIT[] = "TRADERCREDIT";
  const char StipulationType_POOLS_PER_LOT[] = "PPL";
  const char StipulationType_WEIGHTED_AVERAGE_LIFE[] = "WAL";
  const char StipulationType_MATURITY_RANGE[] = "MATURITY";
  const char StipulationType_POOLS_PER_MILLION[] = "PPM";
  const char StipulationType_LOT_VARIANCE[] = "LOTVAR";
  const char StipulationType_PRIMARY_OR_SECONDARY_MARKET_INDICATOR[] = "PRIMARY";
  const char StipulationType_AVERAGE_FICO_SCORE[] = "AVFICO";
  const char StipulationType_WEIGHTED_AVERAGE_MATURITY_VALUE_IN_MONTHS[] = "WAM";
  const char StipulationType_PRICE_RANGE[] = "PRICE";
  const char StipulationType_MATURITY_YEAR_AND_MONTH[] = "MAT";
  const char StipulationType_MINIMUM_INCREMENT[] = "MININCR";
  const char StipulationType_WEIGHTED_AVERAGE_COUPON[] = "WAC";
  const char StipulationType_YEAR_OR_YEAR_MONTH_OF_ISSUE[] = "ISSUE";
  const char StipulationType_SUBSTITUTIONS_LEFT[] = "SUBSLEFT";
  const char StipulationType_NUMBER_OF_PIECES[] = "PIECES";
  const char StipulationType_INSURED[] = "INSURED";
  const char StipulationType_OF_MANUFACTURED_HOUSING_PREPAYMENT_CURVE[] = "MHP";
  const char StipulationType_THE_MINIMUM_RESIDUAL_OFFER_QUANTITY[] = "LEAVEQTY";
  const char StipulationType_BARGAIN_CONDITIONS[] = "BGNCON";
  const char StipulationType_POOLS_PER_TRADE[] = "PPT";
  const char StipulationType_WEIGHTED_AVERAGE_LOAN_AGE_VALUE_IN_MONTHS[] = "WALA";
  const char StipulationType_SINGLE_MONTHLY_MORTALITY[] = "SMM";
  const char StipulationType_INTEREST_OF_ROLLING_OR_CLOSING_TRADE[] = "REFINT";
  const char StipulationType_BROKERS_SALES_CREDIT[] = "BROKERCREDIT";
  const char StipulationType_ISSUE_SIZE_RANGE[] = "ISSUESIZE";
  const char StipulationType_BARGAIN_CONDITIONS_SEE[] = "BGNCON";
  const char StipulationType_PRODUCTION_YEAR[] = "PROD";
  const char PriceQuoteMethod_PERCENT_OF_PAR[] = "PCTPAR";
  const char PriceQuoteMethod_STANDARD_MONEY_PER_UNIT_OF_A_PHYSICAL[] = "STD";
  const char PriceQuoteMethod_INDEX[] = "INX";
  const char PriceQuoteMethod_INTEREST_RATE_INDEX[] = "INT";
  const int SessionRejectReason_NON_DATA_VALUE_INCLUDES_FIELD_DELIMITER = 17;
  const int SessionRejectReason_COMPID_PROBLEM = 9;
  const int SessionRejectReason_SIGNATURE_PROBLEM = 8;
  const int SessionRejectReason_TAG_NOT_DEFINED_FOR_THIS_MESSAGE_TYPE = 2;
  const int SessionRejectReason_XML_VALIDATION_ERROR = 12;
  const int SessionRejectReason_UNDEFINED_TAG = 3;
  const int SessionRejectReason_INCORRECT_DATA_FORMAT_FOR_VALUE = 6;
  const int SessionRejectReason_REPEATING_GROUP_FIELDS_OUT_OF_ORDER = 15;
  const int SessionRejectReason_REQUIRED_TAG_MISSING = 1;
  const int SessionRejectReason_OTHER = 99;
  const int SessionRejectReason_INCORRECT_NUMINGROUP_COUNT_FOR_REPEATING_GROUP = 16;
  const int SessionRejectReason_TAG_APPEARS_MORE_THAN_ONCE = 13;
  const int SessionRejectReason_TAG_SPECIFIED_OUT_OF_REQUIRED_ORDER = 14;
  const int SessionRejectReason_DECRYPTION_PROBLEM = 7;
  const int SessionRejectReason_INVALID_TAG_NUMBER = 0;
  const int SessionRejectReason_VALUE_IS_INCORRECT = 5;
  const int SessionRejectReason_TAG_SPECIFIED_WITHOUT_A_VALUE = 4;
  const int SessionRejectReason_INVALID_MSGTYPE = 11;
  const int SessionRejectReason_SENDINGTIME_ACCURACY_PROBLEM = 10;
  const int DeliveryType_TRI_PARTY = 2;
  const int DeliveryType_HOLD_IN_CUSTODY = 3;
  const int DeliveryType_FREE_DELIVER = 1;
  const int DeliveryType_VERSUS_PAYMENT_DELIVER = 0;
  const char Scope_LOCAL = '1';
  const char Scope_LOCAL_MARKET = '1';
  const char Scope_GLOBAL = '3';
  const char Scope_NATIONAL = '2';
  const char DeleteReason_CANCELLATION = '0';
  const char DeleteReason_CANCELATION = '0';
  const char DeleteReason_ERROR = '1';
  const char InViewOfCommon_NO = 'N';
  const char InViewOfCommon_YES = 'Y';
  const char NoSides_ONE_SIDE = '1';
  const char NoSides_BOTH_SIDES = '2';
  const char SecurityType_EURO_CERTIFICATE_OF_DEPOSIT[] = "EUCD";
  const char SecurityType_MUNICIPAL_BOND[] = "MUNI";
  const char SecurityType_MORTGAGE_INTEREST_ONLY[] = "MIO";
  const char SecurityType_MATURED[] = "MATURED";
  const char SecurityType_FUTURE[] = "FUT";
  const char SecurityType_TREASURY_BILL[] = "TB";
  const char SecurityType_BILL_OF_EXCHANGES[] = "BOX";
  const char SecurityType_TIME_DEPOSIT[] = "TD";
  const char SecurityType_MORTGAGE_IOETTE[] = "IET";
  const char SecurityType_REPURCHASE_AGREEMENT[] = "RP";
  const char SecurityType_SPECIAL_OBLIGATION[] = "SPCLO";
  const char SecurityType_COMMERCIAL_PAPER[] = "CP";
  const char SecurityType_CORPORATE_BOND[] = "CORP";
  const char SecurityType_CORP_MORTGAGE_BACKED_SECURITIES[] = "CMBS";
  const char SecurityType_OTHER_ANTICIPATION_NOTES_BAN_GAN_ETC[] = "AN";
  const char SecurityType_STRUCTURED_NOTES[] = "STRUCT";
  const char SecurityType_REPURCHASE[] = "REPO";
  const char SecurityType_CANADIAN_MORTGAGE_BONDS[] = "CMB";
  const char SecurityType_PRINCIPAL_STRIP_FROM_A_NON_CALLABLE_BOND_OR_NOTE[] = "TPRN";
  const char SecurityType_TREASURIES_PLUS_AGENCY_DEBENTURE[] = "GOVT";
  const char SecurityType_TAX_REVENUE_ANTICIPATION_NOTE[] = "TRAN";
  const char SecurityType_US_TREASURY_BILL[] = "USTB";
  const char SecurityType_PLAZOS_FIJOS[] = "PZFJ";
  const char SecurityType_CANADIAN_TREASURY_NOTES[] = "CAN";
  const char SecurityType_YANKEE_CORPORATE_BOND[] = "YANK";
  const char SecurityType_FEDERAL_AGENCY_DISCOUNT_NOTE[] = "FADN";
  const char SecurityType_BUY_SELLBACK[] = "BUYSELL";
  const char SecurityType_NO_ISITC_SECURITY_TYPE[] = "NONE";
  const char SecurityType_PROMISSORY_NOTE[] = "PN";
  const char SecurityType_PRIVATE_EXPORT_FUNDING[] = "PEF";
  const char SecurityType_CASH[] = "CASH";
  const char SecurityType_DEPOSIT_NOTES[] = "DN";
  const char SecurityType_FOREIGN_EXCHANGE_CONTRACT[] = "FOR";
  const char SecurityType_SECURITIES_PLEDGE[] = "SECPLEDGE";
  const char SecurityType_RETIRED[] = "RETIRED";
  const char SecurityType_OVERNIGHT[] = "ONITE";
  const char SecurityType_REVENUE_ANTICIPATION_NOTE[] = "RAN";
  const char SecurityType_REVERSE_REPURCHASE_AGREEMENT[] = "RVRP";
  const char SecurityType_COLLATERALIZED_MORTGAGE_OBLIGATION[] = "CMO";
  const char SecurityType_WARRANT[] = "WAR";
  const char SecurityType_LIQUIDITY_NOTE[] = "LQN";
  const char SecurityType_MANDATORY_TENDER[] = "MT";
  const char SecurityType_COMMON_STOCK[] = "CS";
  const char SecurityType_EURO_CORPORATE_BOND[] = "EUCORP";
  const char SecurityType_CALL_LOANS[] = "CL";
  const char SecurityType_OPTIONS_ON_PHYSICAL[] = "OOP";
  const char SecurityType_REVOLVER_LOAN[] = "RVLV";
  const char SecurityType_OPTION[] = "OPT";
  const char SecurityType_FEDERAL_AGENCY_COUPON[] = "FAC";
  const char SecurityType_TAX_ALLOCATION[] = "TAXA";
  const char SecurityType_MISCELLANEOUS_PASS_THROUGH[] = "MPT";
  const char SecurityType_VARIABLE_RATE_DEMAND_NOTE[] = "VRDN";
  const char SecurityType_MORTGAGE_PRINCIPAL_ONLY[] = "MPO";
  const char SecurityType_TAXABLE_MUNICIPAL_CP[] = "TMCP";
  const char SecurityType_INTEREST_RATE_SWAP[] = "IRS";
  const char SecurityType_BANK_NOTES[] = "BN";
  const char SecurityType_ASSET_BACKED_SECURITIES[] = "ABS";
  const char SecurityType_MULTILEG_INSTRUMENT[] = "MLEG";
  const char SecurityType_INTEREST_STRIP_FROM_ANY_BOND_OR_NOTE[] = "TINT";
  const char SecurityType_CREDIT_DEFAULT_SWAP[] = "CDS";
  const char SecurityType_FEDERAL_NATIONAL_MORTGAGE_ASSOCIATION[] = "FN";
  const char SecurityType_USD_SUPRANATIONAL_COUPONS[] = "SUPRA";
  const char SecurityType_REVOLVER_TERM_LOAN[] = "RVLVTRM";
  const char SecurityType_MORTGAGE_PRINCIPLE_ONLY[] = "MPO";
  const char SecurityType_REPLACED[] = "REPLACD";
  const char SecurityType_US_TREASURY_BILL_TBILL[] = "TBILL";
  const char SecurityType_CERTIFICATE_OF_DEPOSIT[] = "CD";
  const char SecurityType_SPECIAL_ASSESSMENT[] = "SPCLA";
  const char SecurityType_SHORT_TERM_LOAN_NOTE[] = "STN";
  const char SecurityType_LETTER_OF_CREDIT[] = "LOFC";
  const char SecurityType_OPTIONS_ON_COMBO[] = "OOC";
  const char SecurityType_SPECIAL_TAX[] = "SPCLT";
  const char SecurityType_PREFERRED_STOCK[] = "PS";
  const char SecurityType_US_TREASURY_NOTE_TNOTE[] = "TNOTE";
  const char SecurityType_AGENCY_POOLS[] = "POOL";
  const char SecurityType_MEDIUM_TERM_NOTES[] = "MTN";
  const char SecurityType_CANADIAN_PROVINCIAL_BONDS[] = "PROV";
  const char SecurityType_IOETTE_MORTGAGE[] = "IET";
  const char SecurityType_STUDENT_LOAN_MARKETING_ASSOCIATION[] = "SL";
  const char SecurityType_SECURITIES_LOAN[] = "SECLOAN";
  const char SecurityType_EURO_CORPORATE_FLOATING_RATE_NOTES[] = "EUFRN";
  const char SecurityType_CERTIFICATE_OF_PARTICIPATION[] = "COFP";
  const char SecurityType_FEDERAL_HOME_LOAN[] = "FHL";
  const char SecurityType_US_CORPORATE_FLOATING_RATE_NOTES[] = "FRN";
  const char SecurityType_YANKEE_CERTIFICATE_OF_DEPOSIT[] = "YCD";
  const char SecurityType_MULTI_LEG_INSTRUMENT[] = "MLEG";
  const char SecurityType_WITHDRAWN[] = "WITHDRN";
  const char SecurityType_MISCELLANEOUS_PASS_THRU[] = "MPT";
  const char SecurityType_CANADIAN_MONEY_MARKETS[] = "CAMM";
  const char SecurityType_FORWARD[] = "FORWARD";
  const char SecurityType_EURO_SUPRANATIONAL_COUPONS[] = "EUSUPRA";
  const char SecurityType_PRINCIPAL_STRIP_OF_A_CALLABLE_BOND_OR_NOTE[] = "TCAL";
  const char SecurityType_EURO_SOVEREIGNS[] = "EUSOV";
  const char SecurityType_CERTIFICATE_OF_OBLIGATION[] = "COFO";
  const char SecurityType_BANK_DEPOSITORY_NOTE[] = "BDN";
  const char SecurityType_US_TREASURY_BILL_USTB[] = "USTB";
  const char SecurityType_FX_SWAP[] = "FXSWAP";
  const char SecurityType_WILDCARD_ENTRY[] = "WLD";
  const char SecurityType_SWING_LINE_FACILITY[] = "SWING";
  const char SecurityType_FEDERAL_HOUSING_AUTHORITY[] = "FHA";
  const char SecurityType_CORPORATE_PRIVATE_PLACEMENT[] = "CPP";
  const char SecurityType_GENERAL_OBLIGATION_BONDS[] = "GO";
  const char SecurityType_WILDCARD_ENTRY_FOR_USE_ON_SECURITY_DEFINITION_REQUEST[] = "?";
  const char SecurityType_INDEXED_LINKED[] = "XLINKD";
  const char SecurityType_TO_BE_ANNOUNCED[] = "TBA";
  const char SecurityType_TREASURY_INFLATION_PROTECTED_SECURITIES[] = "TIPS";
  const char SecurityType_NON_DELIVERABLE_FORWARD[] = "FXNDF";
  const char SecurityType_OPTIONS_ON_FUTURES[] = "OOF";
  const char SecurityType_TAX_ANTICIPATION_NOTE[] = "TAN";
  const char SecurityType_TERM_LOAN[] = "TERM";
  const char SecurityType_AMENDED_RESTATED[] = "AMENDED";
  const char SecurityType_FX_FORWARD[] = "FXFWD";
  const char SecurityType_CANADIAN_TREASURY_BILLS[] = "CTB";
  const char SecurityType_DUAL_CURRENCY[] = "DUAL";
  const char SecurityType_MORTGAGE_PRIVATE_PLACEMENT[] = "MPP";
  const char SecurityType_EURO_COMMERCIAL_PAPER[] = "EUCP";
  const char SecurityType_GOVERNMENT_NATIONAL_MORTGAGE_ASSOCIATION[] = "GN";
  const char SecurityType_US_TREASURY_BOND[] = "TBOND";
  const char SecurityType_SECURED_LIQUIDITY_NOTE[] = "SLQN";
  const char SecurityType_MORTGAGE_BACKED_SECURITIES[] = "MBS";
  const char SecurityType_US_TREASURY_NOTE_UST[] = "UST";
  const char SecurityType_DEBTOR_IN_POSSESSION[] = "DINP";
  const char SecurityType_TERM_LIQUIDITY_NOTE[] = "TLQN";
  const char SecurityType_US_TREASURY_NOTE_BOND[] = "UST";
  const char SecurityType_REVENUE_BONDS[] = "REV";
  const char SecurityType_BRIDGE_LOAN[] = "BRIDGE";
  const char SecurityType_CATS_TIGERS_LIONS[] = "ZOO";
  const char SecurityType_BRADY_BOND[] = "BRADY";
  const char SecurityType_NO_SECURITY_TYPE[] = "NONE";
  const char SecurityType_TAX_EXEMPT_COMMERCIAL_PAPER[] = "TECP";
  const char SecurityType_COLLATERALIZE_MORTGAGE_OBLIGATION[] = "CMO";
  const char SecurityType_DEFAULTED[] = "DEFLTED";
  const char SecurityType_OTHER_ANTICIPATION_NOTES[] = "AN";
  const char SecurityType_MUTUAL_FUND[] = "MF";
  const char SecurityType_EXTENDED_COMM_NOTE[] = "XCN";
  const char SecurityType_CONVERTIBLE_BOND[] = "CB";
  const char SecurityType_PFANDBRIEFE[] = "PFAND";
  const char SecurityType_FX_SPOT[] = "FXSPOT";
  const char SecurityType_BANKERS_ACCEPTANCE[] = "BA";
  const char RoundingDirection_ROUND_DOWN = '1';
  const char RoundingDirection_ROUND_TO_NEAREST = '0';
  const char RoundingDirection_ROUND_UP = '2';
  const char TimeUnit_MINUTE[] = "Min";
  const char TimeUnit_WEEK[] = "Wk";
  const char TimeUnit_SECOND[] = "S";
  const char TimeUnit_MONTH[] = "Mo";
  const char TimeUnit_HOUR[] = "H";
  const char TimeUnit_DAY[] = "D";
  const char TimeUnit_YEAR[] = "Yr";
  const int LegSwapType_MODIFIED_DURATION = 2;
  const int LegSwapType_RISK = 4;
  const int LegSwapType_PAR_FOR_PAR = 1;
  const int LegSwapType_PROCEEDS = 5;
  const char IOITransType_REPLACE = 'R';
  const char IOITransType_NEW = 'N';
  const char IOITransType_CANCEL = 'C';
  const int PosReqResult_VALID_REQUEST = 0;
  const int PosReqResult_NOT_AUTHORIZED_TO_REQUEST_POSITIONS = 3;
  const int PosReqResult_NO_POSITIONS_FOUND_THAT_MATCH_CRITERIA = 2;
  const int PosReqResult_INVALID_OR_UNSUPPORTED_REQUEST = 1;
  const int PosReqResult_OTHER = 99;
  const int PosReqResult_REQUEST_FOR_POSITION_NOT_SUPPORTED = 4;
  const char SettlInstMode_DEFAULT = '0';
  const char SettlInstMode_REQUEST_REJECT = '5';
  const char SettlInstMode_SPECIFIC_ALLOCATION_ACCOUNT_OVERRIDING = '2';
  const char SettlInstMode_SPECIFIC_ALLOCATION_ACCOUNT_STANDING = '3';
  const char SettlInstMode_SPECIFIC_ORDER_FOR_A_SINGLE_ACCOUNT = '4';
  const char SettlInstMode_STANDING_INSTRUCTIONS_PROVIDED = '1';
  const char PreviouslyReported_NO = 'N';
  const char PreviouslyReported_YES = 'Y';
  const char CustOrderHandlingInst_PEGGED[] = "PEG";
  const char CustOrderHandlingInst_MARKET_ON_OPEN[] = "MOO";
  const char CustOrderHandlingInst_SCALE[] = "SCL";
  const char CustOrderHandlingInst_FILL_OR_KILL[] = "FOK";
  const char CustOrderHandlingInst_ALL_OR_NONE[] = "AON";
  const char CustOrderHandlingInst_NOT_HELD[] = "NH";
  const char CustOrderHandlingInst_DIRECTED_ORDER[] = "DIR";
  const char CustOrderHandlingInst_STOP_STOCK_TRANSACTION[] = "S.W";
  const char CustOrderHandlingInst_OVER_THE_DAY[] = "OVD";
  const char CustOrderHandlingInst_ADD_ON_ORDER[] = "ADD";
  const char CustOrderHandlingInst_MARKET_AT_CLOSE[] = "MAC";
  const char CustOrderHandlingInst_LIMIT_ON_OPEN[] = "LOO";
  const char CustOrderHandlingInst_CASH_NOT_HELD[] = "CNH";
  const char CustOrderHandlingInst_MARKET_ON_CLOSE[] = "MOC";
  const char CustOrderHandlingInst_TIME_ORDER[] = "TMO";
  const char CustOrderHandlingInst_LIMIT_ON_CLOSE[] = "LOC";
  const char CustOrderHandlingInst_IMMEDIATE_OR_CANCEL[] = "IOC";
  const char CustOrderHandlingInst_TRAILING_STOP[] = "TS";
  const char CustOrderHandlingInst_WORK[] = "WRK";
  const char CustOrderHandlingInst_RESERVE_SIZE_ORDER[] = "RSV";
  const char CustOrderHandlingInst_MINIMUM_QUANTITY[] = "MQT";
  const char CustOrderHandlingInst_MARKET_AT_OPEN[] = "MAO";
  const char CustOrderHandlingInst_IMBALANCE_ONLY[] = "IO";
  const char CustOrderHandlingInst_EXCHANGE_FOR_PHYSICAL_TRANSACTION[] = "E.W";
  const char SecurityStatus_INACTIVE[] = "2";
  const char SecurityStatus_ACTIVE[] = "1";
  const char ProcessCode_SOFT_DOLLAR = '1';
  const char ProcessCode_PLAN_SPONSOR = '6';
  const char ProcessCode_STEP_IN = '2';
  const char ProcessCode_REGULAR = '0';
  const char ProcessCode_SOFT_DOLLAR_STEP_OUT = '5';
  const char ProcessCode_STEP_OUT = '3';
  const char ProcessCode_SOFT_DOLLAR_STEP_IN = '4';
  const char ExecInst_TRY_TO_STOP = 'Y';
  const char ExecInst_PEG_TO_LIMIT_PRICE = 'd';
  const char ExecInst_EXECUTE_AS_DURATION_NEUTRAL = 's';
  const char ExecInst_REINSTATE_ON_TRADING_HALT = 'J';
  const char ExecInst_NO_CROSS = 'A';
  const char ExecInst_PEGVWAP = 'W';
  const char ExecInst_STRICT_SCALE = '7';
  const char ExecInst_AON = 'G';
  const char ExecInst_MARKPEG = 'P';
  const char ExecInst_MIDPRCPEG = 'M';
  const char ExecInst_OKCROSS = 'B';
  const char ExecInst_TRAILING_STOP_PEG = 'a';
  const char ExecInst_EXECUTE_AS_FX_NEUTRAL = 't';
  const char ExecInst_CUSTDISPINST = 'U';
  const char ExecInst_OK_TO_CROSS = 'B';
  const char ExecInst_SUSPEND_ON_SYSTEM_FAILURE = 'l';
  const char ExecInst_GO_ALONG = '3';
  const char ExecInst_INSTITONLY = 'I';
  const char ExecInst_DO_NOT_INCREASE = 'E';
  const char ExecInst_SUSPEND = 'S';
  const char ExecInst_TRYTOSTOP = 'Y';
  const char ExecInst_FIXED_PEG_TO_LOCAL_BEST_BID_OR_OFFER_AT_TIME_OF_ORDER = 'T';
  const char ExecInst_REINSTATE_ON_SYSTEM_FAILURE = 'H';
  const char ExecInst_SUSPEND_ON_TRADING_HALT = 'm';
  const char ExecInst_INTERMARKET_SWEEP = 'f';
  const char ExecInst_BEST_EXECUTION = 'k';
  const char ExecInst_PARTICIPATE_DONT_INITIATE = '6';
  const char ExecInst_LASTPEG = 'L';
  const char ExecInst_PEG_TO_VWAP = 'W';
  const char ExecInst_PRIMARY_PEG = 'R';
  const char ExecInst_NONNEGO = 'N';
  const char ExecInst_IGNORE_PRICE_VALIDITY_CHECKS = 'c';
  const char ExecInst_STAY_ON_BID_SIDE = '9';
  const char ExecInst_NOTHELD = '1';
  const char ExecInst_STRICTSCALE = '7';
  const char ExecInst_REINSTATE_ON_CONNECTION_LOSS = 'n';
  const char ExecInst_DNI = 'E';
  const char ExecInst_TRYTOSCALE = '8';
  const char ExecInst_PERCENT_OF_VOLUME = 'D';
  const char ExecInst_GOALONG = '3';
  const char ExecInst_WORK = '2';
  const char ExecInst_HELD = '5';
  const char ExecInst_NOCROSS = 'A';
  const char ExecInst_RELEASE_FROM_SUSPENSION = 'q';
  const char ExecInst_STRICT_LIMIT = 'b';
  const char ExecInst_OPENPEG = 'O';
  const char ExecInst_STAY_ON_BIDSIDE = '9';
  const char ExecInst_STAY_ON_OFFERSIDE = '0';
  const char ExecInst_OVER_THE_DAY = '4';
  const char ExecInst_RESTATEONTRADINGHALT = 'J';
  const char ExecInst_INSTITUTIONS_ONLY = 'I';
  const char ExecInst_NOT_HELD = '1';
  const char ExecInst_CANCELONTRADINGHALT = 'K';
  const char ExecInst_CANCELONSYSFAIL = 'Q';
  const char ExecInst_MARKET_PEG = 'P';
  const char ExecInst_TRADEALONG = 'X';
  const char ExecInst_CALL_FIRST = 'C';
  const char ExecInst_CANCEL_ON_SYSTEM_FAILURE = 'Q';
  const char ExecInst_EXECUTE_AS_DELTA_NEUTRAL_USING_VOLATILITY_PROVIDED = 'r';
  const char ExecInst_SINGLE_EXECUTION_REQUESTED_FOR_BLOCK_TRADE = 'j';
  const char ExecInst_NON_NEGOTIABLE = 'N';
  const char ExecInst_TRY_TO_SCALE = '8';
  const char ExecInst_EXTERNAL_ROUTING_ALLOWED = 'g';
  const char ExecInst_STAY_ON_OFFER_SIDE = '0';
  const char ExecInst_CUSTOMER_DISPLAY_INSTRUCTION = 'U';
  const char ExecInst_WORK_TO_TARGET_STRATEGY = 'e';
  const char ExecInst_OVERDAY = '4';
  const char ExecInst_LAST_PEG = 'L';
  const char ExecInst_CALLFIRST = 'C';
  const char ExecInst_REINSTATE_ON_SYSTEM_FAILUE = 'H';
  const char ExecInst_DO_NOT_REDUCE = 'F';
  const char ExecInst_MID_PRICE_PEG = 'M';
  const char ExecInst_ALL_OR_NONE = 'G';
  const char ExecInst_OPENING_PEG = 'O';
  const char ExecInst_PERCVOL = 'D';
  const char ExecInst_SUSPEND_ON_CONNECTION_LOSS = 'p';
  const char ExecInst_CANCEL_ON_CONNECTION_LOSS = 'o';
  const char ExecInst_EXTERNAL_ROUTING_NOT_ALLOWED = 'h';
  const char ExecInst_CANCEL_IF_NOT_BEST = 'Z';
  const char ExecInst_PARTNOTINIT = '6';
  const char ExecInst_NETTING = 'V';
  const char ExecInst_IMBALANCE_ONLY = 'i';
  const char ExecInst_DNR = 'F';
  const char ExecInst_STAYOFFER = '0';
  const char ExecInst_STAYBID = '9';
  const char ExecInst_TRADE_ALONG = 'X';
  const char ExecInst_CANCEL_ON_TRADING_HALT = 'K';
  const char ExecInst_RESTATEONSYSFAIL = 'H';
  const char ExecInst_PRIMPEG = 'R';
  const char ExecType_REPLACE = '5';
  const char ExecType_NEW = '0';
  const char ExecType_CALCULATED = 'B';
  const char ExecType_PENDING_CANCEL = '6';
  const char ExecType_TRADE_IN_A_CLEARING_HOLD = 'J';
  const char ExecType_TRADE_HAS_BEEN_RELEASED_TO_CLEARING = 'K';
  const char ExecType_ORDER_STATUS = 'I';
  const char ExecType_PENDING_CANCEL_REPLACE = '6';
  const char ExecType_PARTIAL_FILL = '1';
  const char ExecType_PENDING_NEW = 'A';
  const char ExecType_STOPPED = '7';
  const char ExecType_CANCELED = '4';
  const char ExecType_PENDING_REPLACE = 'E';
  const char ExecType_TRADE = 'F';
  const char ExecType_TRADE_CORRECT = 'G';
  const char ExecType_SUSPENDED = '9';
  const char ExecType_FILL = '2';
  const char ExecType_RESTATED = 'D';
  const char ExecType_REJECTED = '8';
  const char ExecType_REPLACED = '5';
  const char ExecType_EXPIRED = 'C';
  const char ExecType_DONE_FOR_DAY = '3';
  const char ExecType_TRIGGERED_OR_ACTIVATED_BY_SYSTEM = 'L';
  const char ExecType_TRADE_CANCEL = 'H';
  const char ExecType_CANCELLED = '4';
  const int MultilegModel_USER_DEFINED_MULTLEG_SECURITY = 1;
  const int MultilegModel_PREDEFINED_MULTILEG_SECURITY = 0;
  const int MultilegModel_USER_DEFINED_NON_SECURITIZED_MULTILEG = 2;
  const int EventType_SWAP_NEXT_START_DATE = 11;
  const int EventType_LAST_ELIGIBLE_TRADE_DATE = 7;
  const int EventType_FIRST_DELIVERY_DATE = 13;
  const int EventType_TENDER = 3;
  const int EventType_INITIAL_INVENTORY_DUE_DATE = 15;
  const int EventType_FIRST_INTENT_DATE = 17;
  const int EventType_ACTIVATION = 5;
  const int EventType_PUT = 1;
  const int EventType_SWAP_START_DATE = 8;
  const int EventType_SWAP_NEXT_ROLL_DATE = 12;
  const int EventType_LAST_DELIVERY_DATE = 14;
  const int EventType_POSITION_REMOVAL_DATE = 19;
  const int EventType_SWAP_ROLL_DATE = 10;
  const int EventType_FINAL_INVENTORY_DUE_DATE = 16;
  const int EventType_OTHER = 99;
  const int EventType_INACTIVIATION = 6;
  const int EventType_SWAP_END_DATE = 9;
  const int EventType_LAST_INTENT_DATE = 18;
  const int EventType_SINKING_FUND_CALL = 4;
  const int EventType_CALL = 2;
  const int TradeAllocIndicator_ALLOCATION_REQUIRED = 1;
  const int TradeAllocIndicator_ALLOCATION_TO_CLAIM_ACCOUNT = 5;
  const int TradeAllocIndicator_ALLOCATION_FROM_EXECUTOR = 4;
  const int TradeAllocIndicator_USE_ALLOCATION_PROVIDED_WITH_THE_TRADE = 2;
  const int TradeAllocIndicator_ALLOCATION_GIVE_UP_EXECUTOR = 3;
  const int TradeAllocIndicator_ALLOCATION_NOT_REQUIRED = 0;
  const int UserStatus_NOT_LOGGED_IN = 2;
  const int UserStatus_PASSWORD_INCORRECT = 4;
  const int UserStatus_LOGGED_IN = 1;
  const int UserStatus_FORCED_USER_LOGOUT_BY_EXCHANGE = 7;
  const int UserStatus_USER_NOT_RECOGNISED = 3;
  const int UserStatus_OTHER = 6;
  const int UserStatus_PASSWORD_CHANGED = 5;
  const int UserStatus_SESSION_SHUTDOWN_WARNING = 8;
  const int OrderDelayUnit_WEEKS = 13;
  const int OrderDelayUnit_TENTHS_OF_A_SECOND = 1;
  const int OrderDelayUnit_SECONDS = 0;
  const int OrderDelayUnit_MONTHS = 14;
  const int OrderDelayUnit_YEARS = 15;
  const int OrderDelayUnit_NANOSECONDS = 5;
  const int OrderDelayUnit_HUNDREDTHS_OF_A_SECOND = 2;
  const int OrderDelayUnit_HOURS = 11;
  const int OrderDelayUnit_MICROSECONDS = 4;
  const int OrderDelayUnit_MINUTES = 10;
  const int OrderDelayUnit_MILLISECONDS = 3;
  const int OrderDelayUnit_DAYS = 12;
  const char TradedFlatSwitch_NO = 'N';
  const char TradedFlatSwitch_YES = 'Y';
  const int TrdRptStatus_ACCEPTED_WITH_ERRORS = 3;
  const int TrdRptStatus_REJECTED = 1;
  const int TrdRptStatus_ACCEPTED = 0;
  const int QuoteStatus_PENDING = 10;
  const int QuoteStatus_PENDING_END_TRADE = 19;
  const int QuoteStatus_CROSS_MARKET_WARNING = 13;
  const int QuoteStatus_CANCELED = 17;
  const int QuoteStatus_LOCKED_MARKET_WARNING = 12;
  const int QuoteStatus_CANCELED_FOR_UNDERLYING = 3;
  const int QuoteStatus_UNSOLICITED_QUOTE_REPLENISHMENT = 18;
  const int QuoteStatus_TOO_LATE_TO_END = 20;
  const int QuoteStatus_CANCELED_DUE_TO_LOCK_MARKET = 14;
  const int QuoteStatus_CANCELED_DUE_TO_CROSS_MARKET = 15;
  const int QuoteStatus_CANCELED_FOR_SECURITY_TYPE = 2;
  const int QuoteStatus_CANCELED_ALL = 4;
  const int QuoteStatus_PASS = 11;
  const int QuoteStatus_REJECTED = 5;
  const int QuoteStatus_QUERY = 8;
  const int QuoteStatus_ACCEPTED = 0;
  const int QuoteStatus_EXPIRED = 7;
  const int QuoteStatus_CANCELED_FOR_SYMBOL = 1;
  const int QuoteStatus_REMOVED_FROM_MARKET = 6;
  const int QuoteStatus_ACTIVE = 16;
  const int QuoteStatus_CANCEL_FOR_SYMBOL = 1;
  const int QuoteStatus_QUOTE_NOT_FOUND = 9;
  const char SolicitedFlag_NO = 'N';
  const char SolicitedFlag_YES = 'Y';
  const int ShortSaleReason_DEALER_SOLD_SHORT = 0;
  const int ShortSaleReason_QSR_OR_AGU_CONTRA_SIDE_SOLD_SHORT_EXEMPT = 5;
  const int ShortSaleReason_SELLING_CUSTOMER_SOLD_SHORT_EXEMPT = 3;
  const int ShortSaleReason_SELLING_CUSTOMER_SOLD_SHORT = 2;
  const int ShortSaleReason_QUALIFED_SERVICE_REPRESENTATIVE = 4;
  const int ShortSaleReason_DEALER_SOLD_SHORT_EXEMPT = 1;
  const int ShortSaleReason_QUALIFIED_SERVICE_REPRESENTATIVE = 4;
  const int PegRoundDirection_MORE_AGGRESSIVE_ON_A_BUY_ORDER_ROUND_THE_PRICE_UP_ROUND_UP_TO_THE_NEAREST_TICK_ON_A_SELL_ROUND_DOWN_TO_THE_NEAREST_TICK = 1;
  const int PegRoundDirection_MORE_AGGRESSIVE = 1;
  const int PegRoundDirection_MORE_PASSIVE = 2;
  const int PegRoundDirection_MORE_PASSIVE_ON_A_BUY_ORDER_ROUND_DOWN_TO_NEAREST_TICK_ON_A_SELL_ORDER_ROUND_UP_TO_NEAREST_TICK = 2;
  const int ModelType_PROPRIETARY = 1;
  const int ModelType_UTILITY_PROVIDED_STANDARD_MODEL = 0;
  const char FuturesValuationMethod_FUTURES_STYLE_WITH_AN_ATTACHED_CASH_ADJUSTMENT[] = "FUTDA";
  const char FuturesValuationMethod_PREMIUM_STYLE[] = "EQTY";
  const char FuturesValuationMethod_FUTURES_STYLE_MARK_TO_MARKET[] = "FUT";
  const char SettlMethod_CASH_SETTLEMENT_REQUIRED = 'C';
  const char SettlMethod_PHYSICAL_SETTLEMENT_REQUIRED = 'P';
  const int ConfirmStatus_CONFIRMED = 4;
  const int ConfirmStatus_MISSING_SETTLEMENT_INSTRUCTIONS = 3;
  const int ConfirmStatus_REQUEST_REJECTED = 5;
  const int ConfirmStatus_MISMATCHED_ACCOUNT = 2;
  const int ConfirmStatus_RECEIVED = 1;
  const char LocateReqd_NO = 'N';
  const char LocateReqd_YES = 'Y';
  const int Adjustment_CANCEL = 1;
  const int Adjustment_CORRECTION = 3;
  const int Adjustment_ERROR = 2;
  const int StreamAsgnType_ASSIGNMENT = 1;
  const int StreamAsgnType_TERMINATE_UNASSIGN = 3;
  const int StreamAsgnType_REJECTED = 2;
  const char LastRptRequested_NO = 'N';
  const char LastRptRequested_YES = 'Y';
  const char SettlSessID_END_OF_DAY[] = "EOD";
  const char SettlSessID_ELECTRONIC_TRADING_HOURS[] = "ETH";
  const char SettlSessID_REGULAR_TRADING_HOURS[] = "RTH";
  const char SettlSessID_INTRADAY[] = "ITD";
  const int TradeReportType_LOCKED_IN_TRADE_BREAK = 7;
  const int TradeReportType_NO_WAS = 5;
  const int TradeReportType_ADDENDUM = 4;
  const int TradeReportType_7 = 7;
  const int TradeReportType_PENDED = 10;
  const int TradeReportType_DEFAULTED = 8;
  const int TradeReportType_DECLINE = 3;
  const int TradeReportType_ALLEGED_NEW = 11;
  const int TradeReportType_ALLEGED_TRADE_REPORT_CANCEL = 14;
  const int TradeReportType_ALLEGED_15 = 15;
  const int TradeReportType_ALLEGED_ADDENDUM = 12;
  const int TradeReportType_ALLEGED = 1;
  const int TradeReportType_SUBMIT = 0;
  const int TradeReportType_ALLEGED_1 = 1;
  const int TradeReportType_INVALID_CMTA = 9;
  const int TradeReportType_ALLEGED_NO_WAS = 13;
  const int TradeReportType_TRADE_REPORT_CANCEL = 6;
  const int TradeReportType_ACCEPT = 2;
  const int ExerciseStyle_AMERICAN = 1;
  const int ExerciseStyle_EUROPEAN = 0;
  const int ExerciseStyle_BERMUDA = 2;
  const char HaltReasonChar_ADDITIONAL_INFORMATION = 'M';
  const char HaltReasonChar_NEW_PENDING = 'P';
  const char HaltReasonChar_NEWS_PENDING = 'P';
  const char HaltReasonChar_ORDER_INFLUX = 'E';
  const char HaltReasonChar_NEWS_DISSEMINATION = 'D';
  const char HaltReasonChar_EQUIPMENT_CHANGEOVER = 'X';
  const char HaltReasonChar_ORDER_IMBALANCE = 'I';
  const char ExDestination_POSIT = '4';
  const char ExDestination_NONE = '0';
  const int AllocReportType_SELLSIDE_CALCULATED_WITHOUT_PRELIMINARY = 4;
  const int AllocReportType_WAREHOUSE_RECAP = 5;
  const int AllocReportType_REJECT = 10;
  const int AllocReportType_ACCEPT_PENDING = 11;
  const int AllocReportType_COMPLETE = 12;
  const int AllocReportType_REQUEST_TO_INTERMEDIARY = 8;
  const int AllocReportType_PRELIMINARY_REQUEST_TO_INTERMEDIARY = 2;
  const int AllocReportType_SELLSIDE_CALCULATED_USING_PRELIMINARY = 3;
  const int AllocReportType_REVERSE_PENDING = 14;
  const int AllocReportType_ACCEPT = 9;
  const int AllocType_SELLSIDE_CALCULATED_WITHOUT_PRELIMINARY = 4;
  const int AllocType_INCOMPLETE_GROUP = 12;
  const int AllocType_REVERSAL_PENDING = 14;
  const int AllocType_CALCULATED = 1;
  const int AllocType_REJECT = 10;
  const int AllocType_PRELIMINARY = 2;
  const int AllocType_ACCEPT_PENDING = 11;
  const int AllocType_BUYSIDE_CALCULATED = 1;
  const int AllocType_REQUEST_TO_INTERMEDIARY = 8;
  const int AllocType_BUYSIDE_READY_TO_BOOK_5 = 5;
  const int AllocType_BUYSIDE_READY_TO_BOOK_6 = 6;
  const int AllocType_COMPLETE_GROUP = 13;
  const int AllocType_SELLSIDE_CALCULATED_USING_PRELIMINARY = 3;
  const int AllocType_BUYSIDE_READY_TO_BOOK = 6;
  const int AllocType_READY_TO_BOOK = 5;
  const int AllocType_WAREHOUSE_INSTRUCTION = 7;
  const int AllocType_BUYSIDE_PRELIMINARY = 2;
  const int AllocType_ACCEPT = 9;
  const int QuoteRequestRejectReason_INSUFFICIENT_CREDIT = 11;
  const int QuoteRequestRejectReason_NOT_AUTHORIZED_TO_REQUEST_QUOTE = 6;
  const int QuoteRequestRejectReason_INVALID_PRICE = 5;
  const int QuoteRequestRejectReason_TOO_LATE_TO_ENTER = 4;
  const int QuoteRequestRejectReason_NO_MATCH_FOR_INQUIRY = 7;
  const int QuoteRequestRejectReason_EXCHANGE = 2;
  const int QuoteRequestRejectReason_NO_MARKET_FOR_INSTRUMENT = 8;
  const int QuoteRequestRejectReason_UNKNOWN_SYMBOL = 1;
  const int QuoteRequestRejectReason_OTHER = 99;
  const int QuoteRequestRejectReason_PASS = 10;
  const int QuoteRequestRejectReason_NO_INVENTORY = 9;
  const int QuoteRequestRejectReason_QUOTE_REQUEST_EXCEEDS_LIMIT = 3;
  const int LiquidityIndType_20_DAY_MOVING_AVERAGE = 2;
  const int LiquidityIndType_5_DAY_MOVING_AVERAGE = 1;
  const int LiquidityIndType_5DAY_MOVING_AVERAGE = 1;
  const int LiquidityIndType_NORMAL_MARKET_SIZE = 3;
  const int LiquidityIndType_OTHER = 4;
  const int StatusValue_IN_PROCESS = 4;
  const int StatusValue_NOT_CONNECTED_DOWN_EXPECTED_DOWN = 3;
  const int StatusValue_NOT_CONNECTED_2 = 2;
  const int StatusValue_NOT_CONNECTED_DOWN_EXPECTED_UP = 2;
  const int StatusValue_CONNECTED = 1;
  const int StatusValue_NOT_CONNECTED_3 = 3;
  const char PosType_EXCHANGE_FOR_PHYSICAL_QTY[] = "EP";
  const char PosType_TRANSFER_TRADE_QTY[] = "TRF";
  const char PosType_INTER_SPREAD_QTY[] = "IES";
  const char PosType_INTRA_SPREAD_QTY[] = "IAS";
  const char PosType_START_OF_DAY_QTY[] = "SOD";
  const char PosType_DELIVERY_QTY[] = "DLV";
  const char PosType_PIT_TRADE_QTY[] = "PIT";
  const char PosType_TRANSACTION_FROM_ASSIGNMENT[] = "TA";
  const char PosType_TRANSACTION_FROM_EXERCISE[] = "TX";
  const char PosType_OPTION_ASSIGNMENT[] = "AS";
  const char PosType_AS_OF_TRADE_QTY[] = "ASF";
  const char PosType_ELECTRONIC_TRADE_QTY[] = "ETR";
  const char PosType_SUCCESSION_EVENT_ADJUSTMENT[] = "SEA";
  const char PosType_OPTION_EXERCISE_QTY[] = "EX";
  const char PosType_TRANSACTION_QUANTITY[] = "TQ";
  const char PosType_NET_DELTA_QTY[] = "DLT";
  const char PosType_DELIVERY_NOTICE_QTY[] = "DN";
  const char PosType_TOTAL_TRANSACTION_QTY[] = "TOT";
  const char PosType_ADJUSTMENT_QTY[] = "PA";
  const char PosType_END_OF_DAY_QTY[] = "FIN";
  const char PosType_RECEIVE_QUANTITY[] = "RCV";
  const char PosType_CREDIT_EVENT_ADJUSTMENT[] = "CEA";
  const char PosType_PRIVATELY_NEGOTIATED_TRADE_QTY[] = "PNTN";
  const char PosType_CORPORATE_ACTION_ADJUSTMENT[] = "CAA";
  const char PosType_CROSS_MARGIN_QTY[] = "XM";
  const char PosType_INTEGRAL_SPLIT[] = "SPL";
  const char PosType_ALLOCATION_TRADE_QTY[] = "ALC";
  const int StreamAsgnAckType_ASSIGNMENT_REJECTED = 1;
  const int StreamAsgnAckType_ASSIGNMENT_ACCEPTED = 0;
  const int MiscFeeBasis_ABSOLUTE = 0;
  const int MiscFeeBasis_PERCENTAGE = 2;
  const int MiscFeeBasis_PER_UNIT = 1;
  const char OrdType_FOREX_MARKET = 'C';
  const char OrdType_FOREX_PREVIOUSLY_QUOTED = 'H';
  const char OrdType_PREVIOUS_FUND_VALUATION_POINT = 'L';
  const char OrdType_PEGGED = 'P';
  const char OrdType_LIMIT_WITH_OR_WITHOUT = '8';
  const char OrdType_STOP_LIMIT = '4';
  const char OrdType_FOREX_SWAP = 'G';
  const char OrdType_MARKET_WITH_LEFT_OVER_AS_LIMIT = 'K';
  const char OrdType_PREVIOUSLY_QUOTED = 'D';
  const char OrdType_COUNTER_ORDER_SELECTION = 'Q';
  const char OrdType_MARKET_IF_TOUCHED = 'J';
  const char OrdType_NEXT_FUND_VALUATION_POINT = 'M';
  const char OrdType_FOREX_C = 'C';
  const char OrdType_ON_CLOSE = 'A';
  const char OrdType_STOP = '3';
  const char OrdType_FOREX_LIMIT = 'F';
  const char OrdType_FOREX = 'G';
  const char OrdType_FUNARI = 'I';
  const char OrdType_FOREX_F = 'F';
  const char OrdType_PREVIOUSLY_INDICATED = 'E';
  const char OrdType_WITH_OR_WITHOUT = '6';
  const char OrdType_MARKET_ON_CLOSE = '5';
  const char OrdType_LIMIT = '2';
  const char OrdType_MARKET_WITH_LEFTOVER_AS_LIMIT = 'K';
  const char OrdType_FOREX_G = 'G';
  const char OrdType_LIMIT_ON_CLOSE = 'B';
  const char OrdType_FOREX_H = 'H';
  const char OrdType_ON_BASIS = '9';
  const char OrdType_LIMIT_OR_BETTER = '7';
  const char OrdType_MARKET = '1';
  const char MatchType_COMPARED_RECORDS_RESULTING_FROM_STAMPED_ADVISORIES_OR_SPECIALIST_ACCEPTS_PAIR_OFFS[] = "AQ";
  const char MatchType_SUMMARIZED_MATCH_USING_A4_EXACT_MATCH_CRITERIA_EXCEPT_QUANTITY_IS_SUMMARIZED[] = "S4";
  const char MatchType_NON_ACT[] = "MT";
  const char MatchType_EXACT_MATCH_ON_TRADE_DATE_STOCK_SYMBOL_QUANTITY_PRICE_TRADE_TYPE_AND[] = "A4";
  const char MatchType_SUMMARIZED_MATCH_USING_A1_TO_A5_EXACT_MATCH_CRITERIA_EXCEPT_QUANTITY_IS_SUMMARIZED_S3[] = "S3";
  const char MatchType_AUTO_MATCH[] = "4";
  const char MatchType_EXACT_MATCH_ON_TRADE_DATE_STOCK_SYMBOL_QUANTITY_PRICE_TRADE_TYPE_AND_SPECIAL_TRADE_INDICATOR_PLUS_TWO_BADGES[] = "A4";
  const char MatchType_SUMMARIZED_MATCH_USING_A2_EXACT_MATCH_CRITERIA_EXCEPT_QUANTITY_IS_SUMMARIZED[] = "S2";
  const char MatchType_SUMMARIZED_MATCH_USING_A1_TO_A5_EXACT_MATCH_CRITERIA_EXCEPT_QUANTITY_IS_SUMMARIZED_S4[] = "S4";
  const char MatchType_CALL_AUCTION[] = "7";
  const char MatchType_SUMMARIZED_MATCH_USING_A1_EXACT_MATCH_CRITERIA_EXCEPT_QUANTITY_IS_SUMMARIED[] = "S1";
  const char MatchType_SUMMARIZED_MATCH_USING_A3_EXACT_MATCH_CRITERIA_EXCEPT_QUANTITY_IS_SUMMARIZED[] = "S3";
  const char MatchType_COMPARED_RECORDS_RESULTING_FROM_STAMPED_ADVISORIES_OR_SPECIALIST[] = "AQ";
  const char MatchType_EXACT_MATCH_ON_TRADE_DATE_STOCK_SYMBOL_QUANTITY_PRICE_TRADE_TYPE_AND_SPECIAL_TRADE_INDICATOR_PLUS_FOUR_BADGES[] = "A2";
  const char MatchType_ACT_M2_MATCH[] = "M2";
  const char MatchType_SUMMARIZED_MATCH_USING_A1_TO_A5_EXACT_MATCH_CRITERIA_EXCEPT_QUANTITY_IS_SUMMARIZED_S5[] = "S5";
  const char MatchType_ONE_PARTY_TRADE_REPORT[] = "1";
  const char MatchType_ACT_M1_MATCH[] = "M1";
  const char MatchType_COUNTER_ORDER_SELECTION[] = "6";
  const char MatchType_ISSUING_BUY_BACK_AUCTION[] = "8";
  const char MatchType_TWO_PARTY_PRIVATELY_NEGOTIATED_TRADE_REPORT[] = "61";
  const char MatchType_CROSS_AUCTION_63[] = "63";
  const char MatchType_CROSS_AUCTION_5[] = "5";
  const char MatchType_CALL_AUCTION_7[] = "7";
  const char MatchType_COUNTER_ORDER_SELECTION_64[] = "64";
  const char MatchType_TWO_PARTY_TRADE_REPORT[] = "2";
  const char MatchType_SUMMARIZED_MATCH_MINUS_BADGES_AND_TIMES_ACT_M2_MATCH[] = "M2";
  const char MatchType_EXACT_MATCH_ON_TRADE_DATE_STOCK_SYMBOL_QUANTITY_PRICE_TRADE_TYPE_AND_SPECIAL_TRADE_INDICATOR_PLUS_FOUR_BADGES_AND_EXECUTION_TIME[] = "A1";
  const char MatchType_ACT_DEFAULT_TRADE[] = "M4";
  const char MatchType_ACT_ACCEPTED_TRADE[] = "M3";
  const char MatchType_COUNTER_ORDER_SELECTION_6[] = "6";
  const char MatchType_SUMMARIZED_MATCH_USING_A1_EXACT_MATCH_CRITERIA_EXCEPT_QUANTITY_IS_SUMMARIZED[] = "S1";
  const char MatchType_EXACT_MATCH_ON_TRADE_DATE_STOCK_SYMBOL_QUANTITY_PRICE_TRADE_TYPE_AND_SPECIAL_TRADE_INDICATOR_PLUS_TWO_BADGES_AND_EXECUTION_TIME[] = "A3";
  const char MatchType_EXACT_MATCH_ON_TRADE_DATE_STOCK_SYMBOL_QUANTITY_PRICE_TRADETYPE_AND_SPECIAL_TRADE_INDICATOR_PLUS_EXECUTION_TIME[] = "A5";
  const char MatchType_CROSS_AUCTION[] = "5";
  const char MatchType_CALL_AUCTION_65[] = "65";
  const char MatchType_CONFIRMED_TRADE_REPORT[] = "3";
  const char MatchType_SUMMARIZED_MATCH_USING_A5_EXACT_MATCH_CRITERIA_EXCEPT_QUANTITY_IS_SUMMARIZED[] = "S5";
  const char MatchType_ACT_M6_MATCH[] = "M6";
  const char MatchType_ONE_PARTY_PRIVATELY_NEGOTIATED_TRADE_REPORT[] = "60";
  const char MatchType_CONTINUOUS_AUTO_MATCH[] = "62";
  const char MatchType_OCS_LOCKED_IN_NON_ACT[] = "MT";
  const char MatchType_EXACT_MATCH_ON_TRADE_DATE_STOCK_SYMBOL_QUANTITY_PRICE_TRADE_TYPE_AND_SPECIAL_TRADE_INDICATOR_PLUS_EXECUTION_TIME[] = "A5";
  const char MatchType_SUMMARIZED_MATCH_USING_A1_TO_A5_EXACT_MATCH_CRITERIA_EXCEPT_QUANTITY_IS_SUMMARIZED_S1[] = "S1";
  const char MatchType_EXACT_MATCH_ON_TRADE_DATE_STOCK_SYMBOL_QUANTITY_PRICE_TRADE_TYPE_AND_SPECIAL_TRADE_INDICATOR_MINUS_BADGES_AND_TIMES_ACT_M1_MATCH[] = "M1";
  const char MatchType_SUMMARIZED_MATCH_USING_A1_TO_A5_EXACT_MATCH_CRITERIA_EXCEPT_QUANTITY_IS_SUMMARIZED_S2[] = "S2";
  const char MatchType_ACT_DEFAULT_AFTER_M2[] = "M5";
  const int OptPayoutType_BINARY = 3;
  const int OptPayoutType_VANILLA = 1;
  const int OptPayoutType_CAPPED = 2;
  const char MarketUpdateAction_DELETE = 'D';
  const char MarketUpdateAction_ADD = 'A';
  const char MarketUpdateAction_MODIFY = 'M';
  const int CollAsgnRejectReason_UNAUTHORIZED_TRANSACTION = 2;
  const int CollAsgnRejectReason_UNKNOWN_OR_INVALID_INSTRUMENT = 1;
  const int CollAsgnRejectReason_UNKNOWN_DEAL = 0;
  const int CollAsgnRejectReason_INVALID_TYPE_OF_COLLATERAL = 4;
  const int CollAsgnRejectReason_OTHER = 99;
  const int CollAsgnRejectReason_EXCESSIVE_SUBSTITUTION = 5;
  const int CollAsgnRejectReason_INSUFFICIENT_COLLATERAL = 3;
  const int IndividualAllocType_SUB_ALLOCATE = 1;
  const int IndividualAllocType_THIRD_PARTY_ALLOCATION = 2;
  const int GTBookingInst_BOOK_OUT_ALL_TRADES_ON_DAY_OF_EXECUTION = 0;
  const int GTBookingInst_ACCUMULATE_UNTIL_VERBALLY_NOTIFIED_OTHERWISE = 2;
  const int GTBookingInst_ACCUMULATE_EXECUTIONS_UNTIL_ORDER_IS_FILLED_OR_EXPIRES = 1;
  const int GTBookingInst_ACCUMULATE_UNTIL_VERBALLLY_NOTIFIED_OTHERWISE = 2;
  const int GTBookingInst_ACCUMULATE_EXECTUIONS_UNTIL_FORDER_IS_FILLED_OR_EXPIRES = 1;
  const int PutOrCall_PUT = 0;
  const int PutOrCall_CALL = 1;
  const char FundRenewWaiv_NO = 'N';
  const char FundRenewWaiv_YES = 'Y';
  const char ForexReq_NO = 'N';
  const char ForexReq_YES = 'Y';
  const int TickRuleType_TRADED_AS_A_SPREAD_LEG = 3;
  const int TickRuleType_REGULAR = 0;
  const int TickRuleType_VARIABLE = 1;
  const int TickRuleType_SETTLED_AS_A_SPREAD_LEG = 4;
  const int TickRuleType_FIXED = 2;
  const int DiscretionOffsetType_PRICE = 0;
  const int DiscretionOffsetType_PRICE_TIER = 3;
  const int DiscretionOffsetType_TICKS = 2;
  const int DiscretionOffsetType_BASIS_POINTS = 1;
  const int ConfirmTransType_REPLACE = 1;
  const int ConfirmTransType_NEW = 0;
  const int ConfirmTransType_CANCEL = 2;
  const int MDSecSizeType_CUSTOMER = 1;
  const int TradSesEvent_CHANGE_OF_TRADING_STATUS = 3;
  const int TradSesEvent_CHANGE_OF_TRADING_SESSION = 1;
  const int TradSesEvent_CHANGE_OF_TRADING_SUBSESSION = 2;
  const int TradSesEvent_TRADING_RESUMES = 0;
  const char DlvyInstType_SECURITIES = 'S';
  const char DlvyInstType_CASH = 'C';
  const char TradeCondition_IMPLIED_TRADE[] = "1";
  const char TradeCondition_OPENING_PRICE[] = "R";
  const char TradeCondition_PRIOR_REFERENCE_PRICE[] = "AK";
  const char TradeCondition_CANCEL_LAST_ETH[] = "l";
  const char TradeCondition_SELLER[] = "L";
  const char TradeCondition_DISTRIBUTION[] = "e";
  const char TradeCondition_NEXT_DAY_TRADE[] = "J";
  const char TradeCondition_STRADDLE_ETH[] = "AD";
  const char TradeCondition_SPREAD[] = "AA";
  const char TradeCondition_CROSSED_AO[] = "AO";
  const char TradeCondition_SOLD_LAST_SALE[] = "o";
  const char TradeCondition_OPENED_SALE_ETH[] = "r";
  const char TradeCondition_REOPEN_ETH[] = "x";
  const char TradeCondition_SOLD_LAST_SALE_ETH[] = "m";
  const char TradeCondition_STOPPED_SOLD_LAST[] = "AL";
  const char TradeCondition_TRADES_RESULTING_FROM_INTERMARKET_SWEEP[] = "Z";
  const char TradeCondition_FORM_T[] = "AR";
  const char TradeCondition_ADJUSTED[] = "y";
  const char TradeCondition_CANCEL_ETH[] = "i";
  const char TradeCondition_OUT_OF_SEQUENCE_ETH[] = "k";
  const char TradeCondition_COMBO_ETH[] = "AI";
  const char TradeCondition_CANCEL_ONLY_ETH[] = "t";
  const char TradeCondition_STRADDLE[] = "AC";
  const char TradeCondition_OUTSIDE_SPREAD[] = "AV";
  const char TradeCondition_BUNCHED_SALE[] = "f";
  const char TradeCondition_CANCEL_STOPPED[] = "h";
  const char TradeCondition_LATE_OPEN_ETH[] = "u";
  const char TradeCondition_OPENING_REOPENING_TRADE_DETAIL[] = "E";
  const char TradeCondition_CANCEL[] = "0";
  const char TradeCondition_COMBO[] = "AH";
  const char TradeCondition_OPENING[] = "E";
  const char TradeCondition_ACQUISITION[] = "c";
  const char TradeCondition_OPENED[] = "K";
  const char TradeCondition_CANCEL_ONLY[] = "s";
  const char TradeCondition_NEXT_DAY[] = "D";
  const char TradeCondition_BARGAIN_CONDITION[] = "S";
  const char TradeCondition_STOPPED[] = "AE";
  const char TradeCondition_CONVERTED_PRICE_INDICATOR[] = "T";
  const char TradeCondition_OFFICIAL_CLOSING_PRICE[] = "AJ";
  const char TradeCondition_ADJUSTED_ETH[] = "z";
  const char TradeCondition_RULE_155_TRADE[] = "H";
  const char TradeCondition_AUTOMATIC_EXECUTION[] = "AQ";
  const char TradeCondition_CROSSED_X[] = "X";
  const char TradeCondition_AUTO_EXECUTION_ETH[] = "v";
  const char TradeCondition_MULTILEG_TO_MULTILEG_TRADE[] = "4";
  const char TradeCondition_BASKET_INDEX[] = "AS";
  const char TradeCondition_TRADES_RESULTING_FROM_MANUAL_SLOW_QUOTE[] = "Y";
  const char TradeCondition_FINAL_PRICE_OF_SESSION[] = "V";
  const char TradeCondition_STOPPED_STOCK[] = "N";
  const char TradeCondition_OFFICAL_CLOSING_PRICE[] = "AN";
  const char TradeCondition_MULT_ASSET_CLASS_MULTILEG_TRADE[] = "3";
  const char TradeCondition_CASH[] = "A";
  const char TradeCondition_CANCEL_OPEN[] = "p";
  const char TradeCondition_REGULAR_ETH[] = "AG";
  const char TradeCondition_STOPPED_ETH[] = "AF";
  const char TradeCondition_VOLUME_ONLY[] = "a";
  const char TradeCondition_CANCEL_STOPPED_ETH[] = "j";
  const char TradeCondition_STOPPED_OUT_OF_SEQUENCE[] = "AM";
  const char TradeCondition_CASH_TRADE[] = "C";
  const char TradeCondition_SPLIT_TRADE[] = "g";
  const char TradeCondition_IMBALANCE_MORE_BUYERS[] = "P";
  const char TradeCondition_IMBALANCE_MORE_SELLERS[] = "Q";
  const char TradeCondition_INTRADAY_TRADE_DETAIL[] = "F";
  const char TradeCondition_RULE_127_TRADE[] = "G";
  const char TradeCondition_BUNCHED[] = "d";
  const char TradeCondition_REOPEN[] = "w";
  const char TradeCondition_EX_PIT[] = "W";
  const char TradeCondition_DIRECT_PLUS[] = "b";
  const char TradeCondition_CANCEL_LAST[] = "n";
  const char TradeCondition_AVERAGE_PRICE_TRADE[] = "B";
  const char TradeCondition_SOLD_LAST[] = "I";
  const char TradeCondition_MARKETPLACE_ENTERED_TRADE[] = "2";
  const char TradeCondition_SPREAD_ETH[] = "AB";
  const char TradeCondition_CANCEL_OPEN_ETH[] = "q";
  const char TradeCondition_EXCHANGE_LAST[] = "U";
  const char TradeCondition_FAST_MARKET[] = "AP";
  const char TradeCondition_BURST_BASKET[] = "AT";
  const char TradeCondition_SOLD[] = "M";
  const int PriceLimitType_PRICE = 0;
  const int PriceLimitType_TICKS = 1;
  const int PriceLimitType_PERCENTAGE = 2;
  const char CommType_PER_SHARE = '1';
  const char CommType_POINTS_PER_BOND_OR_CONTRACT_SUPPLY_CONTRACTMULTIPLIER = '6';
  const char CommType_ABSOLUTE = '3';
  const char CommType_PER_BOND = '6';
  const char CommType_PERCENTAGE = '2';
  const char CommType_PERCENTAGE_WAIVED_4 = '4';
  const char CommType_POINTS_PER_BOND_OR_CONTRACT = '6';
  const char CommType_PERCENTAGE_WAIVED_5 = '5';
  const char CommType_PER_UNIT = '1';
  const char CommType_PERCENT = '2';
  const char CommType_4 = '4';
  const char CommType_5 = '5';
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_NO_DISTRIB_INSTNS = 13;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_MAILING_DTLS = 7;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_NO_REG_DETAILS = 4;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_MAILING_INSTRUCTIONS = 8;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_TAX_EXEMPT_TYPE = 2;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_CASH_DISTRIB_AGENT_ACCT_NAME = 16;
  const int RegistRejReasonCode_INVALID_UNACEEPTABLE_INVESTOR_ID_SOURCE = 10;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_INVESTOR_ID_SOURCE = 10;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_DATE_OF_BIRTH = 11;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_MAILING_INST = 8;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_NO_REG_DETLS = 4;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_DISTRIB_PAYMENT_METHOD = 15;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_CASH_DISTRIB_AGENT_CODE = 17;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_REG_DETAILS = 6;
  const int RegistRejReasonCode_OTHER = 99;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_REG_DTLS = 6;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_ACCOUNT_TYPE = 1;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_MAILING_DETAILS = 7;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_INVESTOR_COUNTRY_OF_RESIDENCE = 12;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_DISTRIB_PERCENTAGE = 14;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_CASH_DISTRIB_AGENT_ACCT_NUM = 18;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_REG_SEQ_NO = 5;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_INVESTOR_ID = 9;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_OWNERSHIP_TYPE = 3;
  const int RegistRejReasonCode_INVALID_UNACCEPTABLE_NODISTRIBINSTNS = 13;
  const char FinancialStatus_BANKRUPT = '1';
  const char FinancialStatus_RESTRICTED = '3';
  const char FinancialStatus_PENDING_DELISTING = '2';
  const char LastFragment_NO = 'N';
  const char LastFragment_YES = 'Y';
  const char NotifyBrokerOfCredit_NO = 'N';
  const char NotifyBrokerOfCredit_YES = 'Y';
  const int PartySubIDType_DEPARTMENT = 24;
  const int PartySubIDType_FAX_NUMBER = 21;
  const int PartySubIDType_CASH_ACCOUNT_NUMBER = 15;
  const int PartySubIDType_REGISTERED_ADDRESS_12 = 12;
  const int PartySubIDType_CONTACT_NAME = 9;
  const int PartySubIDType_PERSON = 2;
  const int PartySubIDType_FIRM = 1;
  const int PartySubIDType_SECURITY_LOCATE_ID = 27;
  const int PartySubIDType_POSITION_ACCOUNT_TYPE = 26;
  const int PartySubIDType_CASH_ACCOUNT_NAME = 23;
  const int PartySubIDType_POSTAL_ADDRESS = 6;
  const int PartySubIDType_PROFESSIONAL_CLIENT = 30;
  const int PartySubIDType_LOCATION = 31;
  const int PartySubIDType_FUND_ACCOUNT_NAME = 19;
  const int PartySubIDType_REGISTRATION_NUMBER = 11;
  const int PartySubIDType_SYSTEM = 3;
  const int PartySubIDType_CSD_PARTICIPANT_MEMBER_CODE = 17;
  const int PartySubIDType_REGULATORY_STATUS = 13;
  const int PartySubIDType_CURRENCY_DELIVERY_IDENTIFIER = 33;
  const int PartySubIDType_TELEX_NUMBER = 20;
  const int PartySubIDType_REGISTERED_ADDRESS_18 = 18;
  const int PartySubIDType_BIC = 16;
  const int PartySubIDType_REGISTRATION_NAME = 14;
  const int PartySubIDType_EMAIL_ADDRESS = 8;
  const int PartySubIDType_LOCATION_DESK = 25;
  const int PartySubIDType_APPLICATION = 4;
  const int PartySubIDType_SECURITIES_ACCOUNT_NAME = 22;
  const int PartySubIDType_PHONE_NUMBER = 7;
  const int PartySubIDType_ELIGIBLE_COUNTERPARTY = 29;
  const int PartySubIDType_MARKET_MAKER = 28;
  const int PartySubIDType_EXECUTION_VENUE = 32;
  const int PartySubIDType_SECURITIES_ACCOUNT_NUMBER = 10;
  const int PartySubIDType_FULL_LEGAL_NAME_OF_FIRM = 5;
  const int AllocNoOrdersType_EXPLICIT_LIST_PROVIDED = 1;
  const int AllocNoOrdersType_NOT_SPECIFIED = 0;
  const int AllocLinkType_FX_SWAP = 1;
  const int AllocLinkType_F_X_NETTING = 0;
  const int AllocLinkType_FX_NETTING = 0;
  const int AllocLinkType_F_X_SWAP = 1;
  const int UnderlyingSettlementType_T_PLUS_1 = 2;
  const int UnderlyingSettlementType_T_PLUS_3 = 4;
  const int UnderlyingSettlementType_T_PLUS_4 = 5;
  const char DisplayMethod_NEW = '2';
  const char DisplayMethod_UNDISCLOSED = '4';
  const char DisplayMethod_RANDOM = '3';
  const char DisplayMethod_INITIAL = '1';
  const int CollStatus_PARTIALLY_ASSIGNED = 1;
  const int CollStatus_ASSIGNMENT_PROPOSED = 2;
  const int CollStatus_CHALLENGED = 4;
  const int CollStatus_ASSIGNED = 3;
  const int CollStatus_UNASSIGNED = 0;
  const int SideValueInd_SIDEVALUE_2 = 2;
  const int SideValueInd_SIDEVALUE1 = 1;
  const int SideValueInd_SIDE_VALUE_1 = 1;
  const int SideValueInd_SIDE_VALUE_2 = 2;
  const char MsgDirection_RECEIVE = 'R';
  const char MsgDirection_SEND = 'S';
  const char MDUpdateAction_DELETE = '2';
  const char MDUpdateAction_NEW = '0';
  const char MDUpdateAction_DELETE_THRU = '3';
  const char MDUpdateAction_DELETE_FROM = '4';
  const char MDUpdateAction_OVERLAY = '5';
  const char MDUpdateAction_CHANGE = '1';
  const char MatchStatus_UNCOMPARED_UNMATCHED_OR_UNAFFIRED = '1';
  const char MatchStatus_COMPARED_MATCHED_OR_AFFIRMED = '0';
  const char MatchStatus_ADVISORY_OR_ALERT = '2';
  const char MatchStatus_UNCOMPARED_UNMATCHED_OR_UNAFFIRMED = '1';
  const int RateSource_REUTERS = 1;
  const int RateSource_OTHER = 99;
  const int RateSource_BLOOMBERG = 0;
  const int RateSource_TELERATE = 2;
  const char AllocPositionEffect_CLOSE = 'C';
  const char AllocPositionEffect_FIFO = 'F';
  const char AllocPositionEffect_OPEN = 'O';
  const char AllocPositionEffect_ROLLED = 'R';
  const char PartyIDSource_US_EMPLOYER_OR_TAX_ID_NUMBER = '8';
  const char PartyIDSource_PROPRIETARY = 'D';
  const char PartyIDSource_AUSTRALIAN_TAX_FILE_NUMBER = 'A';
  const char PartyIDSource_GENERALLY_ACCEPTED_MARKET_PARTICIPANT_IDENTIFIER = 'C';
  const char PartyIDSource_AUSTRALIAN_BUSINESS_NUMBER = '9';
  const char PartyIDSource_US_EMPLOYER_IDENTIFICATION_NUMBER = '8';
  const char PartyIDSource_TAIWANESE_TRADING_ACCOUNT = '3';
  const char PartyIDSource_TAIWANESE_TRADING_ACCT = '3';
  const char PartyIDSource_MALAYSIAN_CENTRAL_DEPOSITORY = '4';
  const char PartyIDSource_US_SOCIAL_SECURITY_NUMBER = '7';
  const char PartyIDSource_UK_NATIONAL_INSURANCE_OR_PENSION_NUMBER = '6';
  const char PartyIDSource_CSD_PARTICIPANT_MEMBER_CODE = 'H';
  const char PartyIDSource_DIRECTED_BROKER_THREE_CHARACTER_ACRONYM_AS_DEFINED_IN_ISITC_ETC_BEST_PRACTICE_GUIDELINES_DOCUMENT = 'I';
  const char PartyIDSource_TAIWANESE_QUALIFIED_FOREIGN_INVESTOR_ID_QFII = '2';
  const char PartyIDSource_SETTLEMENT_ENTITY_LOCATION = 'F';
  const char PartyIDSource_PROPRIETARY_CUSTOM_CODE = 'D';
  const char PartyIDSource_BIC = 'B';
  const char PartyIDSource_CHINESE_INVESTOR_ID = '5';
  const char PartyIDSource_MIC = 'G';
  const char PartyIDSource_KOREAN_INVESTOR_ID = '1';
  const char PartyIDSource_ISO_COUNTRY_CODE = 'E';
  const char PartyIDSource_TAIWANESE_QUALIFIED_FOREIGN_INVESTOR_ID_QFII_FID = '2';
  const char PartyIDSource_CHINESE_B_SHARE = '5';
  const char ExchangeForPhysical_NO = 'N';
  const char ExchangeForPhysical_YES = 'Y';
  const int SecurityTradingEvent_CHANGE_OF_SECURITY_TRADING_STATUS = 6;
  const int SecurityTradingEvent_CHANGE_OF_TRADING_SESSION = 4;
  const int SecurityTradingEvent_CHANGE_OF_SECURITY_STATUS = 6;
  const int SecurityTradingEvent_PRICE_VOLATILITY_INTERRUPTION = 3;
  const int SecurityTradingEvent_CHANGE_OF_BOOK_TYPE = 7;
  const int SecurityTradingEvent_CHANGE_OF_TRADING_SUBSESSION = 5;
  const int SecurityTradingEvent_CHANGE_OF_MARKET_DEPTH = 8;
  const int SecurityTradingEvent_TRADING_RESUMES = 2;
  const int SecurityTradingEvent_ORDER_IMBALANCE_AUCTION_IS_EXTENDED = 1;
  const int CollAction_ADD = 1;
  const int CollAction_REMOVE = 2;
  const int CollAction_RETAIN = 0;
  const char PossDupFlag_NO = 'N';
  const char PossDupFlag_YES = 'Y';
  const int ListStatusType_ALL_DONE = 5;
  const int ListStatusType_TIMED = 3;
  const int ListStatusType_EXECSTARTED = 4;
  const int ListStatusType_RESPONSE = 2;
  const int ListStatusType_ALLDONE = 5;
  const int ListStatusType_ALERT = 6;
  const int ListStatusType_ACK = 1;
  const int ListStatusType_EXEC_STARTED = 4;
  const char GapFillFlag_NO = 'N';
  const char GapFillFlag_YES = 'Y';
  const char TradeHandlingInstr_AUTOMATED_FLOOR_ORDER_ROUTING = '4';
  const char TradeHandlingInstr_TWO_PARTY_REPORT = '1';
  const char TradeHandlingInstr_ONE_PARTY_REPORT_FOR_MATCHING = '2';
  const char TradeHandlingInstr_TRADE_CONFIRMATION = '0';
  const char TradeHandlingInstr_ONE_PARTY_REPORT_FOR_PASS_THROUGH = '3';
  const char TradeHandlingInstr_TWO_PARTY_REPORT_FOR_CLAIM = '5';
  const int TradSesMethod_ELECTRONIC = 1;
  const int TradSesMethod_TWO_PARTY = 3;
  const int TradSesMethod_OPEN_OUTCRY = 2;
  const char TradeType_AGENCY = 'A';
  const char TradeType_VWAP_GUARANTEE = 'G';
  const char TradeType_RISK_TRADE = 'R';
  const char TradeType_GUARANTEED_CLOSE = 'J';
  const int ComplexEventCondition_AND = 1;
  const int ComplexEventCondition_OR = 2;
  const char BenchmarkCurveName_SONIA[] = "SONIA";
  const char BenchmarkCurveName_MUNIAAA[] = "MuniAAA";
  const char BenchmarkCurveName_LIBID[] = "LIBID";
  const char BenchmarkCurveName_PFANDBRIEFE[] = "Pfandbriefe";
  const char BenchmarkCurveName_EUREPO[] = "EUREPO";
  const char BenchmarkCurveName_FUTURESWAP[] = "FutureSWAP";
  const char BenchmarkCurveName_TREASURY[] = "Treasury";
  const char BenchmarkCurveName_OTHER[] = "OTHER";
  const char BenchmarkCurveName_EURIBOR[] = "Euribor";
  const char BenchmarkCurveName_EONIA[] = "EONIA";
  const char BenchmarkCurveName_LIBOR[] = "LIBOR";
  const char BenchmarkCurveName_SWAP[] = "SWAP";
  const char CashMargin_MARGIN_CLOSE = '3';
  const char CashMargin_MARGIN_OPEN = '2';
  const char CashMargin_CASH = '1';
  const char SettlObligTransType_REPLACE = 'R';
  const char SettlObligTransType_NEW = 'N';
  const char SettlObligTransType_RESTATE = 'T';
  const char SettlObligTransType_CANCEL = 'C';
  const char DeskOrderHandlingInst_PEGGED[] = "PEG";
  const char DeskOrderHandlingInst_MARKET_ON_OPEN[] = "MOO";
  const char DeskOrderHandlingInst_SCALE[] = "SCL";
  const char DeskOrderHandlingInst_FILL_OR_KILL[] = "FOK";
  const char DeskOrderHandlingInst_ALL_OR_NONE[] = "AON";
  const char DeskOrderHandlingInst_NOT_HELD[] = "NH";
  const char DeskOrderHandlingInst_DIRECTED_ORDER[] = "DIR";
  const char DeskOrderHandlingInst_STOP_STOCK_TRANSACTION[] = "S.W";
  const char DeskOrderHandlingInst_OVER_THE_DAY[] = "OVD";
  const char DeskOrderHandlingInst_ADD_ON_ORDER[] = "ADD";
  const char DeskOrderHandlingInst_MARKET_AT_CLOSE[] = "MAC";
  const char DeskOrderHandlingInst_LIMIT_ON_OPEN[] = "LOO";
  const char DeskOrderHandlingInst_CASH_NOT_HELD[] = "CNH";
  const char DeskOrderHandlingInst_MARKET_ON_CLOSE[] = "MOC";
  const char DeskOrderHandlingInst_TIME_ORDER[] = "TMO";
  const char DeskOrderHandlingInst_LIMIT_ON_CLOSE[] = "LOC";
  const char DeskOrderHandlingInst_IMMEDIATE_OR_CANCEL[] = "IOC";
  const char DeskOrderHandlingInst_TRAILING_STOP[] = "TS";
  const char DeskOrderHandlingInst_WORK[] = "WRK";
  const char DeskOrderHandlingInst_RESERVE_SIZE_ORDER[] = "RSV";
  const char DeskOrderHandlingInst_MINIMUM_QUANTITY[] = "MQT";
  const char DeskOrderHandlingInst_MARKET_AT_OPEN[] = "MAO";
  const char DeskOrderHandlingInst_IMBALANCE_ONLY[] = "IO";
  const char DeskOrderHandlingInst_EXCHANGE_FOR_PHYSICAL_TRANSACTION[] = "E.W";
  const int PosTransType_POSITION_CHANGE_SUBMISSION_MARGIN_DISPOSITION = 4;
  const int PosTransType_DO_NOT_EXERCISE = 2;
  const int PosTransType_LARGE_TRADER_SUBMISSION = 6;
  const int PosTransType_EXERCISE = 1;
  const int PosTransType_PLEDGE = 5;
  const int PosTransType_POSITION_ADJUSTMENT = 3;
  const char Seniority_SUBORDINATED[] = "SB";
  const char Seniority_SENIOR_SECURED[] = "SD";
  const char Seniority_SENIOR[] = "SR";
  const char SettlCurrFxRateCalc_DIVIDE = 'D';
  const char SettlCurrFxRateCalc_MULTIPLY = 'M';
  const int PosMaintStatus_COMPLETED = 3;
  const int PosMaintStatus_ACCEPTED_WITH_WARNINGS = 1;
  const int PosMaintStatus_REJECTED = 2;
  const int PosMaintStatus_ACCEPTED = 0;
  const int PosMaintStatus_COMPLETED_WITH_WARNINGS = 4;
  const char Benchmark_6_MO_LIBOR = '9';
  const char Benchmark_OLD_5 = '3';
  const char Benchmark_OLD_30 = '7';
  const char Benchmark_3_MO_LIBOR = '8';
  const char Benchmark_OLD_10 = '5';
  const char Benchmark_CURVE = '1';
  const char Benchmark_30_YR = '6';
  const char Benchmark_10_YR = '4';
  const char Benchmark_5_YR = '2';
  const int MaturityMonthYearFormat_YEARMONTHWEEK = 2;
  const int MaturityMonthYearFormat_YEARMONTHDAY = 1;
  const int MaturityMonthYearFormat_YEARMONTH_ONLY = 0;
  const char LegalConfirm_NO = 'N';
  const char LegalConfirm_YES = 'Y';
  const int ApplReportType_REPORTS_THAT_THE_LAST_MESSAGE_HAS_BEEN_SENT_FOR_THE_APPLIDS_REFER_TO_REFAPPLLASTSEQNUM = 1;
  const int ApplReportType_APPLICATION_MESSAGE_RE_SEND_COMPLETED = 3;
  const int ApplReportType_RESET_APPLSEQNUM_TO_NEW_VALUE_SPECIFIED_IN_APPLNEWSEQNUM = 0;
  const int ApplReportType_HEARTBEAT_MESSAGE_INDICATING_THAT_APPLICATION_IDENTIFIED_BY_REFAPPLID = 2;
  const char ReportToExch_NO = 'N';
  const char ReportToExch_YES = 'Y';
  const int AllocRejCode_INCORRECT_ALLOCATED_QUANTITY = 8;
  const int AllocRejCode_UNKNOWN_ORDERID = 5;
  const int AllocRejCode_INCORRECT_AVERAGEG_PRICE = 2;
  const int AllocRejCode_WAREHOUSE_REQUEST_REJECTED = 13;
  const int AllocRejCode_OTHER_99 = 99;
  const int AllocRejCode_UNKNOWN_LISTID = 6;
  const int AllocRejCode_INCORRECT_QUANTITY = 1;
  const int AllocRejCode_INCORRECT_AVERAGE_PRICE = 2;
  const int AllocRejCode_UNKNOWN_ACCOUNT = 0;
  const int AllocRejCode_UNKNOWN_OR_STALE_EXECID = 10;
  const int AllocRejCode_MISMATCHED_DATA_VALUE = 11;
  const int AllocRejCode_OTHER = 7;
  const int AllocRejCode_OTHER_7 = 7;
  const int AllocRejCode_UNKNOWN_CLORDID = 12;
  const int AllocRejCode_MISMATCHED_DATA = 11;
  const int AllocRejCode_CALCULATION_DIFFERENCE = 9;
  const int AllocRejCode_COMMISSION_DIFFERENCE = 4;
  const int AllocRejCode_UNKNOWN_EXECUTING_BROKER_MNEMONIC = 3;
  const int RefOrdIDReason_GTC_FROM_PREVIOUS_DAY = 0;
  const int RefOrdIDReason_PARTIAL_FILL_REMAINING = 1;
  const int RefOrdIDReason_ORDER_CHANGED = 2;
  const char RefOrderIDSource_SECONDARYORDERID = '0';
  const char RefOrderIDSource_ORDERID = '1';
  const char RefOrderIDSource_MDENTRYID = '2';
  const char RefOrderIDSource_ORIGINAL_ORDER_ID = '4';
  const char RefOrderIDSource_MENTRYID = '2';
  const char RefOrderIDSource_QUOTEENTRYID = '3';
  const char RefOrderIDSource_QUOTENTRYID = '3';
  const char RefOrderIDSource_ORDEID = '1';
  const char RefOrderIDSource_SECONDARYORDEID = '0';
  const char LastCapacity_CROSS_AS_PRINCIPAL = '3';
  const char LastCapacity_PRINCIPAL = '4';
  const char LastCapacity_CROSS_AS_AGENT = '2';
  const char LastCapacity_AGENT = '1';
  const int InstrAttribType_INSTRUMENT_STRIKE_PRICE = 28;
  const int InstrAttribType_IN_DEFAULT = 15;
  const int InstrAttribType_PRE_REFUNDED = 14;
  const int InstrAttribType_SUBJECT_TO_ALTERNATIVE_MINIMUM_TAX = 19;
  const int InstrAttribType_ORIGINAL_ISSUE_DISCOUNT = 10;
  const int InstrAttribType_UNRATED = 16;
  const int InstrAttribType_WHEN_AND_IF_ISSUED = 9;
  const int InstrAttribType_CALLABLE_WITHOUT_NOTICE_BY_MAIL_TO_HOLDER_UNLESS_REGISTERED = 22;
  const int InstrAttribType_ESCROWED_TO_REDEMPTION_DATE_CALLABLE_SUPPLY_REDEMPTION_DATE_IN_THE_INSTRATTRIBVALUE = 13;
  const int InstrAttribType_STEPPED_COUPON = 7;
  const int InstrAttribType_INSTRUMENT_DENOMINATOR = 25;
  const int InstrAttribType_ESCROWED_TO_REDEMPTION_DATE = 13;
  const int InstrAttribType_TAXABLE = 17;
  const int InstrAttribType_INTEREST_BEARING = 3;
  const int InstrAttribType_CALLABLE_BELOW_MATURITY_VALUE = 21;
  const int InstrAttribType_PREREFUNDED = 14;
  const int InstrAttribType_CALLABLE_PUTTABLE = 11;
  const int InstrAttribType_COUPON_PERIOD = 8;
  const int InstrAttribType_INSTRUMENT_PRICE_PRECISION = 27;
  const int InstrAttribType_TRADEABLE_INDICATOR = 29;
  const int InstrAttribType_ORIGINAL_ISSUE_DISCOUNT_PRICE_SUPPLY_PRICE_IN_THE_INSTRATTRIBVALUE = 20;
  const int InstrAttribType_VARIABLE_RATE = 5;
  const int InstrAttribType_FLAT = 1;
  const int InstrAttribType_TRADE_TYPE_ELIGIBILITY_DETAILS_FOR_SECURITY = 24;
  const int InstrAttribType_INSTRUMENT_NUMERATOR = 26;
  const int InstrAttribType_TEXT_SUPPLY_THE_TEXT_OF_THE_ATTRIBUTE_OR_DISCLAIMER_IN_THE_INSTRATTRIBVALUE = 99;
  const int InstrAttribType_INDEXED = 18;
  const int InstrAttribType_ESCROWED_TO_MATURITY = 12;
  const int InstrAttribType_LESS_FEE_FOR_PUT = 6;
  const int InstrAttribType_ZERO_COUPON = 2;
  const int InstrAttribType_PRICE_TICK_RULES_FOR_SECURITY = 23;
  const int InstrAttribType_NO_PERIODIC_PAYMENTS = 4;
  const int Product_FINANCING = 13;
  const int Product_COMMODITY = 2;
  const int Product_EQUITY = 5;
  const int Product_CORPORATE = 3;
  const int Product_AGENCY = 1;
  const int Product_OTHER = 12;
  const int Product_MONEYMARKET = 9;
  const int Product_MORTGAGE = 10;
  const int Product_CURRENCY = 4;
  const int Product_INDEX = 7;
  const int Product_MUNICIPAL = 11;
  const int Product_LOAN = 8;
  const int Product_GOVERNMENT = 6;
  const int SecurityTradingStatus_FAST_MARKET = 23;
  const int SecurityTradingStatus_NO_OPEN_NO_RESUME = 4;
  const int SecurityTradingStatus_TRADING_HALT = 2;
  const int SecurityTradingStatus_NOT_AVAILABLE_FOR_TRADING = 18;
  const int SecurityTradingStatus_NO_OPEN = 4;
  const int SecurityTradingStatus_CROSS = 25;
  const int SecurityTradingStatus_RESUME = 3;
  const int SecurityTradingStatus_TRADE_DISSEMINATION_TIME = 16;
  const int SecurityTradingStatus_NO_MARKET_ON_CLOSE_IMBALANCE = 13;
  const int SecurityTradingStatus_POST_CLOSE = 26;
  const int SecurityTradingStatus_MARKET_ON_CLOSE_IMBALANCE_BUY = 9;
  const int SecurityTradingStatus_MARKET_IMBALANCE_SELL = 8;
  const int SecurityTradingStatus_OPENING_DELAY = 1;
  const int SecurityTradingStatus_NOT_TRADED_ON_THIS_MARKET = 19;
  const int SecurityTradingStatus_ITS_PRE_OPENING = 14;
  const int SecurityTradingStatus_PRE_CROSS = 24;
  const int SecurityTradingStatus_PRE_OPEN = 21;
  const int SecurityTradingStatus_MARKET_IMBALANCE_BUY = 7;
  const int SecurityTradingStatus_TRADING_RANGE_INDICATION = 6;
  const int SecurityTradingStatus_READY_TO_TRADE = 17;
  const int SecurityTradingStatus_NEW_PRICE_INDICATION = 15;
  const int SecurityTradingStatus_OPENING_ROTATION = 22;
  const int SecurityTradingStatus_PRICE_INDICATION = 5;
  const int SecurityTradingStatus_UNKNOWN_OR_INVALID = 20;
  const int SecurityTradingStatus_MARKET_ON_CLOSE_IMBALANCE_SELL = 10;
  const int SecurityTradingStatus_NO_MARKET_IMBALANCE = 12;
  const char Rule80A_TRANSACTIONS_FOR_THE_ACCOUNT_OF_A_NON_MEMBER_COMPETING_MARKET_MAKER = 'R';
  const char Rule80A_SPECIALIST_TRADES = 'S';
  const char Rule80A_PROGRAM_ORDER_INDEX_ARB_FOR_INDIVIDUAL_CUSTOMER = 'J';
  const char Rule80A_PROGRAM_ORDER_INDEX_ARB_FOR_MEMBER_FIRM_ORG = 'D';
  const char Rule80A_SHORT_EXEMPT_TRANSACTION_F = 'F';
  const char Rule80A_COMPETING_DEALER_TRADES_O = 'O';
  const char Rule80A_PROGRAM_ORDER_NON_INDEX_ARB_FOR_INDIVIDUAL_CUSTOMER = 'K';
  const char Rule80A_SHORT_EXEMPT_TRANSACTION_H = 'H';
  const char Rule80A_PRINCIPAL = 'P';
  const char Rule80A_COMPETING_DEALER_TRADES_R = 'R';
  const char Rule80A_INDIVIDUAL_INVESTOR_SINGLE_ORDER = 'I';
  const char Rule80A_PROPRIETARY_TRANSACTIONS_FOR_COMPETING_MARKET_MAKER_THAT_IS_AFFILIATED_WITH_THE_CLEARING_MEMBER = 'O';
  const char Rule80A_SHORT_EXEMPT_TRANSACTION_FOR_MEMBER_COMPETING_MARKET_MAKER_NOT_AFFILIATED_WITH_THE_FIRM_CLEARING_THE_TRADE = 'X';
  const char Rule80A_COMPETING_DEALER_TRADES_T = 'T';
  const char Rule80A_PROGRAM_ORDER_NON_INDEX_ARB_FOR_OTHER_MEMBER = 'N';
  const char Rule80A_SHORT_EXEMPT_TRANSACTION_FOR_NON_MEMBER_COMPETING_MARKET_MAKER = 'Z';
  const char Rule80A_PROGRAM_ORDER_NON_INDEX_ARB_FOR_OTHER_AGENCY = 'Y';
  const char Rule80A_ALL_OTHER_ORDERS_AS_AGENT_FOR_OTHER_MEMBER = 'W';
  const char Rule80A_PROGRAM_ORDER_NON_INDEX_ARB_FOR_MEMBER_FIRM_ORG = 'C';
  const char Rule80A_SHORT_EXEMPT_TRANSACTION_FOR_PRINCIPAL = 'E';
  const char Rule80A_SHORT_EXEMPT_TRANSACTION_B = 'B';
  const char Rule80A_SHORT_EXEMPT_TRANSACTION_FOR_MEMBER_COMPETING_MARKET_MAKER_AFFILIATED_WITH_THE_FIRM_CLEARING_THE_TRADE = 'L';
  const char Rule80A_AGENCY_SINGLE_ORDER = 'A';
  const char Rule80A_TRANSACTIONS_FOR_THE_ACCOUNT_OF_AN_UNAFFILIATED_MEMBERS_COMPETING_MARKET_MAKER = 'T';
  const char Rule80A_REGISTERED_EQUITY_MARKET_MAKER_TRADES = 'E';
  const char Rule80A_PROGRAM_ORDER_INDEX_ARB_FOR_OTHER_AGENCY = 'U';
  const char Rule80A_PROGRAM_ORDER_INDEX_ARB_FOR_OTHER_MEMBER = 'M';
  const char CorporateAction_MERGER_REORGANIZATION = 'M';
  const char CorporateAction_SYMBOL_CONVERSION = 'T';
  const char CorporateAction_NEW = 'D';
  const char CorporateAction_SUCCESSION_EVENT = 'W';
  const char CorporateAction_STOCK_DIVIDEND = 'G';
  const char CorporateAction_REVERSE_STOCK_SPLIT = 'I';
  const char CorporateAction_POSITION_CONSOLIDATION = 'K';
  const char CorporateAction_SPINOFF = 'P';
  const char CorporateAction_EX_INTEREST = 'E';
  const char CorporateAction_LIQUIDATION_REORGANIZATION = 'L';
  const char CorporateAction_CASH_DIVIDEND = 'F';
  const char CorporateAction_STANDARD_INTEGER_STOCK_SPLIT = 'J';
  const char CorporateAction_RIGHTS_OFFERING = 'N';
  const char CorporateAction_SHAREHOLDER_MEETING = 'O';
  const char CorporateAction_WARRANT = 'R';
  const char CorporateAction_EX_RIGHTS = 'C';
  const char CorporateAction_EX_DISTRIBUTION = 'B';
  const char CorporateAction_EX_DIVIDEND = 'A';
  const char CorporateAction_TENDER_OFFER = 'Q';
  const char CorporateAction_SPECIAL_ACTION = 'S';
  const char CorporateAction_NON_INTEGER_STOCK_SPLIT = 'H';
  const char CorporateAction_CUSIP = 'U';
  const char CorporateAction_LEAP_ROLLOVER = 'V';
  const int TerminationType_TERM = 2;
  const int TerminationType_FLEXIBLE = 3;
  const int TerminationType_OPEN = 4;
  const int TerminationType_OVERNIGHT = 1;
  const int PosMaintAction_NEW = 1;
  const int PosMaintAction_REPLACE = 2;
  const int PosMaintAction_REVERSE = 4;
  const int PosMaintAction_CANCEL_USED_TO_REMOVE_THE_OVERALL_TRANSACTION_OR_SPECIFIC_ADD_MESSAGES_BASED_ON_REFERENCE_ID = 3;
  const int PosMaintAction_REPLACE_USED_TO_OVERRIDE_THE_OVERALL_TRANSACTION_QUANTITY_OR_SPECIFIC_ADD_MESSAGES_BASED_ON_THE_REFERENCE_ID = 2;
  const int PosMaintAction_CANCEL = 3;
  const int PosMaintAction_NEW_USED_TO_INCREMENT_THE_OVERALL_TRANSACTION_QUANTITY = 1;
  const int ComplexEventPriceTimeType_SPECIFIED_DATE_TIME = 3;
  const int ComplexEventPriceTimeType_EXPIRATION = 1;
  const int ComplexEventPriceTimeType_IMMEDIATE = 2;
  const char UnderlyingFXRateCalc_DIVIDE = 'D';
  const char UnderlyingFXRateCalc_MULTIPLY = 'M';
  const char OddLot_NO = 'N';
  const char OddLot_YES = 'Y';
  const char BookingUnit_AGGREGATE_EXECUTIONS_FOR_THIS_SYMBOL_SIDE_AND_SETTLEMENT_DATE = '2';
  const char BookingUnit_AGGREGATE_PARTIAL_EXECUTIONS_ON_THIS_ORDER_AND_BOOK_ONE_TRADE_PER_ORDER = '1';
  const char BookingUnit_EACH_PARTIAL_EXECUTION_IS_A_BOOKABLE_UNIT = '0';
  const int AllocStatus_REJECTED_BY_INTERMEDIARY = 5;
  const int AllocStatus_BLOCK_LEVEL_REJECT = 1;
  const int AllocStatus_ACCOUNT_LEVEL_REJECT = 2;
  const int AllocStatus_INCOMPLETE = 4;
  const int AllocStatus_ALLOCATION_PENDING = 6;
  const int AllocStatus_REVERSED = 7;
  const int AllocStatus_RECEIVED = 3;
  const int AllocStatus_PARTIAL_ACCEPT = 2;
  const int AllocStatus_REJECTED = 1;
  const int AllocStatus_ACCEPTED = 0;
  const int IncTaxInd_NET = 1;
  const int IncTaxInd_GROSS = 2;
  const int PosReqStatus_COMPLETED = 0;
  const int PosReqStatus_REJECTED = 2;
  const int PosReqStatus_COMPLETED_WITH_WARNINGS = 1;
  const int PriorityIndicator_PRIORITY_UNCHANGED = 0;
  const int PriorityIndicator_LOST_PRIORITY_AS_RESULT_OF_ORDER_CHANGE = 1;
  const char MoneyLaunderingStatus_EXEMPT_BELOW_THE_LIMIT = '1';
  const char MoneyLaunderingStatus_EXEMPT_CLIENT_MONEY_TYPE_EXEMPTION = '2';
  const char MoneyLaunderingStatus_EXEMPT_AUTHORISED_CREDIT_OR_FINANCIAL_INSTITUTION = '3';
  const char MoneyLaunderingStatus_NOT_CHECKED = 'N';
  const char MoneyLaunderingStatus_PASSED = 'Y';
  const char MoneyLaunderingStatus_EXEMPT_1 = '1';
  const char MoneyLaunderingStatus_EXEMPT_2 = '2';
  const char MoneyLaunderingStatus_EXEMPT_3 = '3';
  const char LotType_ROUND_LOT_BASED_UPON_UNITOFMEASURE = '4';
  const char LotType_ROUND_LOT = '2';
  const char LotType_ODD_LOT = '1';
  const char LotType_BLOCK_LOT = '3';
  const char QuoteCondition_FLAT_CURVE[] = "7";
  const char QuoteCondition_REST_OF_BOOK_VWAP[] = "3";
  const char QuoteCondition_BETTER_PRICES_IN_CONDITIONAL_ORDERS[] = "4";
  const char QuoteCondition_TRADING_RANGE[] = "Q";
  const char QuoteCondition_HALT_ETH[] = "k";
  const char QuoteCondition_BID_OFFER_SPECIALIST[] = "r";
  const char QuoteCondition_CROSSED[] = "F";
  const char QuoteCondition_NO_OPEN[] = "b";
  const char QuoteCondition_HALT[] = "j";
  const char QuoteCondition_PREOPENING_SAM[] = "v";
  const char QuoteCondition_OPEN_SAM[] = "x";
  const char QuoteCondition_RESERVED_SAM[] = "0";
  const char QuoteCondition_OUTRIGHT_PRICE[] = "J";
  const char QuoteCondition_IMPLIED_PRICE[] = "K";
  const char QuoteCondition_DEPTH_ON_OFFER[] = "M";
  const char QuoteCondition_ADDITIONAL_INFO_DUE_TO_RELATED[] = "V";
  const char QuoteCondition_REGULAR_ETH[] = "c";
  const char QuoteCondition_ROTATION_ETH[] = "i";
  const char QuoteCondition_EXCHANGE_BEST[] = "C";
  const char QuoteCondition_DEPTH_ON_BID[] = "N";
  const char QuoteCondition_CLOSING[] = "O";
  const char QuoteCondition_VIEW_OF_COMMON[] = "X";
  const char QuoteCondition_FORBIDDEN_SAM[] = "t";
  const char QuoteCondition_LOCKED[] = "E";
  const char QuoteCondition_ORDER_INFLUX[] = "R";
  const char QuoteCondition_NEWS_PENDING[] = "T";
  const char QuoteCondition_RESUME[] = "W";
  const char QuoteCondition_TRADING_RESUME[] = "n";
  const char QuoteCondition_OUT_OF_SEQUENCE[] = "o";
  const char QuoteCondition_END_OF_DAY_SAM[] = "s";
  const char QuoteCondition_FROZEN_SAM[] = "u";
  const char QuoteCondition_OPENING_SAM[] = "w";
  const char QuoteCondition_MANUAL_SLOW_QUOTE[] = "L";
  const char QuoteCondition_NEWS_DISSEMINATION[] = "P";
  const char QuoteCondition_DUE_TO_RELATED[] = "S";
  const char QuoteCondition_VOLUME_ALERT[] = "Y";
  const char QuoteCondition_FAST_MARKET_ETH[] = "f ";
  const char QuoteCondition_INACTIVE_ETH[] = "g";
  const char QuoteCondition_DUE_TO_NEWS_DISSEMINATION[] = "l";
  const char QuoteCondition_SURVEILLANCE_SAM[] = "y";
  const char QuoteCondition_DEPTH[] = "G";
  const char QuoteCondition_OPEN[] = "A";
  const char QuoteCondition_AUTOMATIC_EXECUTION[] = "d";
  const char QuoteCondition_DUE_TO_NEWS_PENDING[] = "m";
  const char QuoteCondition_NO_ACTIVE_SAM[] = "1";
  const char QuoteCondition_OFFER_SPECIALIST[] = "q";
  const char QuoteCondition_SUSPENDED_SAM[] = "z";
  const char QuoteCondition_RESTRICTED[] = "2";
  const char QuoteCondition_NON_FIRM[] = "I";
  const char QuoteCondition_CLOSED_INACTIVE[] = "B";
  const char QuoteCondition_ADDITIONAL_INFO[] = "U";
  const char QuoteCondition_EQUIPMENT_CHANGEOVER[] = "a";
  const char QuoteCondition_FAST_TRADING[] = "H";
  const char QuoteCondition_FULL_CURVE[] = "6";
  const char QuoteCondition_MEDIAN_PRICE[] = "5";
  const char QuoteCondition_OPEN_ACTIVE[] = "A";
  const char QuoteCondition_ORDER_IMBALANCE[] = "Z";
  const char QuoteCondition_AUTOMATIC_EXECUTION_ETH[] = "e";
  const char QuoteCondition_ROTATION[] = "h";
  const char QuoteCondition_BID_SPECIALIST[] = "p";
  const char QuoteCondition_CONSOLIDATED_BEST[] = "D";
  const char QuoteCondition_CLOSED[] = "B";
  const char SettlLocation_EUROCLEAR[] = "EUR";
  const char SettlLocation_CEDEL[] = "CED";
  const char SettlLocation_PARTICIPANT_TRUST_COMPANY[] = "PTC";
  const char SettlLocation_PHYSICAL[] = "PNY";
  const char SettlLocation_DEPOSITORY_TRUST_COMPANY[] = "DTC";
  const char SettlLocation_LOCAL_MARKET_SETTLE_LOCATION[] = "ISO Country Code";
  const char SettlLocation_FEDERAL_BOOK_ENTRY[] = "FED";
  const int DiscretionScope_NATIONAL_EXCLUDING_LOCAL = 4;
  const int DiscretionScope_LOCAL = 1;
  const int DiscretionScope_GLOBAL = 3;
  const int DiscretionScope_NATIONAL = 2;
  const int OwnerType_PUBLIC_COMPANY = 2;
  const int OwnerType_INDIVIDUAL_TRUSTEE = 4;
  const int OwnerType_CUSTODIAN_UNDER_GIFTS_TO_MINORS_ACT = 7;
  const int OwnerType_INDIVIDUAL_INVESTOR = 1;
  const int OwnerType_COMPANY_TRUSTEE = 5;
  const int OwnerType_PRIVATE_COMPANY = 3;
  const int OwnerType_NETWORKING_SUB_ACCOUNT = 10;
  const int OwnerType_PENSION_PLAN = 6;
  const int OwnerType_TRUSTS = 8;
  const int OwnerType_FIDUCIARIES = 9;
  const int OwnerType_NON_PROFIT_ORGANIZATION = 11;
  const int OwnerType_CORPORATE_BODY = 12;
  const int OwnerType_NOMINEE = 13;
  const int ApplQueueResolution_END_SESSION = 3;
  const int ApplQueueResolution_QUEUE_FLUSHED = 1;
  const int ApplQueueResolution_OVERLAY_LAST = 2;
  const int ApplQueueResolution_NO_ACTION_TAKEN = 0;
  const int QuoteResponseLevel_SUMMARY_ACKNOWLEDGEMENT = 3;
  const int QuoteResponseLevel_ACKNOWLEDGE_ONLY_NEGATIVE_OR_ERRONEOUS_QUOTES = 1;
  const int QuoteResponseLevel_ACKNOWLEDGE_EACH_QUOTE_MESSAGE = 2;
  const int QuoteResponseLevel_ACKNOWLEDGE_EACH_QUOTE_MESSAGES = 2;
  const int QuoteResponseLevel_NO_ACKNOWLEDGEMENT = 0;
  const char ExecAckStatus_RECEIVED_NOT_YET_PROCESSED = '0';
  const char ExecAckStatus_DONT_KNOW = '2';
  const char ExecAckStatus_ACCEPTED = '1';
  const int NetGrossInd_NET = 1;
  const int NetGrossInd_GROSS = 2;
  const char CxlType_PARTIAL_CANCEL = 'P';
  const char CxlType_FULL_REMAINING_QUANTITY = 'F';
  const int DeskTypeSource_NASD_OATS = 1;
  const int DiscretionRoundDirection_MORE_AGGRESSIVE_ON_A_BUY_ORDER_ROUND_THE_PRICE_UP_ROUND_UP_TO_THE_NEAREST_TICK_ON_A_SELL_ROUND_DOWN_TO_THE_NEAREST_TICK = 1;
  const int DiscretionRoundDirection_MORE_AGGRESSIVE = 1;
  const int DiscretionRoundDirection_MORE_PASSIVE = 2;
  const int DiscretionRoundDirection_MORE_PASSIVE_ON_A_BUY_ORDER_ROUND_DOWN_TO_NEAREST_TICK_ON_A_SELL_ORDER_ROUND_UP_TO_NEAREST_TICK = 2;
  const int BidDescriptorType_COUNTRY = 2;
  const int BidDescriptorType_INDEX = 3;
  const int BidDescriptorType_SECTOR = 1;
  const int NetworkStatusResponseType_INCREMENTAL_UPDATE = 2;
  const int NetworkStatusResponseType_FULL = 1;
  const int QuoteType_INDICATIVE = 0;
  const int QuoteType_RESTRICTED_TRADEABLE = 2;
  const int QuoteType_TRADEABLE = 1;
  const int QuoteType_COUNTER = 3;
  const char DiscretionInst_RELATED_TO_MARKET_PRICE = '1';
  const char DiscretionInst_RELATED_TO_VWAP = '6';
  const char DiscretionInst_RELATED_TO_MIDPOINT_PRICE = '4';
  const char DiscretionInst_RELATED_TO_DISPLAYED_PRICE = '0';
  const char DiscretionInst_RELATED_TO_PRIMARY_PRICE = '2';
  const char DiscretionInst_AVERAGE_PRICE_GUARANTEE = '7';
  const char DiscretionInst_RELATED_TO_LAST_TRADE_PRICE = '5';
  const char DiscretionInst_RELATED_TO_LOCAL_PRIMARY_PRICE = '3';
  const int CrossPrioritization_BUY_SIDE_IS_PRIORITIZED = 1;
  const int CrossPrioritization_SELL_SIDE_IS_PRIORITIZED = 2;
  const int CrossPrioritization_NONE = 0;
  const int CrossPrioritization_SELLSIDE_PRIORITIZED = 2;
  const int CrossPrioritization_BUYSIDE_PRIORITIZED = 1;
  const char IOIOthSvc_AUTEX = 'A';
  const char IOIOthSvc_BRIDGE = 'B';
  const char MDReqRejReason_UNSUPPORTED_MDENTRYTYPE = '8';
  const char MDReqRejReason_INSUFFICIENT_CREDIT = 'D';
  const char MDReqRejReason_INSUFFICIENT_BANDWIDTH = '2';
  const char MDReqRejReason_UNSUPPORTED_SCOPE = 'A';
  const char MDReqRejReason_UNSUPPORTED_TRADINGSESSIONID = '9';
  const char MDReqRejReason_DUPLICATE_MDREQID = '1';
  const char MDReqRejReason_UNSUPPORTED_AGGREGATEDBOOK = '7';
  const char MDReqRejReason_UNSUPPORTED_MDUPDATETYPE = '6';
  const char MDReqRejReason_UNSUPPORTED_SUBSCRIPTIONREQUESTTYPE = '4';
  const char MDReqRejReason_UNKNOWN_SYMBOL = '0';
  const char MDReqRejReason_UNSUPPORTED_OPENCLOSESETTLEFLAG = 'B';
  const char MDReqRejReason_UNSUPPORTED_MARKETDEPTH = '5';
  const char MDReqRejReason_INSUFFICIENT_PERMISSIONS = '3';
  const char MDReqRejReason_UNSUPPORTED_MDIMPLICITDELETE = 'C';
  const int ApplReqType_REQUEST_FOR_THE_LAST_APPLLASTSEQNUM_PUBLISHED_FOR_THE_SPECIFIED_APPLICATIONS = 2;
  const int ApplReqType_UNSUBSCRIBE_TO_THE_SPECIFIED_APPLICATIONS = 4;
  const int ApplReqType_CANCEL_RETRANSMISSION_AND_UNSUBSCRIBE_TO_THE_SPECIFIED_APPLICATIONS = 6;
  const int ApplReqType_SUBSCRIPTION_TO_THE_SPECIFIED_APPLICATIONS = 1;
  const int ApplReqType_RETRANSMISSION_OF_APPLICATION_MESSAGES_FOR_THE_SPECIFIED_APPLICATIONS = 0;
  const int ApplReqType_REQUEST_VALID_SET_OF_APPLICATIONS = 3;
  const int ApplReqType_CANCEL_RETRANSMISSION = 5;
  const char AggressorIndicator_NO = 'N';
  const char AggressorIndicator_YES = 'Y';
  const int BusinessRejectReason_UNKNOWN_SECURITY = 2;
  const int BusinessRejectReason_APPLICATION_NOT_AVAILABLE = 4;
  const int BusinessRejectReason_INVALID_PRICE_INCREMENT = 18;
  const int BusinessRejectReason_DELIVERTO_FIRM_NOT_AVAILABLE_AT_THIS_TIME = 7;
  const int BusinessRejectReason_CONDITIONALLY_REQUIRED_FIELD_MISSING = 5;
  const int BusinessRejectReason_UNKNOWN_ID = 1;
  const int BusinessRejectReason_OTHER = 0;
  const int BusinessRejectReason_UNSUPPORTED_MESSAGE_TYPE = 3;
  const int BusinessRejectReason_UNKNOWN_MESSAGE_TYPE = 3;
  const int BusinessRejectReason_NOT_AUTHORIZED = 6;
  const int BusinessRejectReason_UNKOWN_ID = 1;
  const int BookingType_REGULAR_BOOKING = 0;
  const int BookingType_CFD = 1;
  const int BookingType_TOTAL_RETURN_SWAP = 2;
  }
  #endif //FIX_VALUES_H
