/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.FileLog;
import quickfix.Log;
import quickfix.LogFactory;
import quickfix.RuntimeError;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class FileLogFactory
implements LogFactory {
    public static final String SETTING_FILE_LOG_PATH = "FileLogPath";
    public static final String SETTING_INCLUDE_MILLIS_IN_TIMESTAMP = "FileIncludeMilliseconds";
    public static final String SETTING_INCLUDE_TIMESTAMP_FOR_MESSAGES = "FileIncludeTimeStampForMessages";
    public static final String SETTING_LOG_HEARTBEATS = "FileLogHeartbeats";
    private SessionSettings settings;

    public FileLogFactory(SessionSettings settings) {
        this.settings = settings;
    }

    public Log create(SessionID sessionID) {
        try {
            boolean includeMillis = false;
            if (this.settings.isSetting(sessionID, SETTING_INCLUDE_MILLIS_IN_TIMESTAMP)) {
                includeMillis = this.settings.getBool(sessionID, SETTING_INCLUDE_MILLIS_IN_TIMESTAMP);
            }
            boolean includeTimestampInMessages = false;
            if (this.settings.isSetting(sessionID, SETTING_INCLUDE_TIMESTAMP_FOR_MESSAGES)) {
                includeTimestampInMessages = this.settings.getBool(sessionID, SETTING_INCLUDE_TIMESTAMP_FOR_MESSAGES);
            }
            boolean logHeartbeats = true;
            if (this.settings.isSetting(sessionID, SETTING_LOG_HEARTBEATS)) {
                logHeartbeats = this.settings.getBool(sessionID, SETTING_LOG_HEARTBEATS);
            }
            return new FileLog(this.settings.getString(sessionID, SETTING_FILE_LOG_PATH), sessionID, includeMillis, includeTimestampInMessages, logHeartbeats);
        }
        catch (Exception e) {
            throw new RuntimeError(e);
        }
    }

    public Log create() {
        throw new UnsupportedOperationException();
    }
}

