/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.net.SocketAddress;
import java.util.Set;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.support.IoServiceListenerSupport;

public abstract class BaseIoService
implements IoService {
    private IoFilterChainBuilder filterChainBuilder = new DefaultIoFilterChainBuilder();
    private final IoServiceListenerSupport listeners = new IoServiceListenerSupport();

    protected BaseIoService() {
    }

    public IoFilterChainBuilder getFilterChainBuilder() {
        return this.filterChainBuilder;
    }

    public void setFilterChainBuilder(IoFilterChainBuilder builder) {
        if (builder == null) {
            builder = new DefaultIoFilterChainBuilder();
        }
        this.filterChainBuilder = builder;
    }

    public DefaultIoFilterChainBuilder getFilterChain() {
        if (this.filterChainBuilder instanceof DefaultIoFilterChainBuilder) {
            return (DefaultIoFilterChainBuilder)this.filterChainBuilder;
        }
        throw new IllegalStateException("Current filter chain builder is not a DefaultIoFilterChainBuilder.");
    }

    public void addListener(IoServiceListener listener) {
        this.getListeners().add(listener);
    }

    public void removeListener(IoServiceListener listener) {
        this.getListeners().remove(listener);
    }

    public Set getManagedServiceAddresses() {
        return this.getListeners().getManagedServiceAddresses();
    }

    public Set getManagedSessions(SocketAddress serviceAddress) {
        return this.getListeners().getManagedSessions(serviceAddress);
    }

    public boolean isManaged(SocketAddress serviceAddress) {
        return this.getListeners().isManaged(serviceAddress);
    }

    protected IoServiceListenerSupport getListeners() {
        return this.listeners;
    }
}

