/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoSession;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.Executors;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.ConfigError;
import quickfix.FieldConvertError;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.field.converter.IntConverter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionConnector {
    public static final String QF_SESSION = "QF_SESSION";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<SessionID, Session> sessions;
    private final SessionSettings settings;
    private final SessionFactory sessionFactory;
    private static final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new QFTimerThreadFactory());
    private ScheduledFuture<?> sessionTimerFuture;
    private IoFilterChainBuilder ioFilterChainBuilder;

    public SessionConnector(SessionSettings settings, SessionFactory sessionFactory) throws ConfigError {
        this.settings = settings;
        this.sessionFactory = sessionFactory;
        if (settings == null) {
            throw new ConfigError("no settings");
        }
    }

    protected void setSessions(Map<SessionID, Session> sessions) {
        this.sessions = sessions;
    }

    public List<Session> getManagedSessions() {
        return new ArrayList<Session>(this.sessions.values());
    }

    protected Map<SessionID, Session> getSessionMap() {
        return Collections.unmodifiableMap(this.sessions);
    }

    public ArrayList<SessionID> getSessions() {
        return new ArrayList<SessionID>(this.sessions.keySet());
    }

    public SessionSettings getSettings() {
        return this.settings;
    }

    protected Session createSession(SessionID sessionID) throws ConfigError {
        return this.sessionFactory.create(sessionID, this.settings);
    }

    protected int getIntSetting(String key) throws ConfigError {
        try {
            return IntConverter.convert(this.settings.getString(key));
        }
        catch (FieldConvertError e) {
            throw (ConfigError)new ConfigError(e.getMessage()).fillInStackTrace();
        }
    }

    public boolean isLoggedOn() {
        return !this.getLoggedOnSessions().isEmpty();
    }

    private Set<Session> getLoggedOnSessions() {
        HashSet<Session> loggedOnSessions = new HashSet<Session>(this.sessions.size());
        for (Session session : this.sessions.values()) {
            if (!session.isLoggedOn()) continue;
            loggedOnSessions.add(session);
        }
        return loggedOnSessions;
    }

    protected void logoutAllSessions(boolean forceDisconnect) {
        this.log.info("Logging out all sessions");
        if (this.sessions == null) {
            this.log.error("Attempt to logout all sessions before intialization is complete.");
            return;
        }
        for (Session session : this.sessions.values()) {
            try {
                session.logout();
            }
            catch (Throwable e) {
                this.logError(session.getSessionID(), null, "Error during logout", e);
            }
        }
        if (forceDisconnect && this.isLoggedOn()) {
            for (Session session : this.sessions.values()) {
                try {
                    if (!session.isLoggedOn()) continue;
                    session.getLog().onEvent("Forcibly disconnecting session");
                    session.disconnect();
                }
                catch (Throwable e) {
                    this.logError(session.getSessionID(), null, "Error during disconnect", e);
                }
            }
        }
        if (!forceDisconnect) {
            this.waitForLogout();
        }
    }

    protected void waitForLogout() {
        Set<Session> loggedOnSessions = this.getLoggedOnSessions();
        long start = System.currentTimeMillis();
        while (!loggedOnSessions.isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            long elapsed = System.currentTimeMillis() - start;
            Iterator<Session> sessionItr = loggedOnSessions.iterator();
            while (sessionItr.hasNext()) {
                Session session = sessionItr.next();
                if (elapsed < (long)session.getLogoutTimeout() * 1000L) continue;
                try {
                    session.disconnect();
                }
                catch (IOException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
                sessionItr.remove();
            }
            if (elapsed <= 60000L) continue;
            this.log.warn("Stopping session logout wait after 1 minute");
            break;
        }
    }

    protected void logError(SessionID sessionID, IoSession protocolSession, String message, Throwable t) {
        this.log.error(new StringBuffer().append(message).append(this.getLogSuffix(sessionID, protocolSession)).toString(), t);
    }

    private String getLogSuffix(SessionID sessionID, IoSession protocolSession) {
        String suffix = ":";
        if (sessionID != null) {
            suffix = new StringBuffer().append(suffix).append("sessionID=").append(sessionID.toString()).append(";").toString();
        }
        if (protocolSession != null) {
            suffix = new StringBuffer().append(suffix).append("address=").append(protocolSession.getRemoteAddress()).toString();
        }
        return suffix;
    }

    protected void startSessionTimer() {
        this.sessionTimerFuture = scheduledExecutorService.scheduleAtFixedRate(new SessionTimerTask(), 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    protected void stopSessionTimer() {
        if (this.sessionTimerFuture != null) {
            this.sessionTimerFuture.cancel(false);
        }
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return scheduledExecutorService;
    }

    public void setIoFilterChainBuilder(IoFilterChainBuilder ioFilterChainBuilder) {
        this.ioFilterChainBuilder = ioFilterChainBuilder;
    }

    protected IoFilterChainBuilder getIoFilterChainBuilder() {
        return this.ioFilterChainBuilder;
    }

    private static class QFTimerThreadFactory
    implements ThreadFactory {
        private QFTimerThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "QFJ Timer");
            thread.setDaemon(true);
            return thread;
        }
    }

    private class SessionTimerTask
    implements Runnable {
        private SessionTimerTask() {
        }

        public void run() {
            try {
                Iterator sessionItr = SessionConnector.this.sessions.values().iterator();
                while (sessionItr.hasNext()) {
                    Session session = (Session)sessionItr.next();
                    try {
                        session.next();
                    }
                    catch (IOException e) {
                        SessionConnector.this.logError(session.getSessionID(), null, "Error in session timer processing", e);
                    }
                }
            }
            catch (Throwable e) {
                SessionConnector.this.log.error("Error during timer processing", e);
            }
        }
    }
}

